/*********************************************************************
 *     load.c - loads a dsp microcode binary file into the emu10k1 dsp
 *              processor
 *      Copyright (C) 2000 Rui Sousa 
 ********************************************************************* 
 *     This program is free software; you can redistribute it and/or 
 *     modify it under the terms of the GNU General Public License as 
 *     published by the Free Software Foundation; either version 2 of 
 *     the License, or (at your option) any later version. 
 * 
 *     This program is distributed in the hope that it will be useful, 
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of 
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
 *     GNU General Public License for more details. 
 * 
 *     You should have received a copy of the GNU General Public 
 *     License along with this program; if not, write to the Free 
 *     Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, 
 *     USA. 
 ********************************************************************* 
*/

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/ioctl.h>
#include <sys/soundcard.h>
#include <fcntl.h>

int main(int argc, char **argv)
{
	copr_buffer buf;
	int audio_fd;
	FILE *fp;
	int i;

	if (argc < 2) {
		fprintf(stderr, "usage:\n    load dsp_code.bin\n");
		exit(EXIT_FAILURE);
	}

	if ((audio_fd = open("/dev/dsp", O_WRONLY, 0)) == -1) {
		perror("open /dev/dsp");
		exit(EXIT_FAILURE);
	}

	if ((fp = fopen(argv[1], "r")) == NULL) {
		perror(argv[1]);
		exit(EXIT_FAILURE);
	}

	buf.command = 2;
	buf.offs = 0x400;
	buf.len = 0x200;

	for (i = 0; i < 4 * buf.len; i++)
		buf.data[i] = getc(fp);

#ifdef DEBUG
	for (i = 0; i < buf.len; i++) {
		printf("0x%03x   0x%08x\n", buf.offs + i,
		       ((__u32 *) buf.data)[i]);
	}
#endif

	if (ioctl(audio_fd, SNDCTL_COPR_LOAD, &buf) == -1)
		perror("SNDCTL_COPR_LOAD");

	buf.offs = 0x600;
	buf.len = 0x200;

	for (i = 0; i < 4 * buf.len; i++)
		buf.data[i] = getc(fp);

#ifdef DEBUG
	for (i = 0; i < buf.len; i++) {
		printf("0x%03x   0x%08x\n", buf.offs + i,
		       ((__u32 *) buf.data)[i]);
	}
#endif

	if (ioctl(audio_fd, SNDCTL_COPR_LOAD, &buf) == -1)
		perror("SNDCTL_COPR_LOAD");

	fclose(fp);

	close(audio_fd);

	return 0;
}
