// TimeValidator: Control behavior of QLineEdit requesting time value (limit)

#include "TimeValidator.moc"
#include <ctype.h>
#include <qstring.h>

TimeValidator::TimeValidator(QLineEdit *parent, const char * name):QValidator(parent,name)
{
}
TimeValidator::~TimeValidator()
{
}
QValidator::State TimeValidator::validate(QString &input, int &pos) const
{
	QChar c;
	for(unsigned int i = 0; i < input.length();i++) {
		c=input.mid(i,1).latin1()[0];
		if(!isdigit(c) && c!='-')
			return QValidator::Invalid;
	}
	if(input.find('-') > 4) // - has to be at pos. 5 or lower (backspace editing must work)
		return QValidator::Invalid;
	if(pos==4 && input.length()==4 && !input.find('-')) { // Add the - automatically...
		input+="-";
		pos=5;
	}
	if(input.contains('-') == 1) // we want exactly one -
		return QValidator::Invalid;
	if(input.length()!=9 || input[4]!='-' || input.isEmpty()) // Working time = xxxx-xxxx or empty
		return QValidator::Acceptable;
	return QValidator::Valid;
}
void TimeValidator::fixup(QString &)
{
	// Not yet implemented...
}
