/*****************************************************************

Copyright (c) 1996-2000 the kicker authors. See file AUTHORS.

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

******************************************************************/

#include <qfile.h>
#include <qtimer.h>

#include <kpanelapplet.h>
#include <kpanelextension.h>
#include <klibloader.h>
#include <kdebug.h>
#include <kapplication.h>

#include "appletinfo.h"

#include "pluginloader.h"
#include "pluginloader.moc"

PluginLoader* PluginLoader::pluginLoader()
{
    static PluginLoader pluginLoader;
    return &pluginLoader;
}

PluginLoader::PluginLoader()
{
    _dict.setAutoDelete( true );
}

PluginLoader::~PluginLoader()
{
    QPtrDictIterator<AppletInfo> it(_dict);
    for (; it.current(); ++it )
        disconnect( static_cast<QObject *>( it.currentKey() ), SIGNAL( destroyed( QObject* ) ),
                    this, SLOT( slotPluginDestroyed( QObject* ) ) );
}

KPanelApplet* PluginLoader::loadApplet(
    const AppletInfo& info, QWidget* parent )
{
    KLibLoader* loader = KLibLoader::self();
    KLibrary* lib = loader->library( QFile::encodeName(info.library()) );

    if( !lib ) {
        kdWarning() << "cannot open extension: " << info.library()
                    << " because of " << loader->lastErrorMessage() << endl;
        return 0;
    }

    KPanelApplet* (*init_ptr)(QWidget *, const QString&);
    init_ptr = (KPanelApplet* (*)(QWidget *, const QString&))lib->symbol( "init" );

    if(!init_ptr){
        kdWarning() << info.library() << " is not a kicker extension!" << endl;
        loader->unloadLibrary( QFile::encodeName(info.library()) );
        return 0;
    }

    KPanelApplet* applet = init_ptr( parent, info.configFile() );

    if( applet ) {
        _dict.insert( applet, new AppletInfo( info ) );
        connect( applet, SIGNAL( destroyed( QObject* ) ),
                 SLOT( slotPluginDestroyed( QObject* ) ) );
    }

    return applet;
}

KPanelExtension* PluginLoader::loadExtension(
    const AppletInfo& info, QWidget* parent )
{
    KLibLoader* loader = KLibLoader::self();
    KLibrary* lib = loader->library( QFile::encodeName(info.library()) );

    if( !lib ) {
        kdWarning() << "cannot open extension: " << info.library()
                    << " because of " << loader->lastErrorMessage() << endl;
        return 0;
    }

    KPanelExtension* (*init_ptr)(QWidget *, const QString&);
    init_ptr = (KPanelExtension* (*)(QWidget *, const QString&))lib->symbol( "init" );

    if(!init_ptr){
        kdWarning() << info.library() << " is not a kicker extension!" << endl;
        loader->unloadLibrary( QFile::encodeName(info.library()) );
        return 0;
    }

    KPanelExtension* extension = init_ptr( parent, info.configFile() );

    if( extension ) {
        _dict.insert( extension, new AppletInfo( info ) );
        connect( extension, SIGNAL( destroyed( QObject* ) ),
                 SLOT( slotPluginDestroyed( QObject* ) ) );
    }

    return extension;
}

bool PluginLoader::hasInstance( const AppletInfo& info ) const
{
    QPtrDictIterator<AppletInfo> it(_dict);
    for( ; it.current(); ++it ) {
         if( it.current()->library() == info.library() )
             return true;
    }
    return false;
}

void PluginLoader::slotPluginDestroyed( QObject* object )
{
    AppletInfo *info = _dict.take( object );
    if ( !info )
        return;

    LibUnloader::unload( info->library() );
    delete info;
}

LibUnloader::LibUnloader( const QString &libName, QObject *parent )
    : QObject( parent ), _libName( libName )
{
    QTimer::singleShot( 0, this, SLOT( unload() ) );
}

void LibUnloader::unload( const QString &libName )
{
    (void)new LibUnloader( libName, kapp );
}

void LibUnloader::unload()
{
    KLibLoader::self()->unloadLibrary( QFile::encodeName( _libName ) );
    deleteLater();
}

