/*****************************************************************

Copyright (c) 1996-2000 the kicker authors. See file AUTHORS.

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

******************************************************************/

#include "customSize_dlg.h"

#include <klocale.h>
#include <knuminput.h>
#include <qgroupbox.h>
#include <qlabel.h>
#include <qlayout.h>

customSizeDialog::customSizeDialog(QWidget* parent, const char* name)
    : KDialogBase(KDialogBase::Plain, i18n("Custom Panel Size"),
                  KDialogBase::Ok | KDialogBase::Apply | KDialogBase::Cancel,
                  KDialogBase::Ok, parent, name)
{
    QFrame* page = plainPage();
    QVBoxLayout* topLayout = new QVBoxLayout(page);

    QGroupBox* groupBox = new QGroupBox(page);
    groupBox->setTitle(i18n("Custom Panel Size"));
    groupBox->setColumnLayout(0, Qt::Vertical);
    groupBox->layout()->setSpacing(KDialog::spacingHint());
    groupBox->layout()->setMargin(KDialog::marginHint());
    QGridLayout* layout = new QGridLayout(groupBox->layout());
    layout->setAlignment( Qt::AlignTop );

    QLabel* label = new QLabel(groupBox);
    label->setText(i18n( "<qt>Set the size (in pixels) that you would like the panel to be below.<br> \n"
"<p><b>Tip:</b> You can click and drag the edge of the panel to freely resize it later.</qt>" ));
    label->setAlignment(int(QLabel::WordBreak | QLabel::AlignVCenter));

    layout->addMultiCellWidget(label, 0, 0, 0, 2);

    sizeInput = new KIntNumInput(groupBox);
    sizeInput->setSuffix(i18n(" pixels"));
    layout->addWidget(sizeInput, 2, 1);

    QSpacerItem* spacer = new QSpacerItem(0, 0, QSizePolicy::Expanding, QSizePolicy::Minimum);
    layout->addItem(spacer, 2, 2);

    label = new QLabel(groupBox);
    label->setText(i18n("&Size:"));
    label->setBuddy(sizeInput);

    layout->addWidget(label, 2, 0);
    spacer = new QSpacerItem(20, 20, QSizePolicy::Minimum, QSizePolicy::Fixed);
    layout->addItem(spacer, 1, 1);

    topLayout->addWidget(groupBox);

    setMinMax();
    setCurrentSize();
}

customSizeDialog::~customSizeDialog()
{
}

void customSizeDialog::setMinMax(int minSize, int maxSize)
{
    sizeInput->setRange(minSize, maxSize, (maxSize - minSize) / 6, true);
}

void customSizeDialog::setCurrentSize(int currentSize)
{
    sizeInput->setValue(currentSize);
}

int customSizeDialog::size()
{
    return sizeInput->value();
}

void customSizeDialog::slotOk() 
{
    slotApply();
    KDialogBase::slotOk();
}

void customSizeDialog::slotApply()
{
    emit newCustomSize(size());
}

#include "customSize_dlg.moc"

