/***************************************************************************
                            KDesktopFile.h -  description
                             -------------------
    begin                : Fri Mar  8 13:55:08 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Mar  8 13:55:08 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KDESKTOPFILE_H
#define KDESKTOPFILE_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <kdeobjc/KConfig.h>

/**
 
 KDE Desktop File Management.

 @author Pietro Iglio <iglio@kde.org>

 @version $Id: KDesktopFile.h,v 1.3 2002/03/15 02:12:19 rdale Exp $

 @short KDE Desktop File Management class.
*/
@interface KDesktopFile : KConfig 

/** 
 Constructs a KDesktopFile object and make it either read-write
 or read-only.

*/
- initWithText: (NSString *)fileName readOnly: (BOOL)readOnly resType: (NSString *)resType;
- initWithText: (NSString *)fileName ;

/** 
 Destructs the KDesktopFile object.

 Writes back any dirty configuration entries.
   
*/
- (void) dealloc;

/** 
 Returns the value of the "Type=" entry.
   
*/
- (NSString *) readType;

/** 
 Returns the value of the "Icon=" entry.
   
*/
- (NSString *) readIcon;

/** 
 Returns the value of the "Name=" entry.
   
*/
- (NSString *) readName;

/** 
 Returns the value of the "Comment=" entry.
   
*/
- (NSString *) readComment;

/** 
 Returns the value of the "Path=" entry.

   
*/
- (NSString *) readPath;

/** 
 Returns the value of the "Dev=" entry.
   
*/
- (NSString *) readDevice;

/** 
 Returns the value of the "URL=" entry.
   
*/
- (NSString *) readURL;

/** 
 Returns a list of the "Actions=" entries.
   
*/
- (NSArray *) readActions;

/** 
 Sets the desktop action group.
   
*/
- setActionGroup: (NSString *)group;

/** 
 Returns true if the action group exists, false otherwise
   
*/
- (BOOL) hasActionGroup: (NSString *)group;

/** 
 Checks whether there is a "Type=Link" entry.

 The link points to the "URL=" entry.
   
*/
- (BOOL) hasLinkType;

/** 
 Checks whether there is an entry "Type=Application".
   
*/
- (BOOL) hasApplicationType;

/** 
 Checks whether there is an entry "Type=MimeType".
   
*/
- (BOOL) hasMimeTypeType;

/** 
 Checks whether there is an entry "Type=FSDev".
   
*/
- (BOOL) hasDeviceType;

/** 
 Checks whether the TryExec field contains a binary
 which is found on the local system.
   
*/
- (BOOL) tryExec;

/** 

*/
- (NSString *) fileName;

/** 

*/
- (NSString *) resource;
- (NSArray *) sortOrder;

/** 
 Checks whether this is really a desktop file.

 The check is performed looking at the file extension (the file is not
 opened).
 Currently, valid extensions are ".kdelnk" and ".desktop".

*/
+ (BOOL) isDesktopFile: (NSString *)path;
@end

/** Override these methods in subclasses of KDesktopFile to customise event handling behaviour */
@protocol KDesktopFileEventHandling
- childEvent:(QChildEvent*) arg1;
- customEvent:(QCustomEvent*) arg1;
- timerEvent:(QTimerEvent*) arg1;
@end


#endif
