/***************************************************************************
                            KListViewItem.h -  description
                             -------------------
    begin                : Fri Mar  8 13:55:08 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Mar  8 13:55:08 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KLISTVIEWITEM_H
#define KLISTVIEWITEM_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <qtobjc/QListViewItem.h>

/**

 A listview item with support for alternate background colours. It is
 a drop-in replacement for @ref QListViewItem

 @short listview item with alternate background colour support.
*/
@interface KListViewItem : QListViewItem 

/** 
 constructors. The semantics remain as in @ref QListViewItem.
 Although they accept a @ref QListViewItem as parent, please
 don't mix KListViewItem (or subclasses) with QListViewItem
 (or subclasses).
   
*/
- initWithListView: (QListView *)parent;
- initWithListViewItem: (QListViewItem *)parent;
- initWithListView: (QListView *)parent after: (QListViewItem *)after;
- initWithListViewItem: (QListViewItem *)parent after: (QListViewItem *)after;
- initWithListView: (QListView *)parent string: (NSString *)arg1 string: (NSString *)arg2 string: (NSString *)arg3 string: (NSString *)arg4 string: (NSString *)arg5 string: (NSString *)arg6 string: (NSString *)arg7 string: (NSString *)arg8;
- initWithListView: (QListView *)parent string: (NSString *)arg1 ;
- initWithListViewItem: (QListViewItem *)parent string: (NSString *)arg1 string: (NSString *)arg2 string: (NSString *)arg3 string: (NSString *)arg4 string: (NSString *)arg5 string: (NSString *)arg6 string: (NSString *)arg7 string: (NSString *)arg8;
- initWithListViewItem: (QListViewItem *)parent string: (NSString *)arg1 ;
- initWithListView: (QListView *)parent after: (QListViewItem *)after string: (NSString *)arg1 string: (NSString *)arg2 string: (NSString *)arg3 string: (NSString *)arg4 string: (NSString *)arg5 string: (NSString *)arg6 string: (NSString *)arg7 string: (NSString *)arg8;
- initWithListView: (QListView *)parent after: (QListViewItem *)after string: (NSString *)arg1 ;
- initWithListViewItem: (QListViewItem *)parent after: (QListViewItem *)after string: (NSString *)arg1 string: (NSString *)arg2 string: (NSString *)arg3 string: (NSString *)arg4 string: (NSString *)arg5 string: (NSString *)arg6 string: (NSString *)arg7 string: (NSString *)arg8;
- initWithListViewItem: (QListViewItem *)parent after: (QListViewItem *)after string: (NSString *)arg1 ;
- (void) dealloc;

/** 
 returns the background colour for this item
   
*/
- (QColor*) backgroundColor;
- paintCell: (QPainter *)p cg: (QColorGroup *)cg column: (int)column width: (int)width alignment: (int)alignment;
@end

#endif
