/***************************************************************************
                            KTipDialog.h -  description
                             -------------------
    begin                : Fri Mar  8 13:55:08 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Mar  8 13:55:08 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KTIPDIALOG_H
#define KTIPDIALOG_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <kdeobjc/KDialog.h>

/**

 A Tip-of-the-Day dialog.

 This dialog class presents a tip-of-the-day.

 @author Matthias Hoelzer-Kluepfel <mhk@caldera.de>
 
 @short 
 A Tip-of-the-Day dialog.
*/

@class KTipDatabase;

@interface KTipDialog : KDialog 

/** 
 Shows a tip.

 This static method is all that is needed to add a tip-of-the-day
 dialog to an application. It will pop up the dialog, unless the
 user has asked that the dialog does not pop up on startup.

 Note that you probably want an item in the help menu calling
 this method with force=true.

*/
+ showTip: (QWidget *)parent tipFile: (NSString *)tipFile force: (BOOL)force;
+ showTip: (QWidget *)parent ;

/** 
 Shows a tip.

 This methods calls -showTip with the applications main window as parent.

   
*/
+ showTip: (NSString *)tipFile force: (BOOL)force;
+ showTip;

/** 
 Toggles the start behaviour.

 Normally, the user can disable the display of the tip in the dialog.
 This is just a way to change this setting from outside.
   
*/
+ setShowOnStart: (BOOL)show;
- initWithTipDatabase: (KTipDatabase*)db parent: (QWidget *)parent name: (NSString *)name;
- initWithTipDatabase: (KTipDatabase*)db ;
@end

/** Override these methods in subclasses of KTipDialog to customise event handling behaviour */
@protocol KTipDialogEventHandling

/** 

     
*/
- keyPressEvent:(QKeyEvent*) arg1;
- keyReleaseEvent:(QKeyEvent*) arg1;
- focusOutEvent:(QFocusEvent*) arg1;
- childEvent:(QChildEvent*) arg1;
- dragMoveEvent:(QDragMoveEvent*) arg1;
- leaveEvent:(QEvent*) arg1;
- tabletEvent:(QTabletEvent*) arg1;
- showEvent:(QShowEvent*) arg1;
- contextMenuEvent:(QContextMenuEvent*) arg1;
- mousePressEvent:(QMouseEvent*) arg1;
- imComposeEvent:(QIMEvent*) arg1;
- customEvent:(QCustomEvent*) arg1;
- mouseReleaseEvent:(QMouseEvent*) arg1;
- mouseDoubleClickEvent:(QMouseEvent*) arg1;
- dragLeaveEvent:(QDragLeaveEvent*) arg1;
- enterEvent:(QEvent*) arg1;
- focusInEvent:(QFocusEvent*) arg1;
- imEndEvent:(QIMEvent*) arg1;
- dropEvent:(QDropEvent*) arg1;
- dragEnterEvent:(QDragEnterEvent*) arg1;
- mouseMoveEvent:(QMouseEvent*) arg1;
- moveEvent:(QMoveEvent*) arg1;
- wheelEvent:(QWheelEvent*) arg1;
- hideEvent:(QHideEvent*) arg1;
- imStartEvent:(QIMEvent*) arg1;
- closeEvent:(QCloseEvent*) arg1;
- paintEvent:(QPaintEvent*) arg1;
- timerEvent:(QTimerEvent*) arg1;
- resizeEvent:(QResizeEvent*) arg1;
@end


#endif
