#include "settings.h"
#include "settings.moc"

#include <qlabel.h>
#include <qhbox.h>
#include <qlayout.h>
#include <qcheckbox.h>

#include <klocale.h>
#include <knuminput.h>
#include <kcolorbutton.h>


AppearanceConfig::AppearanceConfig()
    : KConfigWidget(i18n("Appearance"), "colorize")
{
    QGridLayout *top = new QGridLayout(this, 6, 3, KDialog::marginHint(),
                                       KDialog::spacingHint());
    top->setColStretch(2, 1);

    QLabel *label = new QLabel(this);
    top->addWidget(label, 0, 0);
    KIntNumInput *in = new KIntNumInput(this);
    in->setRange(0, 100); // #### just to add a slider !
    KConfigItem *set = configCollection()->plug("block size", in);
    set->setProxyLabel(label);
    top->addMultiCellWidget(in, 0, 0, 1, 2);

    top->addRowSpacing(1, KDialog::spacingHint());

    label = new QLabel(this);
    top->addWidget(label, 2, 0);
    KDoubleNumInput *dn = new KDoubleNumInput(this);
    dn->setRange(0, 100, 0.01); // #### just to add a slider and set the step !
    set = configCollection()->plug("fade intensity", dn);
    set->setProxyLabel(label);
    top->addMultiCellWidget(dn, 2, 2, 1, 2);
    label = new QLabel(this);
    top->addWidget(label, 3, 0);
    KColorButton *cob = new KColorButton(this);
    set = configCollection()->plug("fade color", cob);
    set->setProxyLabel(label);
    top->addWidget(cob, 3, 1);

    top->addRowSpacing(4, KDialog::spacingHint());

    QCheckBox *chb = new QCheckBox(this);
    configCollection()->plug("enable animations", chb);
    top->addMultiCellWidget(chb, 5, 5, 0, 2);
}
