//-*-C++-*-
/*
**************************************************************************
                                 description
                             --------------------
    copyright            : (C) 2000-2001 by Andreas Zehender
    email                : zehender@kde.org
**************************************************************************

**************************************************************************
*                                                                        *
*  This program is free software; you can redistribute it and/or modify  *
*  it under the terms of the GNU General Public License as published by  *
*  the Free Software Foundation; either version 2 of the License, or     *
*  (at your option) any later version.                                   *
*                                                                        *
**************************************************************************/


#ifndef PMTRANSLATE_H
#define PMTRANSLATE_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "pmobject.h"
#include "pmvector.h"

/**
 * Class for povray move commands.
 */ 

class PMTranslate : public PMObject
{
   typedef PMObject Base;
public:
   /** Creates a move < 0, 0, 0 > */
   PMTranslate( );
   /** deletes the object */
   virtual ~PMTranslate( );

   /** */
   virtual PMObject* newObject( ) const { return new PMTranslate( ); }
   /** */
   virtual QString className( ) const { return QString( "translate" ); }
   /** */
   virtual QString description( ) const;
   /** */
   virtual PMObjectType type( ) const { return PMTTranslate; }
   /** */
   virtual bool isA( PMObjectType t ) const;

   
   /** */
   virtual void serialize( PMOutputDevice& dev ) const;
   /** */
   virtual void serialize( QDomElement& e, QDomDocument& doc ) const;
   /** */
   virtual void readAttributes( const PMXMLHelper& h );
   /** Returns a new @ref PMTranslateEdit */
   virtual PMDialogEditBase* editWidget( QWidget* parent ) const;
   /** */
   virtual QString pixmap( ) const { return QString( "pmtranslate" ); }

   /** Returns the movement */
   PMVector translation( ) const { return m_move; }
   /** Sets the movement */
   void setTranslation( const PMVector& p );
   
   /** */
   virtual void restoreMemento( PMMemento* s );
   /** */
   virtual bool hasTransformationMatrix( ) const { return true; }
   /** */
   virtual PMMatrix transformationMatrix( ) const;

   /** */
   virtual void controlPoints( PMControlPointList& list );
   /** */
   virtual void controlPointsChanged( PMControlPointList& list );
private:
   /** IDs for @ref PMMementoData */
   enum PMTranslateMementoID { PMTranslationID };
   PMVector m_move;
};

#endif
