/***************************************************************************
                          recordfile.cpp  -  description
                             -------------------
    begin                : Don Jun 20 2002
    copyright            : (C) 2002 by Arnold Krille
    email                : arnold@arnoldarts.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "recordfile.h"

#include <qpixmap.h>
#include <qfile.h>
#include <stdio.h>

#include <kaction.h>
#include <kiconloader.h>
#include <kmessagebox.h>
#include <klocale.h>
#include <kpopupmenu.h>
#include <kdebug.h>

RecordFile::RecordFile( KListViewItem *parent, QString filename, QObject *qobject )
	: QObject(qobject, 0),
	KListViewItem(parent,filename)
	, _filename( filename )
{
	init();
}

RecordFile::RecordFile( KListView *parent, QString filename, QObject *qobject )
	: QObject(qobject,filename.utf8()),
	KListViewItem(parent,filename)
	, _filename( filename )
{
	init();
}

RecordFile::~RecordFile(){
kdDebug()<<"RecordFile("<<_filename<<")::~RecordFile()"<<endl; // (DEBUG)
	closeFile();
kdDebug()<<"~RecordFile("<<_filename<<") Bye"<<endl;
}

void RecordFile::init(){
kdDebug()<<"RecordFile("<<_filename<<")::init()"<<endl; // (DEBUG)
	KIconLoader iconload;

	file_normal = new QPixmap( iconload.loadIcon( "krec_fileempty", KIcon::Small ) );
	file_rec = new QPixmap( iconload.loadIcon( "krec_filerec", KIcon::Small ) );
	file_play = new QPixmap( iconload.loadIcon( "krec_fileplay", KIcon::Small ) );
	pix = file_normal;
	_open = not_tried;

	i_menu = new KActionMenu( i18n("File Menu"), this, "recordfilemenu" );
	a_rec = new KAction( i18n("Record to This File"), "krec_record", KShortcut(), this, SLOT(recFile()), this, "open_rec" );
	i_menu->insert( a_rec );
	a_play = new KAction( i18n("Play File"), "player_play", KShortcut(), this, SLOT(playFile()), this, "playrecordfile" );
	i_menu->insert( a_play );
	a_delete = new KAction( i18n("Close File"), "fileclose", KShortcut(), this, SLOT(deleteLater()), this, "closerecordfile" );
	i_menu->popupMenu()->insertSeparator();
	i_menu->insert( a_delete );
}

const QPixmap* RecordFile::pixmap( int i ) const {
	//kdDebug()<<"RecordFile("<<_filename<<")::pixmap( int "<<i<<" )"<<endl; // (DEBUG)
	if(i)
		return 0;
	if( _open==open_rec ) return file_rec;
	if( _open==open_play ) return file_play;
	return file_normal;
}

bool RecordFile::openFile( int mode )
{
	kdDebug() << k_funcinfo << mode << endl;
	if( m_file.isOpen() )
		kdWarning() << k_funcinfo << "called on an already open file" << endl;
	m_file.setName( _filename );
	return m_file.open( mode );
}

void RecordFile::closeFile( bool signal ){
kdDebug()<<"RecordFile("<<_filename<<")::closeFile( bool "<<signal<<" ) _open="<<_open<<"\n"; // (DEBUG)
	if( !signal && openrec() ) emit sNewRecFile( 0 ); // To remove the recording-connection from this file.
	if( openrec() || openplay() )
	{
		m_file.close();
		_open = not_tried;
	}
	//kdDebug()<<listView()<<" "<<(( listView() )?"true":"false")<<endl;
	if( listView() ) listView()->triggerUpdate();
	//kdDebug()<<" _open="<<_open<<endl; // (DEBUG)
}

void RecordFile::receiveData( QByteArray & data )
{
	m_file.writeBlock( data );
}

void RecordFile::openFileRec(){
kdDebug()<<"RecordFile("<<_filename<<")::openFileRec() _open="<<_open<<"\n"; // (DEBUG)
	if( openrec() || openplay() )
		closeFile();
	if( (!openrec() && !openplay()) )
	{
		//kdDebug()<<"Opening file"<<endl; // (DEBUG)
		if( ! openFile( IO_ReadOnly | IO_Append ) )
		{
			KMessageBox::error( 0, i18n("Unable to open the output file for recording.\nThe failed file is: '%1'").arg( _filename ) );
			_open=error_opening;
		}
		else
		{
			_open=open_rec;
		}
		listView()->triggerUpdate();
	}
	//kdDebug()<<" _open="<<_open<<endl; // (DEBUG)
}

void RecordFile::openFilePlay(){
kdDebug()<<"RecordFile("<<_filename<<")::openFilePlay() _open="<<_open<<"\n"; // (DEBUG)
	if( openrec() || openplay() )
	{
		closeFile();
	}
	//kdDebug()<<" _open="<<_open<<" "; // (DEBUG)

	if( (!openrec() && !openplay()) )
	{
		if( ! openFile( IO_ReadOnly ) )
		{
			KMessageBox::error( 0, i18n("Unable to open the input file for playback.\nThe failed file is: '%1'").arg( _filename ) );
			_open=error_opening;
		}
		else
		{
			_open=open_play;
		}
		listView()->triggerUpdate();
	}
	//kdDebug()<<" _open="<<_open<<endl; // (DEBUG)
}

#include "recordfile.moc"

// vim:sw=4:ts=4

