/***************************************************************************
                          recordfile.h  -  description
                             -------------------
    begin                : Don Jun 20 2002
    copyright            : (C) 2002 by Arnold Krille
    email                : arnold@arnoldarts.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef RECORDFILE_H
#define RECORDFILE_H

#include <stdio.h>

#include <qobject.h>
#include <qstring.h>
#include <qfile.h>

#include <klistview.h>

class QPixmap;
class KActionMenu;
class KAction;

/**
  *@author Arnold Krille
  */

class RecordFile : public QObject, public KListViewItem
{
   Q_OBJECT
public:
	/// Constructs a new File as Child.
	RecordFile( KListViewItem *parent, QString filename, QObject *qobject=0 );
	/// Constructs a new Top-Level-File.
	RecordFile( KListView *parent, QString filename, QObject *qobject=0 );
	/// Destructor
	virtual ~RecordFile();

	/// Returns the opened File.
	QFile & file() { return m_file; };
	/// Returns the Pixmap.
	/**
		Returns the actual Icon for the file depending on the state.

		Returns 0 if i is not 0.
	*/
	const QPixmap* pixmap( int i=0 ) const;
	/// Idenificationnumber
	/**
		Returns the identificationnumber 1001.
	*/
	int rtti() const { return 1001; }
	/// contextMenu.
	/**
		Returns the contextmenu.
	*/
	KActionMenu* menu() { return i_menu; }

	/// If the file is opened for Recording.
	bool openrec() { return (_open==open_rec); }
	/// If the file is opend for playing.
	bool openplay() { return (_open==open_play); }

public slots:
	/// [OBSOLETE] Called when the Item is selected.
	void activate() {}
	/// Called when this file wants to be played.
	void playFile() { emit sNewPlayFile( this ); }
	/// Called when this file wants to be recorded.
	void recFile() { emit sNewRecFile( this ); }
	/// Opens the file for recording.
	void openFileRec();
	/// Opens the file for playback.
	void openFilePlay();
	/// Closes the file.
	void closeFile( bool signal=false);

	/**
	 * receives data to write to the file
	 */
	void receiveData( QByteArray & data );

signals:
	/// Emitted when this file wants to be recorded.
	void sNewRecFile( RecordFile* );
	/// Emitted when this file wants to be played.
	void sNewPlayFile( RecordFile* );

private slots:
	bool openFile( int mode );
	void init();

private:
	enum fstat { not_tried=0, error_opening, open_rec, open_play };
	QFile m_file;
	QPixmap *pix;
	fstat _open;
	KActionMenu *i_menu;
	KAction *a_play;
	KAction *a_rec;
	KAction *a_delete;
	QPixmap *file_normal, *file_rec, *file_play;
	QString _filename;
};

#endif

// vim:sw=4:ts=4
