/* ****************************************************************************
  This file is part of KBabel

  Copyright (C) 2002	Stanislav Visnovsky
                            <visnovsky@kde.org>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

**************************************************************************** */
#ifndef CONTEXT_H
#define CONTEXT_H

#include <qvaluelist.h>
#include <qwidget.h>

#include <ktexteditor/document.h>
#include <ktexteditor/view.h>

class QComboBox;
class QLineEdit;
class KListEditor;
class KConfig;

struct SourceContextSettings 
{
    /**
     * A path, which can be used as @CODEROOT variable in @ref sourcePaths .
     * Defaults to empty string.
     */
    QString codeRoot;

    /**
     * List of paths, where the source file should be lookup. Can use @CODEROOT (replaced by @ref codeRoot),
     * @PACKAGE (replaced by package name), @COMMENTPATH (path extracted from comment specs.
     */
    QStringList sourcePaths;
};

struct ContextInfo
{
    QString path;
    uint line;
};

namespace Defaults {

    class SourceContextSettings
    {
     public:
        static QString codeRoot();
	static QStringList sourcePaths();
    };
}

class SourceContext : public QWidget
{
    Q_OBJECT
public:
    SourceContext(QWidget* parent=0); 
    
    SourceContextSettings settings() {return _settings;}
    void setSettings(SourceContextSettings& settings);
    
    void saveSettings(KConfig* config);
    void restoreSettings(KConfig* config);

public slots:
    /**
     * Try to find the corresponding file and load it to this widget.
     * @param package		package, where to find the source file
     * @param gettextComment	comment string with context as generated by xgettext (can start with #:)
     */
    void setContext( QString package, QString gettextComment );

private:
    QValueList<ContextInfo> resolvePath( QString package, QString gettextComment );
    
    KTextEditor::Document* _part;
    KTextEditor::View* _view;
    QComboBox *_referenceCombo;
    
    QValueList<ContextInfo> _referenceList;
    
    SourceContextSettings _settings;
private slots:
    void updateToSelected(int index);
};

class SourceContextPreferences : public QWidget
{
    Q_OBJECT
public:
    SourceContextPreferences(QWidget* parent=0); 
    virtual ~SourceContextPreferences();
    
    void mergeSettings(SourceContextSettings& settings) const;
    void setSettings(const SourceContextSettings& settings);
    void defaults();

    virtual bool eventFilter(QObject *, QEvent*);

private:
    QLineEdit* _coderootEdit;
    KListEditor* _pathsEditor;
};

#endif // CONTEXT_H
