#ifndef PREFERENCESDIALOG_H
#define PREFERENCESDIALOG_H

#include <kdialogbase.h>

class QCheckBox;
class QRadioButton;
class QLineEdit;
class QListView;

class PreferencesDialog : public KDialogBase
{
    Q_OBJECT
  public:
    PreferencesDialog( QWidget* parent = 0, const char* name = 0 );
    ~PreferencesDialog();

  public:
    void readConfig();
    void writeConfig();

  protected slots:
    void setDefaults();
    void slotOk();
    void slotCancel();
    void slotBugzillaURLChanged( const QString &);

    void addServer();
    void editServer();
    void removeServer();

  protected:
    void setupServerPage();
    void setupAdvancedPage();

  private:
    QCheckBox *mShowClosedCheckBox;
    QCheckBox *mShowWishesCheckBox;
    QCheckBox *mSendBccCheckBox;
    QRadioButton *mKMailButton;
    QRadioButton *mDirectButton;
    QRadioButton *mSendmailButton;
    QLineEdit *mBugzillaURLLineEdit;
    QListView *mServerList;
};

#endif
