 Types in \slang may are implemented in one of 4 ways: as scalars,
 vectors, pointers, and memory managed types (MMTs).  The meaning of
 these is discussed in more detail below.  When implementing new types
 for S-Lang, it is important to determine which class best describes
 the new type.
 
 Scalar-type objects are the simplest because they correspond to
 native C objects.  Examples of S-Lang scalar objects include
 Integer_Type, Double_Type, and Char_Type.  A scalar-type object
 should be used to represent a new type if the new type can be fully
 represented by a simple (non-pointer) C type, e.g., a long.
 
 A vector-type object is represented as an array of simple C types.
 For example, Complex_Type is implemented as an array of two doubles.
 
 The S-Lang String_Type, Array_Type, and Struct_Type are pointer-type
 objects.  For example, String_Type is represented internally as a C
 char *.  A pointer-type object is characterized by a C pointer to
 some malloced object.  As such, the implementation of this type of
 this form must provide the appropriate hook for the destruction of
 an instance of this object.  In other words, the implementation must
 provide the necessary infrastructure for managing the memory
 associated with an object of this type.
 
 The final class of object is a memory-managed type, or MMT.  It is
 similar to a pointer type except that the memory associated with the
 object handled by the S-Lang library.  MMTs are reference-counted
 pointer-types.  As such, the implementation of an object of this
 class is usually simpler than pointer-type objects because the
 interpreter makes certain assumptions about how an object of this
 class is used that are consistent with it being reference-counted.
 
 A S-Lang type is represented by the SLang_Class_Type structure.
 Although this structure is layed out in slang.h, there is no
 guarantee that it will be in future releases.  Instead, one should
 access fields of the structure using functions such as
 SLclass_set_anew_function.

