/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.io.Serializable;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public final class ComponentOrientation
implements Serializable {
    private static final long serialVersionUID = -4113291392143563828L;
    private static final int UNKNOWN_ID = 1;
    private static final int HORIZONTAL_ID = 2;
    private static final int LEFT_TO_RIGHT_ID = 4;
    public static final ComponentOrientation LEFT_TO_RIGHT = new ComponentOrientation(6);
    public static final ComponentOrientation RIGHT_TO_LEFT = new ComponentOrientation(2);
    public static final ComponentOrientation UNKNOWN = new ComponentOrientation(7);
    private final int orientation;

    private ComponentOrientation(int orientation) {
        this.orientation = orientation;
    }

    public boolean isHorizontal() {
        return (this.orientation & 2) != 0;
    }

    public boolean isLeftToRight() {
        return (this.orientation & 4) != 0;
    }

    public static ComponentOrientation getOrientation(Locale locale) {
        String language = locale.getLanguage();
        if ("ar".equals(language) || "fa".equals(language) || "iw".equals(language) || "ur".equals(language)) {
            return RIGHT_TO_LEFT;
        }
        return LEFT_TO_RIGHT;
    }

    public static ComponentOrientation getOrientation(ResourceBundle bdl) {
        ComponentOrientation r;
        try {
            r = (ComponentOrientation)bdl.getObject("Orientation");
            if (r != null) {
                return r;
            }
        }
        catch (MissingResourceException ignored) {
        }
        catch (ClassCastException ignored) {
            // empty catch block
        }
        try {
            r = ComponentOrientation.getOrientation(bdl.getLocale());
            if (r != null) {
                return r;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ComponentOrientation.getOrientation(Locale.getDefault());
    }
}

