/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.DataBuffer;
import java.awt.image.Raster;
import java.awt.image.SampleModel;

public class WritableRaster
extends Raster {
    protected WritableRaster(SampleModel sampleModel, Point origin) {
        this(sampleModel, sampleModel.createDataBuffer(), origin);
    }

    protected WritableRaster(SampleModel sampleModel, DataBuffer dataBuffer, Point origin) {
        this(sampleModel, dataBuffer, new Rectangle(origin.x, origin.y, sampleModel.getWidth(), sampleModel.getHeight()), origin, null);
    }

    protected WritableRaster(SampleModel sampleModel, DataBuffer dataBuffer, Rectangle aRegion, Point sampleModelTranslate, WritableRaster parent) {
        super(sampleModel, dataBuffer, aRegion, sampleModelTranslate, parent);
    }

    public WritableRaster getWritableParent() {
        return (WritableRaster)this.getParent();
    }

    public WritableRaster createWritableTranslatedChild(int childMinX, int childMinY) {
        int tcx = this.sampleModelTranslateX - this.minX + childMinX;
        int tcy = this.sampleModelTranslateY - this.minY + childMinY;
        return new WritableRaster(this.sampleModel, this.dataBuffer, new Rectangle(childMinX, childMinY, this.width, this.height), new Point(tcx, tcy), this);
    }

    public WritableRaster createWritableChild(int parentX, int parentY, int w, int h, int childMinX, int childMinY, int[] bandList) {
        SampleModel sm = bandList == null ? this.sampleModel : this.sampleModel.createSubsetSampleModel(bandList);
        return new WritableRaster(sm, this.dataBuffer, new Rectangle(childMinX, childMinY, w, h), new Point(this.sampleModelTranslateX + childMinX - parentX, this.sampleModelTranslateY + childMinY - parentY), this);
    }

    public void setDataElements(int x, int y, Object inData) {
        this.sampleModel.setDataElements(x - this.sampleModelTranslateX, y - this.sampleModelTranslateY, inData, this.dataBuffer);
    }

    public void setDataElements(int x, int y, Raster inRaster) {
        Object dataElements = this.getDataElements(0, 0, inRaster.getWidth(), inRaster.getHeight(), null);
        this.setDataElements(x, y, dataElements);
    }

    public void setDataElements(int x, int y, int w, int h, Object inData) {
        this.sampleModel.setDataElements(x - this.sampleModelTranslateX, y - this.sampleModelTranslateY, w, h, inData, this.dataBuffer);
    }

    public void setRect(Raster srcRaster) {
        this.setRect(srcRaster, 0, 0);
    }

    public void setRect(Raster srcRaster, int dx, int dy) {
        Rectangle targetUnclipped = new Rectangle(srcRaster.getMinX() + dx, srcRaster.getMinY() + dy, srcRaster.getWidth(), srcRaster.getHeight());
        Rectangle target = this.getBounds().intersection(targetUnclipped);
        if (target.isEmpty()) {
            return;
        }
        int sx = target.x - dx;
        int sy = target.y - dy;
        int[] pixels = srcRaster.getPixels(sx, sy, target.width, target.height, (int[])null);
        this.setPixels(target.x, target.y, target.width, target.height, pixels);
    }

    public void setPixel(int x, int y, int[] iArray) {
        this.sampleModel.setPixel(x - this.sampleModelTranslateX, y - this.sampleModelTranslateY, iArray, this.dataBuffer);
    }

    public void setPixel(int x, int y, float[] fArray) {
        this.sampleModel.setPixel(x - this.sampleModelTranslateX, y - this.sampleModelTranslateY, fArray, this.dataBuffer);
    }

    public void setPixel(int x, int y, double[] dArray) {
        this.sampleModel.setPixel(x - this.sampleModelTranslateX, y - this.sampleModelTranslateY, dArray, this.dataBuffer);
    }

    public void setPixels(int x, int y, int w, int h, int[] iArray) {
        this.sampleModel.setPixels(x - this.sampleModelTranslateX, y - this.sampleModelTranslateY, w, h, iArray, this.dataBuffer);
    }

    public void setPixels(int x, int y, int w, int h, float[] fArray) {
        this.sampleModel.setPixels(x - this.sampleModelTranslateX, y - this.sampleModelTranslateY, w, h, fArray, this.dataBuffer);
    }

    public void setPixels(int x, int y, int w, int h, double[] dArray) {
        this.sampleModel.setPixels(x - this.sampleModelTranslateX, y - this.sampleModelTranslateY, w, h, dArray, this.dataBuffer);
    }

    public void setSample(int x, int y, int b, int s) {
        this.sampleModel.setSample(x - this.sampleModelTranslateX, y - this.sampleModelTranslateY, b, s, this.dataBuffer);
    }

    public void setSample(int x, int y, int b, float s) {
        this.sampleModel.setSample(x - this.sampleModelTranslateX, y - this.sampleModelTranslateY, b, s, this.dataBuffer);
    }

    public void setSample(int x, int y, int b, double s) {
        this.sampleModel.setSample(x - this.sampleModelTranslateX, y - this.sampleModelTranslateY, b, s, this.dataBuffer);
    }

    public void setSamples(int x, int y, int w, int h, int b, int[] iArray) {
        this.sampleModel.setSamples(x - this.sampleModelTranslateX, y - this.sampleModelTranslateY, w, h, b, iArray, this.dataBuffer);
    }

    public void setSamples(int x, int y, int w, int h, int b, float[] fArray) {
        this.sampleModel.setSamples(x - this.sampleModelTranslateX, y - this.sampleModelTranslateY, w, h, b, fArray, this.dataBuffer);
    }

    public void setSamples(int x, int y, int w, int h, int b, double[] dArray) {
        this.sampleModel.setSamples(x - this.sampleModelTranslateX, y - this.sampleModelTranslateY, w, h, b, dArray, this.dataBuffer);
    }
}

