/*
 * mklost+found - Create a lost+found directory for the second
 *                extended file system
 *
 * Copyright (C) 1993  Remy Card (card@masi.ibp.fr)
 *
 */

#include <errno.h>
#include <fcntl.h>
#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <linux/fs.h>
#include <linux/ext2_fs.h>
#include <sys/stat.h>

#define LPF "lost+found"

void main (int argc, char ** argv)
{
	char name [EXT2_NAME_LEN];
	char path [PATH_MAX];
	struct stat st;
	int i, j;
	int d;

	fprintf (stderr, "mklost+found 0.3, 93/04/22 for EXT2 FS %s\n",
		 EXT2FS_VERSION);
	if (argc != 1)
	{
		printf ("Usage: mklost+found\n");
		exit (1);
	}
	if (mkdir (LPF, 0755) == -1)
	{
		perror ("mkdir");
		exit (2);
	}
	
	i = 0;
	memset (name, 'x', 252);
	do
	{
		sprintf (name + 252, "%02d", i);
		strcpy (path, LPF);
		strcat (path, "/");
		strcat (path, name);
		if ((d = creat (path, 0644)) == -1)
		{
			perror ("creat");
			exit (3);
		}
		i ++;
		close (d);
		if (stat (LPF, &st) == -1)
		{
			perror ("stat");
			exit (4);
		}
	} while (st.st_size <= (EXT2_NDIR_BLOCKS - 1) * BLOCK_SIZE);
	for (j = 0; j < i; j ++)
	{
		sprintf (name + 252, "%02d", j);
		strcpy (path, LPF);
		strcat (path, "/");
		strcat (path, name);
		if (unlink (path) == -1)
		{
			perror ("unlink");
			exit (5);
		}
	}
	exit (0);
}
