/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSMessageEvent.h"

#include "DOMWindow.h"
#include "JSDOMWindow.h"
#include "KURL.h"
#include "MessageEvent.h"
#include "SerializedScriptValue.h"
#include <runtime/Error.h>
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSMessageEvent);

/* Hash table */

static const HashTableValue JSMessageEventTableValues[7] =
{
    { "data", DontDelete|ReadOnly, (intptr_t)jsMessageEventData, (intptr_t)0 },
    { "origin", DontDelete|ReadOnly, (intptr_t)jsMessageEventOrigin, (intptr_t)0 },
    { "lastEventId", DontDelete|ReadOnly, (intptr_t)jsMessageEventLastEventId, (intptr_t)0 },
    { "source", DontDelete|ReadOnly, (intptr_t)jsMessageEventSource, (intptr_t)0 },
    { "ports", DontDelete|ReadOnly, (intptr_t)jsMessageEventPorts, (intptr_t)0 },
    { "constructor", DontEnum|ReadOnly, (intptr_t)jsMessageEventConstructor, (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSMessageEventTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 15, JSMessageEventTableValues, 0 };
#else
    { 16, 15, JSMessageEventTableValues, 0 };
#endif

/* Hash table for constructor */

static const HashTableValue JSMessageEventConstructorTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSMessageEventConstructorTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 0, JSMessageEventConstructorTableValues, 0 };
#else
    { 1, 0, JSMessageEventConstructorTableValues, 0 };
#endif

class JSMessageEventConstructor : public DOMConstructorObject {
public:
    JSMessageEventConstructor(ExecState* exec, JSDOMGlobalObject* globalObject)
        : DOMConstructorObject(JSMessageEventConstructor::createStructure(globalObject->objectPrototype()), globalObject)
    {
        putDirect(exec->propertyNames().prototype, JSMessageEventPrototype::self(exec, globalObject), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    virtual bool getOwnPropertyDescriptor(ExecState*, const Identifier&, PropertyDescriptor&);
    virtual const ClassInfo* classInfo() const { return &s_info; }
    static const ClassInfo s_info;

    static PassRefPtr<Structure> createStructure(JSValue proto) 
    { 
        return Structure::create(proto, TypeInfo(ObjectType, StructureFlags)); 
    }
    
protected:
    static const unsigned StructureFlags = OverridesGetOwnPropertySlot | ImplementsHasInstance | DOMConstructorObject::StructureFlags;
};

const ClassInfo JSMessageEventConstructor::s_info = { "MessageEventConstructor", 0, &JSMessageEventConstructorTable, 0 };

bool JSMessageEventConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSMessageEventConstructor, DOMObject>(exec, &JSMessageEventConstructorTable, this, propertyName, slot);
}

bool JSMessageEventConstructor::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSMessageEventConstructor, DOMObject>(exec, &JSMessageEventConstructorTable, this, propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSMessageEventPrototypeTableValues[2] =
{
    { "initMessageEvent", DontDelete|Function, (intptr_t)jsMessageEventPrototypeFunctionInitMessageEvent, (intptr_t)8 },
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSMessageEventPrototypeTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 0, JSMessageEventPrototypeTableValues, 0 };
#else
    { 2, 1, JSMessageEventPrototypeTableValues, 0 };
#endif

static const HashTable* getJSMessageEventPrototypeTable(ExecState* exec)
{
    return getHashTableForGlobalData(exec->globalData(), &JSMessageEventPrototypeTable);
}
const ClassInfo JSMessageEventPrototype::s_info = { "MessageEventPrototype", 0, 0, getJSMessageEventPrototypeTable };

JSObject* JSMessageEventPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSMessageEvent>(exec, globalObject);
}

bool JSMessageEventPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticFunctionSlot<JSObject>(exec, getJSMessageEventPrototypeTable(exec), this, propertyName, slot);
}

bool JSMessageEventPrototype::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticFunctionDescriptor<JSObject>(exec, getJSMessageEventPrototypeTable(exec), this, propertyName, descriptor);
}

static const HashTable* getJSMessageEventTable(ExecState* exec)
{
    return getHashTableForGlobalData(exec->globalData(), &JSMessageEventTable);
}
const ClassInfo JSMessageEvent::s_info = { "MessageEvent", &JSEvent::s_info, 0, getJSMessageEventTable };

JSMessageEvent::JSMessageEvent(NonNullPassRefPtr<Structure> structure, JSDOMGlobalObject* globalObject, PassRefPtr<MessageEvent> impl)
    : JSEvent(structure, globalObject, impl)
{
}

JSObject* JSMessageEvent::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return new (exec) JSMessageEventPrototype(JSMessageEventPrototype::createStructure(JSEventPrototype::self(exec, globalObject)));
}

bool JSMessageEvent::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSMessageEvent, Base>(exec, getJSMessageEventTable(exec), this, propertyName, slot);
}

bool JSMessageEvent::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSMessageEvent, Base>(exec, getJSMessageEventTable(exec), this, propertyName, descriptor);
}

JSValue jsMessageEventData(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSMessageEvent* castedThis = static_cast<JSMessageEvent*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    MessageEvent* imp = static_cast<MessageEvent*>(castedThis->impl());
    return imp->data()->deserialize(exec);
}

JSValue jsMessageEventOrigin(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSMessageEvent* castedThis = static_cast<JSMessageEvent*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    MessageEvent* imp = static_cast<MessageEvent*>(castedThis->impl());
    return jsString(exec, imp->origin());
}

JSValue jsMessageEventLastEventId(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSMessageEvent* castedThis = static_cast<JSMessageEvent*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    MessageEvent* imp = static_cast<MessageEvent*>(castedThis->impl());
    return jsString(exec, imp->lastEventId());
}

JSValue jsMessageEventSource(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSMessageEvent* castedThis = static_cast<JSMessageEvent*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    MessageEvent* imp = static_cast<MessageEvent*>(castedThis->impl());
    return toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->source()));
}

JSValue jsMessageEventPorts(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSMessageEvent* castedThis = static_cast<JSMessageEvent*>(asObject(slot.slotBase()));
    return castedThis->ports(exec);
}

JSValue jsMessageEventConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSMessageEvent* domObject = static_cast<JSMessageEvent*>(asObject(slot.slotBase()));
    return JSMessageEvent::getConstructor(exec, domObject->globalObject());
}
JSValue JSMessageEvent::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSMessageEventConstructor>(exec, static_cast<JSDOMGlobalObject*>(globalObject));
}

JSValue JSC_HOST_CALL jsMessageEventPrototypeFunctionInitMessageEvent(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSMessageEvent::s_info))
        return throwError(exec, TypeError);
    JSMessageEvent* castedThisObj = static_cast<JSMessageEvent*>(asObject(thisValue));
    return castedThisObj->initMessageEvent(exec, args);
}


}
