/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(SVG)

#include "JSSVGColor.h"

#include "JSRGBColor.h"
#include "RGBColor.h"
#include "SVGColor.h"
#include <runtime/Error.h>
#include <runtime/JSNumberCell.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSSVGColor);

/* Hash table */

static const HashTableValue JSSVGColorTableValues[4] =
{
    { "colorType", DontDelete|ReadOnly, (intptr_t)jsSVGColorColorType, (intptr_t)0 },
    { "rgbColor", DontDelete|ReadOnly, (intptr_t)jsSVGColorRgbColor, (intptr_t)0 },
    { "constructor", DontEnum|ReadOnly, (intptr_t)jsSVGColorConstructor, (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSSVGColorTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 3, JSSVGColorTableValues, 0 };
#else
    { 8, 7, JSSVGColorTableValues, 0 };
#endif

/* Hash table for constructor */

static const HashTableValue JSSVGColorConstructorTableValues[5] =
{
    { "SVG_COLORTYPE_UNKNOWN", DontDelete|ReadOnly, (intptr_t)jsSVGColorSVG_COLORTYPE_UNKNOWN, (intptr_t)0 },
    { "SVG_COLORTYPE_RGBCOLOR", DontDelete|ReadOnly, (intptr_t)jsSVGColorSVG_COLORTYPE_RGBCOLOR, (intptr_t)0 },
    { "SVG_COLORTYPE_RGBCOLOR_ICCCOLOR", DontDelete|ReadOnly, (intptr_t)jsSVGColorSVG_COLORTYPE_RGBCOLOR_ICCCOLOR, (intptr_t)0 },
    { "SVG_COLORTYPE_CURRENTCOLOR", DontDelete|ReadOnly, (intptr_t)jsSVGColorSVG_COLORTYPE_CURRENTCOLOR, (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSSVGColorConstructorTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 3, JSSVGColorConstructorTableValues, 0 };
#else
    { 8, 7, JSSVGColorConstructorTableValues, 0 };
#endif

class JSSVGColorConstructor : public DOMConstructorObject {
public:
    JSSVGColorConstructor(ExecState* exec, JSDOMGlobalObject* globalObject)
        : DOMConstructorObject(JSSVGColorConstructor::createStructure(globalObject->objectPrototype()), globalObject)
    {
        putDirect(exec->propertyNames().prototype, JSSVGColorPrototype::self(exec, globalObject), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    virtual bool getOwnPropertyDescriptor(ExecState*, const Identifier&, PropertyDescriptor&);
    virtual const ClassInfo* classInfo() const { return &s_info; }
    static const ClassInfo s_info;

    static PassRefPtr<Structure> createStructure(JSValue proto) 
    { 
        return Structure::create(proto, TypeInfo(ObjectType, StructureFlags)); 
    }
    
protected:
    static const unsigned StructureFlags = OverridesGetOwnPropertySlot | ImplementsHasInstance | DOMConstructorObject::StructureFlags;
};

const ClassInfo JSSVGColorConstructor::s_info = { "SVGColorConstructor", 0, &JSSVGColorConstructorTable, 0 };

bool JSSVGColorConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGColorConstructor, DOMObject>(exec, &JSSVGColorConstructorTable, this, propertyName, slot);
}

bool JSSVGColorConstructor::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSSVGColorConstructor, DOMObject>(exec, &JSSVGColorConstructorTable, this, propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSSVGColorPrototypeTableValues[8] =
{
    { "SVG_COLORTYPE_UNKNOWN", DontDelete|ReadOnly, (intptr_t)jsSVGColorSVG_COLORTYPE_UNKNOWN, (intptr_t)0 },
    { "SVG_COLORTYPE_RGBCOLOR", DontDelete|ReadOnly, (intptr_t)jsSVGColorSVG_COLORTYPE_RGBCOLOR, (intptr_t)0 },
    { "SVG_COLORTYPE_RGBCOLOR_ICCCOLOR", DontDelete|ReadOnly, (intptr_t)jsSVGColorSVG_COLORTYPE_RGBCOLOR_ICCCOLOR, (intptr_t)0 },
    { "SVG_COLORTYPE_CURRENTCOLOR", DontDelete|ReadOnly, (intptr_t)jsSVGColorSVG_COLORTYPE_CURRENTCOLOR, (intptr_t)0 },
    { "setRGBColor", DontDelete|Function, (intptr_t)jsSVGColorPrototypeFunctionSetRGBColor, (intptr_t)1 },
    { "setRGBColorICCColor", DontDelete|Function, (intptr_t)jsSVGColorPrototypeFunctionSetRGBColorICCColor, (intptr_t)2 },
    { "setColor", DontDelete|Function, (intptr_t)jsSVGColorPrototypeFunctionSetColor, (intptr_t)3 },
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSSVGColorPrototypeTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 255, JSSVGColorPrototypeTableValues, 0 };
#else
    { 17, 15, JSSVGColorPrototypeTableValues, 0 };
#endif

const ClassInfo JSSVGColorPrototype::s_info = { "SVGColorPrototype", 0, &JSSVGColorPrototypeTable, 0 };

JSObject* JSSVGColorPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSSVGColor>(exec, globalObject);
}

bool JSSVGColorPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticPropertySlot<JSSVGColorPrototype, JSObject>(exec, &JSSVGColorPrototypeTable, this, propertyName, slot);
}

bool JSSVGColorPrototype::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticPropertyDescriptor<JSSVGColorPrototype, JSObject>(exec, &JSSVGColorPrototypeTable, this, propertyName, descriptor);
}

const ClassInfo JSSVGColor::s_info = { "SVGColor", &JSCSSValue::s_info, &JSSVGColorTable, 0 };

JSSVGColor::JSSVGColor(NonNullPassRefPtr<Structure> structure, JSDOMGlobalObject* globalObject, PassRefPtr<SVGColor> impl)
    : JSCSSValue(structure, globalObject, impl)
{
}

JSObject* JSSVGColor::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return new (exec) JSSVGColorPrototype(JSSVGColorPrototype::createStructure(JSCSSValuePrototype::self(exec, globalObject)));
}

bool JSSVGColor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGColor, Base>(exec, &JSSVGColorTable, this, propertyName, slot);
}

bool JSSVGColor::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSSVGColor, Base>(exec, &JSSVGColorTable, this, propertyName, descriptor);
}

JSValue jsSVGColorColorType(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGColor* castedThis = static_cast<JSSVGColor*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGColor* imp = static_cast<SVGColor*>(castedThis->impl());
    return jsNumber(exec, imp->colorType());
}

JSValue jsSVGColorRgbColor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGColor* castedThis = static_cast<JSSVGColor*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGColor* imp = static_cast<SVGColor*>(castedThis->impl());
    return toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->rgbColor()));
}

JSValue jsSVGColorConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGColor* domObject = static_cast<JSSVGColor*>(asObject(slot.slotBase()));
    return JSSVGColor::getConstructor(exec, domObject->globalObject());
}
JSValue JSSVGColor::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSSVGColorConstructor>(exec, static_cast<JSDOMGlobalObject*>(globalObject));
}

JSValue JSC_HOST_CALL jsSVGColorPrototypeFunctionSetRGBColor(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSSVGColor::s_info))
        return throwError(exec, TypeError);
    JSSVGColor* castedThisObj = static_cast<JSSVGColor*>(asObject(thisValue));
    SVGColor* imp = static_cast<SVGColor*>(castedThisObj->impl());
    ExceptionCode ec = 0;
    const UString& rgbColor = args.at(0).toString(exec);

    imp->setRGBColor(rgbColor, ec);
    setDOMException(exec, ec);
    return jsUndefined();
}

JSValue JSC_HOST_CALL jsSVGColorPrototypeFunctionSetRGBColorICCColor(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSSVGColor::s_info))
        return throwError(exec, TypeError);
    JSSVGColor* castedThisObj = static_cast<JSSVGColor*>(asObject(thisValue));
    SVGColor* imp = static_cast<SVGColor*>(castedThisObj->impl());
    ExceptionCode ec = 0;
    const UString& rgbColor = args.at(0).toString(exec);
    const UString& iccColor = args.at(1).toString(exec);

    imp->setRGBColorICCColor(rgbColor, iccColor, ec);
    setDOMException(exec, ec);
    return jsUndefined();
}

JSValue JSC_HOST_CALL jsSVGColorPrototypeFunctionSetColor(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSSVGColor::s_info))
        return throwError(exec, TypeError);
    JSSVGColor* castedThisObj = static_cast<JSSVGColor*>(asObject(thisValue));
    SVGColor* imp = static_cast<SVGColor*>(castedThisObj->impl());
    ExceptionCode ec = 0;
    unsigned short colorType = args.at(0).toInt32(exec);
    const UString& rgbColor = args.at(1).toString(exec);
    const UString& iccColor = args.at(2).toString(exec);

    imp->setColor(colorType, rgbColor, iccColor, ec);
    setDOMException(exec, ec);
    return jsUndefined();
}

// Constant getters

JSValue jsSVGColorSVG_COLORTYPE_UNKNOWN(ExecState* exec, const Identifier&, const PropertySlot&)
{
    return jsNumber(exec, static_cast<int>(0));
}

JSValue jsSVGColorSVG_COLORTYPE_RGBCOLOR(ExecState* exec, const Identifier&, const PropertySlot&)
{
    return jsNumber(exec, static_cast<int>(1));
}

JSValue jsSVGColorSVG_COLORTYPE_RGBCOLOR_ICCCOLOR(ExecState* exec, const Identifier&, const PropertySlot&)
{
    return jsNumber(exec, static_cast<int>(2));
}

JSValue jsSVGColorSVG_COLORTYPE_CURRENTCOLOR(ExecState* exec, const Identifier&, const PropertySlot&)
{
    return jsNumber(exec, static_cast<int>(3));
}


}

#endif // ENABLE(SVG)
