/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(SVG)

#include "JSSVGDefsElement.h"

#include "CSSMutableStyleDeclaration.h"
#include "CSSStyleDeclaration.h"
#include "CSSValue.h"
#include "JSCSSStyleDeclaration.h"
#include "JSCSSValue.h"
#include "JSSVGAnimatedBoolean.h"
#include "JSSVGAnimatedString.h"
#include "JSSVGAnimatedTransformList.h"
#include "JSSVGElement.h"
#include "JSSVGMatrix.h"
#include "JSSVGRect.h"
#include "JSSVGStringList.h"
#include "KURL.h"
#include "SVGDefsElement.h"
#include "SVGElement.h"
#include "SVGStringList.h"
#include <runtime/Error.h>
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSSVGDefsElement);

/* Hash table */

static const HashTableValue JSSVGDefsElementTableValues[12] =
{
    { "requiredFeatures", DontDelete|ReadOnly, (intptr_t)jsSVGDefsElementRequiredFeatures, (intptr_t)0 },
    { "requiredExtensions", DontDelete|ReadOnly, (intptr_t)jsSVGDefsElementRequiredExtensions, (intptr_t)0 },
    { "systemLanguage", DontDelete|ReadOnly, (intptr_t)jsSVGDefsElementSystemLanguage, (intptr_t)0 },
    { "xmllang", DontDelete, (intptr_t)jsSVGDefsElementXmllang, (intptr_t)setJSSVGDefsElementXmllang },
    { "xmlspace", DontDelete, (intptr_t)jsSVGDefsElementXmlspace, (intptr_t)setJSSVGDefsElementXmlspace },
    { "externalResourcesRequired", DontDelete|ReadOnly, (intptr_t)jsSVGDefsElementExternalResourcesRequired, (intptr_t)0 },
    { "className", DontDelete|ReadOnly, (intptr_t)jsSVGDefsElementClassName, (intptr_t)0 },
    { "style", DontDelete|ReadOnly, (intptr_t)jsSVGDefsElementStyle, (intptr_t)0 },
    { "transform", DontDelete|ReadOnly, (intptr_t)jsSVGDefsElementTransform, (intptr_t)0 },
    { "nearestViewportElement", DontDelete|ReadOnly, (intptr_t)jsSVGDefsElementNearestViewportElement, (intptr_t)0 },
    { "farthestViewportElement", DontDelete|ReadOnly, (intptr_t)jsSVGDefsElementFarthestViewportElement, (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSSVGDefsElementTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 127, JSSVGDefsElementTableValues, 0 };
#else
    { 33, 31, JSSVGDefsElementTableValues, 0 };
#endif

/* Hash table for prototype */

static const HashTableValue JSSVGDefsElementPrototypeTableValues[7] =
{
    { "hasExtension", DontDelete|Function, (intptr_t)jsSVGDefsElementPrototypeFunctionHasExtension, (intptr_t)1 },
    { "getPresentationAttribute", DontDelete|Function, (intptr_t)jsSVGDefsElementPrototypeFunctionGetPresentationAttribute, (intptr_t)1 },
    { "getBBox", DontDelete|Function, (intptr_t)jsSVGDefsElementPrototypeFunctionGetBBox, (intptr_t)0 },
    { "getCTM", DontDelete|Function, (intptr_t)jsSVGDefsElementPrototypeFunctionGetCTM, (intptr_t)0 },
    { "getScreenCTM", DontDelete|Function, (intptr_t)jsSVGDefsElementPrototypeFunctionGetScreenCTM, (intptr_t)0 },
    { "getTransformToElement", DontDelete|Function, (intptr_t)jsSVGDefsElementPrototypeFunctionGetTransformToElement, (intptr_t)1 },
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSSVGDefsElementPrototypeTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 2047, JSSVGDefsElementPrototypeTableValues, 0 };
#else
    { 17, 15, JSSVGDefsElementPrototypeTableValues, 0 };
#endif

const ClassInfo JSSVGDefsElementPrototype::s_info = { "SVGDefsElementPrototype", 0, &JSSVGDefsElementPrototypeTable, 0 };

JSObject* JSSVGDefsElementPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSSVGDefsElement>(exec, globalObject);
}

bool JSSVGDefsElementPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticFunctionSlot<JSObject>(exec, &JSSVGDefsElementPrototypeTable, this, propertyName, slot);
}

bool JSSVGDefsElementPrototype::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticFunctionDescriptor<JSObject>(exec, &JSSVGDefsElementPrototypeTable, this, propertyName, descriptor);
}

const ClassInfo JSSVGDefsElement::s_info = { "SVGDefsElement", &JSSVGElement::s_info, &JSSVGDefsElementTable, 0 };

JSSVGDefsElement::JSSVGDefsElement(NonNullPassRefPtr<Structure> structure, JSDOMGlobalObject* globalObject, PassRefPtr<SVGDefsElement> impl)
    : JSSVGElement(structure, globalObject, impl)
{
}

JSObject* JSSVGDefsElement::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return new (exec) JSSVGDefsElementPrototype(JSSVGDefsElementPrototype::createStructure(JSSVGElementPrototype::self(exec, globalObject)));
}

bool JSSVGDefsElement::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGDefsElement, Base>(exec, &JSSVGDefsElementTable, this, propertyName, slot);
}

bool JSSVGDefsElement::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSSVGDefsElement, Base>(exec, &JSSVGDefsElementTable, this, propertyName, descriptor);
}

JSValue jsSVGDefsElementRequiredFeatures(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGDefsElement* castedThis = static_cast<JSSVGDefsElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGDefsElement* imp = static_cast<SVGDefsElement*>(castedThis->impl());
    return toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->requiredFeatures()), imp);
}

JSValue jsSVGDefsElementRequiredExtensions(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGDefsElement* castedThis = static_cast<JSSVGDefsElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGDefsElement* imp = static_cast<SVGDefsElement*>(castedThis->impl());
    return toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->requiredExtensions()), imp);
}

JSValue jsSVGDefsElementSystemLanguage(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGDefsElement* castedThis = static_cast<JSSVGDefsElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGDefsElement* imp = static_cast<SVGDefsElement*>(castedThis->impl());
    return toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->systemLanguage()), imp);
}

JSValue jsSVGDefsElementXmllang(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGDefsElement* castedThis = static_cast<JSSVGDefsElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGDefsElement* imp = static_cast<SVGDefsElement*>(castedThis->impl());
    return jsString(exec, imp->xmllang());
}

JSValue jsSVGDefsElementXmlspace(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGDefsElement* castedThis = static_cast<JSSVGDefsElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGDefsElement* imp = static_cast<SVGDefsElement*>(castedThis->impl());
    return jsString(exec, imp->xmlspace());
}

JSValue jsSVGDefsElementExternalResourcesRequired(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGDefsElement* castedThis = static_cast<JSSVGDefsElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGDefsElement* imp = static_cast<SVGDefsElement*>(castedThis->impl());
    RefPtr<SVGAnimatedBoolean> obj = imp->externalResourcesRequiredAnimated();
    return toJS(exec, castedThis->globalObject(), obj.get(), imp);
}

JSValue jsSVGDefsElementClassName(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGDefsElement* castedThis = static_cast<JSSVGDefsElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGDefsElement* imp = static_cast<SVGDefsElement*>(castedThis->impl());
    RefPtr<SVGAnimatedString> obj = imp->classNameAnimated();
    return toJS(exec, castedThis->globalObject(), obj.get(), imp);
}

JSValue jsSVGDefsElementStyle(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGDefsElement* castedThis = static_cast<JSSVGDefsElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGDefsElement* imp = static_cast<SVGDefsElement*>(castedThis->impl());
    return toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->style()));
}

JSValue jsSVGDefsElementTransform(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGDefsElement* castedThis = static_cast<JSSVGDefsElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGDefsElement* imp = static_cast<SVGDefsElement*>(castedThis->impl());
    RefPtr<SVGAnimatedTransformList> obj = imp->transformAnimated();
    return toJS(exec, castedThis->globalObject(), obj.get(), imp);
}

JSValue jsSVGDefsElementNearestViewportElement(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGDefsElement* castedThis = static_cast<JSSVGDefsElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGDefsElement* imp = static_cast<SVGDefsElement*>(castedThis->impl());
    return toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->nearestViewportElement()));
}

JSValue jsSVGDefsElementFarthestViewportElement(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGDefsElement* castedThis = static_cast<JSSVGDefsElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGDefsElement* imp = static_cast<SVGDefsElement*>(castedThis->impl());
    return toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->farthestViewportElement()));
}

void JSSVGDefsElement::put(ExecState* exec, const Identifier& propertyName, JSValue value, PutPropertySlot& slot)
{
    lookupPut<JSSVGDefsElement, Base>(exec, propertyName, value, &JSSVGDefsElementTable, this, slot);
}

void setJSSVGDefsElementXmllang(ExecState* exec, JSObject* thisObject, JSValue value)
{
    SVGDefsElement* imp = static_cast<SVGDefsElement*>(static_cast<JSSVGDefsElement*>(thisObject)->impl());
    imp->setXmllang(value.toString(exec));
}

void setJSSVGDefsElementXmlspace(ExecState* exec, JSObject* thisObject, JSValue value)
{
    SVGDefsElement* imp = static_cast<SVGDefsElement*>(static_cast<JSSVGDefsElement*>(thisObject)->impl());
    imp->setXmlspace(value.toString(exec));
}

JSValue JSC_HOST_CALL jsSVGDefsElementPrototypeFunctionHasExtension(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSSVGDefsElement::s_info))
        return throwError(exec, TypeError);
    JSSVGDefsElement* castedThisObj = static_cast<JSSVGDefsElement*>(asObject(thisValue));
    SVGDefsElement* imp = static_cast<SVGDefsElement*>(castedThisObj->impl());
    const UString& extension = args.at(0).toString(exec);


    JSC::JSValue result = jsBoolean(imp->hasExtension(extension));
    return result;
}

JSValue JSC_HOST_CALL jsSVGDefsElementPrototypeFunctionGetPresentationAttribute(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSSVGDefsElement::s_info))
        return throwError(exec, TypeError);
    JSSVGDefsElement* castedThisObj = static_cast<JSSVGDefsElement*>(asObject(thisValue));
    SVGDefsElement* imp = static_cast<SVGDefsElement*>(castedThisObj->impl());
    const UString& name = args.at(0).toString(exec);


    JSC::JSValue result = toJS(exec, castedThisObj->globalObject(), WTF::getPtr(imp->getPresentationAttribute(name)));
    return result;
}

JSValue JSC_HOST_CALL jsSVGDefsElementPrototypeFunctionGetBBox(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSSVGDefsElement::s_info))
        return throwError(exec, TypeError);
    JSSVGDefsElement* castedThisObj = static_cast<JSSVGDefsElement*>(asObject(thisValue));
    SVGDefsElement* imp = static_cast<SVGDefsElement*>(castedThisObj->impl());


    JSC::JSValue result = toJS(exec, castedThisObj->globalObject(), JSSVGStaticPODTypeWrapper<FloatRect>::create(imp->getBBox()).get(), imp);
    return result;
}

JSValue JSC_HOST_CALL jsSVGDefsElementPrototypeFunctionGetCTM(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSSVGDefsElement::s_info))
        return throwError(exec, TypeError);
    JSSVGDefsElement* castedThisObj = static_cast<JSSVGDefsElement*>(asObject(thisValue));
    SVGDefsElement* imp = static_cast<SVGDefsElement*>(castedThisObj->impl());


    JSC::JSValue result = toJS(exec, castedThisObj->globalObject(), JSSVGStaticPODTypeWrapper<TransformationMatrix>::create(imp->getCTM()).get(), imp);
    return result;
}

JSValue JSC_HOST_CALL jsSVGDefsElementPrototypeFunctionGetScreenCTM(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSSVGDefsElement::s_info))
        return throwError(exec, TypeError);
    JSSVGDefsElement* castedThisObj = static_cast<JSSVGDefsElement*>(asObject(thisValue));
    SVGDefsElement* imp = static_cast<SVGDefsElement*>(castedThisObj->impl());


    JSC::JSValue result = toJS(exec, castedThisObj->globalObject(), JSSVGStaticPODTypeWrapper<TransformationMatrix>::create(imp->getScreenCTM()).get(), imp);
    return result;
}

JSValue JSC_HOST_CALL jsSVGDefsElementPrototypeFunctionGetTransformToElement(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSSVGDefsElement::s_info))
        return throwError(exec, TypeError);
    JSSVGDefsElement* castedThisObj = static_cast<JSSVGDefsElement*>(asObject(thisValue));
    SVGDefsElement* imp = static_cast<SVGDefsElement*>(castedThisObj->impl());
    ExceptionCode ec = 0;
    SVGElement* element = toSVGElement(args.at(0));


    JSC::JSValue result = toJS(exec, castedThisObj->globalObject(), JSSVGStaticPODTypeWrapper<TransformationMatrix>::create(imp->getTransformToElement(element, ec)).get(), imp);
    setDOMException(exec, ec);
    return result;
}


}

#endif // ENABLE(SVG)
