/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(SVG) && ENABLE(FILTERS)

#include "JSSVGFEColorMatrixElement.h"

#include "CSSMutableStyleDeclaration.h"
#include "CSSStyleDeclaration.h"
#include "CSSValue.h"
#include "JSCSSStyleDeclaration.h"
#include "JSCSSValue.h"
#include "JSSVGAnimatedEnumeration.h"
#include "JSSVGAnimatedLength.h"
#include "JSSVGAnimatedNumberList.h"
#include "JSSVGAnimatedString.h"
#include "SVGFEColorMatrixElement.h"
#include <runtime/Error.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSSVGFEColorMatrixElement);

/* Hash table */

static const HashTableValue JSSVGFEColorMatrixElementTableValues[12] =
{
    { "in1", DontDelete|ReadOnly, (intptr_t)jsSVGFEColorMatrixElementIn1, (intptr_t)0 },
    { "type", DontDelete|ReadOnly, (intptr_t)jsSVGFEColorMatrixElementType, (intptr_t)0 },
    { "values", DontDelete|ReadOnly, (intptr_t)jsSVGFEColorMatrixElementValues, (intptr_t)0 },
    { "x", DontDelete|ReadOnly, (intptr_t)jsSVGFEColorMatrixElementX, (intptr_t)0 },
    { "y", DontDelete|ReadOnly, (intptr_t)jsSVGFEColorMatrixElementY, (intptr_t)0 },
    { "width", DontDelete|ReadOnly, (intptr_t)jsSVGFEColorMatrixElementWidth, (intptr_t)0 },
    { "height", DontDelete|ReadOnly, (intptr_t)jsSVGFEColorMatrixElementHeight, (intptr_t)0 },
    { "result", DontDelete|ReadOnly, (intptr_t)jsSVGFEColorMatrixElementResult, (intptr_t)0 },
    { "className", DontDelete|ReadOnly, (intptr_t)jsSVGFEColorMatrixElementClassName, (intptr_t)0 },
    { "style", DontDelete|ReadOnly, (intptr_t)jsSVGFEColorMatrixElementStyle, (intptr_t)0 },
    { "constructor", DontEnum|ReadOnly, (intptr_t)jsSVGFEColorMatrixElementConstructor, (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSSVGFEColorMatrixElementTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 255, JSSVGFEColorMatrixElementTableValues, 0 };
#else
    { 34, 31, JSSVGFEColorMatrixElementTableValues, 0 };
#endif

/* Hash table for constructor */

static const HashTableValue JSSVGFEColorMatrixElementConstructorTableValues[6] =
{
    { "SVG_FECOLORMATRIX_TYPE_UNKNOWN", DontDelete|ReadOnly, (intptr_t)jsSVGFEColorMatrixElementSVG_FECOLORMATRIX_TYPE_UNKNOWN, (intptr_t)0 },
    { "SVG_FECOLORMATRIX_TYPE_MATRIX", DontDelete|ReadOnly, (intptr_t)jsSVGFEColorMatrixElementSVG_FECOLORMATRIX_TYPE_MATRIX, (intptr_t)0 },
    { "SVG_FECOLORMATRIX_TYPE_SATURATE", DontDelete|ReadOnly, (intptr_t)jsSVGFEColorMatrixElementSVG_FECOLORMATRIX_TYPE_SATURATE, (intptr_t)0 },
    { "SVG_FECOLORMATRIX_TYPE_HUEROTATE", DontDelete|ReadOnly, (intptr_t)jsSVGFEColorMatrixElementSVG_FECOLORMATRIX_TYPE_HUEROTATE, (intptr_t)0 },
    { "SVG_FECOLORMATRIX_TYPE_LUMINANCETOALPHA", DontDelete|ReadOnly, (intptr_t)jsSVGFEColorMatrixElementSVG_FECOLORMATRIX_TYPE_LUMINANCETOALPHA, (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSSVGFEColorMatrixElementConstructorTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 63, JSSVGFEColorMatrixElementConstructorTableValues, 0 };
#else
    { 17, 15, JSSVGFEColorMatrixElementConstructorTableValues, 0 };
#endif

class JSSVGFEColorMatrixElementConstructor : public DOMConstructorObject {
public:
    JSSVGFEColorMatrixElementConstructor(ExecState* exec, JSDOMGlobalObject* globalObject)
        : DOMConstructorObject(JSSVGFEColorMatrixElementConstructor::createStructure(globalObject->objectPrototype()), globalObject)
    {
        putDirect(exec->propertyNames().prototype, JSSVGFEColorMatrixElementPrototype::self(exec, globalObject), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    virtual bool getOwnPropertyDescriptor(ExecState*, const Identifier&, PropertyDescriptor&);
    virtual const ClassInfo* classInfo() const { return &s_info; }
    static const ClassInfo s_info;

    static PassRefPtr<Structure> createStructure(JSValue proto) 
    { 
        return Structure::create(proto, TypeInfo(ObjectType, StructureFlags)); 
    }
    
protected:
    static const unsigned StructureFlags = OverridesGetOwnPropertySlot | ImplementsHasInstance | DOMConstructorObject::StructureFlags;
};

const ClassInfo JSSVGFEColorMatrixElementConstructor::s_info = { "SVGFEColorMatrixElementConstructor", 0, &JSSVGFEColorMatrixElementConstructorTable, 0 };

bool JSSVGFEColorMatrixElementConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGFEColorMatrixElementConstructor, DOMObject>(exec, &JSSVGFEColorMatrixElementConstructorTable, this, propertyName, slot);
}

bool JSSVGFEColorMatrixElementConstructor::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSSVGFEColorMatrixElementConstructor, DOMObject>(exec, &JSSVGFEColorMatrixElementConstructorTable, this, propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSSVGFEColorMatrixElementPrototypeTableValues[7] =
{
    { "SVG_FECOLORMATRIX_TYPE_UNKNOWN", DontDelete|ReadOnly, (intptr_t)jsSVGFEColorMatrixElementSVG_FECOLORMATRIX_TYPE_UNKNOWN, (intptr_t)0 },
    { "SVG_FECOLORMATRIX_TYPE_MATRIX", DontDelete|ReadOnly, (intptr_t)jsSVGFEColorMatrixElementSVG_FECOLORMATRIX_TYPE_MATRIX, (intptr_t)0 },
    { "SVG_FECOLORMATRIX_TYPE_SATURATE", DontDelete|ReadOnly, (intptr_t)jsSVGFEColorMatrixElementSVG_FECOLORMATRIX_TYPE_SATURATE, (intptr_t)0 },
    { "SVG_FECOLORMATRIX_TYPE_HUEROTATE", DontDelete|ReadOnly, (intptr_t)jsSVGFEColorMatrixElementSVG_FECOLORMATRIX_TYPE_HUEROTATE, (intptr_t)0 },
    { "SVG_FECOLORMATRIX_TYPE_LUMINANCETOALPHA", DontDelete|ReadOnly, (intptr_t)jsSVGFEColorMatrixElementSVG_FECOLORMATRIX_TYPE_LUMINANCETOALPHA, (intptr_t)0 },
    { "getPresentationAttribute", DontDelete|Function, (intptr_t)jsSVGFEColorMatrixElementPrototypeFunctionGetPresentationAttribute, (intptr_t)1 },
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSSVGFEColorMatrixElementPrototypeTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 63, JSSVGFEColorMatrixElementPrototypeTableValues, 0 };
#else
    { 17, 15, JSSVGFEColorMatrixElementPrototypeTableValues, 0 };
#endif

const ClassInfo JSSVGFEColorMatrixElementPrototype::s_info = { "SVGFEColorMatrixElementPrototype", 0, &JSSVGFEColorMatrixElementPrototypeTable, 0 };

JSObject* JSSVGFEColorMatrixElementPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSSVGFEColorMatrixElement>(exec, globalObject);
}

bool JSSVGFEColorMatrixElementPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticPropertySlot<JSSVGFEColorMatrixElementPrototype, JSObject>(exec, &JSSVGFEColorMatrixElementPrototypeTable, this, propertyName, slot);
}

bool JSSVGFEColorMatrixElementPrototype::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticPropertyDescriptor<JSSVGFEColorMatrixElementPrototype, JSObject>(exec, &JSSVGFEColorMatrixElementPrototypeTable, this, propertyName, descriptor);
}

const ClassInfo JSSVGFEColorMatrixElement::s_info = { "SVGFEColorMatrixElement", &JSSVGElement::s_info, &JSSVGFEColorMatrixElementTable, 0 };

JSSVGFEColorMatrixElement::JSSVGFEColorMatrixElement(NonNullPassRefPtr<Structure> structure, JSDOMGlobalObject* globalObject, PassRefPtr<SVGFEColorMatrixElement> impl)
    : JSSVGElement(structure, globalObject, impl)
{
}

JSObject* JSSVGFEColorMatrixElement::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return new (exec) JSSVGFEColorMatrixElementPrototype(JSSVGFEColorMatrixElementPrototype::createStructure(JSSVGElementPrototype::self(exec, globalObject)));
}

bool JSSVGFEColorMatrixElement::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGFEColorMatrixElement, Base>(exec, &JSSVGFEColorMatrixElementTable, this, propertyName, slot);
}

bool JSSVGFEColorMatrixElement::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSSVGFEColorMatrixElement, Base>(exec, &JSSVGFEColorMatrixElementTable, this, propertyName, descriptor);
}

JSValue jsSVGFEColorMatrixElementIn1(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGFEColorMatrixElement* castedThis = static_cast<JSSVGFEColorMatrixElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGFEColorMatrixElement* imp = static_cast<SVGFEColorMatrixElement*>(castedThis->impl());
    RefPtr<SVGAnimatedString> obj = imp->in1Animated();
    return toJS(exec, castedThis->globalObject(), obj.get(), imp);
}

JSValue jsSVGFEColorMatrixElementType(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGFEColorMatrixElement* castedThis = static_cast<JSSVGFEColorMatrixElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGFEColorMatrixElement* imp = static_cast<SVGFEColorMatrixElement*>(castedThis->impl());
    RefPtr<SVGAnimatedEnumeration> obj = imp->typeAnimated();
    return toJS(exec, castedThis->globalObject(), obj.get(), imp);
}

JSValue jsSVGFEColorMatrixElementValues(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGFEColorMatrixElement* castedThis = static_cast<JSSVGFEColorMatrixElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGFEColorMatrixElement* imp = static_cast<SVGFEColorMatrixElement*>(castedThis->impl());
    RefPtr<SVGAnimatedNumberList> obj = imp->valuesAnimated();
    return toJS(exec, castedThis->globalObject(), obj.get(), imp);
}

JSValue jsSVGFEColorMatrixElementX(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGFEColorMatrixElement* castedThis = static_cast<JSSVGFEColorMatrixElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGFEColorMatrixElement* imp = static_cast<SVGFEColorMatrixElement*>(castedThis->impl());
    RefPtr<SVGAnimatedLength> obj = imp->xAnimated();
    return toJS(exec, castedThis->globalObject(), obj.get(), imp);
}

JSValue jsSVGFEColorMatrixElementY(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGFEColorMatrixElement* castedThis = static_cast<JSSVGFEColorMatrixElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGFEColorMatrixElement* imp = static_cast<SVGFEColorMatrixElement*>(castedThis->impl());
    RefPtr<SVGAnimatedLength> obj = imp->yAnimated();
    return toJS(exec, castedThis->globalObject(), obj.get(), imp);
}

JSValue jsSVGFEColorMatrixElementWidth(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGFEColorMatrixElement* castedThis = static_cast<JSSVGFEColorMatrixElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGFEColorMatrixElement* imp = static_cast<SVGFEColorMatrixElement*>(castedThis->impl());
    RefPtr<SVGAnimatedLength> obj = imp->widthAnimated();
    return toJS(exec, castedThis->globalObject(), obj.get(), imp);
}

JSValue jsSVGFEColorMatrixElementHeight(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGFEColorMatrixElement* castedThis = static_cast<JSSVGFEColorMatrixElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGFEColorMatrixElement* imp = static_cast<SVGFEColorMatrixElement*>(castedThis->impl());
    RefPtr<SVGAnimatedLength> obj = imp->heightAnimated();
    return toJS(exec, castedThis->globalObject(), obj.get(), imp);
}

JSValue jsSVGFEColorMatrixElementResult(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGFEColorMatrixElement* castedThis = static_cast<JSSVGFEColorMatrixElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGFEColorMatrixElement* imp = static_cast<SVGFEColorMatrixElement*>(castedThis->impl());
    RefPtr<SVGAnimatedString> obj = imp->resultAnimated();
    return toJS(exec, castedThis->globalObject(), obj.get(), imp);
}

JSValue jsSVGFEColorMatrixElementClassName(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGFEColorMatrixElement* castedThis = static_cast<JSSVGFEColorMatrixElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGFEColorMatrixElement* imp = static_cast<SVGFEColorMatrixElement*>(castedThis->impl());
    RefPtr<SVGAnimatedString> obj = imp->classNameAnimated();
    return toJS(exec, castedThis->globalObject(), obj.get(), imp);
}

JSValue jsSVGFEColorMatrixElementStyle(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGFEColorMatrixElement* castedThis = static_cast<JSSVGFEColorMatrixElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGFEColorMatrixElement* imp = static_cast<SVGFEColorMatrixElement*>(castedThis->impl());
    return toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->style()));
}

JSValue jsSVGFEColorMatrixElementConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGFEColorMatrixElement* domObject = static_cast<JSSVGFEColorMatrixElement*>(asObject(slot.slotBase()));
    return JSSVGFEColorMatrixElement::getConstructor(exec, domObject->globalObject());
}
JSValue JSSVGFEColorMatrixElement::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSSVGFEColorMatrixElementConstructor>(exec, static_cast<JSDOMGlobalObject*>(globalObject));
}

JSValue JSC_HOST_CALL jsSVGFEColorMatrixElementPrototypeFunctionGetPresentationAttribute(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSSVGFEColorMatrixElement::s_info))
        return throwError(exec, TypeError);
    JSSVGFEColorMatrixElement* castedThisObj = static_cast<JSSVGFEColorMatrixElement*>(asObject(thisValue));
    SVGFEColorMatrixElement* imp = static_cast<SVGFEColorMatrixElement*>(castedThisObj->impl());
    const UString& name = args.at(0).toString(exec);


    JSC::JSValue result = toJS(exec, castedThisObj->globalObject(), WTF::getPtr(imp->getPresentationAttribute(name)));
    return result;
}

// Constant getters

JSValue jsSVGFEColorMatrixElementSVG_FECOLORMATRIX_TYPE_UNKNOWN(ExecState* exec, const Identifier&, const PropertySlot&)
{
    return jsNumber(exec, static_cast<int>(0));
}

JSValue jsSVGFEColorMatrixElementSVG_FECOLORMATRIX_TYPE_MATRIX(ExecState* exec, const Identifier&, const PropertySlot&)
{
    return jsNumber(exec, static_cast<int>(1));
}

JSValue jsSVGFEColorMatrixElementSVG_FECOLORMATRIX_TYPE_SATURATE(ExecState* exec, const Identifier&, const PropertySlot&)
{
    return jsNumber(exec, static_cast<int>(2));
}

JSValue jsSVGFEColorMatrixElementSVG_FECOLORMATRIX_TYPE_HUEROTATE(ExecState* exec, const Identifier&, const PropertySlot&)
{
    return jsNumber(exec, static_cast<int>(3));
}

JSValue jsSVGFEColorMatrixElementSVG_FECOLORMATRIX_TYPE_LUMINANCETOALPHA(ExecState* exec, const Identifier&, const PropertySlot&)
{
    return jsNumber(exec, static_cast<int>(4));
}


}

#endif // ENABLE(SVG) && ENABLE(FILTERS)
