/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(SVG)

#include "JSSVGPoint.h"

#include "JSSVGMatrix.h"
#include "JSSVGPoint.h"
#include <runtime/Error.h>
#include <runtime/JSNumberCell.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSSVGPoint);

/* Hash table */

static const HashTableValue JSSVGPointTableValues[3] =
{
    { "x", DontDelete, (intptr_t)jsSVGPointX, (intptr_t)setJSSVGPointX },
    { "y", DontDelete, (intptr_t)jsSVGPointY, (intptr_t)setJSSVGPointY },
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSSVGPointTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 1, JSSVGPointTableValues, 0 };
#else
    { 4, 3, JSSVGPointTableValues, 0 };
#endif

/* Hash table for prototype */

static const HashTableValue JSSVGPointPrototypeTableValues[2] =
{
    { "matrixTransform", DontDelete|Function, (intptr_t)jsSVGPointPrototypeFunctionMatrixTransform, (intptr_t)1 },
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSSVGPointPrototypeTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 0, JSSVGPointPrototypeTableValues, 0 };
#else
    { 2, 1, JSSVGPointPrototypeTableValues, 0 };
#endif

const ClassInfo JSSVGPointPrototype::s_info = { "SVGPointPrototype", 0, &JSSVGPointPrototypeTable, 0 };

JSObject* JSSVGPointPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSSVGPoint>(exec, globalObject);
}

bool JSSVGPointPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticFunctionSlot<JSObject>(exec, &JSSVGPointPrototypeTable, this, propertyName, slot);
}

bool JSSVGPointPrototype::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticFunctionDescriptor<JSObject>(exec, &JSSVGPointPrototypeTable, this, propertyName, descriptor);
}

const ClassInfo JSSVGPoint::s_info = { "SVGPoint", 0, &JSSVGPointTable, 0 };

JSSVGPoint::JSSVGPoint(NonNullPassRefPtr<Structure> structure, JSDOMGlobalObject* globalObject, PassRefPtr<JSSVGPODTypeWrapper<FloatPoint> > impl, SVGElement* context)
    : DOMObjectWithSVGContext(structure, globalObject, context)
    , m_impl(impl)
{
}

JSSVGPoint::~JSSVGPoint()
{
    forgetDOMObject(this, impl());
}

JSObject* JSSVGPoint::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return new (exec) JSSVGPointPrototype(JSSVGPointPrototype::createStructure(globalObject->objectPrototype()));
}

bool JSSVGPoint::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGPoint, Base>(exec, &JSSVGPointTable, this, propertyName, slot);
}

bool JSSVGPoint::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSSVGPoint, Base>(exec, &JSSVGPointTable, this, propertyName, descriptor);
}

JSValue jsSVGPointX(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGPoint* castedThis = static_cast<JSSVGPoint*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    FloatPoint imp(*castedThis->impl());
    return jsNumber(exec, imp.x());
}

JSValue jsSVGPointY(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGPoint* castedThis = static_cast<JSSVGPoint*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    FloatPoint imp(*castedThis->impl());
    return jsNumber(exec, imp.y());
}

void JSSVGPoint::put(ExecState* exec, const Identifier& propertyName, JSValue value, PutPropertySlot& slot)
{
    lookupPut<JSSVGPoint, Base>(exec, propertyName, value, &JSSVGPointTable, this, slot);
}

void setJSSVGPointX(ExecState* exec, JSObject* thisObject, JSValue value)
{
    FloatPoint imp(*static_cast<JSSVGPoint*>(thisObject)->impl());
    imp.setX(value.toFloat(exec));
        static_cast<JSSVGPoint*>(thisObject)->impl()->commitChange(imp, static_cast<JSSVGPoint*>(thisObject)->context());
}

void setJSSVGPointY(ExecState* exec, JSObject* thisObject, JSValue value)
{
    FloatPoint imp(*static_cast<JSSVGPoint*>(thisObject)->impl());
    imp.setY(value.toFloat(exec));
        static_cast<JSSVGPoint*>(thisObject)->impl()->commitChange(imp, static_cast<JSSVGPoint*>(thisObject)->context());
}

JSValue JSC_HOST_CALL jsSVGPointPrototypeFunctionMatrixTransform(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSSVGPoint::s_info))
        return throwError(exec, TypeError);
    JSSVGPoint* castedThisObj = static_cast<JSSVGPoint*>(asObject(thisValue));
    JSSVGPODTypeWrapper<FloatPoint>* wrapper = castedThisObj->impl();
    FloatPoint imp(*wrapper);
    TransformationMatrix matrix = toSVGMatrix(args.at(0));


    JSC::JSValue result = toJS(exec, deprecatedGlobalObjectForPrototype(exec), JSSVGStaticPODTypeWrapper<FloatPoint>::create(imp.matrixTransform(matrix)).get(), castedThisObj->context());
    wrapper->commitChange(imp, castedThisObj->context());
    return result;
}

JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, JSSVGPODTypeWrapper<FloatPoint>* object, SVGElement* context)
{
    return getDOMObjectWrapper<JSSVGPoint, JSSVGPODTypeWrapper<FloatPoint> >(exec, globalObject, object, context);
}
FloatPoint toSVGPoint(JSC::JSValue value)
{
    return value.inherits(&JSSVGPoint::s_info) ? (FloatPoint) *static_cast<JSSVGPoint*>(asObject(value))->impl() : FloatPoint();
}

}

#endif // ENABLE(SVG)
