
/*
Copyright (c) 2019 The Khronos Group Inc.
Use of this source code is governed by an MIT-style license that can be
found in the LICENSE.txt file.
*/


#ifdef GL_ES
precision mediump float;
#endif
varying vec4 color;

// Function declaration.
vec4 function(out vec4 par);
bool is_all(const in vec4 par, const in float value);
void set_all(out vec4 par, const in float value);

void main (void)
{
	vec4 par = vec4(1.0, 1.0, 1.0, 1.0);
	vec4 ret = vec4(0.0, 0.0, 0.0, 0.0);

	float gray = 0.0;

	ret = function(par);

	// The parameter should be changed by the function and the function should return 1.0.
	if(is_all(par, 0.0) && is_all(ret, 1.0))
	{
		gray = 1.0;
	}

	gl_FragColor = vec4(gray, gray, gray, 1.0);
}

// Function definition.
vec4 function(out vec4 par)
{
	// Test parameter qualifier (default is "in").
	set_all(par, 0.0);

	return vec4(1.0, 1.0, 1.0, 1.0);
}

bool is_all(const in vec4 par, const in float value)
{
	bool ret = true;

	if(par[0] != value)
		ret = false;
	if(par[1] != value)
		ret = false;
	if(par[2] != value)
		ret = false;
	if(par[3] != value)
		ret = false;

	return ret;
}

void set_all(out vec4 par, const in float value)
{
	par[0] = value;
	par[1] = value;
	par[2] = value;
	par[3] = value;
}
