/* This file is automatically generated by aarch64-gen.  Do not edit!  */
/* Copyright (C) 2012-2016 Free Software Foundation, Inc.
   Contributed by ARM Ltd.

   This file is part of the GNU opcodes library.

   This library is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3, or (at your option)
   any later version.

   It is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
   or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public
   License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; see the file COPYING3. If not,
   see <http://www.gnu.org/licenses/>.  */

#include "sysdep.h"
#include "aarch64-dis.h"

/* Called by aarch64_opcode_lookup.  */

static int
aarch64_opcode_lookup_1 (uint32_t word)
{
  if (((word >> 26) & 0x1) == 0)
    {
      if (((word >> 25) & 0x1) == 0)
        {
          if (((word >> 27) & 0x1) == 0)
            {
              if (((word >> 24) & 0x1) == 0)
                {
                  if (((word >> 31) & 0x1) == 0)
                    {
                      /* 33222222222211111111110000000000
                         10987654321098765432109876543210
                         xxxxxxxxxxxxxxxxxxxxxxxx0000xxx0
                         adr.  */
                      return 1115;
                    }
                  else
                    {
                      /* 33222222222211111111110000000000
                         10987654321098765432109876543210
                         xxxxxxxxxxxxxxxxxxxxxxxx0000xxx1
                         adrp.  */
                      return 1116;
                    }
                }
              else
                {
                  if (((word >> 29) & 0x1) == 0)
                    {
                      if (((word >> 30) & 0x1) == 0)
                        {
                          /* 33222222222211111111110000000000
                             10987654321098765432109876543210
                             xxxxxxxxxxxxxxxxxxxxxxxx1000x00x
                             add.  */
                          return 12;
                        }
                      else
                        {
                          /* 33222222222211111111110000000000
                             10987654321098765432109876543210
                             xxxxxxxxxxxxxxxxxxxxxxxx1000x01x
                             sub.  */
                          return 16;
                        }
                    }
                  else
                    {
                      if (((word >> 30) & 0x1) == 0)
                        {
                          /* 33222222222211111111110000000000
                             10987654321098765432109876543210
                             xxxxxxxxxxxxxxxxxxxxxxxx1000x10x
                             adds.  */
                          return 14;
                        }
                      else
                        {
                          /* 33222222222211111111110000000000
                             10987654321098765432109876543210
                             xxxxxxxxxxxxxxxxxxxxxxxx1000x11x
                             subs.  */
                          return 17;
                        }
                    }
                }
            }
          else
            {
              if (((word >> 28) & 0x1) == 0)
                {
                  if (((word >> 22) & 0x1) == 0)
                    {
                      if (((word >> 23) & 0x1) == 0)
                        {
                          if (((word >> 29) & 0x1) == 0)
                            {
                              if (((word >> 15) & 0x1) == 0)
                                {
                                  if (((word >> 21) & 0x1) == 0)
                                    {
                                      if (((word >> 31) & 0x1) == 0)
                                        {
                                          if (((word >> 30) & 0x1) == 0)
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 xxxxxxxxxxxxxxx0xxxxx000x0010000
                                                 stxrb.  */
                                              return 873;
                                            }
                                          else
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 xxxxxxxxxxxxxxx0xxxxx000x0010010
                                                 stxrh.  */
                                              return 879;
                                            }
                                        }
                                      else
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             xxxxxxxxxxxxxxx0xxxxx000x00100x1
                                             stxr.  */
                                          return 885;
                                        }
                                    }
                                  else
                                    {
                                      if (((word >> 31) & 0x1) == 0)
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             xxxxxxxxxxxxxxx0xxxxx100x00100x0
                                             casp.  */
                                          return 950;
                                        }
                                      else
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             xxxxxxxxxxxxxxx0xxxxx100x00100x1
                                             stxp.  */
                                          return 887;
                                        }
                                    }
                                }
                              else
                                {
                                  if (((word >> 21) & 0x1) == 0)
                                    {
                                      if (((word >> 31) & 0x1) == 0)
                                        {
                                          if (((word >> 30) & 0x1) == 0)
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 xxxxxxxxxxxxxxx1xxxxx000x0010000
                                                 stlxrb.  */
                                              return 874;
                                            }
                                          else
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 xxxxxxxxxxxxxxx1xxxxx000x0010010
                                                 stlxrh.  */
                                              return 880;
                                            }
                                        }
                                      else
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             xxxxxxxxxxxxxxx1xxxxx000x00100x1
                                             stlxr.  */
                                          return 886;
                                        }
                                    }
                                  else
                                    {
                                      if (((word >> 31) & 0x1) == 0)
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             xxxxxxxxxxxxxxx1xxxxx100x00100x0
                                             caspl.  */
                                          return 952;
                                        }
                                      else
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             xxxxxxxxxxxxxxx1xxxxx100x00100x1
                                             stlxp.  */
                                          return 888;
                                        }
                                    }
                                }
                            }
                          else
                            {
                              /* 33222222222211111111110000000000
                                 10987654321098765432109876543210
                                 xxxxxxxxxxxxxxxxxxxxxx00x00101xx
                                 stnp.  */
                              return 901;
                            }
                        }
                      else
                        {
                          if (((word >> 29) & 0x1) == 0)
                            {
                              if (((word >> 15) & 0x1) == 0)
                                {
                                  if (((word >> 21) & 0x1) == 0)
                                    {
                                      if (((word >> 31) & 0x1) == 0)
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             xxxxxxxxxxxxxxx0xxxxx001x00100x0
                                             stllrb.  */
                                          return 899;
                                        }
                                      else
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             xxxxxxxxxxxxxxx0xxxxx001x00100x1
                                             stllr.  */
                                          return 898;
                                        }
                                    }
                                  else
                                    {
                                      if (((word >> 31) & 0x1) == 0)
                                        {
                                          if (((word >> 30) & 0x1) == 0)
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 xxxxxxxxxxxxxxx0xxxxx101x0010000
                                                 casb.  */
                                              return 938;
                                            }
                                          else
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 xxxxxxxxxxxxxxx0xxxxx101x0010010
                                                 cash.  */
                                              return 939;
                                            }
                                        }
                                      else
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             xxxxxxxxxxxxxxx0xxxxx101x00100x1
                                             cas.  */
                                          return 940;
                                        }
                                    }
                                }
                              else
                                {
                                  if (((word >> 21) & 0x1) == 0)
                                    {
                                      if (((word >> 31) & 0x1) == 0)
                                        {
                                          if (((word >> 30) & 0x1) == 0)
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 xxxxxxxxxxxxxxx1xxxxx001x0010000
                                                 stlrb.  */
                                              return 877;
                                            }
                                          else
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 xxxxxxxxxxxxxxx1xxxxx001x0010010
                                                 stlrh.  */
                                              return 883;
                                            }
                                        }
                                      else
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             xxxxxxxxxxxxxxx1xxxxx001x00100x1
                                             stlr.  */
                                          return 893;
                                        }
                                    }
                                  else
                                    {
                                      if (((word >> 31) & 0x1) == 0)
                                        {
                                          if (((word >> 30) & 0x1) == 0)
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 xxxxxxxxxxxxxxx1xxxxx101x0010000
                                                 caslb.  */
                                              return 942;
                                            }
                                          else
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 xxxxxxxxxxxxxxx1xxxxx101x0010010
                                                 caslh.  */
                                              return 945;
                                            }
                                        }
                                      else
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             xxxxxxxxxxxxxxx1xxxxx101x00100x1
                                             casl.  */
                                          return 948;
                                        }
                                    }
                                }
                            }
                          else
                            {
                              /* 33222222222211111111110000000000
                                 10987654321098765432109876543210
                                 xxxxxxxxxxxxxxxxxxxxxx01x00101xx
                                 stp.  */
                              return 910;
                            }
                        }
                    }
                  else
                    {
                      if (((word >> 23) & 0x1) == 0)
                        {
                          if (((word >> 29) & 0x1) == 0)
                            {
                              if (((word >> 15) & 0x1) == 0)
                                {
                                  if (((word >> 21) & 0x1) == 0)
                                    {
                                      if (((word >> 31) & 0x1) == 0)
                                        {
                                          if (((word >> 30) & 0x1) == 0)
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 xxxxxxxxxxxxxxx0xxxxx010x0010000
                                                 ldxrb.  */
                                              return 875;
                                            }
                                          else
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 xxxxxxxxxxxxxxx0xxxxx010x0010010
                                                 ldxrh.  */
                                              return 881;
                                            }
                                        }
                                      else
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             xxxxxxxxxxxxxxx0xxxxx010x00100x1
                                             ldxr.  */
                                          return 889;
                                        }
                                    }
                                  else
                                    {
                                      if (((word >> 31) & 0x1) == 0)
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             xxxxxxxxxxxxxxx0xxxxx110x00100x0
                                             caspa.  */
                                          return 951;
                                        }
                                      else
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             xxxxxxxxxxxxxxx0xxxxx110x00100x1
                                             ldxp.  */
                                          return 891;
                                        }
                                    }
                                }
                              else
                                {
                                  if (((word >> 21) & 0x1) == 0)
                                    {
                                      if (((word >> 31) & 0x1) == 0)
                                        {
                                          if (((word >> 30) & 0x1) == 0)
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 xxxxxxxxxxxxxxx1xxxxx010x0010000
                                                 ldaxrb.  */
                                              return 876;
                                            }
                                          else
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 xxxxxxxxxxxxxxx1xxxxx010x0010010
                                                 ldaxrh.  */
                                              return 882;
                                            }
                                        }
                                      else
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             xxxxxxxxxxxxxxx1xxxxx010x00100x1
                                             ldaxr.  */
                                          return 890;
                                        }
                                    }
                                  else
                                    {
                                      if (((word >> 31) & 0x1) == 0)
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             xxxxxxxxxxxxxxx1xxxxx110x00100x0
                                             caspal.  */
                                          return 953;
                                        }
                                      else
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             xxxxxxxxxxxxxxx1xxxxx110x00100x1
                                             ldaxp.  */
                                          return 892;
                                        }
                                    }
                                }
                            }
                          else
                            {
                              if (((word >> 30) & 0x1) == 0)
                                {
                                  /* 33222222222211111111110000000000
                                     10987654321098765432109876543210
                                     xxxxxxxxxxxxxxxxxxxxxx10x001010x
                                     ldnp.  */
                                  return 902;
                                }
                              else
                                {
                                  /* 33222222222211111111110000000000
                                     10987654321098765432109876543210
                                     xxxxxxxxxxxxxxxxxxxxxx10x001011x
                                     ldpsw.  */
                                  return 909;
                                }
                            }
                        }
                      else
                        {
                          if (((word >> 29) & 0x1) == 0)
                            {
                              if (((word >> 15) & 0x1) == 0)
                                {
                                  if (((word >> 21) & 0x1) == 0)
                                    {
                                      if (((word >> 31) & 0x1) == 0)
                                        {
                                          if (((word >> 30) & 0x1) == 0)
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 xxxxxxxxxxxxxxx0xxxxx011x0010000
                                                 ldlarb.  */
                                              return 896;
                                            }
                                          else
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 xxxxxxxxxxxxxxx0xxxxx011x0010010
                                                 ldlarh.  */
                                              return 897;
                                            }
                                        }
                                      else
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             xxxxxxxxxxxxxxx0xxxxx011x00100x1
                                             ldlar.  */
                                          return 895;
                                        }
                                    }
                                  else
                                    {
                                      if (((word >> 31) & 0x1) == 0)
                                        {
                                          if (((word >> 30) & 0x1) == 0)
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 xxxxxxxxxxxxxxx0xxxxx111x0010000
                                                 casab.  */
                                              return 941;
                                            }
                                          else
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 xxxxxxxxxxxxxxx0xxxxx111x0010010
                                                 casah.  */
                                              return 944;
                                            }
                                        }
                                      else
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             xxxxxxxxxxxxxxx0xxxxx111x00100x1
                                             casa.  */
                                          return 947;
                                        }
                                    }
                                }
                              else
                                {
                                  if (((word >> 21) & 0x1) == 0)
                                    {
                                      if (((word >> 31) & 0x1) == 0)
                                        {
                                          if (((word >> 30) & 0x1) == 0)
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 xxxxxxxxxxxxxxx1xxxxx011x0010000
                                                 ldarb.  */
                                              return 878;
                                            }
                                          else
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 xxxxxxxxxxxxxxx1xxxxx011x0010010
                                                 ldarh.  */
                                              return 884;
                                            }
                                        }
                                      else
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             xxxxxxxxxxxxxxx1xxxxx011x00100x1
                                             ldar.  */
                                          return 894;
                                        }
                                    }
                                  else
                                    {
                                      if (((word >> 31) & 0x1) == 0)
                                        {
                                          if (((word >> 30) & 0x1) == 0)
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 xxxxxxxxxxxxxxx1xxxxx111x0010000
                                                 casalb.  */
                                              return 943;
                                            }
                                          else
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 xxxxxxxxxxxxxxx1xxxxx111x0010010
                                                 casalh.  */
                                              return 946;
                                            }
                                        }
                                      else
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             xxxxxxxxxxxxxxx1xxxxx111x00100x1
                                             casal.  */
                                          return 949;
                                        }
                                    }
                                }
                            }
                          else
                            {
                              if (((word >> 30) & 0x1) == 0)
                                {
                                  /* 33222222222211111111110000000000
                                     10987654321098765432109876543210
                                     xxxxxxxxxxxxxxxxxxxxxx11x001010x
                                     ldp.  */
                                  return 911;
                                }
                              else
                                {
                                  /* 33222222222211111111110000000000
                                     10987654321098765432109876543210
                                     xxxxxxxxxxxxxxxxxxxxxx11x001011x
                                     ldpsw.  */
                                  return 914;
                                }
                            }
                        }
                    }
                }
              else
                {
                  if (((word >> 24) & 0x1) == 0)
                    {
                      if (((word >> 29) & 0x1) == 0)
                        {
                          if (((word >> 31) & 0x1) == 0)
                            {
                              /* 33222222222211111111110000000000
                                 10987654321098765432109876543210
                                 xxxxxxxxxxxxxxxxxxxxxxxx000110x0
                                 ldr.  */
                              return 915;
                            }
                          else
                            {
                              if (((word >> 30) & 0x1) == 0)
                                {
                                  /* 33222222222211111111110000000000
                                     10987654321098765432109876543210
                                     xxxxxxxxxxxxxxxxxxxxxxxx00011001
                                     ldrsw.  */
                                  return 917;
                                }
                              else
                                {
                                  /* 33222222222211111111110000000000
                                     10987654321098765432109876543210
                                     xxxxxxxxxxxxxxxxxxxxxxxx00011011
                                     prfm.  */
                                  return 918;
                                }
                            }
                        }
                      else
                        {
                          if (((word >> 10) & 0x1) == 0)
                            {
                              if (((word >> 11) & 0x1) == 0)
                                {
                                  if (((word >> 21) & 0x1) == 0)
                                    {
                                      if (((word >> 23) & 0x1) == 0)
                                        {
                                          if (((word >> 22) & 0x1) == 0)
                                            {
                                              if (((word >> 31) & 0x1) == 0)
                                                {
                                                  if (((word >> 30) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx00xxxxxxxxx00000011100
                                                         sturb.  */
                                                      return 861;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx00xxxxxxxxx00000011110
                                                         sturh.  */
                                                      return 866;
                                                    }
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     xxxxxxxxxx00xxxxxxxxx000000111x1
                                                     stur.  */
                                                  return 869;
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 31) & 0x1) == 0)
                                                {
                                                  if (((word >> 30) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx00xxxxxxxxx01000011100
                                                         ldurb.  */
                                                      return 862;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx00xxxxxxxxx01000011110
                                                         ldurh.  */
                                                      return 867;
                                                    }
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     xxxxxxxxxx00xxxxxxxxx010000111x1
                                                     ldur.  */
                                                  return 870;
                                                }
                                            }
                                        }
                                      else
                                        {
                                          if (((word >> 30) & 0x1) == 0)
                                            {
                                              if (((word >> 31) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     xxxxxxxxxx00xxxxxxxxx0x100011100
                                                     ldursb.  */
                                                  return 863;
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     xxxxxxxxxx00xxxxxxxxx0x100011101
                                                     ldursw.  */
                                                  return 871;
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 31) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     xxxxxxxxxx00xxxxxxxxx0x100011110
                                                     ldursh.  */
                                                  return 868;
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     xxxxxxxxxx00xxxxxxxxx0x100011111
                                                     prfum.  */
                                                  return 872;
                                                }
                                            }
                                        }
                                    }
                                  else
                                    {
                                      if (((word >> 12) & 0x1) == 0)
                                        {
                                          if (((word >> 13) & 0x1) == 0)
                                            {
                                              if (((word >> 14) & 0x1) == 0)
                                                {
                                                  if (((word >> 15) & 0x1) == 0)
                                                    {
                                                      if (((word >> 22) & 0x1) == 0)
                                                        {
                                                          if (((word >> 23) & 0x1) == 0)
                                                            {
                                                              if (((word >> 31) & 0x1) == 0)
                                                                {
                                                                  if (((word >> 30) & 0x1) == 0)
                                                                    {
                                                                      /* 33222222222211111111110000000000
                                                                         10987654321098765432109876543210
                                                                         xxxxxxxxxx000000xxxxx10000011100
                                                                         ldaddb.  */
                                                                      return 966;
                                                                    }
                                                                  else
                                                                    {
                                                                      /* 33222222222211111111110000000000
                                                                         10987654321098765432109876543210
                                                                         xxxxxxxxxx000000xxxxx10000011110
                                                                         ldaddh.  */
                                                                      return 967;
                                                                    }
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     xxxxxxxxxx000000xxxxx100000111x1
                                                                     ldadd.  */
                                                                  return 968;
                                                                }
                                                            }
                                                          else
                                                            {
                                                              if (((word >> 31) & 0x1) == 0)
                                                                {
                                                                  if (((word >> 30) & 0x1) == 0)
                                                                    {
                                                                      /* 33222222222211111111110000000000
                                                                         10987654321098765432109876543210
                                                                         xxxxxxxxxx000000xxxxx10100011100
                                                                         ldaddab.  */
                                                                      return 969;
                                                                    }
                                                                  else
                                                                    {
                                                                      /* 33222222222211111111110000000000
                                                                         10987654321098765432109876543210
                                                                         xxxxxxxxxx000000xxxxx10100011110
                                                                         ldaddah.  */
                                                                      return 972;
                                                                    }
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     xxxxxxxxxx000000xxxxx101000111x1
                                                                     ldadda.  */
                                                                  return 975;
                                                                }
                                                            }
                                                        }
                                                      else
                                                        {
                                                          if (((word >> 23) & 0x1) == 0)
                                                            {
                                                              if (((word >> 31) & 0x1) == 0)
                                                                {
                                                                  if (((word >> 30) & 0x1) == 0)
                                                                    {
                                                                      /* 33222222222211111111110000000000
                                                                         10987654321098765432109876543210
                                                                         xxxxxxxxxx000000xxxxx11000011100
                                                                         ldaddlb.  */
                                                                      return 970;
                                                                    }
                                                                  else
                                                                    {
                                                                      /* 33222222222211111111110000000000
                                                                         10987654321098765432109876543210
                                                                         xxxxxxxxxx000000xxxxx11000011110
                                                                         ldaddlh.  */
                                                                      return 973;
                                                                    }
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     xxxxxxxxxx000000xxxxx110000111x1
                                                                     ldaddl.  */
                                                                  return 976;
                                                                }
                                                            }
                                                          else
                                                            {
                                                              if (((word >> 31) & 0x1) == 0)
                                                                {
                                                                  if (((word >> 30) & 0x1) == 0)
                                                                    {
                                                                      /* 33222222222211111111110000000000
                                                                         10987654321098765432109876543210
                                                                         xxxxxxxxxx000000xxxxx11100011100
                                                                         ldaddalb.  */
                                                                      return 971;
                                                                    }
                                                                  else
                                                                    {
                                                                      /* 33222222222211111111110000000000
                                                                         10987654321098765432109876543210
                                                                         xxxxxxxxxx000000xxxxx11100011110
                                                                         ldaddalh.  */
                                                                      return 974;
                                                                    }
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     xxxxxxxxxx000000xxxxx111000111x1
                                                                     ldaddal.  */
                                                                  return 977;
                                                                }
                                                            }
                                                        }
                                                    }
                                                  else
                                                    {
                                                      if (((word >> 22) & 0x1) == 0)
                                                        {
                                                          if (((word >> 23) & 0x1) == 0)
                                                            {
                                                              if (((word >> 31) & 0x1) == 0)
                                                                {
                                                                  if (((word >> 30) & 0x1) == 0)
                                                                    {
                                                                      /* 33222222222211111111110000000000
                                                                         10987654321098765432109876543210
                                                                         xxxxxxxxxx000001xxxxx10000011100
                                                                         swpb.  */
                                                                      return 954;
                                                                    }
                                                                  else
                                                                    {
                                                                      /* 33222222222211111111110000000000
                                                                         10987654321098765432109876543210
                                                                         xxxxxxxxxx000001xxxxx10000011110
                                                                         swph.  */
                                                                      return 955;
                                                                    }
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     xxxxxxxxxx000001xxxxx100000111x1
                                                                     swp.  */
                                                                  return 956;
                                                                }
                                                            }
                                                          else
                                                            {
                                                              if (((word >> 31) & 0x1) == 0)
                                                                {
                                                                  if (((word >> 30) & 0x1) == 0)
                                                                    {
                                                                      /* 33222222222211111111110000000000
                                                                         10987654321098765432109876543210
                                                                         xxxxxxxxxx000001xxxxx10100011100
                                                                         swpab.  */
                                                                      return 957;
                                                                    }
                                                                  else
                                                                    {
                                                                      /* 33222222222211111111110000000000
                                                                         10987654321098765432109876543210
                                                                         xxxxxxxxxx000001xxxxx10100011110
                                                                         swpah.  */
                                                                      return 960;
                                                                    }
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     xxxxxxxxxx000001xxxxx101000111x1
                                                                     swpa.  */
                                                                  return 963;
                                                                }
                                                            }
                                                        }
                                                      else
                                                        {
                                                          if (((word >> 23) & 0x1) == 0)
                                                            {
                                                              if (((word >> 31) & 0x1) == 0)
                                                                {
                                                                  if (((word >> 30) & 0x1) == 0)
                                                                    {
                                                                      /* 33222222222211111111110000000000
                                                                         10987654321098765432109876543210
                                                                         xxxxxxxxxx000001xxxxx11000011100
                                                                         swplb.  */
                                                                      return 958;
                                                                    }
                                                                  else
                                                                    {
                                                                      /* 33222222222211111111110000000000
                                                                         10987654321098765432109876543210
                                                                         xxxxxxxxxx000001xxxxx11000011110
                                                                         swplh.  */
                                                                      return 961;
                                                                    }
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     xxxxxxxxxx000001xxxxx110000111x1
                                                                     swpl.  */
                                                                  return 964;
                                                                }
                                                            }
                                                          else
                                                            {
                                                              if (((word >> 31) & 0x1) == 0)
                                                                {
                                                                  if (((word >> 30) & 0x1) == 0)
                                                                    {
                                                                      /* 33222222222211111111110000000000
                                                                         10987654321098765432109876543210
                                                                         xxxxxxxxxx000001xxxxx11100011100
                                                                         swpalb.  */
                                                                      return 959;
                                                                    }
                                                                  else
                                                                    {
                                                                      /* 33222222222211111111110000000000
                                                                         10987654321098765432109876543210
                                                                         xxxxxxxxxx000001xxxxx11100011110
                                                                         swpalh.  */
                                                                      return 962;
                                                                    }
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     xxxxxxxxxx000001xxxxx111000111x1
                                                                     swpal.  */
                                                                  return 965;
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 22) & 0x1) == 0)
                                                    {
                                                      if (((word >> 23) & 0x1) == 0)
                                                        {
                                                          if (((word >> 31) & 0x1) == 0)
                                                            {
                                                              if (((word >> 30) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     xxxxxxxxxx00001xxxxxx10000011100
                                                                     ldsmaxb.  */
                                                                  return 1014;
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     xxxxxxxxxx00001xxxxxx10000011110
                                                                     ldsmaxh.  */
                                                                  return 1015;
                                                                }
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx00001xxxxxx100000111x1
                                                                 ldsmax.  */
                                                              return 1016;
                                                            }
                                                        }
                                                      else
                                                        {
                                                          if (((word >> 31) & 0x1) == 0)
                                                            {
                                                              if (((word >> 30) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     xxxxxxxxxx00001xxxxxx10100011100
                                                                     ldsmaxab.  */
                                                                  return 1017;
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     xxxxxxxxxx00001xxxxxx10100011110
                                                                     ldsmaxah.  */
                                                                  return 1020;
                                                                }
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx00001xxxxxx101000111x1
                                                                 ldsmaxa.  */
                                                              return 1023;
                                                            }
                                                        }
                                                    }
                                                  else
                                                    {
                                                      if (((word >> 23) & 0x1) == 0)
                                                        {
                                                          if (((word >> 31) & 0x1) == 0)
                                                            {
                                                              if (((word >> 30) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     xxxxxxxxxx00001xxxxxx11000011100
                                                                     ldsmaxlb.  */
                                                                  return 1018;
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     xxxxxxxxxx00001xxxxxx11000011110
                                                                     ldsmaxlh.  */
                                                                  return 1021;
                                                                }
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx00001xxxxxx110000111x1
                                                                 ldsmaxl.  */
                                                              return 1024;
                                                            }
                                                        }
                                                      else
                                                        {
                                                          if (((word >> 31) & 0x1) == 0)
                                                            {
                                                              if (((word >> 30) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     xxxxxxxxxx00001xxxxxx11100011100
                                                                     ldsmaxalb.  */
                                                                  return 1019;
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     xxxxxxxxxx00001xxxxxx11100011110
                                                                     ldsmaxalh.  */
                                                                  return 1022;
                                                                }
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx00001xxxxxx111000111x1
                                                                 ldsmaxal.  */
                                                              return 1025;
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 14) & 0x1) == 0)
                                                {
                                                  if (((word >> 22) & 0x1) == 0)
                                                    {
                                                      if (((word >> 23) & 0x1) == 0)
                                                        {
                                                          if (((word >> 31) & 0x1) == 0)
                                                            {
                                                              if (((word >> 30) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     xxxxxxxxxx00010xxxxxx10000011100
                                                                     ldeorb.  */
                                                                  return 990;
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     xxxxxxxxxx00010xxxxxx10000011110
                                                                     ldeorh.  */
                                                                  return 991;
                                                                }
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx00010xxxxxx100000111x1
                                                                 ldeor.  */
                                                              return 992;
                                                            }
                                                        }
                                                      else
                                                        {
                                                          if (((word >> 31) & 0x1) == 0)
                                                            {
                                                              if (((word >> 30) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     xxxxxxxxxx00010xxxxxx10100011100
                                                                     ldeorab.  */
                                                                  return 993;
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     xxxxxxxxxx00010xxxxxx10100011110
                                                                     ldeorah.  */
                                                                  return 996;
                                                                }
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx00010xxxxxx101000111x1
                                                                 ldeora.  */
                                                              return 999;
                                                            }
                                                        }
                                                    }
                                                  else
                                                    {
                                                      if (((word >> 23) & 0x1) == 0)
                                                        {
                                                          if (((word >> 31) & 0x1) == 0)
                                                            {
                                                              if (((word >> 30) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     xxxxxxxxxx00010xxxxxx11000011100
                                                                     ldeorlb.  */
                                                                  return 994;
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     xxxxxxxxxx00010xxxxxx11000011110
                                                                     ldeorlh.  */
                                                                  return 997;
                                                                }
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx00010xxxxxx110000111x1
                                                                 ldeorl.  */
                                                              return 1000;
                                                            }
                                                        }
                                                      else
                                                        {
                                                          if (((word >> 31) & 0x1) == 0)
                                                            {
                                                              if (((word >> 30) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     xxxxxxxxxx00010xxxxxx11100011100
                                                                     ldeoralb.  */
                                                                  return 995;
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     xxxxxxxxxx00010xxxxxx11100011110
                                                                     ldeoralh.  */
                                                                  return 998;
                                                                }
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx00010xxxxxx111000111x1
                                                                 ldeoral.  */
                                                              return 1001;
                                                            }
                                                        }
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 22) & 0x1) == 0)
                                                    {
                                                      if (((word >> 23) & 0x1) == 0)
                                                        {
                                                          if (((word >> 31) & 0x1) == 0)
                                                            {
                                                              if (((word >> 30) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     xxxxxxxxxx00011xxxxxx10000011100
                                                                     ldumaxb.  */
                                                                  return 1038;
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     xxxxxxxxxx00011xxxxxx10000011110
                                                                     ldumaxh.  */
                                                                  return 1039;
                                                                }
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx00011xxxxxx100000111x1
                                                                 ldumax.  */
                                                              return 1040;
                                                            }
                                                        }
                                                      else
                                                        {
                                                          if (((word >> 31) & 0x1) == 0)
                                                            {
                                                              if (((word >> 30) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     xxxxxxxxxx00011xxxxxx10100011100
                                                                     ldumaxab.  */
                                                                  return 1041;
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     xxxxxxxxxx00011xxxxxx10100011110
                                                                     ldumaxah.  */
                                                                  return 1044;
                                                                }
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx00011xxxxxx101000111x1
                                                                 ldumaxa.  */
                                                              return 1047;
                                                            }
                                                        }
                                                    }
                                                  else
                                                    {
                                                      if (((word >> 23) & 0x1) == 0)
                                                        {
                                                          if (((word >> 31) & 0x1) == 0)
                                                            {
                                                              if (((word >> 30) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     xxxxxxxxxx00011xxxxxx11000011100
                                                                     ldumaxlb.  */
                                                                  return 1042;
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     xxxxxxxxxx00011xxxxxx11000011110
                                                                     ldumaxlh.  */
                                                                  return 1045;
                                                                }
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx00011xxxxxx110000111x1
                                                                 ldumaxl.  */
                                                              return 1048;
                                                            }
                                                        }
                                                      else
                                                        {
                                                          if (((word >> 31) & 0x1) == 0)
                                                            {
                                                              if (((word >> 30) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     xxxxxxxxxx00011xxxxxx11100011100
                                                                     ldumaxalb.  */
                                                                  return 1043;
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     xxxxxxxxxx00011xxxxxx11100011110
                                                                     ldumaxalh.  */
                                                                  return 1046;
                                                                }
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx00011xxxxxx111000111x1
                                                                 ldumaxal.  */
                                                              return 1049;
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                      else
                                        {
                                          if (((word >> 13) & 0x1) == 0)
                                            {
                                              if (((word >> 14) & 0x1) == 0)
                                                {
                                                  if (((word >> 22) & 0x1) == 0)
                                                    {
                                                      if (((word >> 23) & 0x1) == 0)
                                                        {
                                                          if (((word >> 31) & 0x1) == 0)
                                                            {
                                                              if (((word >> 30) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     xxxxxxxxxx00100xxxxxx10000011100
                                                                     ldclrb.  */
                                                                  return 978;
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     xxxxxxxxxx00100xxxxxx10000011110
                                                                     ldclrh.  */
                                                                  return 979;
                                                                }
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx00100xxxxxx100000111x1
                                                                 ldclr.  */
                                                              return 980;
                                                            }
                                                        }
                                                      else
                                                        {
                                                          if (((word >> 31) & 0x1) == 0)
                                                            {
                                                              if (((word >> 30) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     xxxxxxxxxx00100xxxxxx10100011100
                                                                     ldclrab.  */
                                                                  return 981;
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     xxxxxxxxxx00100xxxxxx10100011110
                                                                     ldclrah.  */
                                                                  return 984;
                                                                }
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx00100xxxxxx101000111x1
                                                                 ldclra.  */
                                                              return 987;
                                                            }
                                                        }
                                                    }
                                                  else
                                                    {
                                                      if (((word >> 23) & 0x1) == 0)
                                                        {
                                                          if (((word >> 31) & 0x1) == 0)
                                                            {
                                                              if (((word >> 30) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     xxxxxxxxxx00100xxxxxx11000011100
                                                                     ldclrlb.  */
                                                                  return 982;
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     xxxxxxxxxx00100xxxxxx11000011110
                                                                     ldclrlh.  */
                                                                  return 985;
                                                                }
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx00100xxxxxx110000111x1
                                                                 ldclrl.  */
                                                              return 988;
                                                            }
                                                        }
                                                      else
                                                        {
                                                          if (((word >> 31) & 0x1) == 0)
                                                            {
                                                              if (((word >> 30) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     xxxxxxxxxx00100xxxxxx11100011100
                                                                     ldclralb.  */
                                                                  return 983;
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     xxxxxxxxxx00100xxxxxx11100011110
                                                                     ldclralh.  */
                                                                  return 986;
                                                                }
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx00100xxxxxx111000111x1
                                                                 ldclral.  */
                                                              return 989;
                                                            }
                                                        }
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 22) & 0x1) == 0)
                                                    {
                                                      if (((word >> 23) & 0x1) == 0)
                                                        {
                                                          if (((word >> 31) & 0x1) == 0)
                                                            {
                                                              if (((word >> 30) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     xxxxxxxxxx00101xxxxxx10000011100
                                                                     ldsminb.  */
                                                                  return 1026;
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     xxxxxxxxxx00101xxxxxx10000011110
                                                                     ldsminh.  */
                                                                  return 1027;
                                                                }
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx00101xxxxxx100000111x1
                                                                 ldsmin.  */
                                                              return 1028;
                                                            }
                                                        }
                                                      else
                                                        {
                                                          if (((word >> 31) & 0x1) == 0)
                                                            {
                                                              if (((word >> 30) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     xxxxxxxxxx00101xxxxxx10100011100
                                                                     ldsminab.  */
                                                                  return 1029;
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     xxxxxxxxxx00101xxxxxx10100011110
                                                                     ldsminah.  */
                                                                  return 1032;
                                                                }
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx00101xxxxxx101000111x1
                                                                 ldsmina.  */
                                                              return 1035;
                                                            }
                                                        }
                                                    }
                                                  else
                                                    {
                                                      if (((word >> 23) & 0x1) == 0)
                                                        {
                                                          if (((word >> 31) & 0x1) == 0)
                                                            {
                                                              if (((word >> 30) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     xxxxxxxxxx00101xxxxxx11000011100
                                                                     ldsminlb.  */
                                                                  return 1030;
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     xxxxxxxxxx00101xxxxxx11000011110
                                                                     ldsminlh.  */
                                                                  return 1033;
                                                                }
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx00101xxxxxx110000111x1
                                                                 ldsminl.  */
                                                              return 1036;
                                                            }
                                                        }
                                                      else
                                                        {
                                                          if (((word >> 31) & 0x1) == 0)
                                                            {
                                                              if (((word >> 30) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     xxxxxxxxxx00101xxxxxx11100011100
                                                                     ldsminalb.  */
                                                                  return 1031;
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     xxxxxxxxxx00101xxxxxx11100011110
                                                                     ldsminalh.  */
                                                                  return 1034;
                                                                }
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx00101xxxxxx111000111x1
                                                                 ldsminal.  */
                                                              return 1037;
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 14) & 0x1) == 0)
                                                {
                                                  if (((word >> 22) & 0x1) == 0)
                                                    {
                                                      if (((word >> 23) & 0x1) == 0)
                                                        {
                                                          if (((word >> 31) & 0x1) == 0)
                                                            {
                                                              if (((word >> 30) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     xxxxxxxxxx00110xxxxxx10000011100
                                                                     ldsetb.  */
                                                                  return 1002;
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     xxxxxxxxxx00110xxxxxx10000011110
                                                                     ldseth.  */
                                                                  return 1003;
                                                                }
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx00110xxxxxx100000111x1
                                                                 ldset.  */
                                                              return 1004;
                                                            }
                                                        }
                                                      else
                                                        {
                                                          if (((word >> 31) & 0x1) == 0)
                                                            {
                                                              if (((word >> 30) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     xxxxxxxxxx00110xxxxxx10100011100
                                                                     ldsetab.  */
                                                                  return 1005;
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     xxxxxxxxxx00110xxxxxx10100011110
                                                                     ldsetah.  */
                                                                  return 1008;
                                                                }
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx00110xxxxxx101000111x1
                                                                 ldseta.  */
                                                              return 1011;
                                                            }
                                                        }
                                                    }
                                                  else
                                                    {
                                                      if (((word >> 23) & 0x1) == 0)
                                                        {
                                                          if (((word >> 31) & 0x1) == 0)
                                                            {
                                                              if (((word >> 30) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     xxxxxxxxxx00110xxxxxx11000011100
                                                                     ldsetlb.  */
                                                                  return 1006;
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     xxxxxxxxxx00110xxxxxx11000011110
                                                                     ldsetlh.  */
                                                                  return 1009;
                                                                }
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx00110xxxxxx110000111x1
                                                                 ldsetl.  */
                                                              return 1012;
                                                            }
                                                        }
                                                      else
                                                        {
                                                          if (((word >> 31) & 0x1) == 0)
                                                            {
                                                              if (((word >> 30) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     xxxxxxxxxx00110xxxxxx11100011100
                                                                     ldsetalb.  */
                                                                  return 1007;
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     xxxxxxxxxx00110xxxxxx11100011110
                                                                     ldsetalh.  */
                                                                  return 1010;
                                                                }
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx00110xxxxxx111000111x1
                                                                 ldsetal.  */
                                                              return 1013;
                                                            }
                                                        }
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 22) & 0x1) == 0)
                                                    {
                                                      if (((word >> 23) & 0x1) == 0)
                                                        {
                                                          if (((word >> 31) & 0x1) == 0)
                                                            {
                                                              if (((word >> 30) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     xxxxxxxxxx00111xxxxxx10000011100
                                                                     lduminb.  */
                                                                  return 1050;
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     xxxxxxxxxx00111xxxxxx10000011110
                                                                     lduminh.  */
                                                                  return 1051;
                                                                }
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx00111xxxxxx100000111x1
                                                                 ldumin.  */
                                                              return 1052;
                                                            }
                                                        }
                                                      else
                                                        {
                                                          if (((word >> 31) & 0x1) == 0)
                                                            {
                                                              if (((word >> 30) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     xxxxxxxxxx00111xxxxxx10100011100
                                                                     lduminab.  */
                                                                  return 1053;
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     xxxxxxxxxx00111xxxxxx10100011110
                                                                     lduminah.  */
                                                                  return 1056;
                                                                }
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx00111xxxxxx101000111x1
                                                                 ldumina.  */
                                                              return 1059;
                                                            }
                                                        }
                                                    }
                                                  else
                                                    {
                                                      if (((word >> 23) & 0x1) == 0)
                                                        {
                                                          if (((word >> 31) & 0x1) == 0)
                                                            {
                                                              if (((word >> 30) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     xxxxxxxxxx00111xxxxxx11000011100
                                                                     lduminlb.  */
                                                                  return 1054;
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     xxxxxxxxxx00111xxxxxx11000011110
                                                                     lduminlh.  */
                                                                  return 1057;
                                                                }
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx00111xxxxxx110000111x1
                                                                 lduminl.  */
                                                              return 1060;
                                                            }
                                                        }
                                                      else
                                                        {
                                                          if (((word >> 31) & 0x1) == 0)
                                                            {
                                                              if (((word >> 30) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     xxxxxxxxxx00111xxxxxx11100011100
                                                                     lduminalb.  */
                                                                  return 1055;
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     xxxxxxxxxx00111xxxxxx11100011110
                                                                     lduminalh.  */
                                                                  return 1058;
                                                                }
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx00111xxxxxx111000111x1
                                                                 lduminal.  */
                                                              return 1061;
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                              else
                                {
                                  if (((word >> 21) & 0x1) == 0)
                                    {
                                      if (((word >> 23) & 0x1) == 0)
                                        {
                                          if (((word >> 22) & 0x1) == 0)
                                            {
                                              if (((word >> 31) & 0x1) == 0)
                                                {
                                                  if (((word >> 30) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx01xxxxxxxxx00000011100
                                                         sttrb.  */
                                                      return 852;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx01xxxxxxxxx00000011110
                                                         sttrh.  */
                                                      return 855;
                                                    }
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     xxxxxxxxxx01xxxxxxxxx000000111x1
                                                     sttr.  */
                                                  return 858;
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 31) & 0x1) == 0)
                                                {
                                                  if (((word >> 30) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx01xxxxxxxxx01000011100
                                                         ldtrb.  */
                                                      return 853;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx01xxxxxxxxx01000011110
                                                         ldtrh.  */
                                                      return 856;
                                                    }
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     xxxxxxxxxx01xxxxxxxxx010000111x1
                                                     ldtr.  */
                                                  return 859;
                                                }
                                            }
                                        }
                                      else
                                        {
                                          if (((word >> 30) & 0x1) == 0)
                                            {
                                              if (((word >> 31) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     xxxxxxxxxx01xxxxxxxxx0x100011100
                                                     ldtrsb.  */
                                                  return 854;
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     xxxxxxxxxx01xxxxxxxxx0x100011101
                                                     ldtrsw.  */
                                                  return 860;
                                                }
                                            }
                                          else
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 xxxxxxxxxx01xxxxxxxxx0x10001111x
                                                 ldtrsh.  */
                                              return 857;
                                            }
                                        }
                                    }
                                  else
                                    {
                                      if (((word >> 23) & 0x1) == 0)
                                        {
                                          if (((word >> 22) & 0x1) == 0)
                                            {
                                              if (((word >> 31) & 0x1) == 0)
                                                {
                                                  if (((word >> 30) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx01xxxxxxxxx10000011100
                                                         strb.  */
                                                      return 840;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx01xxxxxxxxx10000011110
                                                         strh.  */
                                                      return 845;
                                                    }
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     xxxxxxxxxx01xxxxxxxxx100000111x1
                                                     str.  */
                                                  return 848;
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 31) & 0x1) == 0)
                                                {
                                                  if (((word >> 30) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx01xxxxxxxxx11000011100
                                                         ldrb.  */
                                                      return 841;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx01xxxxxxxxx11000011110
                                                         ldrh.  */
                                                      return 846;
                                                    }
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     xxxxxxxxxx01xxxxxxxxx110000111x1
                                                     ldr.  */
                                                  return 849;
                                                }
                                            }
                                        }
                                      else
                                        {
                                          if (((word >> 30) & 0x1) == 0)
                                            {
                                              if (((word >> 31) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     xxxxxxxxxx01xxxxxxxxx1x100011100
                                                     ldrsb.  */
                                                  return 842;
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     xxxxxxxxxx01xxxxxxxxx1x100011101
                                                     ldrsw.  */
                                                  return 850;
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 31) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     xxxxxxxxxx01xxxxxxxxx1x100011110
                                                     ldrsh.  */
                                                  return 847;
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     xxxxxxxxxx01xxxxxxxxx1x100011111
                                                     prfm.  */
                                                  return 851;
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                          else
                            {
                              if (((word >> 23) & 0x1) == 0)
                                {
                                  if (((word >> 22) & 0x1) == 0)
                                    {
                                      if (((word >> 31) & 0x1) == 0)
                                        {
                                          if (((word >> 30) & 0x1) == 0)
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 xxxxxxxxxx1xxxxxxxxxxx0000011100
                                                 strb.  */
                                              return 817;
                                            }
                                          else
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 xxxxxxxxxx1xxxxxxxxxxx0000011110
                                                 strh.  */
                                              return 822;
                                            }
                                        }
                                      else
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             xxxxxxxxxx1xxxxxxxxxxx00000111x1
                                             str.  */
                                          return 825;
                                        }
                                    }
                                  else
                                    {
                                      if (((word >> 31) & 0x1) == 0)
                                        {
                                          if (((word >> 30) & 0x1) == 0)
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 xxxxxxxxxx1xxxxxxxxxxx1000011100
                                                 ldrb.  */
                                              return 818;
                                            }
                                          else
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 xxxxxxxxxx1xxxxxxxxxxx1000011110
                                                 ldrh.  */
                                              return 823;
                                            }
                                        }
                                      else
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             xxxxxxxxxx1xxxxxxxxxxx10000111x1
                                             ldr.  */
                                          return 826;
                                        }
                                    }
                                }
                              else
                                {
                                  if (((word >> 30) & 0x1) == 0)
                                    {
                                      if (((word >> 31) & 0x1) == 0)
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             xxxxxxxxxx1xxxxxxxxxxxx100011100
                                             ldrsb.  */
                                          return 819;
                                        }
                                      else
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             xxxxxxxxxx1xxxxxxxxxxxx100011101
                                             ldrsw.  */
                                          return 827;
                                        }
                                    }
                                  else
                                    {
                                      /* 33222222222211111111110000000000
                                         10987654321098765432109876543210
                                         xxxxxxxxxx1xxxxxxxxxxxx10001111x
                                         ldrsh.  */
                                      return 824;
                                    }
                                }
                            }
                        }
                    }
                  else
                    {
                      if (((word >> 23) & 0x1) == 0)
                        {
                          if (((word >> 22) & 0x1) == 0)
                            {
                              if (((word >> 31) & 0x1) == 0)
                                {
                                  if (((word >> 30) & 0x1) == 0)
                                    {
                                      /* 33222222222211111111110000000000
                                         10987654321098765432109876543210
                                         xxxxxxxxxxxxxxxxxxxxxx0010011x00
                                         strb.  */
                                      return 828;
                                    }
                                  else
                                    {
                                      /* 33222222222211111111110000000000
                                         10987654321098765432109876543210
                                         xxxxxxxxxxxxxxxxxxxxxx0010011x10
                                         strh.  */
                                      return 833;
                                    }
                                }
                              else
                                {
                                  /* 33222222222211111111110000000000
                                     10987654321098765432109876543210
                                     xxxxxxxxxxxxxxxxxxxxxx0010011xx1
                                     str.  */
                                  return 836;
                                }
                            }
                          else
                            {
                              if (((word >> 31) & 0x1) == 0)
                                {
                                  if (((word >> 30) & 0x1) == 0)
                                    {
                                      /* 33222222222211111111110000000000
                                         10987654321098765432109876543210
                                         xxxxxxxxxxxxxxxxxxxxxx1010011x00
                                         ldrb.  */
                                      return 829;
                                    }
                                  else
                                    {
                                      /* 33222222222211111111110000000000
                                         10987654321098765432109876543210
                                         xxxxxxxxxxxxxxxxxxxxxx1010011x10
                                         ldrh.  */
                                      return 834;
                                    }
                                }
                              else
                                {
                                  /* 33222222222211111111110000000000
                                     10987654321098765432109876543210
                                     xxxxxxxxxxxxxxxxxxxxxx1010011xx1
                                     ldr.  */
                                  return 837;
                                }
                            }
                        }
                      else
                        {
                          if (((word >> 30) & 0x1) == 0)
                            {
                              if (((word >> 31) & 0x1) == 0)
                                {
                                  /* 33222222222211111111110000000000
                                     10987654321098765432109876543210
                                     xxxxxxxxxxxxxxxxxxxxxxx110011x00
                                     ldrsb.  */
                                  return 830;
                                }
                              else
                                {
                                  /* 33222222222211111111110000000000
                                     10987654321098765432109876543210
                                     xxxxxxxxxxxxxxxxxxxxxxx110011x01
                                     ldrsw.  */
                                  return 838;
                                }
                            }
                          else
                            {
                              if (((word >> 31) & 0x1) == 0)
                                {
                                  /* 33222222222211111111110000000000
                                     10987654321098765432109876543210
                                     xxxxxxxxxxxxxxxxxxxxxxx110011x10
                                     ldrsh.  */
                                  return 835;
                                }
                              else
                                {
                                  /* 33222222222211111111110000000000
                                     10987654321098765432109876543210
                                     xxxxxxxxxxxxxxxxxxxxxxx110011x11
                                     prfm.  */
                                  return 839;
                                }
                            }
                        }
                    }
                }
            }
        }
      else
        {
          if (((word >> 24) & 0x1) == 0)
            {
              if (((word >> 27) & 0x1) == 0)
                {
                  if (((word >> 23) & 0x1) == 0)
                    {
                      if (((word >> 29) & 0x1) == 0)
                        {
                          if (((word >> 30) & 0x1) == 0)
                            {
                              /* 33222222222211111111110000000000
                                 10987654321098765432109876543210
                                 xxxxxxxxxxxxxxxxxxxxxxx00100x00x
                                 and.  */
                              return 919;
                            }
                          else
                            {
                              /* 33222222222211111111110000000000
                                 10987654321098765432109876543210
                                 xxxxxxxxxxxxxxxxxxxxxxx00100x01x
                                 eor.  */
                              return 923;
                            }
                        }
                      else
                        {
                          if (((word >> 30) & 0x1) == 0)
                            {
                              /* 33222222222211111111110000000000
                                 10987654321098765432109876543210
                                 xxxxxxxxxxxxxxxxxxxxxxx00100x10x
                                 orr.  */
                              return 921;
                            }
                          else
                            {
                              /* 33222222222211111111110000000000
                                 10987654321098765432109876543210
                                 xxxxxxxxxxxxxxxxxxxxxxx00100x11x
                                 ands.  */
                              return 924;
                            }
                        }
                    }
                  else
                    {
                      if (((word >> 29) & 0x1) == 0)
                        {
                          if (((word >> 30) & 0x1) == 0)
                            {
                              /* 33222222222211111111110000000000
                                 10987654321098765432109876543210
                                 xxxxxxxxxxxxxxxxxxxxxxx10100x00x
                                 movn.  */
                              return 1110;
                            }
                          else
                            {
                              /* 33222222222211111111110000000000
                                 10987654321098765432109876543210
                                 xxxxxxxxxxxxxxxxxxxxxxx10100x01x
                                 movz.  */
                              return 1112;
                            }
                        }
                      else
                        {
                          /* 33222222222211111111110000000000
                             10987654321098765432109876543210
                             xxxxxxxxxxxxxxxxxxxxxxx10100x1xx
                             movk.  */
                          return 1114;
                        }
                    }
                }
              else
                {
                  if (((word >> 21) & 0x1) == 0)
                    {
                      if (((word >> 28) & 0x1) == 0)
                        {
                          if (((word >> 29) & 0x1) == 0)
                            {
                              if (((word >> 30) & 0x1) == 0)
                                {
                                  /* 33222222222211111111110000000000
                                     10987654321098765432109876543210
                                     xxxxxxxxxxxxxxxxxxxxx0xx0101000x
                                     and.  */
                                  return 926;
                                }
                              else
                                {
                                  /* 33222222222211111111110000000000
                                     10987654321098765432109876543210
                                     xxxxxxxxxxxxxxxxxxxxx0xx0101001x
                                     eor.  */
                                  return 933;
                                }
                            }
                          else
                            {
                              if (((word >> 30) & 0x1) == 0)
                                {
                                  /* 33222222222211111111110000000000
                                     10987654321098765432109876543210
                                     xxxxxxxxxxxxxxxxxxxxx0xx0101010x
                                     orr.  */
                                  return 928;
                                }
                              else
                                {
                                  /* 33222222222211111111110000000000
                                     10987654321098765432109876543210
                                     xxxxxxxxxxxxxxxxxxxxx0xx0101011x
                                     ands.  */
                                  return 935;
                                }
                            }
                        }
                      else
                        {
                          if (((word >> 10) & 0x1) == 0)
                            {
                              if (((word >> 11) & 0x1) == 0)
                                {
                                  if (((word >> 22) & 0x1) == 0)
                                    {
                                      if (((word >> 23) & 0x1) == 0)
                                        {
                                          if (((word >> 29) & 0x1) == 0)
                                            {
                                              if (((word >> 30) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     xxxxxxxxxx00xxxxxxxxx0000101100x
                                                     adc.  */
                                                  return 0;
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     xxxxxxxxxx00xxxxxxxxx0000101101x
                                                     sbc.  */
                                                  return 2;
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 30) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     xxxxxxxxxx00xxxxxxxxx0000101110x
                                                     adcs.  */
                                                  return 1;
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     xxxxxxxxxx00xxxxxxxxx0000101111x
                                                     sbcs.  */
                                                  return 4;
                                                }
                                            }
                                        }
                                      else
                                        {
                                          if (((word >> 30) & 0x1) == 0)
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 xxxxxxxxxx00xxxxxxxxx00101011x0x
                                                 csel.  */
                                              return 641;
                                            }
                                          else
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 xxxxxxxxxx00xxxxxxxxx00101011x1x
                                                 csinv.  */
                                              return 645;
                                            }
                                        }
                                    }
                                  else
                                    {
                                      if (((word >> 23) & 0x1) == 0)
                                        {
                                          if (((word >> 30) & 0x1) == 0)
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 xxxxxxxxxx00xxxxxxxxx01001011x0x
                                                 ccmn.  */
                                              return 639;
                                            }
                                          else
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 xxxxxxxxxx00xxxxxxxxx01001011x1x
                                                 ccmp.  */
                                              return 640;
                                            }
                                        }
                                      else
                                        {
                                          if (((word >> 12) & 0x1) == 0)
                                            {
                                              if (((word >> 13) & 0x1) == 0)
                                                {
                                                  if (((word >> 14) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx00000xxxxxx01101011xxx
                                                         rbit.  */
                                                      return 664;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx00001xxxxxx01101011xxx
                                                         crc32b.  */
                                                      return 682;
                                                    }
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     xxxxxxxxxx0001xxxxxxx01101011xxx
                                                     lslv.  */
                                                  return 674;
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 14) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     xxxxxxxxxx001x0xxxxxx01101011xxx
                                                     clz.  */
                                                  return 669;
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     xxxxxxxxxx001x1xxxxxx01101011xxx
                                                     crc32cb.  */
                                                  return 686;
                                                }
                                            }
                                        }
                                    }
                                }
                              else
                                {
                                  if (((word >> 23) & 0x1) == 0)
                                    {
                                      if (((word >> 30) & 0x1) == 0)
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             xxxxxxxxxx01xxxxxxxxx0x001011x0x
                                             ccmn.  */
                                          return 637;
                                        }
                                      else
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             xxxxxxxxxx01xxxxxxxxx0x001011x1x
                                             ccmp.  */
                                          return 638;
                                        }
                                    }
                                  else
                                    {
                                      if (((word >> 12) & 0x1) == 0)
                                        {
                                          if (((word >> 13) & 0x1) == 0)
                                            {
                                              if (((word >> 14) & 0x1) == 0)
                                                {
                                                  if (((word >> 30) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx01000xxxxxx0x101011x0x
                                                         udiv.  */
                                                      return 672;
                                                    }
                                                  else
                                                    {
                                                      if (((word >> 31) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx01000xxxxxx0x101011x10
                                                             rev.  */
                                                          return 666;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx01000xxxxxx0x101011x11
                                                             rev32.  */
                                                          return 671;
                                                        }
                                                    }
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     xxxxxxxxxx01001xxxxxx0x101011xxx
                                                     crc32w.  */
                                                  return 684;
                                                }
                                            }
                                          else
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 xxxxxxxxxx0101xxxxxxx0x101011xxx
                                                 asrv.  */
                                              return 678;
                                            }
                                        }
                                      else
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             xxxxxxxxxx011xxxxxxxx0x101011xxx
                                             crc32cw.  */
                                          return 688;
                                        }
                                    }
                                }
                            }
                          else
                            {
                              if (((word >> 11) & 0x1) == 0)
                                {
                                  if (((word >> 22) & 0x1) == 0)
                                    {
                                      if (((word >> 30) & 0x1) == 0)
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             xxxxxxxxxx10xxxxxxxxx00x01011x0x
                                             csinc.  */
                                          return 642;
                                        }
                                      else
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             xxxxxxxxxx10xxxxxxxxx00x01011x1x
                                             csneg.  */
                                          return 648;
                                        }
                                    }
                                  else
                                    {
                                      if (((word >> 12) & 0x1) == 0)
                                        {
                                          if (((word >> 13) & 0x1) == 0)
                                            {
                                              if (((word >> 14) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     xxxxxxxxxx10000xxxxxx01x01011xxx
                                                     rev16.  */
                                                  return 665;
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     xxxxxxxxxx10001xxxxxx01x01011xxx
                                                     crc32h.  */
                                                  return 683;
                                                }
                                            }
                                          else
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 xxxxxxxxxx1001xxxxxxx01x01011xxx
                                                 lsrv.  */
                                              return 676;
                                            }
                                        }
                                      else
                                        {
                                          if (((word >> 14) & 0x1) == 0)
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 xxxxxxxxxx101x0xxxxxx01x01011xxx
                                                 cls.  */
                                              return 670;
                                            }
                                          else
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 xxxxxxxxxx101x1xxxxxx01x01011xxx
                                                 crc32ch.  */
                                              return 687;
                                            }
                                        }
                                    }
                                }
                              else
                                {
                                  if (((word >> 12) & 0x1) == 0)
                                    {
                                      if (((word >> 13) & 0x1) == 0)
                                        {
                                          if (((word >> 14) & 0x1) == 0)
                                            {
                                              if (((word >> 30) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     xxxxxxxxxx11000xxxxxx0xx01011x0x
                                                     sdiv.  */
                                                  return 673;
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     xxxxxxxxxx11000xxxxxx0xx01011x1x
                                                     rev.  */
                                                  return 667;
                                                }
                                            }
                                          else
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 xxxxxxxxxx11001xxxxxx0xx01011xxx
                                                 crc32x.  */
                                              return 685;
                                            }
                                        }
                                      else
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             xxxxxxxxxx1101xxxxxxx0xx01011xxx
                                             rorv.  */
                                          return 680;
                                        }
                                    }
                                  else
                                    {
                                      /* 33222222222211111111110000000000
                                         10987654321098765432109876543210
                                         xxxxxxxxxx111xxxxxxxx0xx01011xxx
                                         crc32cx.  */
                                      return 689;
                                    }
                                }
                            }
                        }
                    }
                  else
                    {
                      if (((word >> 29) & 0x1) == 0)
                        {
                          if (((word >> 30) & 0x1) == 0)
                            {
                              /* 33222222222211111111110000000000
                                 10987654321098765432109876543210
                                 xxxxxxxxxxxxxxxxxxxxx1xx0101x00x
                                 bic.  */
                              return 927;
                            }
                          else
                            {
                              /* 33222222222211111111110000000000
                                 10987654321098765432109876543210
                                 xxxxxxxxxxxxxxxxxxxxx1xx0101x01x
                                 eon.  */
                              return 934;
                            }
                        }
                      else
                        {
                          if (((word >> 30) & 0x1) == 0)
                            {
                              /* 33222222222211111111110000000000
                                 10987654321098765432109876543210
                                 xxxxxxxxxxxxxxxxxxxxx1xx0101x10x
                                 orn.  */
                              return 931;
                            }
                          else
                            {
                              /* 33222222222211111111110000000000
                                 10987654321098765432109876543210
                                 xxxxxxxxxxxxxxxxxxxxx1xx0101x11x
                                 bics.  */
                              return 937;
                            }
                        }
                    }
                }
            }
          else
            {
              if (((word >> 27) & 0x1) == 0)
                {
                  if (((word >> 23) & 0x1) == 0)
                    {
                      if (((word >> 29) & 0x1) == 0)
                        {
                          if (((word >> 30) & 0x1) == 0)
                            {
                              /* 33222222222211111111110000000000
                                 10987654321098765432109876543210
                                 xxxxxxxxxxxxxxxxxxxxxxx01100x00x
                                 sbfm.  */
                              return 609;
                            }
                          else
                            {
                              /* 33222222222211111111110000000000
                                 10987654321098765432109876543210
                                 xxxxxxxxxxxxxxxxxxxxxxx01100x01x
                                 ubfm.  */
                              return 620;
                            }
                        }
                      else
                        {
                          /* 33222222222211111111110000000000
                             10987654321098765432109876543210
                             xxxxxxxxxxxxxxxxxxxxxxx01100x1xx
                             bfm.  */
                          return 616;
                        }
                    }
                  else
                    {
                      /* 33222222222211111111110000000000
                         10987654321098765432109876543210
                         xxxxxxxxxxxxxxxxxxxxxxx11100xxxx
                         extr.  */
                      return 712;
                    }
                }
              else
                {
                  if (((word >> 21) & 0x1) == 0)
                    {
                      if (((word >> 28) & 0x1) == 0)
                        {
                          if (((word >> 29) & 0x1) == 0)
                            {
                              if (((word >> 30) & 0x1) == 0)
                                {
                                  /* 33222222222211111111110000000000
                                     10987654321098765432109876543210
                                     xxxxxxxxxxxxxxxxxxxxx0xx1101000x
                                     add.  */
                                  return 19;
                                }
                              else
                                {
                                  /* 33222222222211111111110000000000
                                     10987654321098765432109876543210
                                     xxxxxxxxxxxxxxxxxxxxx0xx1101001x
                                     sub.  */
                                  return 22;
                                }
                            }
                          else
                            {
                              if (((word >> 30) & 0x1) == 0)
                                {
                                  /* 33222222222211111111110000000000
                                     10987654321098765432109876543210
                                     xxxxxxxxxxxxxxxxxxxxx0xx1101010x
                                     adds.  */
                                  return 20;
                                }
                              else
                                {
                                  /* 33222222222211111111110000000000
                                     10987654321098765432109876543210
                                     xxxxxxxxxxxxxxxxxxxxx0xx1101011x
                                     subs.  */
                                  return 24;
                                }
                            }
                        }
                      else
                        {
                          if (((word >> 15) & 0x1) == 0)
                            {
                              if (((word >> 22) & 0x1) == 0)
                                {
                                  /* 33222222222211111111110000000000
                                     10987654321098765432109876543210
                                     xxxxxxxxxxxxxxx0xxxxx00x11011xxx
                                     madd.  */
                                  return 690;
                                }
                              else
                                {
                                  if (((word >> 23) & 0x1) == 0)
                                    {
                                      /* 33222222222211111111110000000000
                                         10987654321098765432109876543210
                                         xxxxxxxxxxxxxxx0xxxxx01011011xxx
                                         smulh.  */
                                      return 698;
                                    }
                                  else
                                    {
                                      /* 33222222222211111111110000000000
                                         10987654321098765432109876543210
                                         xxxxxxxxxxxxxxx0xxxxx01111011xxx
                                         umulh.  */
                                      return 703;
                                    }
                                }
                            }
                          else
                            {
                              /* 33222222222211111111110000000000
                                 10987654321098765432109876543210
                                 xxxxxxxxxxxxxxx1xxxxx0xx11011xxx
                                 msub.  */
                              return 692;
                            }
                        }
                    }
                  else
                    {
                      if (((word >> 23) & 0x1) == 0)
                        {
                          if (((word >> 28) & 0x1) == 0)
                            {
                              if (((word >> 29) & 0x1) == 0)
                                {
                                  if (((word >> 30) & 0x1) == 0)
                                    {
                                      /* 33222222222211111111110000000000
                                         10987654321098765432109876543210
                                         xxxxxxxxxxxxxxxxxxxxx1x01101000x
                                         add.  */
                                      return 6;
                                    }
                                  else
                                    {
                                      /* 33222222222211111111110000000000
                                         10987654321098765432109876543210
                                         xxxxxxxxxxxxxxxxxxxxx1x01101001x
                                         sub.  */
                                      return 9;
                                    }
                                }
                              else
                                {
                                  if (((word >> 30) & 0x1) == 0)
                                    {
                                      /* 33222222222211111111110000000000
                                         10987654321098765432109876543210
                                         xxxxxxxxxxxxxxxxxxxxx1x01101010x
                                         adds.  */
                                      return 7;
                                    }
                                  else
                                    {
                                      /* 33222222222211111111110000000000
                                         10987654321098765432109876543210
                                         xxxxxxxxxxxxxxxxxxxxx1x01101011x
                                         subs.  */
                                      return 10;
                                    }
                                }
                            }
                          else
                            {
                              if (((word >> 15) & 0x1) == 0)
                                {
                                  /* 33222222222211111111110000000000
                                     10987654321098765432109876543210
                                     xxxxxxxxxxxxxxx0xxxxx1x011011xxx
                                     smaddl.  */
                                  return 694;
                                }
                              else
                                {
                                  /* 33222222222211111111110000000000
                                     10987654321098765432109876543210
                                     xxxxxxxxxxxxxxx1xxxxx1x011011xxx
                                     smsubl.  */
                                  return 696;
                                }
                            }
                        }
                      else
                        {
                          if (((word >> 15) & 0x1) == 0)
                            {
                              /* 33222222222211111111110000000000
                                 10987654321098765432109876543210
                                 xxxxxxxxxxxxxxx0xxxxx1x11101xxxx
                                 umaddl.  */
                              return 699;
                            }
                          else
                            {
                              /* 33222222222211111111110000000000
                                 10987654321098765432109876543210
                                 xxxxxxxxxxxxxxx1xxxxx1x11101xxxx
                                 umsubl.  */
                              return 701;
                            }
                        }
                    }
                }
            }
        }
    }
  else
    {
      if (((word >> 27) & 0x1) == 0)
        {
          if (((word >> 29) & 0x1) == 0)
            {
              if (((word >> 30) & 0x1) == 0)
                {
                  if (((word >> 31) & 0x1) == 0)
                    {
                      /* 33222222222211111111110000000000
                         10987654321098765432109876543210
                         xxxxxxxxxxxxxxxxxxxxxxxxxx10x000
                         b.  */
                      return 627;
                    }
                  else
                    {
                      /* 33222222222211111111110000000000
                         10987654321098765432109876543210
                         xxxxxxxxxxxxxxxxxxxxxxxxxx10x001
                         bl.  */
                      return 628;
                    }
                }
              else
                {
                  if (((word >> 24) & 0x1) == 0)
                    {
                      if (((word >> 25) & 0x1) == 0)
                        {
                          if (((word >> 31) & 0x1) == 0)
                            {
                              /* 33222222222211111111110000000000
                                 10987654321098765432109876543210
                                 xxxxxxxxxxxxxxxxxxxxxxxx0010x010
                                 b.c.  */
                              return 636;
                            }
                          else
                            {
                              if (((word >> 0) & 0x1) == 0)
                                {
                                  if (((word >> 1) & 0x1) == 0)
                                    {
                                      if (((word >> 21) & 0x1) == 0)
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             00xxxxxxxxxxxxxxxxxxx0xx0010x011
                                             hlt.  */
                                          return 708;
                                        }
                                      else
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             00xxxxxxxxxxxxxxxxxxx1xx0010x011
                                             brk.  */
                                          return 707;
                                        }
                                    }
                                  else
                                    {
                                      if (((word >> 21) & 0x1) == 0)
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             01xxxxxxxxxxxxxxxxxxx0xx0010x011
                                             hvc.  */
                                          return 705;
                                        }
                                      else
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             01xxxxxxxxxxxxxxxxxxx1xx0010x011
                                             dcps2.  */
                                          return 710;
                                        }
                                    }
                                }
                              else
                                {
                                  if (((word >> 1) & 0x1) == 0)
                                    {
                                      if (((word >> 21) & 0x1) == 0)
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             10xxxxxxxxxxxxxxxxxxx0xx0010x011
                                             svc.  */
                                          return 704;
                                        }
                                      else
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             10xxxxxxxxxxxxxxxxxxx1xx0010x011
                                             dcps1.  */
                                          return 709;
                                        }
                                    }
                                  else
                                    {
                                      if (((word >> 21) & 0x1) == 0)
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             11xxxxxxxxxxxxxxxxxxx0xx0010x011
                                             smc.  */
                                          return 706;
                                        }
                                      else
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             11xxxxxxxxxxxxxxxxxxx1xx0010x011
                                             dcps3.  */
                                          return 711;
                                        }
                                    }
                                }
                            }
                        }
                      else
                        {
                          if (((word >> 21) & 0x1) == 0)
                            {
                              if (((word >> 22) & 0x1) == 0)
                                {
                                  if (((word >> 23) & 0x1) == 0)
                                    {
                                      /* 33222222222211111111110000000000
                                         10987654321098765432109876543210
                                         xxxxxxxxxxxxxxxxxxxxx0000110x01x
                                         br.  */
                                      return 629;
                                    }
                                  else
                                    {
                                      /* 33222222222211111111110000000000
                                         10987654321098765432109876543210
                                         xxxxxxxxxxxxxxxxxxxxx0010110x01x
                                         eret.  */
                                      return 632;
                                    }
                                }
                              else
                                {
                                  /* 33222222222211111111110000000000
                                     10987654321098765432109876543210
                                     xxxxxxxxxxxxxxxxxxxxx01x0110x01x
                                     ret.  */
                                  return 631;
                                }
                            }
                          else
                            {
                              if (((word >> 23) & 0x1) == 0)
                                {
                                  /* 33222222222211111111110000000000
                                     10987654321098765432109876543210
                                     xxxxxxxxxxxxxxxxxxxxx1x00110x01x
                                     blr.  */
                                  return 630;
                                }
                              else
                                {
                                  /* 33222222222211111111110000000000
                                     10987654321098765432109876543210
                                     xxxxxxxxxxxxxxxxxxxxx1x10110x01x
                                     drps.  */
                                  return 633;
                                }
                            }
                        }
                    }
                  else
                    {
                      if (((word >> 21) & 0x1) == 0)
                        {
                          /* 33222222222211111111110000000000
                             10987654321098765432109876543210
                             xxxxxxxxxxxxxxxxxxxxx0xx1x10x01x
                             msr.  */
                          return 1117;
                        }
                      else
                        {
                          /* 33222222222211111111110000000000
                             10987654321098765432109876543210
                             xxxxxxxxxxxxxxxxxxxxx1xx1x10x01x
                             sysl.  */
                          return 1137;
                        }
                    }
                }
            }
          else
            {
              if (((word >> 24) & 0x1) == 0)
                {
                  if (((word >> 25) & 0x1) == 0)
                    {
                      /* 33222222222211111111110000000000
                         10987654321098765432109876543210
                         xxxxxxxxxxxxxxxxxxxxxxxx0010x1xx
                         cbz.  */
                      return 634;
                    }
                  else
                    {
                      /* 33222222222211111111110000000000
                         10987654321098765432109876543210
                         xxxxxxxxxxxxxxxxxxxxxxxx0110x1xx
                         tbz.  */
                      return 1139;
                    }
                }
              else
                {
                  if (((word >> 25) & 0x1) == 0)
                    {
                      /* 33222222222211111111110000000000
                         10987654321098765432109876543210
                         xxxxxxxxxxxxxxxxxxxxxxxx1010x1xx
                         cbnz.  */
                      return 635;
                    }
                  else
                    {
                      /* 33222222222211111111110000000000
                         10987654321098765432109876543210
                         xxxxxxxxxxxxxxxxxxxxxxxx1110x1xx
                         tbnz.  */
                      return 1140;
                    }
                }
            }
        }
      else
        {
          if (((word >> 25) & 0x1) == 0)
            {
              if (((word >> 28) & 0x1) == 0)
                {
                  if (((word >> 22) & 0x1) == 0)
                    {
                      if (((word >> 23) & 0x1) == 0)
                        {
                          if (((word >> 24) & 0x1) == 0)
                            {
                              if (((word >> 29) & 0x1) == 0)
                                {
                                  /* 33222222222211111111110000000000
                                     10987654321098765432109876543210
                                     xxxxxxxxxxxxxxxxxxxxxx00001100xx
                                     st4.  */
                                  return 431;
                                }
                              else
                                {
                                  /* 33222222222211111111110000000000
                                     10987654321098765432109876543210
                                     xxxxxxxxxxxxxxxxxxxxxx00001101xx
                                     stnp.  */
                                  return 903;
                                }
                            }
                          else
                            {
                              if (((word >> 29) & 0x1) == 0)
                                {
                                  if (((word >> 13) & 0x1) == 0)
                                    {
                                      if (((word >> 21) & 0x1) == 0)
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             xxxxxxxxxxxxx0xxxxxxx000101100xx
                                             st1.  */
                                          return 447;
                                        }
                                      else
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             xxxxxxxxxxxxx0xxxxxxx100101100xx
                                             st2.  */
                                          return 449;
                                        }
                                    }
                                  else
                                    {
                                      if (((word >> 21) & 0x1) == 0)
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             xxxxxxxxxxxxx1xxxxxxx000101100xx
                                             st3.  */
                                          return 448;
                                        }
                                      else
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             xxxxxxxxxxxxx1xxxxxxx100101100xx
                                             st4.  */
                                          return 450;
                                        }
                                    }
                                }
                              else
                                {
                                  /* 33222222222211111111110000000000
                                     10987654321098765432109876543210
                                     xxxxxxxxxxxxxxxxxxxxxx00101101xx
                                     stp.  */
                                  return 907;
                                }
                            }
                        }
                      else
                        {
                          if (((word >> 29) & 0x1) == 0)
                            {
                              if (((word >> 21) & 0x1) == 0)
                                {
                                  if (((word >> 24) & 0x1) == 0)
                                    {
                                      /* 33222222222211111111110000000000
                                         10987654321098765432109876543210
                                         xxxxxxxxxxxxxxxxxxxxx001001100xx
                                         st4.  */
                                      return 439;
                                    }
                                  else
                                    {
                                      if (((word >> 13) & 0x1) == 0)
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             xxxxxxxxxxxxx0xxxxxxx001101100xx
                                             st1.  */
                                          return 459;
                                        }
                                      else
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             xxxxxxxxxxxxx1xxxxxxx001101100xx
                                             st3.  */
                                          return 460;
                                        }
                                    }
                                }
                              else
                                {
                                  if (((word >> 13) & 0x1) == 0)
                                    {
                                      /* 33222222222211111111110000000000
                                         10987654321098765432109876543210
                                         xxxxxxxxxxxxx0xxxxxxx101x01100xx
                                         st2.  */
                                      return 461;
                                    }
                                  else
                                    {
                                      /* 33222222222211111111110000000000
                                         10987654321098765432109876543210
                                         xxxxxxxxxxxxx1xxxxxxx101x01100xx
                                         st4.  */
                                      return 462;
                                    }
                                }
                            }
                          else
                            {
                              /* 33222222222211111111110000000000
                                 10987654321098765432109876543210
                                 xxxxxxxxxxxxxxxxxxxxxx01x01101xx
                                 stp.  */
                              return 912;
                            }
                        }
                    }
                  else
                    {
                      if (((word >> 23) & 0x1) == 0)
                        {
                          if (((word >> 24) & 0x1) == 0)
                            {
                              if (((word >> 29) & 0x1) == 0)
                                {
                                  /* 33222222222211111111110000000000
                                     10987654321098765432109876543210
                                     xxxxxxxxxxxxxxxxxxxxxx10001100xx
                                     ld4.  */
                                  return 435;
                                }
                              else
                                {
                                  /* 33222222222211111111110000000000
                                     10987654321098765432109876543210
                                     xxxxxxxxxxxxxxxxxxxxxx10001101xx
                                     ldnp.  */
                                  return 904;
                                }
                            }
                          else
                            {
                              if (((word >> 29) & 0x1) == 0)
                                {
                                  if (((word >> 13) & 0x1) == 0)
                                    {
                                      if (((word >> 21) & 0x1) == 0)
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             xxxxxxxxxxxxx0xxxxxxx010101100xx
                                             ld1.  */
                                          return 451;
                                        }
                                      else
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             xxxxxxxxxxxxx0xxxxxxx110101100xx
                                             ld2.  */
                                          return 455;
                                        }
                                    }
                                  else
                                    {
                                      if (((word >> 21) & 0x1) == 0)
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             xxxxxxxxxxxxx1xxxxxxx010101100xx
                                             ld3.  */
                                          return 452;
                                        }
                                      else
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             xxxxxxxxxxxxx1xxxxxxx110101100xx
                                             ld4.  */
                                          return 456;
                                        }
                                    }
                                }
                              else
                                {
                                  /* 33222222222211111111110000000000
                                     10987654321098765432109876543210
                                     xxxxxxxxxxxxxxxxxxxxxx10101101xx
                                     ldp.  */
                                  return 908;
                                }
                            }
                        }
                      else
                        {
                          if (((word >> 29) & 0x1) == 0)
                            {
                              if (((word >> 21) & 0x1) == 0)
                                {
                                  if (((word >> 24) & 0x1) == 0)
                                    {
                                      /* 33222222222211111111110000000000
                                         10987654321098765432109876543210
                                         xxxxxxxxxxxxxxxxxxxxx011001100xx
                                         ld4.  */
                                      return 443;
                                    }
                                  else
                                    {
                                      if (((word >> 13) & 0x1) == 0)
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             xxxxxxxxxxxxx0xxxxxxx011101100xx
                                             ld1.  */
                                          return 463;
                                        }
                                      else
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             xxxxxxxxxxxxx1xxxxxxx011101100xx
                                             ld3.  */
                                          return 464;
                                        }
                                    }
                                }
                              else
                                {
                                  if (((word >> 13) & 0x1) == 0)
                                    {
                                      /* 33222222222211111111110000000000
                                         10987654321098765432109876543210
                                         xxxxxxxxxxxxx0xxxxxxx111x01100xx
                                         ld2.  */
                                      return 467;
                                    }
                                  else
                                    {
                                      /* 33222222222211111111110000000000
                                         10987654321098765432109876543210
                                         xxxxxxxxxxxxx1xxxxxxx111x01100xx
                                         ld4.  */
                                      return 468;
                                    }
                                }
                            }
                          else
                            {
                              /* 33222222222211111111110000000000
                                 10987654321098765432109876543210
                                 xxxxxxxxxxxxxxxxxxxxxx11x01101xx
                                 ldp.  */
                              return 913;
                            }
                        }
                    }
                }
              else
                {
                  if (((word >> 24) & 0x1) == 0)
                    {
                      if (((word >> 29) & 0x1) == 0)
                        {
                          /* 33222222222211111111110000000000
                             10987654321098765432109876543210
                             xxxxxxxxxxxxxxxxxxxxxxxx001110xx
                             ldr.  */
                          return 916;
                        }
                      else
                        {
                          if (((word >> 10) & 0x1) == 0)
                            {
                              if (((word >> 11) & 0x1) == 0)
                                {
                                  if (((word >> 22) & 0x1) == 0)
                                    {
                                      /* 33222222222211111111110000000000
                                         10987654321098765432109876543210
                                         xxxxxxxxxx00xxxxxxxxxx0x001111xx
                                         stur.  */
                                      return 864;
                                    }
                                  else
                                    {
                                      /* 33222222222211111111110000000000
                                         10987654321098765432109876543210
                                         xxxxxxxxxx00xxxxxxxxxx1x001111xx
                                         ldur.  */
                                      return 865;
                                    }
                                }
                              else
                                {
                                  if (((word >> 22) & 0x1) == 0)
                                    {
                                      /* 33222222222211111111110000000000
                                         10987654321098765432109876543210
                                         xxxxxxxxxx01xxxxxxxxxx0x001111xx
                                         str.  */
                                      return 843;
                                    }
                                  else
                                    {
                                      /* 33222222222211111111110000000000
                                         10987654321098765432109876543210
                                         xxxxxxxxxx01xxxxxxxxxx1x001111xx
                                         ldr.  */
                                      return 844;
                                    }
                                }
                            }
                          else
                            {
                              if (((word >> 22) & 0x1) == 0)
                                {
                                  /* 33222222222211111111110000000000
                                     10987654321098765432109876543210
                                     xxxxxxxxxx1xxxxxxxxxxx0x001111xx
                                     str.  */
                                  return 820;
                                }
                              else
                                {
                                  /* 33222222222211111111110000000000
                                     10987654321098765432109876543210
                                     xxxxxxxxxx1xxxxxxxxxxx1x001111xx
                                     ldr.  */
                                  return 821;
                                }
                            }
                        }
                    }
                  else
                    {
                      if (((word >> 22) & 0x1) == 0)
                        {
                          /* 33222222222211111111110000000000
                             10987654321098765432109876543210
                             xxxxxxxxxxxxxxxxxxxxxx0x10111xxx
                             str.  */
                          return 831;
                        }
                      else
                        {
                          /* 33222222222211111111110000000000
                             10987654321098765432109876543210
                             xxxxxxxxxxxxxxxxxxxxxx1x10111xxx
                             ldr.  */
                          return 832;
                        }
                    }
                }
            }
          else
            {
              if (((word >> 24) & 0x1) == 0)
                {
                  if (((word >> 21) & 0x1) == 0)
                    {
                      if (((word >> 28) & 0x1) == 0)
                        {
                          if (((word >> 10) & 0x1) == 0)
                            {
                              if (((word >> 29) & 0x1) == 0)
                                {
                                  if (((word >> 11) & 0x1) == 0)
                                    {
                                      if (((word >> 12) & 0x1) == 0)
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             xxxxxxxxxx000xxxxxxxx0xx011100xx
                                             tbl.  */
                                          return 411;
                                        }
                                      else
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             xxxxxxxxxx001xxxxxxxx0xx011100xx
                                             tbx.  */
                                          return 412;
                                        }
                                    }
                                  else
                                    {
                                      if (((word >> 12) & 0x1) == 0)
                                        {
                                          if (((word >> 14) & 0x1) == 0)
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 xxxxxxxxxx010x0xxxxxx0xx011100xx
                                                 trn1.  */
                                              return 256;
                                            }
                                          else
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 xxxxxxxxxx010x1xxxxxx0xx011100xx
                                                 trn2.  */
                                              return 259;
                                            }
                                        }
                                      else
                                        {
                                          if (((word >> 13) & 0x1) == 0)
                                            {
                                              if (((word >> 14) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     xxxxxxxxxx01100xxxxxx0xx011100xx
                                                     uzp1.  */
                                                  return 255;
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     xxxxxxxxxx01101xxxxxx0xx011100xx
                                                     uzp2.  */
                                                  return 258;
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 14) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     xxxxxxxxxx01110xxxxxx0xx011100xx
                                                     zip1.  */
                                                  return 257;
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     xxxxxxxxxx01111xxxxxx0xx011100xx
                                                     zip2.  */
                                                  return 260;
                                                }
                                            }
                                        }
                                    }
                                }
                              else
                                {
                                  /* 33222222222211111111110000000000
                                     10987654321098765432109876543210
                                     xxxxxxxxxx0xxxxxxxxxx0xx011101xx
                                     ext.  */
                                  return 129;
                                }
                            }
                          else
                            {
                              if (((word >> 15) & 0x1) == 0)
                                {
                                  if (((word >> 22) & 0x1) == 0)
                                    {
                                      if (((word >> 29) & 0x1) == 0)
                                        {
                                          if (((word >> 11) & 0x1) == 0)
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 xxxxxxxxxx10xxx0xxxxx00x011100xx
                                                 dup.  */
                                              return 146;
                                            }
                                          else
                                            {
                                              if (((word >> 12) & 0x1) == 0)
                                                {
                                                  if (((word >> 13) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx1100x0xxxxx00x011100xx
                                                         dup.  */
                                                      return 147;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx1101x0xxxxx00x011100xx
                                                         smov.  */
                                                      return 148;
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 13) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx1110x0xxxxx00x011100xx
                                                         ins.  */
                                                      return 151;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx1111x0xxxxx00x011100xx
                                                         umov.  */
                                                      return 149;
                                                    }
                                                }
                                            }
                                        }
                                      else
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             xxxxxxxxxx1xxxx0xxxxx00x011101xx
                                             ins.  */
                                          return 153;
                                        }
                                    }
                                  else
                                    {
                                      if (((word >> 11) & 0x1) == 0)
                                        {
                                          if (((word >> 12) & 0x1) == 0)
                                            {
                                              if (((word >> 13) & 0x1) == 0)
                                                {
                                                  if (((word >> 23) & 0x1) == 0)
                                                    {
                                                      if (((word >> 29) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx1000x0xxxxx010011100xx
                                                             fmaxnm.  */
                                                          return 285;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx1000x0xxxxx010011101xx
                                                             fmaxnmp.  */
                                                          return 336;
                                                        }
                                                    }
                                                  else
                                                    {
                                                      if (((word >> 29) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx1000x0xxxxx011011100xx
                                                             fminnm.  */
                                                          return 301;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx1000x0xxxxx011011101xx
                                                             fminnmp.  */
                                                          return 352;
                                                        }
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 23) & 0x1) == 0)
                                                    {
                                                      if (((word >> 29) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx1001x0xxxxx010011100xx
                                                             fcmeq.  */
                                                          return 293;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx1001x0xxxxx010011101xx
                                                             fcmge.  */
                                                          return 342;
                                                        }
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx1001x0xxxxx01101110xxx
                                                         fcmgt.  */
                                                      return 356;
                                                    }
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 13) & 0x1) == 0)
                                                {
                                                  if (((word >> 23) & 0x1) == 0)
                                                    {
                                                      if (((word >> 29) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx1010x0xxxxx010011100xx
                                                             fadd.  */
                                                          return 289;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx1010x0xxxxx010011101xx
                                                             faddp.  */
                                                          return 338;
                                                        }
                                                    }
                                                  else
                                                    {
                                                      if (((word >> 29) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx1010x0xxxxx011011100xx
                                                             fsub.  */
                                                          return 305;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx1010x0xxxxx011011101xx
                                                             fabd.  */
                                                          return 354;
                                                        }
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 23) & 0x1) == 0)
                                                    {
                                                      if (((word >> 29) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx1011x0xxxxx010011100xx
                                                             fmax.  */
                                                          return 295;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx1011x0xxxxx010011101xx
                                                             fmaxp.  */
                                                          return 346;
                                                        }
                                                    }
                                                  else
                                                    {
                                                      if (((word >> 29) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx1011x0xxxxx011011100xx
                                                             fmin.  */
                                                          return 307;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx1011x0xxxxx011011101xx
                                                             fminp.  */
                                                          return 360;
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                      else
                                        {
                                          if (((word >> 12) & 0x1) == 0)
                                            {
                                              if (((word >> 13) & 0x1) == 0)
                                                {
                                                  if (((word >> 23) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx1100x0xxxxx01001110xxx
                                                         fmla.  */
                                                      return 287;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx1100x0xxxxx01101110xxx
                                                         fmls.  */
                                                      return 303;
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 23) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx1101x0xxxxx01001110xxx
                                                         facge.  */
                                                      return 344;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx1101x0xxxxx01101110xxx
                                                         facgt.  */
                                                      return 358;
                                                    }
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 13) & 0x1) == 0)
                                                {
                                                  if (((word >> 29) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx1110x0xxxxx01x011100xx
                                                         fmulx.  */
                                                      return 291;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx1110x0xxxxx01x011101xx
                                                         fmul.  */
                                                      return 340;
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 23) & 0x1) == 0)
                                                    {
                                                      if (((word >> 29) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx1111x0xxxxx010011100xx
                                                             frecps.  */
                                                          return 297;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx1111x0xxxxx010011101xx
                                                             fdiv.  */
                                                          return 348;
                                                        }
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx1111x0xxxxx01101110xxx
                                                         frsqrts.  */
                                                      return 309;
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                              else
                                {
                                  if (((word >> 11) & 0x1) == 0)
                                    {
                                      /* 33222222222211111111110000000000
                                         10987654321098765432109876543210
                                         xxxxxxxxxx10xxx1xxxxx0xx01110xxx
                                         sqrdmlah.  */
                                      return 363;
                                    }
                                  else
                                    {
                                      /* 33222222222211111111110000000000
                                         10987654321098765432109876543210
                                         xxxxxxxxxx11xxx1xxxxx0xx01110xxx
                                         sqrdmlsh.  */
                                      return 364;
                                    }
                                }
                            }
                        }
                      else
                        {
                          if (((word >> 29) & 0x1) == 0)
                            {
                              if (((word >> 30) & 0x1) == 0)
                                {
                                  if (((word >> 16) & 0x1) == 0)
                                    {
                                      if (((word >> 17) & 0x1) == 0)
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             xxxxxxxxxxxxxxxx00xxx0xx0111100x
                                             fcvtzs.  */
                                          return 718;
                                        }
                                      else
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             xxxxxxxxxxxxxxxx01xxx0xx0111100x
                                             scvtf.  */
                                          return 714;
                                        }
                                    }
                                  else
                                    {
                                      if (((word >> 17) & 0x1) == 0)
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             xxxxxxxxxxxxxxxx10xxx0xx0111100x
                                             fcvtzu.  */
                                          return 720;
                                        }
                                      else
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             xxxxxxxxxxxxxxxx11xxx0xx0111100x
                                             ucvtf.  */
                                          return 716;
                                        }
                                    }
                                }
                              else
                                {
                                  if (((word >> 10) & 0x1) == 0)
                                    {
                                      if (((word >> 12) & 0x1) == 0)
                                        {
                                          if (((word >> 13) & 0x1) == 0)
                                            {
                                              if (((word >> 14) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     xxxxxxxxxx0x000xxxxxx0xx0111101x
                                                     sha1c.  */
                                                  return 657;
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     xxxxxxxxxx0x001xxxxxx0xx0111101x
                                                     sha256h.  */
                                                  return 661;
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 14) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     xxxxxxxxxx0x010xxxxxx0xx0111101x
                                                     sha1m.  */
                                                  return 659;
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     xxxxxxxxxx0x011xxxxxx0xx0111101x
                                                     sha256su1.  */
                                                  return 663;
                                                }
                                            }
                                        }
                                      else
                                        {
                                          if (((word >> 13) & 0x1) == 0)
                                            {
                                              if (((word >> 14) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     xxxxxxxxxx0x100xxxxxx0xx0111101x
                                                     sha1p.  */
                                                  return 658;
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     xxxxxxxxxx0x101xxxxxx0xx0111101x
                                                     sha256h2.  */
                                                  return 662;
                                                }
                                            }
                                          else
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 xxxxxxxxxx0x11xxxxxxx0xx0111101x
                                                 sha1su0.  */
                                              return 660;
                                            }
                                        }
                                    }
                                  else
                                    {
                                      if (((word >> 11) & 0x1) == 0)
                                        {
                                          if (((word >> 13) & 0x1) == 0)
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 xxxxxxxxxx10x0xxxxxxx0xx0111101x
                                                 dup.  */
                                              return 526;
                                            }
                                          else
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 xxxxxxxxxx10x1xxxxxxx0xx0111101x
                                                 fcmeq.  */
                                              return 547;
                                            }
                                        }
                                      else
                                        {
                                          if (((word >> 13) & 0x1) == 0)
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 xxxxxxxxxx11x0xxxxxxx0xx0111101x
                                                 fmulx.  */
                                              return 545;
                                            }
                                          else
                                            {
                                              if (((word >> 23) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     xxxxxxxxxx11x1xxxxxxx0x00111101x
                                                     frecps.  */
                                                  return 549;
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     xxxxxxxxxx11x1xxxxxxx0x10111101x
                                                     frsqrts.  */
                                                  return 551;
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                          else
                            {
                              if (((word >> 11) & 0x1) == 0)
                                {
                                  if (((word >> 12) & 0x1) == 0)
                                    {
                                      if (((word >> 13) & 0x1) == 0)
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             xxxxxxxxxxx000xxxxxxx0xx011111xx
                                             sqrdmlah.  */
                                          return 579;
                                        }
                                      else
                                        {
                                          if (((word >> 23) & 0x1) == 0)
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 xxxxxxxxxxx001xxxxxxx0x0011111xx
                                                 fcmge.  */
                                              return 564;
                                            }
                                          else
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 xxxxxxxxxxx001xxxxxxx0x1011111xx
                                                 fcmgt.  */
                                              return 570;
                                            }
                                        }
                                    }
                                  else
                                    {
                                      /* 33222222222211111111110000000000
                                         10987654321098765432109876543210
                                         xxxxxxxxxxx01xxxxxxxx0xx011111xx
                                         fabd.  */
                                      return 568;
                                    }
                                }
                              else
                                {
                                  if (((word >> 13) & 0x1) == 0)
                                    {
                                      /* 33222222222211111111110000000000
                                         10987654321098765432109876543210
                                         xxxxxxxxxxx1x0xxxxxxx0xx011111xx
                                         sqrdmlsh.  */
                                      return 580;
                                    }
                                  else
                                    {
                                      if (((word >> 23) & 0x1) == 0)
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             xxxxxxxxxxx1x1xxxxxxx0x0011111xx
                                             facge.  */
                                          return 566;
                                        }
                                      else
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             xxxxxxxxxxx1x1xxxxxxx0x1011111xx
                                             facgt.  */
                                          return 572;
                                        }
                                    }
                                }
                            }
                        }
                    }
                  else
                    {
                      if (((word >> 10) & 0x1) == 0)
                        {
                          if (((word >> 11) & 0x1) == 0)
                            {
                              if (((word >> 12) & 0x1) == 0)
                                {
                                  if (((word >> 13) & 0x1) == 0)
                                    {
                                      if (((word >> 14) & 0x1) == 0)
                                        {
                                          if (((word >> 15) & 0x1) == 0)
                                            {
                                              if (((word >> 28) & 0x1) == 0)
                                                {
                                                  if (((word >> 29) & 0x1) == 0)
                                                    {
                                                      if (((word >> 30) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx000000xxxxx1xx0111000x
                                                             saddl.  */
                                                          return 42;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx000000xxxxx1xx0111001x
                                                             saddl2.  */
                                                          return 43;
                                                        }
                                                    }
                                                  else
                                                    {
                                                      if (((word >> 30) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx000000xxxxx1xx0111010x
                                                             uaddl.  */
                                                          return 74;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx000000xxxxx1xx0111011x
                                                             uaddl2.  */
                                                          return 75;
                                                        }
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 16) & 0x1) == 0)
                                                    {
                                                      if (((word >> 17) & 0x1) == 0)
                                                        {
                                                          if (((word >> 18) & 0x1) == 0)
                                                            {
                                                              if (((word >> 19) & 0x1) == 0)
                                                                {
                                                                  if (((word >> 20) & 0x1) == 0)
                                                                    {
                                                                      /* 33222222222211111111110000000000
                                                                         10987654321098765432109876543210
                                                                         xxxxxxxxxx000000000001xx01111xxx
                                                                         fcvtns.  */
                                                                      return 722;
                                                                    }
                                                                  else
                                                                    {
                                                                      /* 33222222222211111111110000000000
                                                                         10987654321098765432109876543210
                                                                         xxxxxxxxxx000000000011xx01111xxx
                                                                         fcvtms.  */
                                                                      return 742;
                                                                    }
                                                                }
                                                              else
                                                                {
                                                                  if (((word >> 20) & 0x1) == 0)
                                                                    {
                                                                      /* 33222222222211111111110000000000
                                                                         10987654321098765432109876543210
                                                                         xxxxxxxxxx000000000101xx01111xxx
                                                                         fcvtps.  */
                                                                      return 738;
                                                                    }
                                                                  else
                                                                    {
                                                                      /* 33222222222211111111110000000000
                                                                         10987654321098765432109876543210
                                                                         xxxxxxxxxx000000000111xx01111xxx
                                                                         fcvtzs.  */
                                                                      return 746;
                                                                    }
                                                                }
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx000000001xx1xx01111xxx
                                                                 fcvtas.  */
                                                              return 730;
                                                            }
                                                        }
                                                      else
                                                        {
                                                          if (((word >> 18) & 0x1) == 0)
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx000000010xx1xx01111xxx
                                                                 scvtf.  */
                                                              return 726;
                                                            }
                                                          else
                                                            {
                                                              if (((word >> 19) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     xxxxxxxxxx0000000110x1xx01111xxx
                                                                     fmov.  */
                                                                  return 734;
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     xxxxxxxxxx0000000111x1xx01111xxx
                                                                     fmov.  */
                                                                  return 750;
                                                                }
                                                            }
                                                        }
                                                    }
                                                  else
                                                    {
                                                      if (((word >> 17) & 0x1) == 0)
                                                        {
                                                          if (((word >> 18) & 0x1) == 0)
                                                            {
                                                              if (((word >> 19) & 0x1) == 0)
                                                                {
                                                                  if (((word >> 20) & 0x1) == 0)
                                                                    {
                                                                      /* 33222222222211111111110000000000
                                                                         10987654321098765432109876543210
                                                                         xxxxxxxxxx000000100001xx01111xxx
                                                                         fcvtnu.  */
                                                                      return 724;
                                                                    }
                                                                  else
                                                                    {
                                                                      /* 33222222222211111111110000000000
                                                                         10987654321098765432109876543210
                                                                         xxxxxxxxxx000000100011xx01111xxx
                                                                         fcvtmu.  */
                                                                      return 744;
                                                                    }
                                                                }
                                                              else
                                                                {
                                                                  if (((word >> 20) & 0x1) == 0)
                                                                    {
                                                                      /* 33222222222211111111110000000000
                                                                         10987654321098765432109876543210
                                                                         xxxxxxxxxx000000100101xx01111xxx
                                                                         fcvtpu.  */
                                                                      return 740;
                                                                    }
                                                                  else
                                                                    {
                                                                      /* 33222222222211111111110000000000
                                                                         10987654321098765432109876543210
                                                                         xxxxxxxxxx000000100111xx01111xxx
                                                                         fcvtzu.  */
                                                                      return 748;
                                                                    }
                                                                }
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx000000101xx1xx01111xxx
                                                                 fcvtau.  */
                                                              return 732;
                                                            }
                                                        }
                                                      else
                                                        {
                                                          if (((word >> 18) & 0x1) == 0)
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx000000110xx1xx01111xxx
                                                                 ucvtf.  */
                                                              return 728;
                                                            }
                                                          else
                                                            {
                                                              if (((word >> 19) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     xxxxxxxxxx0000001110x1xx01111xxx
                                                                     fmov.  */
                                                                  return 736;
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     xxxxxxxxxx0000001111x1xx01111xxx
                                                                     fmov.  */
                                                                  return 751;
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 29) & 0x1) == 0)
                                                {
                                                  if (((word >> 30) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx000001xxxxx1xx0111x00x
                                                         smlal.  */
                                                      return 58;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx000001xxxxx1xx0111x01x
                                                         smlal2.  */
                                                      return 59;
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 30) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx000001xxxxx1xx0111x10x
                                                         umlal.  */
                                                      return 90;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx000001xxxxx1xx0111x11x
                                                         umlal2.  */
                                                      return 91;
                                                    }
                                                }
                                            }
                                        }
                                      else
                                        {
                                          if (((word >> 28) & 0x1) == 0)
                                            {
                                              if (((word >> 15) & 0x1) == 0)
                                                {
                                                  if (((word >> 29) & 0x1) == 0)
                                                    {
                                                      if (((word >> 30) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx000010xxxxx1xx0111000x
                                                             addhn.  */
                                                          return 50;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx000010xxxxx1xx0111001x
                                                             addhn2.  */
                                                          return 51;
                                                        }
                                                    }
                                                  else
                                                    {
                                                      if (((word >> 30) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx000010xxxxx1xx0111010x
                                                             raddhn.  */
                                                          return 82;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx000010xxxxx1xx0111011x
                                                             raddhn2.  */
                                                          return 83;
                                                        }
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 29) & 0x1) == 0)
                                                    {
                                                      if (((word >> 30) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx000011xxxxx1xx0111000x
                                                             smull.  */
                                                          return 66;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx000011xxxxx1xx0111001x
                                                             smull2.  */
                                                          return 67;
                                                        }
                                                    }
                                                  else
                                                    {
                                                      if (((word >> 30) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx000011xxxxx1xx0111010x
                                                             umull.  */
                                                          return 94;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx000011xxxxx1xx0111011x
                                                             umull2.  */
                                                          return 95;
                                                        }
                                                    }
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 17) & 0x1) == 0)
                                                {
                                                  if (((word >> 15) & 0x1) == 0)
                                                    {
                                                      if (((word >> 16) & 0x1) == 0)
                                                        {
                                                          if (((word >> 18) & 0x1) == 0)
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx000010000xx1xx01111xxx
                                                                 fmov.  */
                                                              return 764;
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx000010001xx1xx01111xxx
                                                                 frintn.  */
                                                              return 773;
                                                            }
                                                        }
                                                      else
                                                        {
                                                          if (((word >> 18) & 0x1) == 0)
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx000010100xx1xx01111xxx
                                                                 fneg.  */
                                                              return 768;
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx000010101xx1xx01111xxx
                                                                 frintm.  */
                                                              return 777;
                                                            }
                                                        }
                                                    }
                                                  else
                                                    {
                                                      if (((word >> 16) & 0x1) == 0)
                                                        {
                                                          if (((word >> 18) & 0x1) == 0)
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx000011000xx1xx01111xxx
                                                                 fabs.  */
                                                              return 766;
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx000011001xx1xx01111xxx
                                                                 frintp.  */
                                                              return 775;
                                                            }
                                                        }
                                                      else
                                                        {
                                                          if (((word >> 18) & 0x1) == 0)
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx000011100xx1xx01111xxx
                                                                 fsqrt.  */
                                                              return 770;
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx000011101xx1xx01111xxx
                                                                 frintz.  */
                                                              return 779;
                                                            }
                                                        }
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 18) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx00001xx10xx1xx01111xxx
                                                         fcvt.  */
                                                      return 772;
                                                    }
                                                  else
                                                    {
                                                      if (((word >> 15) & 0x1) == 0)
                                                        {
                                                          if (((word >> 16) & 0x1) == 0)
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx000010011xx1xx01111xxx
                                                                 frinta.  */
                                                              return 781;
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx000010111xx1xx01111xxx
                                                                 frintx.  */
                                                              return 783;
                                                            }
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx000011x11xx1xx01111xxx
                                                             frinti.  */
                                                          return 785;
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                  else
                                    {
                                      if (((word >> 14) & 0x1) == 0)
                                        {
                                          if (((word >> 15) & 0x1) == 0)
                                            {
                                              if (((word >> 28) & 0x1) == 0)
                                                {
                                                  if (((word >> 29) & 0x1) == 0)
                                                    {
                                                      if (((word >> 30) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx000100xxxxx1xx0111000x
                                                             ssubl.  */
                                                          return 46;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx000100xxxxx1xx0111001x
                                                             ssubl2.  */
                                                          return 47;
                                                        }
                                                    }
                                                  else
                                                    {
                                                      if (((word >> 30) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx000100xxxxx1xx0111010x
                                                             usubl.  */
                                                          return 78;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx000100xxxxx1xx0111011x
                                                             usubl2.  */
                                                          return 79;
                                                        }
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 3) & 0x1) == 0)
                                                    {
                                                      if (((word >> 4) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxx00xxxxx000100xxxxx1xx01111xxx
                                                             fcmp.  */
                                                          return 756;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxx01xxxxx000100xxxxx1xx01111xxx
                                                             fcmpe.  */
                                                          return 758;
                                                        }
                                                    }
                                                  else
                                                    {
                                                      if (((word >> 4) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxx10xxxxx000100xxxxx1xx01111xxx
                                                             fcmp.  */
                                                          return 760;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxx11xxxxx000100xxxxx1xx01111xxx
                                                             fcmpe.  */
                                                          return 762;
                                                        }
                                                    }
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 29) & 0x1) == 0)
                                                {
                                                  if (((word >> 30) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx000101xxxxx1xx0111x00x
                                                         smlsl.  */
                                                      return 62;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx000101xxxxx1xx0111x01x
                                                         smlsl2.  */
                                                      return 63;
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 30) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx000101xxxxx1xx0111x10x
                                                         umlsl.  */
                                                      return 92;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx000101xxxxx1xx0111x11x
                                                         umlsl2.  */
                                                      return 93;
                                                    }
                                                }
                                            }
                                        }
                                      else
                                        {
                                          if (((word >> 15) & 0x1) == 0)
                                            {
                                              if (((word >> 29) & 0x1) == 0)
                                                {
                                                  if (((word >> 30) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx000110xxxxx1xx0111x00x
                                                         subhn.  */
                                                      return 54;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx000110xxxxx1xx0111x01x
                                                         subhn2.  */
                                                      return 55;
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 30) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx000110xxxxx1xx0111x10x
                                                         rsubhn.  */
                                                      return 86;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx000110xxxxx1xx0111x11x
                                                         rsubhn2.  */
                                                      return 87;
                                                    }
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 22) & 0x1) == 0)
                                                {
                                                  if (((word >> 30) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx000111xxxxx10x0111xx0x
                                                         pmull.  */
                                                      return 70;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx000111xxxxx10x0111xx1x
                                                         pmull2.  */
                                                      return 72;
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 30) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx000111xxxxx11x0111xx0x
                                                         pmull.  */
                                                      return 71;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx000111xxxxx11x0111xx1x
                                                         pmull2.  */
                                                      return 73;
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                              else
                                {
                                  if (((word >> 28) & 0x1) == 0)
                                    {
                                      if (((word >> 13) & 0x1) == 0)
                                        {
                                          if (((word >> 14) & 0x1) == 0)
                                            {
                                              if (((word >> 15) & 0x1) == 0)
                                                {
                                                  if (((word >> 29) & 0x1) == 0)
                                                    {
                                                      if (((word >> 30) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx001000xxxxx1xx0111000x
                                                             saddw.  */
                                                          return 44;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx001000xxxxx1xx0111001x
                                                             saddw2.  */
                                                          return 45;
                                                        }
                                                    }
                                                  else
                                                    {
                                                      if (((word >> 30) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx001000xxxxx1xx0111010x
                                                             uaddw.  */
                                                          return 76;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx001000xxxxx1xx0111011x
                                                             uaddw2.  */
                                                          return 77;
                                                        }
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 30) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx001001xxxxx1xx01110x0x
                                                         sqdmlal.  */
                                                      return 60;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx001001xxxxx1xx01110x1x
                                                         sqdmlal2.  */
                                                      return 61;
                                                    }
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 15) & 0x1) == 0)
                                                {
                                                  if (((word >> 29) & 0x1) == 0)
                                                    {
                                                      if (((word >> 30) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx001010xxxxx1xx0111000x
                                                             sabal.  */
                                                          return 52;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx001010xxxxx1xx0111001x
                                                             sabal2.  */
                                                          return 53;
                                                        }
                                                    }
                                                  else
                                                    {
                                                      if (((word >> 30) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx001010xxxxx1xx0111010x
                                                             uabal.  */
                                                          return 84;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx001010xxxxx1xx0111011x
                                                             uabal2.  */
                                                          return 85;
                                                        }
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 30) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx001011xxxxx1xx01110x0x
                                                         sqdmull.  */
                                                      return 68;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx001011xxxxx1xx01110x1x
                                                         sqdmull2.  */
                                                      return 69;
                                                    }
                                                }
                                            }
                                        }
                                      else
                                        {
                                          if (((word >> 14) & 0x1) == 0)
                                            {
                                              if (((word >> 15) & 0x1) == 0)
                                                {
                                                  if (((word >> 29) & 0x1) == 0)
                                                    {
                                                      if (((word >> 30) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx001100xxxxx1xx0111000x
                                                             ssubw.  */
                                                          return 48;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx001100xxxxx1xx0111001x
                                                             ssubw2.  */
                                                          return 49;
                                                        }
                                                    }
                                                  else
                                                    {
                                                      if (((word >> 30) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx001100xxxxx1xx0111010x
                                                             usubw.  */
                                                          return 80;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx001100xxxxx1xx0111011x
                                                             usubw2.  */
                                                          return 81;
                                                        }
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 30) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx001101xxxxx1xx01110x0x
                                                         sqdmlsl.  */
                                                      return 64;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx001101xxxxx1xx01110x1x
                                                         sqdmlsl2.  */
                                                      return 65;
                                                    }
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 29) & 0x1) == 0)
                                                {
                                                  if (((word >> 30) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx00111xxxxxx1xx0111000x
                                                         sabdl.  */
                                                      return 56;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx00111xxxxxx1xx0111001x
                                                         sabdl2.  */
                                                      return 57;
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 30) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx00111xxxxxx1xx0111010x
                                                         uabdl.  */
                                                      return 88;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx00111xxxxxx1xx0111011x
                                                         uabdl2.  */
                                                      return 89;
                                                    }
                                                }
                                            }
                                        }
                                    }
                                  else
                                    {
                                      if (((word >> 30) & 0x1) == 0)
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             xxxxxxxxxx001xxxxxxxx1xx01111x0x
                                             fmov.  */
                                          return 813;
                                        }
                                      else
                                        {
                                          if (((word >> 13) & 0x1) == 0)
                                            {
                                              if (((word >> 14) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     xxxxxxxxxx00100xxxxxx1xx01111x1x
                                                     sqdmlal.  */
                                                  return 413;
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     xxxxxxxxxx00101xxxxxx1xx01111x1x
                                                     sqdmull.  */
                                                  return 415;
                                                }
                                            }
                                          else
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 xxxxxxxxxx0011xxxxxxx1xx01111x1x
                                                 sqdmlsl.  */
                                              return 414;
                                            }
                                        }
                                    }
                                }
                            }
                          else
                            {
                              if (((word >> 12) & 0x1) == 0)
                                {
                                  if (((word >> 13) & 0x1) == 0)
                                    {
                                      if (((word >> 14) & 0x1) == 0)
                                        {
                                          if (((word >> 15) & 0x1) == 0)
                                            {
                                              if (((word >> 28) & 0x1) == 0)
                                                {
                                                  if (((word >> 29) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx010000xxxxx1xx011100xx
                                                         rev64.  */
                                                      return 155;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx010000xxxxx1xx011101xx
                                                         rev32.  */
                                                      return 206;
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 30) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx010000xxxxx1xx01111x0x
                                                         fmul.  */
                                                      return 787;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx010000xxxxx1xx01111x1x
                                                         sha1h.  */
                                                      return 654;
                                                    }
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 28) & 0x1) == 0)
                                                {
                                                  if (((word >> 16) & 0x1) == 0)
                                                    {
                                                      if (((word >> 29) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx0100010xxxx1xx011100xx
                                                             cmgt.  */
                                                          return 163;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx0100010xxxx1xx011101xx
                                                             cmge.  */
                                                          return 212;
                                                        }
                                                    }
                                                  else
                                                    {
                                                      if (((word >> 19) & 0x1) == 0)
                                                        {
                                                          if (((word >> 23) & 0x1) == 0)
                                                            {
                                                              if (((word >> 29) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     xxxxxxxxxx0100011xx0x1x0011100xx
                                                                     frintn.  */
                                                                  return 175;
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     xxxxxxxxxx0100011xx0x1x0011101xx
                                                                     frinta.  */
                                                                  return 223;
                                                                }
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx0100011xx0x1x101110xxx
                                                                 frintp.  */
                                                              return 195;
                                                            }
                                                        }
                                                      else
                                                        {
                                                          if (((word >> 23) & 0x1) == 0)
                                                            {
                                                              if (((word >> 29) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     xxxxxxxxxx0100011xx1x1x0011100xx
                                                                     frintn.  */
                                                                  return 176;
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     xxxxxxxxxx0100011xx1x1x0011101xx
                                                                     frinta.  */
                                                                  return 224;
                                                                }
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx0100011xx1x1x101110xxx
                                                                 frintp.  */
                                                              return 196;
                                                            }
                                                        }
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 29) & 0x1) == 0)
                                                    {
                                                      if (((word >> 30) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx010001xxxxx1xx0111100x
                                                             fnmul.  */
                                                          return 803;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx010001xxxxx1xx0111101x
                                                             cmgt.  */
                                                          return 473;
                                                        }
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx010001xxxxx1xx011111xx
                                                         cmge.  */
                                                      return 502;
                                                    }
                                                }
                                            }
                                        }
                                      else
                                        {
                                          if (((word >> 15) & 0x1) == 0)
                                            {
                                              if (((word >> 28) & 0x1) == 0)
                                                {
                                                  if (((word >> 16) & 0x1) == 0)
                                                    {
                                                      if (((word >> 19) & 0x1) == 0)
                                                        {
                                                          if (((word >> 29) & 0x1) == 0)
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx0100100xx0x1xx011100xx
                                                                 cls.  */
                                                              return 159;
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx0100100xx0x1xx011101xx
                                                                 clz.  */
                                                              return 209;
                                                            }
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx0100100xx1x1xx01110xxx
                                                             aese.  */
                                                          return 650;
                                                        }
                                                    }
                                                  else
                                                    {
                                                      if (((word >> 29) & 0x1) == 0)
                                                        {
                                                          if (((word >> 30) & 0x1) == 0)
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx0100101xxxx1xx0111000x
                                                                 sqxtn.  */
                                                              return 169;
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx0100101xxxx1xx0111001x
                                                                 sqxtn2.  */
                                                              return 170;
                                                            }
                                                        }
                                                      else
                                                        {
                                                          if (((word >> 30) & 0x1) == 0)
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx0100101xxxx1xx0111010x
                                                                 uqxtn.  */
                                                              return 219;
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx0100101xxxx1xx0111011x
                                                                 uqxtn2.  */
                                                              return 220;
                                                            }
                                                        }
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 29) & 0x1) == 0)
                                                    {
                                                      if (((word >> 30) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx010010xxxxx1xx0111100x
                                                             fmax.  */
                                                          return 795;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx010010xxxxx1xx0111101x
                                                             sqxtn.  */
                                                          return 477;
                                                        }
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx010010xxxxx1xx011111xx
                                                         uqxtn.  */
                                                      return 506;
                                                    }
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 16) & 0x1) == 0)
                                                {
                                                  if (((word >> 19) & 0x1) == 0)
                                                    {
                                                      if (((word >> 20) & 0x1) == 0)
                                                        {
                                                          if (((word >> 28) & 0x1) == 0)
                                                            {
                                                              if (((word >> 29) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     xxxxxxxxxx0100110xx001xx011100xx
                                                                     fcmgt.  */
                                                                  return 187;
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     xxxxxxxxxx0100110xx001xx011101xx
                                                                     fcmge.  */
                                                                  return 238;
                                                                }
                                                            }
                                                          else
                                                            {
                                                              if (((word >> 29) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     xxxxxxxxxx0100110xx001xx011110xx
                                                                     fcmgt.  */
                                                                  return 486;
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     xxxxxxxxxx0100110xx001xx011111xx
                                                                     fcmge.  */
                                                                  return 516;
                                                                }
                                                            }
                                                        }
                                                      else
                                                        {
                                                          if (((word >> 23) & 0x1) == 0)
                                                            {
                                                              if (((word >> 28) & 0x1) == 0)
                                                                {
                                                                  if (((word >> 29) & 0x1) == 0)
                                                                    {
                                                                      /* 33222222222211111111110000000000
                                                                         10987654321098765432109876543210
                                                                         xxxxxxxxxx0100110xx011x0011100xx
                                                                         fmaxnmv.  */
                                                                      return 35;
                                                                    }
                                                                  else
                                                                    {
                                                                      /* 33222222222211111111110000000000
                                                                         10987654321098765432109876543210
                                                                         xxxxxxxxxx0100110xx011x0011101xx
                                                                         fmaxnmv.  */
                                                                      return 34;
                                                                    }
                                                                }
                                                              else
                                                                {
                                                                  if (((word >> 29) & 0x1) == 0)
                                                                    {
                                                                      /* 33222222222211111111110000000000
                                                                         10987654321098765432109876543210
                                                                         xxxxxxxxxx0100110xx011x0011110xx
                                                                         fmaxnmp.  */
                                                                      return 530;
                                                                    }
                                                                  else
                                                                    {
                                                                      /* 33222222222211111111110000000000
                                                                         10987654321098765432109876543210
                                                                         xxxxxxxxxx0100110xx011x0011111xx
                                                                         fmaxnmp.  */
                                                                      return 529;
                                                                    }
                                                                }
                                                            }
                                                          else
                                                            {
                                                              if (((word >> 28) & 0x1) == 0)
                                                                {
                                                                  if (((word >> 29) & 0x1) == 0)
                                                                    {
                                                                      /* 33222222222211111111110000000000
                                                                         10987654321098765432109876543210
                                                                         xxxxxxxxxx0100110xx011x1011100xx
                                                                         fminnmv.  */
                                                                      return 39;
                                                                    }
                                                                  else
                                                                    {
                                                                      /* 33222222222211111111110000000000
                                                                         10987654321098765432109876543210
                                                                         xxxxxxxxxx0100110xx011x1011101xx
                                                                         fminnmv.  */
                                                                      return 38;
                                                                    }
                                                                }
                                                              else
                                                                {
                                                                  if (((word >> 29) & 0x1) == 0)
                                                                    {
                                                                      /* 33222222222211111111110000000000
                                                                         10987654321098765432109876543210
                                                                         xxxxxxxxxx0100110xx011x1011110xx
                                                                         fminnmp.  */
                                                                      return 536;
                                                                    }
                                                                  else
                                                                    {
                                                                      /* 33222222222211111111110000000000
                                                                         10987654321098765432109876543210
                                                                         xxxxxxxxxx0100110xx011x1011111xx
                                                                         fminnmp.  */
                                                                      return 535;
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                  else
                                                    {
                                                      if (((word >> 28) & 0x1) == 0)
                                                        {
                                                          if (((word >> 29) & 0x1) == 0)
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx0100110xx1x1xx011100xx
                                                                 fcmgt.  */
                                                              return 188;
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx0100110xx1x1xx011101xx
                                                                 fcmge.  */
                                                              return 239;
                                                            }
                                                        }
                                                      else
                                                        {
                                                          if (((word >> 29) & 0x1) == 0)
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx0100110xx1x1xx011110xx
                                                                 fcmgt.  */
                                                              return 487;
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx0100110xx1x1xx011111xx
                                                                 fcmge.  */
                                                              return 517;
                                                            }
                                                        }
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 19) & 0x1) == 0)
                                                    {
                                                      if (((word >> 23) & 0x1) == 0)
                                                        {
                                                          if (((word >> 28) & 0x1) == 0)
                                                            {
                                                              if (((word >> 29) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     xxxxxxxxxx0100111xx0x1x0011100xx
                                                                     fcvtas.  */
                                                                  return 183;
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     xxxxxxxxxx0100111xx0x1x0011101xx
                                                                     fcvtau.  */
                                                                  return 231;
                                                                }
                                                            }
                                                          else
                                                            {
                                                              if (((word >> 29) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     xxxxxxxxxx0100111xx0x1x0011110xx
                                                                     fcvtas.  */
                                                                  return 482;
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     xxxxxxxxxx0100111xx0x1x0011111xx
                                                                     fcvtau.  */
                                                                  return 512;
                                                                }
                                                            }
                                                        }
                                                      else
                                                        {
                                                          if (((word >> 29) & 0x1) == 0)
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx0100111xx0x1x10111x0xx
                                                                 urecpe.  */
                                                              return 203;
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx0100111xx0x1x10111x1xx
                                                                 ursqrte.  */
                                                              return 250;
                                                            }
                                                        }
                                                    }
                                                  else
                                                    {
                                                      if (((word >> 28) & 0x1) == 0)
                                                        {
                                                          if (((word >> 29) & 0x1) == 0)
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx0100111xx1x1xx011100xx
                                                                 fcvtas.  */
                                                              return 184;
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx0100111xx1x1xx011101xx
                                                                 fcvtau.  */
                                                              return 232;
                                                            }
                                                        }
                                                      else
                                                        {
                                                          if (((word >> 29) & 0x1) == 0)
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx0100111xx1x1xx011110xx
                                                                 fcvtas.  */
                                                              return 483;
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx0100111xx1x1xx011111xx
                                                                 fcvtau.  */
                                                              return 513;
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                  else
                                    {
                                      if (((word >> 14) & 0x1) == 0)
                                        {
                                          if (((word >> 15) & 0x1) == 0)
                                            {
                                              if (((word >> 28) & 0x1) == 0)
                                                {
                                                  if (((word >> 16) & 0x1) == 0)
                                                    {
                                                      if (((word >> 29) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx0101000xxxx1xx011100xx
                                                             saddlp.  */
                                                          return 157;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx0101000xxxx1xx011101xx
                                                             uaddlp.  */
                                                          return 207;
                                                        }
                                                    }
                                                  else
                                                    {
                                                      if (((word >> 29) & 0x1) == 0)
                                                        {
                                                          if (((word >> 30) & 0x1) == 0)
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx0101001xxxx1xx0111000x
                                                                 xtn.  */
                                                              return 167;
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx0101001xxxx1xx0111001x
                                                                 xtn2.  */
                                                              return 168;
                                                            }
                                                        }
                                                      else
                                                        {
                                                          if (((word >> 30) & 0x1) == 0)
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx0101001xxxx1xx0111010x
                                                                 sqxtun.  */
                                                              return 215;
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx0101001xxxx1xx0111011x
                                                                 sqxtun2.  */
                                                              return 216;
                                                            }
                                                        }
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 29) & 0x1) == 0)
                                                    {
                                                      if (((word >> 30) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx010100xxxxx1xx0111100x
                                                             fadd.  */
                                                          return 791;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx010100xxxxx1xx0111101x
                                                             sha256su0.  */
                                                          return 656;
                                                        }
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx010100xxxxx1xx011111xx
                                                         sqxtun.  */
                                                      return 505;
                                                    }
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 16) & 0x1) == 0)
                                                {
                                                  if (((word >> 20) & 0x1) == 0)
                                                    {
                                                      if (((word >> 28) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx0101010xxx01xx01110xxx
                                                             cmlt.  */
                                                          return 165;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx0101010xxx01xx01111xxx
                                                             cmlt.  */
                                                          return 475;
                                                        }
                                                    }
                                                  else
                                                    {
                                                      if (((word >> 29) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx0101010xxx11xx0111x0xx
                                                             smaxv.  */
                                                          return 28;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx0101010xxx11xx0111x1xx
                                                             umaxv.  */
                                                          return 32;
                                                        }
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 19) & 0x1) == 0)
                                                    {
                                                      if (((word >> 20) & 0x1) == 0)
                                                        {
                                                          if (((word >> 23) & 0x1) == 0)
                                                            {
                                                              if (((word >> 28) & 0x1) == 0)
                                                                {
                                                                  if (((word >> 29) & 0x1) == 0)
                                                                    {
                                                                      /* 33222222222211111111110000000000
                                                                         10987654321098765432109876543210
                                                                         xxxxxxxxxx0101011xx001x0011100xx
                                                                         fcvtns.  */
                                                                      return 179;
                                                                    }
                                                                  else
                                                                    {
                                                                      /* 33222222222211111111110000000000
                                                                         10987654321098765432109876543210
                                                                         xxxxxxxxxx0101011xx001x0011101xx
                                                                         fcvtnu.  */
                                                                      return 227;
                                                                    }
                                                                }
                                                              else
                                                                {
                                                                  if (((word >> 29) & 0x1) == 0)
                                                                    {
                                                                      /* 33222222222211111111110000000000
                                                                         10987654321098765432109876543210
                                                                         xxxxxxxxxx0101011xx001x0011110xx
                                                                         fcvtns.  */
                                                                      return 478;
                                                                    }
                                                                  else
                                                                    {
                                                                      /* 33222222222211111111110000000000
                                                                         10987654321098765432109876543210
                                                                         xxxxxxxxxx0101011xx001x0011111xx
                                                                         fcvtnu.  */
                                                                      return 508;
                                                                    }
                                                                }
                                                            }
                                                          else
                                                            {
                                                              if (((word >> 28) & 0x1) == 0)
                                                                {
                                                                  if (((word >> 29) & 0x1) == 0)
                                                                    {
                                                                      /* 33222222222211111111110000000000
                                                                         10987654321098765432109876543210
                                                                         xxxxxxxxxx0101011xx001x1011100xx
                                                                         fcvtps.  */
                                                                      return 199;
                                                                    }
                                                                  else
                                                                    {
                                                                      /* 33222222222211111111110000000000
                                                                         10987654321098765432109876543210
                                                                         xxxxxxxxxx0101011xx001x1011101xx
                                                                         fcvtpu.  */
                                                                      return 246;
                                                                    }
                                                                }
                                                              else
                                                                {
                                                                  if (((word >> 29) & 0x1) == 0)
                                                                    {
                                                                      /* 33222222222211111111110000000000
                                                                         10987654321098765432109876543210
                                                                         xxxxxxxxxx0101011xx001x1011110xx
                                                                         fcvtps.  */
                                                                      return 492;
                                                                    }
                                                                  else
                                                                    {
                                                                      /* 33222222222211111111110000000000
                                                                         10987654321098765432109876543210
                                                                         xxxxxxxxxx0101011xx001x1011111xx
                                                                         fcvtpu.  */
                                                                      return 520;
                                                                    }
                                                                }
                                                            }
                                                        }
                                                      else
                                                        {
                                                          if (((word >> 29) & 0x1) == 0)
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx0101011xx011xx0111x0xx
                                                                 sminv.  */
                                                              return 29;
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx0101011xx011xx0111x1xx
                                                                 uminv.  */
                                                              return 33;
                                                            }
                                                        }
                                                    }
                                                  else
                                                    {
                                                      if (((word >> 23) & 0x1) == 0)
                                                        {
                                                          if (((word >> 28) & 0x1) == 0)
                                                            {
                                                              if (((word >> 29) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     xxxxxxxxxx0101011xx1x1x0011100xx
                                                                     fcvtns.  */
                                                                  return 180;
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     xxxxxxxxxx0101011xx1x1x0011101xx
                                                                     fcvtnu.  */
                                                                  return 228;
                                                                }
                                                            }
                                                          else
                                                            {
                                                              if (((word >> 29) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     xxxxxxxxxx0101011xx1x1x0011110xx
                                                                     fcvtns.  */
                                                                  return 479;
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     xxxxxxxxxx0101011xx1x1x0011111xx
                                                                     fcvtnu.  */
                                                                  return 509;
                                                                }
                                                            }
                                                        }
                                                      else
                                                        {
                                                          if (((word >> 28) & 0x1) == 0)
                                                            {
                                                              if (((word >> 29) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     xxxxxxxxxx0101011xx1x1x1011100xx
                                                                     fcvtps.  */
                                                                  return 200;
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     xxxxxxxxxx0101011xx1x1x1011101xx
                                                                     fcvtpu.  */
                                                                  return 247;
                                                                }
                                                            }
                                                          else
                                                            {
                                                              if (((word >> 29) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     xxxxxxxxxx0101011xx1x1x1011110xx
                                                                     fcvtps.  */
                                                                  return 493;
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     xxxxxxxxxx0101011xx1x1x1011111xx
                                                                     fcvtpu.  */
                                                                  return 521;
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                      else
                                        {
                                          if (((word >> 15) & 0x1) == 0)
                                            {
                                              if (((word >> 28) & 0x1) == 0)
                                                {
                                                  if (((word >> 16) & 0x1) == 0)
                                                    {
                                                      if (((word >> 19) & 0x1) == 0)
                                                        {
                                                          if (((word >> 29) & 0x1) == 0)
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx0101100xx0x1xx011100xx
                                                                 sadalp.  */
                                                              return 161;
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx0101100xx0x1xx011101xx
                                                                 uadalp.  */
                                                              return 210;
                                                            }
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx0101100xx1x1xx01110xxx
                                                             aesmc.  */
                                                          return 652;
                                                        }
                                                    }
                                                  else
                                                    {
                                                      if (((word >> 29) & 0x1) == 0)
                                                        {
                                                          if (((word >> 30) & 0x1) == 0)
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx0101101xxxx1xx0111000x
                                                                 fcvtn.  */
                                                              return 171;
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx0101101xxxx1xx0111001x
                                                                 fcvtn2.  */
                                                              return 172;
                                                            }
                                                        }
                                                      else
                                                        {
                                                          if (((word >> 30) & 0x1) == 0)
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx0101101xxxx1xx0111010x
                                                                 fcvtxn.  */
                                                              return 221;
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx0101101xxxx1xx0111011x
                                                                 fcvtxn2.  */
                                                              return 222;
                                                            }
                                                        }
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 29) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx010110xxxxx1xx011110xx
                                                         fmaxnm.  */
                                                      return 799;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx010110xxxxx1xx011111xx
                                                         fcvtxn.  */
                                                      return 507;
                                                    }
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 19) & 0x1) == 0)
                                                {
                                                  if (((word >> 28) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx010111xxx0x1xx01110xxx
                                                         fcmlt.  */
                                                      return 191;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx010111xxx0x1xx01111xxx
                                                         fcmlt.  */
                                                      return 490;
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 28) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx010111xxx1x1xx01110xxx
                                                         fcmlt.  */
                                                      return 192;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx010111xxx1x1xx01111xxx
                                                         fcmlt.  */
                                                      return 491;
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                              else
                                {
                                  if (((word >> 13) & 0x1) == 0)
                                    {
                                      if (((word >> 14) & 0x1) == 0)
                                        {
                                          if (((word >> 15) & 0x1) == 0)
                                            {
                                              if (((word >> 28) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     xxxxxxxxxx011000xxxxx1xx01110xxx
                                                     rev16.  */
                                                  return 156;
                                                }
                                              else
                                                {
                                                  if (((word >> 30) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx011000xxxxx1xx01111x0x
                                                         fdiv.  */
                                                      return 789;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx011000xxxxx1xx01111x1x
                                                         sha1su1.  */
                                                      return 655;
                                                    }
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 16) & 0x1) == 0)
                                                {
                                                  if (((word >> 28) & 0x1) == 0)
                                                    {
                                                      if (((word >> 29) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx0110010xxxx1xx011100xx
                                                             cmeq.  */
                                                          return 164;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx0110010xxxx1xx011101xx
                                                             cmle.  */
                                                          return 213;
                                                        }
                                                    }
                                                  else
                                                    {
                                                      if (((word >> 29) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx0110010xxxx1xx011110xx
                                                             cmeq.  */
                                                          return 474;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx0110010xxxx1xx011111xx
                                                             cmle.  */
                                                          return 503;
                                                        }
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 19) & 0x1) == 0)
                                                    {
                                                      if (((word >> 23) & 0x1) == 0)
                                                        {
                                                          if (((word >> 29) & 0x1) == 0)
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx0110011xx0x1x00111x0xx
                                                                 frintm.  */
                                                              return 177;
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx0110011xx0x1x00111x1xx
                                                                 frintx.  */
                                                              return 225;
                                                            }
                                                        }
                                                      else
                                                        {
                                                          if (((word >> 29) & 0x1) == 0)
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx0110011xx0x1x10111x0xx
                                                                 frintz.  */
                                                              return 197;
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx0110011xx0x1x10111x1xx
                                                                 frinti.  */
                                                              return 244;
                                                            }
                                                        }
                                                    }
                                                  else
                                                    {
                                                      if (((word >> 23) & 0x1) == 0)
                                                        {
                                                          if (((word >> 29) & 0x1) == 0)
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx0110011xx1x1x00111x0xx
                                                                 frintm.  */
                                                              return 178;
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx0110011xx1x1x00111x1xx
                                                                 frintx.  */
                                                              return 226;
                                                            }
                                                        }
                                                      else
                                                        {
                                                          if (((word >> 29) & 0x1) == 0)
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx0110011xx1x1x10111x0xx
                                                                 frintz.  */
                                                              return 198;
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx0110011xx1x1x10111x1xx
                                                                 frinti.  */
                                                              return 245;
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                      else
                                        {
                                          if (((word >> 15) & 0x1) == 0)
                                            {
                                              if (((word >> 28) & 0x1) == 0)
                                                {
                                                  if (((word >> 19) & 0x1) == 0)
                                                    {
                                                      if (((word >> 29) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx011010xxx0x1xx011100xx
                                                             cnt.  */
                                                          return 160;
                                                        }
                                                      else
                                                        {
                                                          if (((word >> 22) & 0x1) == 0)
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx011010xxx0x10x011101xx
                                                                 not.  */
                                                              return 235;
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx011010xxx0x11x011101xx
                                                                 rbit.  */
                                                              return 237;
                                                            }
                                                        }
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx011010xxx1x1xx01110xxx
                                                         aesd.  */
                                                      return 651;
                                                    }
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     xxxxxxxxxx011010xxxxx1xx01111xxx
                                                     fmin.  */
                                                  return 797;
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 16) & 0x1) == 0)
                                                {
                                                  if (((word >> 19) & 0x1) == 0)
                                                    {
                                                      if (((word >> 20) & 0x1) == 0)
                                                        {
                                                          if (((word >> 28) & 0x1) == 0)
                                                            {
                                                              if (((word >> 29) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     xxxxxxxxxx0110110xx001xx011100xx
                                                                     fcmeq.  */
                                                                  return 189;
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     xxxxxxxxxx0110110xx001xx011101xx
                                                                     fcmle.  */
                                                                  return 240;
                                                                }
                                                            }
                                                          else
                                                            {
                                                              if (((word >> 29) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     xxxxxxxxxx0110110xx001xx011110xx
                                                                     fcmeq.  */
                                                                  return 488;
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     xxxxxxxxxx0110110xx001xx011111xx
                                                                     fcmle.  */
                                                                  return 518;
                                                                }
                                                            }
                                                        }
                                                      else
                                                        {
                                                          if (((word >> 29) & 0x1) == 0)
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx0110110xx011xx0111x0xx
                                                                 faddp.  */
                                                              return 532;
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx0110110xx011xx0111x1xx
                                                                 faddp.  */
                                                              return 531;
                                                            }
                                                        }
                                                    }
                                                  else
                                                    {
                                                      if (((word >> 28) & 0x1) == 0)
                                                        {
                                                          if (((word >> 29) & 0x1) == 0)
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx0110110xx1x1xx011100xx
                                                                 fcmeq.  */
                                                              return 190;
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx0110110xx1x1xx011101xx
                                                                 fcmle.  */
                                                              return 241;
                                                            }
                                                        }
                                                      else
                                                        {
                                                          if (((word >> 29) & 0x1) == 0)
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx0110110xx1x1xx011110xx
                                                                 fcmeq.  */
                                                              return 489;
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx0110110xx1x1xx011111xx
                                                                 fcmle.  */
                                                              return 519;
                                                            }
                                                        }
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 19) & 0x1) == 0)
                                                    {
                                                      if (((word >> 23) & 0x1) == 0)
                                                        {
                                                          if (((word >> 28) & 0x1) == 0)
                                                            {
                                                              if (((word >> 29) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     xxxxxxxxxx0110111xx0x1x0011100xx
                                                                     scvtf.  */
                                                                  return 185;
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     xxxxxxxxxx0110111xx0x1x0011101xx
                                                                     ucvtf.  */
                                                                  return 233;
                                                                }
                                                            }
                                                          else
                                                            {
                                                              if (((word >> 29) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     xxxxxxxxxx0110111xx0x1x0011110xx
                                                                     scvtf.  */
                                                                  return 484;
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     xxxxxxxxxx0110111xx0x1x0011111xx
                                                                     ucvtf.  */
                                                                  return 514;
                                                                }
                                                            }
                                                        }
                                                      else
                                                        {
                                                          if (((word >> 28) & 0x1) == 0)
                                                            {
                                                              if (((word >> 29) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     xxxxxxxxxx0110111xx0x1x1011100xx
                                                                     frecpe.  */
                                                                  return 204;
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     xxxxxxxxxx0110111xx0x1x1011101xx
                                                                     frsqrte.  */
                                                                  return 251;
                                                                }
                                                            }
                                                          else
                                                            {
                                                              if (((word >> 29) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     xxxxxxxxxx0110111xx0x1x1011110xx
                                                                     frecpe.  */
                                                                  return 496;
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     xxxxxxxxxx0110111xx0x1x1011111xx
                                                                     frsqrte.  */
                                                                  return 524;
                                                                }
                                                            }
                                                        }
                                                    }
                                                  else
                                                    {
                                                      if (((word >> 23) & 0x1) == 0)
                                                        {
                                                          if (((word >> 28) & 0x1) == 0)
                                                            {
                                                              if (((word >> 29) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     xxxxxxxxxx0110111xx1x1x0011100xx
                                                                     scvtf.  */
                                                                  return 186;
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     xxxxxxxxxx0110111xx1x1x0011101xx
                                                                     ucvtf.  */
                                                                  return 234;
                                                                }
                                                            }
                                                          else
                                                            {
                                                              if (((word >> 29) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     xxxxxxxxxx0110111xx1x1x0011110xx
                                                                     scvtf.  */
                                                                  return 485;
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     xxxxxxxxxx0110111xx1x1x0011111xx
                                                                     ucvtf.  */
                                                                  return 515;
                                                                }
                                                            }
                                                        }
                                                      else
                                                        {
                                                          if (((word >> 28) & 0x1) == 0)
                                                            {
                                                              if (((word >> 29) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     xxxxxxxxxx0110111xx1x1x1011100xx
                                                                     frecpe.  */
                                                                  return 205;
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     xxxxxxxxxx0110111xx1x1x1011101xx
                                                                     frsqrte.  */
                                                                  return 252;
                                                                }
                                                            }
                                                          else
                                                            {
                                                              if (((word >> 29) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     xxxxxxxxxx0110111xx1x1x1011110xx
                                                                     frecpe.  */
                                                                  return 497;
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     xxxxxxxxxx0110111xx1x1x1011111xx
                                                                     frsqrte.  */
                                                                  return 525;
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                  else
                                    {
                                      if (((word >> 14) & 0x1) == 0)
                                        {
                                          if (((word >> 15) & 0x1) == 0)
                                            {
                                              if (((word >> 28) & 0x1) == 0)
                                                {
                                                  if (((word >> 16) & 0x1) == 0)
                                                    {
                                                      if (((word >> 20) & 0x1) == 0)
                                                        {
                                                          if (((word >> 29) & 0x1) == 0)
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx0111000xxx01xx011100xx
                                                                 suqadd.  */
                                                              return 158;
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx0111000xxx01xx011101xx
                                                                 usqadd.  */
                                                              return 208;
                                                            }
                                                        }
                                                      else
                                                        {
                                                          if (((word >> 29) & 0x1) == 0)
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx0111000xxx11xx011100xx
                                                                 saddlv.  */
                                                              return 27;
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx0111000xxx11xx011101xx
                                                                 uaddlv.  */
                                                              return 31;
                                                            }
                                                        }
                                                    }
                                                  else
                                                    {
                                                      if (((word >> 30) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx0111001xxxx1xx01110x0x
                                                             shll.  */
                                                          return 217;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx0111001xxxx1xx01110x1x
                                                             shll2.  */
                                                          return 218;
                                                        }
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 29) & 0x1) == 0)
                                                    {
                                                      if (((word >> 30) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx011100xxxxx1xx0111100x
                                                             fsub.  */
                                                          return 793;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx011100xxxxx1xx0111101x
                                                             suqadd.  */
                                                          return 471;
                                                        }
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx011100xxxxx1xx011111xx
                                                         usqadd.  */
                                                      return 500;
                                                    }
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 16) & 0x1) == 0)
                                                {
                                                  if (((word >> 28) & 0x1) == 0)
                                                    {
                                                      if (((word >> 29) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx0111010xxxx1xx011100xx
                                                             abs.  */
                                                          return 166;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx0111010xxxx1xx011101xx
                                                             neg.  */
                                                          return 214;
                                                        }
                                                    }
                                                  else
                                                    {
                                                      if (((word >> 29) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx0111010xxxx1xx011110xx
                                                             abs.  */
                                                          return 476;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx0111010xxxx1xx011111xx
                                                             neg.  */
                                                          return 504;
                                                        }
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 19) & 0x1) == 0)
                                                    {
                                                      if (((word >> 20) & 0x1) == 0)
                                                        {
                                                          if (((word >> 23) & 0x1) == 0)
                                                            {
                                                              if (((word >> 28) & 0x1) == 0)
                                                                {
                                                                  if (((word >> 29) & 0x1) == 0)
                                                                    {
                                                                      /* 33222222222211111111110000000000
                                                                         10987654321098765432109876543210
                                                                         xxxxxxxxxx0111011xx001x0011100xx
                                                                         fcvtms.  */
                                                                      return 181;
                                                                    }
                                                                  else
                                                                    {
                                                                      /* 33222222222211111111110000000000
                                                                         10987654321098765432109876543210
                                                                         xxxxxxxxxx0111011xx001x0011101xx
                                                                         fcvtmu.  */
                                                                      return 229;
                                                                    }
                                                                }
                                                              else
                                                                {
                                                                  if (((word >> 29) & 0x1) == 0)
                                                                    {
                                                                      /* 33222222222211111111110000000000
                                                                         10987654321098765432109876543210
                                                                         xxxxxxxxxx0111011xx001x0011110xx
                                                                         fcvtms.  */
                                                                      return 480;
                                                                    }
                                                                  else
                                                                    {
                                                                      /* 33222222222211111111110000000000
                                                                         10987654321098765432109876543210
                                                                         xxxxxxxxxx0111011xx001x0011111xx
                                                                         fcvtmu.  */
                                                                      return 510;
                                                                    }
                                                                }
                                                            }
                                                          else
                                                            {
                                                              if (((word >> 28) & 0x1) == 0)
                                                                {
                                                                  if (((word >> 29) & 0x1) == 0)
                                                                    {
                                                                      /* 33222222222211111111110000000000
                                                                         10987654321098765432109876543210
                                                                         xxxxxxxxxx0111011xx001x1011100xx
                                                                         fcvtzs.  */
                                                                      return 201;
                                                                    }
                                                                  else
                                                                    {
                                                                      /* 33222222222211111111110000000000
                                                                         10987654321098765432109876543210
                                                                         xxxxxxxxxx0111011xx001x1011101xx
                                                                         fcvtzu.  */
                                                                      return 248;
                                                                    }
                                                                }
                                                              else
                                                                {
                                                                  if (((word >> 29) & 0x1) == 0)
                                                                    {
                                                                      /* 33222222222211111111110000000000
                                                                         10987654321098765432109876543210
                                                                         xxxxxxxxxx0111011xx001x1011110xx
                                                                         fcvtzs.  */
                                                                      return 494;
                                                                    }
                                                                  else
                                                                    {
                                                                      /* 33222222222211111111110000000000
                                                                         10987654321098765432109876543210
                                                                         xxxxxxxxxx0111011xx001x1011111xx
                                                                         fcvtzu.  */
                                                                      return 522;
                                                                    }
                                                                }
                                                            }
                                                        }
                                                      else
                                                        {
                                                          if (((word >> 28) & 0x1) == 0)
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx0111011xx011xx01110xxx
                                                                 addv.  */
                                                              return 30;
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx0111011xx011xx01111xxx
                                                                 addp.  */
                                                              return 528;
                                                            }
                                                        }
                                                    }
                                                  else
                                                    {
                                                      if (((word >> 23) & 0x1) == 0)
                                                        {
                                                          if (((word >> 28) & 0x1) == 0)
                                                            {
                                                              if (((word >> 29) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     xxxxxxxxxx0111011xx1x1x0011100xx
                                                                     fcvtms.  */
                                                                  return 182;
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     xxxxxxxxxx0111011xx1x1x0011101xx
                                                                     fcvtmu.  */
                                                                  return 230;
                                                                }
                                                            }
                                                          else
                                                            {
                                                              if (((word >> 29) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     xxxxxxxxxx0111011xx1x1x0011110xx
                                                                     fcvtms.  */
                                                                  return 481;
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     xxxxxxxxxx0111011xx1x1x0011111xx
                                                                     fcvtmu.  */
                                                                  return 511;
                                                                }
                                                            }
                                                        }
                                                      else
                                                        {
                                                          if (((word >> 28) & 0x1) == 0)
                                                            {
                                                              if (((word >> 29) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     xxxxxxxxxx0111011xx1x1x1011100xx
                                                                     fcvtzs.  */
                                                                  return 202;
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     xxxxxxxxxx0111011xx1x1x1011101xx
                                                                     fcvtzu.  */
                                                                  return 249;
                                                                }
                                                            }
                                                          else
                                                            {
                                                              if (((word >> 29) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     xxxxxxxxxx0111011xx1x1x1011110xx
                                                                     fcvtzs.  */
                                                                  return 495;
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     xxxxxxxxxx0111011xx1x1x1011111xx
                                                                     fcvtzu.  */
                                                                  return 523;
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                      else
                                        {
                                          if (((word >> 15) & 0x1) == 0)
                                            {
                                              if (((word >> 28) & 0x1) == 0)
                                                {
                                                  if (((word >> 16) & 0x1) == 0)
                                                    {
                                                      if (((word >> 19) & 0x1) == 0)
                                                        {
                                                          if (((word >> 29) & 0x1) == 0)
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx0111100xx0x1xx011100xx
                                                                 sqabs.  */
                                                              return 162;
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx0111100xx0x1xx011101xx
                                                                 sqneg.  */
                                                              return 211;
                                                            }
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx0111100xx1x1xx01110xxx
                                                             aesimc.  */
                                                          return 653;
                                                        }
                                                    }
                                                  else
                                                    {
                                                      if (((word >> 30) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx0111101xxxx1xx01110x0x
                                                             fcvtl.  */
                                                          return 173;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx0111101xxxx1xx01110x1x
                                                             fcvtl2.  */
                                                          return 174;
                                                        }
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 29) & 0x1) == 0)
                                                    {
                                                      if (((word >> 30) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx011110xxxxx1xx0111100x
                                                             fminnm.  */
                                                          return 801;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx011110xxxxx1xx0111101x
                                                             sqabs.  */
                                                          return 472;
                                                        }
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx011110xxxxx1xx011111xx
                                                         sqneg.  */
                                                      return 501;
                                                    }
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 16) & 0x1) == 0)
                                                {
                                                  if (((word >> 19) & 0x1) == 0)
                                                    {
                                                      if (((word >> 20) & 0x1) == 0)
                                                        {
                                                          if (((word >> 29) & 0x1) == 0)
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx0111110xx001xx0111x0xx
                                                                 fabs.  */
                                                              return 193;
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx0111110xx001xx0111x1xx
                                                                 fneg.  */
                                                              return 242;
                                                            }
                                                        }
                                                      else
                                                        {
                                                          if (((word >> 23) & 0x1) == 0)
                                                            {
                                                              if (((word >> 28) & 0x1) == 0)
                                                                {
                                                                  if (((word >> 29) & 0x1) == 0)
                                                                    {
                                                                      /* 33222222222211111111110000000000
                                                                         10987654321098765432109876543210
                                                                         xxxxxxxxxx0111110xx011x0011100xx
                                                                         fmaxv.  */
                                                                      return 37;
                                                                    }
                                                                  else
                                                                    {
                                                                      /* 33222222222211111111110000000000
                                                                         10987654321098765432109876543210
                                                                         xxxxxxxxxx0111110xx011x0011101xx
                                                                         fmaxv.  */
                                                                      return 36;
                                                                    }
                                                                }
                                                              else
                                                                {
                                                                  if (((word >> 29) & 0x1) == 0)
                                                                    {
                                                                      /* 33222222222211111111110000000000
                                                                         10987654321098765432109876543210
                                                                         xxxxxxxxxx0111110xx011x0011110xx
                                                                         fmaxp.  */
                                                                      return 534;
                                                                    }
                                                                  else
                                                                    {
                                                                      /* 33222222222211111111110000000000
                                                                         10987654321098765432109876543210
                                                                         xxxxxxxxxx0111110xx011x0011111xx
                                                                         fmaxp.  */
                                                                      return 533;
                                                                    }
                                                                }
                                                            }
                                                          else
                                                            {
                                                              if (((word >> 28) & 0x1) == 0)
                                                                {
                                                                  if (((word >> 29) & 0x1) == 0)
                                                                    {
                                                                      /* 33222222222211111111110000000000
                                                                         10987654321098765432109876543210
                                                                         xxxxxxxxxx0111110xx011x1011100xx
                                                                         fminv.  */
                                                                      return 41;
                                                                    }
                                                                  else
                                                                    {
                                                                      /* 33222222222211111111110000000000
                                                                         10987654321098765432109876543210
                                                                         xxxxxxxxxx0111110xx011x1011101xx
                                                                         fminv.  */
                                                                      return 40;
                                                                    }
                                                                }
                                                              else
                                                                {
                                                                  if (((word >> 29) & 0x1) == 0)
                                                                    {
                                                                      /* 33222222222211111111110000000000
                                                                         10987654321098765432109876543210
                                                                         xxxxxxxxxx0111110xx011x1011110xx
                                                                         fminp.  */
                                                                      return 538;
                                                                    }
                                                                  else
                                                                    {
                                                                      /* 33222222222211111111110000000000
                                                                         10987654321098765432109876543210
                                                                         xxxxxxxxxx0111110xx011x1011111xx
                                                                         fminp.  */
                                                                      return 537;
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                  else
                                                    {
                                                      if (((word >> 29) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx0111110xx1x1xx0111x0xx
                                                             fabs.  */
                                                          return 194;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx0111110xx1x1xx0111x1xx
                                                             fneg.  */
                                                          return 243;
                                                        }
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 19) & 0x1) == 0)
                                                    {
                                                      if (((word >> 28) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx0111111xx0x1xx01110xxx
                                                             fsqrt.  */
                                                          return 253;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx0111111xx0x1xx01111xxx
                                                             frecpx.  */
                                                          return 498;
                                                        }
                                                    }
                                                  else
                                                    {
                                                      if (((word >> 28) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx0111111xx1x1xx01110xxx
                                                             fsqrt.  */
                                                          return 254;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx0111111xx1x1xx01111xxx
                                                             frecpx.  */
                                                          return 499;
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                      else
                        {
                          if (((word >> 11) & 0x1) == 0)
                            {
                              if (((word >> 28) & 0x1) == 0)
                                {
                                  if (((word >> 12) & 0x1) == 0)
                                    {
                                      if (((word >> 13) & 0x1) == 0)
                                        {
                                          if (((word >> 14) & 0x1) == 0)
                                            {
                                              if (((word >> 15) & 0x1) == 0)
                                                {
                                                  if (((word >> 29) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx100000xxxxx1xx011100xx
                                                         shadd.  */
                                                      return 261;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx100000xxxxx1xx011101xx
                                                         uhadd.  */
                                                      return 313;
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 29) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx100001xxxxx1xx011100xx
                                                         add.  */
                                                      return 276;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx100001xxxxx1xx011101xx
                                                         sub.  */
                                                      return 328;
                                                    }
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 15) & 0x1) == 0)
                                                {
                                                  if (((word >> 29) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx100010xxxxx1xx011100xx
                                                         sshl.  */
                                                      return 268;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx100010xxxxx1xx011101xx
                                                         ushl.  */
                                                      return 320;
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 23) & 0x1) == 0)
                                                    {
                                                      if (((word >> 29) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx100011xxxxx1x0011100xx
                                                             fmaxnm.  */
                                                          return 284;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx100011xxxxx1x0011101xx
                                                             fmaxnmp.  */
                                                          return 335;
                                                        }
                                                    }
                                                  else
                                                    {
                                                      if (((word >> 29) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx100011xxxxx1x1011100xx
                                                             fminnm.  */
                                                          return 300;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx100011xxxxx1x1011101xx
                                                             fminnmp.  */
                                                          return 351;
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                      else
                                        {
                                          if (((word >> 14) & 0x1) == 0)
                                            {
                                              if (((word >> 15) & 0x1) == 0)
                                                {
                                                  if (((word >> 29) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx100100xxxxx1xx011100xx
                                                         shsub.  */
                                                      return 264;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx100100xxxxx1xx011101xx
                                                         uhsub.  */
                                                      return 316;
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 29) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx100101xxxxx1xx011100xx
                                                         smaxp.  */
                                                      return 280;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx100101xxxxx1xx011101xx
                                                         umaxp.  */
                                                      return 332;
                                                    }
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 15) & 0x1) == 0)
                                                {
                                                  if (((word >> 29) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx100110xxxxx1xx011100xx
                                                         smax.  */
                                                      return 272;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx100110xxxxx1xx011101xx
                                                         umax.  */
                                                      return 324;
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 23) & 0x1) == 0)
                                                    {
                                                      if (((word >> 29) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx100111xxxxx1x0011100xx
                                                             fcmeq.  */
                                                          return 292;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx100111xxxxx1x0011101xx
                                                             fcmge.  */
                                                          return 341;
                                                        }
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx100111xxxxx1x101110xxx
                                                         fcmgt.  */
                                                      return 355;
                                                    }
                                                }
                                            }
                                        }
                                    }
                                  else
                                    {
                                      if (((word >> 13) & 0x1) == 0)
                                        {
                                          if (((word >> 14) & 0x1) == 0)
                                            {
                                              if (((word >> 15) & 0x1) == 0)
                                                {
                                                  if (((word >> 29) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx101000xxxxx1xx011100xx
                                                         srhadd.  */
                                                      return 263;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx101000xxxxx1xx011101xx
                                                         urhadd.  */
                                                      return 315;
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 29) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx101001xxxxx1xx011100xx
                                                         mla.  */
                                                      return 278;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx101001xxxxx1xx011101xx
                                                         mls.  */
                                                      return 330;
                                                    }
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 15) & 0x1) == 0)
                                                {
                                                  if (((word >> 29) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx101010xxxxx1xx011100xx
                                                         srshl.  */
                                                      return 270;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx101010xxxxx1xx011101xx
                                                         urshl.  */
                                                      return 322;
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 23) & 0x1) == 0)
                                                    {
                                                      if (((word >> 29) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx101011xxxxx1x0011100xx
                                                             fadd.  */
                                                          return 288;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx101011xxxxx1x0011101xx
                                                             faddp.  */
                                                          return 337;
                                                        }
                                                    }
                                                  else
                                                    {
                                                      if (((word >> 29) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx101011xxxxx1x1011100xx
                                                             fsub.  */
                                                          return 304;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx101011xxxxx1x1011101xx
                                                             fabd.  */
                                                          return 353;
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                      else
                                        {
                                          if (((word >> 14) & 0x1) == 0)
                                            {
                                              if (((word >> 15) & 0x1) == 0)
                                                {
                                                  if (((word >> 29) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx101100xxxxx1xx011100xx
                                                         cmgt.  */
                                                      return 266;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx101100xxxxx1xx011101xx
                                                         cmhi.  */
                                                      return 318;
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 29) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx101101xxxxx1xx011100xx
                                                         sqdmulh.  */
                                                      return 282;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx101101xxxxx1xx011101xx
                                                         sqrdmulh.  */
                                                      return 334;
                                                    }
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 15) & 0x1) == 0)
                                                {
                                                  if (((word >> 29) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx101110xxxxx1xx011100xx
                                                         sabd.  */
                                                      return 274;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx101110xxxxx1xx011101xx
                                                         uabd.  */
                                                      return 326;
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 23) & 0x1) == 0)
                                                    {
                                                      if (((word >> 29) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx101111xxxxx1x0011100xx
                                                             fmax.  */
                                                          return 294;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx101111xxxxx1x0011101xx
                                                             fmaxp.  */
                                                          return 345;
                                                        }
                                                    }
                                                  else
                                                    {
                                                      if (((word >> 29) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx101111xxxxx1x1011100xx
                                                             fmin.  */
                                                          return 306;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx101111xxxxx1x1011101xx
                                                             fminp.  */
                                                          return 359;
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                              else
                                {
                                  if (((word >> 29) & 0x1) == 0)
                                    {
                                      if (((word >> 30) & 0x1) == 0)
                                        {
                                          if (((word >> 4) & 0x1) == 0)
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 xxxx0xxxxx10xxxxxxxxx1xx0111100x
                                                 fccmp.  */
                                              return 752;
                                            }
                                          else
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 xxxx1xxxxx10xxxxxxxxx1xx0111100x
                                                 fccmpe.  */
                                              return 754;
                                            }
                                        }
                                      else
                                        {
                                          if (((word >> 12) & 0x1) == 0)
                                            {
                                              if (((word >> 13) & 0x1) == 0)
                                                {
                                                  if (((word >> 14) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx10000xxxxxx1xx0111101x
                                                         add.  */
                                                      return 556;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx10001xxxxxx1xx0111101x
                                                         sshl.  */
                                                      return 554;
                                                    }
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     xxxxxxxxxx1001xxxxxxx1xx0111101x
                                                     fcmeq.  */
                                                  return 546;
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 13) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     xxxxxxxxxx1010xxxxxxx1xx0111101x
                                                     srshl.  */
                                                  return 555;
                                                }
                                              else
                                                {
                                                  if (((word >> 15) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx1011x0xxxxx1xx0111101x
                                                         cmgt.  */
                                                      return 552;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx1011x1xxxxx1xx0111101x
                                                         sqdmulh.  */
                                                      return 543;
                                                    }
                                                }
                                            }
                                        }
                                    }
                                  else
                                    {
                                      if (((word >> 12) & 0x1) == 0)
                                        {
                                          if (((word >> 13) & 0x1) == 0)
                                            {
                                              if (((word >> 14) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     xxxxxxxxxx10000xxxxxx1xx011111xx
                                                     sub.  */
                                                  return 577;
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     xxxxxxxxxx10001xxxxxx1xx011111xx
                                                     ushl.  */
                                                  return 575;
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 23) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     xxxxxxxxxx1001xxxxxxx1x0011111xx
                                                     fcmge.  */
                                                  return 563;
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     xxxxxxxxxx1001xxxxxxx1x1011111xx
                                                     fcmgt.  */
                                                  return 569;
                                                }
                                            }
                                        }
                                      else
                                        {
                                          if (((word >> 13) & 0x1) == 0)
                                            {
                                              if (((word >> 15) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     xxxxxxxxxx1010x0xxxxx1xx011111xx
                                                     urshl.  */
                                                  return 576;
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     xxxxxxxxxx1010x1xxxxx1xx011111xx
                                                     fabd.  */
                                                  return 567;
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 15) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     xxxxxxxxxx1011x0xxxxx1xx011111xx
                                                     cmhi.  */
                                                  return 573;
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     xxxxxxxxxx1011x1xxxxx1xx011111xx
                                                     sqrdmulh.  */
                                                  return 562;
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                          else
                            {
                              if (((word >> 28) & 0x1) == 0)
                                {
                                  if (((word >> 12) & 0x1) == 0)
                                    {
                                      if (((word >> 13) & 0x1) == 0)
                                        {
                                          if (((word >> 14) & 0x1) == 0)
                                            {
                                              if (((word >> 15) & 0x1) == 0)
                                                {
                                                  if (((word >> 29) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx110000xxxxx1xx011100xx
                                                         sqadd.  */
                                                      return 262;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx110000xxxxx1xx011101xx
                                                         uqadd.  */
                                                      return 314;
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 29) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx110001xxxxx1xx011100xx
                                                         cmtst.  */
                                                      return 277;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx110001xxxxx1xx011101xx
                                                         cmeq.  */
                                                      return 329;
                                                    }
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 15) & 0x1) == 0)
                                                {
                                                  if (((word >> 29) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx110010xxxxx1xx011100xx
                                                         sqshl.  */
                                                      return 269;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx110010xxxxx1xx011101xx
                                                         uqshl.  */
                                                      return 321;
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 23) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx110011xxxxx1x001110xxx
                                                         fmla.  */
                                                      return 286;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx110011xxxxx1x101110xxx
                                                         fmls.  */
                                                      return 302;
                                                    }
                                                }
                                            }
                                        }
                                      else
                                        {
                                          if (((word >> 14) & 0x1) == 0)
                                            {
                                              if (((word >> 15) & 0x1) == 0)
                                                {
                                                  if (((word >> 29) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx110100xxxxx1xx011100xx
                                                         sqsub.  */
                                                      return 265;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx110100xxxxx1xx011101xx
                                                         uqsub.  */
                                                      return 317;
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 29) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx110101xxxxx1xx011100xx
                                                         sminp.  */
                                                      return 281;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx110101xxxxx1xx011101xx
                                                         uminp.  */
                                                      return 333;
                                                    }
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 15) & 0x1) == 0)
                                                {
                                                  if (((word >> 29) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx110110xxxxx1xx011100xx
                                                         smin.  */
                                                      return 273;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx110110xxxxx1xx011101xx
                                                         umin.  */
                                                      return 325;
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 23) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx110111xxxxx1x001110xxx
                                                         facge.  */
                                                      return 343;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx110111xxxxx1x101110xxx
                                                         facgt.  */
                                                      return 357;
                                                    }
                                                }
                                            }
                                        }
                                    }
                                  else
                                    {
                                      if (((word >> 13) & 0x1) == 0)
                                        {
                                          if (((word >> 14) & 0x1) == 0)
                                            {
                                              if (((word >> 15) & 0x1) == 0)
                                                {
                                                  if (((word >> 22) & 0x1) == 0)
                                                    {
                                                      if (((word >> 23) & 0x1) == 0)
                                                        {
                                                          if (((word >> 29) & 0x1) == 0)
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx111000xxxxx100011100xx
                                                                 and.  */
                                                              return 298;
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx111000xxxxx100011101xx
                                                                 eor.  */
                                                              return 349;
                                                            }
                                                        }
                                                      else
                                                        {
                                                          if (((word >> 29) & 0x1) == 0)
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx111000xxxxx101011100xx
                                                                 orr.  */
                                                              return 310;
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx111000xxxxx101011101xx
                                                                 bit.  */
                                                              return 361;
                                                            }
                                                        }
                                                    }
                                                  else
                                                    {
                                                      if (((word >> 23) & 0x1) == 0)
                                                        {
                                                          if (((word >> 29) & 0x1) == 0)
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx111000xxxxx110011100xx
                                                                 bic.  */
                                                              return 299;
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx111000xxxxx110011101xx
                                                                 bsl.  */
                                                              return 350;
                                                            }
                                                        }
                                                      else
                                                        {
                                                          if (((word >> 29) & 0x1) == 0)
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx111000xxxxx111011100xx
                                                                 orn.  */
                                                              return 312;
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx111000xxxxx111011101xx
                                                                 bif.  */
                                                              return 362;
                                                            }
                                                        }
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 29) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx111001xxxxx1xx011100xx
                                                         mul.  */
                                                      return 279;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx111001xxxxx1xx011101xx
                                                         pmul.  */
                                                      return 331;
                                                    }
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 15) & 0x1) == 0)
                                                {
                                                  if (((word >> 29) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx111010xxxxx1xx011100xx
                                                         sqrshl.  */
                                                      return 271;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx111010xxxxx1xx011101xx
                                                         uqrshl.  */
                                                      return 323;
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 29) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx111011xxxxx1xx011100xx
                                                         fmulx.  */
                                                      return 290;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx111011xxxxx1xx011101xx
                                                         fmul.  */
                                                      return 339;
                                                    }
                                                }
                                            }
                                        }
                                      else
                                        {
                                          if (((word >> 14) & 0x1) == 0)
                                            {
                                              if (((word >> 15) & 0x1) == 0)
                                                {
                                                  if (((word >> 29) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx111100xxxxx1xx011100xx
                                                         cmge.  */
                                                      return 267;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx111100xxxxx1xx011101xx
                                                         cmhs.  */
                                                      return 319;
                                                    }
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     xxxxxxxxxx111101xxxxx1xx01110xxx
                                                     addp.  */
                                                  return 283;
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 15) & 0x1) == 0)
                                                {
                                                  if (((word >> 29) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx111110xxxxx1xx011100xx
                                                         saba.  */
                                                      return 275;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx111110xxxxx1xx011101xx
                                                         uaba.  */
                                                      return 327;
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 23) & 0x1) == 0)
                                                    {
                                                      if (((word >> 29) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx111111xxxxx1x0011100xx
                                                             frecps.  */
                                                          return 296;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx111111xxxxx1x0011101xx
                                                             fdiv.  */
                                                          return 347;
                                                        }
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx111111xxxxx1x101110xxx
                                                         frsqrts.  */
                                                      return 308;
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                              else
                                {
                                  if (((word >> 29) & 0x1) == 0)
                                    {
                                      if (((word >> 30) & 0x1) == 0)
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             xxxxxxxxxx11xxxxxxxxx1xx0111100x
                                             fcsel.  */
                                          return 815;
                                        }
                                      else
                                        {
                                          if (((word >> 12) & 0x1) == 0)
                                            {
                                              if (((word >> 13) & 0x1) == 0)
                                                {
                                                  if (((word >> 14) & 0x1) == 0)
                                                    {
                                                      if (((word >> 15) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx110000xxxxx1xx0111101x
                                                             sqadd.  */
                                                          return 539;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx110001xxxxx1xx0111101x
                                                             cmtst.  */
                                                          return 557;
                                                        }
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx11001xxxxxx1xx0111101x
                                                         sqshl.  */
                                                      return 541;
                                                    }
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     xxxxxxxxxx1101xxxxxxx1xx0111101x
                                                     sqsub.  */
                                                  return 540;
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 13) & 0x1) == 0)
                                                {
                                                  if (((word >> 15) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx1110x0xxxxx1xx0111101x
                                                         sqrshl.  */
                                                      return 542;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx1110x1xxxxx1xx0111101x
                                                         fmulx.  */
                                                      return 544;
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 14) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx11110xxxxxx1xx0111101x
                                                         cmge.  */
                                                      return 553;
                                                    }
                                                  else
                                                    {
                                                      if (((word >> 23) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx11111xxxxxx1x00111101x
                                                             frecps.  */
                                                          return 548;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx11111xxxxxx1x10111101x
                                                             frsqrts.  */
                                                          return 550;
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                  else
                                    {
                                      if (((word >> 12) & 0x1) == 0)
                                        {
                                          if (((word >> 13) & 0x1) == 0)
                                            {
                                              if (((word >> 14) & 0x1) == 0)
                                                {
                                                  if (((word >> 15) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx110000xxxxx1xx011111xx
                                                         uqadd.  */
                                                      return 558;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx110001xxxxx1xx011111xx
                                                         cmeq.  */
                                                      return 578;
                                                    }
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     xxxxxxxxxx11001xxxxxx1xx011111xx
                                                     uqshl.  */
                                                  return 560;
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 14) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     xxxxxxxxxx11010xxxxxx1xx011111xx
                                                     uqsub.  */
                                                  return 559;
                                                }
                                              else
                                                {
                                                  if (((word >> 23) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx11011xxxxxx1x0011111xx
                                                         facge.  */
                                                      return 565;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx11011xxxxxx1x1011111xx
                                                         facgt.  */
                                                      return 571;
                                                    }
                                                }
                                            }
                                        }
                                      else
                                        {
                                          if (((word >> 13) & 0x1) == 0)
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 xxxxxxxxxx1110xxxxxxx1xx011111xx
                                                 uqrshl.  */
                                              return 561;
                                            }
                                          else
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 xxxxxxxxxx1111xxxxxxx1xx011111xx
                                                 cmhs.  */
                                              return 574;
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
              else
                {
                  if (((word >> 15) & 0x1) == 0)
                    {
                      if (((word >> 28) & 0x1) == 0)
                        {
                          if (((word >> 10) & 0x1) == 0)
                            {
                              if (((word >> 12) & 0x1) == 0)
                                {
                                  if (((word >> 13) & 0x1) == 0)
                                    {
                                      if (((word >> 14) & 0x1) == 0)
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             xxxxxxxxxx0x0000xxxxxxxx11110xxx
                                             mla.  */
                                          return 117;
                                        }
                                      else
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             xxxxxxxxxx0x0010xxxxxxxx11110xxx
                                             mls.  */
                                          return 120;
                                        }
                                    }
                                  else
                                    {
                                      if (((word >> 14) & 0x1) == 0)
                                        {
                                          if (((word >> 29) & 0x1) == 0)
                                            {
                                              if (((word >> 30) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     xxxxxxxxxx0x0100xxxxxxxx1111000x
                                                     smlal.  */
                                                  return 96;
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     xxxxxxxxxx0x0100xxxxxxxx1111001x
                                                     smlal2.  */
                                                  return 97;
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 30) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     xxxxxxxxxx0x0100xxxxxxxx1111010x
                                                     umlal.  */
                                                  return 118;
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     xxxxxxxxxx0x0100xxxxxxxx1111011x
                                                     umlal2.  */
                                                  return 119;
                                                }
                                            }
                                        }
                                      else
                                        {
                                          if (((word >> 29) & 0x1) == 0)
                                            {
                                              if (((word >> 30) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     xxxxxxxxxx0x0110xxxxxxxx1111000x
                                                     smlsl.  */
                                                  return 100;
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     xxxxxxxxxx0x0110xxxxxxxx1111001x
                                                     smlsl2.  */
                                                  return 101;
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 30) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     xxxxxxxxxx0x0110xxxxxxxx1111010x
                                                     umlsl.  */
                                                  return 121;
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     xxxxxxxxxx0x0110xxxxxxxx1111011x
                                                     umlsl2.  */
                                                  return 122;
                                                }
                                            }
                                        }
                                    }
                                }
                              else
                                {
                                  if (((word >> 13) & 0x1) == 0)
                                    {
                                      if (((word >> 14) & 0x1) == 0)
                                        {
                                          if (((word >> 23) & 0x1) == 0)
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 xxxxxxxxxx0x1000xxxxxxx011110xxx
                                                 fmla.  */
                                              return 112;
                                            }
                                          else
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 xxxxxxxxxx0x1000xxxxxxx111110xxx
                                                 fmla.  */
                                              return 111;
                                            }
                                        }
                                      else
                                        {
                                          if (((word >> 23) & 0x1) == 0)
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 xxxxxxxxxx0x1010xxxxxxx011110xxx
                                                 fmls.  */
                                              return 114;
                                            }
                                          else
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 xxxxxxxxxx0x1010xxxxxxx111110xxx
                                                 fmls.  */
                                              return 113;
                                            }
                                        }
                                    }
                                  else
                                    {
                                      if (((word >> 14) & 0x1) == 0)
                                        {
                                          if (((word >> 30) & 0x1) == 0)
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 xxxxxxxxxx0x1100xxxxxxxx11110x0x
                                                 sqdmlal.  */
                                              return 98;
                                            }
                                          else
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 xxxxxxxxxx0x1100xxxxxxxx11110x1x
                                                 sqdmlal2.  */
                                              return 99;
                                            }
                                        }
                                      else
                                        {
                                          if (((word >> 30) & 0x1) == 0)
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 xxxxxxxxxx0x1110xxxxxxxx11110x0x
                                                 sqdmlsl.  */
                                              return 102;
                                            }
                                          else
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 xxxxxxxxxx0x1110xxxxxxxx11110x1x
                                                 sqdmlsl2.  */
                                              return 103;
                                            }
                                        }
                                    }
                                }
                            }
                          else
                            {
                              if (((word >> 12) & 0x1) == 0)
                                {
                                  if (((word >> 29) & 0x1) == 0)
                                    {
                                      /* 33222222222211111111110000000000
                                         10987654321098765432109876543210
                                         xxxxxxxxxx1x0xx0xxxxxxxx111100xx
                                         movi.  */
                                      return 130;
                                    }
                                  else
                                    {
                                      /* 33222222222211111111110000000000
                                         10987654321098765432109876543210
                                         xxxxxxxxxx1x0xx0xxxxxxxx111101xx
                                         mvni.  */
                                      return 138;
                                    }
                                }
                              else
                                {
                                  if (((word >> 29) & 0x1) == 0)
                                    {
                                      /* 33222222222211111111110000000000
                                         10987654321098765432109876543210
                                         xxxxxxxxxx1x1xx0xxxxxxxx111100xx
                                         orr.  */
                                      return 131;
                                    }
                                  else
                                    {
                                      /* 33222222222211111111110000000000
                                         10987654321098765432109876543210
                                         xxxxxxxxxx1x1xx0xxxxxxxx111101xx
                                         bic.  */
                                      return 139;
                                    }
                                }
                            }
                        }
                      else
                        {
                          if (((word >> 29) & 0x1) == 0)
                            {
                              if (((word >> 30) & 0x1) == 0)
                                {
                                  if (((word >> 21) & 0x1) == 0)
                                    {
                                      /* 33222222222211111111110000000000
                                         10987654321098765432109876543210
                                         xxxxxxxxxxxxxxx0xxxxx0xx1111100x
                                         fmadd.  */
                                      return 805;
                                    }
                                  else
                                    {
                                      /* 33222222222211111111110000000000
                                         10987654321098765432109876543210
                                         xxxxxxxxxxxxxxx0xxxxx1xx1111100x
                                         fnmadd.  */
                                      return 809;
                                    }
                                }
                              else
                                {
                                  if (((word >> 10) & 0x1) == 0)
                                    {
                                      if (((word >> 13) & 0x1) == 0)
                                        {
                                          if (((word >> 14) & 0x1) == 0)
                                            {
                                              if (((word >> 23) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     xxxxxxxxxx0xx000xxxxxxx01111101x
                                                     fmla.  */
                                                  return 422;
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     xxxxxxxxxx0xx000xxxxxxx11111101x
                                                     fmla.  */
                                                  return 421;
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 23) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     xxxxxxxxxx0xx010xxxxxxx01111101x
                                                     fmls.  */
                                                  return 424;
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     xxxxxxxxxx0xx010xxxxxxx11111101x
                                                     fmls.  */
                                                  return 423;
                                                }
                                            }
                                        }
                                      else
                                        {
                                          if (((word >> 14) & 0x1) == 0)
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 xxxxxxxxxx0xx100xxxxxxxx1111101x
                                                 sqdmlal.  */
                                              return 416;
                                            }
                                          else
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 xxxxxxxxxx0xx110xxxxxxxx1111101x
                                                 sqdmlsl.  */
                                              return 417;
                                            }
                                        }
                                    }
                                  else
                                    {
                                      if (((word >> 12) & 0x1) == 0)
                                        {
                                          if (((word >> 13) & 0x1) == 0)
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 xxxxxxxxxx1x00x0xxxxxxxx1111101x
                                                 sshr.  */
                                              return 581;
                                            }
                                          else
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 xxxxxxxxxx1x01x0xxxxxxxx1111101x
                                                 srshr.  */
                                              return 583;
                                            }
                                        }
                                      else
                                        {
                                          if (((word >> 13) & 0x1) == 0)
                                            {
                                              if (((word >> 14) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     xxxxxxxxxx1x1000xxxxxxxx1111101x
                                                     ssra.  */
                                                  return 582;
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     xxxxxxxxxx1x1010xxxxxxxx1111101x
                                                     shl.  */
                                                  return 585;
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 14) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     xxxxxxxxxx1x1100xxxxxxxx1111101x
                                                     srsra.  */
                                                  return 584;
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     xxxxxxxxxx1x1110xxxxxxxx1111101x
                                                     sqshl.  */
                                                  return 586;
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                          else
                            {
                              if (((word >> 12) & 0x1) == 0)
                                {
                                  if (((word >> 13) & 0x1) == 0)
                                    {
                                      if (((word >> 14) & 0x1) == 0)
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             xxxxxxxxxxxx0000xxxxxxxx111111xx
                                             ushr.  */
                                          return 593;
                                        }
                                      else
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             xxxxxxxxxxxx0010xxxxxxxx111111xx
                                             sri.  */
                                          return 597;
                                        }
                                    }
                                  else
                                    {
                                      if (((word >> 14) & 0x1) == 0)
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             xxxxxxxxxxxx0100xxxxxxxx111111xx
                                             urshr.  */
                                          return 595;
                                        }
                                      else
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             xxxxxxxxxxxx0110xxxxxxxx111111xx
                                             sqshlu.  */
                                          return 599;
                                        }
                                    }
                                }
                              else
                                {
                                  if (((word >> 13) & 0x1) == 0)
                                    {
                                      if (((word >> 14) & 0x1) == 0)
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             xxxxxxxxxxxx1000xxxxxxxx111111xx
                                             usra.  */
                                          return 594;
                                        }
                                      else
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             xxxxxxxxxxxx1010xxxxxxxx111111xx
                                             sli.  */
                                          return 598;
                                        }
                                    }
                                  else
                                    {
                                      if (((word >> 14) & 0x1) == 0)
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             xxxxxxxxxxxx1100xxxxxxxx111111xx
                                             ursra.  */
                                          return 596;
                                        }
                                      else
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             xxxxxxxxxxxx1110xxxxxxxx111111xx
                                             uqshl.  */
                                          return 600;
                                        }
                                    }
                                }
                            }
                        }
                    }
                  else
                    {
                      if (((word >> 28) & 0x1) == 0)
                        {
                          if (((word >> 10) & 0x1) == 0)
                            {
                              if (((word >> 12) & 0x1) == 0)
                                {
                                  if (((word >> 13) & 0x1) == 0)
                                    {
                                      if (((word >> 14) & 0x1) == 0)
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             xxxxxxxxxx0x0001xxxxxxxx11110xxx
                                             mul.  */
                                          return 104;
                                        }
                                      else
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             xxxxxxxxxx0x0011xxxxxxxx11110xxx
                                             sqdmulh.  */
                                          return 109;
                                        }
                                    }
                                  else
                                    {
                                      if (((word >> 29) & 0x1) == 0)
                                        {
                                          if (((word >> 30) & 0x1) == 0)
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 xxxxxxxxxx0x01x1xxxxxxxx1111000x
                                                 smull.  */
                                              return 105;
                                            }
                                          else
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 xxxxxxxxxx0x01x1xxxxxxxx1111001x
                                                 smull2.  */
                                              return 106;
                                            }
                                        }
                                      else
                                        {
                                          if (((word >> 30) & 0x1) == 0)
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 xxxxxxxxxx0x01x1xxxxxxxx1111010x
                                                 umull.  */
                                              return 123;
                                            }
                                          else
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 xxxxxxxxxx0x01x1xxxxxxxx1111011x
                                                 umull2.  */
                                              return 124;
                                            }
                                        }
                                    }
                                }
                              else
                                {
                                  if (((word >> 13) & 0x1) == 0)
                                    {
                                      if (((word >> 14) & 0x1) == 0)
                                        {
                                          if (((word >> 23) & 0x1) == 0)
                                            {
                                              if (((word >> 29) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     xxxxxxxxxx0x1001xxxxxxx0111100xx
                                                     fmul.  */
                                                  return 116;
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     xxxxxxxxxx0x1001xxxxxxx0111101xx
                                                     fmulx.  */
                                                  return 126;
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 29) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     xxxxxxxxxx0x1001xxxxxxx1111100xx
                                                     fmul.  */
                                                  return 115;
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     xxxxxxxxxx0x1001xxxxxxx1111101xx
                                                     fmulx.  */
                                                  return 125;
                                                }
                                            }
                                        }
                                      else
                                        {
                                          if (((word >> 29) & 0x1) == 0)
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 xxxxxxxxxx0x1011xxxxxxxx111100xx
                                                 sqrdmulh.  */
                                              return 110;
                                            }
                                          else
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 xxxxxxxxxx0x1011xxxxxxxx111101xx
                                                 sqrdmlah.  */
                                              return 127;
                                            }
                                        }
                                    }
                                  else
                                    {
                                      if (((word >> 14) & 0x1) == 0)
                                        {
                                          if (((word >> 30) & 0x1) == 0)
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 xxxxxxxxxx0x1101xxxxxxxx11110x0x
                                                 sqdmull.  */
                                              return 107;
                                            }
                                          else
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 xxxxxxxxxx0x1101xxxxxxxx11110x1x
                                                 sqdmull2.  */
                                              return 108;
                                            }
                                        }
                                      else
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             xxxxxxxxxx0x1111xxxxxxxx11110xxx
                                             sqrdmlsh.  */
                                          return 128;
                                        }
                                    }
                                }
                            }
                          else
                            {
                              if (((word >> 11) & 0x1) == 0)
                                {
                                  if (((word >> 14) & 0x1) == 0)
                                    {
                                      if (((word >> 12) & 0x1) == 0)
                                        {
                                          if (((word >> 29) & 0x1) == 0)
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 xxxxxxxxxx100x01xxxxxxxx111100xx
                                                 movi.  */
                                              return 132;
                                            }
                                          else
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 xxxxxxxxxx100x01xxxxxxxx111101xx
                                                 mvni.  */
                                              return 140;
                                            }
                                        }
                                      else
                                        {
                                          if (((word >> 29) & 0x1) == 0)
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 xxxxxxxxxx101x01xxxxxxxx111100xx
                                                 orr.  */
                                              return 133;
                                            }
                                          else
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 xxxxxxxxxx101x01xxxxxxxx111101xx
                                                 bic.  */
                                              return 141;
                                            }
                                        }
                                    }
                                  else
                                    {
                                      if (((word >> 13) & 0x1) == 0)
                                        {
                                          if (((word >> 29) & 0x1) == 0)
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 xxxxxxxxxx10x011xxxxxxxx111100xx
                                                 movi.  */
                                              return 134;
                                            }
                                          else
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 xxxxxxxxxx10x011xxxxxxxx111101xx
                                                 mvni.  */
                                              return 142;
                                            }
                                        }
                                      else
                                        {
                                          if (((word >> 12) & 0x1) == 0)
                                            {
                                              if (((word >> 29) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     xxxxxxxxxx100111xxxxxxxx111100xx
                                                     movi.  */
                                                  return 135;
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     xxxxxxxxxx100111xxxxxxxx111101xx
                                                     movi.  */
                                                  return 143;
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 29) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     xxxxxxxxxx101111xxxxxxxx111100xx
                                                     fmov.  */
                                                  return 136;
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     xxxxxxxxxx101111xxxxxxxx111101xx
                                                     fmov.  */
                                                  return 145;
                                                }
                                            }
                                        }
                                    }
                                }
                              else
                                {
                                  if (((word >> 12) & 0x1) == 0)
                                    {
                                      if (((word >> 29) & 0x1) == 0)
                                        {
                                          if (((word >> 30) & 0x1) == 0)
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 xxxxxxxxxx110xx1xxxxxxxx1111000x
                                                 rshrn.  */
                                              return 373;
                                            }
                                          else
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 xxxxxxxxxx110xx1xxxxxxxx1111001x
                                                 rshrn2.  */
                                              return 374;
                                            }
                                        }
                                      else
                                        {
                                          if (((word >> 30) & 0x1) == 0)
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 xxxxxxxxxx110xx1xxxxxxxx1111010x
                                                 sqrshrun.  */
                                              return 397;
                                            }
                                          else
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 xxxxxxxxxx110xx1xxxxxxxx1111011x
                                                 sqrshrun2.  */
                                              return 398;
                                            }
                                        }
                                    }
                                  else
                                    {
                                      if (((word >> 13) & 0x1) == 0)
                                        {
                                          if (((word >> 29) & 0x1) == 0)
                                            {
                                              if (((word >> 30) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     xxxxxxxxxx1110x1xxxxxxxx1111000x
                                                     sqrshrn.  */
                                                  return 377;
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     xxxxxxxxxx1110x1xxxxxxxx1111001x
                                                     sqrshrn2.  */
                                                  return 378;
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 30) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     xxxxxxxxxx1110x1xxxxxxxx1111010x
                                                     uqrshrn.  */
                                                  return 401;
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     xxxxxxxxxx1110x1xxxxxxxx1111011x
                                                     uqrshrn2.  */
                                                  return 402;
                                                }
                                            }
                                        }
                                      else
                                        {
                                          if (((word >> 29) & 0x1) == 0)
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 xxxxxxxxxx1111x1xxxxxxxx111100xx
                                                 fmov.  */
                                              return 137;
                                            }
                                          else
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 xxxxxxxxxx1111x1xxxxxxxx111101xx
                                                 fcvtzu.  */
                                              return 409;
                                            }
                                        }
                                    }
                                }
                            }
                        }
                      else
                        {
                          if (((word >> 29) & 0x1) == 0)
                            {
                              if (((word >> 30) & 0x1) == 0)
                                {
                                  if (((word >> 21) & 0x1) == 0)
                                    {
                                      /* 33222222222211111111110000000000
                                         10987654321098765432109876543210
                                         xxxxxxxxxxxxxxx1xxxxx0xx1111100x
                                         fmsub.  */
                                      return 807;
                                    }
                                  else
                                    {
                                      /* 33222222222211111111110000000000
                                         10987654321098765432109876543210
                                         xxxxxxxxxxxxxxx1xxxxx1xx1111100x
                                         fnmsub.  */
                                      return 811;
                                    }
                                }
                              else
                                {
                                  if (((word >> 10) & 0x1) == 0)
                                    {
                                      if (((word >> 12) & 0x1) == 0)
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             xxxxxxxxxx0x0xx1xxxxxxxx1111101x
                                             sqdmulh.  */
                                          return 419;
                                        }
                                      else
                                        {
                                          if (((word >> 13) & 0x1) == 0)
                                            {
                                              if (((word >> 14) & 0x1) == 0)
                                                {
                                                  if (((word >> 23) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx0x1001xxxxxxx01111101x
                                                         fmul.  */
                                                      return 426;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx0x1001xxxxxxx11111101x
                                                         fmul.  */
                                                      return 425;
                                                    }
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     xxxxxxxxxx0x1011xxxxxxxx1111101x
                                                     sqrdmulh.  */
                                                  return 420;
                                                }
                                            }
                                          else
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 xxxxxxxxxx0x11x1xxxxxxxx1111101x
                                                 sqdmull.  */
                                              return 418;
                                            }
                                        }
                                    }
                                  else
                                    {
                                      if (((word >> 11) & 0x1) == 0)
                                        {
                                          if (((word >> 12) & 0x1) == 0)
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 xxxxxxxxxx100xx1xxxxxxxx1111101x
                                                 scvtf.  */
                                              return 589;
                                            }
                                          else
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 xxxxxxxxxx101xx1xxxxxxxx1111101x
                                                 sqshrn.  */
                                              return 587;
                                            }
                                        }
                                      else
                                        {
                                          if (((word >> 13) & 0x1) == 0)
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 xxxxxxxxxx11x0x1xxxxxxxx1111101x
                                                 sqrshrn.  */
                                              return 588;
                                            }
                                          else
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 xxxxxxxxxx11x1x1xxxxxxxx1111101x
                                                 fcvtzs.  */
                                              return 591;
                                            }
                                        }
                                    }
                                }
                            }
                          else
                            {
                              if (((word >> 10) & 0x1) == 0)
                                {
                                  if (((word >> 13) & 0x1) == 0)
                                    {
                                      if (((word >> 14) & 0x1) == 0)
                                        {
                                          if (((word >> 23) & 0x1) == 0)
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 xxxxxxxxxx0xx001xxxxxxx0111111xx
                                                 fmulx.  */
                                              return 428;
                                            }
                                          else
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 xxxxxxxxxx0xx001xxxxxxx1111111xx
                                                 fmulx.  */
                                              return 427;
                                            }
                                        }
                                      else
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             xxxxxxxxxx0xx011xxxxxxxx111111xx
                                             sqrdmlah.  */
                                          return 429;
                                        }
                                    }
                                  else
                                    {
                                      /* 33222222222211111111110000000000
                                         10987654321098765432109876543210
                                         xxxxxxxxxx0xx1x1xxxxxxxx111111xx
                                         sqrdmlsh.  */
                                      return 430;
                                    }
                                }
                              else
                                {
                                  if (((word >> 11) & 0x1) == 0)
                                    {
                                      if (((word >> 12) & 0x1) == 0)
                                        {
                                          if (((word >> 13) & 0x1) == 0)
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 xxxxxxxxxx1000x1xxxxxxxx111111xx
                                                 sqshrun.  */
                                              return 601;
                                            }
                                          else
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 xxxxxxxxxx1001x1xxxxxxxx111111xx
                                                 ucvtf.  */
                                              return 605;
                                            }
                                        }
                                      else
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             xxxxxxxxxx101xx1xxxxxxxx111111xx
                                             uqshrn.  */
                                          return 603;
                                        }
                                    }
                                  else
                                    {
                                      if (((word >> 12) & 0x1) == 0)
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             xxxxxxxxxx110xx1xxxxxxxx111111xx
                                             sqrshrun.  */
                                          return 602;
                                        }
                                      else
                                        {
                                          if (((word >> 13) & 0x1) == 0)
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 xxxxxxxxxx1110x1xxxxxxxx111111xx
                                                 uqrshrn.  */
                                              return 604;
                                            }
                                          else
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 xxxxxxxxxx1111x1xxxxxxxx111111xx
                                                 fcvtzu.  */
                                              return 607;
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }
}

/* Lookup opcode WORD in the opcode table.  N.B. all alias
   opcodes are ignored here.  */

const aarch64_opcode *
aarch64_opcode_lookup (uint32_t word)
{
  return aarch64_opcode_table + aarch64_opcode_lookup_1 (word);
}

const aarch64_opcode *
aarch64_find_next_opcode (const aarch64_opcode *opcode)
{
  /* Use the index as the key to locate the next opcode.  */
  int key = opcode - aarch64_opcode_table;
  int value;
  switch (key)
    {
    case 901: value = 905; break;	/* stnp --> stp.  */
    case 905: return NULL;		/* stp --> NULL.  */
    case 899: value = 900; break;	/* stllrb --> stllrh.  */
    case 900: return NULL;		/* stllrh --> NULL.  */
    case 902: value = 906; break;	/* ldnp --> ldp.  */
    case 906: return NULL;		/* ldp --> NULL.  */
    case 1117: value = 1118; break;	/* msr --> hint.  */
    case 1118: value = 1127; break;	/* hint --> clrex.  */
    case 1127: value = 1128; break;	/* clrex --> dsb.  */
    case 1128: value = 1129; break;	/* dsb --> dmb.  */
    case 1129: value = 1130; break;	/* dmb --> isb.  */
    case 1130: value = 1131; break;	/* isb --> sys.  */
    case 1131: value = 1136; break;	/* sys --> msr.  */
    case 1136: return NULL;		/* msr --> NULL.  */
    case 1137: value = 1138; break;	/* sysl --> mrs.  */
    case 1138: return NULL;		/* mrs --> NULL.  */
    case 431: value = 432; break;	/* st4 --> st1.  */
    case 432: value = 433; break;	/* st1 --> st2.  */
    case 433: value = 434; break;	/* st2 --> st3.  */
    case 434: return NULL;		/* st3 --> NULL.  */
    case 439: value = 440; break;	/* st4 --> st1.  */
    case 440: value = 441; break;	/* st1 --> st2.  */
    case 441: value = 442; break;	/* st2 --> st3.  */
    case 442: return NULL;		/* st3 --> NULL.  */
    case 435: value = 436; break;	/* ld4 --> ld1.  */
    case 436: value = 437; break;	/* ld1 --> ld2.  */
    case 437: value = 438; break;	/* ld2 --> ld3.  */
    case 438: return NULL;		/* ld3 --> NULL.  */
    case 451: value = 453; break;	/* ld1 --> ld1r.  */
    case 453: return NULL;		/* ld1r --> NULL.  */
    case 455: value = 457; break;	/* ld2 --> ld2r.  */
    case 457: return NULL;		/* ld2r --> NULL.  */
    case 452: value = 454; break;	/* ld3 --> ld3r.  */
    case 454: return NULL;		/* ld3r --> NULL.  */
    case 456: value = 458; break;	/* ld4 --> ld4r.  */
    case 458: return NULL;		/* ld4r --> NULL.  */
    case 443: value = 444; break;	/* ld4 --> ld1.  */
    case 444: value = 445; break;	/* ld1 --> ld2.  */
    case 445: value = 446; break;	/* ld2 --> ld3.  */
    case 446: return NULL;		/* ld3 --> NULL.  */
    case 463: value = 465; break;	/* ld1 --> ld1r.  */
    case 465: return NULL;		/* ld1r --> NULL.  */
    case 464: value = 466; break;	/* ld3 --> ld3r.  */
    case 466: return NULL;		/* ld3r --> NULL.  */
    case 467: value = 469; break;	/* ld2 --> ld2r.  */
    case 469: return NULL;		/* ld2r --> NULL.  */
    case 468: value = 470; break;	/* ld4 --> ld4r.  */
    case 470: return NULL;		/* ld4r --> NULL.  */
    case 718: value = 719; break;	/* fcvtzs --> fcvtzs.  */
    case 719: return NULL;		/* fcvtzs --> NULL.  */
    case 714: value = 715; break;	/* scvtf --> scvtf.  */
    case 715: return NULL;		/* scvtf --> NULL.  */
    case 720: value = 721; break;	/* fcvtzu --> fcvtzu.  */
    case 721: return NULL;		/* fcvtzu --> NULL.  */
    case 716: value = 717; break;	/* ucvtf --> ucvtf.  */
    case 717: return NULL;		/* ucvtf --> NULL.  */
    case 722: value = 723; break;	/* fcvtns --> fcvtns.  */
    case 723: return NULL;		/* fcvtns --> NULL.  */
    case 742: value = 743; break;	/* fcvtms --> fcvtms.  */
    case 743: return NULL;		/* fcvtms --> NULL.  */
    case 738: value = 739; break;	/* fcvtps --> fcvtps.  */
    case 739: return NULL;		/* fcvtps --> NULL.  */
    case 746: value = 747; break;	/* fcvtzs --> fcvtzs.  */
    case 747: return NULL;		/* fcvtzs --> NULL.  */
    case 730: value = 731; break;	/* fcvtas --> fcvtas.  */
    case 731: return NULL;		/* fcvtas --> NULL.  */
    case 726: value = 727; break;	/* scvtf --> scvtf.  */
    case 727: return NULL;		/* scvtf --> NULL.  */
    case 734: value = 735; break;	/* fmov --> fmov.  */
    case 735: return NULL;		/* fmov --> NULL.  */
    case 724: value = 725; break;	/* fcvtnu --> fcvtnu.  */
    case 725: return NULL;		/* fcvtnu --> NULL.  */
    case 744: value = 745; break;	/* fcvtmu --> fcvtmu.  */
    case 745: return NULL;		/* fcvtmu --> NULL.  */
    case 740: value = 741; break;	/* fcvtpu --> fcvtpu.  */
    case 741: return NULL;		/* fcvtpu --> NULL.  */
    case 748: value = 749; break;	/* fcvtzu --> fcvtzu.  */
    case 749: return NULL;		/* fcvtzu --> NULL.  */
    case 732: value = 733; break;	/* fcvtau --> fcvtau.  */
    case 733: return NULL;		/* fcvtau --> NULL.  */
    case 728: value = 729; break;	/* ucvtf --> ucvtf.  */
    case 729: return NULL;		/* ucvtf --> NULL.  */
    case 736: value = 737; break;	/* fmov --> fmov.  */
    case 737: return NULL;		/* fmov --> NULL.  */
    case 764: value = 765; break;	/* fmov --> fmov.  */
    case 765: return NULL;		/* fmov --> NULL.  */
    case 773: value = 774; break;	/* frintn --> frintn.  */
    case 774: return NULL;		/* frintn --> NULL.  */
    case 768: value = 769; break;	/* fneg --> fneg.  */
    case 769: return NULL;		/* fneg --> NULL.  */
    case 777: value = 778; break;	/* frintm --> frintm.  */
    case 778: return NULL;		/* frintm --> NULL.  */
    case 766: value = 767; break;	/* fabs --> fabs.  */
    case 767: return NULL;		/* fabs --> NULL.  */
    case 775: value = 776; break;	/* frintp --> frintp.  */
    case 776: return NULL;		/* frintp --> NULL.  */
    case 770: value = 771; break;	/* fsqrt --> fsqrt.  */
    case 771: return NULL;		/* fsqrt --> NULL.  */
    case 779: value = 780; break;	/* frintz --> frintz.  */
    case 780: return NULL;		/* frintz --> NULL.  */
    case 781: value = 782; break;	/* frinta --> frinta.  */
    case 782: return NULL;		/* frinta --> NULL.  */
    case 783: value = 784; break;	/* frintx --> frintx.  */
    case 784: return NULL;		/* frintx --> NULL.  */
    case 785: value = 786; break;	/* frinti --> frinti.  */
    case 786: return NULL;		/* frinti --> NULL.  */
    case 756: value = 757; break;	/* fcmp --> fcmp.  */
    case 757: return NULL;		/* fcmp --> NULL.  */
    case 758: value = 759; break;	/* fcmpe --> fcmpe.  */
    case 759: return NULL;		/* fcmpe --> NULL.  */
    case 760: value = 761; break;	/* fcmp --> fcmp.  */
    case 761: return NULL;		/* fcmp --> NULL.  */
    case 762: value = 763; break;	/* fcmpe --> fcmpe.  */
    case 763: return NULL;		/* fcmpe --> NULL.  */
    case 813: value = 814; break;	/* fmov --> fmov.  */
    case 814: return NULL;		/* fmov --> NULL.  */
    case 787: value = 788; break;	/* fmul --> fmul.  */
    case 788: return NULL;		/* fmul --> NULL.  */
    case 803: value = 804; break;	/* fnmul --> fnmul.  */
    case 804: return NULL;		/* fnmul --> NULL.  */
    case 795: value = 796; break;	/* fmax --> fmax.  */
    case 796: return NULL;		/* fmax --> NULL.  */
    case 791: value = 792; break;	/* fadd --> fadd.  */
    case 792: return NULL;		/* fadd --> NULL.  */
    case 799: value = 800; break;	/* fmaxnm --> fmaxnm.  */
    case 800: return NULL;		/* fmaxnm --> NULL.  */
    case 789: value = 790; break;	/* fdiv --> fdiv.  */
    case 790: return NULL;		/* fdiv --> NULL.  */
    case 797: value = 798; break;	/* fmin --> fmin.  */
    case 798: return NULL;		/* fmin --> NULL.  */
    case 793: value = 794; break;	/* fsub --> fsub.  */
    case 794: return NULL;		/* fsub --> NULL.  */
    case 801: value = 802; break;	/* fminnm --> fminnm.  */
    case 802: return NULL;		/* fminnm --> NULL.  */
    case 752: value = 753; break;	/* fccmp --> fccmp.  */
    case 753: return NULL;		/* fccmp --> NULL.  */
    case 754: value = 755; break;	/* fccmpe --> fccmpe.  */
    case 755: return NULL;		/* fccmpe --> NULL.  */
    case 815: value = 816; break;	/* fcsel --> fcsel.  */
    case 816: return NULL;		/* fcsel --> NULL.  */
    case 130: value = 365; break;	/* movi --> sshr.  */
    case 365: value = 367; break;	/* sshr --> srshr.  */
    case 367: return NULL;		/* srshr --> NULL.  */
    case 138: value = 387; break;	/* mvni --> ushr.  */
    case 387: value = 389; break;	/* ushr --> urshr.  */
    case 389: value = 391; break;	/* urshr --> sri.  */
    case 391: value = 393; break;	/* sri --> sqshlu.  */
    case 393: return NULL;		/* sqshlu --> NULL.  */
    case 131: value = 366; break;	/* orr --> ssra.  */
    case 366: value = 368; break;	/* ssra --> srsra.  */
    case 368: value = 369; break;	/* srsra --> shl.  */
    case 369: value = 370; break;	/* shl --> sqshl.  */
    case 370: return NULL;		/* sqshl --> NULL.  */
    case 139: value = 388; break;	/* bic --> usra.  */
    case 388: value = 390; break;	/* usra --> ursra.  */
    case 390: value = 392; break;	/* ursra --> sli.  */
    case 392: value = 394; break;	/* sli --> uqshl.  */
    case 394: return NULL;		/* uqshl --> NULL.  */
    case 805: value = 806; break;	/* fmadd --> fmadd.  */
    case 806: return NULL;		/* fmadd --> NULL.  */
    case 809: value = 810; break;	/* fnmadd --> fnmadd.  */
    case 810: return NULL;		/* fnmadd --> NULL.  */
    case 132: value = 371; break;	/* movi --> shrn.  */
    case 371: value = 372; break;	/* shrn --> shrn2.  */
    case 372: value = 379; break;	/* shrn2 --> sshll.  */
    case 379: value = 381; break;	/* sshll --> sshll2.  */
    case 381: return NULL;		/* sshll2 --> NULL.  */
    case 140: value = 395; break;	/* mvni --> sqshrun.  */
    case 395: value = 396; break;	/* sqshrun --> sqshrun2.  */
    case 396: value = 403; break;	/* sqshrun2 --> ushll.  */
    case 403: value = 405; break;	/* ushll --> ushll2.  */
    case 405: return NULL;		/* ushll2 --> NULL.  */
    case 133: value = 375; break;	/* orr --> sqshrn.  */
    case 375: value = 376; break;	/* sqshrn --> sqshrn2.  */
    case 376: return NULL;		/* sqshrn2 --> NULL.  */
    case 141: value = 399; break;	/* bic --> uqshrn.  */
    case 399: value = 400; break;	/* uqshrn --> uqshrn2.  */
    case 400: return NULL;		/* uqshrn2 --> NULL.  */
    case 135: value = 383; break;	/* movi --> scvtf.  */
    case 383: value = 384; break;	/* scvtf --> scvtf.  */
    case 384: return NULL;		/* scvtf --> NULL.  */
    case 143: value = 144; break;	/* movi --> movi.  */
    case 144: value = 407; break;	/* movi --> ucvtf.  */
    case 407: value = 408; break;	/* ucvtf --> ucvtf.  */
    case 408: return NULL;		/* ucvtf --> NULL.  */
    case 137: value = 385; break;	/* fmov --> fcvtzs.  */
    case 385: value = 386; break;	/* fcvtzs --> fcvtzs.  */
    case 386: return NULL;		/* fcvtzs --> NULL.  */
    case 409: value = 410; break;	/* fcvtzu --> fcvtzu.  */
    case 410: return NULL;		/* fcvtzu --> NULL.  */
    case 807: value = 808; break;	/* fmsub --> fmsub.  */
    case 808: return NULL;		/* fmsub --> NULL.  */
    case 811: value = 812; break;	/* fnmsub --> fnmsub.  */
    case 812: return NULL;		/* fnmsub --> NULL.  */
    case 589: value = 590; break;	/* scvtf --> scvtf.  */
    case 590: return NULL;		/* scvtf --> NULL.  */
    case 591: value = 592; break;	/* fcvtzs --> fcvtzs.  */
    case 592: return NULL;		/* fcvtzs --> NULL.  */
    case 605: value = 606; break;	/* ucvtf --> ucvtf.  */
    case 606: return NULL;		/* ucvtf --> NULL.  */
    case 607: value = 608; break;	/* fcvtzu --> fcvtzu.  */
    case 608: return NULL;		/* fcvtzu --> NULL.  */
    default: return NULL;
    }

  return aarch64_opcode_table + value;
}

const aarch64_opcode *
aarch64_find_alias_opcode (const aarch64_opcode *opcode)
{
  /* Use the index as the key to locate the alias opcode.  */
  int key = opcode - aarch64_opcode_table;
  int value;
  switch (key)
    {
    case 2: value = 3; break;	/* sbc --> ngc.  */
    case 4: value = 5; break;	/* sbcs --> ngcs.  */
    case 7: value = 8; break;	/* adds --> cmn.  */
    case 10: value = 11; break;	/* subs --> cmp.  */
    case 12: value = 13; break;	/* add --> mov.  */
    case 14: value = 15; break;	/* adds --> cmn.  */
    case 17: value = 18; break;	/* subs --> cmp.  */
    case 20: value = 21; break;	/* adds --> cmn.  */
    case 22: value = 23; break;	/* sub --> neg.  */
    case 24: value = 26; break;	/* subs --> negs.  */
    case 149: value = 150; break;	/* umov --> mov.  */
    case 151: value = 152; break;	/* ins --> mov.  */
    case 153: value = 154; break;	/* ins --> mov.  */
    case 235: value = 236; break;	/* not --> mvn.  */
    case 310: value = 311; break;	/* orr --> mov.  */
    case 379: value = 380; break;	/* sshll --> sxtl.  */
    case 381: value = 382; break;	/* sshll2 --> sxtl2.  */
    case 403: value = 404; break;	/* ushll --> uxtl.  */
    case 405: value = 406; break;	/* ushll2 --> uxtl2.  */
    case 526: value = 527; break;	/* dup --> mov.  */
    case 609: value = 614; break;	/* sbfm --> sxtw.  */
    case 616: value = 618; break;	/* bfm --> bfc.  */
    case 620: value = 624; break;	/* ubfm --> uxth.  */
    case 642: value = 644; break;	/* csinc --> cset.  */
    case 645: value = 647; break;	/* csinv --> csetm.  */
    case 648: value = 649; break;	/* csneg --> cneg.  */
    case 667: value = 667; break;	/* rev --> rev.  */
    case 674: value = 675; break;	/* lslv --> lsl.  */
    case 676: value = 677; break;	/* lsrv --> lsr.  */
    case 678: value = 679; break;	/* asrv --> asr.  */
    case 680: value = 681; break;	/* rorv --> ror.  */
    case 690: value = 691; break;	/* madd --> mul.  */
    case 692: value = 693; break;	/* msub --> mneg.  */
    case 694: value = 695; break;	/* smaddl --> smull.  */
    case 696: value = 697; break;	/* smsubl --> smnegl.  */
    case 699: value = 700; break;	/* umaddl --> umull.  */
    case 701: value = 702; break;	/* umsubl --> umnegl.  */
    case 712: value = 713; break;	/* extr --> ror.  */
    case 919: value = 920; break;	/* and --> bic.  */
    case 921: value = 922; break;	/* orr --> mov.  */
    case 924: value = 925; break;	/* ands --> tst.  */
    case 928: value = 930; break;	/* orr --> uxtw.  */
    case 931: value = 932; break;	/* orn --> mvn.  */
    case 935: value = 936; break;	/* ands --> tst.  */
    case 966: value = 1062; break;	/* ldaddb --> staddb.  */
    case 967: value = 1063; break;	/* ldaddh --> staddh.  */
    case 968: value = 1064; break;	/* ldadd --> stadd.  */
    case 970: value = 1065; break;	/* ldaddlb --> staddlb.  */
    case 973: value = 1066; break;	/* ldaddlh --> staddlh.  */
    case 976: value = 1067; break;	/* ldaddl --> staddl.  */
    case 978: value = 1068; break;	/* ldclrb --> stclrb.  */
    case 979: value = 1069; break;	/* ldclrh --> stclrh.  */
    case 980: value = 1070; break;	/* ldclr --> stclr.  */
    case 982: value = 1071; break;	/* ldclrlb --> stclrlb.  */
    case 985: value = 1072; break;	/* ldclrlh --> stclrlh.  */
    case 988: value = 1073; break;	/* ldclrl --> stclrl.  */
    case 990: value = 1074; break;	/* ldeorb --> steorb.  */
    case 991: value = 1075; break;	/* ldeorh --> steorh.  */
    case 992: value = 1076; break;	/* ldeor --> steor.  */
    case 994: value = 1077; break;	/* ldeorlb --> steorlb.  */
    case 997: value = 1078; break;	/* ldeorlh --> steorlh.  */
    case 1000: value = 1079; break;	/* ldeorl --> steorl.  */
    case 1002: value = 1080; break;	/* ldsetb --> stsetb.  */
    case 1003: value = 1081; break;	/* ldseth --> stseth.  */
    case 1004: value = 1082; break;	/* ldset --> stset.  */
    case 1006: value = 1083; break;	/* ldsetlb --> stsetlb.  */
    case 1009: value = 1084; break;	/* ldsetlh --> stsetlh.  */
    case 1012: value = 1085; break;	/* ldsetl --> stsetl.  */
    case 1014: value = 1086; break;	/* ldsmaxb --> stsmaxb.  */
    case 1015: value = 1087; break;	/* ldsmaxh --> stsmaxh.  */
    case 1016: value = 1088; break;	/* ldsmax --> stsmax.  */
    case 1018: value = 1089; break;	/* ldsmaxlb --> stsmaxlb.  */
    case 1021: value = 1090; break;	/* ldsmaxlh --> stsmaxlh.  */
    case 1024: value = 1091; break;	/* ldsmaxl --> stsmaxl.  */
    case 1026: value = 1092; break;	/* ldsminb --> stsminb.  */
    case 1027: value = 1093; break;	/* ldsminh --> stsminh.  */
    case 1028: value = 1094; break;	/* ldsmin --> stsmin.  */
    case 1030: value = 1095; break;	/* ldsminlb --> stsminlb.  */
    case 1033: value = 1096; break;	/* ldsminlh --> stsminlh.  */
    case 1036: value = 1097; break;	/* ldsminl --> stsminl.  */
    case 1038: value = 1098; break;	/* ldumaxb --> stumaxb.  */
    case 1039: value = 1099; break;	/* ldumaxh --> stumaxh.  */
    case 1040: value = 1100; break;	/* ldumax --> stumax.  */
    case 1042: value = 1101; break;	/* ldumaxlb --> stumaxlb.  */
    case 1045: value = 1102; break;	/* ldumaxlh --> stumaxlh.  */
    case 1048: value = 1103; break;	/* ldumaxl --> stumaxl.  */
    case 1050: value = 1104; break;	/* lduminb --> stuminb.  */
    case 1051: value = 1105; break;	/* lduminh --> stuminh.  */
    case 1052: value = 1106; break;	/* ldumin --> stumin.  */
    case 1054: value = 1107; break;	/* lduminlb --> stuminlb.  */
    case 1057: value = 1108; break;	/* lduminlh --> stuminlh.  */
    case 1060: value = 1109; break;	/* lduminl --> stuminl.  */
    case 1110: value = 1111; break;	/* movn --> mov.  */
    case 1112: value = 1113; break;	/* movz --> mov.  */
    case 1118: value = 1126; break;	/* hint --> psb.  */
    case 1131: value = 1135; break;	/* sys --> tlbi.  */
    default: return NULL;
    }

  return aarch64_opcode_table + value;
}

const aarch64_opcode *
aarch64_find_next_alias_opcode (const aarch64_opcode *opcode)
{
  /* Use the index as the key to locate the next opcode.  */
  int key = opcode - aarch64_opcode_table;
  int value;
  switch (key)
    {
    case 3: value = 2; break;	/* ngc --> sbc.  */
    case 5: value = 4; break;	/* ngcs --> sbcs.  */
    case 8: value = 7; break;	/* cmn --> adds.  */
    case 11: value = 10; break;	/* cmp --> subs.  */
    case 13: value = 12; break;	/* mov --> add.  */
    case 15: value = 14; break;	/* cmn --> adds.  */
    case 18: value = 17; break;	/* cmp --> subs.  */
    case 21: value = 20; break;	/* cmn --> adds.  */
    case 23: value = 22; break;	/* neg --> sub.  */
    case 26: value = 25; break;	/* negs --> cmp.  */
    case 25: value = 24; break;	/* cmp --> subs.  */
    case 150: value = 149; break;	/* mov --> umov.  */
    case 152: value = 151; break;	/* mov --> ins.  */
    case 154: value = 153; break;	/* mov --> ins.  */
    case 236: value = 235; break;	/* mvn --> not.  */
    case 311: value = 310; break;	/* mov --> orr.  */
    case 380: value = 379; break;	/* sxtl --> sshll.  */
    case 382: value = 381; break;	/* sxtl2 --> sshll2.  */
    case 404: value = 403; break;	/* uxtl --> ushll.  */
    case 406: value = 405; break;	/* uxtl2 --> ushll2.  */
    case 527: value = 526; break;	/* mov --> dup.  */
    case 614: value = 613; break;	/* sxtw --> sxth.  */
    case 613: value = 612; break;	/* sxth --> sxtb.  */
    case 612: value = 615; break;	/* sxtb --> asr.  */
    case 615: value = 611; break;	/* asr --> sbfx.  */
    case 611: value = 610; break;	/* sbfx --> sbfiz.  */
    case 610: value = 609; break;	/* sbfiz --> sbfm.  */
    case 618: value = 619; break;	/* bfc --> bfxil.  */
    case 619: value = 617; break;	/* bfxil --> bfi.  */
    case 617: value = 616; break;	/* bfi --> bfm.  */
    case 624: value = 623; break;	/* uxth --> uxtb.  */
    case 623: value = 626; break;	/* uxtb --> lsr.  */
    case 626: value = 625; break;	/* lsr --> lsl.  */
    case 625: value = 622; break;	/* lsl --> ubfx.  */
    case 622: value = 621; break;	/* ubfx --> ubfiz.  */
    case 621: value = 620; break;	/* ubfiz --> ubfm.  */
    case 644: value = 643; break;	/* cset --> cinc.  */
    case 643: value = 642; break;	/* cinc --> csinc.  */
    case 647: value = 646; break;	/* csetm --> cinv.  */
    case 646: value = 645; break;	/* cinv --> csinv.  */
    case 649: value = 648; break;	/* cneg --> csneg.  */
    case 667: value = 668; break;	/* rev --> rev64.  */
    case 675: value = 674; break;	/* lsl --> lslv.  */
    case 677: value = 676; break;	/* lsr --> lsrv.  */
    case 679: value = 678; break;	/* asr --> asrv.  */
    case 681: value = 680; break;	/* ror --> rorv.  */
    case 691: value = 690; break;	/* mul --> madd.  */
    case 693: value = 692; break;	/* mneg --> msub.  */
    case 695: value = 694; break;	/* smull --> smaddl.  */
    case 697: value = 696; break;	/* smnegl --> smsubl.  */
    case 700: value = 699; break;	/* umull --> umaddl.  */
    case 702: value = 701; break;	/* umnegl --> umsubl.  */
    case 713: value = 712; break;	/* ror --> extr.  */
    case 920: value = 919; break;	/* bic --> and.  */
    case 922: value = 921; break;	/* mov --> orr.  */
    case 925: value = 924; break;	/* tst --> ands.  */
    case 930: value = 929; break;	/* uxtw --> mov.  */
    case 929: value = 928; break;	/* mov --> orr.  */
    case 932: value = 931; break;	/* mvn --> orn.  */
    case 936: value = 935; break;	/* tst --> ands.  */
    case 1062: value = 966; break;	/* staddb --> ldaddb.  */
    case 1063: value = 967; break;	/* staddh --> ldaddh.  */
    case 1064: value = 968; break;	/* stadd --> ldadd.  */
    case 1065: value = 970; break;	/* staddlb --> ldaddlb.  */
    case 1066: value = 973; break;	/* staddlh --> ldaddlh.  */
    case 1067: value = 976; break;	/* staddl --> ldaddl.  */
    case 1068: value = 978; break;	/* stclrb --> ldclrb.  */
    case 1069: value = 979; break;	/* stclrh --> ldclrh.  */
    case 1070: value = 980; break;	/* stclr --> ldclr.  */
    case 1071: value = 982; break;	/* stclrlb --> ldclrlb.  */
    case 1072: value = 985; break;	/* stclrlh --> ldclrlh.  */
    case 1073: value = 988; break;	/* stclrl --> ldclrl.  */
    case 1074: value = 990; break;	/* steorb --> ldeorb.  */
    case 1075: value = 991; break;	/* steorh --> ldeorh.  */
    case 1076: value = 992; break;	/* steor --> ldeor.  */
    case 1077: value = 994; break;	/* steorlb --> ldeorlb.  */
    case 1078: value = 997; break;	/* steorlh --> ldeorlh.  */
    case 1079: value = 1000; break;	/* steorl --> ldeorl.  */
    case 1080: value = 1002; break;	/* stsetb --> ldsetb.  */
    case 1081: value = 1003; break;	/* stseth --> ldseth.  */
    case 1082: value = 1004; break;	/* stset --> ldset.  */
    case 1083: value = 1006; break;	/* stsetlb --> ldsetlb.  */
    case 1084: value = 1009; break;	/* stsetlh --> ldsetlh.  */
    case 1085: value = 1012; break;	/* stsetl --> ldsetl.  */
    case 1086: value = 1014; break;	/* stsmaxb --> ldsmaxb.  */
    case 1087: value = 1015; break;	/* stsmaxh --> ldsmaxh.  */
    case 1088: value = 1016; break;	/* stsmax --> ldsmax.  */
    case 1089: value = 1018; break;	/* stsmaxlb --> ldsmaxlb.  */
    case 1090: value = 1021; break;	/* stsmaxlh --> ldsmaxlh.  */
    case 1091: value = 1024; break;	/* stsmaxl --> ldsmaxl.  */
    case 1092: value = 1026; break;	/* stsminb --> ldsminb.  */
    case 1093: value = 1027; break;	/* stsminh --> ldsminh.  */
    case 1094: value = 1028; break;	/* stsmin --> ldsmin.  */
    case 1095: value = 1030; break;	/* stsminlb --> ldsminlb.  */
    case 1096: value = 1033; break;	/* stsminlh --> ldsminlh.  */
    case 1097: value = 1036; break;	/* stsminl --> ldsminl.  */
    case 1098: value = 1038; break;	/* stumaxb --> ldumaxb.  */
    case 1099: value = 1039; break;	/* stumaxh --> ldumaxh.  */
    case 1100: value = 1040; break;	/* stumax --> ldumax.  */
    case 1101: value = 1042; break;	/* stumaxlb --> ldumaxlb.  */
    case 1102: value = 1045; break;	/* stumaxlh --> ldumaxlh.  */
    case 1103: value = 1048; break;	/* stumaxl --> ldumaxl.  */
    case 1104: value = 1050; break;	/* stuminb --> lduminb.  */
    case 1105: value = 1051; break;	/* stuminh --> lduminh.  */
    case 1106: value = 1052; break;	/* stumin --> ldumin.  */
    case 1107: value = 1054; break;	/* stuminlb --> lduminlb.  */
    case 1108: value = 1057; break;	/* stuminlh --> lduminlh.  */
    case 1109: value = 1060; break;	/* stuminl --> lduminl.  */
    case 1111: value = 1110; break;	/* mov --> movn.  */
    case 1113: value = 1112; break;	/* mov --> movz.  */
    case 1126: value = 1125; break;	/* psb --> esb.  */
    case 1125: value = 1124; break;	/* esb --> sevl.  */
    case 1124: value = 1123; break;	/* sevl --> sev.  */
    case 1123: value = 1122; break;	/* sev --> wfi.  */
    case 1122: value = 1121; break;	/* wfi --> wfe.  */
    case 1121: value = 1120; break;	/* wfe --> yield.  */
    case 1120: value = 1119; break;	/* yield --> nop.  */
    case 1119: value = 1118; break;	/* nop --> hint.  */
    case 1135: value = 1134; break;	/* tlbi --> ic.  */
    case 1134: value = 1133; break;	/* ic --> dc.  */
    case 1133: value = 1132; break;	/* dc --> at.  */
    case 1132: value = 1131; break;	/* at --> sys.  */
    default: return NULL;
    }

  return aarch64_opcode_table + value;
}

int
aarch64_extract_operand (const aarch64_operand *self,
			   aarch64_opnd_info *info,
			   aarch64_insn code, const aarch64_inst *inst)
{
  /* Use the index as the key.  */
  int key = self - aarch64_operands;
  switch (key)
    {
    case 1:
    case 2:
    case 3:
    case 4:
    case 5:
    case 6:
    case 7:
    case 9:
    case 10:
    case 14:
    case 15:
    case 16:
    case 17:
    case 19:
    case 20:
    case 21:
    case 22:
    case 23:
    case 24:
    case 25:
    case 26:
    case 27:
    case 35:
    case 36:
      return aarch64_ext_regno (self, info, code, inst);
    case 8:
      return aarch64_ext_regrt_sysins (self, info, code, inst);
    case 11:
      return aarch64_ext_regno_pair (self, info, code, inst);
    case 12:
      return aarch64_ext_reg_extended (self, info, code, inst);
    case 13:
      return aarch64_ext_reg_shifted (self, info, code, inst);
    case 18:
      return aarch64_ext_ft (self, info, code, inst);
    case 28:
    case 29:
    case 30:
      return aarch64_ext_reglane (self, info, code, inst);
    case 31:
      return aarch64_ext_reglist (self, info, code, inst);
    case 32:
      return aarch64_ext_ldst_reglist (self, info, code, inst);
    case 33:
      return aarch64_ext_ldst_reglist_r (self, info, code, inst);
    case 34:
      return aarch64_ext_ldst_elemlist (self, info, code, inst);
    case 37:
    case 46:
    case 47:
    case 48:
    case 49:
    case 50:
    case 51:
    case 52:
    case 53:
    case 54:
    case 55:
    case 56:
    case 57:
    case 58:
    case 66:
    case 67:
    case 68:
    case 69:
    case 70:
      return aarch64_ext_imm (self, info, code, inst);
    case 38:
    case 39:
      return aarch64_ext_advsimd_imm_shift (self, info, code, inst);
    case 40:
    case 41:
    case 42:
      return aarch64_ext_advsimd_imm_modified (self, info, code, inst);
    case 43:
      return aarch64_ext_shll_imm (self, info, code, inst);
    case 59:
      return aarch64_ext_limm (self, info, code, inst);
    case 60:
      return aarch64_ext_aimm (self, info, code, inst);
    case 61:
      return aarch64_ext_imm_half (self, info, code, inst);
    case 62:
      return aarch64_ext_fbits (self, info, code, inst);
    case 64:
    case 65:
      return aarch64_ext_cond (self, info, code, inst);
    case 71:
    case 77:
      return aarch64_ext_addr_simple (self, info, code, inst);
    case 72:
      return aarch64_ext_addr_regoff (self, info, code, inst);
    case 73:
    case 74:
    case 75:
      return aarch64_ext_addr_simm (self, info, code, inst);
    case 76:
      return aarch64_ext_addr_uimm12 (self, info, code, inst);
    case 78:
      return aarch64_ext_simd_addr_post (self, info, code, inst);
    case 79:
      return aarch64_ext_sysreg (self, info, code, inst);
    case 80:
      return aarch64_ext_pstatefield (self, info, code, inst);
    case 81:
    case 82:
    case 83:
    case 84:
      return aarch64_ext_sysins_op (self, info, code, inst);
    case 85:
    case 86:
      return aarch64_ext_barrier (self, info, code, inst);
    case 87:
      return aarch64_ext_prfop (self, info, code, inst);
    case 88:
      return aarch64_ext_hint (self, info, code, inst);
    default: assert (0); abort ();
    }
}
