/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred.lib.db;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobConfigurable;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.lib.db.DBConfiguration;
import org.apache.hadoop.mapred.lib.db.DBWritable;
import org.apache.hadoop.util.ReflectionUtils;

public class DBInputFormat<T extends DBWritable>
implements InputFormat<LongWritable, T>,
JobConfigurable {
    private String conditions;
    private Connection connection;
    private String tableName;
    private String[] fieldNames;
    private DBConfiguration dbConf;

    @Override
    public void configure(JobConf job) {
        this.dbConf = new DBConfiguration(job);
        try {
            this.connection = this.dbConf.getConnection();
            this.connection.setAutoCommit(false);
            this.connection.setTransactionIsolation(8);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        this.tableName = this.dbConf.getInputTableName();
        this.fieldNames = this.dbConf.getInputFieldNames();
        this.conditions = this.dbConf.getInputConditions();
    }

    @Override
    public RecordReader<LongWritable, T> getRecordReader(InputSplit split, JobConf job, Reporter reporter) throws IOException {
        Class<?> inputClass = this.dbConf.getInputClass();
        try {
            return new DBRecordReader((DBInputSplit)split, inputClass, job);
        }
        catch (SQLException ex) {
            throw new IOException(ex.getMessage());
        }
    }

    @Override
    public InputSplit[] getSplits(JobConf job, int chunks) throws IOException {
        try {
            Statement statement = this.connection.createStatement();
            ResultSet results = statement.executeQuery(this.getCountQuery());
            results.next();
            long count = results.getLong(1);
            long chunkSize = count / (long)chunks;
            results.close();
            statement.close();
            InputSplit[] splits = new InputSplit[chunks];
            for (int i = 0; i < chunks; ++i) {
                DBInputSplit split = i + 1 == chunks ? new DBInputSplit((long)i * chunkSize, count) : new DBInputSplit((long)i * chunkSize, (long)i * chunkSize + chunkSize);
                splits[i] = split;
            }
            return splits;
        }
        catch (SQLException e) {
            throw new IOException(e.getMessage());
        }
    }

    protected String getCountQuery() {
        if (this.dbConf.getInputCountQuery() != null) {
            return this.dbConf.getInputCountQuery();
        }
        StringBuilder query = new StringBuilder();
        query.append("SELECT COUNT(*) FROM " + this.tableName);
        if (this.conditions != null && this.conditions.length() > 0) {
            query.append(" WHERE " + this.conditions);
        }
        return query.toString();
    }

    public static void setInput(JobConf job, Class<? extends DBWritable> inputClass, String tableName, String conditions, String orderBy, String ... fieldNames) {
        job.setInputFormat(DBInputFormat.class);
        DBConfiguration dbConf = new DBConfiguration(job);
        dbConf.setInputClass(inputClass);
        dbConf.setInputTableName(tableName);
        dbConf.setInputFieldNames(fieldNames);
        dbConf.setInputConditions(conditions);
        dbConf.setInputOrderBy(orderBy);
    }

    public static void setInput(JobConf job, Class<? extends DBWritable> inputClass, String inputQuery, String inputCountQuery) {
        job.setInputFormat(DBInputFormat.class);
        DBConfiguration dbConf = new DBConfiguration(job);
        dbConf.setInputClass(inputClass);
        dbConf.setInputQuery(inputQuery);
        dbConf.setInputCountQuery(inputCountQuery);
    }

    protected static class DBInputSplit
    implements InputSplit {
        private long end = 0L;
        private long start = 0L;

        public DBInputSplit() {
        }

        public DBInputSplit(long start, long end) {
            this.start = start;
            this.end = end;
        }

        @Override
        public String[] getLocations() throws IOException {
            return new String[0];
        }

        public long getStart() {
            return this.start;
        }

        public long getEnd() {
            return this.end;
        }

        @Override
        public long getLength() throws IOException {
            return this.end - this.start;
        }

        @Override
        public void readFields(DataInput input) throws IOException {
            this.start = input.readLong();
            this.end = input.readLong();
        }

        @Override
        public void write(DataOutput output) throws IOException {
            output.writeLong(this.start);
            output.writeLong(this.end);
        }
    }

    public static class NullDBWritable
    implements DBWritable,
    Writable {
        @Override
        public void readFields(DataInput in) throws IOException {
        }

        @Override
        public void readFields(ResultSet arg0) throws SQLException {
        }

        @Override
        public void write(DataOutput out) throws IOException {
        }

        @Override
        public void write(PreparedStatement arg0) throws SQLException {
        }
    }

    protected class DBRecordReader
    implements RecordReader<LongWritable, T> {
        private ResultSet results;
        private Statement statement;
        private Class<T> inputClass;
        private JobConf job;
        private DBInputSplit split;
        private long pos = 0L;

        protected DBRecordReader(DBInputSplit split, Class<T> inputClass, JobConf job) throws SQLException {
            this.inputClass = inputClass;
            this.split = split;
            this.job = job;
            this.statement = DBInputFormat.this.connection.createStatement(1003, 1007);
            this.results = this.statement.executeQuery(this.getSelectQuery());
        }

        protected String getSelectQuery() {
            StringBuilder query = new StringBuilder();
            if (DBInputFormat.this.dbConf.getInputQuery() == null) {
                String orderBy;
                query.append("SELECT ");
                for (int i = 0; i < DBInputFormat.this.fieldNames.length; ++i) {
                    query.append(DBInputFormat.this.fieldNames[i]);
                    if (i == DBInputFormat.this.fieldNames.length - 1) continue;
                    query.append(", ");
                }
                query.append(" FROM ").append(DBInputFormat.this.tableName);
                query.append(" AS ").append(DBInputFormat.this.tableName);
                if (DBInputFormat.this.conditions != null && DBInputFormat.this.conditions.length() > 0) {
                    query.append(" WHERE (").append(DBInputFormat.this.conditions).append(")");
                }
                if ((orderBy = DBInputFormat.this.dbConf.getInputOrderBy()) != null && orderBy.length() > 0) {
                    query.append(" ORDER BY ").append(orderBy);
                }
            } else {
                query.append(DBInputFormat.this.dbConf.getInputQuery());
            }
            try {
                query.append(" LIMIT ").append(this.split.getLength());
                query.append(" OFFSET ").append(this.split.getStart());
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return query.toString();
        }

        @Override
        public void close() throws IOException {
            try {
                DBInputFormat.this.connection.commit();
                this.results.close();
                this.statement.close();
            }
            catch (SQLException e) {
                throw new IOException(e.getMessage());
            }
        }

        @Override
        public LongWritable createKey() {
            return new LongWritable();
        }

        @Override
        public T createValue() {
            return (DBWritable)ReflectionUtils.newInstance(this.inputClass, this.job);
        }

        @Override
        public long getPos() throws IOException {
            return this.pos;
        }

        @Override
        public float getProgress() throws IOException {
            return (float)this.pos / (float)this.split.getLength();
        }

        @Override
        public boolean next(LongWritable key, T value) throws IOException {
            try {
                if (!this.results.next()) {
                    return false;
                }
                key.set(this.pos + this.split.getStart());
                value.readFields(this.results);
                ++this.pos;
            }
            catch (SQLException e) {
                throw new IOException(e.getMessage());
            }
            return true;
        }
    }
}

