/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.util.bloom;

import org.apache.hadoop.util.bloom.Key;
import org.apache.hadoop.util.hash.Hash;

public final class HashFunction {
    private int nbHash;
    private int maxValue;
    private Hash hashFunction;

    public HashFunction(int maxValue, int nbHash, int hashType) {
        if (maxValue <= 0) {
            throw new IllegalArgumentException("maxValue must be > 0");
        }
        if (nbHash <= 0) {
            throw new IllegalArgumentException("nbHash must be > 0");
        }
        this.maxValue = maxValue;
        this.nbHash = nbHash;
        this.hashFunction = Hash.getInstance(hashType);
        if (this.hashFunction == null) {
            throw new IllegalArgumentException("hashType must be known");
        }
    }

    public void clear() {
    }

    public int[] hash(Key k) {
        byte[] b = k.getBytes();
        if (b == null) {
            throw new NullPointerException("buffer reference is null");
        }
        if (b.length == 0) {
            throw new IllegalArgumentException("key length must be > 0");
        }
        int[] result = new int[this.nbHash];
        int initval = 0;
        for (int i = 0; i < this.nbHash; ++i) {
            initval = this.hashFunction.hash(b, initval);
            result[i] = Math.abs(initval % this.maxValue);
        }
        return result;
    }
}

