; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --function-signature --check-attributes --check-globals
; RUN: opt -aa-pipeline=basic-aa -passes=attributor -attributor-manifest-internal  -attributor-max-iterations-verify -attributor-annotate-decl-cs -attributor-max-iterations=5 -S < %s | FileCheck %s --check-prefixes=CHECK,TUNIT
; RUN: opt -aa-pipeline=basic-aa -passes=attributor-cgscc -attributor-manifest-internal  -attributor-annotate-decl-cs -S < %s | FileCheck %s --check-prefixes=CHECK,CGSCC

; FIXME: icmp folding is missing

define i1 @invokecaller(i1 %C) personality ptr @__gxx_personality_v0 {
; TUNIT: Function Attrs: nofree norecurse nosync nounwind willreturn memory(none)
; TUNIT-LABEL: define {{[^@]+}}@invokecaller
; TUNIT-SAME: (i1 [[C:%.*]]) #[[ATTR0:[0-9]+]] personality ptr @__gxx_personality_v0 {
; TUNIT-NEXT:    [[X:%.*]] = call i32 @foo(i1 [[C]]) #[[ATTR1:[0-9]+]]
; TUNIT-NEXT:    br label [[OK:%.*]]
; TUNIT:       OK:
; TUNIT-NEXT:    ret i1 true
; TUNIT:       FAIL:
; TUNIT-NEXT:    unreachable
;
; CGSCC: Function Attrs: nofree nosync nounwind willreturn memory(none)
; CGSCC-LABEL: define {{[^@]+}}@invokecaller
; CGSCC-SAME: (i1 noundef [[C:%.*]]) #[[ATTR0:[0-9]+]] personality ptr @__gxx_personality_v0 {
; CGSCC-NEXT:    [[X:%.*]] = call i32 @foo(i1 noundef [[C]]) #[[ATTR2:[0-9]+]]
; CGSCC-NEXT:    br label [[OK:%.*]]
; CGSCC:       OK:
; CGSCC-NEXT:    [[Y:%.*]] = icmp ne i32 [[X]], 0
; CGSCC-NEXT:    ret i1 [[Y]]
; CGSCC:       FAIL:
; CGSCC-NEXT:    unreachable
;
  %X = invoke i32 @foo( i1 %C ) to label %OK unwind label %FAIL             ; <i32> [#uses=1]
OK:
  %Y = icmp ne i32 %X, 0          ; <i1> [#uses=1]
  ret i1 %Y
FAIL:
  %exn = landingpad {ptr, i32}
  cleanup
  ret i1 false
}

define internal i32 @foo(i1 %C) {
; TUNIT: Function Attrs: nofree norecurse nosync nounwind willreturn memory(none)
; TUNIT-LABEL: define {{[^@]+}}@foo
; TUNIT-SAME: (i1 noundef [[C:%.*]]) #[[ATTR0]] {
; TUNIT-NEXT:    br i1 [[C]], label [[T:%.*]], label [[F:%.*]]
; TUNIT:       T:
; TUNIT-NEXT:    ret i32 undef
; TUNIT:       F:
; TUNIT-NEXT:    ret i32 undef
;
; CGSCC: Function Attrs: nofree norecurse nosync nounwind willreturn memory(none)
; CGSCC-LABEL: define {{[^@]+}}@foo
; CGSCC-SAME: (i1 noundef [[C:%.*]]) #[[ATTR1:[0-9]+]] {
; CGSCC-NEXT:    br i1 [[C]], label [[T:%.*]], label [[F:%.*]]
; CGSCC:       T:
; CGSCC-NEXT:    ret i32 52
; CGSCC:       F:
; CGSCC-NEXT:    ret i32 52
;
  br i1 %C, label %T, label %F

T:              ; preds = %0
  ret i32 52

F:              ; preds = %0
  ret i32 52
}

define i1 @caller(i1 %C) {
; TUNIT: Function Attrs: nofree norecurse nosync nounwind willreturn memory(none)
; TUNIT-LABEL: define {{[^@]+}}@caller
; TUNIT-SAME: (i1 [[C:%.*]]) #[[ATTR0]] {
; TUNIT-NEXT:    ret i1 true
;
; CGSCC: Function Attrs: nofree nosync nounwind willreturn memory(none)
; CGSCC-LABEL: define {{[^@]+}}@caller
; CGSCC-SAME: (i1 noundef [[C:%.*]]) #[[ATTR0]] {
; CGSCC-NEXT:    [[X:%.*]] = call i32 @foo(i1 noundef [[C]]) #[[ATTR3:[0-9]+]]
; CGSCC-NEXT:    [[Y:%.*]] = icmp ne i32 [[X]], 0
; CGSCC-NEXT:    ret i1 [[Y]]
;
  %X = call i32 @foo( i1 %C )             ; <i32> [#uses=1]
  %Y = icmp ne i32 %X, 0          ; <i1> [#uses=1]
  ret i1 %Y
}

declare i32 @__gxx_personality_v0(...)
;.
; TUNIT: attributes #[[ATTR0]] = { nofree norecurse nosync nounwind willreturn memory(none) }
; TUNIT: attributes #[[ATTR1]] = { nounwind }
;.
; CGSCC: attributes #[[ATTR0]] = { nofree nosync nounwind willreturn memory(none) }
; CGSCC: attributes #[[ATTR1]] = { nofree norecurse nosync nounwind willreturn memory(none) }
; CGSCC: attributes #[[ATTR2]] = { nounwind willreturn }
; CGSCC: attributes #[[ATTR3]] = { willreturn }
;.
;; NOTE: These prefixes are unused and the list is autogenerated. Do not add tests below this line:
; CHECK: {{.*}}
