; RUN: llc -march=amdgcn -mattr=+vgpr-spilling -verify-machineinstrs < %s | FileCheck %s
; RUN: llc -march=amdgcn -mcpu=tonga -mattr=-flat-for-global -mattr=+vgpr-spilling -verify-machineinstrs < %s | FileCheck %s

; These tests check that the compiler won't crash when it needs to spill
; SGPRs.


@ddxy_lds = external addrspace(3) global [64 x i32]

; CHECK-LABEL: {{^}}main:
; CHECK: s_wqm

; Make sure not emitting unused scratch resource descriptor setup
; CHECK-NOT: s_mov_b32
; CHECK-NOT: s_mov_b32
; CHECK-NOT: s_mov_b32
; CHECK-NOT: s_mov_b32

; CHECK: s_mov_b32 m0


; Writing to M0 from an SMRD instruction will hang the GPU.
; CHECK-NOT: s_buffer_load_dword m0
; CHECK: s_endpgm
define amdgpu_ps void @main([17 x <16 x i8>] addrspace(2)* byval %arg, [32 x <16 x i8>] addrspace(2)* byval %arg1, [16 x <8 x i32>] addrspace(2)* byval %arg2, float inreg %arg3, i32 inreg %arg4, <2 x i32> %arg5, <2 x i32> %arg6, <2 x i32> %arg7, <3 x i32> %arg8, <2 x i32> %arg9, <2 x i32> %arg10, <2 x i32> %arg11, float %arg12, float %arg13, float %arg14, float %arg15, float %arg16, float %arg17, float %arg18, float %arg19, float %arg20) {
main_body:
  %tmp = getelementptr [17 x <16 x i8>], [17 x <16 x i8>] addrspace(2)* %arg, i64 0, i32 0
  %tmp21 = load <16 x i8>, <16 x i8> addrspace(2)* %tmp, !tbaa !0
  %tmp22 = call float @llvm.SI.load.const(<16 x i8> %tmp21, i32 96)
  %tmp23 = call float @llvm.SI.load.const(<16 x i8> %tmp21, i32 100)
  %tmp24 = call float @llvm.SI.load.const(<16 x i8> %tmp21, i32 104)
  %tmp25 = call float @llvm.SI.load.const(<16 x i8> %tmp21, i32 112)
  %tmp26 = call float @llvm.SI.load.const(<16 x i8> %tmp21, i32 116)
  %tmp27 = call float @llvm.SI.load.const(<16 x i8> %tmp21, i32 120)
  %tmp28 = call float @llvm.SI.load.const(<16 x i8> %tmp21, i32 128)
  %tmp29 = call float @llvm.SI.load.const(<16 x i8> %tmp21, i32 132)
  %tmp30 = call float @llvm.SI.load.const(<16 x i8> %tmp21, i32 140)
  %tmp31 = call float @llvm.SI.load.const(<16 x i8> %tmp21, i32 144)
  %tmp32 = call float @llvm.SI.load.const(<16 x i8> %tmp21, i32 160)
  %tmp33 = call float @llvm.SI.load.const(<16 x i8> %tmp21, i32 176)
  %tmp34 = call float @llvm.SI.load.const(<16 x i8> %tmp21, i32 180)
  %tmp35 = call float @llvm.SI.load.const(<16 x i8> %tmp21, i32 184)
  %tmp36 = call float @llvm.SI.load.const(<16 x i8> %tmp21, i32 192)
  %tmp37 = call float @llvm.SI.load.const(<16 x i8> %tmp21, i32 196)
  %tmp38 = call float @llvm.SI.load.const(<16 x i8> %tmp21, i32 200)
  %tmp39 = call float @llvm.SI.load.const(<16 x i8> %tmp21, i32 208)
  %tmp40 = call float @llvm.SI.load.const(<16 x i8> %tmp21, i32 212)
  %tmp41 = call float @llvm.SI.load.const(<16 x i8> %tmp21, i32 216)
  %tmp42 = call float @llvm.SI.load.const(<16 x i8> %tmp21, i32 224)
  %tmp43 = call float @llvm.SI.load.const(<16 x i8> %tmp21, i32 240)
  %tmp44 = call float @llvm.SI.load.const(<16 x i8> %tmp21, i32 244)
  %tmp45 = call float @llvm.SI.load.const(<16 x i8> %tmp21, i32 248)
  %tmp46 = call float @llvm.SI.load.const(<16 x i8> %tmp21, i32 256)
  %tmp47 = call float @llvm.SI.load.const(<16 x i8> %tmp21, i32 272)
  %tmp48 = call float @llvm.SI.load.const(<16 x i8> %tmp21, i32 276)
  %tmp49 = call float @llvm.SI.load.const(<16 x i8> %tmp21, i32 280)
  %tmp50 = call float @llvm.SI.load.const(<16 x i8> %tmp21, i32 288)
  %tmp51 = call float @llvm.SI.load.const(<16 x i8> %tmp21, i32 292)
  %tmp52 = call float @llvm.SI.load.const(<16 x i8> %tmp21, i32 296)
  %tmp53 = call float @llvm.SI.load.const(<16 x i8> %tmp21, i32 304)
  %tmp54 = call float @llvm.SI.load.const(<16 x i8> %tmp21, i32 308)
  %tmp55 = call float @llvm.SI.load.const(<16 x i8> %tmp21, i32 312)
  %tmp56 = call float @llvm.SI.load.const(<16 x i8> %tmp21, i32 368)
  %tmp57 = call float @llvm.SI.load.const(<16 x i8> %tmp21, i32 372)
  %tmp58 = call float @llvm.SI.load.const(<16 x i8> %tmp21, i32 376)
  %tmp59 = call float @llvm.SI.load.const(<16 x i8> %tmp21, i32 384)
  %tmp60 = getelementptr [16 x <8 x i32>], [16 x <8 x i32>] addrspace(2)* %arg2, i64 0, i32 0
  %tmp61 = load <8 x i32>, <8 x i32> addrspace(2)* %tmp60, !tbaa !0
  %tmp62 = getelementptr [32 x <16 x i8>], [32 x <16 x i8>] addrspace(2)* %arg1, i64 0, i32 0
  %tmp63 = load <16 x i8>, <16 x i8> addrspace(2)* %tmp62, !tbaa !0
  %tmp63.bc = bitcast <16 x i8> %tmp63 to <4 x i32>
  %tmp64 = getelementptr [16 x <8 x i32>], [16 x <8 x i32>] addrspace(2)* %arg2, i64 0, i32 1
  %tmp65 = load <8 x i32>, <8 x i32> addrspace(2)* %tmp64, !tbaa !0
  %tmp66 = getelementptr [32 x <16 x i8>], [32 x <16 x i8>] addrspace(2)* %arg1, i64 0, i32 1
  %tmp67 = load <16 x i8>, <16 x i8> addrspace(2)* %tmp66, !tbaa !0
  %tmp68 = getelementptr [16 x <8 x i32>], [16 x <8 x i32>] addrspace(2)* %arg2, i64 0, i32 2
  %tmp69 = load <8 x i32>, <8 x i32> addrspace(2)* %tmp68, !tbaa !0
  %tmp70 = getelementptr [32 x <16 x i8>], [32 x <16 x i8>] addrspace(2)* %arg1, i64 0, i32 2
  %tmp71 = load <16 x i8>, <16 x i8> addrspace(2)* %tmp70, !tbaa !0
  %tmp72 = getelementptr [16 x <8 x i32>], [16 x <8 x i32>] addrspace(2)* %arg2, i64 0, i32 3
  %tmp73 = load <8 x i32>, <8 x i32> addrspace(2)* %tmp72, !tbaa !0
  %tmp74 = getelementptr [32 x <16 x i8>], [32 x <16 x i8>] addrspace(2)* %arg1, i64 0, i32 3
  %tmp75 = load <16 x i8>, <16 x i8> addrspace(2)* %tmp74, !tbaa !0
  %tmp76 = getelementptr [16 x <8 x i32>], [16 x <8 x i32>] addrspace(2)* %arg2, i64 0, i32 4
  %tmp77 = load <8 x i32>, <8 x i32> addrspace(2)* %tmp76, !tbaa !0
  %tmp78 = getelementptr [32 x <16 x i8>], [32 x <16 x i8>] addrspace(2)* %arg1, i64 0, i32 4
  %tmp79 = load <16 x i8>, <16 x i8> addrspace(2)* %tmp78, !tbaa !0
  %tmp80 = getelementptr [16 x <8 x i32>], [16 x <8 x i32>] addrspace(2)* %arg2, i64 0, i32 5
  %tmp81 = load <8 x i32>, <8 x i32> addrspace(2)* %tmp80, !tbaa !0
  %tmp82 = getelementptr [32 x <16 x i8>], [32 x <16 x i8>] addrspace(2)* %arg1, i64 0, i32 5
  %tmp83 = load <16 x i8>, <16 x i8> addrspace(2)* %tmp82, !tbaa !0
  %tmp84 = getelementptr [16 x <8 x i32>], [16 x <8 x i32>] addrspace(2)* %arg2, i64 0, i32 6
  %tmp85 = load <8 x i32>, <8 x i32> addrspace(2)* %tmp84, !tbaa !0
  %tmp86 = getelementptr [32 x <16 x i8>], [32 x <16 x i8>] addrspace(2)* %arg1, i64 0, i32 6
  %tmp87 = load <16 x i8>, <16 x i8> addrspace(2)* %tmp86, !tbaa !0
  %tmp88 = getelementptr [16 x <8 x i32>], [16 x <8 x i32>] addrspace(2)* %arg2, i64 0, i32 7
  %tmp89 = load <8 x i32>, <8 x i32> addrspace(2)* %tmp88, !tbaa !0
  %tmp90 = getelementptr [32 x <16 x i8>], [32 x <16 x i8>] addrspace(2)* %arg1, i64 0, i32 7
  %tmp91 = load <16 x i8>, <16 x i8> addrspace(2)* %tmp90, !tbaa !0
  %tmp92 = call float @llvm.SI.fs.interp(i32 0, i32 0, i32 %arg4, <2 x i32> %arg6)
  %tmp93 = call float @llvm.SI.fs.interp(i32 1, i32 0, i32 %arg4, <2 x i32> %arg6)
  %tmp94 = call float @llvm.SI.fs.interp(i32 0, i32 1, i32 %arg4, <2 x i32> %arg6)
  %tmp95 = call float @llvm.SI.fs.interp(i32 1, i32 1, i32 %arg4, <2 x i32> %arg6)
  %tmp96 = call float @llvm.SI.fs.interp(i32 2, i32 1, i32 %arg4, <2 x i32> %arg6)
  %tmp97 = call float @llvm.SI.fs.interp(i32 0, i32 2, i32 %arg4, <2 x i32> %arg6)
  %tmp98 = call float @llvm.SI.fs.interp(i32 1, i32 2, i32 %arg4, <2 x i32> %arg6)
  %tmp99 = call float @llvm.SI.fs.interp(i32 2, i32 2, i32 %arg4, <2 x i32> %arg6)
  %tmp100 = call float @llvm.SI.fs.interp(i32 0, i32 3, i32 %arg4, <2 x i32> %arg6)
  %tmp101 = call float @llvm.SI.fs.interp(i32 1, i32 3, i32 %arg4, <2 x i32> %arg6)
  %tmp102 = call float @llvm.SI.fs.interp(i32 2, i32 3, i32 %arg4, <2 x i32> %arg6)
  %tmp103 = call float @llvm.SI.fs.interp(i32 0, i32 4, i32 %arg4, <2 x i32> %arg6)
  %tmp104 = call float @llvm.SI.fs.interp(i32 1, i32 4, i32 %arg4, <2 x i32> %arg6)
  %tmp105 = call float @llvm.SI.fs.interp(i32 2, i32 4, i32 %arg4, <2 x i32> %arg6)
  %tmp106 = call float @llvm.SI.fs.interp(i32 0, i32 5, i32 %arg4, <2 x i32> %arg6)
  %tmp107 = call float @llvm.SI.fs.interp(i32 1, i32 5, i32 %arg4, <2 x i32> %arg6)
  %tmp108 = call float @llvm.SI.fs.interp(i32 2, i32 5, i32 %arg4, <2 x i32> %arg6)
  %mbcnt.lo.0 = call i32 @llvm.amdgcn.mbcnt.lo(i32 -1, i32 0)
  %tmp109 = call i32 @llvm.amdgcn.mbcnt.hi(i32 -1, i32 %mbcnt.lo.0)
  %tmp110 = getelementptr [64 x i32], [64 x i32] addrspace(3)* @ddxy_lds, i32 0, i32 %tmp109
  %tmp111 = bitcast float %tmp92 to i32
  store i32 %tmp111, i32 addrspace(3)* %tmp110
  %tmp112 = bitcast float %tmp93 to i32
  store i32 %tmp112, i32 addrspace(3)* %tmp110
  %mbcnt.lo.1 = call i32 @llvm.amdgcn.mbcnt.lo(i32 -1, i32 0)
  %tmp113 = call i32 @llvm.amdgcn.mbcnt.hi(i32 -1, i32 %mbcnt.lo.1)
  %tmp114 = getelementptr [64 x i32], [64 x i32] addrspace(3)* @ddxy_lds, i32 0, i32 %tmp113
  %tmp115 = and i32 %tmp113, -4
  %tmp116 = getelementptr [64 x i32], [64 x i32] addrspace(3)* @ddxy_lds, i32 0, i32 %tmp115
  %tmp117 = add i32 %tmp115, 1
  %tmp118 = getelementptr [64 x i32], [64 x i32] addrspace(3)* @ddxy_lds, i32 0, i32 %tmp117
  %tmp119 = bitcast float %tmp92 to i32
  store i32 %tmp119, i32 addrspace(3)* %tmp114
  %tmp120 = load i32, i32 addrspace(3)* %tmp116
  %tmp121 = bitcast i32 %tmp120 to float
  %tmp122 = load i32, i32 addrspace(3)* %tmp118
  %tmp123 = bitcast i32 %tmp122 to float
  %tmp124 = fsub float %tmp123, %tmp121
  %tmp125 = bitcast float %tmp93 to i32
  store i32 %tmp125, i32 addrspace(3)* %tmp114
  %tmp126 = load i32, i32 addrspace(3)* %tmp116
  %tmp127 = bitcast i32 %tmp126 to float
  %tmp128 = load i32, i32 addrspace(3)* %tmp118
  %tmp129 = bitcast i32 %tmp128 to float
  %tmp130 = fsub float %tmp129, %tmp127
  %tmp131 = insertelement <4 x float> undef, float %tmp124, i32 0
  %tmp132 = insertelement <4 x float> %tmp131, float %tmp130, i32 1
  %tmp133 = insertelement <4 x float> %tmp132, float %tmp130, i32 2
  %tmp134 = insertelement <4 x float> %tmp133, float %tmp130, i32 3
  %tmp135 = extractelement <4 x float> %tmp134, i32 0
  %tmp136 = extractelement <4 x float> %tmp134, i32 1
  %tmp137 = fmul float %tmp59, %tmp92
  %tmp138 = fmul float %tmp59, %tmp93
  %tmp139 = fmul float %tmp59, %tmp93
  %tmp140 = fmul float %tmp59, %tmp93
  %mbcnt.lo.2 = call i32 @llvm.amdgcn.mbcnt.lo(i32 -1, i32 0)
  %tmp141 = call i32 @llvm.amdgcn.mbcnt.hi(i32 -1, i32 %mbcnt.lo.2)
  %tmp142 = getelementptr [64 x i32], [64 x i32] addrspace(3)* @ddxy_lds, i32 0, i32 %tmp141
  %tmp143 = bitcast float %tmp137 to i32
  store i32 %tmp143, i32 addrspace(3)* %tmp142
  %tmp144 = bitcast float %tmp138 to i32
  store i32 %tmp144, i32 addrspace(3)* %tmp142
  %tmp145 = bitcast float %tmp139 to i32
  store i32 %tmp145, i32 addrspace(3)* %tmp142
  %tmp146 = bitcast float %tmp140 to i32
  store i32 %tmp146, i32 addrspace(3)* %tmp142
  %mbcnt.lo.3 = call i32 @llvm.amdgcn.mbcnt.lo(i32 -1, i32 0)
  %tmp147 = call i32 @llvm.amdgcn.mbcnt.hi(i32 -1, i32 %mbcnt.lo.3)
  %tmp148 = getelementptr [64 x i32], [64 x i32] addrspace(3)* @ddxy_lds, i32 0, i32 %tmp147
  %tmp149 = and i32 %tmp147, -4
  %tmp150 = getelementptr [64 x i32], [64 x i32] addrspace(3)* @ddxy_lds, i32 0, i32 %tmp149
  %tmp151 = add i32 %tmp149, 2
  %tmp152 = getelementptr [64 x i32], [64 x i32] addrspace(3)* @ddxy_lds, i32 0, i32 %tmp151
  %tmp153 = bitcast float %tmp137 to i32
  store i32 %tmp153, i32 addrspace(3)* %tmp148
  %tmp154 = load i32, i32 addrspace(3)* %tmp150
  %tmp155 = bitcast i32 %tmp154 to float
  %tmp156 = load i32, i32 addrspace(3)* %tmp152
  %tmp157 = bitcast i32 %tmp156 to float
  %tmp158 = fsub float %tmp157, %tmp155
  %tmp159 = bitcast float %tmp138 to i32
  store i32 %tmp159, i32 addrspace(3)* %tmp148
  %tmp160 = load i32, i32 addrspace(3)* %tmp150
  %tmp161 = bitcast i32 %tmp160 to float
  %tmp162 = load i32, i32 addrspace(3)* %tmp152
  %tmp163 = bitcast i32 %tmp162 to float
  %tmp164 = fsub float %tmp163, %tmp161
  %tmp165 = bitcast float %tmp139 to i32
  store i32 %tmp165, i32 addrspace(3)* %tmp148
  %tmp166 = load i32, i32 addrspace(3)* %tmp150
  %tmp167 = bitcast i32 %tmp166 to float
  %tmp168 = load i32, i32 addrspace(3)* %tmp152
  %tmp169 = bitcast i32 %tmp168 to float
  %tmp170 = fsub float %tmp169, %tmp167
  %tmp171 = bitcast float %tmp140 to i32
  store i32 %tmp171, i32 addrspace(3)* %tmp148
  %tmp172 = load i32, i32 addrspace(3)* %tmp150
  %tmp173 = bitcast i32 %tmp172 to float
  %tmp174 = load i32, i32 addrspace(3)* %tmp152
  %tmp175 = bitcast i32 %tmp174 to float
  %tmp176 = fsub float %tmp175, %tmp173
  %tmp177 = insertelement <4 x float> undef, float %tmp158, i32 0
  %tmp178 = insertelement <4 x float> %tmp177, float %tmp164, i32 1
  %tmp179 = insertelement <4 x float> %tmp178, float %tmp170, i32 2
  %tmp180 = insertelement <4 x float> %tmp179, float %tmp176, i32 3
  %tmp181 = extractelement <4 x float> %tmp180, i32 0
  %tmp182 = extractelement <4 x float> %tmp180, i32 1
  %tmp183 = fdiv float 1.000000e+00, %tmp96
  %tmp184 = fmul float %tmp32, %tmp183
  %tmp185 = fcmp uge float 1.000000e+00, %tmp184
  %tmp186 = select i1 %tmp185, float %tmp184, float 1.000000e+00
  %tmp187 = fmul float %tmp186, %tmp29
  %tmp188 = call float @ceil(float %tmp187)
  %tmp189 = fcmp uge float 3.000000e+00, %tmp188
  %tmp190 = select i1 %tmp189, float 3.000000e+00, float %tmp188
  %tmp191 = fdiv float 1.000000e+00, %tmp190
  %tmp192 = fdiv float 1.000000e+00, %tmp29
  %tmp193 = fmul float %tmp190, %tmp192
  %tmp194 = fmul float %tmp30, %tmp193
  %tmp195 = fmul float %tmp94, %tmp94
  %tmp196 = fmul float %tmp95, %tmp95
  %tmp197 = fadd float %tmp196, %tmp195
  %tmp198 = fmul float %tmp96, %tmp96
  %tmp199 = fadd float %tmp197, %tmp198
  %tmp200 = call float @llvm.amdgcn.rsq.f32(float %tmp199)
  %tmp201 = fmul float %tmp94, %tmp200
  %tmp202 = fmul float %tmp95, %tmp200
  %tmp203 = fmul float %tmp201, %tmp28
  %tmp204 = fmul float %tmp202, %tmp28
  %tmp205 = fmul float %tmp203, -1.000000e+00
  %tmp206 = fmul float %tmp204, 1.000000e+00
  %tmp207 = fmul float %tmp205, %tmp31
  %tmp208 = fmul float %tmp206, %tmp31
  %tmp209 = fsub float -0.000000e+00, %tmp207
  %tmp210 = fadd float %tmp92, %tmp209
  %tmp211 = fsub float -0.000000e+00, %tmp208
  %tmp212 = fadd float %tmp93, %tmp211
  %tmp213 = fmul float %tmp205, %tmp191
  %tmp214 = fmul float %tmp206, %tmp191
  %tmp215 = fmul float -1.000000e+00, %tmp191
  %tmp216 = bitcast float %tmp135 to i32
  %tmp217 = bitcast float %tmp181 to i32
  %tmp218 = bitcast float %tmp136 to i32
  %tmp219 = bitcast float %tmp182 to i32
  %tmp220 = insertelement <8 x i32> undef, i32 %tmp216, i32 0
  %tmp221 = insertelement <8 x i32> %tmp220, i32 %tmp217, i32 1
  %tmp222 = insertelement <8 x i32> %tmp221, i32 %tmp218, i32 2
  %tmp223 = insertelement <8 x i32> %tmp222, i32 %tmp219, i32 3
  br label %LOOP

LOOP:                                             ; preds = %ENDIF, %main_body
  %temp24.0 = phi float [ 1.000000e+00, %main_body ], [ %tmp257, %ENDIF ]
  %temp28.0 = phi float [ %tmp210, %main_body ], [ %tmp252, %ENDIF ]
  %temp29.0 = phi float [ %tmp212, %main_body ], [ %tmp254, %ENDIF ]
  %temp30.0 = phi float [ 1.000000e+00, %main_body ], [ %tmp256, %ENDIF ]
  %tmp224 = fcmp oge float %temp24.0, %tmp190
  %tmp225 = sext i1 %tmp224 to i32
  %tmp226 = bitcast i32 %tmp225 to float
  %tmp227 = bitcast float %tmp226 to i32
  %tmp228 = icmp ne i32 %tmp227, 0
  br i1 %tmp228, label %IF, label %ENDIF

IF:                                               ; preds = %LOOP
  %tmp229 = bitcast float %tmp135 to i32
  %tmp230 = bitcast float %tmp181 to i32
  %tmp231 = bitcast float %tmp136 to i32
  %tmp232 = bitcast float %tmp182 to i32
  %tmp233 = insertelement <8 x i32> undef, i32 %tmp229, i32 0
  %tmp234 = insertelement <8 x i32> %tmp233, i32 %tmp230, i32 1
  %tmp235 = insertelement <8 x i32> %tmp234, i32 %tmp231, i32 2
  %tmp236 = insertelement <8 x i32> %tmp235, i32 %tmp232, i32 3
  br label %LOOP65

ENDIF:                                            ; preds = %LOOP
  %tmp237 = bitcast float %temp28.0 to i32
  %tmp238 = bitcast float %temp29.0 to i32
  %tmp239 = insertelement <8 x i32> %tmp223, i32 %tmp237, i32 4
  %tmp240 = insertelement <8 x i32> %tmp239, i32 %tmp238, i32 5
  %tmp241 = insertelement <8 x i32> %tmp240, i32 undef, i32 6
  %tmp242 = insertelement <8 x i32> %tmp241, i32 undef, i32 7
  %tmp243 = call <4 x float> @llvm.SI.image.sample.d.v8i32(<8 x i32> %tmp242, <8 x i32> %tmp61, <4 x i32> %tmp63.bc, i32 15, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0)
  %tmp244 = extractelement <4 x float> %tmp243, i32 3
  %tmp245 = fcmp oge float %temp30.0, %tmp244
  %tmp246 = sext i1 %tmp245 to i32
  %tmp247 = bitcast i32 %tmp246 to float
  %tmp248 = bitcast float %tmp247 to i32
  %tmp249 = and i32 %tmp248, 1065353216
  %tmp250 = bitcast i32 %tmp249 to float
  %tmp251 = fmul float %tmp213, %tmp250
  %tmp252 = fadd float %tmp251, %temp28.0
  %tmp253 = fmul float %tmp214, %tmp250
  %tmp254 = fadd float %tmp253, %temp29.0
  %tmp255 = fmul float %tmp215, %tmp250
  %tmp256 = fadd float %tmp255, %temp30.0
  %tmp257 = fadd float %temp24.0, 1.000000e+00
  br label %LOOP

LOOP65:                                           ; preds = %ENDIF66, %IF
  %temp24.1 = phi float [ 0.000000e+00, %IF ], [ %tmp609, %ENDIF66 ]
  %temp28.1 = phi float [ %temp28.0, %IF ], [ %tmp604, %ENDIF66 ]
  %temp29.1 = phi float [ %temp29.0, %IF ], [ %tmp606, %ENDIF66 ]
  %temp30.1 = phi float [ %temp30.0, %IF ], [ %tmp608, %ENDIF66 ]
  %temp32.0 = phi float [ 1.000000e+00, %IF ], [ %tmp610, %ENDIF66 ]
  %tmp258 = fcmp oge float %temp24.1, %tmp194
  %tmp259 = sext i1 %tmp258 to i32
  %tmp260 = bitcast i32 %tmp259 to float
  %tmp261 = bitcast float %tmp260 to i32
  %tmp262 = icmp ne i32 %tmp261, 0
  br i1 %tmp262, label %IF67, label %ENDIF66

IF67:                                             ; preds = %LOOP65
  %tmp263 = bitcast float %tmp135 to i32
  %tmp264 = bitcast float %tmp181 to i32
  %tmp265 = bitcast float %tmp136 to i32
  %tmp266 = bitcast float %tmp182 to i32
  %tmp267 = bitcast float %temp28.1 to i32
  %tmp268 = bitcast float %temp29.1 to i32
  %tmp269 = insertelement <8 x i32> undef, i32 %tmp263, i32 0
  %tmp270 = insertelement <8 x i32> %tmp269, i32 %tmp264, i32 1
  %tmp271 = insertelement <8 x i32> %tmp270, i32 %tmp265, i32 2
  %tmp272 = insertelement <8 x i32> %tmp271, i32 %tmp266, i32 3
  %tmp273 = insertelement <8 x i32> %tmp272, i32 %tmp267, i32 4
  %tmp274 = insertelement <8 x i32> %tmp273, i32 %tmp268, i32 5
  %tmp275 = insertelement <8 x i32> %tmp274, i32 undef, i32 6
  %tmp276 = insertelement <8 x i32> %tmp275, i32 undef, i32 7
  %tmp67.bc = bitcast <16 x i8> %tmp67 to <4 x i32>
  %tmp277 = call <4 x float> @llvm.SI.image.sample.d.v8i32(<8 x i32> %tmp276, <8 x i32> %tmp65, <4 x i32> %tmp67.bc, i32 15, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0)
  %tmp278 = extractelement <4 x float> %tmp277, i32 0
  %tmp279 = extractelement <4 x float> %tmp277, i32 1
  %tmp280 = extractelement <4 x float> %tmp277, i32 2
  %tmp281 = extractelement <4 x float> %tmp277, i32 3
  %tmp282 = fmul float %tmp281, %tmp46
  %tmp283 = bitcast float %tmp135 to i32
  %tmp284 = bitcast float %tmp181 to i32
  %tmp285 = bitcast float %tmp136 to i32
  %tmp286 = bitcast float %tmp182 to i32
  %tmp287 = bitcast float %temp28.1 to i32
  %tmp288 = bitcast float %temp29.1 to i32
  %tmp289 = insertelement <8 x i32> undef, i32 %tmp283, i32 0
  %tmp290 = insertelement <8 x i32> %tmp289, i32 %tmp284, i32 1
  %tmp291 = insertelement <8 x i32> %tmp290, i32 %tmp285, i32 2
  %tmp292 = insertelement <8 x i32> %tmp291, i32 %tmp286, i32 3
  %tmp293 = insertelement <8 x i32> %tmp292, i32 %tmp287, i32 4
  %tmp294 = insertelement <8 x i32> %tmp293, i32 %tmp288, i32 5
  %tmp295 = insertelement <8 x i32> %tmp294, i32 undef, i32 6
  %tmp296 = insertelement <8 x i32> %tmp295, i32 undef, i32 7
  %tmp83.bc = bitcast <16 x i8> %tmp83 to <4 x i32>
  %tmp297 = call <4 x float> @llvm.SI.image.sample.d.v8i32(<8 x i32> %tmp296, <8 x i32> %tmp81, <4 x i32> %tmp83.bc, i32 15, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0)
  %tmp298 = extractelement <4 x float> %tmp297, i32 0
  %tmp299 = extractelement <4 x float> %tmp297, i32 1
  %tmp300 = extractelement <4 x float> %tmp297, i32 2
  %tmp301 = bitcast float %tmp135 to i32
  %tmp302 = bitcast float %tmp181 to i32
  %tmp303 = bitcast float %tmp136 to i32
  %tmp304 = bitcast float %tmp182 to i32
  %tmp305 = bitcast float %temp28.1 to i32
  %tmp306 = bitcast float %temp29.1 to i32
  %tmp307 = insertelement <8 x i32> undef, i32 %tmp301, i32 0
  %tmp308 = insertelement <8 x i32> %tmp307, i32 %tmp302, i32 1
  %tmp309 = insertelement <8 x i32> %tmp308, i32 %tmp303, i32 2
  %tmp310 = insertelement <8 x i32> %tmp309, i32 %tmp304, i32 3
  %tmp311 = insertelement <8 x i32> %tmp310, i32 %tmp305, i32 4
  %tmp312 = insertelement <8 x i32> %tmp311, i32 %tmp306, i32 5
  %tmp313 = insertelement <8 x i32> %tmp312, i32 undef, i32 6
  %tmp314 = insertelement <8 x i32> %tmp313, i32 undef, i32 7
  %tmp79.bc = bitcast <16 x i8> %tmp79 to <4 x i32>
  %tmp315 = call <4 x float> @llvm.SI.image.sample.d.v8i32(<8 x i32> %tmp314, <8 x i32> %tmp77, <4 x i32> %tmp79.bc, i32 15, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0)
  %tmp316 = extractelement <4 x float> %tmp315, i32 0
  %tmp317 = extractelement <4 x float> %tmp315, i32 1
  %tmp318 = extractelement <4 x float> %tmp315, i32 2
  %tmp319 = fmul float %tmp316, %tmp22
  %tmp320 = fmul float %tmp317, %tmp23
  %tmp321 = fmul float %tmp318, %tmp24
  %tmp322 = fmul float %tmp298, %tmp25
  %tmp323 = fadd float %tmp322, %tmp319
  %tmp324 = fmul float %tmp299, %tmp26
  %tmp325 = fadd float %tmp324, %tmp320
  %tmp326 = fmul float %tmp300, %tmp27
  %tmp327 = fadd float %tmp326, %tmp321
  %tmp328 = fadd float %tmp278, %tmp323
  %tmp329 = fadd float %tmp279, %tmp325
  %tmp330 = fadd float %tmp280, %tmp327
  %tmp331 = bitcast float %tmp135 to i32
  %tmp332 = bitcast float %tmp181 to i32
  %tmp333 = bitcast float %tmp136 to i32
  %tmp334 = bitcast float %tmp182 to i32
  %tmp335 = bitcast float %temp28.1 to i32
  %tmp336 = bitcast float %temp29.1 to i32
  %tmp337 = insertelement <8 x i32> undef, i32 %tmp331, i32 0
  %tmp338 = insertelement <8 x i32> %tmp337, i32 %tmp332, i32 1
  %tmp339 = insertelement <8 x i32> %tmp338, i32 %tmp333, i32 2
  %tmp340 = insertelement <8 x i32> %tmp339, i32 %tmp334, i32 3
  %tmp341 = insertelement <8 x i32> %tmp340, i32 %tmp335, i32 4
  %tmp342 = insertelement <8 x i32> %tmp341, i32 %tmp336, i32 5
  %tmp343 = insertelement <8 x i32> %tmp342, i32 undef, i32 6
  %tmp344 = insertelement <8 x i32> %tmp343, i32 undef, i32 7
  %tmp345 = call <4 x float> @llvm.SI.image.sample.d.v8i32(<8 x i32> %tmp344, <8 x i32> %tmp61, <4 x i32> %tmp63.bc, i32 15, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0)
  %tmp346 = extractelement <4 x float> %tmp345, i32 0
  %tmp347 = extractelement <4 x float> %tmp345, i32 1
  %tmp348 = extractelement <4 x float> %tmp345, i32 2
  %tmp349 = fadd float %tmp346, -5.000000e-01
  %tmp350 = fadd float %tmp347, -5.000000e-01
  %tmp351 = fadd float %tmp348, -5.000000e-01
  %tmp352 = fmul float %tmp349, %tmp349
  %tmp353 = fmul float %tmp350, %tmp350
  %tmp354 = fadd float %tmp353, %tmp352
  %tmp355 = fmul float %tmp351, %tmp351
  %tmp356 = fadd float %tmp354, %tmp355
  %tmp357 = call float @llvm.amdgcn.rsq.f32(float %tmp356)
  %tmp358 = fmul float %tmp349, %tmp357
  %tmp359 = fmul float %tmp350, %tmp357
  %tmp360 = fmul float %tmp351, %tmp357
  %tmp361 = bitcast float %tmp135 to i32
  %tmp362 = bitcast float %tmp181 to i32
  %tmp363 = bitcast float %tmp136 to i32
  %tmp364 = bitcast float %tmp182 to i32
  %tmp365 = bitcast float %temp28.1 to i32
  %tmp366 = bitcast float %temp29.1 to i32
  %tmp367 = insertelement <8 x i32> undef, i32 %tmp361, i32 0
  %tmp368 = insertelement <8 x i32> %tmp367, i32 %tmp362, i32 1
  %tmp369 = insertelement <8 x i32> %tmp368, i32 %tmp363, i32 2
  %tmp370 = insertelement <8 x i32> %tmp369, i32 %tmp364, i32 3
  %tmp371 = insertelement <8 x i32> %tmp370, i32 %tmp365, i32 4
  %tmp372 = insertelement <8 x i32> %tmp371, i32 %tmp366, i32 5
  %tmp373 = insertelement <8 x i32> %tmp372, i32 undef, i32 6
  %tmp374 = insertelement <8 x i32> %tmp373, i32 undef, i32 7
  %tmp71.bc = bitcast <16 x i8> %tmp71 to <4 x i32>
  %tmp375 = call <4 x float> @llvm.SI.image.sample.d.v8i32(<8 x i32> %tmp374, <8 x i32> %tmp69, <4 x i32> %tmp71.bc, i32 15, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0)
  %tmp376 = extractelement <4 x float> %tmp375, i32 0
  %tmp377 = extractelement <4 x float> %tmp375, i32 1
  %tmp378 = extractelement <4 x float> %tmp375, i32 2
  %tmp379 = extractelement <4 x float> %tmp375, i32 3
  %tmp380 = fsub float -0.000000e+00, %tmp94
  %tmp381 = fsub float -0.000000e+00, %tmp95
  %tmp382 = fsub float -0.000000e+00, %tmp96
  %tmp383 = fmul float %tmp358, %tmp380
  %tmp384 = fmul float %tmp359, %tmp381
  %tmp385 = fadd float %tmp384, %tmp383
  %tmp386 = fmul float %tmp360, %tmp382
  %tmp387 = fadd float %tmp385, %tmp386
  %tmp388 = fmul float %tmp387, %tmp358
  %tmp389 = fmul float %tmp387, %tmp359
  %tmp390 = fmul float %tmp387, %tmp360
  %tmp391 = fmul float 2.000000e+00, %tmp388
  %tmp392 = fmul float 2.000000e+00, %tmp389
  %tmp393 = fmul float 2.000000e+00, %tmp390
  %tmp394 = fsub float -0.000000e+00, %tmp391
  %tmp395 = fadd float %tmp380, %tmp394
  %tmp396 = fsub float -0.000000e+00, %tmp392
  %tmp397 = fadd float %tmp381, %tmp396
  %tmp398 = fsub float -0.000000e+00, %tmp393
  %tmp399 = fadd float %tmp382, %tmp398
  %tmp400 = fmul float %tmp395, %tmp97
  %tmp401 = fmul float %tmp395, %tmp98
  %tmp402 = fmul float %tmp395, %tmp99
  %tmp403 = fmul float %tmp397, %tmp100
  %tmp404 = fadd float %tmp403, %tmp400
  %tmp405 = fmul float %tmp397, %tmp101
  %tmp406 = fadd float %tmp405, %tmp401
  %tmp407 = fmul float %tmp397, %tmp102
  %tmp408 = fadd float %tmp407, %tmp402
  %tmp409 = fmul float %tmp399, %tmp103
  %tmp410 = fadd float %tmp409, %tmp404
  %tmp411 = fmul float %tmp399, %tmp104
  %tmp412 = fadd float %tmp411, %tmp406
  %tmp413 = fmul float %tmp399, %tmp105
  %tmp414 = fadd float %tmp413, %tmp408
  %tmp415 = bitcast float %tmp135 to i32
  %tmp416 = bitcast float %tmp181 to i32
  %tmp417 = bitcast float %tmp136 to i32
  %tmp418 = bitcast float %tmp182 to i32
  %tmp419 = bitcast float %temp28.1 to i32
  %tmp420 = bitcast float %temp29.1 to i32
  %tmp421 = insertelement <8 x i32> undef, i32 %tmp415, i32 0
  %tmp422 = insertelement <8 x i32> %tmp421, i32 %tmp416, i32 1
  %tmp423 = insertelement <8 x i32> %tmp422, i32 %tmp417, i32 2
  %tmp424 = insertelement <8 x i32> %tmp423, i32 %tmp418, i32 3
  %tmp425 = insertelement <8 x i32> %tmp424, i32 %tmp419, i32 4
  %tmp426 = insertelement <8 x i32> %tmp425, i32 %tmp420, i32 5
  %tmp427 = insertelement <8 x i32> %tmp426, i32 undef, i32 6
  %tmp428 = insertelement <8 x i32> %tmp427, i32 undef, i32 7
  %tmp87.bc = bitcast <16 x i8> %tmp87 to <4 x i32>
  %tmp429 = call <4 x float> @llvm.SI.image.sample.d.v8i32(<8 x i32> %tmp428, <8 x i32> %tmp85, <4 x i32> %tmp87.bc, i32 15, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0)
  %tmp430 = extractelement <4 x float> %tmp429, i32 0
  %tmp431 = extractelement <4 x float> %tmp429, i32 1
  %tmp432 = extractelement <4 x float> %tmp429, i32 2
  %tmp433 = fmul float %tmp47, %tmp410
  %tmp434 = fmul float %tmp48, %tmp410
  %tmp435 = fmul float %tmp49, %tmp410
  %tmp436 = fmul float %tmp50, %tmp412
  %tmp437 = fadd float %tmp436, %tmp433
  %tmp438 = fmul float %tmp51, %tmp412
  %tmp439 = fadd float %tmp438, %tmp434
  %tmp440 = fmul float %tmp52, %tmp412
  %tmp441 = fadd float %tmp440, %tmp435
  %tmp442 = fmul float %tmp53, %tmp414
  %tmp443 = fadd float %tmp442, %tmp437
  %tmp444 = fmul float %tmp54, %tmp414
  %tmp445 = fadd float %tmp444, %tmp439
  %tmp446 = fmul float %tmp55, %tmp414
  %tmp447 = fadd float %tmp446, %tmp441
  %tmp448 = insertelement <4 x float> undef, float %tmp443, i32 0
  %tmp449 = insertelement <4 x float> %tmp448, float %tmp445, i32 1
  %tmp450 = insertelement <4 x float> %tmp449, float %tmp447, i32 2
  %tmp451 = insertelement <4 x float> %tmp450, float %tmp194, i32 3
  %tmp452 = call <4 x float> @llvm.AMDGPU.cube(<4 x float> %tmp451)
  %tmp453 = extractelement <4 x float> %tmp452, i32 0
  %tmp454 = extractelement <4 x float> %tmp452, i32 1
  %tmp455 = extractelement <4 x float> %tmp452, i32 2
  %tmp456 = extractelement <4 x float> %tmp452, i32 3
  %tmp457 = call float @fabs(float %tmp455)
  %tmp458 = fdiv float 1.000000e+00, %tmp457
  %tmp459 = fmul float %tmp453, %tmp458
  %tmp460 = fadd float %tmp459, 1.500000e+00
  %tmp461 = fmul float %tmp454, %tmp458
  %tmp462 = fadd float %tmp461, 1.500000e+00
  %tmp463 = bitcast float %tmp462 to i32
  %tmp464 = bitcast float %tmp460 to i32
  %tmp465 = bitcast float %tmp456 to i32
  %tmp466 = insertelement <4 x i32> undef, i32 %tmp463, i32 0
  %tmp467 = insertelement <4 x i32> %tmp466, i32 %tmp464, i32 1
  %tmp468 = insertelement <4 x i32> %tmp467, i32 %tmp465, i32 2
  %tmp469 = insertelement <4 x i32> %tmp468, i32 undef, i32 3
  %tmp91.bc = bitcast <16 x i8> %tmp91 to <4 x i32>
  %tmp470 = call <4 x float> @llvm.SI.image.sample.v4i32(<4 x i32> %tmp469, <8 x i32> %tmp89, <4 x i32> %tmp91.bc, i32 15, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0)
  %tmp471 = extractelement <4 x float> %tmp470, i32 0
  %tmp472 = extractelement <4 x float> %tmp470, i32 1
  %tmp473 = extractelement <4 x float> %tmp470, i32 2
  %tmp474 = fmul float %tmp430, %tmp471
  %tmp475 = fadd float %tmp474, %tmp328
  %tmp476 = fmul float %tmp431, %tmp472
  %tmp477 = fadd float %tmp476, %tmp329
  %tmp478 = fmul float %tmp432, %tmp473
  %tmp479 = fadd float %tmp478, %tmp330
  %tmp480 = fmul float %tmp106, %tmp106
  %tmp481 = fmul float %tmp107, %tmp107
  %tmp482 = fadd float %tmp481, %tmp480
  %tmp483 = fmul float %tmp108, %tmp108
  %tmp484 = fadd float %tmp482, %tmp483
  %tmp485 = call float @llvm.amdgcn.rsq.f32(float %tmp484)
  %tmp486 = fmul float %tmp106, %tmp485
  %tmp487 = fmul float %tmp107, %tmp485
  %tmp488 = fmul float %tmp108, %tmp485
  %tmp489 = fmul float %tmp376, %tmp39
  %tmp490 = fmul float %tmp377, %tmp40
  %tmp491 = fmul float %tmp378, %tmp41
  %tmp492 = fmul float %tmp358, %tmp486
  %tmp493 = fmul float %tmp359, %tmp487
  %tmp494 = fadd float %tmp493, %tmp492
  %tmp495 = fmul float %tmp360, %tmp488
  %tmp496 = fadd float %tmp494, %tmp495
  %tmp497 = fmul float %tmp496, %tmp358
  %tmp498 = fmul float %tmp496, %tmp359
  %tmp499 = fmul float %tmp496, %tmp360
  %tmp500 = fmul float 2.000000e+00, %tmp497
  %tmp501 = fmul float 2.000000e+00, %tmp498
  %tmp502 = fmul float 2.000000e+00, %tmp499
  %tmp503 = fsub float -0.000000e+00, %tmp500
  %tmp504 = fadd float %tmp486, %tmp503
  %tmp505 = fsub float -0.000000e+00, %tmp501
  %tmp506 = fadd float %tmp487, %tmp505
  %tmp507 = fsub float -0.000000e+00, %tmp502
  %tmp508 = fadd float %tmp488, %tmp507
  %tmp509 = fmul float %tmp94, %tmp94
  %tmp510 = fmul float %tmp95, %tmp95
  %tmp511 = fadd float %tmp510, %tmp509
  %tmp512 = fmul float %tmp96, %tmp96
  %tmp513 = fadd float %tmp511, %tmp512
  %tmp514 = call float @llvm.amdgcn.rsq.f32(float %tmp513)
  %tmp515 = fmul float %tmp94, %tmp514
  %tmp516 = fmul float %tmp95, %tmp514
  %tmp517 = fmul float %tmp96, %tmp514
  %tmp518 = fmul float %tmp504, %tmp515
  %tmp519 = fmul float %tmp506, %tmp516
  %tmp520 = fadd float %tmp519, %tmp518
  %tmp521 = fmul float %tmp508, %tmp517
  %tmp522 = fadd float %tmp520, %tmp521
  %tmp523 = fsub float -0.000000e+00, %tmp522
  %tmp524 = fcmp uge float %tmp523, 0.000000e+00
  %tmp525 = select i1 %tmp524, float %tmp523, float 0.000000e+00
  %tmp526 = fmul float %tmp42, %tmp379
  %tmp527 = fadd float %tmp526, 1.000000e+00
  %tmp528 = call float @llvm.pow.f32(float %tmp525, float %tmp527)
  %tmp529 = fmul float %tmp475, %tmp36
  %tmp530 = fmul float %tmp477, %tmp37
  %tmp531 = fmul float %tmp479, %tmp38
  %tmp532 = fmul float %tmp358, %tmp486
  %tmp533 = fmul float %tmp359, %tmp487
  %tmp534 = fadd float %tmp533, %tmp532
  %tmp535 = fmul float %tmp360, %tmp488
  %tmp536 = fadd float %tmp534, %tmp535
  %tmp537 = fcmp uge float %tmp536, 0.000000e+00
  %tmp538 = select i1 %tmp537, float %tmp536, float 0.000000e+00
  %tmp539 = fmul float %tmp529, %tmp538
  %tmp540 = fmul float %tmp530, %tmp538
  %tmp541 = fmul float %tmp531, %tmp538
  %tmp542 = fmul float %tmp489, %tmp528
  %tmp543 = fadd float %tmp542, %tmp539
  %tmp544 = fmul float %tmp490, %tmp528
  %tmp545 = fadd float %tmp544, %tmp540
  %tmp546 = fmul float %tmp491, %tmp528
  %tmp547 = fadd float %tmp546, %tmp541
  %tmp548 = fmul float %tmp475, %tmp33
  %tmp549 = fmul float %tmp477, %tmp34
  %tmp550 = fmul float %tmp479, %tmp35
  %tmp551 = fmul float %tmp543, %tmp56
  %tmp552 = fadd float %tmp551, %tmp548
  %tmp553 = fmul float %tmp545, %tmp57
  %tmp554 = fadd float %tmp553, %tmp549
  %tmp555 = fmul float %tmp547, %tmp58
  %tmp556 = fadd float %tmp555, %tmp550
  %tmp557 = bitcast float %tmp135 to i32
  %tmp558 = bitcast float %tmp181 to i32
  %tmp559 = bitcast float %tmp136 to i32
  %tmp560 = bitcast float %tmp182 to i32
  %tmp561 = bitcast float %temp28.1 to i32
  %tmp562 = bitcast float %temp29.1 to i32
  %tmp563 = insertelement <8 x i32> undef, i32 %tmp557, i32 0
  %tmp564 = insertelement <8 x i32> %tmp563, i32 %tmp558, i32 1
  %tmp565 = insertelement <8 x i32> %tmp564, i32 %tmp559, i32 2
  %tmp566 = insertelement <8 x i32> %tmp565, i32 %tmp560, i32 3
  %tmp567 = insertelement <8 x i32> %tmp566, i32 %tmp561, i32 4
  %tmp568 = insertelement <8 x i32> %tmp567, i32 %tmp562, i32 5
  %tmp569 = insertelement <8 x i32> %tmp568, i32 undef, i32 6
  %tmp570 = insertelement <8 x i32> %tmp569, i32 undef, i32 7
  %tmp75.bc = bitcast <16 x i8> %tmp75 to <4 x i32>
  %tmp571 = call <4 x float> @llvm.SI.image.sample.d.v8i32(<8 x i32> %tmp570, <8 x i32> %tmp73, <4 x i32> %tmp75.bc, i32 15, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0)
  %tmp572 = extractelement <4 x float> %tmp571, i32 0
  %tmp573 = extractelement <4 x float> %tmp571, i32 1
  %tmp574 = extractelement <4 x float> %tmp571, i32 2
  %tmp575 = fmul float %tmp572, %tmp43
  %tmp576 = fadd float %tmp575, %tmp552
  %tmp577 = fmul float %tmp573, %tmp44
  %tmp578 = fadd float %tmp577, %tmp554
  %tmp579 = fmul float %tmp574, %tmp45
  %tmp580 = fadd float %tmp579, %tmp556
  %tmp581 = call i32 @llvm.SI.packf16(float %tmp576, float %tmp578)
  %tmp582 = bitcast i32 %tmp581 to float
  %tmp583 = call i32 @llvm.SI.packf16(float %tmp580, float %tmp282)
  %tmp584 = bitcast i32 %tmp583 to float
  call void @llvm.SI.export(i32 15, i32 1, i32 1, i32 0, i32 1, float %tmp582, float %tmp584, float %tmp582, float %tmp584)
  ret void

ENDIF66:                                          ; preds = %LOOP65
  %tmp585 = bitcast float %temp28.1 to i32
  %tmp586 = bitcast float %temp29.1 to i32
  %tmp587 = insertelement <8 x i32> %tmp236, i32 %tmp585, i32 4
  %tmp588 = insertelement <8 x i32> %tmp587, i32 %tmp586, i32 5
  %tmp589 = insertelement <8 x i32> %tmp588, i32 undef, i32 6
  %tmp590 = insertelement <8 x i32> %tmp589, i32 undef, i32 7
  %tmp591 = call <4 x float> @llvm.SI.image.sample.d.v8i32(<8 x i32> %tmp590, <8 x i32> %tmp61, <4 x i32> %tmp63.bc, i32 15, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0)
  %tmp592 = extractelement <4 x float> %tmp591, i32 3
  %tmp593 = fcmp oge float %temp30.1, %tmp592
  %tmp594 = sext i1 %tmp593 to i32
  %tmp595 = bitcast i32 %tmp594 to float
  %tmp596 = bitcast float %tmp595 to i32
  %tmp597 = and i32 %tmp596, 1065353216
  %tmp598 = bitcast i32 %tmp597 to float
  %tmp599 = fmul float 5.000000e-01, %temp32.0
  %tmp600 = fsub float -0.000000e+00, %tmp599
  %tmp601 = fmul float %tmp598, %temp32.0
  %tmp602 = fadd float %tmp601, %tmp600
  %tmp603 = fmul float %tmp213, %tmp602
  %tmp604 = fadd float %tmp603, %temp28.1
  %tmp605 = fmul float %tmp214, %tmp602
  %tmp606 = fadd float %tmp605, %temp29.1
  %tmp607 = fmul float %tmp215, %tmp602
  %tmp608 = fadd float %tmp607, %temp30.1
  %tmp609 = fadd float %temp24.1, 1.000000e+00
  %tmp610 = fmul float %temp32.0, 5.000000e-01
  br label %LOOP65
}

; CHECK-LABEL: {{^}}main1:
; CHECK: s_endpgm
define amdgpu_ps void @main1([17 x <16 x i8>] addrspace(2)* byval %arg, [32 x <16 x i8>] addrspace(2)* byval %arg1, [16 x <8 x i32>] addrspace(2)* byval %arg2, float inreg %arg3, i32 inreg %arg4, <2 x i32> %arg5, <2 x i32> %arg6, <2 x i32> %arg7, <3 x i32> %arg8, <2 x i32> %arg9, <2 x i32> %arg10, <2 x i32> %arg11, float %arg12, float %arg13, float %arg14, float %arg15, float %arg16, float %arg17, float %arg18, float %arg19, float %arg20) {
main_body:
  %tmp = getelementptr [17 x <16 x i8>], [17 x <16 x i8>] addrspace(2)* %arg, i64 0, i32 0
  %tmp21 = load <16 x i8>, <16 x i8> addrspace(2)* %tmp, !tbaa !0
  %tmp22 = call float @llvm.SI.load.const(<16 x i8> %tmp21, i32 0)
  %tmp23 = call float @llvm.SI.load.const(<16 x i8> %tmp21, i32 4)
  %tmp24 = call float @llvm.SI.load.const(<16 x i8> %tmp21, i32 8)
  %tmp25 = call float @llvm.SI.load.const(<16 x i8> %tmp21, i32 12)
  %tmp26 = call float @llvm.SI.load.const(<16 x i8> %tmp21, i32 28)
  %tmp27 = call float @llvm.SI.load.const(<16 x i8> %tmp21, i32 48)
  %tmp28 = call float @llvm.SI.load.const(<16 x i8> %tmp21, i32 52)
  %tmp29 = call float @llvm.SI.load.const(<16 x i8> %tmp21, i32 56)
  %tmp30 = call float @llvm.SI.load.const(<16 x i8> %tmp21, i32 64)
  %tmp31 = call float @llvm.SI.load.const(<16 x i8> %tmp21, i32 68)
  %tmp32 = call float @llvm.SI.load.const(<16 x i8> %tmp21, i32 72)
  %tmp33 = call float @llvm.SI.load.const(<16 x i8> %tmp21, i32 76)
  %tmp34 = call float @llvm.SI.load.const(<16 x i8> %tmp21, i32 128)
  %tmp35 = call float @llvm.SI.load.const(<16 x i8> %tmp21, i32 132)
  %tmp36 = call float @llvm.SI.load.const(<16 x i8> %tmp21, i32 144)
  %tmp37 = call float @llvm.SI.load.const(<16 x i8> %tmp21, i32 148)
  %tmp38 = call float @llvm.SI.load.const(<16 x i8> %tmp21, i32 152)
  %tmp39 = call float @llvm.SI.load.const(<16 x i8> %tmp21, i32 160)
  %tmp40 = call float @llvm.SI.load.const(<16 x i8> %tmp21, i32 164)
  %tmp41 = call float @llvm.SI.load.const(<16 x i8> %tmp21, i32 168)
  %tmp42 = call float @llvm.SI.load.const(<16 x i8> %tmp21, i32 172)
  %tmp43 = call float @llvm.SI.load.const(<16 x i8> %tmp21, i32 176)
  %tmp44 = call float @llvm.SI.load.const(<16 x i8> %tmp21, i32 180)
  %tmp45 = call float @llvm.SI.load.const(<16 x i8> %tmp21, i32 184)
  %tmp46 = call float @llvm.SI.load.const(<16 x i8> %tmp21, i32 192)
  %tmp47 = call float @llvm.SI.load.const(<16 x i8> %tmp21, i32 196)
  %tmp48 = call float @llvm.SI.load.const(<16 x i8> %tmp21, i32 200)
  %tmp49 = call float @llvm.SI.load.const(<16 x i8> %tmp21, i32 208)
  %tmp50 = call float @llvm.SI.load.const(<16 x i8> %tmp21, i32 212)
  %tmp51 = call float @llvm.SI.load.const(<16 x i8> %tmp21, i32 216)
  %tmp52 = call float @llvm.SI.load.const(<16 x i8> %tmp21, i32 220)
  %tmp53 = call float @llvm.SI.load.const(<16 x i8> %tmp21, i32 236)
  %tmp54 = call float @llvm.SI.load.const(<16 x i8> %tmp21, i32 240)
  %tmp55 = call float @llvm.SI.load.const(<16 x i8> %tmp21, i32 244)
  %tmp56 = call float @llvm.SI.load.const(<16 x i8> %tmp21, i32 248)
  %tmp57 = call float @llvm.SI.load.const(<16 x i8> %tmp21, i32 252)
  %tmp58 = call float @llvm.SI.load.const(<16 x i8> %tmp21, i32 256)
  %tmp59 = call float @llvm.SI.load.const(<16 x i8> %tmp21, i32 260)
  %tmp60 = call float @llvm.SI.load.const(<16 x i8> %tmp21, i32 264)
  %tmp61 = call float @llvm.SI.load.const(<16 x i8> %tmp21, i32 268)
  %tmp62 = call float @llvm.SI.load.const(<16 x i8> %tmp21, i32 272)
  %tmp63 = call float @llvm.SI.load.const(<16 x i8> %tmp21, i32 276)
  %tmp64 = call float @llvm.SI.load.const(<16 x i8> %tmp21, i32 280)
  %tmp65 = call float @llvm.SI.load.const(<16 x i8> %tmp21, i32 284)
  %tmp66 = call float @llvm.SI.load.const(<16 x i8> %tmp21, i32 288)
  %tmp67 = call float @llvm.SI.load.const(<16 x i8> %tmp21, i32 292)
  %tmp68 = call float @llvm.SI.load.const(<16 x i8> %tmp21, i32 464)
  %tmp69 = call float @llvm.SI.load.const(<16 x i8> %tmp21, i32 468)
  %tmp70 = call float @llvm.SI.load.const(<16 x i8> %tmp21, i32 472)
  %tmp71 = call float @llvm.SI.load.const(<16 x i8> %tmp21, i32 496)
  %tmp72 = call float @llvm.SI.load.const(<16 x i8> %tmp21, i32 500)
  %tmp73 = call float @llvm.SI.load.const(<16 x i8> %tmp21, i32 504)
  %tmp74 = call float @llvm.SI.load.const(<16 x i8> %tmp21, i32 512)
  %tmp75 = call float @llvm.SI.load.const(<16 x i8> %tmp21, i32 516)
  %tmp76 = call float @llvm.SI.load.const(<16 x i8> %tmp21, i32 524)
  %tmp77 = call float @llvm.SI.load.const(<16 x i8> %tmp21, i32 532)
  %tmp78 = call float @llvm.SI.load.const(<16 x i8> %tmp21, i32 536)
  %tmp79 = call float @llvm.SI.load.const(<16 x i8> %tmp21, i32 540)
  %tmp80 = call float @llvm.SI.load.const(<16 x i8> %tmp21, i32 544)
  %tmp81 = call float @llvm.SI.load.const(<16 x i8> %tmp21, i32 548)
  %tmp82 = call float @llvm.SI.load.const(<16 x i8> %tmp21, i32 552)
  %tmp83 = call float @llvm.SI.load.const(<16 x i8> %tmp21, i32 556)
  %tmp84 = call float @llvm.SI.load.const(<16 x i8> %tmp21, i32 560)
  %tmp85 = call float @llvm.SI.load.const(<16 x i8> %tmp21, i32 564)
  %tmp86 = call float @llvm.SI.load.const(<16 x i8> %tmp21, i32 568)
  %tmp87 = call float @llvm.SI.load.const(<16 x i8> %tmp21, i32 572)
  %tmp88 = call float @llvm.SI.load.const(<16 x i8> %tmp21, i32 576)
  %tmp89 = call float @llvm.SI.load.const(<16 x i8> %tmp21, i32 580)
  %tmp90 = call float @llvm.SI.load.const(<16 x i8> %tmp21, i32 584)
  %tmp91 = call float @llvm.SI.load.const(<16 x i8> %tmp21, i32 588)
  %tmp92 = call float @llvm.SI.load.const(<16 x i8> %tmp21, i32 592)
  %tmp93 = call float @llvm.SI.load.const(<16 x i8> %tmp21, i32 596)
  %tmp94 = call float @llvm.SI.load.const(<16 x i8> %tmp21, i32 600)
  %tmp95 = call float @llvm.SI.load.const(<16 x i8> %tmp21, i32 604)
  %tmp96 = call float @llvm.SI.load.const(<16 x i8> %tmp21, i32 608)
  %tmp97 = call float @llvm.SI.load.const(<16 x i8> %tmp21, i32 612)
  %tmp98 = call float @llvm.SI.load.const(<16 x i8> %tmp21, i32 616)
  %tmp99 = call float @llvm.SI.load.const(<16 x i8> %tmp21, i32 624)
  %tmp100 = call float @llvm.SI.load.const(<16 x i8> %tmp21, i32 628)
  %tmp101 = call float @llvm.SI.load.const(<16 x i8> %tmp21, i32 632)
  %tmp102 = call float @llvm.SI.load.const(<16 x i8> %tmp21, i32 636)
  %tmp103 = call float @llvm.SI.load.const(<16 x i8> %tmp21, i32 640)
  %tmp104 = call float @llvm.SI.load.const(<16 x i8> %tmp21, i32 644)
  %tmp105 = call float @llvm.SI.load.const(<16 x i8> %tmp21, i32 648)
  %tmp106 = call float @llvm.SI.load.const(<16 x i8> %tmp21, i32 652)
  %tmp107 = call float @llvm.SI.load.const(<16 x i8> %tmp21, i32 656)
  %tmp108 = call float @llvm.SI.load.const(<16 x i8> %tmp21, i32 660)
  %tmp109 = call float @llvm.SI.load.const(<16 x i8> %tmp21, i32 664)
  %tmp110 = call float @llvm.SI.load.const(<16 x i8> %tmp21, i32 668)
  %tmp111 = call float @llvm.SI.load.const(<16 x i8> %tmp21, i32 672)
  %tmp112 = call float @llvm.SI.load.const(<16 x i8> %tmp21, i32 676)
  %tmp113 = call float @llvm.SI.load.const(<16 x i8> %tmp21, i32 680)
  %tmp114 = call float @llvm.SI.load.const(<16 x i8> %tmp21, i32 684)
  %tmp115 = call float @llvm.SI.load.const(<16 x i8> %tmp21, i32 688)
  %tmp116 = call float @llvm.SI.load.const(<16 x i8> %tmp21, i32 692)
  %tmp117 = call float @llvm.SI.load.const(<16 x i8> %tmp21, i32 696)
  %tmp118 = call float @llvm.SI.load.const(<16 x i8> %tmp21, i32 700)
  %tmp119 = call float @llvm.SI.load.const(<16 x i8> %tmp21, i32 704)
  %tmp120 = call float @llvm.SI.load.const(<16 x i8> %tmp21, i32 708)
  %tmp121 = call float @llvm.SI.load.const(<16 x i8> %tmp21, i32 712)
  %tmp122 = call float @llvm.SI.load.const(<16 x i8> %tmp21, i32 716)
  %tmp123 = call float @llvm.SI.load.const(<16 x i8> %tmp21, i32 864)
  %tmp124 = call float @llvm.SI.load.const(<16 x i8> %tmp21, i32 868)
  %tmp125 = getelementptr [16 x <8 x i32>], [16 x <8 x i32>] addrspace(2)* %arg2, i64 0, i32 0
  %tmp126 = load <8 x i32>, <8 x i32> addrspace(2)* %tmp125, !tbaa !0
  %tmp127 = getelementptr [32 x <16 x i8>], [32 x <16 x i8>] addrspace(2)* %arg1, i64 0, i32 0
  %tmp128 = load <16 x i8>, <16 x i8> addrspace(2)* %tmp127, !tbaa !0
  %tmp129 = getelementptr [16 x <8 x i32>], [16 x <8 x i32>] addrspace(2)* %arg2, i64 0, i32 1
  %tmp130 = load <8 x i32>, <8 x i32> addrspace(2)* %tmp129, !tbaa !0
  %tmp131 = getelementptr [32 x <16 x i8>], [32 x <16 x i8>] addrspace(2)* %arg1, i64 0, i32 1
  %tmp132 = load <16 x i8>, <16 x i8> addrspace(2)* %tmp131, !tbaa !0
  %tmp133 = getelementptr [16 x <8 x i32>], [16 x <8 x i32>] addrspace(2)* %arg2, i64 0, i32 2
  %tmp134 = load <8 x i32>, <8 x i32> addrspace(2)* %tmp133, !tbaa !0
  %tmp135 = getelementptr [32 x <16 x i8>], [32 x <16 x i8>] addrspace(2)* %arg1, i64 0, i32 2
  %tmp136 = load <16 x i8>, <16 x i8> addrspace(2)* %tmp135, !tbaa !0
  %tmp137 = getelementptr [16 x <8 x i32>], [16 x <8 x i32>] addrspace(2)* %arg2, i64 0, i32 3
  %tmp138 = load <8 x i32>, <8 x i32> addrspace(2)* %tmp137, !tbaa !0
  %tmp139 = getelementptr [32 x <16 x i8>], [32 x <16 x i8>] addrspace(2)* %arg1, i64 0, i32 3
  %tmp140 = load <16 x i8>, <16 x i8> addrspace(2)* %tmp139, !tbaa !0
  %tmp141 = getelementptr [16 x <8 x i32>], [16 x <8 x i32>] addrspace(2)* %arg2, i64 0, i32 4
  %tmp142 = load <8 x i32>, <8 x i32> addrspace(2)* %tmp141, !tbaa !0
  %tmp143 = getelementptr [32 x <16 x i8>], [32 x <16 x i8>] addrspace(2)* %arg1, i64 0, i32 4
  %tmp144 = load <16 x i8>, <16 x i8> addrspace(2)* %tmp143, !tbaa !0
  %tmp145 = getelementptr [16 x <8 x i32>], [16 x <8 x i32>] addrspace(2)* %arg2, i64 0, i32 5
  %tmp146 = load <8 x i32>, <8 x i32> addrspace(2)* %tmp145, !tbaa !0
  %tmp147 = getelementptr [32 x <16 x i8>], [32 x <16 x i8>] addrspace(2)* %arg1, i64 0, i32 5
  %tmp148 = load <16 x i8>, <16 x i8> addrspace(2)* %tmp147, !tbaa !0
  %tmp149 = getelementptr [16 x <8 x i32>], [16 x <8 x i32>] addrspace(2)* %arg2, i64 0, i32 6
  %tmp150 = load <8 x i32>, <8 x i32> addrspace(2)* %tmp149, !tbaa !0
  %tmp151 = getelementptr [32 x <16 x i8>], [32 x <16 x i8>] addrspace(2)* %arg1, i64 0, i32 6
  %tmp152 = load <16 x i8>, <16 x i8> addrspace(2)* %tmp151, !tbaa !0
  %tmp153 = getelementptr [16 x <8 x i32>], [16 x <8 x i32>] addrspace(2)* %arg2, i64 0, i32 7
  %tmp154 = load <8 x i32>, <8 x i32> addrspace(2)* %tmp153, !tbaa !0
  %tmp155 = getelementptr [32 x <16 x i8>], [32 x <16 x i8>] addrspace(2)* %arg1, i64 0, i32 7
  %tmp156 = load <16 x i8>, <16 x i8> addrspace(2)* %tmp155, !tbaa !0
  %tmp157 = getelementptr [16 x <8 x i32>], [16 x <8 x i32>] addrspace(2)* %arg2, i64 0, i32 8
  %tmp158 = load <8 x i32>, <8 x i32> addrspace(2)* %tmp157, !tbaa !0
  %tmp159 = getelementptr [32 x <16 x i8>], [32 x <16 x i8>] addrspace(2)* %arg1, i64 0, i32 8
  %tmp160 = load <16 x i8>, <16 x i8> addrspace(2)* %tmp159, !tbaa !0
  %tmp161 = fcmp ugt float %arg17, 0.000000e+00
  %tmp162 = select i1 %tmp161, float 1.000000e+00, float 0.000000e+00
  %tmp163 = call float @llvm.SI.fs.interp(i32 0, i32 0, i32 %arg4, <2 x i32> %arg6)
  %tmp164 = call float @llvm.SI.fs.interp(i32 1, i32 0, i32 %arg4, <2 x i32> %arg6)
  %tmp165 = call float @llvm.SI.fs.interp(i32 2, i32 0, i32 %arg4, <2 x i32> %arg6)
  %tmp166 = call float @llvm.SI.fs.interp(i32 3, i32 0, i32 %arg4, <2 x i32> %arg6)
  %tmp167 = call float @llvm.SI.fs.interp(i32 0, i32 1, i32 %arg4, <2 x i32> %arg6)
  %tmp168 = call float @llvm.SI.fs.interp(i32 1, i32 1, i32 %arg4, <2 x i32> %arg6)
  %tmp169 = call float @llvm.SI.fs.interp(i32 2, i32 1, i32 %arg4, <2 x i32> %arg6)
  %tmp170 = call float @llvm.SI.fs.interp(i32 3, i32 1, i32 %arg4, <2 x i32> %arg6)
  %tmp171 = call float @llvm.SI.fs.interp(i32 0, i32 2, i32 %arg4, <2 x i32> %arg6)
  %tmp172 = call float @llvm.SI.fs.interp(i32 1, i32 2, i32 %arg4, <2 x i32> %arg6)
  %tmp173 = call float @llvm.SI.fs.interp(i32 2, i32 2, i32 %arg4, <2 x i32> %arg6)
  %tmp174 = call float @llvm.SI.fs.interp(i32 3, i32 2, i32 %arg4, <2 x i32> %arg6)
  %tmp175 = call float @llvm.SI.fs.interp(i32 0, i32 3, i32 %arg4, <2 x i32> %arg6)
  %tmp176 = call float @llvm.SI.fs.interp(i32 1, i32 3, i32 %arg4, <2 x i32> %arg6)
  %tmp177 = call float @llvm.SI.fs.interp(i32 2, i32 3, i32 %arg4, <2 x i32> %arg6)
  %tmp178 = call float @llvm.SI.fs.interp(i32 3, i32 3, i32 %arg4, <2 x i32> %arg6)
  %tmp179 = call float @llvm.SI.fs.interp(i32 0, i32 4, i32 %arg4, <2 x i32> %arg6)
  %tmp180 = call float @llvm.SI.fs.interp(i32 1, i32 4, i32 %arg4, <2 x i32> %arg6)
  %tmp181 = call float @llvm.SI.fs.interp(i32 2, i32 4, i32 %arg4, <2 x i32> %arg6)
  %tmp182 = call float @llvm.SI.fs.interp(i32 3, i32 4, i32 %arg4, <2 x i32> %arg6)
  %tmp183 = call float @llvm.SI.fs.interp(i32 0, i32 5, i32 %arg4, <2 x i32> %arg6)
  %tmp184 = call float @llvm.SI.fs.interp(i32 1, i32 5, i32 %arg4, <2 x i32> %arg6)
  %tmp185 = call float @llvm.SI.fs.interp(i32 2, i32 5, i32 %arg4, <2 x i32> %arg6)
  %tmp186 = call float @llvm.SI.fs.interp(i32 3, i32 5, i32 %arg4, <2 x i32> %arg6)
  %tmp187 = call float @llvm.SI.fs.interp(i32 0, i32 6, i32 %arg4, <2 x i32> %arg6)
  %tmp188 = call float @llvm.SI.fs.interp(i32 1, i32 6, i32 %arg4, <2 x i32> %arg6)
  %tmp189 = call float @llvm.SI.fs.interp(i32 2, i32 6, i32 %arg4, <2 x i32> %arg6)
  %tmp190 = call float @llvm.SI.fs.interp(i32 3, i32 6, i32 %arg4, <2 x i32> %arg6)
  %tmp191 = call float @llvm.SI.fs.interp(i32 0, i32 7, i32 %arg4, <2 x i32> %arg6)
  %tmp192 = call float @llvm.SI.fs.interp(i32 1, i32 7, i32 %arg4, <2 x i32> %arg6)
  %tmp193 = call float @llvm.SI.fs.interp(i32 2, i32 7, i32 %arg4, <2 x i32> %arg6)
  %tmp194 = call float @llvm.SI.fs.interp(i32 3, i32 7, i32 %arg4, <2 x i32> %arg6)
  %tmp195 = fmul float %arg14, %tmp123
  %tmp196 = fadd float %tmp195, %tmp124
  %tmp197 = call float @llvm.AMDGPU.clamp.f32(float %tmp162, float 0.000000e+00, float 1.000000e+00)
  %tmp198 = call float @llvm.AMDGPU.clamp.f32(float 0.000000e+00, float 0.000000e+00, float 1.000000e+00)
  %tmp199 = call float @llvm.AMDGPU.clamp.f32(float 0.000000e+00, float 0.000000e+00, float 1.000000e+00)
  %tmp200 = call float @llvm.AMDGPU.clamp.f32(float 1.000000e+00, float 0.000000e+00, float 1.000000e+00)
  %tmp201 = bitcast float %tmp197 to i32
  %tmp202 = icmp ne i32 %tmp201, 0
  %. = select i1 %tmp202, float -1.000000e+00, float 1.000000e+00
  %tmp203 = fsub float -0.000000e+00, %tmp163
  %tmp204 = fadd float %tmp43, %tmp203
  %tmp205 = fsub float -0.000000e+00, %tmp164
  %tmp206 = fadd float %tmp44, %tmp205
  %tmp207 = fsub float -0.000000e+00, %tmp165
  %tmp208 = fadd float %tmp45, %tmp207
  %tmp209 = fmul float %tmp204, %tmp204
  %tmp210 = fmul float %tmp206, %tmp206
  %tmp211 = fadd float %tmp210, %tmp209
  %tmp212 = fmul float %tmp208, %tmp208
  %tmp213 = fadd float %tmp211, %tmp212
  %tmp214 = call float @llvm.amdgcn.rsq.f32(float %tmp213)
  %tmp215 = fmul float %tmp204, %tmp214
  %tmp216 = fmul float %tmp206, %tmp214
  %tmp217 = fmul float %tmp208, %tmp214
  %tmp218 = fmul float %., %tmp53
  %tmp219 = fmul float %arg13, %tmp46
  %tmp220 = fmul float %tmp196, %tmp47
  %tmp221 = bitcast float %tmp173 to i32
  %tmp222 = bitcast float %tmp174 to i32
  %tmp223 = insertelement <2 x i32> undef, i32 %tmp221, i32 0
  %tmp224 = insertelement <2 x i32> %tmp223, i32 %tmp222, i32 1
  %tmp132.bc = bitcast <16 x i8> %tmp132 to <4 x i32>
  %tmp225 = call <4 x float> @llvm.SI.image.sample.v2i32(<2 x i32> %tmp224, <8 x i32> %tmp130, <4 x i32> %tmp132.bc, i32 15, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0)
  %tmp226 = extractelement <4 x float> %tmp225, i32 0
  %tmp227 = extractelement <4 x float> %tmp225, i32 1
  %tmp228 = extractelement <4 x float> %tmp225, i32 2
  %tmp229 = extractelement <4 x float> %tmp225, i32 3
  %tmp230 = fmul float %tmp226, 0x4012611180000000
  %tmp231 = fmul float %tmp227, 0x4012611180000000
  %tmp232 = fmul float %tmp228, 0x4012611180000000
  %one.sub.a.i = fsub float 1.000000e+00, %tmp26
  %result.i = fadd float %tmp230, %one.sub.a.i
  %one.sub.a.i43 = fsub float 1.000000e+00, %tmp26
  %result.i44 = fadd float %tmp231, %one.sub.a.i43
  %one.sub.a.i41 = fsub float 1.000000e+00, %tmp26
  %result.i42 = fadd float %tmp232, %one.sub.a.i41
  %tmp233 = fmul float %tmp215, %tmp183
  %tmp234 = fmul float %tmp216, %tmp184
  %tmp235 = fadd float %tmp234, %tmp233
  %tmp236 = fmul float %tmp217, %tmp185
  %tmp237 = fadd float %tmp235, %tmp236
  %tmp238 = fmul float %tmp215, %tmp186
  %tmp239 = fmul float %tmp216, %tmp187
  %tmp240 = fadd float %tmp239, %tmp238
  %tmp241 = fmul float %tmp217, %tmp188
  %tmp242 = fadd float %tmp240, %tmp241
  %tmp243 = fmul float %tmp215, %tmp189
  %tmp244 = fmul float %tmp216, %tmp190
  %tmp245 = fadd float %tmp244, %tmp243
  %tmp246 = fmul float %tmp217, %tmp191
  %tmp247 = fadd float %tmp245, %tmp246
  %tmp248 = call float @llvm.AMDGPU.clamp.f32(float %tmp247, float 0.000000e+00, float 1.000000e+00)
  %tmp249 = fmul float %tmp213, 0x3F5A36E2E0000000
  %tmp250 = call float @llvm.AMDGPU.clamp.f32(float %tmp249, float 0.000000e+00, float 1.000000e+00)
  %tmp251 = fsub float -0.000000e+00, %tmp250
  %tmp252 = fadd float 1.000000e+00, %tmp251
  %tmp253 = call float @llvm.pow.f32(float %tmp248, float 2.500000e-01)
  %tmp254 = fmul float %tmp38, %tmp253
  %tmp255 = fmul float %tmp237, %tmp254
  %tmp256 = fmul float %tmp242, %tmp254
  %tmp257 = fmul float %tmp255, %tmp229
  %tmp258 = fmul float %tmp256, %tmp229
  %tmp259 = fadd float %tmp248, 0x3EE4F8B580000000
  %tmp260 = fsub float -0.000000e+00, %tmp248
  %tmp261 = fadd float 1.000000e+00, %tmp260
  %tmp262 = fmul float 1.200000e+01, %tmp261
  %tmp263 = fadd float %tmp262, 4.000000e+00
  %tmp264 = fsub float -0.000000e+00, %tmp263
  %tmp265 = fmul float %tmp264, %tmp259
  %tmp266 = fsub float -0.000000e+00, %tmp263
  %tmp267 = fmul float %tmp266, %tmp259
  %tmp268 = fsub float -0.000000e+00, %tmp263
  %tmp269 = fmul float %tmp268, %tmp259
  %tmp270 = fdiv float 1.000000e+00, %tmp265
  %tmp271 = fdiv float 1.000000e+00, %tmp267
  %tmp272 = fdiv float 1.000000e+00, %tmp269
  %tmp273 = fmul float %tmp257, %tmp270
  %tmp274 = fmul float %tmp258, %tmp271
  %tmp275 = fmul float %tmp259, %tmp272
  br label %LOOP

LOOP:                                             ; preds = %LOOP, %main_body
  %temp144.0 = phi float [ 1.000000e+00, %main_body ], [ %tmp288, %LOOP ]
  %temp168.0 = phi float [ %tmp175, %main_body ], [ %tmp284, %LOOP ]
  %temp169.0 = phi float [ %tmp176, %main_body ], [ %tmp285, %LOOP ]
  %temp170.0 = phi float [ %tmp252, %main_body ], [ %tmp286, %LOOP ]
  %tmp276 = bitcast float %temp168.0 to i32
  %tmp277 = bitcast float %temp169.0 to i32
  %tmp278 = insertelement <4 x i32> undef, i32 %tmp276, i32 0
  %tmp279 = insertelement <4 x i32> %tmp278, i32 %tmp277, i32 1
  %tmp280 = insertelement <4 x i32> %tmp279, i32 0, i32 2
  %tmp281 = insertelement <4 x i32> %tmp280, i32 undef, i32 3
  %tmp148.bc = bitcast <16 x i8> %tmp148 to <4 x i32>
  %tmp282 = call <4 x float> @llvm.SI.image.sample.l.v4i32(<4 x i32> %tmp281, <8 x i32> %tmp146, <4 x i32> %tmp148.bc, i32 15, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0)
  %tmp283 = extractelement <4 x float> %tmp282, i32 3
  %tmp284 = fadd float %temp168.0, %tmp273
  %tmp285 = fadd float %temp169.0, %tmp274
  %tmp286 = fadd float %temp170.0, %tmp275
  %tmp287 = fsub float -0.000000e+00, %tmp283
  %tmp288 = fadd float %tmp286, %tmp287
  %tmp289 = fcmp oge float 0.000000e+00, %tmp288
  %tmp290 = sext i1 %tmp289 to i32
  %tmp291 = bitcast i32 %tmp290 to float
  %tmp292 = bitcast float %tmp291 to i32
  %tmp293 = icmp ne i32 %tmp292, 0
  br i1 %tmp293, label %IF189, label %LOOP

IF189:                                            ; preds = %LOOP
  %tmp294 = extractelement <4 x float> %tmp282, i32 0
  %tmp295 = extractelement <4 x float> %tmp282, i32 1
  %tmp296 = extractelement <4 x float> %tmp282, i32 2
  %tmp297 = fsub float -0.000000e+00, %tmp288
  %tmp298 = fadd float %temp144.0, %tmp297
  %tmp299 = fdiv float 1.000000e+00, %tmp298
  %tmp300 = fmul float %tmp288, %tmp299
  %tmp301 = fadd float %tmp300, -1.000000e+00
  %tmp302 = fmul float %tmp301, %tmp273
  %tmp303 = fadd float %tmp302, %tmp284
  %tmp304 = fmul float %tmp301, %tmp274
  %tmp305 = fadd float %tmp304, %tmp285
  %tmp306 = fsub float -0.000000e+00, %tmp175
  %tmp307 = fadd float %tmp303, %tmp306
  %tmp308 = fsub float -0.000000e+00, %tmp176
  %tmp309 = fadd float %tmp305, %tmp308
  %tmp310 = fadd float %tmp175, %tmp307
  %tmp311 = fadd float %tmp176, %tmp309
  %tmp312 = fmul float %tmp307, %tmp66
  %tmp313 = fmul float %tmp309, %tmp67
  %tmp314 = fmul float %tmp312, %tmp54
  %tmp315 = fmul float %tmp312, %tmp55
  %tmp316 = fmul float %tmp313, %tmp56
  %tmp317 = fadd float %tmp316, %tmp314
  %tmp318 = fmul float %tmp313, %tmp57
  %tmp319 = fadd float %tmp318, %tmp315
  %tmp320 = fadd float %tmp177, %tmp317
  %tmp321 = fadd float %tmp178, %tmp319
  %tmp322 = fmul float %tmp312, %tmp58
  %tmp323 = fmul float %tmp312, %tmp59
  %tmp324 = fmul float %tmp312, %tmp60
  %tmp325 = fmul float %tmp312, %tmp61
  %tmp326 = fmul float %tmp313, %tmp62
  %tmp327 = fadd float %tmp326, %tmp322
  %tmp328 = fmul float %tmp313, %tmp63
  %tmp329 = fadd float %tmp328, %tmp323
  %tmp330 = fmul float %tmp313, %tmp64
  %tmp331 = fadd float %tmp330, %tmp324
  %tmp332 = fmul float %tmp313, %tmp65
  %tmp333 = fadd float %tmp332, %tmp325
  %tmp334 = fadd float %tmp167, %tmp327
  %tmp335 = fadd float %tmp168, %tmp329
  %tmp336 = fadd float %tmp169, %tmp331
  %tmp337 = fadd float %tmp170, %tmp333
  %tmp338 = bitcast float %tmp334 to i32
  %tmp339 = bitcast float %tmp335 to i32
  %tmp340 = insertelement <2 x i32> undef, i32 %tmp338, i32 0
  %tmp341 = insertelement <2 x i32> %tmp340, i32 %tmp339, i32 1
  %tmp136.bc = bitcast <16 x i8> %tmp136 to <4 x i32>
  %tmp342 = call <4 x float> @llvm.SI.image.sample.v2i32(<2 x i32> %tmp341, <8 x i32> %tmp134, <4 x i32> %tmp136.bc, i32 15, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0)
  %tmp343 = extractelement <4 x float> %tmp342, i32 0
  %tmp344 = extractelement <4 x float> %tmp342, i32 1
  %tmp345 = extractelement <4 x float> %tmp342, i32 2
  %tmp346 = extractelement <4 x float> %tmp342, i32 3
  %tmp347 = fmul float %tmp343, %tmp22
  %tmp348 = fmul float %tmp344, %tmp23
  %tmp349 = fmul float %tmp345, %tmp24
  %tmp350 = fmul float %tmp346, %tmp25
  %tmp351 = fmul float %tmp347, %tmp179
  %tmp352 = fmul float %tmp348, %tmp180
  %tmp353 = fmul float %tmp349, %tmp181
  %tmp354 = fmul float %tmp350, %tmp182
  %tmp355 = fsub float -0.000000e+00, %tmp346
  %tmp356 = fadd float 1.000000e+00, %tmp355
  %tmp357 = fmul float %tmp356, %tmp48
  %one.sub.a.i37 = fsub float 1.000000e+00, %tmp357
  %one.sub.ac.i38 = fmul float %one.sub.a.i37, %tmp351
  %mul.i39 = fmul float %tmp343, %tmp351
  %result.i40 = fadd float %mul.i39, %one.sub.ac.i38
  %one.sub.a.i33 = fsub float 1.000000e+00, %tmp357
  %one.sub.ac.i34 = fmul float %one.sub.a.i33, %tmp352
  %mul.i35 = fmul float %tmp344, %tmp352
  %result.i36 = fadd float %mul.i35, %one.sub.ac.i34
  %one.sub.a.i29 = fsub float 1.000000e+00, %tmp357
  %one.sub.ac.i30 = fmul float %one.sub.a.i29, %tmp353
  %mul.i31 = fmul float %tmp345, %tmp353
  %result.i32 = fadd float %mul.i31, %one.sub.ac.i30
  %tmp358 = bitcast float %tmp336 to i32
  %tmp359 = bitcast float %tmp337 to i32
  %tmp360 = insertelement <2 x i32> undef, i32 %tmp358, i32 0
  %tmp361 = insertelement <2 x i32> %tmp360, i32 %tmp359, i32 1
  %tmp152.bc = bitcast <16 x i8> %tmp152 to <4 x i32>
  %tmp362 = call <4 x float> @llvm.SI.image.sample.v2i32(<2 x i32> %tmp361, <8 x i32> %tmp150, <4 x i32> %tmp152.bc, i32 15, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0)
  %tmp363 = extractelement <4 x float> %tmp362, i32 2
  %tmp364 = fmul float %result.i40, %result.i
  %tmp365 = fmul float %result.i36, %result.i44
  %tmp366 = fmul float %result.i32, %result.i42
  %tmp367 = fmul float %tmp354, %tmp229
  %tmp368 = bitcast float %tmp310 to i32
  %tmp369 = bitcast float %tmp311 to i32
  %tmp370 = insertelement <2 x i32> undef, i32 %tmp368, i32 0
  %tmp371 = insertelement <2 x i32> %tmp370, i32 %tmp369, i32 1
  %tmp140.bc = bitcast <16 x i8> %tmp140 to <4 x i32>
  %tmp372 = call <4 x float> @llvm.SI.image.sample.v2i32(<2 x i32> %tmp371, <8 x i32> %tmp138, <4 x i32> %tmp140.bc, i32 15, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0)
  %tmp373 = extractelement <4 x float> %tmp372, i32 0
  %tmp374 = extractelement <4 x float> %tmp372, i32 1
  %tmp375 = extractelement <4 x float> %tmp372, i32 2
  %tmp376 = extractelement <4 x float> %tmp372, i32 3
  %tmp377 = fcmp olt float 0.000000e+00, %tmp375
  %tmp378 = sext i1 %tmp377 to i32
  %tmp379 = bitcast i32 %tmp378 to float
  %tmp380 = bitcast float %tmp379 to i32
  %tmp381 = icmp ne i32 %tmp380, 0
  %.224 = select i1 %tmp381, float %tmp374, float %tmp373
  %.225 = select i1 %tmp381, float %tmp376, float %tmp374
  %tmp382 = bitcast float %tmp320 to i32
  %tmp383 = bitcast float %tmp321 to i32
  %tmp384 = insertelement <2 x i32> undef, i32 %tmp382, i32 0
  %tmp385 = insertelement <2 x i32> %tmp384, i32 %tmp383, i32 1
  %tmp144.bc = bitcast <16 x i8> %tmp144 to <4 x i32>
  %tmp386 = call <4 x float> @llvm.SI.image.sample.v2i32(<2 x i32> %tmp385, <8 x i32> %tmp142, <4 x i32> %tmp144.bc, i32 15, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0)
  %tmp387 = extractelement <4 x float> %tmp386, i32 0
  %tmp388 = extractelement <4 x float> %tmp386, i32 1
  %tmp389 = extractelement <4 x float> %tmp386, i32 2
  %tmp390 = extractelement <4 x float> %tmp386, i32 3
  %tmp391 = fcmp olt float 0.000000e+00, %tmp389
  %tmp392 = sext i1 %tmp391 to i32
  %tmp393 = bitcast i32 %tmp392 to float
  %tmp394 = bitcast float %tmp393 to i32
  %tmp395 = icmp ne i32 %tmp394, 0
  %temp112.1 = select i1 %tmp395, float %tmp388, float %tmp387
  %temp113.1 = select i1 %tmp395, float %tmp390, float %tmp388
  %tmp396 = fmul float %.224, 2.000000e+00
  %tmp397 = fadd float %tmp396, -1.000000e+00
  %tmp398 = fmul float %.225, 2.000000e+00
  %tmp399 = fadd float %tmp398, -1.000000e+00
  %tmp400 = fmul float %temp112.1, 2.000000e+00
  %tmp401 = fadd float %tmp400, -1.000000e+00
  %tmp402 = fmul float %temp113.1, 2.000000e+00
  %tmp403 = fadd float %tmp402, -1.000000e+00
  %tmp404 = fsub float -0.000000e+00, %tmp397
  %tmp405 = fmul float %tmp404, %tmp34
  %tmp406 = fsub float -0.000000e+00, %tmp399
  %tmp407 = fmul float %tmp406, %tmp34
  %tmp408 = fsub float -0.000000e+00, %tmp401
  %tmp409 = fmul float %tmp408, %tmp35
  %tmp410 = fsub float -0.000000e+00, %tmp403
  %tmp411 = fmul float %tmp410, %tmp35
  %tmp412 = fmul float %tmp409, %tmp363
  %tmp413 = fmul float %tmp411, %tmp363
  %tmp414 = call float @fabs(float %tmp405)
  %tmp415 = call float @fabs(float %tmp407)
  %tmp416 = fsub float -0.000000e+00, %tmp414
  %tmp417 = fadd float 1.000000e+00, %tmp416
  %tmp418 = fsub float -0.000000e+00, %tmp415
  %tmp419 = fadd float 1.000000e+00, %tmp418
  %tmp420 = fmul float %tmp417, %tmp412
  %tmp421 = fadd float %tmp420, %tmp405
  %tmp422 = fmul float %tmp419, %tmp413
  %tmp423 = fadd float %tmp422, %tmp407
  %tmp424 = fmul float %tmp421, %tmp421
  %tmp425 = fmul float %tmp423, %tmp423
  %tmp426 = fadd float %tmp424, %tmp425
  %tmp427 = fsub float -0.000000e+00, %tmp426
  %tmp428 = fadd float 0x3FF00068E0000000, %tmp427
  %tmp429 = call float @llvm.AMDGPU.clamp.f32(float %tmp428, float 0.000000e+00, float 1.000000e+00)
  %tmp430 = call float @llvm.amdgcn.rsq.f32(float %tmp429)
  %tmp431 = fmul float %tmp430, %tmp429
  %tmp432 = fsub float -0.000000e+00, %tmp429
  %cmp = fcmp ogt float 0.000000e+00, %tmp432
  %tmp433 = select i1 %cmp, float %tmp431, float 0.000000e+00
  %tmp434 = fmul float %tmp183, %tmp421
  %tmp435 = fmul float %tmp184, %tmp421
  %tmp436 = fmul float %tmp185, %tmp421
  %tmp437 = fmul float %tmp186, %tmp423
  %tmp438 = fadd float %tmp437, %tmp434
  %tmp439 = fmul float %tmp187, %tmp423
  %tmp440 = fadd float %tmp439, %tmp435
  %tmp441 = fmul float %tmp188, %tmp423
  %tmp442 = fadd float %tmp441, %tmp436
  %tmp443 = fmul float %tmp189, %tmp433
  %tmp444 = fadd float %tmp443, %tmp438
  %tmp445 = fmul float %tmp190, %tmp433
  %tmp446 = fadd float %tmp445, %tmp440
  %tmp447 = fmul float %tmp191, %tmp433
  %tmp448 = fadd float %tmp447, %tmp442
  %tmp449 = fmul float %tmp444, %tmp444
  %tmp450 = fmul float %tmp446, %tmp446
  %tmp451 = fadd float %tmp450, %tmp449
  %tmp452 = fmul float %tmp448, %tmp448
  %tmp453 = fadd float %tmp451, %tmp452
  %tmp454 = call float @llvm.amdgcn.rsq.f32(float %tmp453)
  %tmp455 = fmul float %tmp444, %tmp454
  %tmp456 = fmul float %tmp446, %tmp454
  %tmp457 = fmul float %tmp448, %tmp454
  %tmp458 = fcmp olt float 0.000000e+00, %tmp218
  %tmp459 = sext i1 %tmp458 to i32
  %tmp460 = bitcast i32 %tmp459 to float
  %tmp461 = bitcast float %tmp460 to i32
  %tmp462 = icmp ne i32 %tmp461, 0
  br i1 %tmp462, label %IF198, label %ENDIF197

IF198:                                            ; preds = %IF189
  %tmp463 = fsub float -0.000000e+00, %tmp455
  %tmp464 = fsub float -0.000000e+00, %tmp456
  %tmp465 = fsub float -0.000000e+00, %tmp457
  br label %ENDIF197

ENDIF197:                                         ; preds = %IF198, %IF189
  %temp14.0 = phi float [ %tmp465, %IF198 ], [ %tmp457, %IF189 ]
  %temp13.0 = phi float [ %tmp464, %IF198 ], [ %tmp456, %IF189 ]
  %temp12.0 = phi float [ %tmp463, %IF198 ], [ %tmp455, %IF189 ]
  %tmp466 = bitcast float %tmp219 to i32
  %tmp467 = bitcast float %tmp220 to i32
  %tmp468 = insertelement <2 x i32> undef, i32 %tmp466, i32 0
  %tmp469 = insertelement <2 x i32> %tmp468, i32 %tmp467, i32 1
  %tmp160.bc = bitcast <16 x i8> %tmp160 to <4 x i32>
  %tmp470 = call <4 x float> @llvm.SI.image.sample.v2i32(<2 x i32> %tmp469, <8 x i32> %tmp158, <4 x i32> %tmp160.bc, i32 15, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0)
  %tmp471 = extractelement <4 x float> %tmp470, i32 0
  %tmp472 = extractelement <4 x float> %tmp470, i32 1
  %tmp473 = extractelement <4 x float> %tmp470, i32 2
  %tmp474 = extractelement <4 x float> %tmp470, i32 3
  %tmp475 = fmul float %tmp471, %tmp39
  %tmp476 = fadd float %tmp475, %tmp40
  %tmp477 = fmul float %tmp472, %tmp39
  %tmp478 = fadd float %tmp477, %tmp40
  %tmp479 = fmul float %tmp473, %tmp39
  %tmp480 = fadd float %tmp479, %tmp40
  %tmp481 = fmul float %tmp474, %tmp41
  %tmp482 = fadd float %tmp481, %tmp42
  %tmp483 = bitcast float %tmp171 to i32
  %tmp484 = bitcast float %tmp172 to i32
  %tmp485 = insertelement <2 x i32> undef, i32 %tmp483, i32 0
  %tmp486 = insertelement <2 x i32> %tmp485, i32 %tmp484, i32 1
  %tmp156.bc = bitcast <16 x i8> %tmp156 to <4 x i32>
  %tmp487 = call <4 x float> @llvm.SI.image.sample.v2i32(<2 x i32> %tmp486, <8 x i32> %tmp154, <4 x i32> %tmp156.bc, i32 15, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0)
  %tmp488 = extractelement <4 x float> %tmp487, i32 0
  %tmp489 = extractelement <4 x float> %tmp487, i32 1
  %tmp490 = extractelement <4 x float> %tmp487, i32 2
  %tmp491 = extractelement <4 x float> %tmp487, i32 3
  %tmp492 = fmul float %tmp491, 3.200000e+01
  %tmp493 = fadd float %tmp492, -1.600000e+01
  %tmp494 = call float @llvm.exp2.f32(float %tmp493)
  %tmp495 = fmul float %tmp488, %tmp494
  %tmp496 = fmul float %tmp489, %tmp494
  %tmp497 = fmul float %tmp490, %tmp494
  %tmp498 = fmul float %tmp27, %tmp495
  %tmp499 = fadd float %tmp498, %tmp192
  %tmp500 = fmul float %tmp28, %tmp496
  %tmp501 = fadd float %tmp500, %tmp193
  %tmp502 = fmul float %tmp29, %tmp497
  %tmp503 = fadd float %tmp502, %tmp194
  %tmp504 = fmul float %tmp499, %tmp482
  %tmp505 = fmul float %tmp501, %tmp482
  %tmp506 = fmul float %tmp503, %tmp482
  %tmp507 = fmul float %tmp482, 5.000000e-01
  %tmp508 = fadd float %tmp507, 5.000000e-01
  %tmp509 = fmul float %tmp476, %tmp508
  %tmp510 = fadd float %tmp509, %tmp504
  %tmp511 = fmul float %tmp478, %tmp508
  %tmp512 = fadd float %tmp511, %tmp505
  %tmp513 = fmul float %tmp480, %tmp508
  %tmp514 = fadd float %tmp513, %tmp506
  %tmp515 = fmul float %tmp510, %tmp364
  %tmp516 = fmul float %tmp512, %tmp365
  %tmp517 = fmul float %tmp514, %tmp366
  %tmp518 = fmul float %tmp421, 0x3FDB272440000000
  %tmp519 = fmul float %tmp423, 0xBFDB272440000000
  %tmp520 = fadd float %tmp519, %tmp518
  %tmp521 = fmul float %tmp433, 0x3FE99999A0000000
  %tmp522 = fadd float %tmp520, %tmp521
  %tmp523 = fmul float %tmp522, 5.000000e-01
  %tmp524 = fadd float %tmp523, 0x3FE3333340000000
  %tmp525 = fmul float %tmp524, %tmp524
  %tmp526 = fmul float %tmp515, %tmp525
  %tmp527 = fmul float %tmp516, %tmp525
  %tmp528 = fmul float %tmp517, %tmp525
  %tmp529 = fsub float -0.000000e+00, %tmp71
  %tmp530 = fsub float -0.000000e+00, %tmp72
  %tmp531 = fsub float -0.000000e+00, %tmp73
  %tmp532 = fmul float %temp12.0, %tmp529
  %tmp533 = fmul float %temp13.0, %tmp530
  %tmp534 = fadd float %tmp533, %tmp532
  %tmp535 = fmul float %temp14.0, %tmp531
  %tmp536 = fadd float %tmp534, %tmp535
  %tmp537 = call float @llvm.AMDGPU.clamp.f32(float %tmp536, float 0.000000e+00, float 1.000000e+00)
  %tmp538 = fmul float %tmp364, %tmp537
  %tmp539 = fmul float %tmp365, %tmp537
  %tmp540 = fmul float %tmp366, %tmp537
  %tmp541 = fmul float %tmp538, %tmp68
  %tmp542 = fmul float %tmp539, %tmp69
  %tmp543 = fmul float %tmp540, %tmp70
  %tmp544 = fsub float -0.000000e+00, %tmp163
  %tmp545 = fadd float %tmp96, %tmp544
  %tmp546 = fsub float -0.000000e+00, %tmp164
  %tmp547 = fadd float %tmp97, %tmp546
  %tmp548 = fsub float -0.000000e+00, %tmp165
  %tmp549 = fadd float %tmp98, %tmp548
  %tmp550 = fmul float %tmp545, %tmp545
  %tmp551 = fmul float %tmp547, %tmp547
  %tmp552 = fadd float %tmp551, %tmp550
  %tmp553 = fmul float %tmp549, %tmp549
  %tmp554 = fadd float %tmp552, %tmp553
  %tmp555 = call float @llvm.amdgcn.rsq.f32(float %tmp554)
  %tmp556 = fmul float %tmp555, %tmp554
  %tmp557 = fsub float -0.000000e+00, %tmp554
  %cmp1 = fcmp ogt float %tmp557, 0.000000e+00
  %tmp558 = select i1 %cmp1, float %tmp556, float 0.000000e+00
  %tmp559 = fsub float -0.000000e+00, %tmp83
  %tmp560 = fadd float %tmp558, %tmp559
  %tmp561 = fsub float -0.000000e+00, %tmp82
  %tmp562 = fadd float %tmp558, %tmp561
  %tmp563 = fsub float -0.000000e+00, %tmp81
  %tmp564 = fadd float %tmp558, %tmp563
  %tmp565 = fsub float -0.000000e+00, %tmp83
  %tmp566 = fadd float %tmp82, %tmp565
  %tmp567 = fsub float -0.000000e+00, %tmp82
  %tmp568 = fadd float %tmp81, %tmp567
  %tmp569 = fsub float -0.000000e+00, %tmp81
  %tmp570 = fadd float %tmp80, %tmp569
  %tmp571 = fdiv float 1.000000e+00, %tmp566
  %tmp572 = fdiv float 1.000000e+00, %tmp568
  %tmp573 = fdiv float 1.000000e+00, %tmp570
  %tmp574 = fmul float %tmp560, %tmp571
  %tmp575 = fmul float %tmp562, %tmp572
  %tmp576 = fmul float %tmp564, %tmp573
  %tmp577 = fcmp olt float %tmp558, %tmp82
  %tmp578 = sext i1 %tmp577 to i32
  %tmp579 = bitcast i32 %tmp578 to float
  %tmp580 = bitcast float %tmp579 to i32
  %tmp581 = icmp ne i32 %tmp580, 0
  br i1 %tmp581, label %ENDIF200, label %ELSE202

ELSE202:                                          ; preds = %ENDIF197
  %tmp582 = fcmp olt float %tmp558, %tmp81
  %tmp583 = sext i1 %tmp582 to i32
  %tmp584 = bitcast i32 %tmp583 to float
  %tmp585 = bitcast float %tmp584 to i32
  %tmp586 = icmp ne i32 %tmp585, 0
  br i1 %tmp586, label %ENDIF200, label %ELSE205

ENDIF200:                                         ; preds = %ELSE205, %ELSE202, %ENDIF197
  %temp80.0 = phi float [ %tmp574, %ENDIF197 ], [ %.226, %ELSE205 ], [ %tmp575, %ELSE202 ]
  %temp88.0 = phi float [ %tmp121, %ENDIF197 ], [ %.227, %ELSE205 ], [ %tmp119, %ELSE202 ]
  %temp89.0 = phi float [ %tmp122, %ENDIF197 ], [ %.228, %ELSE205 ], [ %tmp120, %ELSE202 ]
  %temp90.0 = phi float [ %tmp119, %ENDIF197 ], [ %tmp115, %ELSE205 ], [ %tmp117, %ELSE202 ]
  %temp91.0 = phi float [ %tmp120, %ENDIF197 ], [ %tmp116, %ELSE205 ], [ %tmp118, %ELSE202 ]
  %tmp587 = fcmp olt float %tmp558, %tmp82
  %tmp588 = sext i1 %tmp587 to i32
  %tmp589 = bitcast i32 %tmp588 to float
  %tmp590 = bitcast float %tmp589 to i32
  %tmp591 = icmp ne i32 %tmp590, 0
  br i1 %tmp591, label %ENDIF209, label %ELSE211

ELSE205:                                          ; preds = %ELSE202
  %tmp592 = fcmp olt float %tmp558, %tmp80
  %tmp593 = sext i1 %tmp592 to i32
  %tmp594 = bitcast i32 %tmp593 to float
  %tmp595 = bitcast float %tmp594 to i32
  %tmp596 = icmp ne i32 %tmp595, 0
  %.226 = select i1 %tmp596, float %tmp576, float 1.000000e+00
  %.227 = select i1 %tmp596, float %tmp117, float %tmp115
  %.228 = select i1 %tmp596, float %tmp118, float %tmp116
  br label %ENDIF200

ELSE211:                                          ; preds = %ENDIF200
  %tmp597 = fcmp olt float %tmp558, %tmp81
  %tmp598 = sext i1 %tmp597 to i32
  %tmp599 = bitcast i32 %tmp598 to float
  %tmp600 = bitcast float %tmp599 to i32
  %tmp601 = icmp ne i32 %tmp600, 0
  br i1 %tmp601, label %ENDIF209, label %ELSE214

ENDIF209:                                         ; preds = %ELSE214, %ELSE211, %ENDIF200
  %temp52.0 = phi float [ %tmp107, %ENDIF200 ], [ %tmp99, %ELSE214 ], [ %tmp103, %ELSE211 ]
  %temp53.0 = phi float [ %tmp108, %ENDIF200 ], [ %tmp100, %ELSE214 ], [ %tmp104, %ELSE211 ]
  %temp54.0 = phi float [ %tmp109, %ENDIF200 ], [ %tmp101, %ELSE214 ], [ %tmp105, %ELSE211 ]
  %temp55.0 = phi float [ %tmp110, %ENDIF200 ], [ %tmp102, %ELSE214 ], [ %tmp106, %ELSE211 ]
  %temp68.0 = phi float [ %tmp111, %ENDIF200 ], [ %.230, %ELSE214 ], [ %tmp107, %ELSE211 ]
  %temp69.0 = phi float [ %tmp112, %ENDIF200 ], [ %.231, %ELSE214 ], [ %tmp108, %ELSE211 ]
  %temp70.0 = phi float [ %tmp113, %ENDIF200 ], [ %.232, %ELSE214 ], [ %tmp109, %ELSE211 ]
  %temp71.0 = phi float [ %tmp114, %ENDIF200 ], [ %.233, %ELSE214 ], [ %tmp110, %ELSE211 ]
  %tmp602 = fmul float %tmp163, %tmp84
  %tmp603 = fmul float %tmp164, %tmp85
  %tmp604 = fadd float %tmp602, %tmp603
  %tmp605 = fmul float %tmp165, %tmp86
  %tmp606 = fadd float %tmp604, %tmp605
  %tmp607 = fmul float %tmp166, %tmp87
  %tmp608 = fadd float %tmp606, %tmp607
  %tmp609 = fmul float %tmp163, %tmp88
  %tmp610 = fmul float %tmp164, %tmp89
  %tmp611 = fadd float %tmp609, %tmp610
  %tmp612 = fmul float %tmp165, %tmp90
  %tmp613 = fadd float %tmp611, %tmp612
  %tmp614 = fmul float %tmp166, %tmp91
  %tmp615 = fadd float %tmp613, %tmp614
  %tmp616 = fmul float %tmp163, %tmp92
  %tmp617 = fmul float %tmp164, %tmp93
  %tmp618 = fadd float %tmp616, %tmp617
  %tmp619 = fmul float %tmp165, %tmp94
  %tmp620 = fadd float %tmp618, %tmp619
  %tmp621 = fmul float %tmp166, %tmp95
  %tmp622 = fadd float %tmp620, %tmp621
  %tmp623 = fsub float -0.000000e+00, %tmp77
  %tmp624 = fadd float 1.000000e+00, %tmp623
  %tmp625 = call float @fabs(float %tmp608)
  %tmp626 = call float @fabs(float %tmp615)
  %tmp627 = fcmp oge float %tmp624, %tmp625
  %tmp628 = sext i1 %tmp627 to i32
  %tmp629 = bitcast i32 %tmp628 to float
  %tmp630 = bitcast float %tmp629 to i32
  %tmp631 = and i32 %tmp630, 1065353216
  %tmp632 = bitcast i32 %tmp631 to float
  %tmp633 = fcmp oge float %tmp624, %tmp626
  %tmp634 = sext i1 %tmp633 to i32
  %tmp635 = bitcast i32 %tmp634 to float
  %tmp636 = bitcast float %tmp635 to i32
  %tmp637 = and i32 %tmp636, 1065353216
  %tmp638 = bitcast i32 %tmp637 to float
  %tmp639 = fmul float %tmp632, %tmp638
  %tmp640 = fmul float %tmp622, %tmp639
  %tmp641 = fmul float %tmp608, %temp68.0
  %tmp642 = fadd float %tmp641, %temp70.0
  %tmp643 = fmul float %tmp615, %temp69.0
  %tmp644 = fadd float %tmp643, %temp71.0
  %tmp645 = fmul float %tmp608, %temp52.0
  %tmp646 = fadd float %tmp645, %temp54.0
  %tmp647 = fmul float %tmp615, %temp53.0
  %tmp648 = fadd float %tmp647, %temp55.0
  %tmp649 = fadd float %temp80.0, -1.000000e+00
  %tmp650 = fmul float %tmp649, %tmp76
  %tmp651 = fadd float %tmp650, 1.000000e+00
  %tmp652 = call float @llvm.AMDGPU.clamp.f32(float %tmp651, float 0.000000e+00, float 1.000000e+00)
  %tmp653 = bitcast float %tmp642 to i32
  %tmp654 = bitcast float %tmp644 to i32
  %tmp655 = bitcast float 0.000000e+00 to i32
  %tmp656 = insertelement <4 x i32> undef, i32 %tmp653, i32 0
  %tmp657 = insertelement <4 x i32> %tmp656, i32 %tmp654, i32 1
  %tmp658 = insertelement <4 x i32> %tmp657, i32 %tmp655, i32 2
  %tmp659 = insertelement <4 x i32> %tmp658, i32 undef, i32 3
  %tmp128.bc = bitcast <16 x i8> %tmp128 to <4 x i32>
  %tmp660 = call <4 x float> @llvm.SI.image.sample.l.v4i32(<4 x i32> %tmp659, <8 x i32> %tmp126, <4 x i32> %tmp128.bc, i32 15, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0)
  %tmp661 = extractelement <4 x float> %tmp660, i32 0
  %tmp662 = extractelement <4 x float> %tmp660, i32 1
  %tmp663 = bitcast float %tmp646 to i32
  %tmp664 = bitcast float %tmp648 to i32
  %tmp665 = bitcast float 0.000000e+00 to i32
  %tmp666 = insertelement <4 x i32> undef, i32 %tmp663, i32 0
  %tmp667 = insertelement <4 x i32> %tmp666, i32 %tmp664, i32 1
  %tmp668 = insertelement <4 x i32> %tmp667, i32 %tmp665, i32 2
  %tmp669 = insertelement <4 x i32> %tmp668, i32 undef, i32 3
  %tmp670 = call <4 x float> @llvm.SI.image.sample.l.v4i32(<4 x i32> %tmp669, <8 x i32> %tmp126, <4 x i32> %tmp128.bc, i32 15, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0)
  %tmp671 = extractelement <4 x float> %tmp670, i32 0
  %tmp672 = extractelement <4 x float> %tmp670, i32 1
  %tmp673 = fsub float -0.000000e+00, %tmp662
  %tmp674 = fadd float 1.000000e+00, %tmp673
  %tmp675 = fsub float -0.000000e+00, %tmp672
  %tmp676 = fadd float 1.000000e+00, %tmp675
  %tmp677 = fmul float %tmp674, 2.500000e-01
  %tmp678 = fmul float %tmp676, 2.500000e-01
  %tmp679 = fsub float -0.000000e+00, %tmp677
  %tmp680 = fadd float %tmp661, %tmp679
  %tmp681 = fsub float -0.000000e+00, %tmp678
  %tmp682 = fadd float %tmp671, %tmp681
  %tmp683 = fmul float %tmp640, %temp88.0
  %tmp684 = fadd float %tmp683, %temp89.0
  %tmp685 = fmul float %tmp640, %temp90.0
  %tmp686 = fadd float %tmp685, %temp91.0
  %tmp687 = call float @llvm.AMDGPU.clamp.f32(float %tmp684, float 0.000000e+00, float 1.000000e+00)
  %tmp688 = call float @llvm.AMDGPU.clamp.f32(float %tmp686, float 0.000000e+00, float 1.000000e+00)
  %tmp689 = fsub float -0.000000e+00, %tmp687
  %tmp690 = fadd float %tmp661, %tmp689
  %tmp691 = fsub float -0.000000e+00, %tmp688
  %tmp692 = fadd float %tmp671, %tmp691
  %tmp693 = fmul float %tmp661, %tmp661
  %tmp694 = fmul float %tmp671, %tmp671
  %tmp695 = fsub float -0.000000e+00, %tmp693
  %tmp696 = fadd float %tmp680, %tmp695
  %tmp697 = fsub float -0.000000e+00, %tmp694
  %tmp698 = fadd float %tmp682, %tmp697
  %tmp699 = fcmp uge float %tmp696, %tmp74
  %tmp700 = select i1 %tmp699, float %tmp696, float %tmp74
  %tmp701 = fcmp uge float %tmp698, %tmp74
  %tmp702 = select i1 %tmp701, float %tmp698, float %tmp74
  %tmp703 = fmul float %tmp690, %tmp690
  %tmp704 = fadd float %tmp703, %tmp700
  %tmp705 = fmul float %tmp692, %tmp692
  %tmp706 = fadd float %tmp705, %tmp702
  %tmp707 = fdiv float 1.000000e+00, %tmp704
  %tmp708 = fdiv float 1.000000e+00, %tmp706
  %tmp709 = fmul float %tmp700, %tmp707
  %tmp710 = fmul float %tmp702, %tmp708
  %tmp711 = fcmp oge float %tmp690, 0.000000e+00
  %tmp712 = sext i1 %tmp711 to i32
  %tmp713 = bitcast i32 %tmp712 to float
  %tmp714 = bitcast float %tmp713 to i32
  %tmp715 = icmp ne i32 %tmp714, 0
  %.229 = select i1 %tmp715, float 1.000000e+00, float %tmp709
  %tmp716 = fcmp oge float %tmp692, 0.000000e+00
  %tmp717 = sext i1 %tmp716 to i32
  %tmp718 = bitcast i32 %tmp717 to float
  %tmp719 = bitcast float %tmp718 to i32
  %tmp720 = icmp ne i32 %tmp719, 0
  %temp28.0 = select i1 %tmp720, float 1.000000e+00, float %tmp710
  %one.sub.a.i25 = fsub float 1.000000e+00, %tmp652
  %one.sub.ac.i26 = fmul float %one.sub.a.i25, %.229
  %mul.i27 = fmul float %temp28.0, %.229
  %result.i28 = fadd float %mul.i27, %one.sub.ac.i26
  %tmp721 = call float @llvm.pow.f32(float %result.i28, float %tmp75)
  %tmp722 = fmul float %tmp721, %tmp78
  %tmp723 = fadd float %tmp722, %tmp79
  %tmp724 = call float @llvm.AMDGPU.clamp.f32(float %tmp723, float 0.000000e+00, float 1.000000e+00)
  %tmp725 = fmul float %tmp724, %tmp724
  %tmp726 = fmul float 2.000000e+00, %tmp724
  %tmp727 = fsub float -0.000000e+00, %tmp726
  %tmp728 = fadd float 3.000000e+00, %tmp727
  %tmp729 = fmul float %tmp725, %tmp728
  %tmp730 = fmul float %tmp541, %tmp729
  %tmp731 = fmul float %tmp542, %tmp729
  %tmp732 = fmul float %tmp543, %tmp729
  %tmp733 = fmul float %tmp730, %tmp508
  %tmp734 = fadd float %tmp733, %tmp526
  %tmp735 = fmul float %tmp731, %tmp508
  %tmp736 = fadd float %tmp735, %tmp527
  %tmp737 = fmul float %tmp732, %tmp508
  %tmp738 = fadd float %tmp737, %tmp528
  %one.sub.a.i23 = fsub float 1.000000e+00, %tmp229
  %result.i24 = fadd float %tmp283, %one.sub.a.i23
  %one.sub.a.i21 = fsub float 1.000000e+00, %tmp36
  %result.i22 = fadd float %tmp294, %one.sub.a.i21
  %one.sub.a.i19 = fsub float 1.000000e+00, %tmp36
  %result.i20 = fadd float %tmp295, %one.sub.a.i19
  %one.sub.a.i17 = fsub float 1.000000e+00, %tmp36
  %result.i18 = fadd float %tmp296, %one.sub.a.i17
  %one.sub.a.i15 = fsub float 1.000000e+00, %tmp37
  %result.i16 = fadd float %result.i24, %one.sub.a.i15
  %tmp739 = fmul float %result.i22, %result.i16
  %tmp740 = fmul float %result.i20, %result.i16
  %tmp741 = fmul float %result.i18, %result.i16
  %tmp742 = fmul float %tmp734, %tmp739
  %tmp743 = fmul float %tmp736, %tmp740
  %tmp744 = fmul float %tmp738, %tmp741
  %tmp745 = fmul float %temp12.0, %tmp215
  %tmp746 = fmul float %temp13.0, %tmp216
  %tmp747 = fadd float %tmp746, %tmp745
  %tmp748 = fmul float %temp14.0, %tmp217
  %tmp749 = fadd float %tmp747, %tmp748
  %tmp750 = call float @fabs(float %tmp749)
  %tmp751 = fmul float %tmp750, %tmp750
  %tmp752 = fmul float %tmp751, %tmp49
  %tmp753 = fadd float %tmp752, %tmp50
  %tmp754 = call float @llvm.AMDGPU.clamp.f32(float %tmp753, float 0.000000e+00, float 1.000000e+00)
  %tmp755 = fsub float -0.000000e+00, %tmp754
  %tmp756 = fadd float 1.000000e+00, %tmp755
  %tmp757 = fmul float %tmp32, %tmp756
  %tmp758 = fmul float %tmp32, %tmp756
  %tmp759 = fmul float %tmp32, %tmp756
  %tmp760 = fmul float %tmp33, %tmp756
  %one.sub.a.i11 = fsub float 1.000000e+00, %tmp757
  %one.sub.ac.i12 = fmul float %one.sub.a.i11, %tmp742
  %mul.i13 = fmul float %tmp30, %tmp742
  %result.i14 = fadd float %mul.i13, %one.sub.ac.i12
  %one.sub.a.i7 = fsub float 1.000000e+00, %tmp758
  %one.sub.ac.i8 = fmul float %one.sub.a.i7, %tmp743
  %mul.i9 = fmul float %tmp30, %tmp743
  %result.i10 = fadd float %mul.i9, %one.sub.ac.i8
  %one.sub.a.i3 = fsub float 1.000000e+00, %tmp759
  %one.sub.ac.i4 = fmul float %one.sub.a.i3, %tmp744
  %mul.i5 = fmul float %tmp30, %tmp744
  %result.i6 = fadd float %mul.i5, %one.sub.ac.i4
  %one.sub.a.i1 = fsub float 1.000000e+00, %tmp760
  %one.sub.ac.i = fmul float %one.sub.a.i1, %tmp367
  %mul.i = fmul float %tmp31, %tmp367
  %result.i2 = fadd float %mul.i, %one.sub.ac.i
  %tmp761 = fcmp uge float %result.i14, 0x3E6FFFFE60000000
  %tmp762 = select i1 %tmp761, float %result.i14, float 0x3E6FFFFE60000000
  %tmp763 = fcmp uge float %result.i10, 0x3E6FFFFE60000000
  %tmp764 = select i1 %tmp763, float %result.i10, float 0x3E6FFFFE60000000
  %tmp765 = fcmp uge float %result.i6, 0x3E6FFFFE60000000
  %tmp766 = select i1 %tmp765, float %result.i6, float 0x3E6FFFFE60000000
  %tmp767 = fcmp uge float %tmp762, 6.550400e+04
  %tmp768 = select i1 %tmp767, float 6.550400e+04, float %tmp762
  %tmp769 = fcmp uge float %tmp764, 6.550400e+04
  %tmp770 = select i1 %tmp769, float 6.550400e+04, float %tmp764
  %tmp771 = fcmp uge float %tmp766, 6.550400e+04
  %tmp772 = select i1 %tmp771, float 6.550400e+04, float %tmp766
  %tmp773 = fmul float %result.i2, %tmp51
  %tmp774 = fadd float %tmp773, %tmp52
  %tmp775 = call float @llvm.AMDGPU.clamp.f32(float %tmp774, float 0.000000e+00, float 1.000000e+00)
  %tmp776 = call i32 @llvm.SI.packf16(float %tmp768, float %tmp770)
  %tmp777 = bitcast i32 %tmp776 to float
  %tmp778 = call i32 @llvm.SI.packf16(float %tmp772, float %tmp775)
  %tmp779 = bitcast i32 %tmp778 to float
  call void @llvm.SI.export(i32 15, i32 1, i32 1, i32 0, i32 1, float %tmp777, float %tmp779, float %tmp777, float %tmp779)
  ret void

ELSE214:                                          ; preds = %ELSE211
  %tmp780 = fcmp olt float %tmp558, %tmp80
  %tmp781 = sext i1 %tmp780 to i32
  %tmp782 = bitcast i32 %tmp781 to float
  %tmp783 = bitcast float %tmp782 to i32
  %tmp784 = icmp ne i32 %tmp783, 0
  %.230 = select i1 %tmp784, float %tmp103, float %tmp99
  %.231 = select i1 %tmp784, float %tmp104, float %tmp100
  %.232 = select i1 %tmp784, float %tmp105, float %tmp101
  %.233 = select i1 %tmp784, float %tmp106, float %tmp102
  br label %ENDIF209
}

; Function Attrs: readnone
declare float @llvm.AMDGPU.clamp.f32(float, float, float) #1

; Function Attrs: nounwind readnone
declare <4 x float> @llvm.SI.image.sample.v2i32(<2 x i32>, <8 x i32>, <4 x i32>, i32, i32, i32, i32, i32, i32, i32, i32) #2

; Function Attrs: nounwind readnone
declare <4 x float> @llvm.SI.image.sample.l.v4i32(<4 x i32>, <8 x i32>, <4 x i32>, i32, i32, i32, i32, i32, i32, i32, i32) #2


declare float @llvm.exp2.f32(float) #2

; Function Attrs: nounwind readnone
declare float @llvm.SI.load.const(<16 x i8>, i32) #2

; Function Attrs: nounwind readnone
declare float @llvm.SI.fs.interp(i32, i32, i32, <2 x i32>) #2

declare i32 @llvm.amdgcn.mbcnt.lo(i32, i32) #1
declare i32 @llvm.amdgcn.mbcnt.hi(i32, i32) #1

; Function Attrs: nounwind readonly
declare float @ceil(float) #3

; Function Attrs: nounwind readnone
declare float @llvm.amdgcn.rsq.f32(float) #2

; Function Attrs: nounwind readnone
declare <4 x float> @llvm.SI.image.sample.d.v8i32(<8 x i32>, <8 x i32>, <4 x i32>, i32, i32, i32, i32, i32, i32, i32, i32) #2

; Function Attrs: readnone
declare <4 x float> @llvm.AMDGPU.cube(<4 x float>) #1

; Function Attrs: readnone
declare float @fabs(float) #1

; Function Attrs: nounwind readnone
declare <4 x float> @llvm.SI.image.sample.v4i32(<4 x i32>, <8 x i32>, <4 x i32>, i32, i32, i32, i32, i32, i32, i32, i32) #2


; Function Attrs: nounwind readnone
declare float @llvm.pow.f32(float, float) #2

; Function Attrs: nounwind readnone
declare i32 @llvm.SI.packf16(float, float) #2

declare void @llvm.SI.export(i32, i32, i32, i32, i32, float, float, float, float)

attributes #1 = { readnone }
attributes #2 = { nounwind readnone }
attributes #3 = { nounwind readonly }

!0 = !{!1, !1, i64 0, i32 1}
!1 = !{!"const", !2}
!2 = !{!"tbaa root"}
