; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -verify-machineinstrs -mtriple=aarch64-linux-gnu    | FileCheck --check-prefixes=CHECK,NOSPLIT %s
; RUN: llc < %s -verify-machineinstrs -mtriple=aarch64_be-linux-gnu | FileCheck --check-prefixes=CHECK,NOSPLIT %s
; RUN: llc < %s -verify-machineinstrs -mtriple=aarch64-linux-gnu    -mcpu=exynos-m1 | FileCheck --check-prefixes=CHECK,NOSPLIT %s
; RUN: llc < %s -verify-machineinstrs -mtriple=aarch64_be-linux-gnu -mcpu=exynos-m1 | FileCheck --check-prefixes=CHECK,SPLIT %s

define void @test_split_f(<4 x float> %val, <4 x float>* %addr) {
; NOSPLIT-LABEL: test_split_f:
; NOSPLIT:       // %bb.0:
; NOSPLIT-NEXT:    str q0, [x0]
; NOSPLIT-NEXT:    ret
;
; SPLIT-LABEL: test_split_f:
; SPLIT:       // %bb.0:
; SPLIT-NEXT:    rev64 v0.4s, v0.4s
; SPLIT-NEXT:    ext v0.16b, v0.16b, v0.16b, #8
; SPLIT-NEXT:    st1 { v0.2s }, [x0]
; SPLIT-NEXT:    ext v0.16b, v0.16b, v0.16b, #8
; SPLIT-NEXT:    add x8, x0, #8 // =8
; SPLIT-NEXT:    st1 { v0.2s }, [x8]
; SPLIT-NEXT:    ret
  store <4 x float> %val, <4 x float>* %addr, align 8
  ret void
}

define void @test_split_d(<2 x double> %val, <2 x double>* %addr) {
; NOSPLIT-LABEL: test_split_d:
; NOSPLIT:       // %bb.0:
; NOSPLIT-NEXT:    str q0, [x0]
; NOSPLIT-NEXT:    ret
;
; SPLIT-LABEL: test_split_d:
; SPLIT:       // %bb.0:
; SPLIT-NEXT:    ext v0.16b, v0.16b, v0.16b, #8
; SPLIT-NEXT:    st1 { v0.2d }, [x0]
; SPLIT-NEXT:    ret
  store <2 x double> %val, <2 x double>* %addr, align 8
  ret void
}

define void @test_split_128(fp128 %val, fp128* %addr) {
; CHECK-LABEL: test_split_128:
; CHECK:       // %bb.0:
; CHECK-NEXT:    str q0, [x0]
; CHECK-NEXT:    ret
  store fp128 %val, fp128* %addr, align 8
  ret void
}
