// vim:expandtab:shiftwidth=2:tabstop=2:
// Copyright (c) 2012 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "render_widget_host_view_oxide.h"

#include "base/logging.h"
#include "content/common/view_messages.h"

namespace content {

void RenderWidgetHostViewOxide::SelectionBoundsChanged(
    const ViewHostMsg_SelectionBounds_Params& params) {
  OnSelectionBoundsChanged(params.anchor_rect,
                           params.focus_rect,
                           params.is_anchor_first);
  RenderWidgetHostViewBase::SelectionBoundsChanged(params);
}

RenderWidgetHostViewOxide::~RenderWidgetHostViewOxide() {}

} // namespace content
