/* 
   Unix SMB/CIFS implementation.
   test suite for atsvc ndr operations

   Copyright (C) Jelmer Vernooij 2007
   
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3 of the License, or
   (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#include "includes.h"
#include "torture/ndr/ndr.h"
#include "librpc/gen_ndr/ndr_lsa.h"
#include "torture/ndr/proto.h"

static const uint8_t lsarlookupnames_in_data[] = {
  0x00, 0x00, 0x00, 0x00, 0x2a, 0xab, 0xb8, 0x84, 0x36, 0xc6, 0xed, 0x4f,
  0x83, 0x16, 0x04, 0xe8, 0x63, 0x15, 0xeb, 0x84, 0x64, 0x00, 0x00, 0x00,
  0x64, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0a, 0x00, 0x01, 0x00, 0x00, 0x00,
  0x0a, 0x00, 0x0a, 0x00, 0x02, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0a, 0x00,
  0x03, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0a, 0x00, 0x04, 0x00, 0x00, 0x00,
  0x0a, 0x00, 0x0a, 0x00, 0x05, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0a, 0x00,
  0x06, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0a, 0x00, 0x07, 0x00, 0x00, 0x00,
  0x0a, 0x00, 0x0a, 0x00, 0x08, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0a, 0x00,
  0x09, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0a, 0x00, 0x0a, 0x00, 0x00, 0x00,
  0x0a, 0x00, 0x0a, 0x00, 0x0b, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0a, 0x00,
  0x0c, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0a, 0x00, 0x0d, 0x00, 0x00, 0x00,
  0x0a, 0x00, 0x0a, 0x00, 0x0e, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0a, 0x00,
  0x0f, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0a, 0x00, 0x10, 0x00, 0x00, 0x00,
  0x0a, 0x00, 0x0a, 0x00, 0x11, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0a, 0x00,
  0x12, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0a, 0x00, 0x13, 0x00, 0x00, 0x00,
  0x0a, 0x00, 0x0a, 0x00, 0x14, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0a, 0x00,
  0x15, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0a, 0x00, 0x16, 0x00, 0x00, 0x00,
  0x0a, 0x00, 0x0a, 0x00, 0x17, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0a, 0x00,
  0x18, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0a, 0x00, 0x19, 0x00, 0x00, 0x00,
  0x0a, 0x00, 0x0a, 0x00, 0x1a, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0a, 0x00,
  0x1b, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0a, 0x00, 0x1c, 0x00, 0x00, 0x00,
  0x0a, 0x00, 0x0a, 0x00, 0x1d, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0a, 0x00,
  0x1e, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0a, 0x00, 0x1f, 0x00, 0x00, 0x00,
  0x0a, 0x00, 0x0a, 0x00, 0x20, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0a, 0x00,
  0x21, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0a, 0x00, 0x22, 0x00, 0x00, 0x00,
  0x0a, 0x00, 0x0a, 0x00, 0x23, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0a, 0x00,
  0x24, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0a, 0x00, 0x25, 0x00, 0x00, 0x00,
  0x0a, 0x00, 0x0a, 0x00, 0x26, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0a, 0x00,
  0x27, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0a, 0x00, 0x28, 0x00, 0x00, 0x00,
  0x0a, 0x00, 0x0a, 0x00, 0x29, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0a, 0x00,
  0x2a, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0a, 0x00, 0x2b, 0x00, 0x00, 0x00,
  0x0a, 0x00, 0x0a, 0x00, 0x2c, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0a, 0x00,
  0x2d, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0a, 0x00, 0x2e, 0x00, 0x00, 0x00,
  0x0a, 0x00, 0x0a, 0x00, 0x2f, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0a, 0x00,
  0x30, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0a, 0x00, 0x31, 0x00, 0x00, 0x00,
  0x0a, 0x00, 0x0a, 0x00, 0x32, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0a, 0x00,
  0x33, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0a, 0x00, 0x34, 0x00, 0x00, 0x00,
  0x0a, 0x00, 0x0a, 0x00, 0x35, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0a, 0x00,
  0x36, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0a, 0x00, 0x37, 0x00, 0x00, 0x00,
  0x0a, 0x00, 0x0a, 0x00, 0x38, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0a, 0x00,
  0x39, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0a, 0x00, 0x3a, 0x00, 0x00, 0x00,
  0x0a, 0x00, 0x0a, 0x00, 0x3b, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0a, 0x00,
  0x3c, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0a, 0x00, 0x3d, 0x00, 0x00, 0x00,
  0x0a, 0x00, 0x0a, 0x00, 0x3e, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0a, 0x00,
  0x3f, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0a, 0x00, 0x40, 0x00, 0x00, 0x00,
  0x0a, 0x00, 0x0a, 0x00, 0x41, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0a, 0x00,
  0x42, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0a, 0x00, 0x43, 0x00, 0x00, 0x00,
  0x0a, 0x00, 0x0a, 0x00, 0x44, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0a, 0x00,
  0x45, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0a, 0x00, 0x46, 0x00, 0x00, 0x00,
  0x0a, 0x00, 0x0a, 0x00, 0x47, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0a, 0x00,
  0x48, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0a, 0x00, 0x49, 0x00, 0x00, 0x00,
  0x0a, 0x00, 0x0a, 0x00, 0x4a, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0a, 0x00,
  0x4b, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0a, 0x00, 0x4c, 0x00, 0x00, 0x00,
  0x0a, 0x00, 0x0a, 0x00, 0x4d, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0a, 0x00,
  0x4e, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0a, 0x00, 0x4f, 0x00, 0x00, 0x00,
  0x0a, 0x00, 0x0a, 0x00, 0x50, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0a, 0x00,
  0x51, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0a, 0x00, 0x52, 0x00, 0x00, 0x00,
  0x0a, 0x00, 0x0a, 0x00, 0x53, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0a, 0x00,
  0x54, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0a, 0x00, 0x55, 0x00, 0x00, 0x00,
  0x0a, 0x00, 0x0a, 0x00, 0x56, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0a, 0x00,
  0x57, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0a, 0x00, 0x58, 0x00, 0x00, 0x00,
  0x0a, 0x00, 0x0a, 0x00, 0x59, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0a, 0x00,
  0x5a, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0a, 0x00, 0x5b, 0x00, 0x00, 0x00,
  0x0a, 0x00, 0x0a, 0x00, 0x5c, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0a, 0x00,
  0x5d, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0a, 0x00, 0x5e, 0x00, 0x00, 0x00,
  0x0a, 0x00, 0x0a, 0x00, 0x5f, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0a, 0x00,
  0x60, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0a, 0x00, 0x61, 0x00, 0x00, 0x00,
  0x0a, 0x00, 0x0a, 0x00, 0x62, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0a, 0x00,
  0x63, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0a, 0x00, 0x64, 0x00, 0x00, 0x00,
  0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x55, 0x00, 0x73, 0x00, 0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00,
  0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x55, 0x00, 0x73, 0x00, 0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00,
  0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x55, 0x00, 0x73, 0x00, 0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00,
  0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x55, 0x00, 0x73, 0x00, 0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00,
  0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x55, 0x00, 0x73, 0x00, 0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00,
  0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x55, 0x00, 0x73, 0x00, 0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00,
  0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x55, 0x00, 0x73, 0x00, 0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00,
  0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x55, 0x00, 0x73, 0x00, 0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00,
  0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x55, 0x00, 0x73, 0x00, 0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00,
  0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x55, 0x00, 0x73, 0x00, 0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00,
  0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x55, 0x00, 0x73, 0x00, 0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00,
  0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x55, 0x00, 0x73, 0x00, 0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00,
  0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x55, 0x00, 0x73, 0x00, 0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00,
  0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x55, 0x00, 0x73, 0x00, 0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00,
  0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x55, 0x00, 0x73, 0x00, 0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00,
  0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x55, 0x00, 0x73, 0x00, 0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00,
  0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x55, 0x00, 0x73, 0x00, 0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00,
  0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x55, 0x00, 0x73, 0x00, 0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00,
  0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x55, 0x00, 0x73, 0x00, 0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00,
  0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x55, 0x00, 0x73, 0x00, 0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00,
  0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x55, 0x00, 0x73, 0x00, 0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00,
  0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x55, 0x00, 0x73, 0x00, 0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00,
  0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x55, 0x00, 0x73, 0x00, 0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00,
  0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x55, 0x00, 0x73, 0x00, 0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00,
  0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x55, 0x00, 0x73, 0x00, 0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00,
  0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x55, 0x00, 0x73, 0x00, 0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00,
  0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x55, 0x00, 0x73, 0x00, 0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00,
  0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x55, 0x00, 0x73, 0x00, 0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00,
  0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x55, 0x00, 0x73, 0x00, 0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00,
  0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x55, 0x00, 0x73, 0x00, 0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00,
  0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x55, 0x00, 0x73, 0x00, 0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00,
  0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x55, 0x00, 0x73, 0x00, 0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00,
  0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x55, 0x00, 0x73, 0x00, 0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00,
  0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x55, 0x00, 0x73, 0x00, 0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00,
  0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x55, 0x00, 0x73, 0x00, 0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00,
  0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x55, 0x00, 0x73, 0x00, 0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00,
  0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x55, 0x00, 0x73, 0x00, 0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00,
  0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x55, 0x00, 0x73, 0x00, 0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00,
  0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x55, 0x00, 0x73, 0x00, 0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00,
  0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x55, 0x00, 0x73, 0x00, 0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00,
  0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x55, 0x00, 0x73, 0x00, 0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00,
  0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x55, 0x00, 0x73, 0x00, 0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00,
  0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x55, 0x00, 0x73, 0x00, 0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00,
  0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x55, 0x00, 0x73, 0x00, 0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00,
  0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x55, 0x00, 0x73, 0x00, 0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00,
  0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x55, 0x00, 0x73, 0x00, 0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00,
  0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x55, 0x00, 0x73, 0x00, 0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00,
  0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x55, 0x00, 0x73, 0x00, 0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00,
  0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x55, 0x00, 0x73, 0x00, 0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00,
  0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x55, 0x00, 0x73, 0x00, 0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00,
  0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x55, 0x00, 0x73, 0x00, 0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00,
  0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x55, 0x00, 0x73, 0x00, 0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00,
  0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x55, 0x00, 0x73, 0x00, 0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00,
  0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x55, 0x00, 0x73, 0x00, 0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00,
  0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x55, 0x00, 0x73, 0x00, 0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00,
  0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x55, 0x00, 0x73, 0x00, 0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00,
  0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x55, 0x00, 0x73, 0x00, 0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00,
  0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x55, 0x00, 0x73, 0x00, 0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00,
  0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x55, 0x00, 0x73, 0x00, 0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00,
  0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x55, 0x00, 0x73, 0x00, 0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00,
  0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x55, 0x00, 0x73, 0x00, 0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00,
  0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x55, 0x00, 0x73, 0x00, 0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00,
  0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x55, 0x00, 0x73, 0x00, 0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00,
  0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x55, 0x00, 0x73, 0x00, 0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00,
  0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x55, 0x00, 0x73, 0x00, 0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00,
  0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x55, 0x00, 0x73, 0x00, 0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00,
  0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x55, 0x00, 0x73, 0x00, 0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00,
  0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x55, 0x00, 0x73, 0x00, 0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00,
  0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x55, 0x00, 0x73, 0x00, 0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00,
  0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x55, 0x00, 0x73, 0x00, 0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00,
  0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x55, 0x00, 0x73, 0x00, 0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00,
  0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x55, 0x00, 0x73, 0x00, 0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00,
  0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x55, 0x00, 0x73, 0x00, 0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00,
  0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x55, 0x00, 0x73, 0x00, 0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00,
  0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x55, 0x00, 0x73, 0x00, 0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00,
  0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x55, 0x00, 0x73, 0x00, 0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00,
  0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x55, 0x00, 0x73, 0x00, 0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00,
  0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x55, 0x00, 0x73, 0x00, 0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00,
  0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x55, 0x00, 0x73, 0x00, 0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00,
  0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x55, 0x00, 0x73, 0x00, 0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00,
  0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x55, 0x00, 0x73, 0x00, 0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00,
  0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x55, 0x00, 0x73, 0x00, 0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00,
  0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x55, 0x00, 0x73, 0x00, 0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00,
  0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x55, 0x00, 0x73, 0x00, 0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00,
  0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x55, 0x00, 0x73, 0x00, 0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00,
  0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x55, 0x00, 0x73, 0x00, 0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00,
  0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x55, 0x00, 0x73, 0x00, 0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00,
  0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x55, 0x00, 0x73, 0x00, 0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00,
  0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x55, 0x00, 0x73, 0x00, 0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00,
  0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x55, 0x00, 0x73, 0x00, 0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00,
  0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x55, 0x00, 0x73, 0x00, 0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00,
  0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x55, 0x00, 0x73, 0x00, 0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00,
  0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x55, 0x00, 0x73, 0x00, 0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00,
  0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x55, 0x00, 0x73, 0x00, 0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00,
  0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x55, 0x00, 0x73, 0x00, 0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00,
  0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x55, 0x00, 0x73, 0x00, 0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00,
  0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x55, 0x00, 0x73, 0x00, 0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00,
  0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x55, 0x00, 0x73, 0x00, 0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00,
  0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x55, 0x00, 0x73, 0x00, 0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00,
  0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x55, 0x00, 0x73, 0x00, 0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00
};

static bool lsarlookupnames_in_check(struct torture_context *tctx, 
									 struct lsa_LookupNames *r)
{
	int i;
	/* FIXME: Handle */
	torture_assert_int_equal(tctx, r->in.num_names, 100, "num names");
	for (i = 0; i < 100; i++) {
		torture_assert_str_equal(tctx, r->in.names[i].string, "Users", "names");
	}
	torture_assert(tctx, r->in.sids != NULL, "sids");
	torture_assert_int_equal(tctx, r->in.sids->count, 0, "sids count");
	torture_assert(tctx, r->in.sids->sids == NULL, "sids domains");
	torture_assert_int_equal(tctx, r->in.level, 1, "level");
	torture_assert(tctx, r->in.count != NULL, "count ptr");
	torture_assert_int_equal(tctx, *r->in.count, 0, "count");
	return true;
}

static const uint8_t lsarlookupnames_out_data[] = {
  0x00, 0x00, 0x02, 0x00, 0x01, 0x00, 0x00, 0x00, 0x04, 0x00, 0x02, 0x00,
  0x20, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x0e, 0x00, 0x10, 0x00,
  0x08, 0x00, 0x02, 0x00, 0x0c, 0x00, 0x02, 0x00, 0x08, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 0x42, 0x00, 0x55, 0x00,
  0x49, 0x00, 0x4c, 0x00, 0x54, 0x00, 0x49, 0x00, 0x4e, 0x00, 0x00, 0x00,
  0x01, 0x00, 0x00, 0x00, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05,
  0x20, 0x00, 0x00, 0x00, 0x64, 0x00, 0x00, 0x00, 0x10, 0x00, 0x02, 0x00,
  0x64, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x21, 0x02, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x6f, 0x00, 0x21, 0x02, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x70, 0x00, 0x21, 0x02, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x72, 0x00, 0x21, 0x02, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x21, 0x02, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x69, 0x00, 0x21, 0x02, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x61, 0x00, 0x21, 0x02, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x21, 0x02, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x55, 0x00, 0x21, 0x02, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x5f, 0x00, 0x21, 0x02, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x35, 0x00, 0x21, 0x02, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x21, 0x02, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x57, 0x00, 0x21, 0x02, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x45, 0x00, 0x21, 0x02, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x21, 0x02, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x21, 0x02, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x20, 0x00, 0x21, 0x02, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x43, 0x00, 0x21, 0x02, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x21, 0x02, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x68, 0x00, 0x21, 0x02, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x61, 0x00, 0x21, 0x02, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x73, 0x00, 0x21, 0x02, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x21, 0x02, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x76, 0x00, 0x21, 0x02, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x65, 0x00, 0x21, 0x02, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x21, 0x02, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x21, 0x02, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0xb4, 0xfc, 0x21, 0x02, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0xd8, 0x9f, 0x21, 0x02, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x42, 0x48, 0x21, 0x02, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x05, 0xbf, 0x21, 0x02, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0xf4, 0x98, 0x21, 0x02, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0xc4, 0x18, 0x21, 0x02, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x94, 0xb3, 0x21, 0x02, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x0c, 0x7f, 0x21, 0x02, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x9b, 0x92, 0x21, 0x02, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0xf7, 0x59, 0x21, 0x02, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x75, 0xa3, 0x21, 0x02, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x37, 0xeb, 0x21, 0x02, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x98, 0xbe, 0x21, 0x02, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x5a, 0x7e, 0x21, 0x02, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x7c, 0xae, 0x21, 0x02, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0xcb, 0x87, 0x21, 0x02, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x1c, 0x77, 0x21, 0x02, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x45, 0xa9, 0x21, 0x02, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x6f, 0xbf, 0x21, 0x02, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x86, 0x6d, 0x21, 0x02, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0xbc, 0x61, 0x21, 0x02, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x18, 0xa7, 0x21, 0x02, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x5f, 0xa8, 0x21, 0x02, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x44, 0x3c, 0x21, 0x02, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x4e, 0x0d, 0x21, 0x02, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0xcf, 0xb0, 0x21, 0x02, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0xd1, 0x87, 0x21, 0x02, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x48, 0xc1, 0x21, 0x02, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0xa8, 0xb3, 0x21, 0x02, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x52, 0xf4, 0x21, 0x02, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x62, 0x3e, 0x21, 0x02, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0xb6, 0x7f, 0x21, 0x02, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0xee, 0x43, 0x21, 0x02, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0xc1, 0x85, 0x21, 0x02, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x8a, 0x80, 0x21, 0x02, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0xe1, 0x1e, 0x21, 0x02, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x5b, 0xdf, 0x21, 0x02, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x98, 0xe0, 0x21, 0x02, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x85, 0x8b, 0x21, 0x02, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0xc9, 0xb4, 0x21, 0x02, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x60, 0xba, 0x21, 0x02, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x9b, 0x95, 0x21, 0x02, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x0f, 0x10, 0x21, 0x02, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0xc9, 0xed, 0x21, 0x02, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x72, 0xa6, 0x21, 0x02, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0xbe, 0x11, 0x21, 0x02, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x37, 0xcd, 0x21, 0x02, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0xc3, 0x40, 0x21, 0x02, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x51, 0x12, 0x21, 0x02, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0xd3, 0x25, 0x21, 0x02, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x4f, 0x72, 0x21, 0x02, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x33, 0xd7, 0x21, 0x02, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0xfb, 0x70, 0x21, 0x02, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0xdc, 0xd2, 0x21, 0x02, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x1f, 0xeb, 0x21, 0x02, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0xd0, 0x98, 0x21, 0x02, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x87, 0x14, 0x21, 0x02, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0xc6, 0xb5, 0x21, 0x02, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x94, 0x74, 0x21, 0x02, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x5a, 0x50, 0x21, 0x02, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x5d, 0x43, 0x21, 0x02, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x34, 0x6a, 0x21, 0x02, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x6d, 0x30, 0x21, 0x02, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x02, 0x01, 0x21, 0x02, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0xf7, 0x37, 0x21, 0x02, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0xf1, 0x90, 0x21, 0x02, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x91, 0xf6, 0x21, 0x02, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x8e, 0x0d, 0x21, 0x02, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x54, 0x87, 0x21, 0x02, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0xb2, 0x14, 0x21, 0x02, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0xf8, 0x8d, 0x21, 0x02, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x25, 0x23, 0x21, 0x02, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x2c, 0x2f, 0x21, 0x02, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x64, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

static bool lsarlookupnames_out_check(struct torture_context *tctx, 
									 struct lsa_LookupNames *r)
{
	struct lsa_RefDomainList *domains = *(r->out.domains);
	torture_assert(tctx, r->out.domains != NULL, "domains ptr");
	torture_assert_int_equal(tctx, domains->count, 1, "domains count");
	torture_assert_int_equal(tctx, domains->max_size, 32, "domains size");
	torture_assert(tctx, domains->domains != NULL, "domains domains");
	torture_assert_str_equal(tctx, domains->domains[0].name.string, "BUILTIN", "domain name");
	/* FIXME: SID */
	torture_assert(tctx, r->out.count != NULL, "count ptr");
	torture_assert_int_equal(tctx, *r->out.count, 100, "count");

	torture_assert_int_equal(tctx, r->out.sids->count, 100, "sids count");
	torture_assert_int_equal(tctx, r->out.sids->sids[0].sid_type, 4, "sid type");
	torture_assert_int_equal(tctx, r->out.sids->sids[0].rid, 0x221, "sid rid");
	torture_assert_int_equal(tctx, r->out.sids->sids[0].sid_index, 0, "sid index");
	return true;
}

static const uint8_t lsarlookupsids_in_data[] = {
  0x00, 0x00, 0x00, 0x00, 0x2a, 0xab, 0xb8, 0x84, 0x36, 0xc6, 0xed, 0x4f,
  0x83, 0x16, 0x04, 0xe8, 0x63, 0x15, 0xeb, 0x84, 0x64, 0x00, 0x00, 0x00,
  0x01, 0x00, 0x00, 0x00, 0x64, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00,
  0x03, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x06, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00,
  0x09, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x00, 0x00, 0x0b, 0x00, 0x00, 0x00,
  0x0c, 0x00, 0x00, 0x00, 0x0d, 0x00, 0x00, 0x00, 0x0e, 0x00, 0x00, 0x00,
  0x0f, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x11, 0x00, 0x00, 0x00,
  0x12, 0x00, 0x00, 0x00, 0x13, 0x00, 0x00, 0x00, 0x14, 0x00, 0x00, 0x00,
  0x15, 0x00, 0x00, 0x00, 0x16, 0x00, 0x00, 0x00, 0x17, 0x00, 0x00, 0x00,
  0x18, 0x00, 0x00, 0x00, 0x19, 0x00, 0x00, 0x00, 0x1a, 0x00, 0x00, 0x00,
  0x1b, 0x00, 0x00, 0x00, 0x1c, 0x00, 0x00, 0x00, 0x1d, 0x00, 0x00, 0x00,
  0x1e, 0x00, 0x00, 0x00, 0x1f, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00,
  0x21, 0x00, 0x00, 0x00, 0x22, 0x00, 0x00, 0x00, 0x23, 0x00, 0x00, 0x00,
  0x24, 0x00, 0x00, 0x00, 0x25, 0x00, 0x00, 0x00, 0x26, 0x00, 0x00, 0x00,
  0x27, 0x00, 0x00, 0x00, 0x28, 0x00, 0x00, 0x00, 0x29, 0x00, 0x00, 0x00,
  0x2a, 0x00, 0x00, 0x00, 0x2b, 0x00, 0x00, 0x00, 0x2c, 0x00, 0x00, 0x00,
  0x2d, 0x00, 0x00, 0x00, 0x2e, 0x00, 0x00, 0x00, 0x2f, 0x00, 0x00, 0x00,
  0x30, 0x00, 0x00, 0x00, 0x31, 0x00, 0x00, 0x00, 0x32, 0x00, 0x00, 0x00,
  0x33, 0x00, 0x00, 0x00, 0x34, 0x00, 0x00, 0x00, 0x35, 0x00, 0x00, 0x00,
  0x36, 0x00, 0x00, 0x00, 0x37, 0x00, 0x00, 0x00, 0x38, 0x00, 0x00, 0x00,
  0x39, 0x00, 0x00, 0x00, 0x3a, 0x00, 0x00, 0x00, 0x3b, 0x00, 0x00, 0x00,
  0x3c, 0x00, 0x00, 0x00, 0x3d, 0x00, 0x00, 0x00, 0x3e, 0x00, 0x00, 0x00,
  0x3f, 0x00, 0x00, 0x00, 0x40, 0x00, 0x00, 0x00, 0x41, 0x00, 0x00, 0x00,
  0x42, 0x00, 0x00, 0x00, 0x43, 0x00, 0x00, 0x00, 0x44, 0x00, 0x00, 0x00,
  0x45, 0x00, 0x00, 0x00, 0x46, 0x00, 0x00, 0x00, 0x47, 0x00, 0x00, 0x00,
  0x48, 0x00, 0x00, 0x00, 0x49, 0x00, 0x00, 0x00, 0x4a, 0x00, 0x00, 0x00,
  0x4b, 0x00, 0x00, 0x00, 0x4c, 0x00, 0x00, 0x00, 0x4d, 0x00, 0x00, 0x00,
  0x4e, 0x00, 0x00, 0x00, 0x4f, 0x00, 0x00, 0x00, 0x50, 0x00, 0x00, 0x00,
  0x51, 0x00, 0x00, 0x00, 0x52, 0x00, 0x00, 0x00, 0x53, 0x00, 0x00, 0x00,
  0x54, 0x00, 0x00, 0x00, 0x55, 0x00, 0x00, 0x00, 0x56, 0x00, 0x00, 0x00,
  0x57, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x59, 0x00, 0x00, 0x00,
  0x5a, 0x00, 0x00, 0x00, 0x5b, 0x00, 0x00, 0x00, 0x5c, 0x00, 0x00, 0x00,
  0x5d, 0x00, 0x00, 0x00, 0x5e, 0x00, 0x00, 0x00, 0x5f, 0x00, 0x00, 0x00,
  0x60, 0x00, 0x00, 0x00, 0x61, 0x00, 0x00, 0x00, 0x62, 0x00, 0x00, 0x00,
  0x63, 0x00, 0x00, 0x00, 0x64, 0x00, 0x00, 0x00, 0x65, 0x00, 0x00, 0x00,
  0x02, 0x00, 0x00, 0x00, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05,
  0x20, 0x00, 0x00, 0x00, 0x21, 0x02, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00,
  0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x20, 0x00, 0x00, 0x00,
  0x21, 0x02, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x01, 0x02, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x05, 0x20, 0x00, 0x00, 0x00, 0x21, 0x02, 0x00, 0x00,
  0x02, 0x00, 0x00, 0x00, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05,
  0x20, 0x00, 0x00, 0x00, 0x21, 0x02, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00,
  0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x20, 0x00, 0x00, 0x00,
  0x21, 0x02, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x01, 0x02, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x05, 0x20, 0x00, 0x00, 0x00, 0x21, 0x02, 0x00, 0x00,
  0x02, 0x00, 0x00, 0x00, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05,
  0x20, 0x00, 0x00, 0x00, 0x21, 0x02, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00,
  0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x20, 0x00, 0x00, 0x00,
  0x21, 0x02, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x01, 0x02, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x05, 0x20, 0x00, 0x00, 0x00, 0x21, 0x02, 0x00, 0x00,
  0x02, 0x00, 0x00, 0x00, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05,
  0x20, 0x00, 0x00, 0x00, 0x21, 0x02, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00,
  0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x20, 0x00, 0x00, 0x00,
  0x21, 0x02, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x01, 0x02, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x05, 0x20, 0x00, 0x00, 0x00, 0x21, 0x02, 0x00, 0x00,
  0x02, 0x00, 0x00, 0x00, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05,
  0x20, 0x00, 0x00, 0x00, 0x21, 0x02, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00,
  0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x20, 0x00, 0x00, 0x00,
  0x21, 0x02, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x01, 0x02, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x05, 0x20, 0x00, 0x00, 0x00, 0x21, 0x02, 0x00, 0x00,
  0x02, 0x00, 0x00, 0x00, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05,
  0x20, 0x00, 0x00, 0x00, 0x21, 0x02, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00,
  0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x20, 0x00, 0x00, 0x00,
  0x21, 0x02, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x01, 0x02, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x05, 0x20, 0x00, 0x00, 0x00, 0x21, 0x02, 0x00, 0x00,
  0x02, 0x00, 0x00, 0x00, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05,
  0x20, 0x00, 0x00, 0x00, 0x21, 0x02, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00,
  0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x20, 0x00, 0x00, 0x00,
  0x21, 0x02, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x01, 0x02, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x05, 0x20, 0x00, 0x00, 0x00, 0x21, 0x02, 0x00, 0x00,
  0x02, 0x00, 0x00, 0x00, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05,
  0x20, 0x00, 0x00, 0x00, 0x21, 0x02, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00,
  0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x20, 0x00, 0x00, 0x00,
  0x21, 0x02, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x01, 0x02, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x05, 0x20, 0x00, 0x00, 0x00, 0x21, 0x02, 0x00, 0x00,
  0x02, 0x00, 0x00, 0x00, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05,
  0x20, 0x00, 0x00, 0x00, 0x21, 0x02, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00,
  0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x20, 0x00, 0x00, 0x00,
  0x21, 0x02, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x01, 0x02, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x05, 0x20, 0x00, 0x00, 0x00, 0x21, 0x02, 0x00, 0x00,
  0x02, 0x00, 0x00, 0x00, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05,
  0x20, 0x00, 0x00, 0x00, 0x21, 0x02, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00,
  0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x20, 0x00, 0x00, 0x00,
  0x21, 0x02, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x01, 0x02, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x05, 0x20, 0x00, 0x00, 0x00, 0x21, 0x02, 0x00, 0x00,
  0x02, 0x00, 0x00, 0x00, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05,
  0x20, 0x00, 0x00, 0x00, 0x21, 0x02, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00,
  0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x20, 0x00, 0x00, 0x00,
  0x21, 0x02, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x01, 0x02, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x05, 0x20, 0x00, 0x00, 0x00, 0x21, 0x02, 0x00, 0x00,
  0x02, 0x00, 0x00, 0x00, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05,
  0x20, 0x00, 0x00, 0x00, 0x21, 0x02, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00,
  0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x20, 0x00, 0x00, 0x00,
  0x21, 0x02, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x01, 0x02, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x05, 0x20, 0x00, 0x00, 0x00, 0x21, 0x02, 0x00, 0x00,
  0x02, 0x00, 0x00, 0x00, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05,
  0x20, 0x00, 0x00, 0x00, 0x21, 0x02, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00,
  0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x20, 0x00, 0x00, 0x00,
  0x21, 0x02, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x01, 0x02, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x05, 0x20, 0x00, 0x00, 0x00, 0x21, 0x02, 0x00, 0x00,
  0x02, 0x00, 0x00, 0x00, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05,
  0x20, 0x00, 0x00, 0x00, 0x21, 0x02, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00,
  0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x20, 0x00, 0x00, 0x00,
  0x21, 0x02, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x01, 0x02, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x05, 0x20, 0x00, 0x00, 0x00, 0x21, 0x02, 0x00, 0x00,
  0x02, 0x00, 0x00, 0x00, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05,
  0x20, 0x00, 0x00, 0x00, 0x21, 0x02, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00,
  0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x20, 0x00, 0x00, 0x00,
  0x21, 0x02, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x01, 0x02, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x05, 0x20, 0x00, 0x00, 0x00, 0x21, 0x02, 0x00, 0x00,
  0x02, 0x00, 0x00, 0x00, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05,
  0x20, 0x00, 0x00, 0x00, 0x21, 0x02, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00,
  0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x20, 0x00, 0x00, 0x00,
  0x21, 0x02, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x01, 0x02, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x05, 0x20, 0x00, 0x00, 0x00, 0x21, 0x02, 0x00, 0x00,
  0x02, 0x00, 0x00, 0x00, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05,
  0x20, 0x00, 0x00, 0x00, 0x21, 0x02, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00,
  0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x20, 0x00, 0x00, 0x00,
  0x21, 0x02, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x01, 0x02, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x05, 0x20, 0x00, 0x00, 0x00, 0x21, 0x02, 0x00, 0x00,
  0x02, 0x00, 0x00, 0x00, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05,
  0x20, 0x00, 0x00, 0x00, 0x21, 0x02, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00,
  0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x20, 0x00, 0x00, 0x00,
  0x21, 0x02, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x01, 0x02, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x05, 0x20, 0x00, 0x00, 0x00, 0x21, 0x02, 0x00, 0x00,
  0x02, 0x00, 0x00, 0x00, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05,
  0x20, 0x00, 0x00, 0x00, 0x21, 0x02, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00,
  0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x20, 0x00, 0x00, 0x00,
  0x21, 0x02, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x01, 0x02, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x05, 0x20, 0x00, 0x00, 0x00, 0x21, 0x02, 0x00, 0x00,
  0x02, 0x00, 0x00, 0x00, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05,
  0x20, 0x00, 0x00, 0x00, 0x21, 0x02, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00,
  0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x20, 0x00, 0x00, 0x00,
  0x21, 0x02, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x01, 0x02, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x05, 0x20, 0x00, 0x00, 0x00, 0x21, 0x02, 0x00, 0x00,
  0x02, 0x00, 0x00, 0x00, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05,
  0x20, 0x00, 0x00, 0x00, 0x21, 0x02, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00,
  0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x20, 0x00, 0x00, 0x00,
  0x21, 0x02, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x01, 0x02, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x05, 0x20, 0x00, 0x00, 0x00, 0x21, 0x02, 0x00, 0x00,
  0x02, 0x00, 0x00, 0x00, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05,
  0x20, 0x00, 0x00, 0x00, 0x21, 0x02, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00,
  0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x20, 0x00, 0x00, 0x00,
  0x21, 0x02, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x01, 0x02, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x05, 0x20, 0x00, 0x00, 0x00, 0x21, 0x02, 0x00, 0x00,
  0x02, 0x00, 0x00, 0x00, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05,
  0x20, 0x00, 0x00, 0x00, 0x21, 0x02, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00,
  0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x20, 0x00, 0x00, 0x00,
  0x21, 0x02, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x01, 0x02, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x05, 0x20, 0x00, 0x00, 0x00, 0x21, 0x02, 0x00, 0x00,
  0x02, 0x00, 0x00, 0x00, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05,
  0x20, 0x00, 0x00, 0x00, 0x21, 0x02, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00,
  0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x20, 0x00, 0x00, 0x00,
  0x21, 0x02, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x01, 0x02, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x05, 0x20, 0x00, 0x00, 0x00, 0x21, 0x02, 0x00, 0x00,
  0x02, 0x00, 0x00, 0x00, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05,
  0x20, 0x00, 0x00, 0x00, 0x21, 0x02, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00,
  0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x20, 0x00, 0x00, 0x00,
  0x21, 0x02, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x01, 0x02, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x05, 0x20, 0x00, 0x00, 0x00, 0x21, 0x02, 0x00, 0x00,
  0x02, 0x00, 0x00, 0x00, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05,
  0x20, 0x00, 0x00, 0x00, 0x21, 0x02, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00,
  0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x20, 0x00, 0x00, 0x00,
  0x21, 0x02, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x01, 0x02, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x05, 0x20, 0x00, 0x00, 0x00, 0x21, 0x02, 0x00, 0x00,
  0x02, 0x00, 0x00, 0x00, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05,
  0x20, 0x00, 0x00, 0x00, 0x21, 0x02, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00,
  0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x20, 0x00, 0x00, 0x00,
  0x21, 0x02, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x01, 0x02, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x05, 0x20, 0x00, 0x00, 0x00, 0x21, 0x02, 0x00, 0x00,
  0x02, 0x00, 0x00, 0x00, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05,
  0x20, 0x00, 0x00, 0x00, 0x21, 0x02, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00,
  0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x20, 0x00, 0x00, 0x00,
  0x21, 0x02, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x01, 0x02, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x05, 0x20, 0x00, 0x00, 0x00, 0x21, 0x02, 0x00, 0x00,
  0x02, 0x00, 0x00, 0x00, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05,
  0x20, 0x00, 0x00, 0x00, 0x21, 0x02, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00,
  0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x20, 0x00, 0x00, 0x00,
  0x21, 0x02, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x01, 0x02, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x05, 0x20, 0x00, 0x00, 0x00, 0x21, 0x02, 0x00, 0x00,
  0x02, 0x00, 0x00, 0x00, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05,
  0x20, 0x00, 0x00, 0x00, 0x21, 0x02, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00,
  0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x20, 0x00, 0x00, 0x00,
  0x21, 0x02, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x01, 0x02, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x05, 0x20, 0x00, 0x00, 0x00, 0x21, 0x02, 0x00, 0x00,
  0x02, 0x00, 0x00, 0x00, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05,
  0x20, 0x00, 0x00, 0x00, 0x21, 0x02, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00,
  0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x20, 0x00, 0x00, 0x00,
  0x21, 0x02, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x01, 0x02, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x05, 0x20, 0x00, 0x00, 0x00, 0x21, 0x02, 0x00, 0x00,
  0x02, 0x00, 0x00, 0x00, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05,
  0x20, 0x00, 0x00, 0x00, 0x21, 0x02, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00,
  0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x20, 0x00, 0x00, 0x00,
  0x21, 0x02, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x01, 0x02, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x05, 0x20, 0x00, 0x00, 0x00, 0x21, 0x02, 0x00, 0x00,
  0x02, 0x00, 0x00, 0x00, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05,
  0x20, 0x00, 0x00, 0x00, 0x21, 0x02, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00,
  0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x20, 0x00, 0x00, 0x00,
  0x21, 0x02, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x01, 0x02, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x05, 0x20, 0x00, 0x00, 0x00, 0x21, 0x02, 0x00, 0x00,
  0x02, 0x00, 0x00, 0x00, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05,
  0x20, 0x00, 0x00, 0x00, 0x21, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

static bool lsarlookupsids_in_check(struct torture_context *tctx, 
									 struct lsa_LookupSids *r)
{
	/* FIXME: Handle */
	torture_assert_int_equal(tctx, r->in.sids->num_sids, 100, "num sids");
	torture_assert(tctx, r->in.sids->sids != NULL, "sids sids");
	torture_assert_int_equal(tctx, r->in.names->count, 0, "names count");
	torture_assert(tctx, r->in.names->names == NULL, "names names");
	torture_assert_int_equal(tctx, r->in.level, 1, "level");
	torture_assert(tctx, r->in.count != NULL, "count ptr");
	torture_assert_int_equal(tctx, *r->in.count, 0, "count");

	return true;
}

static const uint8_t lsarlookupsids_out_data[] = {
  0x00, 0x00, 0x02, 0x00, 0x01, 0x00, 0x00, 0x00, 0x04, 0x00, 0x02, 0x00,
  0x20, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x0e, 0x00, 0x10, 0x00,
  0x08, 0x00, 0x02, 0x00, 0x0c, 0x00, 0x02, 0x00, 0x08, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 0x42, 0x00, 0x55, 0x00,
  0x49, 0x00, 0x4c, 0x00, 0x54, 0x00, 0x49, 0x00, 0x4e, 0x00, 0x00, 0x00,
  0x01, 0x00, 0x00, 0x00, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05,
  0x20, 0x00, 0x00, 0x00, 0x64, 0x00, 0x00, 0x00, 0x10, 0x00, 0x02, 0x00,
  0x64, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0a, 0x00,
  0x14, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00,
  0x0a, 0x00, 0x0a, 0x00, 0x18, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x04, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0a, 0x00, 0x1c, 0x00, 0x02, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0a, 0x00,
  0x20, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00,
  0x0a, 0x00, 0x0a, 0x00, 0x24, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x04, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0a, 0x00, 0x28, 0x00, 0x02, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0a, 0x00,
  0x2c, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00,
  0x0a, 0x00, 0x0a, 0x00, 0x30, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x04, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0a, 0x00, 0x34, 0x00, 0x02, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0a, 0x00,
  0x38, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00,
  0x0a, 0x00, 0x0a, 0x00, 0x3c, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x04, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0a, 0x00, 0x40, 0x00, 0x02, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0a, 0x00,
  0x44, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00,
  0x0a, 0x00, 0x0a, 0x00, 0x48, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x04, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0a, 0x00, 0x4c, 0x00, 0x02, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0a, 0x00,
  0x50, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00,
  0x0a, 0x00, 0x0a, 0x00, 0x54, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x04, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0a, 0x00, 0x58, 0x00, 0x02, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0a, 0x00,
  0x5c, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00,
  0x0a, 0x00, 0x0a, 0x00, 0x60, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x04, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0a, 0x00, 0x64, 0x00, 0x02, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0a, 0x00,
  0x68, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00,
  0x0a, 0x00, 0x0a, 0x00, 0x6c, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x04, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0a, 0x00, 0x70, 0x00, 0x02, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0a, 0x00,
  0x74, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00,
  0x0a, 0x00, 0x0a, 0x00, 0x78, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x04, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0a, 0x00, 0x7c, 0x00, 0x02, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0a, 0x00,
  0x80, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00,
  0x0a, 0x00, 0x0a, 0x00, 0x84, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x04, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0a, 0x00, 0x88, 0x00, 0x02, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0a, 0x00,
  0x8c, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00,
  0x0a, 0x00, 0x0a, 0x00, 0x90, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x04, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0a, 0x00, 0x94, 0x00, 0x02, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0a, 0x00,
  0x98, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00,
  0x0a, 0x00, 0x0a, 0x00, 0x9c, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x04, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0a, 0x00, 0xa0, 0x00, 0x02, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0a, 0x00,
  0xa4, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00,
  0x0a, 0x00, 0x0a, 0x00, 0xa8, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x04, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0a, 0x00, 0xac, 0x00, 0x02, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0a, 0x00,
  0xb0, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0xde, 0x36,
  0x0a, 0x00, 0x0a, 0x00, 0xb4, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x04, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0a, 0x00, 0xb8, 0x00, 0x02, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0a, 0x00,
  0xbc, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00,
  0x0a, 0x00, 0x0a, 0x00, 0xc0, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x04, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0a, 0x00, 0xc4, 0x00, 0x02, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0a, 0x00,
  0xc8, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00,
  0x0a, 0x00, 0x0a, 0x00, 0xcc, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x04, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0a, 0x00, 0xd0, 0x00, 0x02, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0a, 0x00,
  0xd4, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00,
  0x0a, 0x00, 0x0a, 0x00, 0xd8, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x04, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0a, 0x00, 0xdc, 0x00, 0x02, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0a, 0x00,
  0xe0, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00,
  0x0a, 0x00, 0x0a, 0x00, 0xe4, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x04, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0a, 0x00, 0xe8, 0x00, 0x02, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0a, 0x00,
  0xec, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00,
  0x0a, 0x00, 0x0a, 0x00, 0xf0, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x04, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0a, 0x00, 0xf4, 0x00, 0x02, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0a, 0x00,
  0xf8, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00,
  0x0a, 0x00, 0x0a, 0x00, 0xfc, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x04, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0a, 0x00, 0x00, 0x01, 0x02, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0a, 0x00,
  0x04, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00,
  0x0a, 0x00, 0x0a, 0x00, 0x08, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x04, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0a, 0x00, 0x0c, 0x01, 0x02, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0a, 0x00,
  0x10, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00,
  0x0a, 0x00, 0x0a, 0x00, 0x14, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x04, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0a, 0x00, 0x18, 0x01, 0x02, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0a, 0x00,
  0x1c, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00,
  0x0a, 0x00, 0x0a, 0x00, 0x20, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x04, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0a, 0x00, 0x24, 0x01, 0x02, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0a, 0x00,
  0x28, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00,
  0x0a, 0x00, 0x0a, 0x00, 0x2c, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x04, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0a, 0x00, 0x30, 0x01, 0x02, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0a, 0x00,
  0x34, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00,
  0x0a, 0x00, 0x0a, 0x00, 0x38, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x04, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0a, 0x00, 0x3c, 0x01, 0x02, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0a, 0x00,
  0x40, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00,
  0x0a, 0x00, 0x0a, 0x00, 0x44, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x04, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0a, 0x00, 0x48, 0x01, 0x02, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0a, 0x00,
  0x4c, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00,
  0x0a, 0x00, 0x0a, 0x00, 0x50, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x04, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0a, 0x00, 0x54, 0x01, 0x02, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0a, 0x00,
  0x58, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00,
  0x0a, 0x00, 0x0a, 0x00, 0x5c, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x04, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0a, 0x00, 0x60, 0x01, 0x02, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0a, 0x00,
  0x64, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00,
  0x0a, 0x00, 0x0a, 0x00, 0x68, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x04, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0a, 0x00, 0x6c, 0x01, 0x02, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0a, 0x00,
  0x70, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00,
  0x0a, 0x00, 0x0a, 0x00, 0x74, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x04, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0a, 0x00, 0x78, 0x01, 0x02, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0a, 0x00,
  0x7c, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00,
  0x0a, 0x00, 0x0a, 0x00, 0x80, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x04, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0a, 0x00, 0x84, 0x01, 0x02, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0a, 0x00,
  0x88, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00,
  0x0a, 0x00, 0x0a, 0x00, 0x8c, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x04, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0a, 0x00, 0x90, 0x01, 0x02, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0a, 0x00,
  0x94, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00,
  0x0a, 0x00, 0x0a, 0x00, 0x98, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x04, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0a, 0x00, 0x9c, 0x01, 0x02, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0a, 0x00,
  0xa0, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x55, 0x00, 0x73, 0x00,
  0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x55, 0x00, 0x73, 0x00,
  0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x55, 0x00, 0x73, 0x00,
  0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x55, 0x00, 0x73, 0x00,
  0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x55, 0x00, 0x73, 0x00,
  0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x55, 0x00, 0x73, 0x00,
  0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x55, 0x00, 0x73, 0x00,
  0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x55, 0x00, 0x73, 0x00,
  0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x55, 0x00, 0x73, 0x00,
  0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x55, 0x00, 0x73, 0x00,
  0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x55, 0x00, 0x73, 0x00,
  0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x55, 0x00, 0x73, 0x00,
  0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x55, 0x00, 0x73, 0x00,
  0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x55, 0x00, 0x73, 0x00,
  0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x55, 0x00, 0x73, 0x00,
  0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x55, 0x00, 0x73, 0x00,
  0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x55, 0x00, 0x73, 0x00,
  0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x55, 0x00, 0x73, 0x00,
  0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x55, 0x00, 0x73, 0x00,
  0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x55, 0x00, 0x73, 0x00,
  0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x55, 0x00, 0x73, 0x00,
  0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x55, 0x00, 0x73, 0x00,
  0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x55, 0x00, 0x73, 0x00,
  0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x55, 0x00, 0x73, 0x00,
  0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x55, 0x00, 0x73, 0x00,
  0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x55, 0x00, 0x73, 0x00,
  0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x55, 0x00, 0x73, 0x00,
  0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x55, 0x00, 0x73, 0x00,
  0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x55, 0x00, 0x73, 0x00,
  0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x55, 0x00, 0x73, 0x00,
  0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x55, 0x00, 0x73, 0x00,
  0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x55, 0x00, 0x73, 0x00,
  0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x55, 0x00, 0x73, 0x00,
  0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x55, 0x00, 0x73, 0x00,
  0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x55, 0x00, 0x73, 0x00,
  0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x55, 0x00, 0x73, 0x00,
  0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x55, 0x00, 0x73, 0x00,
  0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x55, 0x00, 0x73, 0x00,
  0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x55, 0x00, 0x73, 0x00,
  0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x55, 0x00, 0x73, 0x00,
  0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x55, 0x00, 0x73, 0x00,
  0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x55, 0x00, 0x73, 0x00,
  0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x55, 0x00, 0x73, 0x00,
  0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x55, 0x00, 0x73, 0x00,
  0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x55, 0x00, 0x73, 0x00,
  0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x55, 0x00, 0x73, 0x00,
  0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x55, 0x00, 0x73, 0x00,
  0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x55, 0x00, 0x73, 0x00,
  0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x55, 0x00, 0x73, 0x00,
  0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x55, 0x00, 0x73, 0x00,
  0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x55, 0x00, 0x73, 0x00,
  0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x55, 0x00, 0x73, 0x00,
  0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x55, 0x00, 0x73, 0x00,
  0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x55, 0x00, 0x73, 0x00,
  0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x55, 0x00, 0x73, 0x00,
  0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x55, 0x00, 0x73, 0x00,
  0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x55, 0x00, 0x73, 0x00,
  0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x55, 0x00, 0x73, 0x00,
  0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x55, 0x00, 0x73, 0x00,
  0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x55, 0x00, 0x73, 0x00,
  0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x55, 0x00, 0x73, 0x00,
  0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x55, 0x00, 0x73, 0x00,
  0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x55, 0x00, 0x73, 0x00,
  0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x55, 0x00, 0x73, 0x00,
  0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x55, 0x00, 0x73, 0x00,
  0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x55, 0x00, 0x73, 0x00,
  0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x55, 0x00, 0x73, 0x00,
  0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x55, 0x00, 0x73, 0x00,
  0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x55, 0x00, 0x73, 0x00,
  0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x55, 0x00, 0x73, 0x00,
  0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x55, 0x00, 0x73, 0x00,
  0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x55, 0x00, 0x73, 0x00,
  0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x55, 0x00, 0x73, 0x00,
  0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x55, 0x00, 0x73, 0x00,
  0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x55, 0x00, 0x73, 0x00,
  0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x55, 0x00, 0x73, 0x00,
  0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x55, 0x00, 0x73, 0x00,
  0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x55, 0x00, 0x73, 0x00,
  0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x55, 0x00, 0x73, 0x00,
  0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x55, 0x00, 0x73, 0x00,
  0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x55, 0x00, 0x73, 0x00,
  0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x55, 0x00, 0x73, 0x00,
  0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x55, 0x00, 0x73, 0x00,
  0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x55, 0x00, 0x73, 0x00,
  0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x55, 0x00, 0x73, 0x00,
  0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x55, 0x00, 0x73, 0x00,
  0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x55, 0x00, 0x73, 0x00,
  0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x55, 0x00, 0x73, 0x00,
  0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x55, 0x00, 0x73, 0x00,
  0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x55, 0x00, 0x73, 0x00,
  0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x55, 0x00, 0x73, 0x00,
  0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x55, 0x00, 0x73, 0x00,
  0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x55, 0x00, 0x73, 0x00,
  0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x55, 0x00, 0x73, 0x00,
  0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x55, 0x00, 0x73, 0x00,
  0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x55, 0x00, 0x73, 0x00,
  0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x55, 0x00, 0x73, 0x00,
  0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x55, 0x00, 0x73, 0x00,
  0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x55, 0x00, 0x73, 0x00,
  0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x55, 0x00, 0x73, 0x00,
  0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00, 0x64, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00
};

static bool lsarlookupsids_out_check(struct torture_context *tctx, 
									 struct lsa_LookupSids *r)
{
	struct lsa_RefDomainList *domains = *(r->out.domains);
	torture_assert(tctx, domains != NULL, "domains");
	torture_assert_int_equal(tctx, domains->count, 1, "domains count");
	torture_assert_int_equal(tctx, domains->max_size, 32, "domains size");
	torture_assert(tctx, domains->domains != NULL, "domains domains");
	torture_assert_str_equal(tctx, domains->domains[0].name.string, "BUILTIN", "name");
	torture_assert_ntstatus_ok(tctx, r->out.result, "return code");
	return true;
}

static const uint8_t lsaropenpolicy2_in_data[] = {
  0x01, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x02, 0x00, 0x00, 0x00, 0x5c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x02, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x02
};

static bool lsaropenpolicy2_in_check(struct torture_context *tctx, 
									 struct lsa_OpenPolicy2 *r)
{
	torture_assert_str_equal(tctx, r->in.system_name, "\\", "system name");
	torture_assert(tctx, r->in.attr != NULL, "attr ptr");
	torture_assert_int_equal(tctx, r->in.attr->len, 0, "attr len");
	torture_assert(tctx, r->in.attr->root_dir == NULL, "attr root");
	torture_assert(tctx, r->in.attr->object_name == NULL, "attr object name");
	torture_assert_int_equal(tctx, r->in.attr->attributes, 0, "attr attributes");
	torture_assert_int_equal(tctx, r->in.access_mask, 0x02000000, "access mask");
	return true;
}

static const uint8_t lsaropenpolicy2_out_data[] = {
  0x00, 0x00, 0x00, 0x00, 0x2a, 0xab, 0xb8, 0x84, 0x36, 0xc6, 0xed, 0x4f,
  0x83, 0x16, 0x04, 0xe8, 0x63, 0x15, 0xeb, 0x84, 0x00, 0x00, 0x00, 0x00
};

static bool lsaropenpolicy2_out_check(struct torture_context *tctx, 
									 struct lsa_OpenPolicy2 *r)
{
	/* FIXME: handle */
	torture_assert_ntstatus_ok(tctx, r->out.result, "return code");
	return true;
}

static const uint8_t lsaropenpolicy_in_data[] = {
  0x01, 0x00, 0x00, 0x00, 0x5c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x02, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x02
};

static bool lsaropenpolicy_in_check(struct torture_context *tctx, 
									 struct lsa_OpenPolicy *r)
{
	torture_assert(tctx, r->in.system_name != NULL, "system name");
	torture_assert(tctx, r->in.attr != NULL, "attr ptr");
	torture_assert_int_equal(tctx, r->in.attr->len, 0, "attr len");
	torture_assert(tctx, r->in.attr->root_dir == NULL, "attr root");
	torture_assert(tctx, r->in.attr->object_name == NULL, "attr object name");
	torture_assert_int_equal(tctx, r->in.attr->attributes, 0, "attr attributes");
	torture_assert_int_equal(tctx, r->in.access_mask, 0x02000000, "access mask");

	return true;
}

static const uint8_t lsaropenpolicy_out_data[] = {
  0x00, 0x00, 0x00, 0x00, 0x2a, 0xbd, 0xf1, 0xb1, 0xe8, 0xd7, 0xf8, 0x43,
  0xae, 0xb4, 0x5f, 0x9b, 0xbe, 0x06, 0xf2, 0xce, 0x00, 0x00, 0x00, 0x00
};

static bool lsaropenpolicy_out_check(struct torture_context *tctx, 
									 struct lsa_OpenPolicy *r)
{
	/* FIXME: Handle */
	torture_assert_ntstatus_ok(tctx, r->out.result, "return code");
	return true;
}

static const uint8_t lsarcreateaccount_in_data[] = {
  0x00, 0x00, 0x00, 0x00, 0x2a, 0xab, 0xb8, 0x84, 0x36, 0xc6, 0xed, 0x4f,
  0x83, 0x16, 0x04, 0xe8, 0x63, 0x15, 0xeb, 0x84, 0x03, 0x00, 0x00, 0x00,
  0x01, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0xb4, 0x71, 0xbc, 0x00,
  0xe1, 0x10, 0x00, 0x00, 0x26, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02
};

static bool lsarcreateaccount_in_check(struct torture_context *tctx, 
									 struct lsa_CreateAccount *r)
{
	/* FIXME: Handle */	
	/* FIXME: Sid */
	torture_assert_int_equal(tctx, r->in.access_mask, 0x2000000, "access mask");
	return true;
}

static const uint8_t lsarcreateaccount_out_data[] = {
  0x00, 0x00, 0x00, 0x00, 0x3d, 0x28, 0x64, 0xd8, 0x9a, 0xad, 0x2f, 0x48,
  0xa5, 0x37, 0x26, 0xb4, 0x17, 0x71, 0x3a, 0xe8, 0x00, 0x00, 0x00, 0x00
};

static bool lsarcreateaccount_out_check(struct torture_context *tctx, 
									 struct lsa_CreateAccount *r)
{
	/* FIXME */	
	torture_assert_ntstatus_ok(tctx, r->out.result, "return code");
	return true;
}

static const uint8_t lsardelete_in_data[] = {
  0x00, 0x00, 0x00, 0x00, 0x3d, 0x28, 0x64, 0xd8, 0x9a, 0xad, 0x2f, 0x48,
  0xa5, 0x37, 0x26, 0xb4, 0x17, 0x71, 0x3a, 0xe8
};

static bool lsardelete_in_check(struct torture_context *tctx, 
									 struct lsa_Delete *r)
{
	/* FIXME: Handle */
	return true;
}

static const uint8_t lsardelete_out_data[] = {
  0x00, 0x00, 0x00, 0x00
};

static bool lsardelete_out_check(struct torture_context *tctx, 
									 struct lsa_Delete *r)
{
	torture_assert_ntstatus_ok(tctx, r->out.result, "return code");
	return true;
}

static const uint8_t lsarcreatesecret_in_data[] = {
  0x00, 0x00, 0x00, 0x00, 0x2a, 0xab, 0xb8, 0x84, 0x36, 0xc6, 0xed, 0x4f,
  0x83, 0x16, 0x04, 0xe8, 0x63, 0x15, 0xeb, 0x84, 0x2e, 0x00, 0x2e, 0x00,
  0x01, 0x00, 0x00, 0x00, 0x17, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x17, 0x00, 0x00, 0x00, 0x74, 0x00, 0x6f, 0x00, 0x72, 0x00, 0x74, 0x00,
  0x75, 0x00, 0x72, 0x00, 0x65, 0x00, 0x73, 0x00, 0x65, 0x00, 0x63, 0x00,
  0x72, 0x00, 0x65, 0x00, 0x74, 0x00, 0x2d, 0x00, 0x38, 0x00, 0x35, 0x00,
  0x32, 0x00, 0x38, 0x00, 0x38, 0x00, 0x35, 0x00, 0x33, 0x00, 0x35, 0x00,
  0x36, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02
};

static bool lsarcreatesecret_in_check(struct torture_context *tctx,
									struct lsa_CreateSecret *r)
{
	/* FIXME: Handle */
	torture_assert_str_equal(tctx, r->in.name.string, "torturesecret-852885356", "name");
	torture_assert_int_equal(tctx, r->in.access_mask, 0x2000000, "access mask");
	return true;
}

static const uint8_t lsarcreatesecret_out_data[] = {
  0x00, 0x00, 0x00, 0x00, 0x08, 0x2d, 0x02, 0x15, 0x3d, 0xfb, 0x27, 0x4c,
  0xaa, 0x22, 0x13, 0x79, 0x20, 0x14, 0x7f, 0xad, 0x00, 0x00, 0x00, 0x00
};

static bool lsarcreatesecret_out_check(struct torture_context *tctx,
									struct lsa_CreateSecret *r)
{
	/* FIXME: Handle */
	torture_assert_ntstatus_ok(tctx, r->out.result, "return code");
	return true;
}

static const uint8_t lsaropensecret_in_data[] = {
  0x00, 0x00, 0x00, 0x00, 0x2a, 0xab, 0xb8, 0x84, 0x36, 0xc6, 0xed, 0x4f,
  0x83, 0x16, 0x04, 0xe8, 0x63, 0x15, 0xeb, 0x84, 0x2e, 0x00, 0x2e, 0x00,
  0x01, 0x00, 0x00, 0x00, 0x17, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x17, 0x00, 0x00, 0x00, 0x74, 0x00, 0x6f, 0x00, 0x72, 0x00, 0x74, 0x00,
  0x75, 0x00, 0x72, 0x00, 0x65, 0x00, 0x73, 0x00, 0x65, 0x00, 0x63, 0x00,
  0x72, 0x00, 0x65, 0x00, 0x74, 0x00, 0x2d, 0x00, 0x38, 0x00, 0x35, 0x00,
  0x32, 0x00, 0x38, 0x00, 0x38, 0x00, 0x35, 0x00, 0x33, 0x00, 0x35, 0x00,
  0x36, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02
};

static bool lsaropensecret_in_check(struct torture_context *tctx,
									struct lsa_OpenSecret *r)
{
	/* FIXME: Handle */
	torture_assert_str_equal(tctx, r->in.name.string, "torturesecret-852885356", "name");
	torture_assert_int_equal(tctx, r->in.access_mask, 0x2000000, "access mask");
	return true;
}

static const uint8_t lsaropensecret_out_data[] = {
  0x00, 0x00, 0x00, 0x00, 0x9f, 0x6d, 0x07, 0x35, 0x08, 0x43, 0xd9, 0x4b,
  0xbb, 0xcf, 0xeb, 0x4a, 0x91, 0xd2, 0x24, 0xe7, 0x00, 0x00, 0x00, 0x00
};

static bool lsaropensecret_out_check(struct torture_context *tctx,
									struct lsa_OpenSecret *r)
{
	/* FIXME: Handle */
	torture_assert_ntstatus_ok(tctx, r->out.result, "return code");
	return true;
}

static const uint8_t lsarsetsecret_in_data[] = {
  0x00, 0x00, 0x00, 0x00, 0x08, 0x2d, 0x02, 0x15, 0x3d, 0xfb, 0x27, 0x4c,
  0xaa, 0x22, 0x13, 0x79, 0x20, 0x14, 0x7f, 0xad, 0x01, 0x00, 0x00, 0x00,
  0x20, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00,
  0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00,
  0xda, 0xb8, 0x19, 0xb6, 0xaf, 0x8c, 0x0f, 0xf5, 0x28, 0x81, 0xca, 0xce,
  0xcc, 0x8b, 0x70, 0xc4, 0x8a, 0xe5, 0xad, 0x51, 0x1a, 0x0e, 0xb5, 0xaa,
  0x3b, 0xdc, 0xbf, 0x38, 0x30, 0xb4, 0x18, 0x6d, 0x00, 0x00, 0x00, 0x00
};

static bool lsarsetsecret_in_check(struct torture_context *tctx,
									struct lsa_SetSecret *r)
{
	/* FIXME: Handle */
	torture_assert(tctx, r->in.new_val != NULL, "new val ptr");
	torture_assert(tctx, r->in.old_val == NULL, "old val ptr");
	torture_assert_int_equal(tctx, r->in.new_val->length, 32, "new val len");
	torture_assert_int_equal(tctx, r->in.new_val->size, 32, "new val size");
	return true;
}


static const uint8_t lsarsetsecret_out_data[] = {
  0x00, 0x00, 0x00, 0x00
};

static bool lsarsetsecret_out_check(struct torture_context *tctx,
									struct lsa_SetSecret *r)
{
	torture_assert_ntstatus_ok(tctx, r->out.result, "return code");
	return true;
}

static const uint8_t lsarquerysecret_in_data[] = {
  0x00, 0x00, 0x00, 0x00, 0x08, 0x2d, 0x02, 0x15, 0x3d, 0xfb, 0x27, 0x4c,
  0xaa, 0x22, 0x13, 0x79, 0x20, 0x14, 0x7f, 0xad, 0x01, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

static bool lsarquerysecret_in_check(struct torture_context *tctx,
									struct lsa_QuerySecret *r)
{
	/* FIXME: Handle */
	torture_assert(tctx, r->in.new_val != NULL, "new val ptr");
	torture_assert(tctx, r->in.new_val->buf == NULL, "new val ptr ptr");
	torture_assert(tctx, r->in.new_mtime != NULL, "new mtime ptr");
	/* FIXME: *new_mtime */
	torture_assert(tctx, r->in.old_val == NULL, "old val ptr");
	torture_assert(tctx, r->in.old_mtime == NULL, "old mtime ptr");
	return true;
}


static const uint8_t lsarquerysecret_out_data[] = {
  0x00, 0x00, 0x02, 0x00, 0x04, 0x00, 0x02, 0x00, 0x20, 0x00, 0x00, 0x00,
  0x20, 0x00, 0x00, 0x00, 0x08, 0x00, 0x02, 0x00, 0x20, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 0xda, 0xb8, 0x19, 0xb6,
  0xaf, 0x8c, 0x0f, 0xf5, 0x28, 0x81, 0xca, 0xce, 0xcc, 0x8b, 0x70, 0xc4,
  0x8a, 0xe5, 0xad, 0x51, 0x1a, 0x0e, 0xb5, 0xaa, 0x3b, 0xdc, 0xbf, 0x38,
  0x30, 0xb4, 0x18, 0x6d, 0x0c, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x90, 0x3e, 0x63, 0x7e, 0xee, 0xf1, 0xc4, 0x01, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

static bool lsarquerysecret_out_check(struct torture_context *tctx,
									struct lsa_QuerySecret *r)
{
	/* FIXME: Handle */
	torture_assert(tctx, r->out.new_val != NULL, "new val ptr");
	torture_assert(tctx, r->out.new_mtime != NULL, "new mtime ptr");
	/* FIXME: *new_mtime */
	torture_assert(tctx, r->out.old_val == NULL, "old val ptr");
	torture_assert(tctx, r->out.old_mtime == NULL, "old mtime ptr");
	return true;
}

static const uint8_t lsarcreatetrusteddomain_in_data[] = {
  0x00, 0x00, 0x00, 0x00, 0x2a, 0xab, 0xb8, 0x84, 0x36, 0xc6, 0xed, 0x4f,
  0x83, 0x16, 0x04, 0xe8, 0x63, 0x15, 0xeb, 0x84, 0x1a, 0x00, 0x1a, 0x00,
  0x01, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x0d, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x0d, 0x00, 0x00, 0x00, 0x74, 0x00, 0x6f, 0x00,
  0x72, 0x00, 0x74, 0x00, 0x75, 0x00, 0x72, 0x00, 0x65, 0x00, 0x64, 0x00,
  0x6f, 0x00, 0x6d, 0x00, 0x61, 0x00, 0x69, 0x00, 0x6e, 0x00, 0x00, 0x00,
  0x04, 0x00, 0x00, 0x00, 0x01, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05,
  0x15, 0x00, 0x00, 0x00, 0x76, 0x7c, 0x01, 0x00, 0x93, 0xcb, 0x05, 0x00,
  0x39, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02
};

static bool lsarcreatetrusteddomain_in_check(struct torture_context *tctx, 
										   struct lsa_CreateTrustedDomain *r)
{
	/* FIXME: Handle */
	torture_assert_str_equal(tctx, r->in.info->name.string, "torturedomain", "name");
	torture_assert(tctx, r->in.info->sid != NULL, "sid");
	torture_assert_int_equal(tctx, r->in.access_mask, 0x2000000, "access mask");
	return true;
}

static const uint8_t lsarcreatetrusteddomain_out_data[] = {
  0x00, 0x00, 0x00, 0x00, 0xb5, 0x23, 0x36, 0x5f, 0x33, 0x92, 0x41, 0x4c,
  0x9a, 0x73, 0x7d, 0x6a, 0x23, 0x14, 0x62, 0x56, 0x00, 0x00, 0x00, 0x00
};

static bool lsarcreatetrusteddomain_out_check(struct torture_context *tctx, 
										   struct lsa_CreateTrustedDomain *r)
{
	/* FIXME: Handle */
	torture_assert_ntstatus_ok(tctx, r->out.result, "return code");
	return true;
}

static const uint8_t lsarenumerateaccounts_in_data[] = {
  0x00, 0x00, 0x00, 0x00, 0x2a, 0xab, 0xb8, 0x84, 0x36, 0xc6, 0xed, 0x4f,
  0x83, 0x16, 0x04, 0xe8, 0x63, 0x15, 0xeb, 0x84, 0x00, 0x00, 0x00, 0x00,
  0x64, 0x00, 0x00, 0x00
};

static bool lsarenumerateaccounts_in_check(struct torture_context *tctx, 
										   struct lsa_EnumAccounts *r)
{
	/* FIXME: handle */
	torture_assert(tctx, r->in.resume_handle != NULL, "resume handle ptr");
	torture_assert_int_equal(tctx, *r->in.resume_handle, 0, "resume handle");
	torture_assert_int_equal(tctx, r->in.num_entries, 100, "num entries");
	return true;
}

static const uint8_t lsarenumerateaccounts_out_data[] = {
  0x07, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00,
  0x07, 0x00, 0x00, 0x00, 0x04, 0x00, 0x02, 0x00, 0x08, 0x00, 0x02, 0x00,
  0x0c, 0x00, 0x02, 0x00, 0x10, 0x00, 0x02, 0x00, 0x14, 0x00, 0x02, 0x00,
  0x18, 0x00, 0x02, 0x00, 0x1c, 0x00, 0x02, 0x00, 0x02, 0x00, 0x00, 0x00,
  0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x20, 0x00, 0x00, 0x00,
  0x24, 0x02, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x01, 0x02, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x05, 0x20, 0x00, 0x00, 0x00, 0x20, 0x02, 0x00, 0x00,
  0x05, 0x00, 0x00, 0x00, 0x01, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05,
  0x15, 0x00, 0x00, 0x00, 0x14, 0xcd, 0xfb, 0x2b, 0x07, 0x32, 0xfb, 0xb2,
  0xcc, 0x04, 0x9c, 0x4c, 0xe9, 0x03, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
  0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x14, 0x00, 0x00, 0x00,
  0x01, 0x00, 0x00, 0x00, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05,
  0x13, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x01, 0x01, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x05, 0x0b, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
  0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00
};

static bool lsarenumerateaccounts_out_check(struct torture_context *tctx, 
										   struct lsa_EnumAccounts *r)
{
	torture_assert(tctx, r->out.resume_handle != NULL, "resume handle ptr");
	torture_assert_int_equal(tctx, *r->out.resume_handle, 7, "resume handle");
	torture_assert_int_equal(tctx, r->out.sids->num_sids, 7, "num sids");
	torture_assert(tctx, r->out.sids->sids != NULL, "sids sids");
	torture_assert(tctx, r->out.sids->sids[0].sid != NULL, "sids sids");
	torture_assert_ntstatus_ok(tctx, r->out.result, "return code");
	return true;
}

static const uint8_t lsarlookupsids2_in_data[] = {
  0x00, 0x00, 0x00, 0x00, 0x2a, 0xab, 0xb8, 0x84, 0x36, 0xc6, 0xed, 0x4f,
  0x83, 0x16, 0x04, 0xe8, 0x63, 0x15, 0xeb, 0x84, 0x07, 0x00, 0x00, 0x00,
  0x01, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00,
  0x03, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x06, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00,
  0x02, 0x00, 0x00, 0x00, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05,
  0x20, 0x00, 0x00, 0x00, 0x24, 0x02, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00,
  0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x20, 0x00, 0x00, 0x00,
  0x20, 0x02, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x01, 0x05, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x05, 0x15, 0x00, 0x00, 0x00, 0x14, 0xcd, 0xfb, 0x2b,
  0x07, 0x32, 0xfb, 0xb2, 0xcc, 0x04, 0x9c, 0x4c, 0xe9, 0x03, 0x00, 0x00,
  0x01, 0x00, 0x00, 0x00, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05,
  0x14, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x01, 0x01, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x05, 0x13, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
  0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x0b, 0x00, 0x00, 0x00,
  0x01, 0x00, 0x00, 0x00, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x01, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00
};

static bool lsarlookupsids2_in_check(struct torture_context *tctx, 
									 struct lsa_LookupSids2 *r)
{
	/* FIXME: Handle */
	torture_assert_int_equal(tctx, r->in.sids->num_sids, 7, "num sids");
	torture_assert(tctx, r->in.sids->sids != NULL, "sids sids");
	torture_assert(tctx, r->in.sids->sids[0].sid != NULL, "sids sids");
	torture_assert(tctx, r->in.names != NULL, "names ptr");
	torture_assert_int_equal(tctx, r->in.names->count, 0, "names count");
	torture_assert(tctx, r->in.names->names == NULL, "names");
	torture_assert_int_equal(tctx, r->in.level, 1, "level");
	torture_assert(tctx, r->in.count != NULL, "count ptr");
	torture_assert_int_equal(tctx, *r->in.count, 7, "count");
	torture_assert_int_equal(tctx, r->in.lookup_options, 0, "unknown 1");
	torture_assert_int_equal(tctx, r->in.client_revision, 0, "unknown 2");

	return true;
}

static const uint8_t lsarlookupsids2_out_data[] = {
  0x00, 0x00, 0x02, 0x00, 0x04, 0x00, 0x00, 0x00, 0x04, 0x00, 0x02, 0x00,
  0x20, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x18, 0x00, 0x1a, 0x00,
  0x08, 0x00, 0x02, 0x00, 0x0c, 0x00, 0x02, 0x00, 0x00, 0x00, 0x02, 0x00,
  0x10, 0x00, 0x02, 0x00, 0x14, 0x00, 0x02, 0x00, 0x0e, 0x00, 0x10, 0x00,
  0x18, 0x00, 0x02, 0x00, 0x1c, 0x00, 0x02, 0x00, 0x12, 0x00, 0x14, 0x00,
  0x20, 0x00, 0x02, 0x00, 0x24, 0x00, 0x02, 0x00, 0x0d, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x0c, 0x00, 0x00, 0x00, 0x4e, 0x00, 0x54, 0x00,
  0x20, 0x00, 0x41, 0x00, 0x55, 0x00, 0x54, 0x00, 0x48, 0x00, 0x4f, 0x00,
  0x52, 0x00, 0x49, 0x00, 0x54, 0x00, 0x59, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x01, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x08, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 0x42, 0x00, 0x55, 0x00,
  0x49, 0x00, 0x4c, 0x00, 0x54, 0x00, 0x49, 0x00, 0x4e, 0x00, 0x00, 0x00,
  0x01, 0x00, 0x00, 0x00, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05,
  0x20, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x09, 0x00, 0x00, 0x00, 0x57, 0x00, 0x49, 0x00, 0x4e, 0x00, 0x32, 0x00,
  0x4b, 0x00, 0x33, 0x00, 0x44, 0x00, 0x4f, 0x00, 0x4d, 0x00, 0x00, 0x00,
  0x04, 0x00, 0x00, 0x00, 0x01, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05,
  0x15, 0x00, 0x00, 0x00, 0x14, 0xcd, 0xfb, 0x2b, 0x07, 0x32, 0xfb, 0xb2,
  0xcc, 0x04, 0x9c, 0x4c, 0x07, 0x00, 0x00, 0x00, 0x28, 0x00, 0x02, 0x00,
  0x07, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x22, 0x00, 0x22, 0x00,
  0x2c, 0x00, 0x02, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x04, 0x00, 0x00, 0x00, 0x1c, 0x00, 0x1c, 0x00, 0x30, 0x00, 0x02, 0x00,
  0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
  0x20, 0x00, 0x20, 0x00, 0x34, 0x00, 0x02, 0x00, 0x03, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x1e, 0x00, 0x20, 0x00,
  0x38, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x05, 0x00, 0x00, 0x00, 0x1a, 0x00, 0x1c, 0x00, 0x3c, 0x00, 0x02, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x12, 0x00,
  0x26, 0x00, 0x28, 0x00, 0x40, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x10, 0x00, 0x12, 0x00,
  0x44, 0x00, 0x02, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x11, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x00, 0x00, 0x00,
  0x41, 0x00, 0x63, 0x00, 0x63, 0x00, 0x6f, 0x00, 0x75, 0x00, 0x6e, 0x00,
  0x74, 0x00, 0x20, 0x00, 0x4f, 0x00, 0x70, 0x00, 0x65, 0x00, 0x72, 0x00,
  0x61, 0x00, 0x74, 0x00, 0x6f, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00,
  0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x00, 0x00, 0x00,
  0x41, 0x00, 0x64, 0x00, 0x6d, 0x00, 0x69, 0x00, 0x6e, 0x00, 0x69, 0x00,
  0x73, 0x00, 0x74, 0x00, 0x72, 0x00, 0x61, 0x00, 0x74, 0x00, 0x6f, 0x00,
  0x72, 0x00, 0x73, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x10, 0x00, 0x00, 0x00, 0x53, 0x00, 0x55, 0x00, 0x50, 0x00, 0x50, 0x00,
  0x4f, 0x00, 0x52, 0x00, 0x54, 0x00, 0x5f, 0x00, 0x33, 0x00, 0x38, 0x00,
  0x38, 0x00, 0x39, 0x00, 0x34, 0x00, 0x35, 0x00, 0x61, 0x00, 0x30, 0x00,
  0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0x00, 0x00, 0x00,
  0x4e, 0x00, 0x45, 0x00, 0x54, 0x00, 0x57, 0x00, 0x4f, 0x00, 0x52, 0x00,
  0x4b, 0x00, 0x20, 0x00, 0x53, 0x00, 0x45, 0x00, 0x52, 0x00, 0x56, 0x00,
  0x49, 0x00, 0x43, 0x00, 0x45, 0x00, 0x00, 0x00, 0x0e, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x0d, 0x00, 0x00, 0x00, 0x4c, 0x00, 0x4f, 0x00,
  0x43, 0x00, 0x41, 0x00, 0x4c, 0x00, 0x20, 0x00, 0x53, 0x00, 0x45, 0x00,
  0x52, 0x00, 0x56, 0x00, 0x49, 0x00, 0x43, 0x00, 0x45, 0x00, 0x00, 0x00,
  0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x13, 0x00, 0x00, 0x00,
  0x41, 0x00, 0x75, 0x00, 0x74, 0x00, 0x68, 0x00, 0x65, 0x00, 0x6e, 0x00,
  0x74, 0x00, 0x69, 0x00, 0x63, 0x00, 0x61, 0x00, 0x74, 0x00, 0x65, 0x00,
  0x64, 0x00, 0x20, 0x00, 0x55, 0x00, 0x73, 0x00, 0x65, 0x00, 0x72, 0x00,
  0x73, 0x00, 0x00, 0x00, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x08, 0x00, 0x00, 0x00, 0x45, 0x00, 0x76, 0x00, 0x65, 0x00, 0x72, 0x00,
  0x79, 0x00, 0x6f, 0x00, 0x6e, 0x00, 0x65, 0x00, 0x07, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00
};

static bool lsarlookupsids2_out_check(struct torture_context *tctx, 
									 struct lsa_LookupSids2 *r)
{
	struct lsa_RefDomainList *domains = *(r->out.domains);
	/* FIXME: Handle */
	torture_assert(tctx, r->out.names != NULL, "names ptr");
	torture_assert(tctx, r->out.domains != NULL, "domains ptr");
	torture_assert_int_equal(tctx, domains->count, 4, "domains count");
	torture_assert_int_equal(tctx, domains->max_size, 32, "domains size");
	torture_assert_str_equal(tctx, domains->domains[0].name.string, "NT AUTHORITY", "trust info name");
	torture_assert_int_equal(tctx, r->out.names->count, 7, "names count");
	torture_assert_str_equal(tctx, r->out.names->names[0].name.string, "Account Operators", "name str 1");
	torture_assert_str_equal(tctx, r->out.names->names[1].name.string, "Administrators", "name str 2");
	torture_assert_str_equal(tctx, r->out.names->names[2].name.string, "SUPPORT_388945a0", "name str 3");
	torture_assert(tctx, r->out.count != NULL, "count ptr");
	torture_assert_int_equal(tctx, *r->out.count, 7, "count");
	torture_assert_ntstatus_ok(tctx, r->out.result, "return code");

	return true;
}

static const uint8_t lsarlookupnames2_in_data[] = {
  0x00, 0x00, 0x00, 0x00, 0x2a, 0xab, 0xb8, 0x84, 0x36, 0xc6, 0xed, 0x4f,
  0x83, 0x16, 0x04, 0xe8, 0x63, 0x15, 0xeb, 0x84, 0x07, 0x00, 0x00, 0x00,
  0x07, 0x00, 0x00, 0x00, 0x22, 0x00, 0x22, 0x00, 0x01, 0x00, 0x00, 0x00,
  0x1c, 0x00, 0x1c, 0x00, 0x02, 0x00, 0x00, 0x00, 0x20, 0x00, 0x20, 0x00,
  0x03, 0x00, 0x00, 0x00, 0x1e, 0x00, 0x1e, 0x00, 0x04, 0x00, 0x00, 0x00,
  0x1a, 0x00, 0x1a, 0x00, 0x05, 0x00, 0x00, 0x00, 0x26, 0x00, 0x26, 0x00,
  0x06, 0x00, 0x00, 0x00, 0x10, 0x00, 0x10, 0x00, 0x07, 0x00, 0x00, 0x00,
  0x11, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x00, 0x00, 0x00,
  0x41, 0x00, 0x63, 0x00, 0x63, 0x00, 0x6f, 0x00, 0x75, 0x00, 0x6e, 0x00,
  0x74, 0x00, 0x20, 0x00, 0x4f, 0x00, 0x70, 0x00, 0x65, 0x00, 0x72, 0x00,
  0x61, 0x00, 0x74, 0x00, 0x6f, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00,
  0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x00, 0x00, 0x00,
  0x41, 0x00, 0x64, 0x00, 0x6d, 0x00, 0x69, 0x00, 0x6e, 0x00, 0x69, 0x00,
  0x73, 0x00, 0x74, 0x00, 0x72, 0x00, 0x61, 0x00, 0x74, 0x00, 0x6f, 0x00,
  0x72, 0x00, 0x73, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x10, 0x00, 0x00, 0x00, 0x53, 0x00, 0x55, 0x00, 0x50, 0x00, 0x50, 0x00,
  0x4f, 0x00, 0x52, 0x00, 0x54, 0x00, 0x5f, 0x00, 0x33, 0x00, 0x38, 0x00,
  0x38, 0x00, 0x39, 0x00, 0x34, 0x00, 0x35, 0x00, 0x61, 0x00, 0x30, 0x00,
  0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0x00, 0x00, 0x00,
  0x4e, 0x00, 0x45, 0x00, 0x54, 0x00, 0x57, 0x00, 0x4f, 0x00, 0x52, 0x00,
  0x4b, 0x00, 0x20, 0x00, 0x53, 0x00, 0x45, 0x00, 0x52, 0x00, 0x56, 0x00,
  0x49, 0x00, 0x43, 0x00, 0x45, 0x00, 0x00, 0x00, 0x0d, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x0d, 0x00, 0x00, 0x00, 0x4c, 0x00, 0x4f, 0x00,
  0x43, 0x00, 0x41, 0x00, 0x4c, 0x00, 0x20, 0x00, 0x53, 0x00, 0x45, 0x00,
  0x52, 0x00, 0x56, 0x00, 0x49, 0x00, 0x43, 0x00, 0x45, 0x00, 0x00, 0x00,
  0x13, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x13, 0x00, 0x00, 0x00,
  0x41, 0x00, 0x75, 0x00, 0x74, 0x00, 0x68, 0x00, 0x65, 0x00, 0x6e, 0x00,
  0x74, 0x00, 0x69, 0x00, 0x63, 0x00, 0x61, 0x00, 0x74, 0x00, 0x65, 0x00,
  0x64, 0x00, 0x20, 0x00, 0x55, 0x00, 0x73, 0x00, 0x65, 0x00, 0x72, 0x00,
  0x73, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x08, 0x00, 0x00, 0x00, 0x45, 0x00, 0x76, 0x00, 0x65, 0x00, 0x72, 0x00,
  0x79, 0x00, 0x6f, 0x00, 0x6e, 0x00, 0x65, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

static bool lsarlookupnames2_in_check(struct torture_context *tctx,
									  struct lsa_LookupNames2 *r)
{
	/* FIXME: Handle */
	torture_assert_int_equal(tctx, r->in.num_names, 7, "num names");
	torture_assert_str_equal(tctx, r->in.names[0].string, "Account Operators", 
							 "names[0]");
	torture_assert_str_equal(tctx, r->in.names[1].string, "Administrators", 
							 "names[1]");
	torture_assert_int_equal(tctx, r->in.level, 1, "level");
	torture_assert_int_equal(tctx, r->in.lookup_options, 0, "lookup_options");
	torture_assert_int_equal(tctx, r->in.client_revision, 0, "client_revision");
	torture_assert_int_equal(tctx, *r->in.count, 0, "count");
	torture_assert_int_equal(tctx, r->in.sids->count, 0, "sids count");
	torture_assert(tctx, r->in.sids->sids == NULL, "sids sids");
	return true;
}

static const uint8_t lsarlookupnames2_out_data[] = {
  0x00, 0x00, 0x02, 0x00, 0x04, 0x00, 0x00, 0x00, 0x04, 0x00, 0x02, 0x00,
  0x20, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x18, 0x00, 0x1a, 0x00,
  0x08, 0x00, 0x02, 0x00, 0x0c, 0x00, 0x02, 0x00, 0x00, 0x00, 0x02, 0x00,
  0x10, 0x00, 0x02, 0x00, 0x14, 0x00, 0x02, 0x00, 0x0e, 0x00, 0x10, 0x00,
  0x18, 0x00, 0x02, 0x00, 0x1c, 0x00, 0x02, 0x00, 0x12, 0x00, 0x14, 0x00,
  0x20, 0x00, 0x02, 0x00, 0x24, 0x00, 0x02, 0x00, 0x0d, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x0c, 0x00, 0x00, 0x00, 0x4e, 0x00, 0x54, 0x00,
  0x20, 0x00, 0x41, 0x00, 0x55, 0x00, 0x54, 0x00, 0x48, 0x00, 0x4f, 0x00,
  0x52, 0x00, 0x49, 0x00, 0x54, 0x00, 0x59, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x01, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x08, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 0x42, 0x00, 0x55, 0x00,
  0x49, 0x00, 0x4c, 0x00, 0x54, 0x00, 0x49, 0x00, 0x4e, 0x00, 0x00, 0x00,
  0x01, 0x00, 0x00, 0x00, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05,
  0x20, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x09, 0x00, 0x00, 0x00, 0x57, 0x00, 0x49, 0x00, 0x4e, 0x00, 0x32, 0x00,
  0x4b, 0x00, 0x33, 0x00, 0x44, 0x00, 0x4f, 0x00, 0x4d, 0x00, 0x00, 0x00,
  0x04, 0x00, 0x00, 0x00, 0x01, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05,
  0x15, 0x00, 0x00, 0x00, 0x14, 0xcd, 0xfb, 0x2b, 0x07, 0x32, 0xfb, 0xb2,
  0xcc, 0x04, 0x9c, 0x4c, 0x07, 0x00, 0x00, 0x00, 0x28, 0x00, 0x02, 0x00,
  0x07, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x24, 0x02, 0x00, 0x00,
  0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00,
  0x20, 0x02, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x01, 0x00, 0x00, 0x00, 0xe9, 0x03, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x02, 0x00, 0x14, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x20, 0x00,
  0x13, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x05, 0x00, 0x00, 0x00, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00
};

static bool lsarlookupnames2_out_check(struct torture_context *tctx,
									  struct lsa_LookupNames2 *r)
{
	torture_assert_int_equal(tctx, *r->out.count, 7, "count");
	torture_assert_int_equal(tctx, r->out.sids->count, 7, "sids count");
	torture_assert_ntstatus_ok(tctx, r->out.result, "return code");
	return true;
}

static const uint8_t lsarlookupnames3_in_data[] = {
  0x00, 0x00, 0x00, 0x00, 0x2a, 0xab, 0xb8, 0x84, 0x36, 0xc6, 0xed, 0x4f,
  0x83, 0x16, 0x04, 0xe8, 0x63, 0x15, 0xeb, 0x84, 0x07, 0x00, 0x00, 0x00,
  0x07, 0x00, 0x00, 0x00, 0x22, 0x00, 0x22, 0x00, 0x01, 0x00, 0x00, 0x00,
  0x1c, 0x00, 0x1c, 0x00, 0x02, 0x00, 0x00, 0x00, 0x20, 0x00, 0x20, 0x00,
  0x03, 0x00, 0x00, 0x00, 0x1e, 0x00, 0x1e, 0x00, 0x04, 0x00, 0x00, 0x00,
  0x1a, 0x00, 0x1a, 0x00, 0x05, 0x00, 0x00, 0x00, 0x26, 0x00, 0x26, 0x00,
  0x06, 0x00, 0x00, 0x00, 0x10, 0x00, 0x10, 0x00, 0x07, 0x00, 0x00, 0x00,
  0x11, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x00, 0x00, 0x00,
  0x41, 0x00, 0x63, 0x00, 0x63, 0x00, 0x6f, 0x00, 0x75, 0x00, 0x6e, 0x00,
  0x74, 0x00, 0x20, 0x00, 0x4f, 0x00, 0x70, 0x00, 0x65, 0x00, 0x72, 0x00,
  0x61, 0x00, 0x74, 0x00, 0x6f, 0x00, 0x72, 0x00, 0x73, 0x00, 0x00, 0x00,
  0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x00, 0x00, 0x00,
  0x41, 0x00, 0x64, 0x00, 0x6d, 0x00, 0x69, 0x00, 0x6e, 0x00, 0x69, 0x00,
  0x73, 0x00, 0x74, 0x00, 0x72, 0x00, 0x61, 0x00, 0x74, 0x00, 0x6f, 0x00,
  0x72, 0x00, 0x73, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x10, 0x00, 0x00, 0x00, 0x53, 0x00, 0x55, 0x00, 0x50, 0x00, 0x50, 0x00,
  0x4f, 0x00, 0x52, 0x00, 0x54, 0x00, 0x5f, 0x00, 0x33, 0x00, 0x38, 0x00,
  0x38, 0x00, 0x39, 0x00, 0x34, 0x00, 0x35, 0x00, 0x61, 0x00, 0x30, 0x00,
  0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0x00, 0x00, 0x00,
  0x4e, 0x00, 0x45, 0x00, 0x54, 0x00, 0x57, 0x00, 0x4f, 0x00, 0x52, 0x00,
  0x4b, 0x00, 0x20, 0x00, 0x53, 0x00, 0x45, 0x00, 0x52, 0x00, 0x56, 0x00,
  0x49, 0x00, 0x43, 0x00, 0x45, 0x00, 0x00, 0x00, 0x0d, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x0d, 0x00, 0x00, 0x00, 0x4c, 0x00, 0x4f, 0x00,
  0x43, 0x00, 0x41, 0x00, 0x4c, 0x00, 0x20, 0x00, 0x53, 0x00, 0x45, 0x00,
  0x52, 0x00, 0x56, 0x00, 0x49, 0x00, 0x43, 0x00, 0x45, 0x00, 0x00, 0x00,
  0x13, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x13, 0x00, 0x00, 0x00,
  0x41, 0x00, 0x75, 0x00, 0x74, 0x00, 0x68, 0x00, 0x65, 0x00, 0x6e, 0x00,
  0x74, 0x00, 0x69, 0x00, 0x63, 0x00, 0x61, 0x00, 0x74, 0x00, 0x65, 0x00,
  0x64, 0x00, 0x20, 0x00, 0x55, 0x00, 0x73, 0x00, 0x65, 0x00, 0x72, 0x00,
  0x73, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x08, 0x00, 0x00, 0x00, 0x45, 0x00, 0x76, 0x00, 0x65, 0x00, 0x72, 0x00,
  0x79, 0x00, 0x6f, 0x00, 0x6e, 0x00, 0x65, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

static bool lsarlookupnames3_in_check(struct torture_context *tctx,
									  struct lsa_LookupNames2 *r)
{
	/* FIXME: Handle */
	torture_assert_int_equal(tctx, r->in.num_names, 7, "num names");
	torture_assert_str_equal(tctx, r->in.names[0].string, "Account Operators", 
							 "names[0]");
	torture_assert_str_equal(tctx, r->in.names[1].string, "Administrators", 
							 "names[1]");
	torture_assert_int_equal(tctx, r->in.level, 1, "level");
	torture_assert_int_equal(tctx, r->in.lookup_options, 0, "lookup_options");
	torture_assert_int_equal(tctx, r->in.client_revision, 0, "client_revision");
	torture_assert_int_equal(tctx, *r->in.count, 0, "count");
	torture_assert_int_equal(tctx, r->in.sids->count, 0, "sids count");
	torture_assert(tctx, r->in.sids->sids == NULL, "sids sids");
	return true;
}

static const uint8_t lsarlookupnames3_out_data[] = {
  0x00, 0x00, 0x02, 0x00, 0x04, 0x00, 0x00, 0x00, 0x04, 0x00, 0x02, 0x00,
  0x20, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x18, 0x00, 0x1a, 0x00,
  0x08, 0x00, 0x02, 0x00, 0x0c, 0x00, 0x02, 0x00, 0x00, 0x00, 0x02, 0x00,
  0x10, 0x00, 0x02, 0x00, 0x14, 0x00, 0x02, 0x00, 0x0e, 0x00, 0x10, 0x00,
  0x18, 0x00, 0x02, 0x00, 0x1c, 0x00, 0x02, 0x00, 0x12, 0x00, 0x14, 0x00,
  0x20, 0x00, 0x02, 0x00, 0x24, 0x00, 0x02, 0x00, 0x0d, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x0c, 0x00, 0x00, 0x00, 0x4e, 0x00, 0x54, 0x00,
  0x20, 0x00, 0x41, 0x00, 0x55, 0x00, 0x54, 0x00, 0x48, 0x00, 0x4f, 0x00,
  0x52, 0x00, 0x49, 0x00, 0x54, 0x00, 0x59, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x01, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x08, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 0x42, 0x00, 0x55, 0x00,
  0x49, 0x00, 0x4c, 0x00, 0x54, 0x00, 0x49, 0x00, 0x4e, 0x00, 0x00, 0x00,
  0x01, 0x00, 0x00, 0x00, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05,
  0x20, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x09, 0x00, 0x00, 0x00, 0x57, 0x00, 0x49, 0x00, 0x4e, 0x00, 0x32, 0x00,
  0x4b, 0x00, 0x33, 0x00, 0x44, 0x00, 0x4f, 0x00, 0x4d, 0x00, 0x00, 0x00,
  0x04, 0x00, 0x00, 0x00, 0x01, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05,
  0x15, 0x00, 0x00, 0x00, 0x14, 0xcd, 0xfb, 0x2b, 0x07, 0x32, 0xfb, 0xb2,
  0xcc, 0x04, 0x9c, 0x4c, 0x07, 0x00, 0x00, 0x00, 0x28, 0x00, 0x02, 0x00,
  0x07, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x2c, 0x00, 0x02, 0x00,
  0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00,
  0x30, 0x00, 0x02, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x01, 0x00, 0x00, 0x00, 0x34, 0x00, 0x02, 0x00, 0x03, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x02, 0x00, 0x38, 0x00, 0x02, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x20, 0x00,
  0x3c, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x05, 0x00, 0x00, 0x00, 0x40, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x44, 0x00, 0x02, 0x00,
  0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00,
  0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x20, 0x00, 0x00, 0x00,
  0x24, 0x02, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x01, 0x02, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x05, 0x20, 0x00, 0x00, 0x00, 0x20, 0x02, 0x00, 0x00,
  0x05, 0x00, 0x00, 0x00, 0x01, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05,
  0x15, 0x00, 0x00, 0x00, 0x14, 0xcd, 0xfb, 0x2b, 0x07, 0x32, 0xfb, 0xb2,
  0xcc, 0x04, 0x9c, 0x4c, 0xe9, 0x03, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
  0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x14, 0x00, 0x00, 0x00,
  0x01, 0x00, 0x00, 0x00, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05,
  0x13, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x01, 0x01, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x05, 0x0b, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
  0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00,
  0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

static bool lsarlookupnames3_out_check(struct torture_context *tctx,
									  struct lsa_LookupNames3 *r)
{
	torture_assert_int_equal(tctx, *r->out.count, 7, "count");
	torture_assert_int_equal(tctx, r->out.sids->count, 7, "sids count");
	torture_assert_ntstatus_ok(tctx, r->out.result, "return code");
	return true;
}



static const uint8_t lsarlookupsids3_in_data[] = {
  0x07, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00,
  0x02, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00,
  0x05, 0x00, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00,
  0x08, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x01, 0x02, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x05, 0x20, 0x00, 0x00, 0x00, 0x24, 0x02, 0x00, 0x00,
  0x02, 0x00, 0x00, 0x00, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05,
  0x20, 0x00, 0x00, 0x00, 0x20, 0x02, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x01, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x15, 0x00, 0x00, 0x00,
  0x14, 0xcd, 0xfb, 0x2b, 0x07, 0x32, 0xfb, 0xb2, 0xcc, 0x04, 0x9c, 0x4c,
  0xe9, 0x03, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x01, 0x01, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x05, 0x14, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
  0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x13, 0x00, 0x00, 0x00,
  0x01, 0x00, 0x00, 0x00, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05,
  0x0b, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x01, 0x01, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

static bool lsarlookupsids3_in_check(struct torture_context *tctx, 
									 struct lsa_LookupSids3 *r)
{
	/* FIXME: Handle */
	torture_assert_int_equal(tctx, r->in.sids->num_sids, 7, "num sids");
	torture_assert(tctx, r->in.sids->sids != NULL, "sids sids");
	torture_assert(tctx, r->in.sids->sids[0].sid != NULL, "sids sids");
	torture_assert(tctx, r->in.names != NULL, "names ptr");
	torture_assert_int_equal(tctx, r->in.names->count, 0, "names count");
	torture_assert(tctx, r->in.names->names == NULL, "names");
	torture_assert_int_equal(tctx, r->in.level, 1, "level");
	torture_assert(tctx, r->in.count != NULL, "count ptr");
	torture_assert_int_equal(tctx, *r->in.count, 7, "count");
	torture_assert_int_equal(tctx, r->in.lookup_options, 0, "unknown 1");
	torture_assert_int_equal(tctx, r->in.client_revision, 0, "unknown 2");

	return true;
}

#if 0
static const uint8_t lsarlookupsids3_out_data[] = {
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x07, 0x00, 0x00, 0x00, 0x22, 0x00, 0x00, 0xc0
};

static bool lsarlookupsids3_out_check(struct torture_context *tctx, 
				      struct lsa_LookupSids3 *r)
{
	struct lsa_RefDomainList *domains = *(r->out.domains);
	/* FIXME: Handle */
	torture_assert(tctx, r->out.names != NULL, "names ptr");
	torture_assert(tctx, r->out.domains != NULL, "domains ptr");
	torture_assert_int_equal(tctx, domains->count, 4, "domains count");
	torture_assert_int_equal(tctx, domains->max_size, 32, "domains size");
	torture_assert_str_equal(tctx, domains->domains[0].name.string, "NT AUTHORITY", "trust info name");
	torture_assert_int_equal(tctx, r->out.names->count, 7, "names count");
	torture_assert_str_equal(tctx, r->out.names->names[0].name.string, "Account Operators", "name str 1");
	torture_assert_str_equal(tctx, r->out.names->names[1].name.string, "Administrators", "name str 2");
	torture_assert_str_equal(tctx, r->out.names->names[2].name.string, "SUPPORT_388945a0", "name str 3");
	torture_assert(tctx, r->out.count != NULL, "count ptr");
	torture_assert_int_equal(tctx, *r->out.count, 7, "count");
	torture_assert_ntstatus_ok(tctx, r->out.result, "return code");

	return true;
}
#endif

static const uint8_t lsarenumerateprivileges_in_data[] = {
  0x00, 0x00, 0x00, 0x00, 0x2a, 0xab, 0xb8, 0x84, 0x36, 0xc6, 0xed, 0x4f,
  0x83, 0x16, 0x04, 0xe8, 0x63, 0x15, 0xeb, 0x84, 0x00, 0x00, 0x00, 0x00,
  0x64, 0x00, 0x00, 0x00
};

static bool lsarenumerateprivileges_in_check(struct torture_context *tctx,
											 struct lsa_EnumPrivs *r)
{
	/* FIXME handle */
	torture_assert(tctx, r->in.resume_handle != NULL, "resume handle ptr");
	torture_assert_int_equal(tctx, *r->in.resume_handle, 0, "resume handle");
	torture_assert_int_equal(tctx, r->in.max_count, 100, "max count");
	return true;
}

static const uint8_t lsarenumerateprivileges_out_data[] = {
  0x1d, 0x00, 0x00, 0x00, 0x1d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00,
  0x1d, 0x00, 0x00, 0x00, 0x2c, 0x00, 0x2e, 0x00, 0x04, 0x00, 0x02, 0x00,
  0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3a, 0x00, 0x3c, 0x00,
  0x08, 0x00, 0x02, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x2a, 0x00, 0x2c, 0x00, 0x0c, 0x00, 0x02, 0x00, 0x04, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x30, 0x00, 0x32, 0x00, 0x10, 0x00, 0x02, 0x00,
  0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x32, 0x00, 0x34, 0x00,
  0x14, 0x00, 0x02, 0x00, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x1c, 0x00, 0x1e, 0x00, 0x18, 0x00, 0x02, 0x00, 0x07, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x26, 0x00, 0x28, 0x00, 0x1c, 0x00, 0x02, 0x00,
  0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x00, 0x32, 0x00,
  0x20, 0x00, 0x02, 0x00, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x2a, 0x00, 0x2c, 0x00, 0x24, 0x00, 0x02, 0x00, 0x0a, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x30, 0x00, 0x32, 0x00, 0x28, 0x00, 0x02, 0x00,
  0x0b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2a, 0x00, 0x2c, 0x00,
  0x2c, 0x00, 0x02, 0x00, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x3e, 0x00, 0x40, 0x00, 0x30, 0x00, 0x02, 0x00, 0x0d, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x3e, 0x00, 0x40, 0x00, 0x34, 0x00, 0x02, 0x00,
  0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x32, 0x00, 0x34, 0x00,
  0x38, 0x00, 0x02, 0x00, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x34, 0x00, 0x36, 0x00, 0x3c, 0x00, 0x02, 0x00, 0x10, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x22, 0x00, 0x24, 0x00, 0x40, 0x00, 0x02, 0x00,
  0x11, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0x00, 0x26, 0x00,
  0x44, 0x00, 0x02, 0x00, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x26, 0x00, 0x28, 0x00, 0x48, 0x00, 0x02, 0x00, 0x13, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x20, 0x00, 0x22, 0x00, 0x4c, 0x00, 0x02, 0x00,
  0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x00, 0x22, 0x00,
  0x50, 0x00, 0x02, 0x00, 0x15, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x38, 0x00, 0x3a, 0x00, 0x54, 0x00, 0x02, 0x00, 0x16, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x2e, 0x00, 0x30, 0x00, 0x58, 0x00, 0x02, 0x00,
  0x17, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x32, 0x00, 0x34, 0x00,
  0x5c, 0x00, 0x02, 0x00, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x22, 0x00, 0x24, 0x00, 0x60, 0x00, 0x02, 0x00, 0x19, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x28, 0x00, 0x2a, 0x00, 0x64, 0x00, 0x02, 0x00,
  0x1a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x36, 0x00, 0x38, 0x00,
  0x68, 0x00, 0x02, 0x00, 0x1b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x2e, 0x00, 0x30, 0x00, 0x6c, 0x00, 0x02, 0x00, 0x1c, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x2c, 0x00, 0x2e, 0x00, 0x70, 0x00, 0x02, 0x00,
  0x1d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2e, 0x00, 0x30, 0x00,
  0x74, 0x00, 0x02, 0x00, 0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x17, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x16, 0x00, 0x00, 0x00,
  0x53, 0x00, 0x65, 0x00, 0x43, 0x00, 0x72, 0x00, 0x65, 0x00, 0x61, 0x00,
  0x74, 0x00, 0x65, 0x00, 0x54, 0x00, 0x6f, 0x00, 0x6b, 0x00, 0x65, 0x00,
  0x6e, 0x00, 0x50, 0x00, 0x72, 0x00, 0x69, 0x00, 0x76, 0x00, 0x69, 0x00,
  0x6c, 0x00, 0x65, 0x00, 0x67, 0x00, 0x65, 0x00, 0x1e, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x1d, 0x00, 0x00, 0x00, 0x53, 0x00, 0x65, 0x00,
  0x41, 0x00, 0x73, 0x00, 0x73, 0x00, 0x69, 0x00, 0x67, 0x00, 0x6e, 0x00,
  0x50, 0x00, 0x72, 0x00, 0x69, 0x00, 0x6d, 0x00, 0x61, 0x00, 0x72, 0x00,
  0x79, 0x00, 0x54, 0x00, 0x6f, 0x00, 0x6b, 0x00, 0x65, 0x00, 0x6e, 0x00,
  0x50, 0x00, 0x72, 0x00, 0x69, 0x00, 0x76, 0x00, 0x69, 0x00, 0x6c, 0x00,
  0x65, 0x00, 0x67, 0x00, 0x65, 0x00, 0x00, 0x00, 0x16, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x15, 0x00, 0x00, 0x00, 0x53, 0x00, 0x65, 0x00,
  0x4c, 0x00, 0x6f, 0x00, 0x63, 0x00, 0x6b, 0x00, 0x4d, 0x00, 0x65, 0x00,
  0x6d, 0x00, 0x6f, 0x00, 0x72, 0x00, 0x79, 0x00, 0x50, 0x00, 0x72, 0x00,
  0x69, 0x00, 0x76, 0x00, 0x69, 0x00, 0x6c, 0x00, 0x65, 0x00, 0x67, 0x00,
  0x65, 0x00, 0x00, 0x00, 0x19, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x18, 0x00, 0x00, 0x00, 0x53, 0x00, 0x65, 0x00, 0x49, 0x00, 0x6e, 0x00,
  0x63, 0x00, 0x72, 0x00, 0x65, 0x00, 0x61, 0x00, 0x73, 0x00, 0x65, 0x00,
  0x51, 0x00, 0x75, 0x00, 0x6f, 0x00, 0x74, 0x00, 0x61, 0x00, 0x50, 0x00,
  0x72, 0x00, 0x69, 0x00, 0x76, 0x00, 0x69, 0x00, 0x6c, 0x00, 0x65, 0x00,
  0x67, 0x00, 0x65, 0x00, 0x1a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x19, 0x00, 0x00, 0x00, 0x53, 0x00, 0x65, 0x00, 0x4d, 0x00, 0x61, 0x00,
  0x63, 0x00, 0x68, 0x00, 0x69, 0x00, 0x6e, 0x00, 0x65, 0x00, 0x41, 0x00,
  0x63, 0x00, 0x63, 0x00, 0x6f, 0x00, 0x75, 0x00, 0x6e, 0x00, 0x74, 0x00,
  0x50, 0x00, 0x72, 0x00, 0x69, 0x00, 0x76, 0x00, 0x69, 0x00, 0x6c, 0x00,
  0x65, 0x00, 0x67, 0x00, 0x65, 0x00, 0x00, 0x00, 0x0f, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x0e, 0x00, 0x00, 0x00, 0x53, 0x00, 0x65, 0x00,
  0x54, 0x00, 0x63, 0x00, 0x62, 0x00, 0x50, 0x00, 0x72, 0x00, 0x69, 0x00,
  0x76, 0x00, 0x69, 0x00, 0x6c, 0x00, 0x65, 0x00, 0x67, 0x00, 0x65, 0x00,
  0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x13, 0x00, 0x00, 0x00,
  0x53, 0x00, 0x65, 0x00, 0x53, 0x00, 0x65, 0x00, 0x63, 0x00, 0x75, 0x00,
  0x72, 0x00, 0x69, 0x00, 0x74, 0x00, 0x79, 0x00, 0x50, 0x00, 0x72, 0x00,
  0x69, 0x00, 0x76, 0x00, 0x69, 0x00, 0x6c, 0x00, 0x65, 0x00, 0x67, 0x00,
  0x65, 0x00, 0x00, 0x00, 0x19, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x18, 0x00, 0x00, 0x00, 0x53, 0x00, 0x65, 0x00, 0x54, 0x00, 0x61, 0x00,
  0x6b, 0x00, 0x65, 0x00, 0x4f, 0x00, 0x77, 0x00, 0x6e, 0x00, 0x65, 0x00,
  0x72, 0x00, 0x73, 0x00, 0x68, 0x00, 0x69, 0x00, 0x70, 0x00, 0x50, 0x00,
  0x72, 0x00, 0x69, 0x00, 0x76, 0x00, 0x69, 0x00, 0x6c, 0x00, 0x65, 0x00,
  0x67, 0x00, 0x65, 0x00, 0x16, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x15, 0x00, 0x00, 0x00, 0x53, 0x00, 0x65, 0x00, 0x4c, 0x00, 0x6f, 0x00,
  0x61, 0x00, 0x64, 0x00, 0x44, 0x00, 0x72, 0x00, 0x69, 0x00, 0x76, 0x00,
  0x65, 0x00, 0x72, 0x00, 0x50, 0x00, 0x72, 0x00, 0x69, 0x00, 0x76, 0x00,
  0x69, 0x00, 0x6c, 0x00, 0x65, 0x00, 0x67, 0x00, 0x65, 0x00, 0x00, 0x00,
  0x19, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x00, 0x00, 0x00,
  0x53, 0x00, 0x65, 0x00, 0x53, 0x00, 0x79, 0x00, 0x73, 0x00, 0x74, 0x00,
  0x65, 0x00, 0x6d, 0x00, 0x50, 0x00, 0x72, 0x00, 0x6f, 0x00, 0x66, 0x00,
  0x69, 0x00, 0x6c, 0x00, 0x65, 0x00, 0x50, 0x00, 0x72, 0x00, 0x69, 0x00,
  0x76, 0x00, 0x69, 0x00, 0x6c, 0x00, 0x65, 0x00, 0x67, 0x00, 0x65, 0x00,
  0x16, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x15, 0x00, 0x00, 0x00,
  0x53, 0x00, 0x65, 0x00, 0x53, 0x00, 0x79, 0x00, 0x73, 0x00, 0x74, 0x00,
  0x65, 0x00, 0x6d, 0x00, 0x74, 0x00, 0x69, 0x00, 0x6d, 0x00, 0x65, 0x00,
  0x50, 0x00, 0x72, 0x00, 0x69, 0x00, 0x76, 0x00, 0x69, 0x00, 0x6c, 0x00,
  0x65, 0x00, 0x67, 0x00, 0x65, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x1f, 0x00, 0x00, 0x00, 0x53, 0x00, 0x65, 0x00,
  0x50, 0x00, 0x72, 0x00, 0x6f, 0x00, 0x66, 0x00, 0x69, 0x00, 0x6c, 0x00,
  0x65, 0x00, 0x53, 0x00, 0x69, 0x00, 0x6e, 0x00, 0x67, 0x00, 0x6c, 0x00,
  0x65, 0x00, 0x50, 0x00, 0x72, 0x00, 0x6f, 0x00, 0x63, 0x00, 0x65, 0x00,
  0x73, 0x00, 0x73, 0x00, 0x50, 0x00, 0x72, 0x00, 0x69, 0x00, 0x76, 0x00,
  0x69, 0x00, 0x6c, 0x00, 0x65, 0x00, 0x67, 0x00, 0x65, 0x00, 0x00, 0x00,
  0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x00, 0x00, 0x00,
  0x53, 0x00, 0x65, 0x00, 0x49, 0x00, 0x6e, 0x00, 0x63, 0x00, 0x72, 0x00,
  0x65, 0x00, 0x61, 0x00, 0x73, 0x00, 0x65, 0x00, 0x42, 0x00, 0x61, 0x00,
  0x73, 0x00, 0x65, 0x00, 0x50, 0x00, 0x72, 0x00, 0x69, 0x00, 0x6f, 0x00,
  0x72, 0x00, 0x69, 0x00, 0x74, 0x00, 0x79, 0x00, 0x50, 0x00, 0x72, 0x00,
  0x69, 0x00, 0x76, 0x00, 0x69, 0x00, 0x6c, 0x00, 0x65, 0x00, 0x67, 0x00,
  0x65, 0x00, 0x00, 0x00, 0x1a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x19, 0x00, 0x00, 0x00, 0x53, 0x00, 0x65, 0x00, 0x43, 0x00, 0x72, 0x00,
  0x65, 0x00, 0x61, 0x00, 0x74, 0x00, 0x65, 0x00, 0x50, 0x00, 0x61, 0x00,
  0x67, 0x00, 0x65, 0x00, 0x66, 0x00, 0x69, 0x00, 0x6c, 0x00, 0x65, 0x00,
  0x50, 0x00, 0x72, 0x00, 0x69, 0x00, 0x76, 0x00, 0x69, 0x00, 0x6c, 0x00,
  0x65, 0x00, 0x67, 0x00, 0x65, 0x00, 0x00, 0x00, 0x1b, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x1a, 0x00, 0x00, 0x00, 0x53, 0x00, 0x65, 0x00,
  0x43, 0x00, 0x72, 0x00, 0x65, 0x00, 0x61, 0x00, 0x74, 0x00, 0x65, 0x00,
  0x50, 0x00, 0x65, 0x00, 0x72, 0x00, 0x6d, 0x00, 0x61, 0x00, 0x6e, 0x00,
  0x65, 0x00, 0x6e, 0x00, 0x74, 0x00, 0x50, 0x00, 0x72, 0x00, 0x69, 0x00,
  0x76, 0x00, 0x69, 0x00, 0x6c, 0x00, 0x65, 0x00, 0x67, 0x00, 0x65, 0x00,
  0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x00, 0x00, 0x00,
  0x53, 0x00, 0x65, 0x00, 0x42, 0x00, 0x61, 0x00, 0x63, 0x00, 0x6b, 0x00,
  0x75, 0x00, 0x70, 0x00, 0x50, 0x00, 0x72, 0x00, 0x69, 0x00, 0x76, 0x00,
  0x69, 0x00, 0x6c, 0x00, 0x65, 0x00, 0x67, 0x00, 0x65, 0x00, 0x00, 0x00,
  0x13, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x00, 0x00, 0x00,
  0x53, 0x00, 0x65, 0x00, 0x52, 0x00, 0x65, 0x00, 0x73, 0x00, 0x74, 0x00,
  0x6f, 0x00, 0x72, 0x00, 0x65, 0x00, 0x50, 0x00, 0x72, 0x00, 0x69, 0x00,
  0x76, 0x00, 0x69, 0x00, 0x6c, 0x00, 0x65, 0x00, 0x67, 0x00, 0x65, 0x00,
  0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x13, 0x00, 0x00, 0x00,
  0x53, 0x00, 0x65, 0x00, 0x53, 0x00, 0x68, 0x00, 0x75, 0x00, 0x74, 0x00,
  0x64, 0x00, 0x6f, 0x00, 0x77, 0x00, 0x6e, 0x00, 0x50, 0x00, 0x72, 0x00,
  0x69, 0x00, 0x76, 0x00, 0x69, 0x00, 0x6c, 0x00, 0x65, 0x00, 0x67, 0x00,
  0x65, 0x00, 0x00, 0x00, 0x11, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x10, 0x00, 0x00, 0x00, 0x53, 0x00, 0x65, 0x00, 0x44, 0x00, 0x65, 0x00,
  0x62, 0x00, 0x75, 0x00, 0x67, 0x00, 0x50, 0x00, 0x72, 0x00, 0x69, 0x00,
  0x76, 0x00, 0x69, 0x00, 0x6c, 0x00, 0x65, 0x00, 0x67, 0x00, 0x65, 0x00,
  0x11, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00,
  0x53, 0x00, 0x65, 0x00, 0x41, 0x00, 0x75, 0x00, 0x64, 0x00, 0x69, 0x00,
  0x74, 0x00, 0x50, 0x00, 0x72, 0x00, 0x69, 0x00, 0x76, 0x00, 0x69, 0x00,
  0x6c, 0x00, 0x65, 0x00, 0x67, 0x00, 0x65, 0x00, 0x1d, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x1c, 0x00, 0x00, 0x00, 0x53, 0x00, 0x65, 0x00,
  0x53, 0x00, 0x79, 0x00, 0x73, 0x00, 0x74, 0x00, 0x65, 0x00, 0x6d, 0x00,
  0x45, 0x00, 0x6e, 0x00, 0x76, 0x00, 0x69, 0x00, 0x72, 0x00, 0x6f, 0x00,
  0x6e, 0x00, 0x6d, 0x00, 0x65, 0x00, 0x6e, 0x00, 0x74, 0x00, 0x50, 0x00,
  0x72, 0x00, 0x69, 0x00, 0x76, 0x00, 0x69, 0x00, 0x6c, 0x00, 0x65, 0x00,
  0x67, 0x00, 0x65, 0x00, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x17, 0x00, 0x00, 0x00, 0x53, 0x00, 0x65, 0x00, 0x43, 0x00, 0x68, 0x00,
  0x61, 0x00, 0x6e, 0x00, 0x67, 0x00, 0x65, 0x00, 0x4e, 0x00, 0x6f, 0x00,
  0x74, 0x00, 0x69, 0x00, 0x66, 0x00, 0x79, 0x00, 0x50, 0x00, 0x72, 0x00,
  0x69, 0x00, 0x76, 0x00, 0x69, 0x00, 0x6c, 0x00, 0x65, 0x00, 0x67, 0x00,
  0x65, 0x00, 0x00, 0x00, 0x1a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x19, 0x00, 0x00, 0x00, 0x53, 0x00, 0x65, 0x00, 0x52, 0x00, 0x65, 0x00,
  0x6d, 0x00, 0x6f, 0x00, 0x74, 0x00, 0x65, 0x00, 0x53, 0x00, 0x68, 0x00,
  0x75, 0x00, 0x74, 0x00, 0x64, 0x00, 0x6f, 0x00, 0x77, 0x00, 0x6e, 0x00,
  0x50, 0x00, 0x72, 0x00, 0x69, 0x00, 0x76, 0x00, 0x69, 0x00, 0x6c, 0x00,
  0x65, 0x00, 0x67, 0x00, 0x65, 0x00, 0x00, 0x00, 0x12, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x11, 0x00, 0x00, 0x00, 0x53, 0x00, 0x65, 0x00,
  0x55, 0x00, 0x6e, 0x00, 0x64, 0x00, 0x6f, 0x00, 0x63, 0x00, 0x6b, 0x00,
  0x50, 0x00, 0x72, 0x00, 0x69, 0x00, 0x76, 0x00, 0x69, 0x00, 0x6c, 0x00,
  0x65, 0x00, 0x67, 0x00, 0x65, 0x00, 0x00, 0x00, 0x15, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x14, 0x00, 0x00, 0x00, 0x53, 0x00, 0x65, 0x00,
  0x53, 0x00, 0x79, 0x00, 0x6e, 0x00, 0x63, 0x00, 0x41, 0x00, 0x67, 0x00,
  0x65, 0x00, 0x6e, 0x00, 0x74, 0x00, 0x50, 0x00, 0x72, 0x00, 0x69, 0x00,
  0x76, 0x00, 0x69, 0x00, 0x6c, 0x00, 0x65, 0x00, 0x67, 0x00, 0x65, 0x00,
  0x1c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1b, 0x00, 0x00, 0x00,
  0x53, 0x00, 0x65, 0x00, 0x45, 0x00, 0x6e, 0x00, 0x61, 0x00, 0x62, 0x00,
  0x6c, 0x00, 0x65, 0x00, 0x44, 0x00, 0x65, 0x00, 0x6c, 0x00, 0x65, 0x00,
  0x67, 0x00, 0x61, 0x00, 0x74, 0x00, 0x69, 0x00, 0x6f, 0x00, 0x6e, 0x00,
  0x50, 0x00, 0x72, 0x00, 0x69, 0x00, 0x76, 0x00, 0x69, 0x00, 0x6c, 0x00,
  0x65, 0x00, 0x67, 0x00, 0x65, 0x00, 0x00, 0x00, 0x18, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x17, 0x00, 0x00, 0x00, 0x53, 0x00, 0x65, 0x00,
  0x4d, 0x00, 0x61, 0x00, 0x6e, 0x00, 0x61, 0x00, 0x67, 0x00, 0x65, 0x00,
  0x56, 0x00, 0x6f, 0x00, 0x6c, 0x00, 0x75, 0x00, 0x6d, 0x00, 0x65, 0x00,
  0x50, 0x00, 0x72, 0x00, 0x69, 0x00, 0x76, 0x00, 0x69, 0x00, 0x6c, 0x00,
  0x65, 0x00, 0x67, 0x00, 0x65, 0x00, 0x00, 0x00, 0x17, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x16, 0x00, 0x00, 0x00, 0x53, 0x00, 0x65, 0x00,
  0x49, 0x00, 0x6d, 0x00, 0x70, 0x00, 0x65, 0x00, 0x72, 0x00, 0x73, 0x00,
  0x6f, 0x00, 0x6e, 0x00, 0x61, 0x00, 0x74, 0x00, 0x65, 0x00, 0x50, 0x00,
  0x72, 0x00, 0x69, 0x00, 0x76, 0x00, 0x69, 0x00, 0x6c, 0x00, 0x65, 0x00,
  0x67, 0x00, 0x65, 0x00, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x17, 0x00, 0x00, 0x00, 0x53, 0x00, 0x65, 0x00, 0x43, 0x00, 0x72, 0x00,
  0x65, 0x00, 0x61, 0x00, 0x74, 0x00, 0x65, 0x00, 0x47, 0x00, 0x6c, 0x00,
  0x6f, 0x00, 0x62, 0x00, 0x61, 0x00, 0x6c, 0x00, 0x50, 0x00, 0x72, 0x00,
  0x69, 0x00, 0x76, 0x00, 0x69, 0x00, 0x6c, 0x00, 0x65, 0x00, 0x67, 0x00,
  0x65, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

static bool lsarenumerateprivileges_out_check(struct torture_context *tctx,
											 struct lsa_EnumPrivs *r)
{
	torture_assert(tctx, r->out.resume_handle != NULL, "resume handle ptr");
	torture_assert_int_equal(tctx, *r->out.resume_handle, 29, "resume handle");
	torture_assert_str_equal(tctx, r->out.privs->privs[0].name.string, "SeCreateTokenPrivilege", "name");
	torture_assert_str_equal(tctx, r->out.privs->privs[1].name.string, "SeAssignPrimaryTokenPrivilege", "name");
	torture_assert_ntstatus_ok(tctx, r->out.result, "return code");
	return true;
}

static const uint8_t lsarsetforesttrustsinformation_in_data[] = {
  0x00, 0x00, 0x00, 0x00, 0x42, 0x3e, 0xd4, 0x20, 0x20, 0xe8, 0xa1, 0x43,
  0x96, 0x67, 0x8c, 0xd1, 0xb9, 0x48, 0xa0, 0x3d, 0x0e, 0x00, 0x10, 0x00,
  0x00, 0x00, 0x02, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x07, 0x00, 0x00, 0x00, 0x66, 0x00, 0x31, 0x00, 0x2e, 0x00, 0x74, 0x00,
  0x65, 0x00, 0x73, 0x00, 0x74, 0x00, 0x02, 0x00, 0x02, 0x00, 0x00, 0x00,
  0x04, 0x00, 0x02, 0x00, 0x02, 0x00, 0x00, 0x00, 0x08, 0x00, 0x02, 0x00,
  0x10, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x0e, 0x00, 0x10, 0x00, 0x0c, 0x00, 0x02, 0x00,
  0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00,
  0x66, 0x00, 0x31, 0x00, 0x2e, 0x00, 0x74, 0x00, 0x65, 0x00, 0x73, 0x00,
  0x74, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00,
  0x14, 0x00, 0x02, 0x00, 0x0e, 0x00, 0x10, 0x00, 0x18, 0x00, 0x02, 0x00,
  0x04, 0x00, 0x06, 0x00, 0x1c, 0x00, 0x02, 0x00, 0x04, 0x00, 0x00, 0x00,
  0x01, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x15, 0x00, 0x00, 0x00,
  0x60, 0xcc, 0x85, 0x53, 0x92, 0x64, 0x11, 0x5e, 0x37, 0xa1, 0x11, 0x65,
  0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00,
  0x66, 0x00, 0x31, 0x00, 0x2e, 0x00, 0x74, 0x00, 0x65, 0x00, 0x73, 0x00,
  0x74, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x02, 0x00, 0x00, 0x00, 0x46, 0x00, 0x31, 0x00, 0x01
};

static bool lsarsetforesttrustsinformation_in_check(struct torture_context *tctx,
                                                    struct lsa_lsaRSetForestTrustInformation *r)
{
	/* FIXME: Handle */
	torture_assert_str_equal(tctx, r->in.trusted_domain_name->string, "f1.test", "trusted domain name");
	torture_assert_int_equal(tctx, r->in.highest_record_type, 2, "highest record type");
	torture_assert(tctx, r->in.forest_trust_info != NULL, "forest trust info");
	torture_assert_int_equal(tctx, r->in.forest_trust_info->count, 2, "number fo forest trust records");
	torture_assert_int_equal(tctx, r->in.forest_trust_info->entries[0]->flags, 0, "first entry flags");
	torture_assert_int_equal(tctx, r->in.forest_trust_info->entries[0]->type, 0, "first entry type");
	torture_assert_int_equal(tctx, r->in.forest_trust_info->entries[0]->time, 0, "first entry time");
	torture_assert_str_equal(tctx, r->in.forest_trust_info->entries[0]->forest_trust_data.top_level_name.string, "f1.test", "first entry data");
	torture_assert_int_equal(tctx, r->in.forest_trust_info->entries[1]->flags, 0, "second entry flags");
	torture_assert_int_equal(tctx, r->in.forest_trust_info->entries[1]->type, 2, "second entry type");
	torture_assert_int_equal(tctx, r->in.forest_trust_info->entries[1]->time, 0, "second entry time");
	torture_assert_str_equal(tctx, r->in.forest_trust_info->entries[1]->forest_trust_data.domain_info.dns_domain_name.string, "f1.test", "second entry data");
	torture_assert_str_equal(tctx, r->in.forest_trust_info->entries[1]->forest_trust_data.domain_info.netbios_domain_name.string, "F1", "second entry data");
	torture_assert_int_equal(tctx, r->in.check_only, 1, "check only");

	torture_assert_ntstatus_ok(tctx, r->out.result, "return code");

	return true;
}

static const uint8_t lsasettrusteddomaininfobyname_in_data[] = {
  0x00, 0x00, 0x00, 0x00, 0xe2, 0xbe, 0xb5, 0xfe, 0x4a, 0xe2, 0x25, 0x43,
  0xaf, 0x37, 0x14, 0x77, 0xa5, 0xd6, 0xd9, 0x31, 0x0e, 0x00, 0x10, 0x00,
  0x00, 0x00, 0x02, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x07, 0x00, 0x00, 0x00, 0x66, 0x00, 0x31, 0x00, 0x2e, 0x00, 0x74, 0x00,
  0x65, 0x00, 0x73, 0x00, 0x74, 0x00, 0x0a, 0x00, 0x0a, 0x00, 0x00, 0x00,
  0x0e, 0x00, 0x10, 0x00, 0x04, 0x00, 0x02, 0x00, 0x04, 0x00, 0x06, 0x00,
  0x08, 0x00, 0x02, 0x00, 0x0c, 0x00, 0x02, 0x00, 0x03, 0x00, 0x00, 0x00,
  0x02, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x44, 0x02, 0x00, 0x00, 0x10, 0x00, 0x02, 0x00, 0x08, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 0x66, 0x00, 0x31, 0x00,
  0x2e, 0x00, 0x74, 0x00, 0x65, 0x00, 0x73, 0x00, 0x74, 0x00, 0x00, 0x00,
  0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00,
  0x46, 0x00, 0x31, 0x00, 0x04, 0x00, 0x00, 0x00, 0x01, 0x04, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x05, 0x15, 0x00, 0x00, 0x00, 0x60, 0xcc, 0x85, 0x53,
  0x92, 0x64, 0x11, 0x5e, 0x37, 0xa1, 0x11, 0x65, 0x44, 0x02, 0x00, 0x00,
  0x25, 0xf5, 0x9e, 0xfc, 0x2c, 0x36, 0x8e, 0x0d, 0xd8, 0x6b, 0x98, 0x14,
  0xb6, 0x78, 0xcc, 0xca, 0xb2, 0xbd, 0xa0, 0x8d, 0x59, 0xd9, 0x51, 0x90,
  0x14, 0x0e, 0x0c, 0x3f, 0xac, 0xed, 0x67, 0x98, 0xd9, 0x44, 0xe7, 0xec,
  0x72, 0xd7, 0x83, 0xba, 0x12, 0x3e, 0xcb, 0x8a, 0xaa, 0x87, 0xdb, 0xf2,
  0xf8, 0x35, 0x00, 0x9c, 0xc7, 0x76, 0x85, 0x8d, 0x04, 0x08, 0x4c, 0xa3,
  0x05, 0x4b, 0x02, 0x85, 0xcd, 0x1c, 0x83, 0xd4, 0x1e, 0xcc, 0xd8, 0xa3,
  0x32, 0x9e, 0xa5, 0x6f, 0xd8, 0x3d, 0xe2, 0xcd, 0xa1, 0x44, 0xf5, 0x03,
  0x47, 0x79, 0x22, 0xf3, 0xb4, 0x14, 0x3d, 0x6c, 0xe3, 0x98, 0x91, 0x96,
  0x89, 0x78, 0x26, 0xa1, 0x77, 0x78, 0x58, 0xa1, 0xba, 0x84, 0xb7, 0xb3,
  0x7a, 0xad, 0xcf, 0x77, 0x5c, 0x92, 0x97, 0x3a, 0x19, 0x0f, 0xfa, 0x7d,
  0x48, 0xa4, 0x11, 0x33, 0xdd, 0x51, 0xd6, 0x0c, 0x48, 0xd6, 0xd2, 0x59,
  0x83, 0x4d, 0xf6, 0x8b, 0x6b, 0x4d, 0x6a, 0x0e, 0xcc, 0x15, 0xd6, 0x1a,
  0x2f, 0x44, 0x61, 0x45, 0x8f, 0xa8, 0x1b, 0x3f, 0x2d, 0xbd, 0x3a, 0xdb,
  0xe0, 0x74, 0x44, 0x27, 0x02, 0x85, 0x02, 0xb4, 0xf9, 0x7f, 0x81, 0xcb,
  0x28, 0x27, 0x83, 0xfb, 0xa7, 0x92, 0x43, 0x70, 0x73, 0x2b, 0x89, 0xda,
  0x03, 0x83, 0x48, 0x58, 0x04, 0xba, 0x1e, 0xe2, 0x84, 0xf3, 0xa2, 0xfa,
  0x22, 0xe8, 0x5f, 0x41, 0xf3, 0xe6, 0x47, 0x92, 0x06, 0x61, 0x77, 0x31,
  0x00, 0x1b, 0x9f, 0x9b, 0x8f, 0xfd, 0x1d, 0x9e, 0xcb, 0x09, 0xd7, 0xdc,
  0x19, 0x94, 0xf4, 0x18, 0xfa, 0x96, 0x3e, 0xb3, 0xf0, 0x6b, 0x1c, 0x21,
  0xe4, 0x52, 0xb3, 0x48, 0x19, 0x5d, 0x10, 0x8e, 0xf1, 0xb5, 0x8b, 0x72,
  0x69, 0xdb, 0x60, 0x7b, 0x7c, 0xef, 0x5c, 0x16, 0x1b, 0x11, 0xf2, 0x97,
  0x2e, 0xf4, 0xd1, 0xc5, 0x13, 0x52, 0xb4, 0xc7, 0xca, 0xf8, 0xc0, 0x46,
  0x61, 0xdc, 0x9b, 0x8a, 0x5b, 0xcd, 0xf1, 0x1d, 0x7a, 0xc4, 0x0f, 0x02,
  0x0c, 0x22, 0x4f, 0x42, 0x12, 0xbb, 0xa6, 0xe2, 0xbb, 0x92, 0xda, 0xdb,
  0x12, 0xea, 0xe8, 0x61, 0xf2, 0xdd, 0x45, 0x3c, 0x35, 0x2c, 0x89, 0x92,
  0x22, 0x35, 0xb0, 0x24, 0x5b, 0xa7, 0x54, 0x58, 0xe1, 0x8c, 0xf5, 0x36,
  0x4d, 0x04, 0xdf, 0x25, 0x36, 0x48, 0x7b, 0x84, 0xc9, 0xb9, 0xc2, 0x2a,
  0xc5, 0x62, 0x06, 0xcb, 0xa1, 0xf5, 0x26, 0x05, 0xb4, 0x20, 0xcc, 0x8b,
  0xed, 0x2e, 0xa2, 0x4b, 0xa4, 0x85, 0x3e, 0x7f, 0x26, 0x25, 0x39, 0x69,
  0x2f, 0x89, 0x47, 0x7e, 0xde, 0xc7, 0xa4, 0x12, 0x01, 0xc5, 0x98, 0x01,
  0xf5, 0xae, 0x2e, 0x3e, 0xbd, 0xb7, 0x62, 0xaa, 0x57, 0x5d, 0xa0, 0x6f,
  0xac, 0xc5, 0x4e, 0x09, 0xcc, 0x87, 0x8e, 0x76, 0x93, 0xf2, 0xc6, 0x08,
  0x45, 0x88, 0x9f, 0x18, 0x9b, 0xeb, 0xa6, 0x1b, 0xf7, 0x64, 0x47, 0x73,
  0x0c, 0xb2, 0xc7, 0xc5, 0xe5, 0x62, 0x56, 0x7f, 0x0a, 0xe4, 0x79, 0xaf,
  0x7e, 0x71, 0xe6, 0x09, 0x22, 0x3d, 0x22, 0x10, 0x5c, 0x94, 0x71, 0x35,
  0xfd, 0x28, 0x20, 0x79, 0x89, 0x47, 0x5c, 0x37, 0x41, 0xd1, 0xfe, 0xee,
  0x2e, 0xd8, 0x41, 0x8e, 0x1c, 0x4d, 0x77, 0x09, 0x43, 0x6a, 0xee, 0x3c,
  0x80, 0x9b, 0xb7, 0xe7, 0x4c, 0xe8, 0x38, 0xd1, 0x6b, 0xc0, 0x03, 0x4b,
  0xbf, 0x8d, 0x19, 0x06, 0xad, 0x28, 0x22, 0xe7, 0x1a, 0x4e, 0x14, 0xa9,
  0x90, 0xba, 0xc4, 0x13, 0x8c, 0xde, 0x30, 0xfc, 0xe2, 0xb8, 0x97, 0x90,
  0x63, 0x3f, 0x30, 0xfc, 0xf5, 0x0d, 0xd2, 0xc2, 0xbe, 0xd2, 0xe3, 0x7f,
  0x52, 0x4e, 0xc5, 0x91, 0x38, 0xfc, 0xa7, 0x0d, 0xec, 0xa5, 0x4f, 0xd5,
  0x65, 0xb3, 0x51, 0x44, 0x21, 0x2a, 0x2e, 0x87, 0xe6, 0x91, 0x09, 0x8c,
  0xa5, 0x89, 0x13, 0x69, 0x01, 0x28, 0xa8, 0x64, 0x4f, 0x87, 0x0d, 0x12,
  0xe5, 0xeb, 0xce, 0xb9, 0xfa, 0xca, 0x10, 0x69, 0xa6, 0x95, 0x3b, 0x6d,
  0x6e, 0xca, 0x9e, 0x75, 0x25, 0x1c, 0xfa, 0xd6, 0x68, 0x84, 0xe0, 0x1f,
  0x35, 0x7e, 0x6e, 0xe8, 0xb7, 0x0a, 0x32, 0x9f, 0xc3, 0x31, 0x35, 0x84,
  0xa6, 0xc7, 0x5a, 0xa2, 0x0c, 0x8c, 0x07, 0x6a, 0x66, 0xd8, 0x58, 0xb1,
  0x4c, 0xb9, 0xbc, 0x46
};

static bool lsasettrusteddomaininfobyname_in_check(struct torture_context *tctx,
                                                   struct lsa_SetTrustedDomainInfoByName *r)
{
	/* FIXME: Handle */
	torture_assert_str_equal(tctx, r->in.trusted_domain->string, "f1.test", "trusted domain");
	torture_assert_int_equal(tctx, r->in.level, LSA_TRUSTED_DOMAIN_INFO_FULL_INFO_INTERNAL, "level");
	torture_assert(tctx, r->in.info != NULL, "trust info");
	torture_assert_str_equal(tctx, r->in.info->full_info_internal.info_ex.domain_name.string, "f1.test", "domain name");
	torture_assert_str_equal(tctx, r->in.info->full_info_internal.info_ex.netbios_name.string, "F1", "netbios name");
	torture_assert(tctx, r->in.info->full_info_internal.info_ex.sid != NULL, "domain sid ptr");
	torture_assert_sid_equal(tctx, r->in.info->full_info_internal.info_ex.sid, dom_sid_parse_talloc(tctx, "S-1-5-21-1401277536-1578198162-1695654199"), "domain sid");
	torture_assert_int_equal(tctx, r->in.info->full_info_internal.info_ex.trust_direction, 3, "trust direction");
	torture_assert_int_equal(tctx, r->in.info->full_info_internal.info_ex.trust_type, LSA_TRUST_TYPE_UPLEVEL, "trust type");
	torture_assert_int_equal(tctx, r->in.info->full_info_internal.info_ex.trust_attributes, 8, "trust attributes");
	torture_assert_int_equal(tctx, r->in.info->full_info_internal.posix_offset.posix_offset, 0, "posix offset");
	torture_assert_int_equal(tctx, r->in.info->full_info_internal.auth_info.auth_blob.size, 580, "auth blob size");

	torture_assert_ntstatus_ok(tctx, r->out.result, "return code");

	return true;
}

static const uint8_t lsa_lsaRQueryForestTrustInformation_in_data[] = {
	0x00, 0x00, 0x00, 0x00, 0x40, 0xfd, 0xa1, 0xb8, 0x04, 0x3a, 0xa2, 0x46,
	0xb1, 0x45, 0x5c, 0xaa, 0xf7, 0x54, 0x13, 0x9a, 0x16, 0x00, 0x16, 0x00,
	0x00, 0x00, 0x02, 0x00, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x0b, 0x00, 0x00, 0x00, 0x61, 0x00, 0x64, 0x00, 0x32, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x38, 0x00, 0x2e, 0x00, 0x74, 0x00, 0x65, 0x00, 0x73, 0x00,
	0x74, 0x00, 0x02, 0x00
};

static bool lsa_lsaRQueryForestTrustInformation_in_check(struct torture_context *tctx,
							 struct lsa_lsaRQueryForestTrustInformation *r)
{
	return true;
}

static const uint8_t lsa_lsaRQueryForestTrustInformation_out_data[] = {
	0x00, 0x00, 0x02, 0x00, 0x02, 0x00, 0x00, 0x00, 0x04, 0x00, 0x02, 0x00,
	0x02, 0x00, 0x00, 0x00, 0x08, 0x00, 0x02, 0x00, 0x10, 0x00, 0x02, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xbe, 0xd1, 0x06, 0xc6,
	0xb9, 0xba, 0xcf, 0x01, 0x00, 0x00, 0x00, 0x00, 0x16, 0x00, 0x18, 0x00,
	0x0c, 0x00, 0x02, 0x00, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x0b, 0x00, 0x00, 0x00, 0x61, 0x00, 0x64, 0x00, 0x32, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x38, 0x00, 0x2e, 0x00, 0x74, 0x00, 0x65, 0x00, 0x73, 0x00,
	0x74, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00,
	0xbe, 0xd1, 0x06, 0xc6, 0xb9, 0xba, 0xcf, 0x01, 0x02, 0x00, 0x00, 0x00,
	0x14, 0x00, 0x02, 0x00, 0x16, 0x00, 0x18, 0x00, 0x18, 0x00, 0x02, 0x00,
	0x0c, 0x00, 0x0e, 0x00, 0x1c, 0x00, 0x02, 0x00, 0x04, 0x00, 0x00, 0x00,
	0x01, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x15, 0x00, 0x00, 0x00,
	0x51, 0xd1, 0xbb, 0x42, 0xa8, 0x23, 0x83, 0xb1, 0x31, 0x59, 0xf1, 0x8d,
	0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0b, 0x00, 0x00, 0x00,
	0x61, 0x00, 0x64, 0x00, 0x32, 0x00, 0x30, 0x00, 0x30, 0x00, 0x38, 0x00,
	0x2e, 0x00, 0x74, 0x00, 0x65, 0x00, 0x73, 0x00, 0x74, 0x00, 0x00, 0x00,
	0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00,
	0x41, 0x00, 0x44, 0x00, 0x32, 0x00, 0x30, 0x00, 0x30, 0x00, 0x38, 0x00,
	0x00, 0x00, 0x00, 0x00
};

static bool lsa_lsaRQueryForestTrustInformation_out_check(struct torture_context *tctx,
							  struct lsa_lsaRQueryForestTrustInformation *r)
{
	return true;
}

struct torture_suite *ndr_lsa_suite(TALLOC_CTX *ctx)
{
	struct torture_suite *suite = torture_suite_create(ctx, "lsa");

	torture_suite_add_ndr_pull_fn_test(suite, lsa_OpenPolicy, lsaropenpolicy_in_data, NDR_IN, lsaropenpolicy_in_check);
	torture_suite_add_ndr_pull_fn_test(suite, lsa_OpenPolicy, lsaropenpolicy_out_data, NDR_OUT, lsaropenpolicy_out_check);

	torture_suite_add_ndr_pull_fn_test(suite, lsa_OpenPolicy2, lsaropenpolicy2_in_data, NDR_IN, lsaropenpolicy2_in_check);
	torture_suite_add_ndr_pull_fn_test(suite, lsa_OpenPolicy2, lsaropenpolicy2_out_data, NDR_OUT, lsaropenpolicy2_out_check);

	torture_suite_add_ndr_pull_fn_test(suite, lsa_LookupNames, lsarlookupnames_in_data, NDR_IN, lsarlookupnames_in_check);
	torture_suite_add_ndr_pull_fn_test(suite, lsa_LookupNames, lsarlookupnames_out_data, NDR_OUT, lsarlookupnames_out_check); 

	torture_suite_add_ndr_pull_fn_test(suite, lsa_LookupSids, lsarlookupsids_in_data, NDR_IN, lsarlookupsids_in_check);
	torture_suite_add_ndr_pull_fn_test(suite, lsa_LookupSids, lsarlookupsids_out_data, NDR_OUT, lsarlookupsids_out_check);

	torture_suite_add_ndr_pull_fn_test(suite, lsa_CreateAccount, lsarcreateaccount_in_data, NDR_IN, lsarcreateaccount_in_check);
	torture_suite_add_ndr_pull_fn_test(suite, lsa_CreateAccount, lsarcreateaccount_out_data, NDR_OUT, lsarcreateaccount_out_check);

	torture_suite_add_ndr_pull_fn_test(suite, lsa_Delete, lsardelete_in_data, NDR_IN, lsardelete_in_check);
	torture_suite_add_ndr_pull_fn_test(suite, lsa_Delete, lsardelete_out_data, NDR_OUT, lsardelete_out_check); 

	torture_suite_add_ndr_pull_fn_test(suite, lsa_CreateSecret, lsarcreatesecret_in_data, NDR_IN, lsarcreatesecret_in_check);
	torture_suite_add_ndr_pull_fn_test(suite, lsa_CreateSecret, lsarcreatesecret_out_data, NDR_OUT, lsarcreatesecret_out_check);

	torture_suite_add_ndr_pull_fn_test(suite, lsa_OpenSecret, lsaropensecret_in_data, NDR_IN, lsaropensecret_in_check);
	torture_suite_add_ndr_pull_fn_test(suite, lsa_OpenSecret, lsaropensecret_out_data, NDR_OUT, lsaropensecret_out_check);

	torture_suite_add_ndr_pull_fn_test(suite, lsa_SetSecret, lsarsetsecret_in_data, NDR_IN, lsarsetsecret_in_check);
	torture_suite_add_ndr_pull_fn_test(suite, lsa_SetSecret, lsarsetsecret_out_data, NDR_OUT, lsarsetsecret_out_check);

	torture_suite_add_ndr_pull_fn_test(suite, lsa_QuerySecret, lsarquerysecret_in_data, NDR_IN, lsarquerysecret_in_check);
	torture_suite_add_ndr_pull_fn_test(suite, lsa_QuerySecret, lsarquerysecret_out_data, NDR_OUT, lsarquerysecret_out_check);

	torture_suite_add_ndr_pull_fn_test(suite, lsa_CreateTrustedDomain, lsarcreatetrusteddomain_in_data, NDR_IN, lsarcreatetrusteddomain_in_check);
	torture_suite_add_ndr_pull_fn_test(suite, lsa_CreateTrustedDomain, lsarcreatetrusteddomain_out_data, NDR_OUT, lsarcreatetrusteddomain_out_check);

	torture_suite_add_ndr_pull_fn_test(suite, lsa_EnumAccounts, lsarenumerateaccounts_in_data, NDR_IN, lsarenumerateaccounts_in_check);
	torture_suite_add_ndr_pull_fn_test(suite, lsa_EnumAccounts, lsarenumerateaccounts_out_data, NDR_OUT, lsarenumerateaccounts_out_check);

	torture_suite_add_ndr_pull_fn_test(suite, lsa_LookupSids2, lsarlookupsids2_in_data, NDR_IN, lsarlookupsids2_in_check);
	torture_suite_add_ndr_pull_fn_test(suite, lsa_LookupSids2, lsarlookupsids2_out_data, NDR_OUT, lsarlookupsids2_out_check);

	torture_suite_add_ndr_pull_fn_test(suite, lsa_LookupNames2, lsarlookupnames2_in_data, NDR_IN, lsarlookupnames2_in_check);
	torture_suite_add_ndr_pull_fn_test(suite, lsa_LookupNames2, lsarlookupnames2_out_data, NDR_OUT, lsarlookupnames2_out_check);

	torture_suite_add_ndr_pull_fn_test(suite, lsa_LookupNames3, lsarlookupnames3_in_data, NDR_IN, lsarlookupnames3_in_check);
	torture_suite_add_ndr_pull_fn_test(suite, lsa_LookupNames3, lsarlookupnames3_out_data, NDR_OUT, lsarlookupnames3_out_check);

	torture_suite_add_ndr_pull_fn_test(suite, lsa_LookupSids3, lsarlookupsids3_in_data, NDR_IN, lsarlookupsids3_in_check);
	/* torture_suite_add_ndr_pull_fn_test(suite, lsa_LookupSids3, lsarlookupsids3_out_data, NDR_OUT, lsarlookupsids3_out_check); */

	torture_suite_add_ndr_pull_fn_test(suite, lsa_EnumPrivs, lsarenumerateprivileges_in_data, NDR_IN, lsarenumerateprivileges_in_check);
	torture_suite_add_ndr_pull_fn_test(suite, lsa_EnumPrivs, lsarenumerateprivileges_out_data, NDR_OUT, lsarenumerateprivileges_out_check);

	torture_suite_add_ndr_pull_fn_test(suite, lsa_lsaRSetForestTrustInformation, lsarsetforesttrustsinformation_in_data, NDR_IN, lsarsetforesttrustsinformation_in_check);

	torture_suite_add_ndr_pull_fn_test(suite, lsa_SetTrustedDomainInfoByName, lsasettrusteddomaininfobyname_in_data, NDR_IN, lsasettrusteddomaininfobyname_in_check);

	torture_suite_add_ndr_pull_fn_test(suite, lsa_lsaRQueryForestTrustInformation, lsa_lsaRQueryForestTrustInformation_in_data, NDR_IN, lsa_lsaRQueryForestTrustInformation_in_check);
	torture_suite_add_ndr_pull_fn_test(suite, lsa_lsaRQueryForestTrustInformation, lsa_lsaRQueryForestTrustInformation_out_data, NDR_OUT, lsa_lsaRQueryForestTrustInformation_out_check);

	return suite;
}
