/* CheckerboardLayout.c generated by valac 0.40.4, the Vala compiler
 * generated from CheckerboardLayout.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU LGPL (version 2.1 or later).
 * See the COPYING file in this distribution.
 */


#include <glib.h>
#include <glib-object.h>
#include <gdk/gdk.h>
#include <stdlib.h>
#include <string.h>
#include <pango/pango.h>
#include <gtk/gtk.h>
#include <cairo.h>
#include <float.h>
#include <math.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <gee.h>
#include <pango/pangocairo.h>
#include <gobject/gvaluecollector.h>


#define TYPE_CHECKERBOARD_ITEM_TEXT (checkerboard_item_text_get_type ())
#define CHECKERBOARD_ITEM_TEXT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHECKERBOARD_ITEM_TEXT, CheckerboardItemText))
#define CHECKERBOARD_ITEM_TEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHECKERBOARD_ITEM_TEXT, CheckerboardItemTextClass))
#define IS_CHECKERBOARD_ITEM_TEXT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHECKERBOARD_ITEM_TEXT))
#define IS_CHECKERBOARD_ITEM_TEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHECKERBOARD_ITEM_TEXT))
#define CHECKERBOARD_ITEM_TEXT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHECKERBOARD_ITEM_TEXT, CheckerboardItemTextClass))

typedef struct _CheckerboardItemText CheckerboardItemText;
typedef struct _CheckerboardItemTextClass CheckerboardItemTextClass;
typedef struct _CheckerboardItemTextPrivate CheckerboardItemTextPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_PAGE_WINDOW (page_window_get_type ())
#define PAGE_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PAGE_WINDOW, PageWindow))
#define PAGE_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PAGE_WINDOW, PageWindowClass))
#define IS_PAGE_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PAGE_WINDOW))
#define IS_PAGE_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PAGE_WINDOW))
#define PAGE_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PAGE_WINDOW, PageWindowClass))

typedef struct _PageWindow PageWindow;
typedef struct _PageWindowClass PageWindowClass;

#define TYPE_APP_WINDOW (app_window_get_type ())
#define APP_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_APP_WINDOW, AppWindow))
#define APP_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_APP_WINDOW, AppWindowClass))
#define IS_APP_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_APP_WINDOW))
#define IS_APP_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_APP_WINDOW))
#define APP_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_APP_WINDOW, AppWindowClass))

typedef struct _AppWindow AppWindow;
typedef struct _AppWindowClass AppWindowClass;
typedef struct _ParamSpecCheckerboardItemText ParamSpecCheckerboardItemText;

#define TYPE_DATA_OBJECT (data_object_get_type ())
#define DATA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_OBJECT, DataObject))
#define DATA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_OBJECT, DataObjectClass))
#define IS_DATA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_OBJECT))
#define IS_DATA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_OBJECT))
#define DATA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_OBJECT, DataObjectClass))

typedef struct _DataObject DataObject;
typedef struct _DataObjectClass DataObjectClass;
typedef struct _DataObjectPrivate DataObjectPrivate;

#define TYPE_ALTERATION (alteration_get_type ())
#define ALTERATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ALTERATION, Alteration))
#define ALTERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ALTERATION, AlterationClass))
#define IS_ALTERATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ALTERATION))
#define IS_ALTERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ALTERATION))
#define ALTERATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ALTERATION, AlterationClass))

typedef struct _Alteration Alteration;
typedef struct _AlterationClass AlterationClass;

#define TYPE_DATA_COLLECTION (data_collection_get_type ())
#define DATA_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_COLLECTION, DataCollection))
#define DATA_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_COLLECTION, DataCollectionClass))
#define IS_DATA_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_COLLECTION))
#define IS_DATA_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_COLLECTION))
#define DATA_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_COLLECTION, DataCollectionClass))

typedef struct _DataCollection DataCollection;
typedef struct _DataCollectionClass DataCollectionClass;

#define TYPE_DATA_VIEW (data_view_get_type ())
#define DATA_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_VIEW, DataView))
#define DATA_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_VIEW, DataViewClass))
#define IS_DATA_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_VIEW))
#define IS_DATA_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_VIEW))
#define DATA_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_VIEW, DataViewClass))

typedef struct _DataView DataView;
typedef struct _DataViewClass DataViewClass;
typedef struct _DataViewPrivate DataViewPrivate;

#define TYPE_DATA_SOURCE (data_source_get_type ())
#define DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_SOURCE, DataSource))
#define DATA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_SOURCE, DataSourceClass))
#define IS_DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_SOURCE))
#define IS_DATA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_SOURCE))
#define DATA_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_SOURCE, DataSourceClass))

typedef struct _DataSource DataSource;
typedef struct _DataSourceClass DataSourceClass;

#define TYPE_THUMBNAIL_VIEW (thumbnail_view_get_type ())
#define THUMBNAIL_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_THUMBNAIL_VIEW, ThumbnailView))
#define THUMBNAIL_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_THUMBNAIL_VIEW, ThumbnailViewClass))
#define IS_THUMBNAIL_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_THUMBNAIL_VIEW))
#define IS_THUMBNAIL_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_THUMBNAIL_VIEW))
#define THUMBNAIL_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_THUMBNAIL_VIEW, ThumbnailViewClass))

typedef struct _ThumbnailView ThumbnailView;
typedef struct _ThumbnailViewClass ThumbnailViewClass;
typedef struct _ThumbnailViewPrivate ThumbnailViewPrivate;

#define TYPE_CHECKERBOARD_ITEM (checkerboard_item_get_type ())
#define CHECKERBOARD_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHECKERBOARD_ITEM, CheckerboardItem))
#define CHECKERBOARD_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHECKERBOARD_ITEM, CheckerboardItemClass))
#define IS_CHECKERBOARD_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHECKERBOARD_ITEM))
#define IS_CHECKERBOARD_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHECKERBOARD_ITEM))
#define CHECKERBOARD_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHECKERBOARD_ITEM, CheckerboardItemClass))

typedef struct _CheckerboardItem CheckerboardItem;
typedef struct _CheckerboardItemClass CheckerboardItemClass;
typedef struct _CheckerboardItemPrivate CheckerboardItemPrivate;

#define TYPE_DIMENSIONS (dimensions_get_type ())
typedef struct _Dimensions Dimensions;

#define TYPE_TAG (tag_get_type ())
#define TAG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TAG, Tag))
#define TAG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TAG, TagClass))
#define IS_TAG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TAG))
#define IS_TAG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TAG))
#define TAG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TAG, TagClass))

typedef struct _Tag Tag;
typedef struct _TagClass TagClass;
enum  {
	CHECKERBOARD_ITEM_0_PROPERTY,
	CHECKERBOARD_ITEM_HAS_TAGS_PROPERTY,
	CHECKERBOARD_ITEM_NUM_PROPERTIES
};
static GParamSpec* checkerboard_item_properties[CHECKERBOARD_ITEM_NUM_PROPERTIES];
#define _checkerboard_item_text_unref0(var) ((var == NULL) ? NULL : (var = (checkerboard_item_text_unref (var), NULL)))

#define TYPE_THUMBNAIL_SOURCE (thumbnail_source_get_type ())
#define THUMBNAIL_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_THUMBNAIL_SOURCE, ThumbnailSource))
#define THUMBNAIL_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_THUMBNAIL_SOURCE, ThumbnailSourceClass))
#define IS_THUMBNAIL_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_THUMBNAIL_SOURCE))
#define IS_THUMBNAIL_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_THUMBNAIL_SOURCE))
#define THUMBNAIL_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_THUMBNAIL_SOURCE, ThumbnailSourceClass))

typedef struct _ThumbnailSource ThumbnailSource;
typedef struct _ThumbnailSourceClass ThumbnailSourceClass;
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define __vala_GValue_free0(var) ((var == NULL) ? NULL : (var = (_vala_GValue_free (var), NULL)))
#define _cairo_pattern_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_pattern_destroy (var), NULL)))

#define TYPE_CHECKERBOARD_LAYOUT (checkerboard_layout_get_type ())
#define CHECKERBOARD_LAYOUT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHECKERBOARD_LAYOUT, CheckerboardLayout))
#define CHECKERBOARD_LAYOUT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHECKERBOARD_LAYOUT, CheckerboardLayoutClass))
#define IS_CHECKERBOARD_LAYOUT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHECKERBOARD_LAYOUT))
#define IS_CHECKERBOARD_LAYOUT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHECKERBOARD_LAYOUT))
#define CHECKERBOARD_LAYOUT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHECKERBOARD_LAYOUT, CheckerboardLayoutClass))

typedef struct _CheckerboardLayout CheckerboardLayout;
typedef struct _CheckerboardLayoutClass CheckerboardLayoutClass;
typedef struct _CheckerboardLayoutPrivate CheckerboardLayoutPrivate;

#define TYPE_VIEW_COLLECTION (view_collection_get_type ())
#define VIEW_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_VIEW_COLLECTION, ViewCollection))
#define VIEW_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_VIEW_COLLECTION, ViewCollectionClass))
#define IS_VIEW_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_VIEW_COLLECTION))
#define IS_VIEW_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_VIEW_COLLECTION))
#define VIEW_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_VIEW_COLLECTION, ViewCollectionClass))

typedef struct _ViewCollection ViewCollection;
typedef struct _ViewCollectionClass ViewCollectionClass;

#define CHECKERBOARD_LAYOUT_TYPE_LAYOUT_ROW (checkerboard_layout_layout_row_get_type ())
#define CHECKERBOARD_LAYOUT_LAYOUT_ROW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CHECKERBOARD_LAYOUT_TYPE_LAYOUT_ROW, CheckerboardLayoutLayoutRow))
#define CHECKERBOARD_LAYOUT_LAYOUT_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CHECKERBOARD_LAYOUT_TYPE_LAYOUT_ROW, CheckerboardLayoutLayoutRowClass))
#define CHECKERBOARD_LAYOUT_IS_LAYOUT_ROW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CHECKERBOARD_LAYOUT_TYPE_LAYOUT_ROW))
#define CHECKERBOARD_LAYOUT_IS_LAYOUT_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CHECKERBOARD_LAYOUT_TYPE_LAYOUT_ROW))
#define CHECKERBOARD_LAYOUT_LAYOUT_ROW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CHECKERBOARD_LAYOUT_TYPE_LAYOUT_ROW, CheckerboardLayoutLayoutRowClass))

typedef struct _CheckerboardLayoutLayoutRow CheckerboardLayoutLayoutRow;
typedef struct _CheckerboardLayoutLayoutRowClass CheckerboardLayoutLayoutRowClass;
enum  {
	CHECKERBOARD_LAYOUT_0_PROPERTY,
	CHECKERBOARD_LAYOUT_NUM_PROPERTIES
};
static GParamSpec* checkerboard_layout_properties[CHECKERBOARD_LAYOUT_NUM_PROPERTIES];

#define TYPE_CONFIGURATION_FACADE (configuration_facade_get_type ())
#define CONFIGURATION_FACADE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CONFIGURATION_FACADE, ConfigurationFacade))
#define CONFIGURATION_FACADE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CONFIGURATION_FACADE, ConfigurationFacadeClass))
#define IS_CONFIGURATION_FACADE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CONFIGURATION_FACADE))
#define IS_CONFIGURATION_FACADE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CONFIGURATION_FACADE))
#define CONFIGURATION_FACADE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CONFIGURATION_FACADE, ConfigurationFacadeClass))

typedef struct _ConfigurationFacade ConfigurationFacade;
typedef struct _ConfigurationFacadeClass ConfigurationFacadeClass;

#define CONFIG_TYPE_FACADE (config_facade_get_type ())
#define CONFIG_FACADE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONFIG_TYPE_FACADE, ConfigFacade))
#define CONFIG_FACADE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONFIG_TYPE_FACADE, ConfigFacadeClass))
#define CONFIG_IS_FACADE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONFIG_TYPE_FACADE))
#define CONFIG_IS_FACADE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONFIG_TYPE_FACADE))
#define CONFIG_FACADE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONFIG_TYPE_FACADE, ConfigFacadeClass))

typedef struct _ConfigFacade ConfigFacade;
typedef struct _ConfigFacadeClass ConfigFacadeClass;
#define _data_collection_unref0(var) ((var == NULL) ? NULL : (var = (data_collection_unref (var), NULL)))
typedef struct _CheckerboardLayoutLayoutRowPrivate CheckerboardLayoutLayoutRowPrivate;
#define _checkerboard_layout_layout_row_unref0(var) ((var == NULL) ? NULL : (var = (checkerboard_layout_layout_row_unref (var), NULL)))

#define TYPE_LIBRARY_WINDOW (library_window_get_type ())
#define LIBRARY_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LIBRARY_WINDOW, LibraryWindow))
#define LIBRARY_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LIBRARY_WINDOW, LibraryWindowClass))
#define IS_LIBRARY_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LIBRARY_WINDOW))
#define IS_LIBRARY_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LIBRARY_WINDOW))
#define LIBRARY_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LIBRARY_WINDOW, LibraryWindowClass))

typedef struct _LibraryWindow LibraryWindow;
typedef struct _LibraryWindowClass LibraryWindowClass;

#define TYPE_COMPASS_POINT (compass_point_get_type ())

#define TYPE_BOX (box_get_type ())
typedef struct _Box Box;
typedef struct _CheckerboardLayoutParamSpecLayoutRow CheckerboardLayoutParamSpecLayoutRow;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _CheckerboardItemText {
	GTypeInstance parent_instance;
	volatile int ref_count;
	CheckerboardItemTextPrivate * priv;
	GdkRectangle allocation;
};

struct _CheckerboardItemTextClass {
	GTypeClass parent_class;
	void (*finalize) (CheckerboardItemText *self);
};

struct _CheckerboardItemTextPrivate {
	gchar* text;
	gboolean marked_up;
	PangoAlignment alignment;
	PangoLayout* layout;
	gboolean single_line;
	gint height;
};

struct _ParamSpecCheckerboardItemText {
	GParamSpec parent_instance;
};

struct _DataObject {
	GObject parent_instance;
	DataObjectPrivate * priv;
};

struct _DataObjectClass {
	GObjectClass parent_class;
	void (*notify_altered) (DataObject* self, Alteration* alteration);
	void (*notify_membership_changed) (DataObject* self, DataCollection* collection);
	void (*notify_collection_property_set) (DataObject* self, const gchar* name, GValue* old, GValue* val);
	void (*notify_collection_property_cleared) (DataObject* self, const gchar* name);
	gchar* (*get_name) (DataObject* self);
	gchar* (*to_string) (DataObject* self);
};

struct _DataView {
	DataObject parent_instance;
	DataViewPrivate * priv;
};

struct _DataViewClass {
	DataObjectClass parent_class;
	void (*notify_view_altered) (DataView* self);
	void (*notify_geometry_altered) (DataView* self);
	void (*notify_unsubscribed) (DataView* self, DataSource* source);
	void (*state_changed) (DataView* self, gboolean selected);
	void (*visibility_changed) (DataView* self, gboolean visible);
	void (*view_altered) (DataView* self);
	void (*geometry_altered) (DataView* self);
	void (*unsubscribed) (DataView* self, DataSource* source);
};

struct _ThumbnailView {
	DataView parent_instance;
	ThumbnailViewPrivate * priv;
};

struct _ThumbnailViewClass {
	DataViewClass parent_class;
	void (*notify_thumbnail_altered) (ThumbnailView* self);
	void (*thumbnail_altered) (ThumbnailView* self);
};

struct _Dimensions {
	gint width;
	gint height;
};

struct _CheckerboardItem {
	ThumbnailView parent_instance;
	CheckerboardItemPrivate * priv;
	Dimensions requisition;
	GdkRectangle allocation;
};

struct _CheckerboardItemClass {
	ThumbnailViewClass parent_class;
	void (*exposed) (CheckerboardItem* self);
	void (*unexposed) (CheckerboardItem* self);
	gboolean (*is_exposed) (CheckerboardItem* self);
	void (*paint_shadow) (CheckerboardItem* self, cairo_t* ctx, Dimensions* dimensions, GdkPoint* origin, gint radius, gfloat initial_alpha);
	void (*paint_border) (CheckerboardItem* self, cairo_t* ctx, Dimensions* object_dimensions, GdkPoint* object_origin, gint border_width);
	void (*paint_image) (CheckerboardItem* self, cairo_t* ctx, GdkPixbuf* pixbuf, GdkPoint* origin);
	GdkPixbuf* (*get_top_left_trinket) (CheckerboardItem* self, gint scale);
	GdkPixbuf* (*get_top_right_trinket) (CheckerboardItem* self, gint scale);
	GdkPixbuf* (*get_bottom_left_trinket) (CheckerboardItem* self, gint scale);
	GdkPixbuf* (*get_bottom_right_trinket) (CheckerboardItem* self, gint scale);
};

struct _CheckerboardItemPrivate {
	gboolean exposure;
	CheckerboardItemText* title;
	gboolean title_visible;
	CheckerboardItemText* comment;
	gboolean comment_visible;
	CheckerboardItemText* subtitle;
	gboolean subtitle_visible;
	gboolean is_cursor;
	PangoAlignment tag_alignment;
	GeeList* user_visible_tag_list;
	GeeCollection* tags;
	GdkPixbuf* pixbuf;
	GdkPixbuf* display_pixbuf;
	GdkPixbuf* brightened;
	Dimensions pixbuf_dim;
	gint col;
	gint row;
	gint horizontal_trinket_offset;
	gboolean _has_tags;
};

struct _CheckerboardLayout {
	GtkDrawingArea parent_instance;
	CheckerboardLayoutPrivate * priv;
};

struct _CheckerboardLayoutClass {
	GtkDrawingAreaClass parent_class;
};

struct _CheckerboardLayoutPrivate {
	ViewCollection* view;
	gchar* page_name;
	CheckerboardLayoutLayoutRow** item_rows;
	gint item_rows_length1;
	gint _item_rows_size_;
	GeeHashSet* exposed_items;
	GtkAdjustment* hadjustment;
	GtkAdjustment* vadjustment;
	gchar* message;
	GdkRGBA selected_color;
	GdkRGBA unselected_color;
	GdkRGBA border_color;
	GdkRGBA bg_color;
	GdkRectangle visible_page;
	gint last_width;
	gint columns;
	gint rows;
	GdkPoint drag_origin;
	GdkPoint drag_endpoint;
	GdkRectangle selection_band;
	gint scale;
	gboolean flow_scheduled;
	gboolean exposure_dirty;
	CheckerboardItem* anchor;
	CheckerboardItem* cursor;
	gboolean in_center_on_anchor;
	gboolean size_allocate_due_to_reflow;
	gboolean is_in_view;
	gboolean reflow_needed;
};

struct _CheckerboardLayoutLayoutRow {
	GTypeInstance parent_instance;
	volatile int ref_count;
	CheckerboardLayoutLayoutRowPrivate * priv;
	gint y;
	gint height;
	CheckerboardItem** items;
	gint items_length1;
	gint _items_size_;
};

struct _CheckerboardLayoutLayoutRowClass {
	GTypeClass parent_class;
	void (*finalize) (CheckerboardLayoutLayoutRow *self);
};

typedef enum  {
	COMPASS_POINT_NORTH,
	COMPASS_POINT_SOUTH,
	COMPASS_POINT_EAST,
	COMPASS_POINT_WEST
} CompassPoint;

struct _Box {
	gint left;
	gint top;
	gint right;
	gint bottom;
};

struct _CheckerboardLayoutParamSpecLayoutRow {
	GParamSpec parent_instance;
};


static gpointer checkerboard_item_text_parent_class = NULL;
static gint checkerboard_item_text_one_line_height;
static gint checkerboard_item_text_one_line_height = 0;
static gpointer checkerboard_item_parent_class = NULL;
static gpointer checkerboard_layout_parent_class = NULL;
static gpointer checkerboard_layout_layout_row_parent_class = NULL;

gpointer checkerboard_item_text_ref (gpointer instance);
void checkerboard_item_text_unref (gpointer instance);
GParamSpec* param_spec_checkerboard_item_text (const gchar* name,
                                               const gchar* nick,
                                               const gchar* blurb,
                                               GType object_type,
                                               GParamFlags flags);
void value_set_checkerboard_item_text (GValue* value,
                                       gpointer v_object);
void value_take_checkerboard_item_text (GValue* value,
                                        gpointer v_object);
gpointer value_get_checkerboard_item_text (const GValue* value);
GType checkerboard_item_text_get_type (void) G_GNUC_CONST;
#define CHECKERBOARD_ITEM_TEXT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_CHECKERBOARD_ITEM_TEXT, CheckerboardItemTextPrivate))
CheckerboardItemText* checkerboard_item_text_new (const gchar* text,
                                                  PangoAlignment alignment,
                                                  gboolean marked_up);
CheckerboardItemText* checkerboard_item_text_construct (GType object_type,
                                                        const gchar* text,
                                                        PangoAlignment alignment,
                                                        gboolean marked_up);
static gboolean checkerboard_item_text_is_single_line (CheckerboardItemText* self);
gboolean string_contains_char (const gchar* haystack,
                               gunichar needle);
gboolean checkerboard_item_text_is_marked_up (CheckerboardItemText* self);
gboolean checkerboard_item_text_is_set_to (CheckerboardItemText* self,
                                           const gchar* text,
                                           gboolean marked_up,
                                           PangoAlignment alignment);
gchar* checkerboard_item_text_get_text (CheckerboardItemText* self);
gint checkerboard_item_text_get_height (CheckerboardItemText* self);
static void checkerboard_item_text_update_height (CheckerboardItemText* self);
PangoLayout* checkerboard_item_text_get_pango_layout (CheckerboardItemText* self,
                                                      gint max_width);
static void checkerboard_item_text_create_pango (CheckerboardItemText* self);
void checkerboard_item_text_clear_pango_layout (CheckerboardItemText* self);
GType page_window_get_type (void) G_GNUC_CONST;
GType app_window_get_type (void) G_GNUC_CONST;
AppWindow* app_window_get_instance (void);
static void checkerboard_item_text_finalize (CheckerboardItemText * obj);
GType data_object_get_type (void) G_GNUC_CONST;
gpointer alteration_ref (gpointer instance);
void alteration_unref (gpointer instance);
GParamSpec* param_spec_alteration (const gchar* name,
                                   const gchar* nick,
                                   const gchar* blurb,
                                   GType object_type,
                                   GParamFlags flags);
void value_set_alteration (GValue* value,
                           gpointer v_object);
void value_take_alteration (GValue* value,
                            gpointer v_object);
gpointer value_get_alteration (const GValue* value);
GType alteration_get_type (void) G_GNUC_CONST;
gpointer data_collection_ref (gpointer instance);
void data_collection_unref (gpointer instance);
GParamSpec* param_spec_data_collection (const gchar* name,
                                        const gchar* nick,
                                        const gchar* blurb,
                                        GType object_type,
                                        GParamFlags flags);
void value_set_data_collection (GValue* value,
                                gpointer v_object);
void value_take_data_collection (GValue* value,
                                 gpointer v_object);
gpointer value_get_data_collection (const GValue* value);
GType data_collection_get_type (void) G_GNUC_CONST;
GType data_view_get_type (void) G_GNUC_CONST;
GType data_source_get_type (void) G_GNUC_CONST;
GType thumbnail_view_get_type (void) G_GNUC_CONST;
GType checkerboard_item_get_type (void) G_GNUC_CONST;
GType dimensions_get_type (void) G_GNUC_CONST;
Dimensions* dimensions_dup (const Dimensions* self);
void dimensions_free (Dimensions* self);
GType tag_get_type (void) G_GNUC_CONST;
#define CHECKERBOARD_ITEM_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_CHECKERBOARD_ITEM, CheckerboardItemPrivate))
void dimensions_init (Dimensions *self,
                      gint width,
                      gint height);
#define CHECKERBOARD_ITEM_PROP_SHOW_TITLES "show-titles"
#define CHECKERBOARD_ITEM_PROP_SHOW_COMMENTS "show-comments"
#define CHECKERBOARD_ITEM_PROP_SHOW_SUBTITLES "show-subtitles"
#define CHECKERBOARD_ITEM_FRAME_WIDTH 8
#define CHECKERBOARD_ITEM_LABEL_PADDING 4
#define CHECKERBOARD_ITEM_BORDER_WIDTH 1
#define CHECKERBOARD_ITEM_SHADOW_RADIUS 4
#define CHECKERBOARD_ITEM_SHADOW_INITIAL_ALPHA 0.5f
#define CHECKERBOARD_ITEM_TRINKET_SCALE 12
#define CHECKERBOARD_ITEM_TRINKET_PADDING 1
#define CHECKERBOARD_ITEM_BRIGHTEN_SHIFT 0x18
GType thumbnail_source_get_type (void) G_GNUC_CONST;
CheckerboardItem* checkerboard_item_construct (GType object_type,
                                               ThumbnailSource* source,
                                               Dimensions* initial_pixbuf_dim,
                                               const gchar* title,
                                               const gchar* comment,
                                               gboolean marked_up,
                                               PangoAlignment alignment);
ThumbnailView* thumbnail_view_new (ThumbnailSource* source);
ThumbnailView* thumbnail_view_construct (GType object_type,
                                         ThumbnailSource* source);
static gchar* checkerboard_item_real_get_name (DataObject* base);
gchar* data_object_get_name (DataObject* self);
gchar* checkerboard_item_get_title (CheckerboardItem* self);
gchar* checkerboard_item_get_comment (CheckerboardItem* self);
void checkerboard_item_set_title (CheckerboardItem* self,
                                  const gchar* text,
                                  gboolean marked_up,
                                  PangoAlignment alignment);
static void checkerboard_item_recalc_size (CheckerboardItem* self,
                                    const gchar* reason);
void data_view_notify_view_altered (DataView* self);
void checkerboard_item_translate_coordinates (CheckerboardItem* self,
                                              gint* x,
                                              gint* y);
void checkerboard_item_clear_title (CheckerboardItem* self);
static void checkerboard_item_set_title_visible (CheckerboardItem* self,
                                          gboolean visible);
void checkerboard_item_set_comment (CheckerboardItem* self,
                                    const gchar* text,
                                    gboolean marked_up,
                                    PangoAlignment alignment);
void checkerboard_item_clear_comment (CheckerboardItem* self);
static void checkerboard_item_set_comment_visible (CheckerboardItem* self,
                                            gboolean visible);
void checkerboard_item_set_tags (CheckerboardItem* self,
                                 GeeCollection* tags,
                                 PangoAlignment alignment);
static void checkerboard_item_set_has_tags (CheckerboardItem* self,
                                     gboolean value);
gboolean checkerboard_item_get_has_tags (CheckerboardItem* self);
GeeList* tag_make_user_visible_tag_list (GeeCollection* tags);
gchar* tag_make_tag_markup_string (GeeList* tags,
                                   gint highlight_index);
void checkerboard_item_clear_tags (CheckerboardItem* self);
void checkerboard_item_clear_subtitle (CheckerboardItem* self);
void checkerboard_item_highlight_user_visible_tag (CheckerboardItem* self,
                                                   gint index);
Tag* checkerboard_item_get_user_visible_tag (CheckerboardItem* self,
                                             gint index);
PangoLayout* checkerboard_item_get_tag_list_layout (CheckerboardItem* self);
void checkerboard_item_get_subtitle_allocation (CheckerboardItem* self,
                                                GdkRectangle* result);
gchar* checkerboard_item_get_subtitle (CheckerboardItem* self);
void checkerboard_item_set_subtitle (CheckerboardItem* self,
                                     const gchar* text,
                                     gboolean marked_up,
                                     PangoAlignment alignment);
static void checkerboard_item_set_subtitle_visible (CheckerboardItem* self,
                                             gboolean visible);
void checkerboard_item_set_is_cursor (CheckerboardItem* self,
                                      gboolean is_cursor);
gboolean checkerboard_item_get_is_cursor (CheckerboardItem* self);
static void checkerboard_item_real_notify_membership_changed (DataObject* base,
                                                       DataCollection* collection);
void data_object_get_collection_property (DataObject* self,
                                          const gchar* name,
                                          GValue* def,
                                          GValue* result);
static void _vala_GValue_free (GValue* self);
gboolean dimensions_has_area (Dimensions *self);
void data_object_notify_membership_changed (DataObject* self,
                                            DataCollection* collection);
static void checkerboard_item_real_notify_collection_property_set (DataObject* base,
                                                            const gchar* name,
                                                            GValue* old,
                                                            GValue* val);
void data_object_notify_collection_property_set (DataObject* self,
                                                 const gchar* name,
                                                 GValue* old,
                                                 GValue* val);
gint checkerboard_item_get_alignment_point (CheckerboardItem* self);
void checkerboard_item_exposed (CheckerboardItem* self);
static void checkerboard_item_real_exposed (CheckerboardItem* self);
void checkerboard_item_unexposed (CheckerboardItem* self);
static void checkerboard_item_real_unexposed (CheckerboardItem* self);
gboolean checkerboard_item_is_exposed (CheckerboardItem* self);
static gboolean checkerboard_item_real_is_exposed (CheckerboardItem* self);
gboolean checkerboard_item_has_image (CheckerboardItem* self);
GdkPixbuf* checkerboard_item_get_image (CheckerboardItem* self);
void checkerboard_item_set_image (CheckerboardItem* self,
                                  GdkPixbuf* pixbuf);
void dimensions_for_pixbuf (GdkPixbuf* pixbuf,
                            Dimensions* result);
void checkerboard_item_clear_image (CheckerboardItem* self,
                                    Dimensions* dim);
gint checkerboard_item_get_max_width (gint scale);
gboolean dimensions_approx_equals (Dimensions *self,
                                   Dimensions* dim,
                                   gint fudge);
void data_view_notify_geometry_altered (DataView* self);
void checkerboard_item_get_border_dimensions (Dimensions* object_dim,
                                              gint border_width,
                                              Dimensions* result);
void checkerboard_item_get_border_origin (GdkPoint* object_origin,
                                          gint border_width,
                                          GdkPoint* result);
void checkerboard_item_paint_shadow (CheckerboardItem* self,
                                     cairo_t* ctx,
                                     Dimensions* dimensions,
                                     GdkPoint* origin,
                                     gint radius,
                                     gfloat initial_alpha);
static void checkerboard_item_real_paint_shadow (CheckerboardItem* self,
                                          cairo_t* ctx,
                                          Dimensions* dimensions,
                                          GdkPoint* origin,
                                          gint radius,
                                          gfloat initial_alpha);
void checkerboard_item_paint_shadow_in_corner (CheckerboardItem* self,
                                               cairo_t* ctx,
                                               gint x,
                                               gint y,
                                               gdouble rgb_all,
                                               gfloat radius,
                                               gfloat initial_alpha,
                                               gdouble arc1,
                                               gdouble arc2);
void checkerboard_item_paint_border (CheckerboardItem* self,
                                     cairo_t* ctx,
                                     Dimensions* object_dimensions,
                                     GdkPoint* object_origin,
                                     gint border_width);
static void checkerboard_item_real_paint_border (CheckerboardItem* self,
                                          cairo_t* ctx,
                                          Dimensions* object_dimensions,
                                          GdkPoint* object_origin,
                                          gint border_width);
void draw_rounded_corners_filled (cairo_t* ctx,
                                  Dimensions* dim,
                                  GdkPoint* origin,
                                  gdouble radius_proportion);
void checkerboard_item_paint_image (CheckerboardItem* self,
                                    cairo_t* ctx,
                                    GdkPixbuf* pixbuf,
                                    GdkPoint* origin);
static void checkerboard_item_real_paint_image (CheckerboardItem* self,
                                         cairo_t* ctx,
                                         GdkPixbuf* pixbuf,
                                         GdkPoint* origin);
void paint_pixmap_with_background (cairo_t* ctx,
                                   GdkPixbuf* pixbuf,
                                   gint x,
                                   gint y);
static gint checkerboard_item_get_selection_border_width (CheckerboardItem* self,
                                                   gint scale);
gint thumbnail_get_MIN_SCALE (void);
gint thumbnail_get_MAX_SCALE (void);
GdkPixbuf* checkerboard_item_get_top_left_trinket (CheckerboardItem* self,
                                                   gint scale);
static GdkPixbuf* checkerboard_item_real_get_top_left_trinket (CheckerboardItem* self,
                                                        gint scale);
GdkPixbuf* checkerboard_item_get_top_right_trinket (CheckerboardItem* self,
                                                    gint scale);
static GdkPixbuf* checkerboard_item_real_get_top_right_trinket (CheckerboardItem* self,
                                                         gint scale);
GdkPixbuf* checkerboard_item_get_bottom_left_trinket (CheckerboardItem* self,
                                                      gint scale);
static GdkPixbuf* checkerboard_item_real_get_bottom_left_trinket (CheckerboardItem* self,
                                                           gint scale);
GdkPixbuf* checkerboard_item_get_bottom_right_trinket (CheckerboardItem* self,
                                                       gint scale);
static GdkPixbuf* checkerboard_item_real_get_bottom_right_trinket (CheckerboardItem* self,
                                                            gint scale);
void checkerboard_item_paint (CheckerboardItem* self,
                              cairo_t* ctx,
                              GdkRGBA* bg_color,
                              GdkRGBA* selected_color,
                              GdkRGBA* text_color,
                              GdkRGBA* border_color);
gboolean data_view_is_selected (DataView* self);
gint checkerboard_item_get_horizontal_trinket_offset (CheckerboardItem* self);
void checkerboard_item_set_horizontal_trinket_offset (CheckerboardItem* self,
                                                      gint horizontal_trinket_offset);
void checkerboard_item_set_grid_coordinates (CheckerboardItem* self,
                                             gint col,
                                             gint row);
gint checkerboard_item_get_column (CheckerboardItem* self);
gint checkerboard_item_get_row (CheckerboardItem* self);
void checkerboard_item_brighten (CheckerboardItem* self);
void shift_colors (GdkPixbuf* pixbuf,
                   gint red,
                   gint green,
                   gint blue,
                   gint alpha);
void checkerboard_item_unbrighten (CheckerboardItem* self);
static void checkerboard_item_real_visibility_changed (DataView* base,
                                                gboolean visible);
static gboolean checkerboard_item_query_tooltip_on_text (CheckerboardItem* self,
                                                  CheckerboardItemText* text,
                                                  GtkTooltip* tooltip);
gboolean checkerboard_item_query_tooltip (CheckerboardItem* self,
                                          gint x,
                                          gint y,
                                          GtkTooltip* tooltip);
gboolean coord_in_rectangle (gint x,
                             gint y,
                             GdkRectangle* rect);
static void checkerboard_item_finalize (GObject * obj);
static void _vala_checkerboard_item_get_property (GObject * object,
                                           guint property_id,
                                           GValue * value,
                                           GParamSpec * pspec);
static void _vala_checkerboard_item_set_property (GObject * object,
                                           guint property_id,
                                           const GValue * value,
                                           GParamSpec * pspec);
GType checkerboard_layout_get_type (void) G_GNUC_CONST;
GType view_collection_get_type (void) G_GNUC_CONST;
static gpointer checkerboard_layout_layout_row_ref (gpointer instance);
static void checkerboard_layout_layout_row_unref (gpointer instance);
static GParamSpec* checkerboard_layout_param_spec_layout_row (const gchar* name,
                                                       const gchar* nick,
                                                       const gchar* blurb,
                                                       GType object_type,
                                                       GParamFlags flags) G_GNUC_UNUSED;
static void checkerboard_layout_value_set_layout_row (GValue* value,
                                               gpointer v_object) G_GNUC_UNUSED;
static void checkerboard_layout_value_take_layout_row (GValue* value,
                                                gpointer v_object) G_GNUC_UNUSED;
static gpointer checkerboard_layout_value_get_layout_row (const GValue* value) G_GNUC_UNUSED;
static GType checkerboard_layout_layout_row_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
#define CHECKERBOARD_LAYOUT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_CHECKERBOARD_LAYOUT, CheckerboardLayoutPrivate))
static void checkerboard_layout_on_contents_altered (CheckerboardLayout* self,
                                              GeeIterable* added,
                                              GeeIterable* removed);
static void _checkerboard_layout_on_contents_altered_data_collection_contents_altered (DataCollection* _sender,
                                                                                GeeIterable* added,
                                                                                GeeIterable* removed,
                                                                                gpointer self);
static void checkerboard_layout_on_items_altered (CheckerboardLayout* self);
static void _checkerboard_layout_on_items_altered_data_collection_items_altered (DataCollection* _sender,
                                                                          GeeMap* items,
                                                                          gpointer self);
static void checkerboard_layout_on_items_state_changed (CheckerboardLayout* self,
                                                 GeeIterable* changed);
static void _checkerboard_layout_on_items_state_changed_view_collection_items_state_changed (ViewCollection* _sender,
                                                                                      GeeIterable* changed,
                                                                                      gpointer self);
static void checkerboard_layout_on_items_visibility_changed (CheckerboardLayout* self,
                                                      GeeIterable* changed);
static void _checkerboard_layout_on_items_visibility_changed_view_collection_items_visibility_changed (ViewCollection* _sender,
                                                                                                GeeCollection* changed,
                                                                                                gpointer self);
static void checkerboard_layout_on_ordering_changed (CheckerboardLayout* self);
static void _checkerboard_layout_on_ordering_changed_data_collection_ordering_changed (DataCollection* _sender,
                                                                                gpointer self);
static void checkerboard_layout_on_views_altered (CheckerboardLayout* self,
                                           GeeCollection* altered);
static void _checkerboard_layout_on_views_altered_view_collection_views_altered (ViewCollection* _sender,
                                                                          GeeCollection* views,
                                                                          gpointer self);
static void checkerboard_layout_on_geometries_altered (CheckerboardLayout* self);
static void _checkerboard_layout_on_geometries_altered_view_collection_geometries_altered (ViewCollection* _sender,
                                                                                    GeeCollection* views,
                                                                                    gpointer self);
static void checkerboard_layout_on_items_selection_changed (CheckerboardLayout* self);
static void _checkerboard_layout_on_items_selection_changed_view_collection_items_selected (ViewCollection* _sender,
                                                                                     GeeIterable* selected,
                                                                                     gpointer self);
static void _checkerboard_layout_on_items_selection_changed_view_collection_items_unselected (ViewCollection* _sender,
                                                                                       GeeIterable* unselected,
                                                                                       gpointer self);
static void checkerboard_layout_on_viewport_shifted (CheckerboardLayout* self);
static void _checkerboard_layout_on_viewport_shifted_gtk_adjustment_value_changed (GtkAdjustment* _sender,
                                                                            gpointer self);
static void checkerboard_layout_on_viewport_resized (CheckerboardLayout* self);
static void _checkerboard_layout_on_viewport_resized_gtk_widget_size_allocate (GtkWidget* _sender,
                                                                        GtkAllocation* allocation,
                                                                        gpointer self);
GType configuration_facade_get_type (void) G_GNUC_CONST;
GType config_facade_get_type (void) G_GNUC_CONST;
ConfigFacade* config_facade_get_instance (void);
static void checkerboard_layout_on_colors_changed (CheckerboardLayout* self);
static void _checkerboard_layout_on_colors_changed_config_facade_colors_changed (ConfigFacade* _sender,
                                                                          gpointer self);
#define CHECKERBOARD_LAYOUT_TOP_PADDING 16
#define CHECKERBOARD_LAYOUT_BOTTOM_PADDING 16
#define CHECKERBOARD_LAYOUT_ROW_GUTTER_PADDING 24
#define CHECKERBOARD_LAYOUT_COLUMN_GUTTER_PADDING 24
#define CHECKERBOARD_LAYOUT_SELECTION_ALPHA 0.40
#define CHECKERBOARD_LAYOUT_SCROLLBAR_PLACEHOLDER_WIDTH 1
CheckerboardLayout* checkerboard_layout_new (ViewCollection* view);
CheckerboardLayout* checkerboard_layout_construct (GType object_type,
                                                   ViewCollection* view);
void checkerboard_layout_clear_drag_select (CheckerboardLayout* self);
void config_facade_get_bg_color (ConfigFacade* self,
                                 GdkRGBA* result);
void checkerboard_layout_set_adjustments (CheckerboardLayout* self,
                                          GtkAdjustment* hadjustment,
                                          GtkAdjustment* vadjustment);
void checkerboard_layout_set_scale (CheckerboardLayout* self,
                                    gint scale);
gint checkerboard_layout_get_scale (CheckerboardLayout* self);
void checkerboard_layout_set_name (CheckerboardLayout* self,
                                   const gchar* name);
static void checkerboard_layout_viewport_resized (CheckerboardLayout* self);
static void checkerboard_layout_clear_anchor (CheckerboardLayout* self);
static void checkerboard_layout_update_visible_page (CheckerboardLayout* self);
static void checkerboard_layout_need_exposure (CheckerboardLayout* self,
                                        const gchar* caller);
static void checkerboard_layout_update_anchor (CheckerboardLayout* self);
GeeList* checkerboard_layout_intersection (CheckerboardLayout* self,
                                           GdkRectangle* area);
static void checkerboard_layout_center_on_anchor (CheckerboardLayout* self,
                                           gdouble upper);
void checkerboard_layout_set_cursor (CheckerboardLayout* self,
                                     CheckerboardItem* item);
gboolean data_collection_contains (DataCollection* self,
                                   DataObject* object);
CheckerboardItem* checkerboard_layout_get_cursor (CheckerboardLayout* self);
static void checkerboard_layout_need_reflow (CheckerboardLayout* self,
                                      const gchar* caller);
static void checkerboard_layout_items_dirty (CheckerboardLayout* self,
                                      const gchar* reason,
                                      GeeIterable* items);
static gboolean checkerboard_layout_do_reflow (CheckerboardLayout* self);
static gboolean _checkerboard_layout_do_reflow_gsource_func (gpointer self);
static void checkerboard_layout_reflow (CheckerboardLayout* self,
                                 const gchar* caller);
void checkerboard_layout_set_message (CheckerboardLayout* self,
                                      const gchar* text);
void checkerboard_layout_unset_message (CheckerboardLayout* self);
void get_adjustment_page (GtkAdjustment* hadj,
                          GtkAdjustment* vadj,
                          GdkRectangle* result);
void checkerboard_layout_set_in_view (CheckerboardLayout* self,
                                      gboolean in_view);
static void checkerboard_layout_unexpose_items (CheckerboardLayout* self,
                                         const gchar* caller);
CheckerboardItem* checkerboard_layout_get_item_at_pixel (CheckerboardLayout* self,
                                                         gdouble xd,
                                                         gdouble yd);
gint checkerboard_layout_get_tag_index_at_pos (const gchar* tag_list,
                                               gint pos);
#define TAG_TAG_LIST_SEPARATOR_STRING ", "
static gint checkerboard_layout_internal_handle_tag_mouse_event (CheckerboardLayout* self,
                                                          CheckerboardItem* item,
                                                          gint x,
                                                          gint y);
gboolean checkerboard_layout_handle_mouse_motion (CheckerboardLayout* self,
                                                  CheckerboardItem* item,
                                                  gint x,
                                                  gint y,
                                                  GdkModifierType mask);
gboolean checkerboard_layout_is_drag_select_active (CheckerboardLayout* self);
gboolean checkerboard_layout_handle_left_click (CheckerboardLayout* self,
                                                CheckerboardItem* item,
                                                gdouble xd,
                                                gdouble yd,
                                                GdkModifierType mask);
GType library_window_get_type (void) G_GNUC_CONST;
LibraryWindow* library_window_get_app (void);
void library_window_switch_to_tag (LibraryWindow* self,
                                   Tag* tag);
GeeList* checkerboard_layout_get_visible_items (CheckerboardLayout* self);
GType compass_point_get_type (void) G_GNUC_CONST;
CheckerboardItem* checkerboard_layout_get_item_relative_to (CheckerboardLayout* self,
                                                            CheckerboardItem* item,
                                                            CompassPoint point);
gint data_collection_get_count (DataCollection* self);
CheckerboardItem* checkerboard_layout_get_item_at_coordinate (CheckerboardLayout* self,
                                                              gint col,
                                                              gint row);
DataView* view_collection_get_last (ViewCollection* self);
void checkerboard_layout_set_drag_select_origin (CheckerboardLayout* self,
                                                 gint x,
                                                 gint y);
void checkerboard_layout_set_drag_select_endpoint (CheckerboardLayout* self,
                                                   gint x,
                                                   gint y);
GType box_get_type (void) G_GNUC_CONST;
Box* box_dup (const Box* self);
void box_free (Box* self);
void box_from_points (GdkPoint* corner1,
                      GdkPoint* corner2,
                      Box* result);
void box_get_rectangle (Box *self,
                        GdkRectangle* result);
GeeList* checkerboard_layout_items_in_selection_band (CheckerboardLayout* self);
void dimensions_for_rectangle (GdkRectangle* rect,
                               Dimensions* result);
static void checkerboard_layout_expose_items (CheckerboardLayout* self,
                                       const gchar* caller);
void data_collection_freeze_notifications (DataCollection* self);
void data_collection_thaw_notifications (DataCollection* self);
gboolean data_view_is_visible (DataView* self);
DataObject* data_collection_get_at (DataCollection* self,
                                    gint index);
static CheckerboardLayoutLayoutRow* checkerboard_layout_layout_row_new (gint y,
                                                                 gint height,
                                                                 gint num_in_row);
static CheckerboardLayoutLayoutRow* checkerboard_layout_layout_row_construct (GType object_type,
                                                                       gint y,
                                                                       gint height,
                                                                       gint num_in_row);
static void checkerboard_layout_real_map (GtkWidget* base);
static void checkerboard_layout_set_colors (CheckerboardLayout* self,
                                     gboolean in_focus);
void config_facade_get_selected_color (ConfigFacade* self,
                                       gboolean in_focus,
                                       GdkRGBA* result);
void config_facade_get_unselected_color (ConfigFacade* self,
                                         GdkRGBA* result);
void config_facade_get_border_color (ConfigFacade* self,
                                     GdkRGBA* result);
static void checkerboard_layout_real_size_allocate (GtkWidget* base,
                                             GtkAllocation* allocation);
static gboolean checkerboard_layout_real_draw (GtkWidget* base,
                                        cairo_t* ctx);
static void checkerboard_layout_draw_selection_band (CheckerboardLayout* self,
                                              cairo_t* ctx);
static gboolean checkerboard_layout_real_query_tooltip (GtkWidget* base,
                                                 gint x,
                                                 gint y,
                                                 gboolean keyboard_mode,
                                                 GtkTooltip* tooltip);
void invalidate_transparent_background (void);
static gboolean checkerboard_layout_real_focus_in_event (GtkWidget* base,
                                                  GdkEventFocus* event);
GeeList* view_collection_get_selected (ViewCollection* self);
static gboolean checkerboard_layout_real_focus_out_event (GtkWidget* base,
                                                   GdkEventFocus* event);
static void checkerboard_layout_layout_row_finalize (CheckerboardLayoutLayoutRow * obj);
static void checkerboard_layout_finalize (GObject * obj);
static void _vala_array_destroy (gpointer array,
                          gint array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gint array_length,
                       GDestroyNotify destroy_func);


CheckerboardItemText*
checkerboard_item_text_construct (GType object_type,
                                  const gchar* text,
                                  PangoAlignment alignment,
                                  gboolean marked_up)
{
	CheckerboardItemText* self = NULL;
	gchar* _tmp0_;
#line 19 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_val_if_fail (text != NULL, NULL);
#line 19 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self = (CheckerboardItemText*) g_type_create_instance (object_type);
#line 21 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = g_strdup (text);
#line 21 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_g_free0 (self->priv->text);
#line 21 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->text = _tmp0_;
#line 22 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->marked_up = marked_up;
#line 23 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->alignment = alignment;
#line 25 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->single_line = checkerboard_item_text_is_single_line (self);
#line 19 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return self;
#line 1007 "CheckerboardLayout.c"
}


CheckerboardItemText*
checkerboard_item_text_new (const gchar* text,
                            PangoAlignment alignment,
                            gboolean marked_up)
{
#line 19 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return checkerboard_item_text_construct (TYPE_CHECKERBOARD_ITEM_TEXT, text, alignment, marked_up);
#line 1018 "CheckerboardLayout.c"
}


static gboolean
checkerboard_item_text_is_single_line (CheckerboardItemText* self)
{
	gboolean result = FALSE;
	const gchar* _tmp0_;
#line 28 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_val_if_fail (IS_CHECKERBOARD_ITEM_TEXT (self), FALSE);
#line 29 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = self->priv->text;
#line 29 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	result = !string_contains_char (_tmp0_, (gunichar) '\n');
#line 29 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return result;
#line 1035 "CheckerboardLayout.c"
}


gboolean
checkerboard_item_text_is_marked_up (CheckerboardItemText* self)
{
	gboolean result = FALSE;
	gboolean _tmp0_;
#line 32 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_val_if_fail (IS_CHECKERBOARD_ITEM_TEXT (self), FALSE);
#line 33 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = self->priv->marked_up;
#line 33 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	result = _tmp0_;
#line 33 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return result;
#line 1052 "CheckerboardLayout.c"
}


gboolean
checkerboard_item_text_is_set_to (CheckerboardItemText* self,
                                  const gchar* text,
                                  gboolean marked_up,
                                  PangoAlignment alignment)
{
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_;
#line 36 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_val_if_fail (IS_CHECKERBOARD_ITEM_TEXT (self), FALSE);
#line 36 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_val_if_fail (text != NULL, FALSE);
#line 37 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp2_ = self->priv->marked_up;
#line 37 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp2_ == marked_up) {
#line 1074 "CheckerboardLayout.c"
		PangoAlignment _tmp3_;
#line 37 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp3_ = self->priv->alignment;
#line 37 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp1_ = _tmp3_ == alignment;
#line 1080 "CheckerboardLayout.c"
	} else {
#line 37 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp1_ = FALSE;
#line 1084 "CheckerboardLayout.c"
	}
#line 37 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp1_) {
#line 1088 "CheckerboardLayout.c"
		const gchar* _tmp4_;
#line 37 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp4_ = self->priv->text;
#line 37 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp0_ = g_strcmp0 (_tmp4_, text) == 0;
#line 1094 "CheckerboardLayout.c"
	} else {
#line 37 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp0_ = FALSE;
#line 1098 "CheckerboardLayout.c"
	}
#line 37 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	result = _tmp0_;
#line 37 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return result;
#line 1104 "CheckerboardLayout.c"
}


gchar*
checkerboard_item_text_get_text (CheckerboardItemText* self)
{
	gchar* result = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
#line 40 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_val_if_fail (IS_CHECKERBOARD_ITEM_TEXT (self), NULL);
#line 41 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = self->priv->text;
#line 41 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 41 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	result = _tmp1_;
#line 41 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return result;
#line 1124 "CheckerboardLayout.c"
}


gint
checkerboard_item_text_get_height (CheckerboardItemText* self)
{
	gint result = 0;
	gint _tmp0_;
	gint _tmp1_;
#line 44 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_val_if_fail (IS_CHECKERBOARD_ITEM_TEXT (self), 0);
#line 45 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = self->priv->height;
#line 45 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp0_ == 0) {
#line 46 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		checkerboard_item_text_update_height (self);
#line 1142 "CheckerboardLayout.c"
	}
#line 48 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = self->priv->height;
#line 48 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	result = _tmp1_;
#line 48 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return result;
#line 1150 "CheckerboardLayout.c"
}


static gpointer
_g_object_ref0 (gpointer self)
{
#line 58 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return self ? g_object_ref (self) : NULL;
#line 1159 "CheckerboardLayout.c"
}


PangoLayout*
checkerboard_item_text_get_pango_layout (CheckerboardItemText* self,
                                         gint max_width)
{
	PangoLayout* result = NULL;
	PangoLayout* _tmp0_;
	PangoLayout* _tmp2_;
	PangoLayout* _tmp3_;
#line 51 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_val_if_fail (IS_CHECKERBOARD_ITEM_TEXT (self), NULL);
#line 52 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = self->priv->layout;
#line 52 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp0_ == NULL) {
#line 53 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		checkerboard_item_text_create_pango (self);
#line 1179 "CheckerboardLayout.c"
	}
#line 55 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (max_width > 0) {
#line 1183 "CheckerboardLayout.c"
		PangoLayout* _tmp1_;
#line 56 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp1_ = self->priv->layout;
#line 56 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		pango_layout_set_width (_tmp1_, max_width * PANGO_SCALE);
#line 1189 "CheckerboardLayout.c"
	}
#line 58 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp2_ = self->priv->layout;
#line 58 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp3_ = _g_object_ref0 (_tmp2_);
#line 58 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	result = _tmp3_;
#line 58 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return result;
#line 1199 "CheckerboardLayout.c"
}


void
checkerboard_item_text_clear_pango_layout (CheckerboardItemText* self)
{
#line 61 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (IS_CHECKERBOARD_ITEM_TEXT (self));
#line 62 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_g_object_unref0 (self->priv->layout);
#line 62 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->layout = NULL;
#line 1212 "CheckerboardLayout.c"
}


static void
checkerboard_item_text_update_height (CheckerboardItemText* self)
{
	gboolean _tmp0_ = FALSE;
	gint _tmp1_;
#line 65 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (IS_CHECKERBOARD_ITEM_TEXT (self));
#line 66 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = checkerboard_item_text_one_line_height;
#line 66 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp1_ != 0) {
#line 1227 "CheckerboardLayout.c"
		gboolean _tmp2_;
#line 66 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp2_ = self->priv->single_line;
#line 66 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp0_ = _tmp2_;
#line 1233 "CheckerboardLayout.c"
	} else {
#line 66 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp0_ = FALSE;
#line 1237 "CheckerboardLayout.c"
	}
#line 66 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp0_) {
#line 1241 "CheckerboardLayout.c"
		gint _tmp3_;
#line 67 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp3_ = checkerboard_item_text_one_line_height;
#line 67 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		self->priv->height = _tmp3_;
#line 1247 "CheckerboardLayout.c"
	} else {
#line 69 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		checkerboard_item_text_create_pango (self);
#line 1251 "CheckerboardLayout.c"
	}
}


static void
checkerboard_item_text_create_pango (CheckerboardItemText* self)
{
	AppWindow* _tmp0_;
	AppWindow* _tmp1_;
	PangoLayout* _tmp2_;
	gboolean _tmp3_;
	PangoLayout* _tmp8_;
	PangoLayout* _tmp9_;
	PangoAlignment _tmp10_;
	gboolean _tmp11_ = FALSE;
	gint _tmp12_;
#line 72 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (IS_CHECKERBOARD_ITEM_TEXT (self));
#line 74 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = app_window_get_instance ();
#line 74 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = _tmp0_;
#line 74 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp2_ = gtk_widget_create_pango_layout (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, gtk_widget_get_type (), GtkWidget), NULL);
#line 74 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_g_object_unref0 (self->priv->layout);
#line 74 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->layout = _tmp2_;
#line 74 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_g_object_unref0 (_tmp1_);
#line 75 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp3_ = self->priv->marked_up;
#line 75 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (!_tmp3_) {
#line 1286 "CheckerboardLayout.c"
		PangoLayout* _tmp4_;
		const gchar* _tmp5_;
#line 76 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp4_ = self->priv->layout;
#line 76 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp5_ = self->priv->text;
#line 76 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		pango_layout_set_text (_tmp4_, _tmp5_, -1);
#line 1295 "CheckerboardLayout.c"
	} else {
		PangoLayout* _tmp6_;
		const gchar* _tmp7_;
#line 78 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp6_ = self->priv->layout;
#line 78 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp7_ = self->priv->text;
#line 78 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		pango_layout_set_markup (_tmp6_, _tmp7_, -1);
#line 1305 "CheckerboardLayout.c"
	}
#line 80 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp8_ = self->priv->layout;
#line 80 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	pango_layout_set_ellipsize (_tmp8_, PANGO_ELLIPSIZE_END);
#line 81 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp9_ = self->priv->layout;
#line 81 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp10_ = self->priv->alignment;
#line 81 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	pango_layout_set_alignment (_tmp9_, _tmp10_);
#line 85 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp12_ = checkerboard_item_text_one_line_height;
#line 85 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp12_ != 0) {
#line 1321 "CheckerboardLayout.c"
		gboolean _tmp13_;
#line 85 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp13_ = self->priv->single_line;
#line 85 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp11_ = _tmp13_;
#line 1327 "CheckerboardLayout.c"
	} else {
#line 85 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp11_ = FALSE;
#line 1331 "CheckerboardLayout.c"
	}
#line 85 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp11_) {
#line 1335 "CheckerboardLayout.c"
		gint _tmp14_;
#line 86 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp14_ = checkerboard_item_text_one_line_height;
#line 86 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		self->priv->height = _tmp14_;
#line 1341 "CheckerboardLayout.c"
	} else {
		gint width = 0;
		PangoLayout* _tmp15_;
		gint _tmp16_ = 0;
		gint _tmp17_ = 0;
		gboolean _tmp18_ = FALSE;
		gint _tmp19_;
#line 89 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp15_ = self->priv->layout;
#line 89 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		pango_layout_get_pixel_size (_tmp15_, &_tmp16_, &_tmp17_);
#line 89 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		width = _tmp16_;
#line 89 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		self->priv->height = _tmp17_;
#line 92 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp19_ = checkerboard_item_text_one_line_height;
#line 92 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		if (_tmp19_ == 0) {
#line 1361 "CheckerboardLayout.c"
			gboolean _tmp20_;
#line 92 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp20_ = self->priv->single_line;
#line 92 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp18_ = _tmp20_;
#line 1367 "CheckerboardLayout.c"
		} else {
#line 92 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp18_ = FALSE;
#line 1371 "CheckerboardLayout.c"
		}
#line 92 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		if (_tmp18_) {
#line 1375 "CheckerboardLayout.c"
			gint _tmp21_;
#line 93 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp21_ = self->priv->height;
#line 93 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			checkerboard_item_text_one_line_height = _tmp21_;
#line 1381 "CheckerboardLayout.c"
		}
	}
}


static void
value_checkerboard_item_text_init (GValue* value)
{
#line 7 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	value->data[0].v_pointer = NULL;
#line 1392 "CheckerboardLayout.c"
}


static void
value_checkerboard_item_text_free_value (GValue* value)
{
#line 7 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (value->data[0].v_pointer) {
#line 7 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		checkerboard_item_text_unref (value->data[0].v_pointer);
#line 1403 "CheckerboardLayout.c"
	}
}


static void
value_checkerboard_item_text_copy_value (const GValue* src_value,
                                         GValue* dest_value)
{
#line 7 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (src_value->data[0].v_pointer) {
#line 7 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		dest_value->data[0].v_pointer = checkerboard_item_text_ref (src_value->data[0].v_pointer);
#line 1416 "CheckerboardLayout.c"
	} else {
#line 7 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		dest_value->data[0].v_pointer = NULL;
#line 1420 "CheckerboardLayout.c"
	}
}


static gpointer
value_checkerboard_item_text_peek_pointer (const GValue* value)
{
#line 7 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return value->data[0].v_pointer;
#line 1430 "CheckerboardLayout.c"
}


static gchar*
value_checkerboard_item_text_collect_value (GValue* value,
                                            guint n_collect_values,
                                            GTypeCValue* collect_values,
                                            guint collect_flags)
{
#line 7 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (collect_values[0].v_pointer) {
#line 1442 "CheckerboardLayout.c"
		CheckerboardItemText * object;
		object = collect_values[0].v_pointer;
#line 7 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		if (object->parent_instance.g_class == NULL) {
#line 7 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 1449 "CheckerboardLayout.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 7 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 1453 "CheckerboardLayout.c"
		}
#line 7 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		value->data[0].v_pointer = checkerboard_item_text_ref (object);
#line 1457 "CheckerboardLayout.c"
	} else {
#line 7 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		value->data[0].v_pointer = NULL;
#line 1461 "CheckerboardLayout.c"
	}
#line 7 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return NULL;
#line 1465 "CheckerboardLayout.c"
}


static gchar*
value_checkerboard_item_text_lcopy_value (const GValue* value,
                                          guint n_collect_values,
                                          GTypeCValue* collect_values,
                                          guint collect_flags)
{
	CheckerboardItemText ** object_p;
	object_p = collect_values[0].v_pointer;
#line 7 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (!object_p) {
#line 7 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 1481 "CheckerboardLayout.c"
	}
#line 7 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (!value->data[0].v_pointer) {
#line 7 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		*object_p = NULL;
#line 1487 "CheckerboardLayout.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 7 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		*object_p = value->data[0].v_pointer;
#line 1491 "CheckerboardLayout.c"
	} else {
#line 7 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		*object_p = checkerboard_item_text_ref (value->data[0].v_pointer);
#line 1495 "CheckerboardLayout.c"
	}
#line 7 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return NULL;
#line 1499 "CheckerboardLayout.c"
}


GParamSpec*
param_spec_checkerboard_item_text (const gchar* name,
                                   const gchar* nick,
                                   const gchar* blurb,
                                   GType object_type,
                                   GParamFlags flags)
{
	ParamSpecCheckerboardItemText* spec;
#line 7 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_CHECKERBOARD_ITEM_TEXT), NULL);
#line 7 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 7 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 7 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return G_PARAM_SPEC (spec);
#line 1519 "CheckerboardLayout.c"
}


gpointer
value_get_checkerboard_item_text (const GValue* value)
{
#line 7 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_CHECKERBOARD_ITEM_TEXT), NULL);
#line 7 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return value->data[0].v_pointer;
#line 1530 "CheckerboardLayout.c"
}


void
value_set_checkerboard_item_text (GValue* value,
                                  gpointer v_object)
{
	CheckerboardItemText * old;
#line 7 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_CHECKERBOARD_ITEM_TEXT));
#line 7 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	old = value->data[0].v_pointer;
#line 7 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (v_object) {
#line 7 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_CHECKERBOARD_ITEM_TEXT));
#line 7 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 7 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		value->data[0].v_pointer = v_object;
#line 7 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		checkerboard_item_text_ref (value->data[0].v_pointer);
#line 1553 "CheckerboardLayout.c"
	} else {
#line 7 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		value->data[0].v_pointer = NULL;
#line 1557 "CheckerboardLayout.c"
	}
#line 7 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (old) {
#line 7 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		checkerboard_item_text_unref (old);
#line 1563 "CheckerboardLayout.c"
	}
}


void
value_take_checkerboard_item_text (GValue* value,
                                   gpointer v_object)
{
	CheckerboardItemText * old;
#line 7 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_CHECKERBOARD_ITEM_TEXT));
#line 7 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	old = value->data[0].v_pointer;
#line 7 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (v_object) {
#line 7 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_CHECKERBOARD_ITEM_TEXT));
#line 7 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 7 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		value->data[0].v_pointer = v_object;
#line 1585 "CheckerboardLayout.c"
	} else {
#line 7 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		value->data[0].v_pointer = NULL;
#line 1589 "CheckerboardLayout.c"
	}
#line 7 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (old) {
#line 7 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		checkerboard_item_text_unref (old);
#line 1595 "CheckerboardLayout.c"
	}
}


static void
checkerboard_item_text_class_init (CheckerboardItemTextClass * klass)
{
#line 7 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	checkerboard_item_text_parent_class = g_type_class_peek_parent (klass);
#line 7 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	((CheckerboardItemTextClass *) klass)->finalize = checkerboard_item_text_finalize;
#line 7 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_type_class_add_private (klass, sizeof (CheckerboardItemTextPrivate));
#line 1609 "CheckerboardLayout.c"
}


static void
checkerboard_item_text_instance_init (CheckerboardItemText * self)
{
#line 7 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv = CHECKERBOARD_ITEM_TEXT_GET_PRIVATE (self);
#line 13 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->layout = NULL;
#line 14 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->single_line = TRUE;
#line 15 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->height = 0;
#line 17 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	memset (&self->allocation, 0, sizeof (GdkRectangle));
#line 7 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->ref_count = 1;
#line 1628 "CheckerboardLayout.c"
}


static void
checkerboard_item_text_finalize (CheckerboardItemText * obj)
{
	CheckerboardItemText * self;
#line 7 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_CHECKERBOARD_ITEM_TEXT, CheckerboardItemText);
#line 7 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_signal_handlers_destroy (self);
#line 10 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_g_free0 (self->priv->text);
#line 13 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_g_object_unref0 (self->priv->layout);
#line 1644 "CheckerboardLayout.c"
}


GType
checkerboard_item_text_get_type (void)
{
	static volatile gsize checkerboard_item_text_type_id__volatile = 0;
	if (g_once_init_enter (&checkerboard_item_text_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_checkerboard_item_text_init, value_checkerboard_item_text_free_value, value_checkerboard_item_text_copy_value, value_checkerboard_item_text_peek_pointer, "p", value_checkerboard_item_text_collect_value, "p", value_checkerboard_item_text_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (CheckerboardItemTextClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) checkerboard_item_text_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CheckerboardItemText), 0, (GInstanceInitFunc) checkerboard_item_text_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType checkerboard_item_text_type_id;
		checkerboard_item_text_type_id = g_type_register_fundamental (g_type_fundamental_next (), "CheckerboardItemText", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&checkerboard_item_text_type_id__volatile, checkerboard_item_text_type_id);
	}
	return checkerboard_item_text_type_id__volatile;
}


gpointer
checkerboard_item_text_ref (gpointer instance)
{
	CheckerboardItemText * self;
	self = instance;
#line 7 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_atomic_int_inc (&self->ref_count);
#line 7 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return instance;
#line 1673 "CheckerboardLayout.c"
}


void
checkerboard_item_text_unref (gpointer instance)
{
	CheckerboardItemText * self;
	self = instance;
#line 7 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 7 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		CHECKERBOARD_ITEM_TEXT_GET_CLASS (self)->finalize (self);
#line 7 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 1688 "CheckerboardLayout.c"
	}
}


static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gchar* result = NULL;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError * _inner_error_ = NULL;
#line 1421 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1421 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	g_return_val_if_fail (old != NULL, NULL);
#line 1421 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	g_return_val_if_fail (replacement != NULL, NULL);
#line 1422 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	if ((*((gchar*) self)) == '\0') {
#line 1422 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		_tmp1_ = TRUE;
#line 1712 "CheckerboardLayout.c"
	} else {
#line 1422 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		_tmp1_ = (*((gchar*) old)) == '\0';
#line 1716 "CheckerboardLayout.c"
	}
#line 1422 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	if (_tmp1_) {
#line 1422 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		_tmp0_ = TRUE;
#line 1722 "CheckerboardLayout.c"
	} else {
#line 1422 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
#line 1726 "CheckerboardLayout.c"
	}
#line 1422 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	if (_tmp0_) {
#line 1730 "CheckerboardLayout.c"
		gchar* _tmp2_;
#line 1423 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		_tmp2_ = g_strdup (self);
#line 1423 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		result = _tmp2_;
#line 1423 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		return result;
#line 1738 "CheckerboardLayout.c"
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
#line 1426 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		_tmp3_ = g_regex_escape_string (old, -1);
#line 1426 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		_tmp4_ = _tmp3_;
#line 1426 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error_);
#line 1426 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		_tmp6_ = _tmp5_;
#line 1426 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		_g_free0 (_tmp4_);
#line 1426 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		regex = _tmp6_;
#line 1426 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1426 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
			if (_inner_error_->domain == G_REGEX_ERROR) {
#line 1766 "CheckerboardLayout.c"
				goto __catch254_g_regex_error;
			}
#line 1426 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1426 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
			g_clear_error (&_inner_error_);
#line 1426 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
			return NULL;
#line 1775 "CheckerboardLayout.c"
		}
#line 1427 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		_tmp8_ = regex;
#line 1427 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error_);
#line 1427 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		_tmp7_ = _tmp9_;
#line 1427 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1427 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
			_g_regex_unref0 (regex);
#line 1427 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
			if (_inner_error_->domain == G_REGEX_ERROR) {
#line 1789 "CheckerboardLayout.c"
				goto __catch254_g_regex_error;
			}
#line 1427 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
			_g_regex_unref0 (regex);
#line 1427 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1427 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
			g_clear_error (&_inner_error_);
#line 1427 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
			return NULL;
#line 1800 "CheckerboardLayout.c"
		}
#line 1427 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		_tmp10_ = _tmp7_;
#line 1427 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		_tmp7_ = NULL;
#line 1427 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		result = _tmp10_;
#line 1427 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		_g_free0 (_tmp7_);
#line 1427 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		_g_regex_unref0 (regex);
#line 1427 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		return result;
#line 1814 "CheckerboardLayout.c"
	}
	goto __finally254;
	__catch254_g_regex_error:
	{
		GError* e = NULL;
#line 1425 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		e = _inner_error_;
#line 1425 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		_inner_error_ = NULL;
#line 1429 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		g_assert_not_reached ();
#line 1425 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		_g_error_free0 (e);
#line 1828 "CheckerboardLayout.c"
	}
	__finally254:
#line 1425 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1425 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1425 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		g_clear_error (&_inner_error_);
#line 1425 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		return NULL;
#line 1839 "CheckerboardLayout.c"
	}
}


CheckerboardItem*
checkerboard_item_construct (GType object_type,
                             ThumbnailSource* source,
                             Dimensions* initial_pixbuf_dim,
                             const gchar* title,
                             const gchar* comment,
                             gboolean marked_up,
                             PangoAlignment alignment)
{
	CheckerboardItem * self = NULL;
	Dimensions _tmp0_;
	CheckerboardItemText* _tmp1_;
#line 141 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_val_if_fail (IS_THUMBNAIL_SOURCE (source), NULL);
#line 141 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_val_if_fail (initial_pixbuf_dim != NULL, NULL);
#line 141 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_val_if_fail (title != NULL, NULL);
#line 143 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self = (CheckerboardItem*) thumbnail_view_construct (object_type, source);
#line 145 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = *initial_pixbuf_dim;
#line 145 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->pixbuf_dim = _tmp0_;
#line 146 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = checkerboard_item_text_new (title, alignment, marked_up);
#line 146 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_checkerboard_item_text_unref0 (self->priv->title);
#line 146 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->title = _tmp1_;
#line 152 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (comment != NULL) {
#line 1876 "CheckerboardLayout.c"
		gchar* _tmp2_;
		gchar* _tmp3_;
		CheckerboardItemText* _tmp4_;
#line 153 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp2_ = string_replace (comment, "\n", " ");
#line 153 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp3_ = _tmp2_;
#line 153 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp4_ = checkerboard_item_text_new (_tmp3_, alignment, marked_up);
#line 153 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_checkerboard_item_text_unref0 (self->priv->comment);
#line 153 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		self->priv->comment = _tmp4_;
#line 153 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_g_free0 (_tmp3_);
#line 1892 "CheckerboardLayout.c"
	}
#line 141 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return self;
#line 1896 "CheckerboardLayout.c"
}


static gchar*
checkerboard_item_real_get_name (DataObject* base)
{
	CheckerboardItem * self;
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	CheckerboardItemText* _tmp1_;
#line 163 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_CHECKERBOARD_ITEM, CheckerboardItem);
#line 164 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = self->priv->title;
#line 164 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp1_ != NULL) {
#line 1913 "CheckerboardLayout.c"
		CheckerboardItemText* _tmp2_;
		gchar* _tmp3_;
#line 164 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp2_ = self->priv->title;
#line 164 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp3_ = checkerboard_item_text_get_text (_tmp2_);
#line 164 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_g_free0 (_tmp0_);
#line 164 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp0_ = _tmp3_;
#line 1924 "CheckerboardLayout.c"
	} else {
		gchar* _tmp4_;
#line 164 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp4_ = DATA_OBJECT_CLASS (checkerboard_item_parent_class)->get_name (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_THUMBNAIL_VIEW, ThumbnailView), TYPE_DATA_OBJECT, DataObject));
#line 164 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_g_free0 (_tmp0_);
#line 164 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp0_ = _tmp4_;
#line 1933 "CheckerboardLayout.c"
	}
#line 164 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	result = _tmp0_;
#line 164 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return result;
#line 1939 "CheckerboardLayout.c"
}


gchar*
checkerboard_item_get_title (CheckerboardItem* self)
{
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	CheckerboardItemText* _tmp1_;
#line 167 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_val_if_fail (IS_CHECKERBOARD_ITEM (self), NULL);
#line 168 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = self->priv->title;
#line 168 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp1_ != NULL) {
#line 1955 "CheckerboardLayout.c"
		CheckerboardItemText* _tmp2_;
		gchar* _tmp3_;
#line 168 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp2_ = self->priv->title;
#line 168 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp3_ = checkerboard_item_text_get_text (_tmp2_);
#line 168 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_g_free0 (_tmp0_);
#line 168 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp0_ = _tmp3_;
#line 1966 "CheckerboardLayout.c"
	} else {
		gchar* _tmp4_;
#line 168 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp4_ = g_strdup ("");
#line 168 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_g_free0 (_tmp0_);
#line 168 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp0_ = _tmp4_;
#line 1975 "CheckerboardLayout.c"
	}
#line 168 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	result = _tmp0_;
#line 168 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return result;
#line 1981 "CheckerboardLayout.c"
}


gchar*
checkerboard_item_get_comment (CheckerboardItem* self)
{
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	CheckerboardItemText* _tmp1_;
#line 171 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_val_if_fail (IS_CHECKERBOARD_ITEM (self), NULL);
#line 172 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = self->priv->comment;
#line 172 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp1_ != NULL) {
#line 1997 "CheckerboardLayout.c"
		CheckerboardItemText* _tmp2_;
		gchar* _tmp3_;
#line 172 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp2_ = self->priv->comment;
#line 172 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp3_ = checkerboard_item_text_get_text (_tmp2_);
#line 172 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_g_free0 (_tmp0_);
#line 172 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp0_ = _tmp3_;
#line 2008 "CheckerboardLayout.c"
	} else {
		gchar* _tmp4_;
#line 172 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp4_ = g_strdup ("");
#line 172 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_g_free0 (_tmp0_);
#line 172 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp0_ = _tmp4_;
#line 2017 "CheckerboardLayout.c"
	}
#line 172 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	result = _tmp0_;
#line 172 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return result;
#line 2023 "CheckerboardLayout.c"
}


void
checkerboard_item_set_title (CheckerboardItem* self,
                             const gchar* text,
                             gboolean marked_up,
                             PangoAlignment alignment)
{
	gboolean _tmp0_ = FALSE;
	CheckerboardItemText* _tmp1_;
	CheckerboardItemText* _tmp3_;
	gboolean _tmp4_;
#line 175 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (IS_CHECKERBOARD_ITEM (self));
#line 175 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (text != NULL);
#line 177 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = self->priv->title;
#line 177 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp1_ != NULL) {
#line 2045 "CheckerboardLayout.c"
		CheckerboardItemText* _tmp2_;
#line 177 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp2_ = self->priv->title;
#line 177 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp0_ = checkerboard_item_text_is_set_to (_tmp2_, text, marked_up, alignment);
#line 2051 "CheckerboardLayout.c"
	} else {
#line 177 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp0_ = FALSE;
#line 2055 "CheckerboardLayout.c"
	}
#line 177 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp0_) {
#line 178 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		return;
#line 2061 "CheckerboardLayout.c"
	}
#line 180 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp3_ = checkerboard_item_text_new (text, alignment, marked_up);
#line 180 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_checkerboard_item_text_unref0 (self->priv->title);
#line 180 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->title = _tmp3_;
#line 182 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp4_ = self->priv->title_visible;
#line 182 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp4_) {
#line 183 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		checkerboard_item_recalc_size (self, "set_title");
#line 184 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		data_view_notify_view_altered (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_VIEW, DataView));
#line 2077 "CheckerboardLayout.c"
	}
}


void
checkerboard_item_translate_coordinates (CheckerboardItem* self,
                                         gint* x,
                                         gint* y)
{
	GdkRectangle _tmp0_;
	gint _tmp1_;
	GdkRectangle _tmp2_;
	gint _tmp3_;
#line 188 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (IS_CHECKERBOARD_ITEM (self));
#line 189 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = self->allocation;
#line 189 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = _tmp0_.x;
#line 189 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	*x = (*x) - (_tmp1_ + CHECKERBOARD_ITEM_FRAME_WIDTH);
#line 190 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp2_ = self->allocation;
#line 190 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp3_ = _tmp2_.y;
#line 190 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	*y = (*y) - (_tmp3_ + CHECKERBOARD_ITEM_FRAME_WIDTH);
#line 2105 "CheckerboardLayout.c"
}


void
checkerboard_item_clear_title (CheckerboardItem* self)
{
	CheckerboardItemText* _tmp0_;
	gboolean _tmp1_;
#line 193 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (IS_CHECKERBOARD_ITEM (self));
#line 194 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = self->priv->title;
#line 194 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp0_ == NULL) {
#line 195 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		return;
#line 2122 "CheckerboardLayout.c"
	}
#line 197 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_checkerboard_item_text_unref0 (self->priv->title);
#line 197 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->title = NULL;
#line 199 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = self->priv->title_visible;
#line 199 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp1_) {
#line 200 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		checkerboard_item_recalc_size (self, "clear_title");
#line 201 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		data_view_notify_view_altered (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_VIEW, DataView));
#line 2136 "CheckerboardLayout.c"
	}
}


static void
checkerboard_item_set_title_visible (CheckerboardItem* self,
                                     gboolean visible)
{
	gboolean _tmp0_;
#line 205 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (IS_CHECKERBOARD_ITEM (self));
#line 206 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = self->priv->title_visible;
#line 206 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp0_ == visible) {
#line 207 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		return;
#line 2154 "CheckerboardLayout.c"
	}
#line 209 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->title_visible = visible;
#line 211 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	checkerboard_item_recalc_size (self, "set_title_visible");
#line 212 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	data_view_notify_view_altered (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_VIEW, DataView));
#line 2162 "CheckerboardLayout.c"
}


void
checkerboard_item_set_comment (CheckerboardItem* self,
                               const gchar* text,
                               gboolean marked_up,
                               PangoAlignment alignment)
{
	gboolean _tmp0_ = FALSE;
	CheckerboardItemText* _tmp1_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	CheckerboardItemText* _tmp5_;
	gboolean _tmp6_;
#line 215 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (IS_CHECKERBOARD_ITEM (self));
#line 215 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (text != NULL);
#line 217 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = self->priv->comment;
#line 217 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp1_ != NULL) {
#line 2186 "CheckerboardLayout.c"
		CheckerboardItemText* _tmp2_;
#line 217 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp2_ = self->priv->comment;
#line 217 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp0_ = checkerboard_item_text_is_set_to (_tmp2_, text, marked_up, alignment);
#line 2192 "CheckerboardLayout.c"
	} else {
#line 217 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp0_ = FALSE;
#line 2196 "CheckerboardLayout.c"
	}
#line 217 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp0_) {
#line 218 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		return;
#line 2202 "CheckerboardLayout.c"
	}
#line 220 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp3_ = string_replace (text, "\n", " ");
#line 220 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp4_ = _tmp3_;
#line 220 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp5_ = checkerboard_item_text_new (_tmp4_, alignment, marked_up);
#line 220 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_checkerboard_item_text_unref0 (self->priv->comment);
#line 220 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->comment = _tmp5_;
#line 220 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_g_free0 (_tmp4_);
#line 222 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp6_ = self->priv->comment_visible;
#line 222 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp6_) {
#line 223 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		checkerboard_item_recalc_size (self, "set_comment");
#line 224 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		data_view_notify_view_altered (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_VIEW, DataView));
#line 2224 "CheckerboardLayout.c"
	}
}


void
checkerboard_item_clear_comment (CheckerboardItem* self)
{
	CheckerboardItemText* _tmp0_;
	gboolean _tmp1_;
#line 228 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (IS_CHECKERBOARD_ITEM (self));
#line 229 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = self->priv->comment;
#line 229 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp0_ == NULL) {
#line 230 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		return;
#line 2242 "CheckerboardLayout.c"
	}
#line 232 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_checkerboard_item_text_unref0 (self->priv->comment);
#line 232 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->comment = NULL;
#line 234 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = self->priv->comment_visible;
#line 234 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp1_) {
#line 235 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		checkerboard_item_recalc_size (self, "clear_comment");
#line 236 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		data_view_notify_view_altered (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_VIEW, DataView));
#line 2256 "CheckerboardLayout.c"
	}
}


static void
checkerboard_item_set_comment_visible (CheckerboardItem* self,
                                       gboolean visible)
{
	gboolean _tmp0_;
#line 240 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (IS_CHECKERBOARD_ITEM (self));
#line 241 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = self->priv->comment_visible;
#line 241 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp0_ == visible) {
#line 242 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		return;
#line 2274 "CheckerboardLayout.c"
	}
#line 244 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->comment_visible = visible;
#line 246 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	checkerboard_item_recalc_size (self, "set_comment_visible");
#line 247 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	data_view_notify_view_altered (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_VIEW, DataView));
#line 2282 "CheckerboardLayout.c"
}


void
checkerboard_item_set_tags (CheckerboardItem* self,
                            GeeCollection* tags,
                            PangoAlignment alignment)
{
	gboolean _tmp0_ = FALSE;
	gchar* text = NULL;
	gboolean _tmp3_;
	gboolean _tmp9_ = FALSE;
	CheckerboardItemText* _tmp10_;
	const gchar* _tmp13_;
	CheckerboardItemText* _tmp14_;
	gboolean _tmp15_;
#line 250 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (IS_CHECKERBOARD_ITEM (self));
#line 250 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail ((tags == NULL) || GEE_IS_COLLECTION (tags));
#line 252 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (tags != NULL) {
#line 2305 "CheckerboardLayout.c"
		gint _tmp1_;
		gint _tmp2_;
#line 252 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp1_ = gee_collection_get_size (tags);
#line 252 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp2_ = _tmp1_;
#line 252 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp0_ = _tmp2_ > 0;
#line 2314 "CheckerboardLayout.c"
	} else {
#line 252 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp0_ = FALSE;
#line 2318 "CheckerboardLayout.c"
	}
#line 252 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	checkerboard_item_set_has_tags (self, _tmp0_);
#line 253 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->tag_alignment = alignment;
#line 255 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp3_ = self->priv->_has_tags;
#line 255 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp3_) {
#line 2328 "CheckerboardLayout.c"
		GeeCollection* _tmp4_;
		GeeList* _tmp5_;
		GeeList* _tmp6_;
		gchar* _tmp7_;
#line 256 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp4_ = _g_object_ref0 (tags);
#line 256 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_g_object_unref0 (self->priv->tags);
#line 256 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		self->priv->tags = _tmp4_;
#line 257 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp5_ = tag_make_user_visible_tag_list (tags);
#line 257 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_g_object_unref0 (self->priv->user_visible_tag_list);
#line 257 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		self->priv->user_visible_tag_list = _tmp5_;
#line 258 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp6_ = self->priv->user_visible_tag_list;
#line 258 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp7_ = tag_make_tag_markup_string (_tmp6_, -1);
#line 258 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_g_free0 (text);
#line 258 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		text = _tmp7_;
#line 2353 "CheckerboardLayout.c"
	} else {
		gchar* _tmp8_;
#line 260 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp8_ = g_strdup ("<small>.</small>");
#line 260 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_g_free0 (text);
#line 260 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		text = _tmp8_;
#line 2362 "CheckerboardLayout.c"
	}
#line 263 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp10_ = self->priv->subtitle;
#line 263 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp10_ != NULL) {
#line 2368 "CheckerboardLayout.c"
		CheckerboardItemText* _tmp11_;
		const gchar* _tmp12_;
#line 263 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp11_ = self->priv->subtitle;
#line 263 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp12_ = text;
#line 263 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp9_ = checkerboard_item_text_is_set_to (_tmp11_, _tmp12_, TRUE, alignment);
#line 2377 "CheckerboardLayout.c"
	} else {
#line 263 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp9_ = FALSE;
#line 2381 "CheckerboardLayout.c"
	}
#line 263 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp9_) {
#line 264 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_g_free0 (text);
#line 264 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		return;
#line 2389 "CheckerboardLayout.c"
	}
#line 265 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp13_ = text;
#line 265 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp14_ = checkerboard_item_text_new (_tmp13_, alignment, TRUE);
#line 265 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_checkerboard_item_text_unref0 (self->priv->subtitle);
#line 265 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->subtitle = _tmp14_;
#line 267 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp15_ = self->priv->subtitle_visible;
#line 267 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp15_) {
#line 268 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		checkerboard_item_recalc_size (self, "set_subtitle");
#line 269 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		data_view_notify_view_altered (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_VIEW, DataView));
#line 2407 "CheckerboardLayout.c"
	}
#line 250 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_g_free0 (text);
#line 2411 "CheckerboardLayout.c"
}


void
checkerboard_item_clear_tags (CheckerboardItem* self)
{
#line 273 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (IS_CHECKERBOARD_ITEM (self));
#line 274 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	checkerboard_item_clear_subtitle (self);
#line 275 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	checkerboard_item_set_has_tags (self, FALSE);
#line 276 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_g_object_unref0 (self->priv->user_visible_tag_list);
#line 276 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->user_visible_tag_list = NULL;
#line 2428 "CheckerboardLayout.c"
}


void
checkerboard_item_highlight_user_visible_tag (CheckerboardItem* self,
                                              gint index)
{
	GeeList* _tmp0_;
	gchar* text = NULL;
	GeeList* _tmp1_;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	PangoAlignment _tmp4_;
	CheckerboardItemText* _tmp5_;
	gboolean _tmp6_;
#line 279 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (IS_CHECKERBOARD_ITEM (self));
#line 279 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = self->priv->user_visible_tag_list;
#line 279 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_vala_return_if_fail (_tmp0_ != NULL, "user_visible_tag_list != null");
#line 281 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = self->priv->user_visible_tag_list;
#line 281 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp2_ = tag_make_tag_markup_string (_tmp1_, index);
#line 281 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	text = _tmp2_;
#line 282 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp3_ = text;
#line 282 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp4_ = self->priv->tag_alignment;
#line 282 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp5_ = checkerboard_item_text_new (_tmp3_, _tmp4_, TRUE);
#line 282 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_checkerboard_item_text_unref0 (self->priv->subtitle);
#line 282 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->subtitle = _tmp5_;
#line 284 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp6_ = self->priv->subtitle_visible;
#line 284 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp6_) {
#line 285 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		data_view_notify_view_altered (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_VIEW, DataView));
#line 2472 "CheckerboardLayout.c"
	}
#line 279 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_g_free0 (text);
#line 2476 "CheckerboardLayout.c"
}


Tag*
checkerboard_item_get_user_visible_tag (CheckerboardItem* self,
                                        gint index)
{
	Tag* result = NULL;
	GeeList* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	GeeList* _tmp3_;
	gpointer _tmp4_;
#line 288 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_val_if_fail (IS_CHECKERBOARD_ITEM (self), NULL);
#line 288 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = self->priv->user_visible_tag_list;
#line 288 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_COLLECTION, GeeCollection));
#line 288 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp2_ = _tmp1_;
#line 288 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_vala_return_val_if_fail ((index >= 0) && (index < _tmp2_), "index >= 0 && index < user_visible_tag_list.size", NULL);
#line 290 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp3_ = self->priv->user_visible_tag_list;
#line 290 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp4_ = gee_list_get (_tmp3_, index);
#line 290 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	result = (Tag*) _tmp4_;
#line 290 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return result;
#line 2508 "CheckerboardLayout.c"
}


PangoLayout*
checkerboard_item_get_tag_list_layout (CheckerboardItem* self)
{
	PangoLayout* result = NULL;
	PangoLayout* _tmp0_ = NULL;
	gboolean _tmp1_;
#line 293 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_val_if_fail (IS_CHECKERBOARD_ITEM (self), NULL);
#line 294 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = self->priv->_has_tags;
#line 294 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp1_) {
#line 2524 "CheckerboardLayout.c"
		CheckerboardItemText* _tmp2_;
		PangoLayout* _tmp3_;
#line 294 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp2_ = self->priv->subtitle;
#line 294 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp3_ = checkerboard_item_text_get_pango_layout (_tmp2_, 0);
#line 294 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_g_object_unref0 (_tmp0_);
#line 294 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp0_ = _tmp3_;
#line 2535 "CheckerboardLayout.c"
	} else {
#line 294 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_g_object_unref0 (_tmp0_);
#line 294 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp0_ = NULL;
#line 2541 "CheckerboardLayout.c"
	}
#line 294 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	result = _tmp0_;
#line 294 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return result;
#line 2547 "CheckerboardLayout.c"
}


void
checkerboard_item_get_subtitle_allocation (CheckerboardItem* self,
                                           GdkRectangle* result)
{
	CheckerboardItemText* _tmp0_;
	GdkRectangle _tmp1_;
#line 297 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (IS_CHECKERBOARD_ITEM (self));
#line 298 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = self->priv->subtitle;
#line 298 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = _tmp0_->allocation;
#line 298 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	*result = _tmp1_;
#line 298 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return;
#line 2567 "CheckerboardLayout.c"
}


gchar*
checkerboard_item_get_subtitle (CheckerboardItem* self)
{
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	CheckerboardItemText* _tmp1_;
#line 301 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_val_if_fail (IS_CHECKERBOARD_ITEM (self), NULL);
#line 302 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = self->priv->subtitle;
#line 302 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp1_ != NULL) {
#line 2583 "CheckerboardLayout.c"
		CheckerboardItemText* _tmp2_;
		gchar* _tmp3_;
#line 302 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp2_ = self->priv->subtitle;
#line 302 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp3_ = checkerboard_item_text_get_text (_tmp2_);
#line 302 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_g_free0 (_tmp0_);
#line 302 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp0_ = _tmp3_;
#line 2594 "CheckerboardLayout.c"
	} else {
		gchar* _tmp4_;
#line 302 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp4_ = g_strdup ("");
#line 302 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_g_free0 (_tmp0_);
#line 302 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp0_ = _tmp4_;
#line 2603 "CheckerboardLayout.c"
	}
#line 302 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	result = _tmp0_;
#line 302 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return result;
#line 2609 "CheckerboardLayout.c"
}


void
checkerboard_item_set_subtitle (CheckerboardItem* self,
                                const gchar* text,
                                gboolean marked_up,
                                PangoAlignment alignment)
{
	gboolean _tmp0_ = FALSE;
	CheckerboardItemText* _tmp1_;
	CheckerboardItemText* _tmp3_;
	gboolean _tmp4_;
#line 305 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (IS_CHECKERBOARD_ITEM (self));
#line 305 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (text != NULL);
#line 307 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = self->priv->subtitle;
#line 307 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp1_ != NULL) {
#line 2631 "CheckerboardLayout.c"
		CheckerboardItemText* _tmp2_;
#line 307 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp2_ = self->priv->subtitle;
#line 307 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp0_ = checkerboard_item_text_is_set_to (_tmp2_, text, marked_up, alignment);
#line 2637 "CheckerboardLayout.c"
	} else {
#line 307 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp0_ = FALSE;
#line 2641 "CheckerboardLayout.c"
	}
#line 307 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp0_) {
#line 308 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		return;
#line 2647 "CheckerboardLayout.c"
	}
#line 310 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp3_ = checkerboard_item_text_new (text, alignment, marked_up);
#line 310 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_checkerboard_item_text_unref0 (self->priv->subtitle);
#line 310 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->subtitle = _tmp3_;
#line 312 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp4_ = self->priv->subtitle_visible;
#line 312 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp4_) {
#line 313 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		checkerboard_item_recalc_size (self, "set_subtitle");
#line 314 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		data_view_notify_view_altered (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_VIEW, DataView));
#line 2663 "CheckerboardLayout.c"
	}
}


void
checkerboard_item_clear_subtitle (CheckerboardItem* self)
{
	CheckerboardItemText* _tmp0_;
	gboolean _tmp1_;
#line 318 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (IS_CHECKERBOARD_ITEM (self));
#line 319 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = self->priv->subtitle;
#line 319 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp0_ == NULL) {
#line 320 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		return;
#line 2681 "CheckerboardLayout.c"
	}
#line 322 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_checkerboard_item_text_unref0 (self->priv->subtitle);
#line 322 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->subtitle = NULL;
#line 324 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = self->priv->subtitle_visible;
#line 324 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp1_) {
#line 325 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		checkerboard_item_recalc_size (self, "clear_subtitle");
#line 326 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		data_view_notify_view_altered (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_VIEW, DataView));
#line 2695 "CheckerboardLayout.c"
	}
}


static void
checkerboard_item_set_subtitle_visible (CheckerboardItem* self,
                                        gboolean visible)
{
	gboolean _tmp0_;
#line 330 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (IS_CHECKERBOARD_ITEM (self));
#line 331 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = self->priv->subtitle_visible;
#line 331 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp0_ == visible) {
#line 332 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		return;
#line 2713 "CheckerboardLayout.c"
	}
#line 334 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->subtitle_visible = visible;
#line 336 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	checkerboard_item_recalc_size (self, "set_subtitle_visible");
#line 337 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	data_view_notify_view_altered (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_VIEW, DataView));
#line 2721 "CheckerboardLayout.c"
}


void
checkerboard_item_set_is_cursor (CheckerboardItem* self,
                                 gboolean is_cursor)
{
#line 340 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (IS_CHECKERBOARD_ITEM (self));
#line 341 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->is_cursor = is_cursor;
#line 2733 "CheckerboardLayout.c"
}


gboolean
checkerboard_item_get_is_cursor (CheckerboardItem* self)
{
	gboolean result = FALSE;
	gboolean _tmp0_;
#line 344 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_val_if_fail (IS_CHECKERBOARD_ITEM (self), FALSE);
#line 345 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = self->priv->is_cursor;
#line 345 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	result = _tmp0_;
#line 345 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return result;
#line 2750 "CheckerboardLayout.c"
}


static void
_vala_GValue_free (GValue* self)
{
#line 349 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_value_unset (self);
#line 349 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_free (self);
#line 2761 "CheckerboardLayout.c"
}


static void
checkerboard_item_real_notify_membership_changed (DataObject* base,
                                                  DataCollection* collection)
{
	CheckerboardItem * self;
	gboolean title_visible = FALSE;
	GValue* _tmp0_ = NULL;
	GValue _tmp1_ = {0};
	gboolean _tmp2_;
	gboolean comment_visible = FALSE;
	GValue* _tmp3_ = NULL;
	GValue _tmp4_ = {0};
	gboolean _tmp5_;
	gboolean subtitle_visible = FALSE;
	GValue* _tmp6_ = NULL;
	GValue _tmp7_ = {0};
	gboolean _tmp8_;
	gboolean altered = FALSE;
	gboolean _tmp9_;
	gboolean _tmp10_;
	gboolean _tmp12_;
	gboolean _tmp13_;
	gboolean _tmp15_;
	gboolean _tmp16_;
	gboolean _tmp18_ = FALSE;
	gboolean _tmp19_;
#line 348 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_CHECKERBOARD_ITEM, CheckerboardItem);
#line 348 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail ((collection == NULL) || IS_DATA_COLLECTION (collection));
#line 349 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = g_new0 (GValue, 1);
#line 349 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_value_init (_tmp0_, G_TYPE_BOOLEAN);
#line 349 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_value_set_boolean (_tmp0_, TRUE);
#line 349 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	data_object_get_collection_property (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_OBJECT, DataObject), CHECKERBOARD_ITEM_PROP_SHOW_TITLES, _tmp0_, &_tmp1_);
#line 349 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp2_ = g_value_get_boolean (&_tmp1_);
#line 349 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	__vala_GValue_free0 (_tmp0_);
#line 349 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	title_visible = _tmp2_;
#line 350 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp3_ = g_new0 (GValue, 1);
#line 350 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_value_init (_tmp3_, G_TYPE_BOOLEAN);
#line 350 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_value_set_boolean (_tmp3_, TRUE);
#line 350 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	data_object_get_collection_property (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_OBJECT, DataObject), CHECKERBOARD_ITEM_PROP_SHOW_COMMENTS, _tmp3_, &_tmp4_);
#line 350 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp5_ = g_value_get_boolean (&_tmp4_);
#line 350 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	__vala_GValue_free0 (_tmp3_);
#line 350 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	comment_visible = _tmp5_;
#line 351 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp6_ = g_new0 (GValue, 1);
#line 351 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_value_init (_tmp6_, G_TYPE_BOOLEAN);
#line 351 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_value_set_boolean (_tmp6_, FALSE);
#line 351 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	data_object_get_collection_property (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_OBJECT, DataObject), CHECKERBOARD_ITEM_PROP_SHOW_SUBTITLES, _tmp6_, &_tmp7_);
#line 351 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp8_ = g_value_get_boolean (&_tmp7_);
#line 351 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	__vala_GValue_free0 (_tmp6_);
#line 351 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	subtitle_visible = _tmp8_;
#line 353 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	altered = FALSE;
#line 354 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp9_ = self->priv->title_visible;
#line 354 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp10_ = title_visible;
#line 354 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp9_ != _tmp10_) {
#line 2845 "CheckerboardLayout.c"
		gboolean _tmp11_;
#line 355 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp11_ = title_visible;
#line 355 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		self->priv->title_visible = _tmp11_;
#line 356 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		altered = TRUE;
#line 2853 "CheckerboardLayout.c"
	}
#line 359 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp12_ = self->priv->comment_visible;
#line 359 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp13_ = comment_visible;
#line 359 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp12_ != _tmp13_) {
#line 2861 "CheckerboardLayout.c"
		gboolean _tmp14_;
#line 360 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp14_ = comment_visible;
#line 360 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		self->priv->comment_visible = _tmp14_;
#line 361 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		altered = TRUE;
#line 2869 "CheckerboardLayout.c"
	}
#line 364 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp15_ = self->priv->subtitle_visible;
#line 364 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp16_ = subtitle_visible;
#line 364 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp15_ != _tmp16_) {
#line 2877 "CheckerboardLayout.c"
		gboolean _tmp17_;
#line 365 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp17_ = subtitle_visible;
#line 365 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		self->priv->subtitle_visible = _tmp17_;
#line 366 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		altered = TRUE;
#line 2885 "CheckerboardLayout.c"
	}
#line 369 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp19_ = altered;
#line 369 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp19_) {
#line 369 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp18_ = TRUE;
#line 2893 "CheckerboardLayout.c"
	} else {
#line 369 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp18_ = !dimensions_has_area (&self->requisition);
#line 2897 "CheckerboardLayout.c"
	}
#line 369 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp18_) {
#line 370 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		checkerboard_item_recalc_size (self, "notify_membership_changed");
#line 371 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		data_view_notify_view_altered (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_VIEW, DataView));
#line 2905 "CheckerboardLayout.c"
	}
#line 374 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	DATA_OBJECT_CLASS (checkerboard_item_parent_class)->notify_membership_changed (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_THUMBNAIL_VIEW, ThumbnailView), TYPE_DATA_OBJECT, DataObject), collection);
#line 2909 "CheckerboardLayout.c"
}


static void
checkerboard_item_real_notify_collection_property_set (DataObject* base,
                                                       const gchar* name,
                                                       GValue* old,
                                                       GValue* val)
{
	CheckerboardItem * self;
	const gchar* _tmp0_;
	GQuark _tmp2_ = 0U;
	GValue _tmp6_;
#line 377 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_CHECKERBOARD_ITEM, CheckerboardItem);
#line 377 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (name != NULL);
#line 377 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (val != NULL);
#line 378 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = name;
#line 378 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp2_ = (NULL == _tmp0_) ? 0 : g_quark_from_string (_tmp0_);
#line 378 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp2_ == g_quark_from_string (CHECKERBOARD_ITEM_PROP_SHOW_TITLES)) {
#line 378 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		switch (0) {
#line 2937 "CheckerboardLayout.c"
			default:
			{
				GValue _tmp3_;
#line 380 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp3_ = *val;
#line 380 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				checkerboard_item_set_title_visible (self, g_value_get_boolean (&_tmp3_));
#line 381 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				break;
#line 2947 "CheckerboardLayout.c"
			}
		}
	} else if (_tmp2_ == g_quark_from_string (CHECKERBOARD_ITEM_PROP_SHOW_COMMENTS)) {
#line 378 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		switch (0) {
#line 2953 "CheckerboardLayout.c"
			default:
			{
				GValue _tmp4_;
#line 384 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp4_ = *val;
#line 384 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				checkerboard_item_set_comment_visible (self, g_value_get_boolean (&_tmp4_));
#line 385 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				break;
#line 2963 "CheckerboardLayout.c"
			}
		}
	} else if (_tmp2_ == g_quark_from_string (CHECKERBOARD_ITEM_PROP_SHOW_SUBTITLES)) {
#line 378 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		switch (0) {
#line 2969 "CheckerboardLayout.c"
			default:
			{
				GValue _tmp5_;
#line 388 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp5_ = *val;
#line 388 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				checkerboard_item_set_subtitle_visible (self, g_value_get_boolean (&_tmp5_));
#line 389 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				break;
#line 2979 "CheckerboardLayout.c"
			}
		}
	}
#line 392 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp6_ = *val;
#line 392 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	DATA_OBJECT_CLASS (checkerboard_item_parent_class)->notify_collection_property_set (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_THUMBNAIL_VIEW, ThumbnailView), TYPE_DATA_OBJECT, DataObject), name, old, &_tmp6_);
#line 2987 "CheckerboardLayout.c"
}


gint
checkerboard_item_get_alignment_point (CheckerboardItem* self)
{
	gint result = 0;
	Dimensions _tmp0_;
	gint _tmp1_;
#line 398 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_val_if_fail (IS_CHECKERBOARD_ITEM (self), 0);
#line 399 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = self->priv->pixbuf_dim;
#line 399 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = _tmp0_.height;
#line 399 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	result = (CHECKERBOARD_ITEM_FRAME_WIDTH + CHECKERBOARD_ITEM_BORDER_WIDTH) + _tmp1_;
#line 399 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return result;
#line 3007 "CheckerboardLayout.c"
}


static void
checkerboard_item_real_exposed (CheckerboardItem* self)
{
#line 403 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->exposure = TRUE;
#line 3016 "CheckerboardLayout.c"
}


void
checkerboard_item_exposed (CheckerboardItem* self)
{
#line 402 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (IS_CHECKERBOARD_ITEM (self));
#line 402 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	CHECKERBOARD_ITEM_GET_CLASS (self)->exposed (self);
#line 3027 "CheckerboardLayout.c"
}


static void
checkerboard_item_real_unexposed (CheckerboardItem* self)
{
	CheckerboardItemText* _tmp0_;
	CheckerboardItemText* _tmp2_;
	CheckerboardItemText* _tmp4_;
#line 407 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->exposure = FALSE;
#line 409 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = self->priv->title;
#line 409 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp0_ != NULL) {
#line 3043 "CheckerboardLayout.c"
		CheckerboardItemText* _tmp1_;
#line 410 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp1_ = self->priv->title;
#line 410 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		checkerboard_item_text_clear_pango_layout (_tmp1_);
#line 3049 "CheckerboardLayout.c"
	}
#line 412 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp2_ = self->priv->comment;
#line 412 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp2_ != NULL) {
#line 3055 "CheckerboardLayout.c"
		CheckerboardItemText* _tmp3_;
#line 413 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp3_ = self->priv->comment;
#line 413 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		checkerboard_item_text_clear_pango_layout (_tmp3_);
#line 3061 "CheckerboardLayout.c"
	}
#line 415 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp4_ = self->priv->subtitle;
#line 415 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp4_ != NULL) {
#line 3067 "CheckerboardLayout.c"
		CheckerboardItemText* _tmp5_;
#line 416 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp5_ = self->priv->subtitle;
#line 416 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		checkerboard_item_text_clear_pango_layout (_tmp5_);
#line 3073 "CheckerboardLayout.c"
	}
}


void
checkerboard_item_unexposed (CheckerboardItem* self)
{
#line 406 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (IS_CHECKERBOARD_ITEM (self));
#line 406 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	CHECKERBOARD_ITEM_GET_CLASS (self)->unexposed (self);
#line 3085 "CheckerboardLayout.c"
}


static gboolean
checkerboard_item_real_is_exposed (CheckerboardItem* self)
{
	gboolean result = FALSE;
	gboolean _tmp0_;
#line 420 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = self->priv->exposure;
#line 420 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	result = _tmp0_;
#line 420 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return result;
#line 3100 "CheckerboardLayout.c"
}


gboolean
checkerboard_item_is_exposed (CheckerboardItem* self)
{
#line 419 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_val_if_fail (IS_CHECKERBOARD_ITEM (self), FALSE);
#line 419 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return CHECKERBOARD_ITEM_GET_CLASS (self)->is_exposed (self);
#line 3111 "CheckerboardLayout.c"
}


gboolean
checkerboard_item_has_image (CheckerboardItem* self)
{
	gboolean result = FALSE;
	GdkPixbuf* _tmp0_;
#line 423 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_val_if_fail (IS_CHECKERBOARD_ITEM (self), FALSE);
#line 424 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = self->priv->pixbuf;
#line 424 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	result = _tmp0_ != NULL;
#line 424 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return result;
#line 3128 "CheckerboardLayout.c"
}


GdkPixbuf*
checkerboard_item_get_image (CheckerboardItem* self)
{
	GdkPixbuf* result = NULL;
	GdkPixbuf* _tmp0_;
	GdkPixbuf* _tmp1_;
#line 427 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_val_if_fail (IS_CHECKERBOARD_ITEM (self), NULL);
#line 428 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = self->priv->pixbuf;
#line 428 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 428 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	result = _tmp1_;
#line 428 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return result;
#line 3148 "CheckerboardLayout.c"
}


void
checkerboard_item_set_image (CheckerboardItem* self,
                             GdkPixbuf* pixbuf)
{
	GdkPixbuf* _tmp0_;
	GdkPixbuf* _tmp1_;
	Dimensions _tmp2_ = {0};
#line 431 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (IS_CHECKERBOARD_ITEM (self));
#line 431 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (GDK_IS_PIXBUF (pixbuf));
#line 432 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = _g_object_ref0 (pixbuf);
#line 432 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_g_object_unref0 (self->priv->pixbuf);
#line 432 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->pixbuf = _tmp0_;
#line 433 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = _g_object_ref0 (pixbuf);
#line 433 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_g_object_unref0 (self->priv->display_pixbuf);
#line 433 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->display_pixbuf = _tmp1_;
#line 434 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	dimensions_for_pixbuf (pixbuf, &_tmp2_);
#line 434 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->pixbuf_dim = _tmp2_;
#line 436 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	checkerboard_item_recalc_size (self, "set_image");
#line 437 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	data_view_notify_view_altered (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_VIEW, DataView));
#line 3183 "CheckerboardLayout.c"
}


void
checkerboard_item_clear_image (CheckerboardItem* self,
                               Dimensions* dim)
{
	gboolean had_image = FALSE;
	GdkPixbuf* _tmp0_;
	Dimensions _tmp1_;
	gboolean _tmp2_;
#line 440 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (IS_CHECKERBOARD_ITEM (self));
#line 440 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (dim != NULL);
#line 441 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = self->priv->pixbuf;
#line 441 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	had_image = _tmp0_ != NULL;
#line 443 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_g_object_unref0 (self->priv->pixbuf);
#line 443 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->pixbuf = NULL;
#line 444 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_g_object_unref0 (self->priv->display_pixbuf);
#line 444 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->display_pixbuf = NULL;
#line 445 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = *dim;
#line 445 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->pixbuf_dim = _tmp1_;
#line 447 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	checkerboard_item_recalc_size (self, "clear_image");
#line 449 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp2_ = had_image;
#line 449 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp2_) {
#line 450 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		data_view_notify_view_altered (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_VIEW, DataView));
#line 3223 "CheckerboardLayout.c"
	}
}


gint
checkerboard_item_get_max_width (gint scale)
{
	gint result = 0;
#line 456 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	result = (CHECKERBOARD_ITEM_FRAME_WIDTH * 2) + scale;
#line 456 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return result;
#line 3236 "CheckerboardLayout.c"
}


static void
checkerboard_item_recalc_size (CheckerboardItem* self,
                               const gchar* reason)
{
	Dimensions old_requisition = {0};
	Dimensions _tmp0_;
	gint _tmp1_ = 0;
	gboolean _tmp2_ = FALSE;
	CheckerboardItemText* _tmp3_;
	gint title_height = 0;
	gint _tmp6_ = 0;
	gboolean _tmp7_ = FALSE;
	CheckerboardItemText* _tmp8_;
	gint comment_height = 0;
	gint _tmp11_ = 0;
	gboolean _tmp12_ = FALSE;
	CheckerboardItemText* _tmp13_;
	gint subtitle_height = 0;
	Dimensions _tmp16_;
	gint _tmp17_;
	Dimensions _tmp18_;
	gint _tmp19_;
	gint _tmp20_;
	gint _tmp21_;
	gint _tmp22_;
	Dimensions _tmp23_;
#line 459 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (IS_CHECKERBOARD_ITEM (self));
#line 459 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (reason != NULL);
#line 460 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = self->requisition;
#line 460 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	old_requisition = _tmp0_;
#line 463 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp3_ = self->priv->title;
#line 463 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp3_ != NULL) {
#line 3278 "CheckerboardLayout.c"
		gboolean _tmp4_;
#line 463 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp4_ = self->priv->title_visible;
#line 463 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp2_ = _tmp4_;
#line 3284 "CheckerboardLayout.c"
	} else {
#line 463 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp2_ = FALSE;
#line 3288 "CheckerboardLayout.c"
	}
#line 463 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp2_) {
#line 3292 "CheckerboardLayout.c"
		CheckerboardItemText* _tmp5_;
#line 464 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp5_ = self->priv->title;
#line 464 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp1_ = checkerboard_item_text_get_height (_tmp5_) + CHECKERBOARD_ITEM_LABEL_PADDING;
#line 3298 "CheckerboardLayout.c"
	} else {
#line 464 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp1_ = 0;
#line 3302 "CheckerboardLayout.c"
	}
#line 463 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	title_height = _tmp1_;
#line 465 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp8_ = self->priv->comment;
#line 465 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp8_ != NULL) {
#line 3310 "CheckerboardLayout.c"
		gboolean _tmp9_;
#line 465 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp9_ = self->priv->comment_visible;
#line 465 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp7_ = _tmp9_;
#line 3316 "CheckerboardLayout.c"
	} else {
#line 465 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp7_ = FALSE;
#line 3320 "CheckerboardLayout.c"
	}
#line 465 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp7_) {
#line 3324 "CheckerboardLayout.c"
		CheckerboardItemText* _tmp10_;
#line 466 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp10_ = self->priv->comment;
#line 466 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp6_ = checkerboard_item_text_get_height (_tmp10_) + CHECKERBOARD_ITEM_LABEL_PADDING;
#line 3330 "CheckerboardLayout.c"
	} else {
#line 466 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp6_ = 0;
#line 3334 "CheckerboardLayout.c"
	}
#line 465 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	comment_height = _tmp6_;
#line 467 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp13_ = self->priv->subtitle;
#line 467 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp13_ != NULL) {
#line 3342 "CheckerboardLayout.c"
		gboolean _tmp14_;
#line 467 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp14_ = self->priv->subtitle_visible;
#line 467 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp12_ = _tmp14_;
#line 3348 "CheckerboardLayout.c"
	} else {
#line 467 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp12_ = FALSE;
#line 3352 "CheckerboardLayout.c"
	}
#line 467 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp12_) {
#line 3356 "CheckerboardLayout.c"
		CheckerboardItemText* _tmp15_;
#line 468 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp15_ = self->priv->subtitle;
#line 468 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp11_ = checkerboard_item_text_get_height (_tmp15_) + CHECKERBOARD_ITEM_LABEL_PADDING;
#line 3362 "CheckerboardLayout.c"
	} else {
#line 468 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp11_ = 0;
#line 3366 "CheckerboardLayout.c"
	}
#line 467 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	subtitle_height = _tmp11_;
#line 472 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp16_ = self->priv->pixbuf_dim;
#line 472 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp17_ = _tmp16_.width;
#line 472 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->requisition.width = ((CHECKERBOARD_ITEM_FRAME_WIDTH * 2) + (CHECKERBOARD_ITEM_BORDER_WIDTH * 2)) + _tmp17_;
#line 476 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp18_ = self->priv->pixbuf_dim;
#line 476 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp19_ = _tmp18_.height;
#line 476 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp20_ = title_height;
#line 476 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp21_ = comment_height;
#line 476 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp22_ = subtitle_height;
#line 476 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->requisition.height = (((((CHECKERBOARD_ITEM_FRAME_WIDTH * 2) + (CHECKERBOARD_ITEM_BORDER_WIDTH * 2)) + _tmp19_) + _tmp20_) + _tmp21_) + _tmp22_;
#line 485 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp23_ = old_requisition;
#line 485 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (!dimensions_approx_equals (&self->requisition, &_tmp23_, 1)) {
#line 489 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		data_view_notify_geometry_altered (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_VIEW, DataView));
#line 3394 "CheckerboardLayout.c"
	}
}


void
checkerboard_item_get_border_dimensions (Dimensions* object_dim,
                                         gint border_width,
                                         Dimensions* result)
{
	Dimensions dimensions = {0};
	Dimensions _tmp0_;
	gint _tmp1_;
	Dimensions _tmp2_;
	gint _tmp3_;
#line 493 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (object_dim != NULL);
#line 494 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	dimensions_init (&dimensions, 0, 0);
#line 495 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = *object_dim;
#line 495 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = _tmp0_.width;
#line 495 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	dimensions.width = _tmp1_ + (border_width * 2);
#line 496 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp2_ = *object_dim;
#line 496 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp3_ = _tmp2_.height;
#line 496 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	dimensions.height = _tmp3_ + (border_width * 2);
#line 497 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	*result = dimensions;
#line 497 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return;
#line 3429 "CheckerboardLayout.c"
}


void
checkerboard_item_get_border_origin (GdkPoint* object_origin,
                                     gint border_width,
                                     GdkPoint* result)
{
	GdkPoint origin = {0};
	GdkPoint _tmp0_;
	gint _tmp1_;
	GdkPoint _tmp2_;
	gint _tmp3_;
#line 500 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (object_origin != NULL);
#line 501 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	memset (&origin, 0, sizeof (GdkPoint));
#line 502 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = *object_origin;
#line 502 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = _tmp0_.x;
#line 502 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	origin.x = _tmp1_ - border_width;
#line 503 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp2_ = *object_origin;
#line 503 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp3_ = _tmp2_.y;
#line 503 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	origin.y = _tmp3_ - border_width;
#line 504 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	*result = origin;
#line 504 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return;
#line 3463 "CheckerboardLayout.c"
}


static void
checkerboard_item_real_paint_shadow (CheckerboardItem* self,
                                     cairo_t* ctx,
                                     Dimensions* dimensions,
                                     GdkPoint* origin,
                                     gint radius,
                                     gfloat initial_alpha)
{
	gdouble rgb_all = 0.0;
	GdkPoint _tmp0_;
	gint _tmp1_;
	Dimensions _tmp2_;
	gint _tmp3_;
	GdkPoint _tmp4_;
	gint _tmp5_;
	GdkPoint _tmp6_;
	gint _tmp7_;
	Dimensions _tmp8_;
	gint _tmp9_;
	GdkPoint _tmp10_;
	gint _tmp11_;
	Dimensions _tmp12_;
	gint _tmp13_;
	GdkPoint _tmp14_;
	gint _tmp15_;
	GdkPoint _tmp16_;
	gint _tmp17_;
	Dimensions _tmp18_;
	gint _tmp19_;
	cairo_pattern_t* lr = NULL;
	GdkPoint _tmp20_;
	gint _tmp21_;
	Dimensions _tmp22_;
	gint _tmp23_;
	GdkPoint _tmp24_;
	gint _tmp25_;
	Dimensions _tmp26_;
	gint _tmp27_;
	cairo_pattern_t* _tmp28_;
	GdkPoint _tmp29_;
	gint _tmp30_;
	GdkPoint _tmp31_;
	gint _tmp32_;
	Dimensions _tmp33_;
	gint _tmp34_;
	Dimensions _tmp35_;
	gint _tmp36_;
	cairo_pattern_t* td = NULL;
	GdkPoint _tmp37_;
	gint _tmp38_;
	Dimensions _tmp39_;
	gint _tmp40_;
	GdkPoint _tmp41_;
	gint _tmp42_;
	Dimensions _tmp43_;
	gint _tmp44_;
	cairo_pattern_t* _tmp45_;
	GdkPoint _tmp46_;
	gint _tmp47_;
	Dimensions _tmp48_;
	gint _tmp49_;
	GdkPoint _tmp50_;
	gint _tmp51_;
	Dimensions _tmp52_;
	gint _tmp53_;
#line 507 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (ctx != NULL);
#line 507 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (dimensions != NULL);
#line 507 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (origin != NULL);
#line 509 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	rgb_all = 0.0;
#line 512 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = *origin;
#line 512 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = _tmp0_.x;
#line 512 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp2_ = *dimensions;
#line 512 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp3_ = _tmp2_.width;
#line 512 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp4_ = *origin;
#line 512 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp5_ = _tmp4_.y;
#line 512 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	checkerboard_item_paint_shadow_in_corner (self, ctx, _tmp1_ + _tmp3_, _tmp5_ + radius, rgb_all, (gfloat) radius, initial_alpha, (-0.5) * G_PI, (gdouble) 0);
#line 515 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp6_ = *origin;
#line 515 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp7_ = _tmp6_.x;
#line 515 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp8_ = *dimensions;
#line 515 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp9_ = _tmp8_.width;
#line 515 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp10_ = *origin;
#line 515 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp11_ = _tmp10_.y;
#line 515 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp12_ = *dimensions;
#line 515 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp13_ = _tmp12_.height;
#line 515 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	checkerboard_item_paint_shadow_in_corner (self, ctx, _tmp7_ + _tmp9_, _tmp11_ + _tmp13_, rgb_all, (gfloat) radius, initial_alpha, (gdouble) 0, 0.5 * G_PI);
#line 518 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp14_ = *origin;
#line 518 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp15_ = _tmp14_.x;
#line 518 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp16_ = *origin;
#line 518 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp17_ = _tmp16_.y;
#line 518 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp18_ = *dimensions;
#line 518 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp19_ = _tmp18_.height;
#line 518 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	checkerboard_item_paint_shadow_in_corner (self, ctx, _tmp15_ + radius, _tmp17_ + _tmp19_, rgb_all, (gfloat) radius, initial_alpha, 0.5 * G_PI, G_PI);
#line 522 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp20_ = *origin;
#line 522 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp21_ = _tmp20_.y;
#line 522 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp22_ = *dimensions;
#line 522 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp23_ = _tmp22_.height;
#line 522 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp24_ = *origin;
#line 522 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp25_ = _tmp24_.y;
#line 522 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp26_ = *dimensions;
#line 522 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp27_ = _tmp26_.height;
#line 522 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp28_ = cairo_pattern_create_linear ((gdouble) 0, (gdouble) (_tmp21_ + _tmp23_), (gdouble) 0, (gdouble) ((_tmp25_ + _tmp27_) + radius));
#line 522 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	lr = _tmp28_;
#line 524 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	cairo_pattern_add_color_stop_rgba (lr, 0.0, rgb_all, rgb_all, rgb_all, (gdouble) initial_alpha);
#line 525 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	cairo_pattern_add_color_stop_rgba (lr, 1.0, rgb_all, rgb_all, rgb_all, 0.0);
#line 526 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	cairo_set_source (ctx, lr);
#line 527 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp29_ = *origin;
#line 527 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp30_ = _tmp29_.x;
#line 527 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp31_ = *origin;
#line 527 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp32_ = _tmp31_.y;
#line 527 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp33_ = *dimensions;
#line 527 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp34_ = _tmp33_.height;
#line 527 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp35_ = *dimensions;
#line 527 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp36_ = _tmp35_.width;
#line 527 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	cairo_rectangle (ctx, (gdouble) (_tmp30_ + radius), (gdouble) (_tmp32_ + _tmp34_), (gdouble) (_tmp36_ - radius), (gdouble) radius);
#line 528 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	cairo_fill (ctx);
#line 531 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp37_ = *origin;
#line 531 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp38_ = _tmp37_.x;
#line 531 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp39_ = *dimensions;
#line 531 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp40_ = _tmp39_.width;
#line 531 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp41_ = *origin;
#line 531 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp42_ = _tmp41_.x;
#line 531 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp43_ = *dimensions;
#line 531 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp44_ = _tmp43_.width;
#line 531 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp45_ = cairo_pattern_create_linear ((gdouble) (_tmp38_ + _tmp40_), (gdouble) 0, (gdouble) ((_tmp42_ + _tmp44_) + radius), (gdouble) 0);
#line 531 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	td = _tmp45_;
#line 533 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	cairo_pattern_add_color_stop_rgba (td, 0.0, rgb_all, rgb_all, rgb_all, (gdouble) initial_alpha);
#line 534 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	cairo_pattern_add_color_stop_rgba (td, 1.0, rgb_all, rgb_all, rgb_all, 0.0);
#line 535 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	cairo_set_source (ctx, td);
#line 536 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp46_ = *origin;
#line 536 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp47_ = _tmp46_.x;
#line 536 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp48_ = *dimensions;
#line 536 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp49_ = _tmp48_.width;
#line 536 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp50_ = *origin;
#line 536 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp51_ = _tmp50_.y;
#line 536 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp52_ = *dimensions;
#line 536 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp53_ = _tmp52_.height;
#line 536 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	cairo_rectangle (ctx, (gdouble) (_tmp47_ + _tmp49_), (gdouble) (_tmp51_ + radius), (gdouble) radius, (gdouble) (_tmp53_ - radius));
#line 538 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	cairo_fill (ctx);
#line 507 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_cairo_pattern_destroy0 (td);
#line 507 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_cairo_pattern_destroy0 (lr);
#line 3682 "CheckerboardLayout.c"
}


void
checkerboard_item_paint_shadow (CheckerboardItem* self,
                                cairo_t* ctx,
                                Dimensions* dimensions,
                                GdkPoint* origin,
                                gint radius,
                                gfloat initial_alpha)
{
#line 507 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (IS_CHECKERBOARD_ITEM (self));
#line 507 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	CHECKERBOARD_ITEM_GET_CLASS (self)->paint_shadow (self, ctx, dimensions, origin, radius, initial_alpha);
#line 3698 "CheckerboardLayout.c"
}


void
checkerboard_item_paint_shadow_in_corner (CheckerboardItem* self,
                                          cairo_t* ctx,
                                          gint x,
                                          gint y,
                                          gdouble rgb_all,
                                          gfloat radius,
                                          gfloat initial_alpha,
                                          gdouble arc1,
                                          gdouble arc2)
{
	cairo_pattern_t* p = NULL;
	cairo_pattern_t* _tmp0_;
#line 541 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (IS_CHECKERBOARD_ITEM (self));
#line 541 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (ctx != NULL);
#line 543 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = cairo_pattern_create_radial ((gdouble) x, (gdouble) y, (gdouble) 0, (gdouble) x, (gdouble) y, (gdouble) radius);
#line 543 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	p = _tmp0_;
#line 544 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	cairo_pattern_add_color_stop_rgba (p, 0.0, rgb_all, rgb_all, rgb_all, (gdouble) initial_alpha);
#line 545 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	cairo_pattern_add_color_stop_rgba (p, 1.0, rgb_all, rgb_all, rgb_all, (gdouble) 0);
#line 546 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	cairo_set_source (ctx, p);
#line 547 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	cairo_move_to (ctx, (gdouble) x, (gdouble) y);
#line 548 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	cairo_arc (ctx, (gdouble) x, (gdouble) y, (gdouble) radius, arc1, arc2);
#line 549 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	cairo_close_path (ctx);
#line 550 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	cairo_fill (ctx);
#line 541 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_cairo_pattern_destroy0 (p);
#line 3739 "CheckerboardLayout.c"
}


static void
checkerboard_item_real_paint_border (CheckerboardItem* self,
                                     cairo_t* ctx,
                                     Dimensions* object_dimensions,
                                     GdkPoint* object_origin,
                                     gint border_width)
{
#line 553 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (ctx != NULL);
#line 553 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (object_dimensions != NULL);
#line 553 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (object_origin != NULL);
#line 555 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (border_width == 1) {
#line 3758 "CheckerboardLayout.c"
		GdkPoint _tmp0_;
		gint _tmp1_;
		GdkPoint _tmp2_;
		gint _tmp3_;
		Dimensions _tmp4_;
		gint _tmp5_;
		Dimensions _tmp6_;
		gint _tmp7_;
#line 556 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp0_ = *object_origin;
#line 556 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp1_ = _tmp0_.x;
#line 556 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp2_ = *object_origin;
#line 556 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp3_ = _tmp2_.y;
#line 556 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp4_ = *object_dimensions;
#line 556 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp5_ = _tmp4_.width;
#line 556 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp6_ = *object_dimensions;
#line 556 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp7_ = _tmp6_.height;
#line 556 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		cairo_rectangle (ctx, (gdouble) (_tmp1_ - border_width), (gdouble) (_tmp3_ - border_width), (gdouble) (_tmp5_ + (border_width * 2)), (gdouble) (_tmp7_ + (border_width * 2)));
#line 559 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		cairo_fill (ctx);
#line 3787 "CheckerboardLayout.c"
	} else {
		Dimensions dimensions = {0};
		Dimensions _tmp8_;
		Dimensions _tmp9_ = {0};
		GdkPoint origin = {0};
		GdkPoint _tmp10_;
		GdkPoint _tmp11_ = {0};
		gdouble scale = 0.0;
		Dimensions _tmp12_;
		gint _tmp13_;
		Dimensions _tmp14_;
		gint _tmp15_;
		Dimensions _tmp16_;
		GdkPoint _tmp17_;
		gdouble _tmp18_;
#line 561 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp8_ = *object_dimensions;
#line 561 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		checkerboard_item_get_border_dimensions (&_tmp8_, border_width, &_tmp9_);
#line 561 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		dimensions = _tmp9_;
#line 562 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp10_ = *object_origin;
#line 562 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		checkerboard_item_get_border_origin (&_tmp10_, border_width, &_tmp11_);
#line 562 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		origin = _tmp11_;
#line 565 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp12_ = *object_dimensions;
#line 565 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp13_ = _tmp12_.width;
#line 565 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp14_ = *object_dimensions;
#line 565 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp15_ = _tmp14_.height;
#line 565 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		scale = (gdouble) MAX (_tmp13_, _tmp15_);
#line 566 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp16_ = dimensions;
#line 566 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp17_ = origin;
#line 566 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp18_ = scale;
#line 566 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		draw_rounded_corners_filled (ctx, &_tmp16_, &_tmp17_, 0.25 * _tmp18_);
#line 3833 "CheckerboardLayout.c"
	}
}


void
checkerboard_item_paint_border (CheckerboardItem* self,
                                cairo_t* ctx,
                                Dimensions* object_dimensions,
                                GdkPoint* object_origin,
                                gint border_width)
{
#line 553 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (IS_CHECKERBOARD_ITEM (self));
#line 553 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	CHECKERBOARD_ITEM_GET_CLASS (self)->paint_border (self, ctx, object_dimensions, object_origin, border_width);
#line 3849 "CheckerboardLayout.c"
}


static void
checkerboard_item_real_paint_image (CheckerboardItem* self,
                                    cairo_t* ctx,
                                    GdkPixbuf* pixbuf,
                                    GdkPoint* origin)
{
	GdkPoint _tmp0_;
	gint _tmp1_;
	GdkPoint _tmp2_;
	gint _tmp3_;
#line 570 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (ctx != NULL);
#line 570 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (GDK_IS_PIXBUF (pixbuf));
#line 570 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (origin != NULL);
#line 571 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = *origin;
#line 571 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = _tmp0_.x;
#line 571 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp2_ = *origin;
#line 571 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp3_ = _tmp2_.y;
#line 571 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	paint_pixmap_with_background (ctx, pixbuf, _tmp1_, _tmp3_);
#line 3879 "CheckerboardLayout.c"
}


void
checkerboard_item_paint_image (CheckerboardItem* self,
                               cairo_t* ctx,
                               GdkPixbuf* pixbuf,
                               GdkPoint* origin)
{
#line 570 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (IS_CHECKERBOARD_ITEM (self));
#line 570 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	CHECKERBOARD_ITEM_GET_CLASS (self)->paint_image (self, ctx, pixbuf, origin);
#line 3893 "CheckerboardLayout.c"
}


static gint
checkerboard_item_get_selection_border_width (CheckerboardItem* self,
                                              gint scale)
{
	gint result = 0;
	gint _tmp0_ = 0;
	gint _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
#line 574 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_val_if_fail (IS_CHECKERBOARD_ITEM (self), 0);
#line 575 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = thumbnail_get_MIN_SCALE ();
#line 575 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp2_ = _tmp1_;
#line 575 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp3_ = thumbnail_get_MAX_SCALE ();
#line 575 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp4_ = _tmp3_;
#line 575 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (scale <= ((_tmp2_ + _tmp4_) / 3)) {
#line 575 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp0_ = 2;
#line 3921 "CheckerboardLayout.c"
	} else {
#line 575 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp0_ = 3;
#line 3925 "CheckerboardLayout.c"
	}
#line 575 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	result = _tmp0_ + CHECKERBOARD_ITEM_BORDER_WIDTH;
#line 575 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return result;
#line 3931 "CheckerboardLayout.c"
}


static GdkPixbuf*
checkerboard_item_real_get_top_left_trinket (CheckerboardItem* self,
                                             gint scale)
{
	GdkPixbuf* result = NULL;
#line 580 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	result = NULL;
#line 580 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return result;
#line 3944 "CheckerboardLayout.c"
}


GdkPixbuf*
checkerboard_item_get_top_left_trinket (CheckerboardItem* self,
                                        gint scale)
{
#line 579 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_val_if_fail (IS_CHECKERBOARD_ITEM (self), NULL);
#line 579 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return CHECKERBOARD_ITEM_GET_CLASS (self)->get_top_left_trinket (self, scale);
#line 3956 "CheckerboardLayout.c"
}


static GdkPixbuf*
checkerboard_item_real_get_top_right_trinket (CheckerboardItem* self,
                                              gint scale)
{
	GdkPixbuf* result = NULL;
#line 584 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	result = NULL;
#line 584 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return result;
#line 3969 "CheckerboardLayout.c"
}


GdkPixbuf*
checkerboard_item_get_top_right_trinket (CheckerboardItem* self,
                                         gint scale)
{
#line 583 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_val_if_fail (IS_CHECKERBOARD_ITEM (self), NULL);
#line 583 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return CHECKERBOARD_ITEM_GET_CLASS (self)->get_top_right_trinket (self, scale);
#line 3981 "CheckerboardLayout.c"
}


static GdkPixbuf*
checkerboard_item_real_get_bottom_left_trinket (CheckerboardItem* self,
                                                gint scale)
{
	GdkPixbuf* result = NULL;
#line 588 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	result = NULL;
#line 588 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return result;
#line 3994 "CheckerboardLayout.c"
}


GdkPixbuf*
checkerboard_item_get_bottom_left_trinket (CheckerboardItem* self,
                                           gint scale)
{
#line 587 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_val_if_fail (IS_CHECKERBOARD_ITEM (self), NULL);
#line 587 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return CHECKERBOARD_ITEM_GET_CLASS (self)->get_bottom_left_trinket (self, scale);
#line 4006 "CheckerboardLayout.c"
}


static GdkPixbuf*
checkerboard_item_real_get_bottom_right_trinket (CheckerboardItem* self,
                                                 gint scale)
{
	GdkPixbuf* result = NULL;
#line 592 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	result = NULL;
#line 592 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return result;
#line 4019 "CheckerboardLayout.c"
}


GdkPixbuf*
checkerboard_item_get_bottom_right_trinket (CheckerboardItem* self,
                                            gint scale)
{
#line 591 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_val_if_fail (IS_CHECKERBOARD_ITEM (self), NULL);
#line 591 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return CHECKERBOARD_ITEM_GET_CLASS (self)->get_bottom_right_trinket (self, scale);
#line 4031 "CheckerboardLayout.c"
}


void
checkerboard_item_paint (CheckerboardItem* self,
                         cairo_t* ctx,
                         GdkRGBA* bg_color,
                         GdkRGBA* selected_color,
                         GdkRGBA* text_color,
                         GdkRGBA* border_color)
{
	GdkRectangle _tmp0_;
	gint _tmp1_;
	GdkRectangle _tmp2_;
	gint _tmp3_;
	GdkPoint pixbuf_origin = {0};
	GdkRGBA _tmp4_;
	gdouble _tmp5_;
	GdkRGBA _tmp6_;
	gdouble _tmp7_;
	GdkRGBA _tmp8_;
	gdouble _tmp9_;
	GdkRGBA _tmp10_;
	gdouble _tmp11_;
	gboolean _tmp18_;
	GdkPixbuf* _tmp41_;
	GdkRGBA _tmp52_;
	gdouble _tmp53_;
	GdkRGBA _tmp54_;
	gdouble _tmp55_;
	GdkRGBA _tmp56_;
	gdouble _tmp57_;
	GdkRGBA _tmp58_;
	gdouble _tmp59_;
	gint text_y = 0;
	Dimensions _tmp60_;
	gint _tmp61_;
	gboolean _tmp62_ = FALSE;
	CheckerboardItemText* _tmp63_;
	gboolean _tmp86_ = FALSE;
	CheckerboardItemText* _tmp87_;
	gboolean _tmp110_ = FALSE;
	CheckerboardItemText* _tmp111_;
	GdkRGBA _tmp132_;
	gdouble _tmp133_;
	GdkRGBA _tmp134_;
	gdouble _tmp135_;
	GdkRGBA _tmp136_;
	gdouble _tmp137_;
	GdkRGBA _tmp138_;
	gdouble _tmp139_;
	GdkPixbuf* trinket = NULL;
	GdkPixbuf* _tmp140_;
	GdkPixbuf* _tmp141_;
	GdkPixbuf* _tmp156_;
	GdkPixbuf* _tmp157_;
	GdkPixbuf* _tmp169_;
	GdkPixbuf* _tmp170_;
	GdkPixbuf* _tmp187_;
	GdkPixbuf* _tmp188_;
#line 595 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (IS_CHECKERBOARD_ITEM (self));
#line 595 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (ctx != NULL);
#line 595 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (bg_color != NULL);
#line 595 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (selected_color != NULL);
#line 595 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (text_color != NULL);
#line 597 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	cairo_save (ctx);
#line 598 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = self->allocation;
#line 598 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = _tmp0_.x;
#line 598 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp2_ = self->allocation;
#line 598 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp3_ = _tmp2_.y;
#line 598 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	cairo_translate (ctx, (gdouble) (_tmp1_ + CHECKERBOARD_ITEM_FRAME_WIDTH), (gdouble) (_tmp3_ + CHECKERBOARD_ITEM_FRAME_WIDTH));
#line 601 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	memset (&pixbuf_origin, 0, sizeof (GdkPoint));
#line 602 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	pixbuf_origin.x = CHECKERBOARD_ITEM_BORDER_WIDTH;
#line 603 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	pixbuf_origin.y = CHECKERBOARD_ITEM_BORDER_WIDTH;
#line 605 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	cairo_set_line_width (ctx, (gdouble) CHECKERBOARD_ITEM_FRAME_WIDTH);
#line 606 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp4_ = *selected_color;
#line 606 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp5_ = _tmp4_.red;
#line 606 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp6_ = *selected_color;
#line 606 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp7_ = _tmp6_.green;
#line 606 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp8_ = *selected_color;
#line 606 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp9_ = _tmp8_.blue;
#line 606 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp10_ = *selected_color;
#line 606 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp11_ = _tmp10_.alpha;
#line 606 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	cairo_set_source_rgba (ctx, _tmp5_, _tmp7_, _tmp9_, _tmp11_);
#line 610 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (border_color != NULL) {
#line 4142 "CheckerboardLayout.c"
		Dimensions shadow_dim = {0};
		Dimensions _tmp12_;
		gint _tmp13_;
		Dimensions _tmp14_;
		gint _tmp15_;
		Dimensions _tmp16_;
		GdkPoint _tmp17_;
#line 611 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		cairo_save (ctx);
#line 612 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		dimensions_init (&shadow_dim, 0, 0);
#line 613 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp12_ = self->priv->pixbuf_dim;
#line 613 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp13_ = _tmp12_.width;
#line 613 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		shadow_dim.width = _tmp13_ + CHECKERBOARD_ITEM_BORDER_WIDTH;
#line 614 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp14_ = self->priv->pixbuf_dim;
#line 614 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp15_ = _tmp14_.height;
#line 614 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		shadow_dim.height = _tmp15_ + CHECKERBOARD_ITEM_BORDER_WIDTH;
#line 615 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp16_ = shadow_dim;
#line 615 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp17_ = pixbuf_origin;
#line 615 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		checkerboard_item_paint_shadow (self, ctx, &_tmp16_, &_tmp17_, CHECKERBOARD_ITEM_SHADOW_RADIUS, CHECKERBOARD_ITEM_SHADOW_INITIAL_ALPHA);
#line 616 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		cairo_restore (ctx);
#line 4174 "CheckerboardLayout.c"
	}
#line 620 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp18_ = self->priv->is_cursor;
#line 620 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp18_) {
#line 4180 "CheckerboardLayout.c"
		gdouble _tmp19_;
		gdouble _tmp20_;
		gdouble _tmp21_;
		gdouble _tmp22_;
		Dimensions _tmp23_;
		GdkPoint _tmp24_;
		Dimensions _tmp25_;
		gint _tmp26_;
		Dimensions _tmp27_;
		gint _tmp28_;
#line 621 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		cairo_save (ctx);
#line 622 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp19_ = (*border_color).red;
#line 622 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp20_ = (*border_color).green;
#line 622 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp21_ = (*border_color).blue;
#line 622 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp22_ = (*border_color).alpha;
#line 622 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		cairo_set_source_rgba (ctx, _tmp19_, _tmp20_, _tmp21_, _tmp22_);
#line 624 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp23_ = self->priv->pixbuf_dim;
#line 624 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp24_ = pixbuf_origin;
#line 624 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp25_ = self->priv->pixbuf_dim;
#line 624 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp26_ = _tmp25_.width;
#line 624 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp27_ = self->priv->pixbuf_dim;
#line 624 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp28_ = _tmp27_.height;
#line 624 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		checkerboard_item_paint_border (self, ctx, &_tmp23_, &_tmp24_, checkerboard_item_get_selection_border_width (self, MAX (_tmp26_, _tmp28_)));
#line 626 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		cairo_restore (ctx);
#line 4219 "CheckerboardLayout.c"
	}
#line 630 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (data_view_is_selected (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_VIEW, DataView))) {
#line 4223 "CheckerboardLayout.c"
		Dimensions _tmp29_;
		GdkPoint _tmp30_;
		Dimensions _tmp31_;
		gint _tmp32_;
		Dimensions _tmp33_;
		gint _tmp34_;
#line 632 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		cairo_save (ctx);
#line 633 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp29_ = self->priv->pixbuf_dim;
#line 633 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp30_ = pixbuf_origin;
#line 633 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp31_ = self->priv->pixbuf_dim;
#line 633 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp32_ = _tmp31_.width;
#line 633 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp33_ = self->priv->pixbuf_dim;
#line 633 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp34_ = _tmp33_.height;
#line 633 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		checkerboard_item_paint_border (self, ctx, &_tmp29_, &_tmp30_, checkerboard_item_get_selection_border_width (self, MAX (_tmp32_, _tmp34_)));
#line 635 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		cairo_restore (ctx);
#line 4248 "CheckerboardLayout.c"
	}
#line 639 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (border_color != NULL) {
#line 4252 "CheckerboardLayout.c"
		gdouble _tmp35_;
		gdouble _tmp36_;
		gdouble _tmp37_;
		gdouble _tmp38_;
		Dimensions _tmp39_;
		GdkPoint _tmp40_;
#line 640 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		cairo_save (ctx);
#line 641 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp35_ = (*border_color).red;
#line 641 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp36_ = (*border_color).green;
#line 641 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp37_ = (*border_color).blue;
#line 641 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp38_ = (*border_color).alpha;
#line 641 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		cairo_set_source_rgba (ctx, _tmp35_, _tmp36_, _tmp37_, _tmp38_);
#line 643 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp39_ = self->priv->pixbuf_dim;
#line 643 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp40_ = pixbuf_origin;
#line 643 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		checkerboard_item_paint_border (self, ctx, &_tmp39_, &_tmp40_, CHECKERBOARD_ITEM_BORDER_WIDTH);
#line 644 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		cairo_restore (ctx);
#line 4279 "CheckerboardLayout.c"
	}
#line 647 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp41_ = self->priv->display_pixbuf;
#line 647 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp41_ != NULL) {
#line 4285 "CheckerboardLayout.c"
		GdkRGBA _tmp42_;
		gdouble _tmp43_;
		GdkRGBA _tmp44_;
		gdouble _tmp45_;
		GdkRGBA _tmp46_;
		gdouble _tmp47_;
		GdkRGBA _tmp48_;
		gdouble _tmp49_;
		GdkPixbuf* _tmp50_;
		GdkPoint _tmp51_;
#line 648 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		cairo_save (ctx);
#line 649 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp42_ = *bg_color;
#line 649 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp43_ = _tmp42_.red;
#line 649 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp44_ = *bg_color;
#line 649 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp45_ = _tmp44_.green;
#line 649 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp46_ = *bg_color;
#line 649 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp47_ = _tmp46_.blue;
#line 649 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp48_ = *bg_color;
#line 649 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp49_ = _tmp48_.alpha;
#line 649 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		cairo_set_source_rgba (ctx, _tmp43_, _tmp45_, _tmp47_, _tmp49_);
#line 650 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp50_ = self->priv->display_pixbuf;
#line 650 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp51_ = pixbuf_origin;
#line 650 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		checkerboard_item_paint_image (self, ctx, _tmp50_, &_tmp51_);
#line 651 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		cairo_restore (ctx);
#line 4324 "CheckerboardLayout.c"
	}
#line 654 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp52_ = *text_color;
#line 654 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp53_ = _tmp52_.red;
#line 654 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp54_ = *text_color;
#line 654 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp55_ = _tmp54_.green;
#line 654 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp56_ = *text_color;
#line 654 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp57_ = _tmp56_.blue;
#line 654 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp58_ = *text_color;
#line 654 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp59_ = _tmp58_.alpha;
#line 654 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	cairo_set_source_rgba (ctx, _tmp53_, _tmp55_, _tmp57_, _tmp59_);
#line 657 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp60_ = self->priv->pixbuf_dim;
#line 657 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp61_ = _tmp60_.height;
#line 657 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	text_y = (_tmp61_ + CHECKERBOARD_ITEM_FRAME_WIDTH) + CHECKERBOARD_ITEM_LABEL_PADDING;
#line 658 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp63_ = self->priv->title;
#line 658 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp63_ != NULL) {
#line 4354 "CheckerboardLayout.c"
		gboolean _tmp64_;
#line 658 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp64_ = self->priv->title_visible;
#line 658 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp62_ = _tmp64_;
#line 4360 "CheckerboardLayout.c"
	} else {
#line 658 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp62_ = FALSE;
#line 4364 "CheckerboardLayout.c"
	}
#line 658 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp62_) {
#line 4368 "CheckerboardLayout.c"
		CheckerboardItemText* _tmp65_;
		CheckerboardItemText* _tmp66_;
		gint _tmp67_;
		CheckerboardItemText* _tmp68_;
		Dimensions _tmp69_;
		gint _tmp70_;
		CheckerboardItemText* _tmp71_;
		CheckerboardItemText* _tmp72_;
		CheckerboardItemText* _tmp73_;
		GdkRectangle _tmp74_;
		gint _tmp75_;
		CheckerboardItemText* _tmp76_;
		GdkRectangle _tmp77_;
		gint _tmp78_;
		CheckerboardItemText* _tmp79_;
		Dimensions _tmp80_;
		gint _tmp81_;
		PangoLayout* _tmp82_;
		PangoLayout* _tmp83_;
		gint _tmp84_;
		CheckerboardItemText* _tmp85_;
#line 661 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp65_ = self->priv->title;
#line 661 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp65_->allocation.x = 0;
#line 662 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp66_ = self->priv->title;
#line 662 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp67_ = text_y;
#line 662 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp66_->allocation.y = _tmp67_;
#line 663 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp68_ = self->priv->title;
#line 663 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp69_ = self->priv->pixbuf_dim;
#line 663 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp70_ = _tmp69_.width;
#line 663 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp68_->allocation.width = _tmp70_;
#line 664 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp71_ = self->priv->title;
#line 664 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp72_ = self->priv->title;
#line 664 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp71_->allocation.height = checkerboard_item_text_get_height (_tmp72_);
#line 666 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp73_ = self->priv->title;
#line 666 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp74_ = _tmp73_->allocation;
#line 666 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp75_ = _tmp74_.x;
#line 666 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp76_ = self->priv->title;
#line 666 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp77_ = _tmp76_->allocation;
#line 666 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp78_ = _tmp77_.y;
#line 666 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		cairo_move_to (ctx, (gdouble) _tmp75_, (gdouble) _tmp78_);
#line 667 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp79_ = self->priv->title;
#line 667 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp80_ = self->priv->pixbuf_dim;
#line 667 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp81_ = _tmp80_.width;
#line 667 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp82_ = checkerboard_item_text_get_pango_layout (_tmp79_, _tmp81_);
#line 667 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp83_ = _tmp82_;
#line 667 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		pango_cairo_show_layout (ctx, _tmp83_);
#line 667 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_g_object_unref0 (_tmp83_);
#line 669 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp84_ = text_y;
#line 669 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp85_ = self->priv->title;
#line 669 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		text_y = _tmp84_ + (checkerboard_item_text_get_height (_tmp85_) + CHECKERBOARD_ITEM_LABEL_PADDING);
#line 4448 "CheckerboardLayout.c"
	}
#line 672 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp87_ = self->priv->comment;
#line 672 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp87_ != NULL) {
#line 4454 "CheckerboardLayout.c"
		gboolean _tmp88_;
#line 672 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp88_ = self->priv->comment_visible;
#line 672 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp86_ = _tmp88_;
#line 4460 "CheckerboardLayout.c"
	} else {
#line 672 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp86_ = FALSE;
#line 4464 "CheckerboardLayout.c"
	}
#line 672 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp86_) {
#line 4468 "CheckerboardLayout.c"
		CheckerboardItemText* _tmp89_;
		CheckerboardItemText* _tmp90_;
		gint _tmp91_;
		CheckerboardItemText* _tmp92_;
		Dimensions _tmp93_;
		gint _tmp94_;
		CheckerboardItemText* _tmp95_;
		CheckerboardItemText* _tmp96_;
		CheckerboardItemText* _tmp97_;
		GdkRectangle _tmp98_;
		gint _tmp99_;
		CheckerboardItemText* _tmp100_;
		GdkRectangle _tmp101_;
		gint _tmp102_;
		CheckerboardItemText* _tmp103_;
		Dimensions _tmp104_;
		gint _tmp105_;
		PangoLayout* _tmp106_;
		PangoLayout* _tmp107_;
		gint _tmp108_;
		CheckerboardItemText* _tmp109_;
#line 673 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp89_ = self->priv->comment;
#line 673 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp89_->allocation.x = 0;
#line 674 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp90_ = self->priv->comment;
#line 674 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp91_ = text_y;
#line 674 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp90_->allocation.y = _tmp91_;
#line 675 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp92_ = self->priv->comment;
#line 675 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp93_ = self->priv->pixbuf_dim;
#line 675 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp94_ = _tmp93_.width;
#line 675 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp92_->allocation.width = _tmp94_;
#line 676 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp95_ = self->priv->comment;
#line 676 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp96_ = self->priv->comment;
#line 676 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp95_->allocation.height = checkerboard_item_text_get_height (_tmp96_);
#line 678 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp97_ = self->priv->comment;
#line 678 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp98_ = _tmp97_->allocation;
#line 678 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp99_ = _tmp98_.x;
#line 678 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp100_ = self->priv->comment;
#line 678 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp101_ = _tmp100_->allocation;
#line 678 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp102_ = _tmp101_.y;
#line 678 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		cairo_move_to (ctx, (gdouble) _tmp99_, (gdouble) _tmp102_);
#line 679 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp103_ = self->priv->comment;
#line 679 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp104_ = self->priv->pixbuf_dim;
#line 679 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp105_ = _tmp104_.width;
#line 679 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp106_ = checkerboard_item_text_get_pango_layout (_tmp103_, _tmp105_);
#line 679 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp107_ = _tmp106_;
#line 679 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		pango_cairo_show_layout (ctx, _tmp107_);
#line 679 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_g_object_unref0 (_tmp107_);
#line 681 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp108_ = text_y;
#line 681 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp109_ = self->priv->comment;
#line 681 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		text_y = _tmp108_ + (checkerboard_item_text_get_height (_tmp109_) + CHECKERBOARD_ITEM_LABEL_PADDING);
#line 4548 "CheckerboardLayout.c"
	}
#line 684 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp111_ = self->priv->subtitle;
#line 684 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp111_ != NULL) {
#line 4554 "CheckerboardLayout.c"
		gboolean _tmp112_;
#line 684 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp112_ = self->priv->subtitle_visible;
#line 684 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp110_ = _tmp112_;
#line 4560 "CheckerboardLayout.c"
	} else {
#line 684 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp110_ = FALSE;
#line 4564 "CheckerboardLayout.c"
	}
#line 684 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp110_) {
#line 4568 "CheckerboardLayout.c"
		CheckerboardItemText* _tmp113_;
		CheckerboardItemText* _tmp114_;
		gint _tmp115_;
		CheckerboardItemText* _tmp116_;
		Dimensions _tmp117_;
		gint _tmp118_;
		CheckerboardItemText* _tmp119_;
		CheckerboardItemText* _tmp120_;
		CheckerboardItemText* _tmp121_;
		GdkRectangle _tmp122_;
		gint _tmp123_;
		CheckerboardItemText* _tmp124_;
		GdkRectangle _tmp125_;
		gint _tmp126_;
		CheckerboardItemText* _tmp127_;
		Dimensions _tmp128_;
		gint _tmp129_;
		PangoLayout* _tmp130_;
		PangoLayout* _tmp131_;
#line 685 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp113_ = self->priv->subtitle;
#line 685 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp113_->allocation.x = 0;
#line 686 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp114_ = self->priv->subtitle;
#line 686 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp115_ = text_y;
#line 686 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp114_->allocation.y = _tmp115_;
#line 687 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp116_ = self->priv->subtitle;
#line 687 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp117_ = self->priv->pixbuf_dim;
#line 687 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp118_ = _tmp117_.width;
#line 687 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp116_->allocation.width = _tmp118_;
#line 688 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp119_ = self->priv->subtitle;
#line 688 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp120_ = self->priv->subtitle;
#line 688 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp119_->allocation.height = checkerboard_item_text_get_height (_tmp120_);
#line 690 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp121_ = self->priv->subtitle;
#line 690 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp122_ = _tmp121_->allocation;
#line 690 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp123_ = _tmp122_.x;
#line 690 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp124_ = self->priv->subtitle;
#line 690 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp125_ = _tmp124_->allocation;
#line 690 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp126_ = _tmp125_.y;
#line 690 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		cairo_move_to (ctx, (gdouble) _tmp123_, (gdouble) _tmp126_);
#line 691 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp127_ = self->priv->subtitle;
#line 691 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp128_ = self->priv->pixbuf_dim;
#line 691 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp129_ = _tmp128_.width;
#line 691 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp130_ = checkerboard_item_text_get_pango_layout (_tmp127_, _tmp129_);
#line 691 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp131_ = _tmp130_;
#line 691 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		pango_cairo_show_layout (ctx, _tmp131_);
#line 691 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_g_object_unref0 (_tmp131_);
#line 4640 "CheckerboardLayout.c"
	}
#line 696 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp132_ = *selected_color;
#line 696 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp133_ = _tmp132_.red;
#line 696 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp134_ = *selected_color;
#line 696 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp135_ = _tmp134_.green;
#line 696 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp136_ = *selected_color;
#line 696 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp137_ = _tmp136_.blue;
#line 696 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp138_ = *selected_color;
#line 696 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp139_ = _tmp138_.alpha;
#line 696 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	cairo_set_source_rgba (ctx, _tmp133_, _tmp135_, _tmp137_, _tmp139_);
#line 700 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp140_ = checkerboard_item_get_bottom_left_trinket (self, CHECKERBOARD_ITEM_TRINKET_SCALE);
#line 700 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	trinket = _tmp140_;
#line 701 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp141_ = trinket;
#line 701 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp141_ != NULL) {
#line 4668 "CheckerboardLayout.c"
		gint x = 0;
		GdkPoint _tmp142_;
		gint _tmp143_;
		gint y = 0;
		GdkPoint _tmp144_;
		gint _tmp145_;
		Dimensions _tmp146_;
		gint _tmp147_;
		GdkPixbuf* _tmp148_;
		GdkPixbuf* _tmp149_;
		gint _tmp150_;
		gint _tmp151_;
		gint _tmp152_;
		gint _tmp153_;
		GdkPixbuf* _tmp154_;
		GdkPixbuf* _tmp155_;
#line 702 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp142_ = pixbuf_origin;
#line 702 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp143_ = _tmp142_.x;
#line 702 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		x = (_tmp143_ + CHECKERBOARD_ITEM_TRINKET_PADDING) + checkerboard_item_get_horizontal_trinket_offset (self);
#line 703 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp144_ = pixbuf_origin;
#line 703 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp145_ = _tmp144_.y;
#line 703 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp146_ = self->priv->pixbuf_dim;
#line 703 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp147_ = _tmp146_.height;
#line 703 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp148_ = trinket;
#line 703 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		y = ((_tmp145_ + _tmp147_) - gdk_pixbuf_get_height (_tmp148_)) - CHECKERBOARD_ITEM_TRINKET_PADDING;
#line 705 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp149_ = trinket;
#line 705 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp150_ = x;
#line 705 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp151_ = y;
#line 705 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		gdk_cairo_set_source_pixbuf (ctx, _tmp149_, (gdouble) _tmp150_, (gdouble) _tmp151_);
#line 706 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp152_ = x;
#line 706 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp153_ = y;
#line 706 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp154_ = trinket;
#line 706 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp155_ = trinket;
#line 706 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		cairo_rectangle (ctx, (gdouble) _tmp152_, (gdouble) _tmp153_, (gdouble) gdk_pixbuf_get_width (_tmp154_), (gdouble) gdk_pixbuf_get_height (_tmp155_));
#line 707 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		cairo_fill (ctx);
#line 4723 "CheckerboardLayout.c"
	}
#line 710 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp156_ = checkerboard_item_get_top_left_trinket (self, CHECKERBOARD_ITEM_TRINKET_SCALE);
#line 710 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_g_object_unref0 (trinket);
#line 710 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	trinket = _tmp156_;
#line 711 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp157_ = trinket;
#line 711 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp157_ != NULL) {
#line 4735 "CheckerboardLayout.c"
		gint x = 0;
		GdkPoint _tmp158_;
		gint _tmp159_;
		gint y = 0;
		GdkPoint _tmp160_;
		gint _tmp161_;
		GdkPixbuf* _tmp162_;
		gint _tmp163_;
		gint _tmp164_;
		gint _tmp165_;
		gint _tmp166_;
		GdkPixbuf* _tmp167_;
		GdkPixbuf* _tmp168_;
#line 712 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp158_ = pixbuf_origin;
#line 712 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp159_ = _tmp158_.x;
#line 712 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		x = (_tmp159_ + CHECKERBOARD_ITEM_TRINKET_PADDING) + checkerboard_item_get_horizontal_trinket_offset (self);
#line 713 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp160_ = pixbuf_origin;
#line 713 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp161_ = _tmp160_.y;
#line 713 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		y = _tmp161_ + CHECKERBOARD_ITEM_TRINKET_PADDING;
#line 714 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp162_ = trinket;
#line 714 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp163_ = x;
#line 714 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp164_ = y;
#line 714 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		gdk_cairo_set_source_pixbuf (ctx, _tmp162_, (gdouble) _tmp163_, (gdouble) _tmp164_);
#line 715 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp165_ = x;
#line 715 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp166_ = y;
#line 715 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp167_ = trinket;
#line 715 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp168_ = trinket;
#line 715 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		cairo_rectangle (ctx, (gdouble) _tmp165_, (gdouble) _tmp166_, (gdouble) gdk_pixbuf_get_width (_tmp167_), (gdouble) gdk_pixbuf_get_height (_tmp168_));
#line 716 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		cairo_fill (ctx);
#line 4781 "CheckerboardLayout.c"
	}
#line 719 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp169_ = checkerboard_item_get_top_right_trinket (self, CHECKERBOARD_ITEM_TRINKET_SCALE);
#line 719 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_g_object_unref0 (trinket);
#line 719 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	trinket = _tmp169_;
#line 720 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp170_ = trinket;
#line 720 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp170_ != NULL) {
#line 4793 "CheckerboardLayout.c"
		gint x = 0;
		GdkPoint _tmp171_;
		gint _tmp172_;
		Dimensions _tmp173_;
		gint _tmp174_;
		GdkPixbuf* _tmp175_;
		gint _tmp176_;
		gint _tmp177_;
		gint y = 0;
		GdkPoint _tmp178_;
		gint _tmp179_;
		GdkPixbuf* _tmp180_;
		gint _tmp181_;
		gint _tmp182_;
		gint _tmp183_;
		gint _tmp184_;
		GdkPixbuf* _tmp185_;
		GdkPixbuf* _tmp186_;
#line 721 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp171_ = pixbuf_origin;
#line 721 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp172_ = _tmp171_.x;
#line 721 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp173_ = self->priv->pixbuf_dim;
#line 721 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp174_ = _tmp173_.width;
#line 721 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp175_ = trinket;
#line 721 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp176_ = gdk_pixbuf_get_width (_tmp175_);
#line 721 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp177_ = _tmp176_;
#line 721 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		x = (((_tmp172_ + _tmp174_) - _tmp177_) - checkerboard_item_get_horizontal_trinket_offset (self)) - CHECKERBOARD_ITEM_TRINKET_PADDING;
#line 723 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp178_ = pixbuf_origin;
#line 723 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp179_ = _tmp178_.y;
#line 723 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		y = _tmp179_ + CHECKERBOARD_ITEM_TRINKET_PADDING;
#line 724 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp180_ = trinket;
#line 724 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp181_ = x;
#line 724 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp182_ = y;
#line 724 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		gdk_cairo_set_source_pixbuf (ctx, _tmp180_, (gdouble) _tmp181_, (gdouble) _tmp182_);
#line 725 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp183_ = x;
#line 725 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp184_ = y;
#line 725 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp185_ = trinket;
#line 725 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp186_ = trinket;
#line 725 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		cairo_rectangle (ctx, (gdouble) _tmp183_, (gdouble) _tmp184_, (gdouble) gdk_pixbuf_get_width (_tmp185_), (gdouble) gdk_pixbuf_get_height (_tmp186_));
#line 726 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		cairo_fill (ctx);
#line 4854 "CheckerboardLayout.c"
	}
#line 729 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp187_ = checkerboard_item_get_bottom_right_trinket (self, CHECKERBOARD_ITEM_TRINKET_SCALE);
#line 729 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_g_object_unref0 (trinket);
#line 729 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	trinket = _tmp187_;
#line 730 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp188_ = trinket;
#line 730 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp188_ != NULL) {
#line 4866 "CheckerboardLayout.c"
		gint x = 0;
		GdkPoint _tmp189_;
		gint _tmp190_;
		Dimensions _tmp191_;
		gint _tmp192_;
		GdkPixbuf* _tmp193_;
		gint _tmp194_;
		gint _tmp195_;
		gint y = 0;
		GdkPoint _tmp196_;
		gint _tmp197_;
		Dimensions _tmp198_;
		gint _tmp199_;
		GdkPixbuf* _tmp200_;
		gint _tmp201_;
		gint _tmp202_;
		GdkPixbuf* _tmp203_;
		gint _tmp204_;
		gint _tmp205_;
		gint _tmp206_;
		gint _tmp207_;
		GdkPixbuf* _tmp208_;
		GdkPixbuf* _tmp209_;
#line 731 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp189_ = pixbuf_origin;
#line 731 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp190_ = _tmp189_.x;
#line 731 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp191_ = self->priv->pixbuf_dim;
#line 731 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp192_ = _tmp191_.width;
#line 731 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp193_ = trinket;
#line 731 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp194_ = gdk_pixbuf_get_width (_tmp193_);
#line 731 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp195_ = _tmp194_;
#line 731 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		x = (((_tmp190_ + _tmp192_) - _tmp195_) - checkerboard_item_get_horizontal_trinket_offset (self)) - CHECKERBOARD_ITEM_TRINKET_PADDING;
#line 733 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp196_ = pixbuf_origin;
#line 733 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp197_ = _tmp196_.y;
#line 733 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp198_ = self->priv->pixbuf_dim;
#line 733 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp199_ = _tmp198_.height;
#line 733 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp200_ = trinket;
#line 733 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp201_ = gdk_pixbuf_get_height (_tmp200_);
#line 733 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp202_ = _tmp201_;
#line 733 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		y = ((_tmp197_ + _tmp199_) - _tmp202_) - CHECKERBOARD_ITEM_TRINKET_PADDING;
#line 735 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp203_ = trinket;
#line 735 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp204_ = x;
#line 735 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp205_ = y;
#line 735 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		gdk_cairo_set_source_pixbuf (ctx, _tmp203_, (gdouble) _tmp204_, (gdouble) _tmp205_);
#line 736 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp206_ = x;
#line 736 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp207_ = y;
#line 736 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp208_ = trinket;
#line 736 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp209_ = trinket;
#line 736 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		cairo_rectangle (ctx, (gdouble) _tmp206_, (gdouble) _tmp207_, (gdouble) gdk_pixbuf_get_width (_tmp208_), (gdouble) gdk_pixbuf_get_height (_tmp209_));
#line 737 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		cairo_fill (ctx);
#line 4942 "CheckerboardLayout.c"
	}
#line 739 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	cairo_restore (ctx);
#line 595 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_g_object_unref0 (trinket);
#line 4948 "CheckerboardLayout.c"
}


void
checkerboard_item_set_horizontal_trinket_offset (CheckerboardItem* self,
                                                 gint horizontal_trinket_offset)
{
#line 742 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (IS_CHECKERBOARD_ITEM (self));
#line 743 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_vala_assert (horizontal_trinket_offset >= 0, "horizontal_trinket_offset >= 0");
#line 744 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->horizontal_trinket_offset = horizontal_trinket_offset;
#line 4962 "CheckerboardLayout.c"
}


gint
checkerboard_item_get_horizontal_trinket_offset (CheckerboardItem* self)
{
	gint result = 0;
	gint _tmp0_;
#line 747 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_val_if_fail (IS_CHECKERBOARD_ITEM (self), 0);
#line 748 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = self->priv->horizontal_trinket_offset;
#line 748 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	result = _tmp0_;
#line 748 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return result;
#line 4979 "CheckerboardLayout.c"
}


void
checkerboard_item_set_grid_coordinates (CheckerboardItem* self,
                                        gint col,
                                        gint row)
{
#line 751 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (IS_CHECKERBOARD_ITEM (self));
#line 752 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->col = col;
#line 753 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->row = row;
#line 4994 "CheckerboardLayout.c"
}


gint
checkerboard_item_get_column (CheckerboardItem* self)
{
	gint result = 0;
	gint _tmp0_;
#line 756 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_val_if_fail (IS_CHECKERBOARD_ITEM (self), 0);
#line 757 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = self->priv->col;
#line 757 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	result = _tmp0_;
#line 757 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return result;
#line 5011 "CheckerboardLayout.c"
}


gint
checkerboard_item_get_row (CheckerboardItem* self)
{
	gint result = 0;
	gint _tmp0_;
#line 760 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_val_if_fail (IS_CHECKERBOARD_ITEM (self), 0);
#line 761 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = self->priv->row;
#line 761 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	result = _tmp0_;
#line 761 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return result;
#line 5028 "CheckerboardLayout.c"
}


void
checkerboard_item_brighten (CheckerboardItem* self)
{
	gboolean _tmp0_ = FALSE;
	GdkPixbuf* _tmp1_;
	GdkPixbuf* _tmp3_;
	GdkPixbuf* _tmp4_;
	GdkPixbuf* _tmp5_;
	GdkPixbuf* _tmp6_;
	GdkPixbuf* _tmp7_;
#line 764 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (IS_CHECKERBOARD_ITEM (self));
#line 766 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = self->priv->brightened;
#line 766 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp1_ != NULL) {
#line 766 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp0_ = TRUE;
#line 5050 "CheckerboardLayout.c"
	} else {
		GdkPixbuf* _tmp2_;
#line 766 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp2_ = self->priv->pixbuf;
#line 766 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp0_ = _tmp2_ == NULL;
#line 5057 "CheckerboardLayout.c"
	}
#line 766 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp0_) {
#line 767 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		return;
#line 5063 "CheckerboardLayout.c"
	}
#line 770 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp3_ = self->priv->pixbuf;
#line 770 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp4_ = gdk_pixbuf_copy (_tmp3_);
#line 770 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_g_object_unref0 (self->priv->brightened);
#line 770 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->brightened = _tmp4_;
#line 771 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp5_ = self->priv->brightened;
#line 771 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	shift_colors (_tmp5_, CHECKERBOARD_ITEM_BRIGHTEN_SHIFT, CHECKERBOARD_ITEM_BRIGHTEN_SHIFT, CHECKERBOARD_ITEM_BRIGHTEN_SHIFT, 0);
#line 773 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp6_ = self->priv->brightened;
#line 773 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp7_ = _g_object_ref0 (_tmp6_);
#line 773 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_g_object_unref0 (self->priv->display_pixbuf);
#line 773 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->display_pixbuf = _tmp7_;
#line 775 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	data_view_notify_view_altered (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_VIEW, DataView));
#line 5087 "CheckerboardLayout.c"
}


void
checkerboard_item_unbrighten (CheckerboardItem* self)
{
	gboolean _tmp0_ = FALSE;
	GdkPixbuf* _tmp1_;
	GdkPixbuf* _tmp3_;
	GdkPixbuf* _tmp4_;
#line 778 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (IS_CHECKERBOARD_ITEM (self));
#line 780 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = self->priv->brightened;
#line 780 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp1_ == NULL) {
#line 780 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp0_ = TRUE;
#line 5106 "CheckerboardLayout.c"
	} else {
		GdkPixbuf* _tmp2_;
#line 780 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp2_ = self->priv->pixbuf;
#line 780 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp0_ = _tmp2_ == NULL;
#line 5113 "CheckerboardLayout.c"
	}
#line 780 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp0_) {
#line 781 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		return;
#line 5119 "CheckerboardLayout.c"
	}
#line 783 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_g_object_unref0 (self->priv->brightened);
#line 783 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->brightened = NULL;
#line 786 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp3_ = self->priv->pixbuf;
#line 786 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp4_ = _g_object_ref0 (_tmp3_);
#line 786 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_g_object_unref0 (self->priv->display_pixbuf);
#line 786 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->display_pixbuf = _tmp4_;
#line 788 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	data_view_notify_view_altered (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_VIEW, DataView));
#line 5135 "CheckerboardLayout.c"
}


static void
checkerboard_item_real_visibility_changed (DataView* base,
                                           gboolean visible)
{
	CheckerboardItem * self;
#line 791 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_CHECKERBOARD_ITEM, CheckerboardItem);
#line 793 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (!visible) {
#line 794 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		checkerboard_item_unbrighten (self);
#line 5150 "CheckerboardLayout.c"
	}
#line 796 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	DATA_VIEW_CLASS (checkerboard_item_parent_class)->visibility_changed (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_THUMBNAIL_VIEW, ThumbnailView), TYPE_DATA_VIEW, DataView), visible);
#line 5154 "CheckerboardLayout.c"
}


static gboolean
checkerboard_item_query_tooltip_on_text (CheckerboardItem* self,
                                         CheckerboardItemText* text,
                                         GtkTooltip* tooltip)
{
	gboolean result = FALSE;
	PangoLayout* _tmp0_;
	PangoLayout* _tmp1_;
	gboolean _tmp2_;
#line 799 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_val_if_fail (IS_CHECKERBOARD_ITEM (self), FALSE);
#line 799 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_val_if_fail (IS_CHECKERBOARD_ITEM_TEXT (text), FALSE);
#line 799 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_val_if_fail (GTK_IS_TOOLTIP (tooltip), FALSE);
#line 800 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = checkerboard_item_text_get_pango_layout (text, 0);
#line 800 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = _tmp0_;
#line 800 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp2_ = !pango_layout_is_ellipsized (_tmp1_);
#line 800 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_g_object_unref0 (_tmp1_);
#line 800 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp2_) {
#line 801 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		result = FALSE;
#line 801 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		return result;
#line 5187 "CheckerboardLayout.c"
	}
#line 803 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (checkerboard_item_text_is_marked_up (text)) {
#line 5191 "CheckerboardLayout.c"
		gchar* _tmp3_;
		gchar* _tmp4_;
#line 804 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp3_ = checkerboard_item_text_get_text (text);
#line 804 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp4_ = _tmp3_;
#line 804 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		gtk_tooltip_set_markup (tooltip, _tmp4_);
#line 804 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_g_free0 (_tmp4_);
#line 5202 "CheckerboardLayout.c"
	} else {
		gchar* _tmp5_;
		gchar* _tmp6_;
#line 806 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp5_ = checkerboard_item_text_get_text (text);
#line 806 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp6_ = _tmp5_;
#line 806 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		gtk_tooltip_set_text (tooltip, _tmp6_);
#line 806 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_g_free0 (_tmp6_);
#line 5214 "CheckerboardLayout.c"
	}
#line 808 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	result = TRUE;
#line 808 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return result;
#line 5220 "CheckerboardLayout.c"
}


gboolean
checkerboard_item_query_tooltip (CheckerboardItem* self,
                                 gint x,
                                 gint y,
                                 GtkTooltip* tooltip)
{
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	CheckerboardItemText* _tmp2_;
	gboolean _tmp7_ = FALSE;
	gboolean _tmp8_ = FALSE;
	CheckerboardItemText* _tmp9_;
	gboolean _tmp14_ = FALSE;
	gboolean _tmp15_ = FALSE;
	CheckerboardItemText* _tmp16_;
#line 811 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_val_if_fail (IS_CHECKERBOARD_ITEM (self), FALSE);
#line 811 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_val_if_fail (GTK_IS_TOOLTIP (tooltip), FALSE);
#line 812 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp2_ = self->priv->title;
#line 812 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp2_ != NULL) {
#line 5248 "CheckerboardLayout.c"
		gboolean _tmp3_;
#line 812 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp3_ = self->priv->title_visible;
#line 812 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp1_ = _tmp3_;
#line 5254 "CheckerboardLayout.c"
	} else {
#line 812 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp1_ = FALSE;
#line 5258 "CheckerboardLayout.c"
	}
#line 812 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp1_) {
#line 5262 "CheckerboardLayout.c"
		CheckerboardItemText* _tmp4_;
		GdkRectangle _tmp5_;
#line 812 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp4_ = self->priv->title;
#line 812 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp5_ = _tmp4_->allocation;
#line 812 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp0_ = coord_in_rectangle (x, y, &_tmp5_);
#line 5271 "CheckerboardLayout.c"
	} else {
#line 812 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp0_ = FALSE;
#line 5275 "CheckerboardLayout.c"
	}
#line 812 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp0_) {
#line 5279 "CheckerboardLayout.c"
		CheckerboardItemText* _tmp6_;
#line 813 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp6_ = self->priv->title;
#line 813 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		result = checkerboard_item_query_tooltip_on_text (self, _tmp6_, tooltip);
#line 813 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		return result;
#line 5287 "CheckerboardLayout.c"
	}
#line 815 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp9_ = self->priv->comment;
#line 815 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp9_ != NULL) {
#line 5293 "CheckerboardLayout.c"
		gboolean _tmp10_;
#line 815 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp10_ = self->priv->comment_visible;
#line 815 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp8_ = _tmp10_;
#line 5299 "CheckerboardLayout.c"
	} else {
#line 815 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp8_ = FALSE;
#line 5303 "CheckerboardLayout.c"
	}
#line 815 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp8_) {
#line 5307 "CheckerboardLayout.c"
		CheckerboardItemText* _tmp11_;
		GdkRectangle _tmp12_;
#line 815 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp11_ = self->priv->comment;
#line 815 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp12_ = _tmp11_->allocation;
#line 815 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp7_ = coord_in_rectangle (x, y, &_tmp12_);
#line 5316 "CheckerboardLayout.c"
	} else {
#line 815 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp7_ = FALSE;
#line 5320 "CheckerboardLayout.c"
	}
#line 815 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp7_) {
#line 5324 "CheckerboardLayout.c"
		CheckerboardItemText* _tmp13_;
#line 816 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp13_ = self->priv->comment;
#line 816 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		result = checkerboard_item_query_tooltip_on_text (self, _tmp13_, tooltip);
#line 816 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		return result;
#line 5332 "CheckerboardLayout.c"
	}
#line 818 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp16_ = self->priv->subtitle;
#line 818 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp16_ != NULL) {
#line 5338 "CheckerboardLayout.c"
		gboolean _tmp17_;
#line 818 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp17_ = self->priv->subtitle_visible;
#line 818 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp15_ = _tmp17_;
#line 5344 "CheckerboardLayout.c"
	} else {
#line 818 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp15_ = FALSE;
#line 5348 "CheckerboardLayout.c"
	}
#line 818 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp15_) {
#line 5352 "CheckerboardLayout.c"
		CheckerboardItemText* _tmp18_;
		GdkRectangle _tmp19_;
#line 818 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp18_ = self->priv->subtitle;
#line 818 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp19_ = _tmp18_->allocation;
#line 818 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp14_ = coord_in_rectangle (x, y, &_tmp19_);
#line 5361 "CheckerboardLayout.c"
	} else {
#line 818 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp14_ = FALSE;
#line 5365 "CheckerboardLayout.c"
	}
#line 818 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp14_) {
#line 5369 "CheckerboardLayout.c"
		CheckerboardItemText* _tmp20_;
#line 819 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp20_ = self->priv->subtitle;
#line 819 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		result = checkerboard_item_query_tooltip_on_text (self, _tmp20_, tooltip);
#line 819 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		return result;
#line 5377 "CheckerboardLayout.c"
	}
#line 821 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	result = FALSE;
#line 821 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return result;
#line 5383 "CheckerboardLayout.c"
}


gboolean
checkerboard_item_get_has_tags (CheckerboardItem* self)
{
	gboolean result;
	gboolean _tmp0_;
#line 161 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_val_if_fail (IS_CHECKERBOARD_ITEM (self), FALSE);
#line 161 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = self->priv->_has_tags;
#line 161 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	result = _tmp0_;
#line 161 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return result;
#line 5400 "CheckerboardLayout.c"
}


static void
checkerboard_item_set_has_tags (CheckerboardItem* self,
                                gboolean value)
{
#line 161 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (IS_CHECKERBOARD_ITEM (self));
#line 161 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (checkerboard_item_get_has_tags (self) != value) {
#line 161 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		self->priv->_has_tags = value;
#line 161 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		g_object_notify_by_pspec ((GObject *) self, checkerboard_item_properties[CHECKERBOARD_ITEM_HAS_TAGS_PROPERTY]);
#line 5416 "CheckerboardLayout.c"
	}
}


static void
checkerboard_item_class_init (CheckerboardItemClass * klass)
{
#line 98 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	checkerboard_item_parent_class = g_type_class_peek_parent (klass);
#line 98 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_type_class_add_private (klass, sizeof (CheckerboardItemPrivate));
#line 98 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	((DataObjectClass *) klass)->get_name = (gchar* (*) (DataObject *)) checkerboard_item_real_get_name;
#line 98 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	((DataObjectClass *) klass)->notify_membership_changed = (void (*) (DataObject *, DataCollection*)) checkerboard_item_real_notify_membership_changed;
#line 98 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	((DataObjectClass *) klass)->notify_collection_property_set = (void (*) (DataObject *, const gchar*, GValue*, GValue*)) checkerboard_item_real_notify_collection_property_set;
#line 98 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	((CheckerboardItemClass *) klass)->exposed = (void (*) (CheckerboardItem *)) checkerboard_item_real_exposed;
#line 98 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	((CheckerboardItemClass *) klass)->unexposed = (void (*) (CheckerboardItem *)) checkerboard_item_real_unexposed;
#line 98 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	((CheckerboardItemClass *) klass)->is_exposed = (gboolean (*) (CheckerboardItem *)) checkerboard_item_real_is_exposed;
#line 98 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	((CheckerboardItemClass *) klass)->paint_shadow = (void (*) (CheckerboardItem *, cairo_t*, Dimensions*, GdkPoint*, gint, gfloat)) checkerboard_item_real_paint_shadow;
#line 98 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	((CheckerboardItemClass *) klass)->paint_border = (void (*) (CheckerboardItem *, cairo_t*, Dimensions*, GdkPoint*, gint)) checkerboard_item_real_paint_border;
#line 98 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	((CheckerboardItemClass *) klass)->paint_image = (void (*) (CheckerboardItem *, cairo_t*, GdkPixbuf*, GdkPoint*)) checkerboard_item_real_paint_image;
#line 98 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	((CheckerboardItemClass *) klass)->get_top_left_trinket = (GdkPixbuf* (*) (CheckerboardItem *, gint)) checkerboard_item_real_get_top_left_trinket;
#line 98 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	((CheckerboardItemClass *) klass)->get_top_right_trinket = (GdkPixbuf* (*) (CheckerboardItem *, gint)) checkerboard_item_real_get_top_right_trinket;
#line 98 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	((CheckerboardItemClass *) klass)->get_bottom_left_trinket = (GdkPixbuf* (*) (CheckerboardItem *, gint)) checkerboard_item_real_get_bottom_left_trinket;
#line 98 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	((CheckerboardItemClass *) klass)->get_bottom_right_trinket = (GdkPixbuf* (*) (CheckerboardItem *, gint)) checkerboard_item_real_get_bottom_right_trinket;
#line 98 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	((DataViewClass *) klass)->visibility_changed = (void (*) (DataView *, gboolean)) checkerboard_item_real_visibility_changed;
#line 98 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_checkerboard_item_get_property;
#line 98 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_checkerboard_item_set_property;
#line 98 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	G_OBJECT_CLASS (klass)->finalize = checkerboard_item_finalize;
#line 98 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), CHECKERBOARD_ITEM_HAS_TAGS_PROPERTY, checkerboard_item_properties[CHECKERBOARD_ITEM_HAS_TAGS_PROPERTY] = g_param_spec_boolean ("has-tags", "has-tags", "has-tags", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
#line 5464 "CheckerboardLayout.c"
}


static void
checkerboard_item_instance_init (CheckerboardItem * self)
{
#line 98 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv = CHECKERBOARD_ITEM_GET_PRIVATE (self);
#line 119 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	dimensions_init (&self->requisition, 0, 0);
#line 120 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	memset (&self->allocation, 0, sizeof (GdkRectangle));
#line 122 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->exposure = FALSE;
#line 123 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->title = NULL;
#line 124 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->title_visible = TRUE;
#line 125 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->comment = NULL;
#line 126 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->comment_visible = TRUE;
#line 127 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->subtitle = NULL;
#line 128 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->subtitle_visible = FALSE;
#line 129 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->is_cursor = FALSE;
#line 130 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->tag_alignment = PANGO_ALIGN_LEFT;
#line 131 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->user_visible_tag_list = NULL;
#line 133 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->pixbuf = NULL;
#line 134 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->display_pixbuf = NULL;
#line 135 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->brightened = NULL;
#line 136 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	dimensions_init (&self->priv->pixbuf_dim, 0, 0);
#line 137 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->col = -1;
#line 138 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->row = -1;
#line 139 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->horizontal_trinket_offset = 0;
#line 5511 "CheckerboardLayout.c"
}


static void
checkerboard_item_finalize (GObject * obj)
{
	CheckerboardItem * self;
#line 98 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_CHECKERBOARD_ITEM, CheckerboardItem);
#line 123 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_checkerboard_item_text_unref0 (self->priv->title);
#line 125 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_checkerboard_item_text_unref0 (self->priv->comment);
#line 127 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_checkerboard_item_text_unref0 (self->priv->subtitle);
#line 131 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_g_object_unref0 (self->priv->user_visible_tag_list);
#line 132 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_g_object_unref0 (self->priv->tags);
#line 133 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_g_object_unref0 (self->priv->pixbuf);
#line 134 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_g_object_unref0 (self->priv->display_pixbuf);
#line 135 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_g_object_unref0 (self->priv->brightened);
#line 98 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	G_OBJECT_CLASS (checkerboard_item_parent_class)->finalize (obj);
#line 5539 "CheckerboardLayout.c"
}


GType
checkerboard_item_get_type (void)
{
	static volatile gsize checkerboard_item_type_id__volatile = 0;
	if (g_once_init_enter (&checkerboard_item_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (CheckerboardItemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) checkerboard_item_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CheckerboardItem), 0, (GInstanceInitFunc) checkerboard_item_instance_init, NULL };
		GType checkerboard_item_type_id;
		checkerboard_item_type_id = g_type_register_static (TYPE_THUMBNAIL_VIEW, "CheckerboardItem", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&checkerboard_item_type_id__volatile, checkerboard_item_type_id);
	}
	return checkerboard_item_type_id__volatile;
}


static void
_vala_checkerboard_item_get_property (GObject * object,
                                      guint property_id,
                                      GValue * value,
                                      GParamSpec * pspec)
{
	CheckerboardItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_CHECKERBOARD_ITEM, CheckerboardItem);
#line 98 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	switch (property_id) {
#line 98 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		case CHECKERBOARD_ITEM_HAS_TAGS_PROPERTY:
#line 98 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		g_value_set_boolean (value, checkerboard_item_get_has_tags (self));
#line 98 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		break;
#line 5573 "CheckerboardLayout.c"
		default:
#line 98 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 98 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		break;
#line 5579 "CheckerboardLayout.c"
	}
}


static void
_vala_checkerboard_item_set_property (GObject * object,
                                      guint property_id,
                                      const GValue * value,
                                      GParamSpec * pspec)
{
	CheckerboardItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_CHECKERBOARD_ITEM, CheckerboardItem);
#line 98 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	switch (property_id) {
#line 98 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		case CHECKERBOARD_ITEM_HAS_TAGS_PROPERTY:
#line 98 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		checkerboard_item_set_has_tags (self, g_value_get_boolean (value));
#line 98 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		break;
#line 5600 "CheckerboardLayout.c"
		default:
#line 98 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 98 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		break;
#line 5606 "CheckerboardLayout.c"
	}
}


static void
_checkerboard_layout_on_contents_altered_data_collection_contents_altered (DataCollection* _sender,
                                                                           GeeIterable* added,
                                                                           GeeIterable* removed,
                                                                           gpointer self)
{
#line 911 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	checkerboard_layout_on_contents_altered ((CheckerboardLayout*) self, added, removed);
#line 5619 "CheckerboardLayout.c"
}


static void
_checkerboard_layout_on_items_altered_data_collection_items_altered (DataCollection* _sender,
                                                                     GeeMap* items,
                                                                     gpointer self)
{
#line 912 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	checkerboard_layout_on_items_altered ((CheckerboardLayout*) self);
#line 5630 "CheckerboardLayout.c"
}


static void
_checkerboard_layout_on_items_state_changed_view_collection_items_state_changed (ViewCollection* _sender,
                                                                                 GeeIterable* changed,
                                                                                 gpointer self)
{
#line 913 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	checkerboard_layout_on_items_state_changed ((CheckerboardLayout*) self, changed);
#line 5641 "CheckerboardLayout.c"
}


static void
_checkerboard_layout_on_items_visibility_changed_view_collection_items_visibility_changed (ViewCollection* _sender,
                                                                                           GeeCollection* changed,
                                                                                           gpointer self)
{
#line 914 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	checkerboard_layout_on_items_visibility_changed ((CheckerboardLayout*) self, changed);
#line 5652 "CheckerboardLayout.c"
}


static void
_checkerboard_layout_on_ordering_changed_data_collection_ordering_changed (DataCollection* _sender,
                                                                           gpointer self)
{
#line 915 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	checkerboard_layout_on_ordering_changed ((CheckerboardLayout*) self);
#line 5662 "CheckerboardLayout.c"
}


static void
_checkerboard_layout_on_views_altered_view_collection_views_altered (ViewCollection* _sender,
                                                                     GeeCollection* views,
                                                                     gpointer self)
{
#line 916 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	checkerboard_layout_on_views_altered ((CheckerboardLayout*) self, views);
#line 5673 "CheckerboardLayout.c"
}


static void
_checkerboard_layout_on_geometries_altered_view_collection_geometries_altered (ViewCollection* _sender,
                                                                               GeeCollection* views,
                                                                               gpointer self)
{
#line 917 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	checkerboard_layout_on_geometries_altered ((CheckerboardLayout*) self);
#line 5684 "CheckerboardLayout.c"
}


static void
_checkerboard_layout_on_items_selection_changed_view_collection_items_selected (ViewCollection* _sender,
                                                                                GeeIterable* selected,
                                                                                gpointer self)
{
#line 918 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	checkerboard_layout_on_items_selection_changed ((CheckerboardLayout*) self);
#line 5695 "CheckerboardLayout.c"
}


static void
_checkerboard_layout_on_items_selection_changed_view_collection_items_unselected (ViewCollection* _sender,
                                                                                  GeeIterable* unselected,
                                                                                  gpointer self)
{
#line 919 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	checkerboard_layout_on_items_selection_changed ((CheckerboardLayout*) self);
#line 5706 "CheckerboardLayout.c"
}


static void
_checkerboard_layout_on_viewport_shifted_gtk_adjustment_value_changed (GtkAdjustment* _sender,
                                                                       gpointer self)
{
#line 922 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	checkerboard_layout_on_viewport_shifted ((CheckerboardLayout*) self);
#line 5716 "CheckerboardLayout.c"
}


static void
_checkerboard_layout_on_viewport_resized_gtk_widget_size_allocate (GtkWidget* _sender,
                                                                   GtkAllocation* allocation,
                                                                   gpointer self)
{
#line 928 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	checkerboard_layout_on_viewport_resized ((CheckerboardLayout*) self);
#line 5727 "CheckerboardLayout.c"
}


static void
_checkerboard_layout_on_colors_changed_config_facade_colors_changed (ConfigFacade* _sender,
                                                                     gpointer self)
{
#line 930 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	checkerboard_layout_on_colors_changed ((CheckerboardLayout*) self);
#line 5737 "CheckerboardLayout.c"
}


static gpointer
_data_collection_ref0 (gpointer self)
{
#line 883 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return self ? data_collection_ref (self) : NULL;
#line 5746 "CheckerboardLayout.c"
}


CheckerboardLayout*
checkerboard_layout_construct (GType object_type,
                               ViewCollection* view)
{
	CheckerboardLayout * self = NULL;
	ViewCollection* _tmp0_;
	ConfigFacade* _tmp1_;
	ConfigFacade* _tmp2_;
	GdkRGBA _tmp3_ = {0};
	ConfigFacade* _tmp4_;
	ConfigFacade* _tmp5_;
#line 882 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_val_if_fail (IS_VIEW_COLLECTION (view), NULL);
#line 882 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self = (CheckerboardLayout*) g_object_new (object_type, NULL);
#line 883 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = _data_collection_ref0 (view);
#line 883 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_data_collection_unref0 (self->priv->view);
#line 883 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->view = _tmp0_;
#line 885 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	checkerboard_layout_clear_drag_select (self);
#line 888 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (view, TYPE_DATA_COLLECTION, DataCollection), "contents-altered", (GCallback) _checkerboard_layout_on_contents_altered_data_collection_contents_altered, self, 0);
#line 889 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (view, TYPE_DATA_COLLECTION, DataCollection), "items-altered", (GCallback) _checkerboard_layout_on_items_altered_data_collection_items_altered, self, 0);
#line 890 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_signal_connect_object (view, "items-state-changed", (GCallback) _checkerboard_layout_on_items_state_changed_view_collection_items_state_changed, self, 0);
#line 891 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_signal_connect_object (view, "items-visibility-changed", (GCallback) _checkerboard_layout_on_items_visibility_changed_view_collection_items_visibility_changed, self, 0);
#line 892 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (view, TYPE_DATA_COLLECTION, DataCollection), "ordering-changed", (GCallback) _checkerboard_layout_on_ordering_changed_data_collection_ordering_changed, self, 0);
#line 893 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_signal_connect_object (view, "views-altered", (GCallback) _checkerboard_layout_on_views_altered_view_collection_views_altered, self, 0);
#line 894 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_signal_connect_object (view, "geometries-altered", (GCallback) _checkerboard_layout_on_geometries_altered_view_collection_geometries_altered, self, 0);
#line 895 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_signal_connect_object (view, "items-selected", (GCallback) _checkerboard_layout_on_items_selection_changed_view_collection_items_selected, self, 0);
#line 896 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_signal_connect_object (view, "items-unselected", (GCallback) _checkerboard_layout_on_items_selection_changed_view_collection_items_unselected, self, 0);
#line 898 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = config_facade_get_instance ();
#line 898 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp2_ = _tmp1_;
#line 898 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	config_facade_get_bg_color (_tmp2_, &_tmp3_);
#line 898 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	gtk_widget_override_background_color (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), GTK_STATE_FLAG_NORMAL, &_tmp3_);
#line 898 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_g_object_unref0 (_tmp2_);
#line 900 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp4_ = config_facade_get_instance ();
#line 900 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp5_ = _tmp4_;
#line 900 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_signal_connect_object (_tmp5_, "colors-changed", (GCallback) _checkerboard_layout_on_colors_changed_config_facade_colors_changed, self, 0);
#line 900 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_g_object_unref0 (_tmp5_);
#line 903 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	gtk_widget_set_has_tooltip (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), TRUE);
#line 882 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return self;
#line 5813 "CheckerboardLayout.c"
}


CheckerboardLayout*
checkerboard_layout_new (ViewCollection* view)
{
#line 882 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return checkerboard_layout_construct (TYPE_CHECKERBOARD_LAYOUT, view);
#line 5822 "CheckerboardLayout.c"
}


void
checkerboard_layout_set_adjustments (CheckerboardLayout* self,
                                     GtkAdjustment* hadjustment,
                                     GtkAdjustment* vadjustment)
{
	GtkAdjustment* _tmp0_;
	GtkAdjustment* _tmp1_;
	GtkContainer* _tmp2_;
	GtkContainer* _tmp3_;
#line 933 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (IS_CHECKERBOARD_LAYOUT (self));
#line 933 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (GTK_IS_ADJUSTMENT (hadjustment));
#line 933 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (GTK_IS_ADJUSTMENT (vadjustment));
#line 934 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = _g_object_ref0 (hadjustment);
#line 934 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_g_object_unref0 (self->priv->hadjustment);
#line 934 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->hadjustment = _tmp0_;
#line 935 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = _g_object_ref0 (vadjustment);
#line 935 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_g_object_unref0 (self->priv->vadjustment);
#line 935 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->vadjustment = _tmp1_;
#line 938 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_signal_connect_object (hadjustment, "value-changed", (GCallback) _checkerboard_layout_on_viewport_shifted_gtk_adjustment_value_changed, self, 0);
#line 939 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_signal_connect_object (vadjustment, "value-changed", (GCallback) _checkerboard_layout_on_viewport_shifted_gtk_adjustment_value_changed, self, 0);
#line 942 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp2_ = gtk_widget_get_parent (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
#line 942 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp3_ = _tmp2_;
#line 942 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, gtk_widget_get_type (), GtkWidget), "size-allocate", (GCallback) _checkerboard_layout_on_viewport_resized_gtk_widget_size_allocate, self, 0);
#line 5863 "CheckerboardLayout.c"
}


void
checkerboard_layout_set_scale (CheckerboardLayout* self,
                               gint scale)
{
#line 947 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (IS_CHECKERBOARD_LAYOUT (self));
#line 948 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->scale = scale;
#line 5875 "CheckerboardLayout.c"
}


gint
checkerboard_layout_get_scale (CheckerboardLayout* self)
{
	gint result = 0;
	gint _tmp0_;
#line 951 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_val_if_fail (IS_CHECKERBOARD_LAYOUT (self), 0);
#line 952 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = self->priv->scale;
#line 952 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	result = _tmp0_;
#line 952 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return result;
#line 5892 "CheckerboardLayout.c"
}


void
checkerboard_layout_set_name (CheckerboardLayout* self,
                              const gchar* name)
{
	gchar* _tmp0_;
#line 955 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (IS_CHECKERBOARD_LAYOUT (self));
#line 955 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (name != NULL);
#line 956 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = g_strdup (name);
#line 956 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_g_free0 (self->priv->page_name);
#line 956 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->page_name = _tmp0_;
#line 5911 "CheckerboardLayout.c"
}


static void
checkerboard_layout_on_viewport_resized (CheckerboardLayout* self)
{
	GtkRequisition req = {0};
	GtkRequisition _tmp0_ = {0};
	GtkAllocation parent_allocation = {0};
	GtkContainer* _tmp1_;
	GtkContainer* _tmp2_;
	GtkAllocation _tmp3_ = {0};
	const gchar* _tmp4_;
	gboolean _tmp15_;
#line 959 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (IS_CHECKERBOARD_LAYOUT (self));
#line 961 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	gtk_widget_get_preferred_size (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), NULL, &_tmp0_);
#line 961 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	req = _tmp0_;
#line 964 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = gtk_widget_get_parent (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
#line 964 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp2_ = _tmp1_;
#line 964 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	gtk_widget_get_allocation (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, gtk_widget_get_type (), GtkWidget), &_tmp3_);
#line 964 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	parent_allocation = _tmp3_;
#line 966 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp4_ = self->priv->message;
#line 966 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp4_ == NULL) {
#line 5944 "CheckerboardLayout.c"
		GtkRequisition _tmp5_;
		gint _tmp6_;
#line 975 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp5_ = req;
#line 975 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp6_ = _tmp5_.height;
#line 975 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		if (_tmp6_ != 0) {
#line 5953 "CheckerboardLayout.c"
			GtkAllocation _tmp7_;
			gint _tmp8_;
			GtkRequisition _tmp9_;
			gint _tmp10_;
#line 976 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp7_ = parent_allocation;
#line 976 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp8_ = _tmp7_.width;
#line 976 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp9_ = req;
#line 976 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp10_ = _tmp9_.height;
#line 976 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			gtk_widget_set_size_request (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), _tmp8_ - CHECKERBOARD_LAYOUT_SCROLLBAR_PLACEHOLDER_WIDTH, _tmp10_);
#line 5968 "CheckerboardLayout.c"
		}
	} else {
		GtkAllocation _tmp11_;
		gint _tmp12_;
		GtkAllocation _tmp13_;
		gint _tmp14_;
#line 980 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp11_ = parent_allocation;
#line 980 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp12_ = _tmp11_.width;
#line 980 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp13_ = parent_allocation;
#line 980 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp14_ = _tmp13_.height;
#line 980 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		gtk_widget_set_size_request (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), _tmp12_, _tmp14_);
#line 5985 "CheckerboardLayout.c"
	}
#line 985 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	checkerboard_layout_viewport_resized (self);
#line 987 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp15_ = self->priv->size_allocate_due_to_reflow;
#line 987 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (!_tmp15_) {
#line 988 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		checkerboard_layout_clear_anchor (self);
#line 5995 "CheckerboardLayout.c"
	} else {
#line 990 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		self->priv->size_allocate_due_to_reflow = FALSE;
#line 5999 "CheckerboardLayout.c"
	}
}


static void
checkerboard_layout_on_viewport_shifted (CheckerboardLayout* self)
{
#line 993 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (IS_CHECKERBOARD_LAYOUT (self));
#line 994 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	checkerboard_layout_update_visible_page (self);
#line 995 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	checkerboard_layout_need_exposure (self, "on_viewport_shift");
#line 997 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	checkerboard_layout_clear_anchor (self);
#line 6015 "CheckerboardLayout.c"
}


static void
checkerboard_layout_on_items_selection_changed (CheckerboardLayout* self)
{
#line 1000 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (IS_CHECKERBOARD_LAYOUT (self));
#line 1001 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	checkerboard_layout_clear_anchor (self);
#line 6026 "CheckerboardLayout.c"
}


static void
checkerboard_layout_clear_anchor (CheckerboardLayout* self)
{
	gboolean _tmp0_;
#line 1004 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (IS_CHECKERBOARD_LAYOUT (self));
#line 1005 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = self->priv->in_center_on_anchor;
#line 1005 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp0_) {
#line 1006 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		return;
#line 6042 "CheckerboardLayout.c"
	}
#line 1008 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_g_object_unref0 (self->priv->anchor);
#line 1008 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->anchor = NULL;
#line 6048 "CheckerboardLayout.c"
}


static void
checkerboard_layout_update_anchor (CheckerboardLayout* self)
{
	gboolean _tmp0_;
	GeeList* items_on_page = NULL;
	GdkRectangle _tmp1_;
	GeeList* _tmp2_;
	GeeList* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	GtkAdjustment* _tmp20_;
	GeeList* _tmp21_;
	GeeList* _tmp22_;
	gint _tmp23_;
	gint _tmp24_;
	gpointer _tmp25_;
#line 1011 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (IS_CHECKERBOARD_LAYOUT (self));
#line 1012 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = self->priv->in_center_on_anchor;
#line 1012 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_vala_assert (!_tmp0_, "!in_center_on_anchor");
#line 1014 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = self->priv->visible_page;
#line 1014 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp2_ = checkerboard_layout_intersection (self, &_tmp1_);
#line 1014 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	items_on_page = _tmp2_;
#line 1015 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp3_ = items_on_page;
#line 1015 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp4_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, GEE_TYPE_COLLECTION, GeeCollection));
#line 1015 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp5_ = _tmp4_;
#line 1015 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp5_ == 0) {
#line 1016 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_g_object_unref0 (self->priv->anchor);
#line 1016 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		self->priv->anchor = NULL;
#line 1017 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_g_object_unref0 (items_on_page);
#line 1017 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		return;
#line 6096 "CheckerboardLayout.c"
	}
	{
		GeeList* _item_list = NULL;
		GeeList* _tmp6_;
		GeeList* _tmp7_;
		gint _item_size = 0;
		GeeList* _tmp8_;
		gint _tmp9_;
		gint _tmp10_;
		gint _item_index = 0;
#line 1020 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp6_ = items_on_page;
#line 1020 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp7_ = _g_object_ref0 (_tmp6_);
#line 1020 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_item_list = _tmp7_;
#line 1020 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp8_ = _item_list;
#line 1020 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp9_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, GEE_TYPE_COLLECTION, GeeCollection));
#line 1020 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp10_ = _tmp9_;
#line 1020 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_item_size = _tmp10_;
#line 1020 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_item_index = -1;
#line 1020 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		while (TRUE) {
#line 6125 "CheckerboardLayout.c"
			gint _tmp11_;
			gint _tmp12_;
			gint _tmp13_;
			CheckerboardItem* item = NULL;
			GeeList* _tmp14_;
			gint _tmp15_;
			gpointer _tmp16_;
			CheckerboardItem* _tmp17_;
#line 1020 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp11_ = _item_index;
#line 1020 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_item_index = _tmp11_ + 1;
#line 1020 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp12_ = _item_index;
#line 1020 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp13_ = _item_size;
#line 1020 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			if (!(_tmp12_ < _tmp13_)) {
#line 1020 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				break;
#line 6146 "CheckerboardLayout.c"
			}
#line 1020 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp14_ = _item_list;
#line 1020 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp15_ = _item_index;
#line 1020 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp16_ = gee_list_get (_tmp14_, _tmp15_);
#line 1020 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			item = (CheckerboardItem*) _tmp16_;
#line 1021 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp17_ = item;
#line 1021 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			if (data_view_is_selected (G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, TYPE_DATA_VIEW, DataView))) {
#line 6160 "CheckerboardLayout.c"
				CheckerboardItem* _tmp18_;
				CheckerboardItem* _tmp19_;
#line 1022 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp18_ = item;
#line 1022 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp19_ = _g_object_ref0 (_tmp18_);
#line 1022 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_g_object_unref0 (self->priv->anchor);
#line 1022 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				self->priv->anchor = _tmp19_;
#line 1023 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_g_object_unref0 (item);
#line 1023 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_g_object_unref0 (_item_list);
#line 1023 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_g_object_unref0 (items_on_page);
#line 1023 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				return;
#line 6179 "CheckerboardLayout.c"
			}
#line 1020 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_g_object_unref0 (item);
#line 6183 "CheckerboardLayout.c"
		}
#line 1020 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_g_object_unref0 (_item_list);
#line 6187 "CheckerboardLayout.c"
	}
#line 1027 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp20_ = self->priv->vadjustment;
#line 1027 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (gtk_adjustment_get_value (_tmp20_) == ((gdouble) 0)) {
#line 1028 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_g_object_unref0 (self->priv->anchor);
#line 1028 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		self->priv->anchor = NULL;
#line 1029 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_g_object_unref0 (items_on_page);
#line 1029 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		return;
#line 6201 "CheckerboardLayout.c"
	}
#line 1034 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp21_ = items_on_page;
#line 1034 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp22_ = items_on_page;
#line 1034 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp23_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp22_, GEE_TYPE_COLLECTION, GeeCollection));
#line 1034 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp24_ = _tmp23_;
#line 1034 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp25_ = gee_list_get (_tmp21_, ((gint) _tmp24_) / 2);
#line 1034 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_g_object_unref0 (self->priv->anchor);
#line 1034 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->anchor = (CheckerboardItem*) _tmp25_;
#line 1011 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_g_object_unref0 (items_on_page);
#line 6219 "CheckerboardLayout.c"
}


static void
checkerboard_layout_center_on_anchor (CheckerboardLayout* self,
                                      gdouble upper)
{
	CheckerboardItem* _tmp0_;
	gdouble anchor_pos = 0.0;
	CheckerboardItem* _tmp1_;
	GdkRectangle _tmp2_;
	gint _tmp3_;
	CheckerboardItem* _tmp4_;
	GdkRectangle _tmp5_;
	gint _tmp6_;
	GtkAdjustment* _tmp7_;
	GtkAdjustment* _tmp8_;
	gdouble _tmp9_;
	GtkAdjustment* _tmp10_;
	GtkAdjustment* _tmp11_;
	GtkAdjustment* _tmp12_;
#line 1037 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (IS_CHECKERBOARD_LAYOUT (self));
#line 1038 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = self->priv->anchor;
#line 1038 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp0_ == NULL) {
#line 1039 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		return;
#line 6249 "CheckerboardLayout.c"
	}
#line 1041 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->in_center_on_anchor = TRUE;
#line 1043 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = self->priv->anchor;
#line 1043 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp2_ = _tmp1_->allocation;
#line 1043 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp3_ = _tmp2_.y;
#line 1043 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp4_ = self->priv->anchor;
#line 1043 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp5_ = _tmp4_->allocation;
#line 1043 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp6_ = _tmp5_.height;
#line 1043 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp7_ = self->priv->vadjustment;
#line 1043 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	anchor_pos = (_tmp3_ + (_tmp6_ / 2)) - (gtk_adjustment_get_page_size (_tmp7_) / 2);
#line 1045 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp8_ = self->priv->vadjustment;
#line 1045 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp9_ = anchor_pos;
#line 1045 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp10_ = self->priv->vadjustment;
#line 1045 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp11_ = self->priv->vadjustment;
#line 1045 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp12_ = self->priv->vadjustment;
#line 1045 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	gtk_adjustment_set_value (_tmp8_, CLAMP (_tmp9_, gtk_adjustment_get_lower (_tmp10_), gtk_adjustment_get_upper (_tmp11_) - gtk_adjustment_get_page_size (_tmp12_)));
#line 1048 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->in_center_on_anchor = FALSE;
#line 6283 "CheckerboardLayout.c"
}


void
checkerboard_layout_set_cursor (CheckerboardLayout* self,
                                CheckerboardItem* item)
{
	GeeHashSet* collection = NULL;
	GeeHashSet* _tmp0_;
	CheckerboardItem* _tmp1_;
	CheckerboardItem* _tmp7_;
	GeeHashSet* _tmp8_;
	GeeHashSet* _tmp9_;
#line 1051 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (IS_CHECKERBOARD_LAYOUT (self));
#line 1051 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (IS_CHECKERBOARD_ITEM (item));
#line 1052 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = gee_hash_set_new (TYPE_DATA_VIEW, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL);
#line 1052 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	collection = _tmp0_;
#line 1053 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = self->priv->cursor;
#line 1053 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp1_ != NULL) {
#line 6309 "CheckerboardLayout.c"
		CheckerboardItem* _tmp2_;
		ViewCollection* _tmp3_;
		CheckerboardItem* _tmp4_;
#line 1054 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp2_ = self->priv->cursor;
#line 1054 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		checkerboard_item_set_is_cursor (_tmp2_, FALSE);
#line 1056 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp3_ = self->priv->view;
#line 1056 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp4_ = self->priv->cursor;
#line 1056 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		if (data_collection_contains (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, TYPE_DATA_COLLECTION, DataCollection), G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, TYPE_DATA_OBJECT, DataObject))) {
#line 6323 "CheckerboardLayout.c"
			GeeHashSet* _tmp5_;
			CheckerboardItem* _tmp6_;
#line 1057 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp5_ = collection;
#line 1057 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp6_ = self->priv->cursor;
#line 1057 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, TYPE_DATA_VIEW, DataView));
#line 6332 "CheckerboardLayout.c"
		}
	}
#line 1060 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	checkerboard_item_set_is_cursor (item, TRUE);
#line 1061 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp7_ = _g_object_ref0 (item);
#line 1061 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_g_object_unref0 (self->priv->cursor);
#line 1061 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->cursor = _tmp7_;
#line 1062 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp8_ = collection;
#line 1062 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), G_TYPE_CHECK_INSTANCE_CAST (item, TYPE_DATA_VIEW, DataView));
#line 1063 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp9_ = collection;
#line 1063 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	checkerboard_layout_on_items_state_changed (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, GEE_TYPE_ITERABLE, GeeIterable));
#line 1051 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_g_object_unref0 (collection);
#line 6353 "CheckerboardLayout.c"
}


CheckerboardItem*
checkerboard_layout_get_cursor (CheckerboardLayout* self)
{
	CheckerboardItem* result = NULL;
	CheckerboardItem* _tmp0_;
	CheckerboardItem* _tmp1_;
#line 1066 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_val_if_fail (IS_CHECKERBOARD_LAYOUT (self), NULL);
#line 1067 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = self->priv->cursor;
#line 1067 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 1067 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	result = _tmp1_;
#line 1067 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return result;
#line 6373 "CheckerboardLayout.c"
}


static void
checkerboard_layout_on_contents_altered (CheckerboardLayout* self,
                                         GeeIterable* added,
                                         GeeIterable* removed)
{
#line 1071 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (IS_CHECKERBOARD_LAYOUT (self));
#line 1071 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail ((added == NULL) || GEE_IS_ITERABLE (added));
#line 1071 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail ((removed == NULL) || GEE_IS_ITERABLE (removed));
#line 1073 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (added != NULL) {
#line 1074 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_g_free0 (self->priv->message);
#line 1074 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		self->priv->message = NULL;
#line 6394 "CheckerboardLayout.c"
	}
#line 1076 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (removed != NULL) {
#line 6398 "CheckerboardLayout.c"
		{
			GeeIterator* _object_it = NULL;
			GeeIterator* _tmp0_;
#line 1077 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp0_ = gee_iterable_iterator (removed);
#line 1077 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_object_it = _tmp0_;
#line 1077 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			while (TRUE) {
#line 6408 "CheckerboardLayout.c"
				GeeIterator* _tmp1_;
				DataObject* object = NULL;
				GeeIterator* _tmp2_;
				gpointer _tmp3_;
				GeeHashSet* _tmp4_;
				DataObject* _tmp5_;
#line 1077 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp1_ = _object_it;
#line 1077 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				if (!gee_iterator_next (_tmp1_)) {
#line 1077 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					break;
#line 6421 "CheckerboardLayout.c"
				}
#line 1077 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp2_ = _object_it;
#line 1077 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp3_ = gee_iterator_get (_tmp2_);
#line 1077 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				object = (DataObject*) _tmp3_;
#line 1078 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp4_ = self->priv->exposed_items;
#line 1078 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp5_ = object;
#line 1078 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				gee_abstract_collection_remove (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, TYPE_CHECKERBOARD_ITEM, CheckerboardItem));
#line 1077 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_g_object_unref0 (object);
#line 6437 "CheckerboardLayout.c"
			}
#line 1077 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_g_object_unref0 (_object_it);
#line 6441 "CheckerboardLayout.c"
		}
	}
#line 1083 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->item_rows = (_vala_array_free (self->priv->item_rows, self->priv->item_rows_length1, (GDestroyNotify) checkerboard_layout_layout_row_unref), NULL);
#line 1083 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->item_rows = NULL;
#line 1083 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->item_rows_length1 = 0;
#line 1083 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->_item_rows_size_ = self->priv->item_rows_length1;
#line 1085 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	checkerboard_layout_need_reflow (self, "on_contents_altered");
#line 6454 "CheckerboardLayout.c"
}


static void
checkerboard_layout_on_items_altered (CheckerboardLayout* self)
{
#line 1088 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (IS_CHECKERBOARD_LAYOUT (self));
#line 1089 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	checkerboard_layout_need_reflow (self, "on_items_altered");
#line 6465 "CheckerboardLayout.c"
}


static void
checkerboard_layout_on_items_state_changed (CheckerboardLayout* self,
                                            GeeIterable* changed)
{
#line 1092 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (IS_CHECKERBOARD_LAYOUT (self));
#line 1092 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (GEE_IS_ITERABLE (changed));
#line 1093 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	checkerboard_layout_items_dirty (self, "on_items_state_changed", changed);
#line 6479 "CheckerboardLayout.c"
}


static void
checkerboard_layout_on_items_visibility_changed (CheckerboardLayout* self,
                                                 GeeIterable* changed)
{
#line 1096 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (IS_CHECKERBOARD_LAYOUT (self));
#line 1096 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (GEE_IS_ITERABLE (changed));
#line 1097 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	checkerboard_layout_need_reflow (self, "on_items_visibility_changed");
#line 6493 "CheckerboardLayout.c"
}


static void
checkerboard_layout_on_ordering_changed (CheckerboardLayout* self)
{
#line 1100 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (IS_CHECKERBOARD_LAYOUT (self));
#line 1101 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	checkerboard_layout_need_reflow (self, "on_ordering_changed");
#line 6504 "CheckerboardLayout.c"
}


static void
checkerboard_layout_on_views_altered (CheckerboardLayout* self,
                                      GeeCollection* altered)
{
#line 1104 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (IS_CHECKERBOARD_LAYOUT (self));
#line 1104 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (GEE_IS_COLLECTION (altered));
#line 1105 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	checkerboard_layout_items_dirty (self, "on_views_altered", G_TYPE_CHECK_INSTANCE_CAST (altered, GEE_TYPE_ITERABLE, GeeIterable));
#line 6518 "CheckerboardLayout.c"
}


static void
checkerboard_layout_on_geometries_altered (CheckerboardLayout* self)
{
#line 1108 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (IS_CHECKERBOARD_LAYOUT (self));
#line 1109 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	checkerboard_layout_need_reflow (self, "on_geometries_altered");
#line 6529 "CheckerboardLayout.c"
}


static gboolean
_checkerboard_layout_do_reflow_gsource_func (gpointer self)
{
	gboolean result;
	result = checkerboard_layout_do_reflow ((CheckerboardLayout*) self);
#line 1125 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return result;
#line 6540 "CheckerboardLayout.c"
}


static void
checkerboard_layout_need_reflow (CheckerboardLayout* self,
                                 const gchar* caller)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
#line 1112 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (IS_CHECKERBOARD_LAYOUT (self));
#line 1112 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (caller != NULL);
#line 1113 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = self->priv->flow_scheduled;
#line 1113 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp0_) {
#line 1114 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		return;
#line 6560 "CheckerboardLayout.c"
	}
#line 1116 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = self->priv->is_in_view;
#line 1116 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (!_tmp1_) {
#line 1117 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		self->priv->reflow_needed = TRUE;
#line 1118 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		return;
#line 6570 "CheckerboardLayout.c"
	}
#line 1124 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->flow_scheduled = TRUE;
#line 1125 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_idle_add_full (G_PRIORITY_HIGH, _checkerboard_layout_do_reflow_gsource_func, g_object_ref (self), g_object_unref);
#line 6576 "CheckerboardLayout.c"
}


static gboolean
checkerboard_layout_do_reflow (CheckerboardLayout* self)
{
	gboolean result = FALSE;
#line 1128 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_val_if_fail (IS_CHECKERBOARD_LAYOUT (self), FALSE);
#line 1129 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	checkerboard_layout_reflow (self, "do_reflow");
#line 1130 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	checkerboard_layout_need_exposure (self, "do_reflow");
#line 1132 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->flow_scheduled = FALSE;
#line 1134 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	result = FALSE;
#line 1134 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return result;
#line 6596 "CheckerboardLayout.c"
}


static void
checkerboard_layout_need_exposure (CheckerboardLayout* self,
                                   const gchar* caller)
{
#line 1137 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (IS_CHECKERBOARD_LAYOUT (self));
#line 1137 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (caller != NULL);
#line 1141 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->exposure_dirty = TRUE;
#line 1142 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	gtk_widget_queue_draw (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
#line 6612 "CheckerboardLayout.c"
}


void
checkerboard_layout_set_message (CheckerboardLayout* self,
                                 const gchar* text)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
#line 1145 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (IS_CHECKERBOARD_LAYOUT (self));
#line 1146 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = self->priv->message;
#line 1146 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (g_strcmp0 (text, _tmp0_) == 0) {
#line 1147 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		return;
#line 6630 "CheckerboardLayout.c"
	}
#line 1149 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = g_strdup (text);
#line 1149 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_g_free0 (self->priv->message);
#line 1149 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->message = _tmp1_;
#line 1151 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (text != NULL) {
#line 6640 "CheckerboardLayout.c"
		GtkContainer* _tmp2_;
		GtkContainer* _tmp3_;
#line 1154 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp2_ = gtk_widget_get_parent (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
#line 1154 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp3_ = _tmp2_;
#line 1154 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		if (_tmp3_ != NULL) {
#line 6649 "CheckerboardLayout.c"
			GtkAllocation parent_allocation = {0};
			GtkContainer* _tmp4_;
			GtkContainer* _tmp5_;
			GtkAllocation _tmp6_ = {0};
			GtkAllocation _tmp7_;
			gint _tmp8_;
			GtkAllocation _tmp9_;
			gint _tmp10_;
#line 1156 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp4_ = gtk_widget_get_parent (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
#line 1156 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp5_ = _tmp4_;
#line 1156 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			gtk_widget_get_allocation (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, gtk_widget_get_type (), GtkWidget), &_tmp6_);
#line 1156 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			parent_allocation = _tmp6_;
#line 1158 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp7_ = parent_allocation;
#line 1158 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp8_ = _tmp7_.width;
#line 1158 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp9_ = parent_allocation;
#line 1158 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp10_ = _tmp9_.height;
#line 1158 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			gtk_widget_set_size_request (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), _tmp8_, _tmp10_);
#line 6676 "CheckerboardLayout.c"
		}
	} else {
#line 1162 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		checkerboard_layout_need_reflow (self, "set_message");
#line 6681 "CheckerboardLayout.c"
	}
}


void
checkerboard_layout_unset_message (CheckerboardLayout* self)
{
#line 1166 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (IS_CHECKERBOARD_LAYOUT (self));
#line 1167 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	checkerboard_layout_set_message (self, NULL);
#line 6693 "CheckerboardLayout.c"
}


static void
checkerboard_layout_update_visible_page (CheckerboardLayout* self)
{
	gboolean _tmp0_ = FALSE;
	GtkAdjustment* _tmp1_;
#line 1170 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (IS_CHECKERBOARD_LAYOUT (self));
#line 1171 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = self->priv->hadjustment;
#line 1171 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp1_ != NULL) {
#line 6708 "CheckerboardLayout.c"
		GtkAdjustment* _tmp2_;
#line 1171 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp2_ = self->priv->vadjustment;
#line 1171 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp0_ = _tmp2_ != NULL;
#line 6714 "CheckerboardLayout.c"
	} else {
#line 1171 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp0_ = FALSE;
#line 6718 "CheckerboardLayout.c"
	}
#line 1171 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp0_) {
#line 6722 "CheckerboardLayout.c"
		GtkAdjustment* _tmp3_;
		GtkAdjustment* _tmp4_;
		GdkRectangle _tmp5_ = {0};
#line 1172 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp3_ = self->priv->hadjustment;
#line 1172 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp4_ = self->priv->vadjustment;
#line 1172 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		get_adjustment_page (_tmp3_, _tmp4_, &_tmp5_);
#line 1172 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		self->priv->visible_page = _tmp5_;
#line 6734 "CheckerboardLayout.c"
	}
}


void
checkerboard_layout_set_in_view (CheckerboardLayout* self,
                                 gboolean in_view)
{
#line 1175 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (IS_CHECKERBOARD_LAYOUT (self));
#line 1176 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->is_in_view = in_view;
#line 1178 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (in_view) {
#line 6749 "CheckerboardLayout.c"
		gboolean _tmp0_;
#line 1179 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp0_ = self->priv->reflow_needed;
#line 1179 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		if (_tmp0_) {
#line 1180 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			checkerboard_layout_need_reflow (self, "set_in_view (true)");
#line 6757 "CheckerboardLayout.c"
		} else {
#line 1182 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			checkerboard_layout_need_exposure (self, "set_in_view (true)");
#line 6761 "CheckerboardLayout.c"
		}
	} else {
#line 1184 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		checkerboard_layout_unexpose_items (self, "set_in_view (false)");
#line 6766 "CheckerboardLayout.c"
	}
}


static gpointer
_checkerboard_layout_layout_row_ref0 (gpointer self)
{
#line 1200 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return self ? checkerboard_layout_layout_row_ref (self) : NULL;
#line 6776 "CheckerboardLayout.c"
}


CheckerboardItem*
checkerboard_layout_get_item_at_pixel (CheckerboardLayout* self,
                                       gdouble xd,
                                       gdouble yd)
{
	CheckerboardItem* result = NULL;
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_;
	gint x = 0;
	gint y = 0;
	CheckerboardLayoutLayoutRow* in_range = NULL;
	gint min = 0;
	gint max = 0;
	CheckerboardLayoutLayoutRow** _tmp3_;
	gint _tmp3__length1;
	CheckerboardLayoutLayoutRow* _tmp28_;
	CheckerboardLayoutLayoutRow* _tmp29_;
	CheckerboardItem** _tmp30_;
	gint _tmp30__length1;
#line 1187 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_val_if_fail (IS_CHECKERBOARD_LAYOUT (self), NULL);
#line 1188 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = self->priv->message;
#line 1188 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp1_ != NULL) {
#line 1188 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp0_ = TRUE;
#line 6807 "CheckerboardLayout.c"
	} else {
		CheckerboardLayoutLayoutRow** _tmp2_;
		gint _tmp2__length1;
#line 1188 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp2_ = self->priv->item_rows;
#line 1188 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp2__length1 = self->priv->item_rows_length1;
#line 1188 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp0_ = _tmp2_ == NULL;
#line 6817 "CheckerboardLayout.c"
	}
#line 1188 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp0_) {
#line 1189 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		result = NULL;
#line 1189 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		return result;
#line 6825 "CheckerboardLayout.c"
	}
#line 1191 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	x = (gint) xd;
#line 1192 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	y = (gint) yd;
#line 1195 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	in_range = NULL;
#line 1196 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	min = 0;
#line 1197 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp3_ = self->priv->item_rows;
#line 1197 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp3__length1 = self->priv->item_rows_length1;
#line 1197 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	max = _tmp3__length1;
#line 6841 "CheckerboardLayout.c"
	{
		gboolean _tmp4_ = FALSE;
#line 1198 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp4_ = TRUE;
#line 1198 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		while (TRUE) {
#line 6848 "CheckerboardLayout.c"
			gint mid = 0;
			gint _tmp5_;
			gint _tmp6_;
			gint _tmp7_;
			CheckerboardLayoutLayoutRow* row = NULL;
			CheckerboardLayoutLayoutRow** _tmp8_;
			gint _tmp8__length1;
			gint _tmp9_;
			CheckerboardLayoutLayoutRow* _tmp10_;
			CheckerboardLayoutLayoutRow* _tmp11_;
			gboolean _tmp12_ = FALSE;
			CheckerboardLayoutLayoutRow* _tmp13_;
			gint _tmp26_;
			gint _tmp27_;
#line 1198 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			if (!_tmp4_) {
#line 6865 "CheckerboardLayout.c"
			}
#line 1198 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp4_ = FALSE;
#line 1199 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp5_ = min;
#line 1199 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp6_ = max;
#line 1199 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp7_ = min;
#line 1199 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			mid = _tmp5_ + ((_tmp6_ - _tmp7_) / 2);
#line 1200 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp8_ = self->priv->item_rows;
#line 1200 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp8__length1 = self->priv->item_rows_length1;
#line 1200 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp9_ = mid;
#line 1200 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp10_ = _tmp8_[_tmp9_];
#line 1200 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp11_ = _checkerboard_layout_layout_row_ref0 (_tmp10_);
#line 1200 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			row = _tmp11_;
#line 1202 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp13_ = row;
#line 1202 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			if (_tmp13_ == NULL) {
#line 1202 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp12_ = TRUE;
#line 6895 "CheckerboardLayout.c"
			} else {
				gint _tmp14_;
				CheckerboardLayoutLayoutRow* _tmp15_;
				gint _tmp16_;
#line 1202 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp14_ = y;
#line 1202 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp15_ = row;
#line 1202 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp16_ = _tmp15_->y;
#line 1202 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp12_ = _tmp14_ < _tmp16_;
#line 6908 "CheckerboardLayout.c"
			}
#line 1202 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			if (_tmp12_) {
#line 6912 "CheckerboardLayout.c"
				gint _tmp17_;
#line 1205 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp17_ = mid;
#line 1205 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				max = _tmp17_ - 1;
#line 6918 "CheckerboardLayout.c"
			} else {
				gint _tmp18_;
				CheckerboardLayoutLayoutRow* _tmp19_;
				gint _tmp20_;
				CheckerboardLayoutLayoutRow* _tmp21_;
				gint _tmp22_;
#line 1206 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp18_ = y;
#line 1206 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp19_ = row;
#line 1206 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp20_ = _tmp19_->y;
#line 1206 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp21_ = row;
#line 1206 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp22_ = _tmp21_->height;
#line 1206 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				if (_tmp18_ > (_tmp20_ + _tmp22_)) {
#line 6937 "CheckerboardLayout.c"
					gint _tmp23_;
#line 1208 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp23_ = mid;
#line 1208 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					min = _tmp23_ + 1;
#line 6943 "CheckerboardLayout.c"
				} else {
					CheckerboardLayoutLayoutRow* _tmp24_;
					CheckerboardLayoutLayoutRow* _tmp25_;
#line 1211 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp24_ = row;
#line 1211 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp25_ = _checkerboard_layout_layout_row_ref0 (_tmp24_);
#line 1211 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_checkerboard_layout_layout_row_unref0 (in_range);
#line 1211 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					in_range = _tmp25_;
#line 1213 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_checkerboard_layout_layout_row_unref0 (row);
#line 1213 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					break;
#line 6959 "CheckerboardLayout.c"
				}
			}
#line 1216 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp26_ = min;
#line 1216 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp27_ = max;
#line 1216 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			if (_tmp26_ > _tmp27_) {
#line 1217 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_checkerboard_layout_layout_row_unref0 (row);
#line 1217 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				break;
#line 6972 "CheckerboardLayout.c"
			}
#line 1198 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_checkerboard_layout_layout_row_unref0 (row);
#line 6976 "CheckerboardLayout.c"
		}
	}
#line 1220 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp28_ = in_range;
#line 1220 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp28_ == NULL) {
#line 1221 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		result = NULL;
#line 1221 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_checkerboard_layout_layout_row_unref0 (in_range);
#line 1221 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		return result;
#line 6989 "CheckerboardLayout.c"
	}
#line 1224 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp29_ = in_range;
#line 1224 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp30_ = _tmp29_->items;
#line 1224 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp30__length1 = _tmp29_->items_length1;
#line 6997 "CheckerboardLayout.c"
	{
		CheckerboardItem** item_collection = NULL;
		gint item_collection_length1 = 0;
		gint _item_collection_size_ = 0;
		gint item_it = 0;
#line 1224 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		item_collection = _tmp30_;
#line 1224 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		item_collection_length1 = _tmp30__length1;
#line 1224 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		for (item_it = 0; item_it < _tmp30__length1; item_it = item_it + 1) {
#line 7009 "CheckerboardLayout.c"
			CheckerboardItem* _tmp31_;
			CheckerboardItem* item = NULL;
#line 1224 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp31_ = _g_object_ref0 (item_collection[item_it]);
#line 1224 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			item = _tmp31_;
#line 7016 "CheckerboardLayout.c"
			{
				CheckerboardItem* _tmp32_;
				gint _tmp33_;
				CheckerboardItem* _tmp34_;
				GdkRectangle _tmp35_;
				gint _tmp36_;
				gboolean _tmp37_ = FALSE;
				gboolean _tmp38_ = FALSE;
				gint _tmp39_;
				CheckerboardItem* _tmp40_;
				GdkRectangle _tmp41_;
				gint _tmp42_;
				CheckerboardItem* _tmp43_;
				GdkRectangle _tmp44_;
				gint _tmp45_;
#line 1227 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp32_ = item;
#line 1227 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				if (_tmp32_ == NULL) {
#line 1228 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_g_object_unref0 (item);
#line 1228 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					continue;
#line 7040 "CheckerboardLayout.c"
				}
#line 1230 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp33_ = x;
#line 1230 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp34_ = item;
#line 1230 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp35_ = _tmp34_->allocation;
#line 1230 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp36_ = _tmp35_.x;
#line 1230 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				if (_tmp33_ < _tmp36_) {
#line 1232 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_g_object_unref0 (item);
#line 1232 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					break;
#line 7056 "CheckerboardLayout.c"
				}
#line 1237 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp39_ = x;
#line 1237 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp40_ = item;
#line 1237 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp41_ = _tmp40_->allocation;
#line 1237 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp42_ = _tmp41_.x;
#line 1237 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp43_ = item;
#line 1237 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp44_ = _tmp43_->allocation;
#line 1237 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp45_ = _tmp44_.width;
#line 1237 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				if (_tmp39_ <= (_tmp42_ + _tmp45_)) {
#line 7074 "CheckerboardLayout.c"
					gint _tmp46_;
					CheckerboardItem* _tmp47_;
					GdkRectangle _tmp48_;
					gint _tmp49_;
#line 1237 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp46_ = y;
#line 1237 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp47_ = item;
#line 1237 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp48_ = _tmp47_->allocation;
#line 1237 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp49_ = _tmp48_.y;
#line 1237 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp38_ = _tmp46_ >= _tmp49_;
#line 7089 "CheckerboardLayout.c"
				} else {
#line 1237 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp38_ = FALSE;
#line 7093 "CheckerboardLayout.c"
				}
#line 1237 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				if (_tmp38_) {
#line 7097 "CheckerboardLayout.c"
					gint _tmp50_;
					CheckerboardItem* _tmp51_;
					GdkRectangle _tmp52_;
					gint _tmp53_;
					CheckerboardItem* _tmp54_;
					GdkRectangle _tmp55_;
					gint _tmp56_;
#line 1238 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp50_ = y;
#line 1238 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp51_ = item;
#line 1238 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp52_ = _tmp51_->allocation;
#line 1238 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp53_ = _tmp52_.y;
#line 1238 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp54_ = item;
#line 1238 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp55_ = _tmp54_->allocation;
#line 1238 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp56_ = _tmp55_.height;
#line 1238 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp37_ = _tmp50_ <= (_tmp53_ + _tmp56_);
#line 7121 "CheckerboardLayout.c"
				} else {
#line 1237 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp37_ = FALSE;
#line 7125 "CheckerboardLayout.c"
				}
#line 1237 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				if (_tmp37_) {
#line 1239 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					result = item;
#line 1239 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_checkerboard_layout_layout_row_unref0 (in_range);
#line 1239 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					return result;
#line 7135 "CheckerboardLayout.c"
				}
#line 1224 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_g_object_unref0 (item);
#line 7139 "CheckerboardLayout.c"
			}
		}
	}
#line 1242 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	result = NULL;
#line 1242 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_checkerboard_layout_layout_row_unref0 (in_range);
#line 1242 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return result;
#line 7149 "CheckerboardLayout.c"
}


static gchar
string_get (const gchar* self,
            glong index)
{
	gchar result = '\0';
	gchar _tmp0_;
#line 1124 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, '\0');
#line 1125 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	_tmp0_ = ((gchar*) self)[index];
#line 1125 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	result = _tmp0_;
#line 1125 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	return result;
#line 7167 "CheckerboardLayout.c"
}


static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	glong result = 0L;
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
#line 1336 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
#line 1336 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	end = _tmp0_;
#line 1337 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	_tmp1_ = end;
#line 1337 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	if (_tmp1_ == NULL) {
#line 1338 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		result = maxlen;
#line 1338 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		return result;
#line 7191 "CheckerboardLayout.c"
	} else {
		gchar* _tmp2_;
#line 1340 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		_tmp2_ = end;
#line 1340 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		result = (glong) (_tmp2_ - str);
#line 1340 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		return result;
#line 7200 "CheckerboardLayout.c"
	}
}


static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp6_;
	gchar* _tmp7_;
#line 1347 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1349 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	if (offset >= ((glong) 0)) {
#line 1349 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		_tmp0_ = len >= ((glong) 0);
#line 7221 "CheckerboardLayout.c"
	} else {
#line 1349 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		_tmp0_ = FALSE;
#line 7225 "CheckerboardLayout.c"
	}
#line 1349 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	if (_tmp0_) {
#line 1351 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		string_length = string_strnlen ((gchar*) self, offset + len);
#line 7231 "CheckerboardLayout.c"
	} else {
		gint _tmp1_;
		gint _tmp2_;
#line 1353 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		_tmp1_ = strlen (self);
#line 1353 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		_tmp2_ = _tmp1_;
#line 1353 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		string_length = (glong) _tmp2_;
#line 7241 "CheckerboardLayout.c"
	}
#line 1356 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	if (offset < ((glong) 0)) {
#line 7245 "CheckerboardLayout.c"
		glong _tmp3_;
#line 1357 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		_tmp3_ = string_length;
#line 1357 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		offset = _tmp3_ + offset;
#line 1358 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
#line 7253 "CheckerboardLayout.c"
	} else {
		glong _tmp4_;
#line 1360 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		_tmp4_ = string_length;
#line 1360 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		g_return_val_if_fail (offset <= _tmp4_, NULL);
#line 7260 "CheckerboardLayout.c"
	}
#line 1362 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	if (len < ((glong) 0)) {
#line 7264 "CheckerboardLayout.c"
		glong _tmp5_;
#line 1363 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		_tmp5_ = string_length;
#line 1363 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		len = _tmp5_ - offset;
#line 7270 "CheckerboardLayout.c"
	}
#line 1365 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	_tmp6_ = string_length;
#line 1365 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	g_return_val_if_fail ((offset + len) <= _tmp6_, NULL);
#line 1366 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	_tmp7_ = g_strndup (((gchar*) self) + offset, (gsize) len);
#line 1366 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	result = _tmp7_;
#line 1366 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	return result;
#line 7282 "CheckerboardLayout.c"
}


gint
checkerboard_layout_get_tag_index_at_pos (const gchar* tag_list,
                                          gint pos)
{
	gint result = 0;
	gint sep_len = 0;
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint len = 0;
	gint _tmp3_;
	gint _tmp4_;
	gboolean _tmp5_ = FALSE;
	gint index = 0;
#line 1245 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_val_if_fail (tag_list != NULL, 0);
#line 1246 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = strlen (TAG_TAG_LIST_SEPARATOR_STRING);
#line 1246 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = _tmp0_;
#line 1246 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	sep_len = _tmp1_;
#line 1247 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp2_ = sep_len;
#line 1247 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_vala_assert (_tmp2_ > 0, "sep_len > 0");
#line 1248 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp3_ = strlen (tag_list);
#line 1248 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp4_ = _tmp3_;
#line 1248 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	len = _tmp4_;
#line 1249 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (pos < 0) {
#line 1249 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp5_ = TRUE;
#line 7322 "CheckerboardLayout.c"
	} else {
		gint _tmp6_;
#line 1249 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp6_ = len;
#line 1249 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp5_ = pos >= _tmp6_;
#line 7329 "CheckerboardLayout.c"
	}
#line 1249 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp5_) {
#line 1250 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		result = -1;
#line 1250 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		return result;
#line 7337 "CheckerboardLayout.c"
	}
	{
		gint i = 0;
#line 1253 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		i = 0;
#line 7343 "CheckerboardLayout.c"
		{
			gboolean _tmp7_ = FALSE;
#line 1253 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp7_ = TRUE;
#line 1253 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			while (TRUE) {
#line 7350 "CheckerboardLayout.c"
				gint _tmp9_;
				gint _tmp10_;
				gboolean _tmp11_ = FALSE;
				gint _tmp12_;
#line 1253 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				if (!_tmp7_) {
#line 7357 "CheckerboardLayout.c"
					gint _tmp8_;
#line 1253 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp8_ = i;
#line 1253 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					i = _tmp8_ + 1;
#line 7363 "CheckerboardLayout.c"
				}
#line 1253 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp7_ = FALSE;
#line 1253 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp9_ = i;
#line 1253 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp10_ = sep_len;
#line 1253 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				if (!(_tmp9_ < _tmp10_)) {
#line 1253 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					break;
#line 7375 "CheckerboardLayout.c"
				}
#line 1254 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp12_ = i;
#line 1254 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				if (string_get (tag_list, (glong) pos) == string_get (TAG_TAG_LIST_SEPARATOR_STRING, (glong) _tmp12_)) {
#line 7381 "CheckerboardLayout.c"
					gint _tmp13_;
#line 1254 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp13_ = i;
#line 1254 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp11_ = pos >= _tmp13_;
#line 7387 "CheckerboardLayout.c"
				} else {
#line 1254 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp11_ = FALSE;
#line 7391 "CheckerboardLayout.c"
				}
#line 1254 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				if (_tmp11_) {
#line 7395 "CheckerboardLayout.c"
					gint _tmp14_;
					gint _tmp15_;
					gchar* _tmp16_;
					gchar* _tmp17_;
					gboolean _tmp18_;
#line 1255 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp14_ = i;
#line 1255 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp15_ = sep_len;
#line 1255 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp16_ = string_substring (tag_list, (glong) (pos - _tmp14_), (glong) _tmp15_);
#line 1255 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp17_ = _tmp16_;
#line 1255 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp18_ = g_strcmp0 (_tmp17_, TAG_TAG_LIST_SEPARATOR_STRING) == 0;
#line 1255 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_g_free0 (_tmp17_);
#line 1255 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					if (_tmp18_) {
#line 1256 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
						result = -1;
#line 1256 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
						return result;
#line 7419 "CheckerboardLayout.c"
					}
				}
			}
		}
	}
#line 1263 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	index = 0;
#line 7427 "CheckerboardLayout.c"
	{
		gint i = 0;
#line 1264 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		i = 0;
#line 7432 "CheckerboardLayout.c"
		{
			gboolean _tmp19_ = FALSE;
#line 1264 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp19_ = TRUE;
#line 1264 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			while (TRUE) {
#line 7439 "CheckerboardLayout.c"
				gint _tmp21_;
				gboolean _tmp22_ = FALSE;
				gboolean _tmp23_ = FALSE;
				gint _tmp24_;
#line 1264 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				if (!_tmp19_) {
#line 7446 "CheckerboardLayout.c"
					gint _tmp20_;
#line 1264 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp20_ = i;
#line 1264 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					i = _tmp20_ + 1;
#line 7452 "CheckerboardLayout.c"
				}
#line 1264 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp19_ = FALSE;
#line 1264 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp21_ = i;
#line 1264 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				if (!(_tmp21_ < pos)) {
#line 1264 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					break;
#line 7462 "CheckerboardLayout.c"
				}
#line 1265 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp24_ = i;
#line 1265 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				if (string_get (tag_list, (glong) _tmp24_) == string_get (TAG_TAG_LIST_SEPARATOR_STRING, (glong) 0)) {
#line 7468 "CheckerboardLayout.c"
					gint _tmp25_;
					gint _tmp26_;
					gint _tmp27_;
#line 1266 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp25_ = i;
#line 1266 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp26_ = sep_len;
#line 1266 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp27_ = len;
#line 1266 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp23_ = (_tmp25_ + _tmp26_) <= _tmp27_;
#line 7480 "CheckerboardLayout.c"
				} else {
#line 1265 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp23_ = FALSE;
#line 7484 "CheckerboardLayout.c"
				}
#line 1265 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				if (_tmp23_) {
#line 7488 "CheckerboardLayout.c"
					gint _tmp28_;
					gint _tmp29_;
					gchar* _tmp30_;
					gchar* _tmp31_;
#line 1267 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp28_ = i;
#line 1267 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp29_ = sep_len;
#line 1267 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp30_ = string_substring (tag_list, (glong) _tmp28_, (glong) _tmp29_);
#line 1267 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp31_ = _tmp30_;
#line 1267 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp22_ = g_strcmp0 (_tmp31_, TAG_TAG_LIST_SEPARATOR_STRING) == 0;
#line 1267 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_g_free0 (_tmp31_);
#line 7505 "CheckerboardLayout.c"
				} else {
#line 1265 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp22_ = FALSE;
#line 7509 "CheckerboardLayout.c"
				}
#line 1265 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				if (_tmp22_) {
#line 7513 "CheckerboardLayout.c"
					gint _tmp32_;
					gint _tmp33_;
					gint _tmp34_;
#line 1268 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp32_ = index;
#line 1268 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					index = _tmp32_ + 1;
#line 1269 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp33_ = i;
#line 1269 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp34_ = sep_len;
#line 1269 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					i = _tmp33_ + (_tmp34_ - 1);
#line 7527 "CheckerboardLayout.c"
				}
			}
		}
	}
#line 1272 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	result = index;
#line 1272 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return result;
#line 7536 "CheckerboardLayout.c"
}


static gint
checkerboard_layout_internal_handle_tag_mouse_event (CheckerboardLayout* self,
                                                     CheckerboardItem* item,
                                                     gint x,
                                                     gint y)
{
	gint result = 0;
	PangoLayout* layout = NULL;
	PangoLayout* _tmp0_;
	PangoLayout* _tmp1_;
	GdkRectangle rect = {0};
	GdkRectangle _tmp2_ = {0};
	gint index = 0;
	gint trailing = 0;
	gint px = 0;
	GdkRectangle _tmp3_;
	gint _tmp4_;
	gint py = 0;
	GdkRectangle _tmp5_;
	gint _tmp6_;
	PangoLayout* _tmp7_;
	gint _tmp8_;
	gint _tmp9_;
	gint _tmp10_ = 0;
	gint _tmp11_ = 0;
	gboolean _tmp12_;
#line 1275 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_val_if_fail (IS_CHECKERBOARD_LAYOUT (self), 0);
#line 1275 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_val_if_fail (IS_CHECKERBOARD_ITEM (item), 0);
#line 1276 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = checkerboard_item_get_tag_list_layout (item);
#line 1276 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	layout = _tmp0_;
#line 1277 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = layout;
#line 1277 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp1_ == NULL) {
#line 1278 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		result = -1;
#line 1278 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_g_object_unref0 (layout);
#line 1278 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		return result;
#line 7584 "CheckerboardLayout.c"
	}
#line 1280 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	checkerboard_item_translate_coordinates (item, &x, &y);
#line 1282 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	checkerboard_item_get_subtitle_allocation (item, &_tmp2_);
#line 1282 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	rect = _tmp2_;
#line 1284 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp3_ = rect;
#line 1284 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp4_ = _tmp3_.x;
#line 1284 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	px = (x - _tmp4_) * PANGO_SCALE;
#line 1285 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp5_ = rect;
#line 1285 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp6_ = _tmp5_.y;
#line 1285 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	py = (y - _tmp6_) * PANGO_SCALE;
#line 1286 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp7_ = layout;
#line 1286 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp8_ = px;
#line 1286 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp9_ = py;
#line 1286 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp12_ = pango_layout_xy_to_index (_tmp7_, _tmp8_, _tmp9_, &_tmp10_, &_tmp11_);
#line 1286 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	index = _tmp10_;
#line 1286 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	trailing = _tmp11_;
#line 1286 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp12_) {
#line 7618 "CheckerboardLayout.c"
		PangoLayout* _tmp13_;
		const gchar* _tmp14_;
		gint _tmp15_;
#line 1287 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp13_ = layout;
#line 1287 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp14_ = pango_layout_get_text (_tmp13_);
#line 1287 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp15_ = index;
#line 1287 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		result = checkerboard_layout_get_tag_index_at_pos (_tmp14_, _tmp15_);
#line 1287 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_g_object_unref0 (layout);
#line 1287 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		return result;
#line 7634 "CheckerboardLayout.c"
	}
#line 1288 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	result = -1;
#line 1288 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_g_object_unref0 (layout);
#line 1288 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return result;
#line 7642 "CheckerboardLayout.c"
}


gboolean
checkerboard_layout_handle_mouse_motion (CheckerboardLayout* self,
                                         CheckerboardItem* item,
                                         gint x,
                                         gint y,
                                         GdkModifierType mask)
{
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	gboolean _tmp2_;
	gint tag_index = 0;
	gint _tmp3_;
	gint _tmp4_;
#line 1291 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_val_if_fail (IS_CHECKERBOARD_LAYOUT (self), FALSE);
#line 1291 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_val_if_fail (IS_CHECKERBOARD_ITEM (item), FALSE);
#line 1292 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = checkerboard_item_get_has_tags (item);
#line 1292 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp2_ = _tmp1_;
#line 1292 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (!_tmp2_) {
#line 1292 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp0_ = TRUE;
#line 7672 "CheckerboardLayout.c"
	} else {
#line 1292 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp0_ = checkerboard_layout_is_drag_select_active (self);
#line 7676 "CheckerboardLayout.c"
	}
#line 1292 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp0_) {
#line 1293 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		result = FALSE;
#line 1293 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		return result;
#line 7684 "CheckerboardLayout.c"
	}
#line 1294 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	tag_index = checkerboard_layout_internal_handle_tag_mouse_event (self, item, x, y);
#line 1295 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp3_ = tag_index;
#line 1295 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	checkerboard_item_highlight_user_visible_tag (item, _tmp3_);
#line 1296 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp4_ = tag_index;
#line 1296 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	result = _tmp4_ >= 0;
#line 1296 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return result;
#line 7698 "CheckerboardLayout.c"
}


gboolean
checkerboard_layout_handle_left_click (CheckerboardLayout* self,
                                       CheckerboardItem* item,
                                       gdouble xd,
                                       gdouble yd,
                                       GdkModifierType mask)
{
	gboolean result = FALSE;
	gint tag_index = 0;
	gint _tmp0_;
#line 1299 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_val_if_fail (IS_CHECKERBOARD_LAYOUT (self), FALSE);
#line 1299 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_val_if_fail (IS_CHECKERBOARD_ITEM (item), FALSE);
#line 1300 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	tag_index = checkerboard_layout_internal_handle_tag_mouse_event (self, item, (gint) round (xd), (gint) round (yd));
#line 1301 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = tag_index;
#line 1301 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp0_ >= 0) {
#line 7722 "CheckerboardLayout.c"
		Tag* tag = NULL;
		gint _tmp1_;
		Tag* _tmp2_;
		LibraryWindow* _tmp3_;
		LibraryWindow* _tmp4_;
		Tag* _tmp5_;
#line 1302 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp1_ = tag_index;
#line 1302 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp2_ = checkerboard_item_get_user_visible_tag (item, _tmp1_);
#line 1302 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		tag = _tmp2_;
#line 1303 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp3_ = library_window_get_app ();
#line 1303 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp4_ = _tmp3_;
#line 1303 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp5_ = tag;
#line 1303 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		library_window_switch_to_tag (_tmp4_, _tmp5_);
#line 1303 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_g_object_unref0 (_tmp4_);
#line 1304 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		result = TRUE;
#line 1304 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_g_object_unref0 (tag);
#line 1304 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		return result;
#line 7751 "CheckerboardLayout.c"
	}
#line 1306 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	result = FALSE;
#line 1306 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return result;
#line 7757 "CheckerboardLayout.c"
}


GeeList*
checkerboard_layout_get_visible_items (CheckerboardLayout* self)
{
	GeeList* result = NULL;
	GdkRectangle _tmp0_;
	GeeList* _tmp1_;
#line 1309 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_val_if_fail (IS_CHECKERBOARD_LAYOUT (self), NULL);
#line 1310 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = self->priv->visible_page;
#line 1310 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = checkerboard_layout_intersection (self, &_tmp0_);
#line 1310 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	result = _tmp1_;
#line 1310 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return result;
#line 7777 "CheckerboardLayout.c"
}


GeeList*
checkerboard_layout_intersection (CheckerboardLayout* self,
                                  GdkRectangle* area)
{
	GeeList* result = NULL;
	GeeArrayList* intersects = NULL;
	GeeArrayList* _tmp0_;
	GtkAllocation allocation = {0};
	GtkAllocation _tmp1_ = {0};
	GdkRectangle bitbucket = {0};
	CheckerboardLayoutLayoutRow** _tmp2_;
	gint _tmp2__length1;
#line 1313 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_val_if_fail (IS_CHECKERBOARD_LAYOUT (self), NULL);
#line 1313 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_val_if_fail (area != NULL, NULL);
#line 1314 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = gee_array_list_new (TYPE_CHECKERBOARD_ITEM, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
#line 1314 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	intersects = _tmp0_;
#line 1317 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	gtk_widget_get_allocation (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), &_tmp1_);
#line 1317 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	allocation = _tmp1_;
#line 1319 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	memset (&bitbucket, 0, sizeof (GdkRectangle));
#line 1320 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp2_ = self->priv->item_rows;
#line 1320 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp2__length1 = self->priv->item_rows_length1;
#line 7811 "CheckerboardLayout.c"
	{
		CheckerboardLayoutLayoutRow** row_collection = NULL;
		gint row_collection_length1 = 0;
		gint _row_collection_size_ = 0;
		gint row_it = 0;
#line 1320 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		row_collection = _tmp2_;
#line 1320 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		row_collection_length1 = _tmp2__length1;
#line 1320 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		for (row_it = 0; row_it < _tmp2__length1; row_it = row_it + 1) {
#line 7823 "CheckerboardLayout.c"
			CheckerboardLayoutLayoutRow* _tmp3_;
			CheckerboardLayoutLayoutRow* row = NULL;
#line 1320 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp3_ = _checkerboard_layout_layout_row_ref0 (row_collection[row_it]);
#line 1320 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			row = _tmp3_;
#line 7830 "CheckerboardLayout.c"
			{
				CheckerboardLayoutLayoutRow* _tmp4_;
				GdkRectangle _tmp5_;
				gint _tmp6_;
				GdkRectangle _tmp7_;
				gint _tmp8_;
				CheckerboardLayoutLayoutRow* _tmp9_;
				gint _tmp10_;
				CheckerboardLayoutLayoutRow* _tmp11_;
				gint _tmp12_;
				CheckerboardLayoutLayoutRow* _tmp13_;
				gint _tmp14_;
				GdkRectangle _tmp15_;
				gint _tmp16_;
				GdkRectangle row_rect = {0};
				CheckerboardLayoutLayoutRow* _tmp17_;
				gint _tmp18_;
				GtkAllocation _tmp19_;
				gint _tmp20_;
				CheckerboardLayoutLayoutRow* _tmp21_;
				gint _tmp22_;
				GdkRectangle _tmp23_;
				GdkRectangle _tmp24_ = {0};
				gboolean _tmp25_;
#line 1321 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp4_ = row;
#line 1321 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				if (_tmp4_ == NULL) {
#line 1322 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_checkerboard_layout_layout_row_unref0 (row);
#line 1322 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					continue;
#line 7863 "CheckerboardLayout.c"
				}
#line 1324 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp5_ = *area;
#line 1324 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp6_ = _tmp5_.y;
#line 1324 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp7_ = *area;
#line 1324 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp8_ = _tmp7_.height;
#line 1324 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp9_ = row;
#line 1324 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp10_ = _tmp9_->y;
#line 1324 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				if ((_tmp6_ + _tmp8_) < _tmp10_) {
#line 1326 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_checkerboard_layout_layout_row_unref0 (row);
#line 1326 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					break;
#line 7883 "CheckerboardLayout.c"
				}
#line 1329 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp11_ = row;
#line 1329 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp12_ = _tmp11_->y;
#line 1329 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp13_ = row;
#line 1329 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp14_ = _tmp13_->height;
#line 1329 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp15_ = *area;
#line 1329 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp16_ = _tmp15_.y;
#line 1329 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				if ((_tmp12_ + _tmp14_) < _tmp16_) {
#line 1331 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_checkerboard_layout_layout_row_unref0 (row);
#line 1331 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					continue;
#line 7903 "CheckerboardLayout.c"
				}
#line 1335 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				memset (&row_rect, 0, sizeof (GdkRectangle));
#line 1336 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				row_rect.x = 0;
#line 1337 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp17_ = row;
#line 1337 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp18_ = _tmp17_->y;
#line 1337 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				row_rect.y = _tmp18_;
#line 1338 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp19_ = allocation;
#line 1338 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp20_ = _tmp19_.width;
#line 1338 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				row_rect.width = _tmp20_;
#line 1339 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp21_ = row;
#line 1339 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp22_ = _tmp21_->height;
#line 1339 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				row_rect.height = _tmp22_;
#line 1341 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp23_ = row_rect;
#line 1341 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp25_ = gdk_rectangle_intersect (area, &_tmp23_, &_tmp24_);
#line 1341 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				bitbucket = _tmp24_;
#line 1341 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				if (_tmp25_) {
#line 7935 "CheckerboardLayout.c"
					CheckerboardLayoutLayoutRow* _tmp26_;
					CheckerboardItem** _tmp27_;
					gint _tmp27__length1;
#line 1343 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp26_ = row;
#line 1343 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp27_ = _tmp26_->items;
#line 1343 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp27__length1 = _tmp26_->items_length1;
#line 7945 "CheckerboardLayout.c"
					{
						CheckerboardItem** item_collection = NULL;
						gint item_collection_length1 = 0;
						gint _item_collection_size_ = 0;
						gint item_it = 0;
#line 1343 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
						item_collection = _tmp27_;
#line 1343 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
						item_collection_length1 = _tmp27__length1;
#line 1343 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
						for (item_it = 0; item_it < _tmp27__length1; item_it = item_it + 1) {
#line 7957 "CheckerboardLayout.c"
							CheckerboardItem* _tmp28_;
							CheckerboardItem* item = NULL;
#line 1343 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
							_tmp28_ = _g_object_ref0 (item_collection[item_it]);
#line 1343 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
							item = _tmp28_;
#line 7964 "CheckerboardLayout.c"
							{
								CheckerboardItem* _tmp29_;
								CheckerboardItem* _tmp30_;
								GdkRectangle _tmp31_;
								GdkRectangle _tmp32_ = {0};
								gboolean _tmp33_;
#line 1344 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
								_tmp29_ = item;
#line 1344 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
								if (_tmp29_ == NULL) {
#line 1345 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
									_g_object_unref0 (item);
#line 1345 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
									continue;
#line 7979 "CheckerboardLayout.c"
								}
#line 1347 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
								_tmp30_ = item;
#line 1347 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
								_tmp31_ = _tmp30_->allocation;
#line 1347 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
								_tmp33_ = gdk_rectangle_intersect (area, &_tmp31_, &_tmp32_);
#line 1347 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
								bitbucket = _tmp32_;
#line 1347 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
								if (_tmp33_) {
#line 7991 "CheckerboardLayout.c"
									GeeArrayList* _tmp34_;
									CheckerboardItem* _tmp35_;
#line 1348 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
									_tmp34_ = intersects;
#line 1348 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
									_tmp35_ = item;
#line 1348 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
									gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp34_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp35_);
#line 8000 "CheckerboardLayout.c"
								}
#line 1343 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
								_g_object_unref0 (item);
#line 8004 "CheckerboardLayout.c"
							}
						}
					}
				}
#line 1320 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_checkerboard_layout_layout_row_unref0 (row);
#line 8011 "CheckerboardLayout.c"
			}
		}
	}
#line 1353 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	result = G_TYPE_CHECK_INSTANCE_CAST (intersects, GEE_TYPE_LIST, GeeList);
#line 1353 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return result;
#line 8019 "CheckerboardLayout.c"
}


CheckerboardItem*
checkerboard_layout_get_item_relative_to (CheckerboardLayout* self,
                                          CheckerboardItem* item,
                                          CompassPoint point)
{
	CheckerboardItem* result = NULL;
	ViewCollection* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint col = 0;
	gint row = 0;
	gboolean _tmp3_ = FALSE;
	gint _tmp4_;
	CheckerboardItem* new_item = NULL;
	gint _tmp27_;
	gint _tmp28_;
	CheckerboardItem* _tmp29_;
	gboolean _tmp30_ = FALSE;
	CheckerboardItem* _tmp31_;
	CheckerboardItem* _tmp35_ = NULL;
	CheckerboardItem* _tmp36_;
	CheckerboardItem* _tmp38_;
#line 1356 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_val_if_fail (IS_CHECKERBOARD_LAYOUT (self), NULL);
#line 1356 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_val_if_fail (IS_CHECKERBOARD_ITEM (item), NULL);
#line 1357 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = self->priv->view;
#line 1357 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (data_collection_get_count (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, TYPE_DATA_COLLECTION, DataCollection)) == 0) {
#line 1358 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		result = NULL;
#line 1358 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		return result;
#line 8057 "CheckerboardLayout.c"
	}
#line 1360 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = self->priv->columns;
#line 1360 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_vala_assert (_tmp1_ > 0, "columns > 0");
#line 1361 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp2_ = self->priv->rows;
#line 1361 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_vala_assert (_tmp2_ > 0, "rows > 0");
#line 1363 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	col = checkerboard_item_get_column (item);
#line 1364 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	row = checkerboard_item_get_row (item);
#line 1366 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp4_ = col;
#line 1366 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp4_ < 0) {
#line 1366 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp3_ = TRUE;
#line 8077 "CheckerboardLayout.c"
	} else {
		gint _tmp5_;
#line 1366 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp5_ = row;
#line 1366 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp3_ = _tmp5_ < 0;
#line 8084 "CheckerboardLayout.c"
	}
#line 1366 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp3_) {
#line 8088 "CheckerboardLayout.c"
		gchar* _tmp6_;
		gchar* _tmp7_;
#line 1367 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp6_ = checkerboard_item_get_title (item);
#line 1367 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp7_ = _tmp6_;
#line 1367 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		g_critical ("CheckerboardLayout.vala:1367: Attempting to locate item not placed in " \
"layout: %s", _tmp7_);
#line 1367 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_g_free0 (_tmp7_);
#line 1369 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		result = NULL;
#line 1369 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		return result;
#line 8103 "CheckerboardLayout.c"
	}
#line 1372 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	switch (point) {
#line 1372 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		case COMPASS_POINT_NORTH:
#line 8109 "CheckerboardLayout.c"
		{
			gint _tmp8_;
			gint _tmp9_;
#line 1374 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp8_ = row;
#line 1374 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			row = _tmp8_ - 1;
#line 1374 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp9_ = row;
#line 1374 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			if (_tmp9_ < 0) {
#line 1375 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				row = 0;
#line 8123 "CheckerboardLayout.c"
			}
#line 1376 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			break;
#line 8127 "CheckerboardLayout.c"
		}
#line 1372 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		case COMPASS_POINT_SOUTH:
#line 8131 "CheckerboardLayout.c"
		{
			gint _tmp10_;
			gint _tmp11_;
			gint _tmp12_;
#line 1379 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp10_ = row;
#line 1379 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			row = _tmp10_ + 1;
#line 1379 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp11_ = row;
#line 1379 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp12_ = self->priv->rows;
#line 1379 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			if (_tmp11_ >= _tmp12_) {
#line 8146 "CheckerboardLayout.c"
				gint _tmp13_;
#line 1380 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp13_ = self->priv->rows;
#line 1380 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				row = _tmp13_ - 1;
#line 8152 "CheckerboardLayout.c"
			}
#line 1381 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			break;
#line 8156 "CheckerboardLayout.c"
		}
#line 1372 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		case COMPASS_POINT_EAST:
#line 8160 "CheckerboardLayout.c"
		{
			gint _tmp14_;
			gint _tmp15_;
			gint _tmp16_;
#line 1384 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp14_ = col;
#line 1384 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			col = _tmp14_ + 1;
#line 1384 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp15_ = col;
#line 1384 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp16_ = self->priv->columns;
#line 1384 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			if (_tmp15_ >= _tmp16_) {
#line 8175 "CheckerboardLayout.c"
				gint _tmp17_;
				gint _tmp18_;
				gint _tmp19_;
#line 1385 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp17_ = row;
#line 1385 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				row = _tmp17_ + 1;
#line 1385 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp18_ = row;
#line 1385 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp19_ = self->priv->rows;
#line 1385 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				if (_tmp18_ >= _tmp19_) {
#line 8189 "CheckerboardLayout.c"
					gint _tmp20_;
					gint _tmp21_;
#line 1386 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp20_ = self->priv->rows;
#line 1386 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					row = _tmp20_ - 1;
#line 1387 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp21_ = self->priv->columns;
#line 1387 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					col = _tmp21_ - 1;
#line 8200 "CheckerboardLayout.c"
				} else {
#line 1389 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					col = 0;
#line 8204 "CheckerboardLayout.c"
				}
			}
#line 1392 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			break;
#line 8209 "CheckerboardLayout.c"
		}
#line 1372 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		case COMPASS_POINT_WEST:
#line 8213 "CheckerboardLayout.c"
		{
			gint _tmp22_;
			gint _tmp23_;
#line 1395 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp22_ = col;
#line 1395 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			col = _tmp22_ - 1;
#line 1395 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp23_ = col;
#line 1395 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			if (_tmp23_ < 0) {
#line 8225 "CheckerboardLayout.c"
				gint _tmp24_;
				gint _tmp25_;
#line 1396 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp24_ = row;
#line 1396 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				row = _tmp24_ - 1;
#line 1396 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp25_ = row;
#line 1396 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				if (_tmp25_ < 0) {
#line 1397 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					row = 0;
#line 1398 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					col = 0;
#line 8240 "CheckerboardLayout.c"
				} else {
					gint _tmp26_;
#line 1400 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp26_ = self->priv->columns;
#line 1400 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					col = _tmp26_ - 1;
#line 8247 "CheckerboardLayout.c"
				}
			}
#line 1403 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			break;
#line 8252 "CheckerboardLayout.c"
		}
		default:
		{
#line 1406 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			g_error ("CheckerboardLayout.vala:1406: Bad compass point %d", (gint) point);
#line 8258 "CheckerboardLayout.c"
		}
	}
#line 1409 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp27_ = col;
#line 1409 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp28_ = row;
#line 1409 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp29_ = checkerboard_layout_get_item_at_coordinate (self, _tmp27_, _tmp28_);
#line 1409 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	new_item = _tmp29_;
#line 1411 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp31_ = new_item;
#line 1411 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp31_ == NULL) {
#line 1411 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp30_ = point == COMPASS_POINT_SOUTH;
#line 8275 "CheckerboardLayout.c"
	} else {
#line 1411 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp30_ = FALSE;
#line 8279 "CheckerboardLayout.c"
	}
#line 1411 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp30_) {
#line 8283 "CheckerboardLayout.c"
		ViewCollection* _tmp32_;
		DataView* _tmp33_;
		CheckerboardItem* _tmp34_;
#line 1413 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp32_ = self->priv->view;
#line 1413 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp33_ = view_collection_get_last (_tmp32_);
#line 1413 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_g_object_unref0 (new_item);
#line 1413 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		new_item = G_TYPE_CHECK_INSTANCE_CAST (_tmp33_, TYPE_CHECKERBOARD_ITEM, CheckerboardItem);
#line 1414 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp34_ = new_item;
#line 1414 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		if (checkerboard_item_get_row (_tmp34_) <= checkerboard_item_get_row (item)) {
#line 1415 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_g_object_unref0 (new_item);
#line 1415 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			new_item = NULL;
#line 8303 "CheckerboardLayout.c"
		}
	}
#line 1418 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp36_ = new_item;
#line 1418 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp36_ != NULL) {
#line 8310 "CheckerboardLayout.c"
		CheckerboardItem* _tmp37_;
#line 1418 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp37_ = new_item;
#line 1418 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp35_ = _tmp37_;
#line 8316 "CheckerboardLayout.c"
	} else {
#line 1418 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp35_ = item;
#line 8320 "CheckerboardLayout.c"
	}
#line 1418 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp38_ = _g_object_ref0 (_tmp35_);
#line 1418 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	result = _tmp38_;
#line 1418 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_g_object_unref0 (new_item);
#line 1418 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return result;
#line 8330 "CheckerboardLayout.c"
}


CheckerboardItem*
checkerboard_layout_get_item_at_coordinate (CheckerboardLayout* self,
                                            gint col,
                                            gint row)
{
	CheckerboardItem* result = NULL;
	CheckerboardLayoutLayoutRow** _tmp0_;
	gint _tmp0__length1;
	CheckerboardLayoutLayoutRow* item_row = NULL;
	CheckerboardLayoutLayoutRow** _tmp1_;
	gint _tmp1__length1;
	CheckerboardLayoutLayoutRow* _tmp2_;
	CheckerboardLayoutLayoutRow* _tmp3_;
	CheckerboardLayoutLayoutRow* _tmp4_;
	CheckerboardLayoutLayoutRow* _tmp5_;
	CheckerboardItem** _tmp6_;
	gint _tmp6__length1;
	CheckerboardLayoutLayoutRow* _tmp7_;
	CheckerboardItem** _tmp8_;
	gint _tmp8__length1;
	CheckerboardItem* _tmp9_;
	CheckerboardItem* _tmp10_;
#line 1421 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_val_if_fail (IS_CHECKERBOARD_LAYOUT (self), NULL);
#line 1422 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = self->priv->item_rows;
#line 1422 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0__length1 = self->priv->item_rows_length1;
#line 1422 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (row >= _tmp0__length1) {
#line 1423 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		result = NULL;
#line 1423 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		return result;
#line 8368 "CheckerboardLayout.c"
	}
#line 1425 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = self->priv->item_rows;
#line 1425 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1__length1 = self->priv->item_rows_length1;
#line 1425 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp2_ = _tmp1_[row];
#line 1425 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp3_ = _checkerboard_layout_layout_row_ref0 (_tmp2_);
#line 1425 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	item_row = _tmp3_;
#line 1426 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp4_ = item_row;
#line 1426 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp4_ == NULL) {
#line 1427 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		result = NULL;
#line 1427 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_checkerboard_layout_layout_row_unref0 (item_row);
#line 1427 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		return result;
#line 8390 "CheckerboardLayout.c"
	}
#line 1429 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp5_ = item_row;
#line 1429 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp6_ = _tmp5_->items;
#line 1429 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp6__length1 = _tmp5_->items_length1;
#line 1429 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (col >= _tmp6__length1) {
#line 1430 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		result = NULL;
#line 1430 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_checkerboard_layout_layout_row_unref0 (item_row);
#line 1430 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		return result;
#line 8406 "CheckerboardLayout.c"
	}
#line 1432 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp7_ = item_row;
#line 1432 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp8_ = _tmp7_->items;
#line 1432 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp8__length1 = _tmp7_->items_length1;
#line 1432 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp9_ = _tmp8_[col];
#line 1432 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp10_ = _g_object_ref0 (_tmp9_);
#line 1432 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	result = _tmp10_;
#line 1432 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_checkerboard_layout_layout_row_unref0 (item_row);
#line 1432 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return result;
#line 8424 "CheckerboardLayout.c"
}


void
checkerboard_layout_set_drag_select_origin (CheckerboardLayout* self,
                                            gint x,
                                            gint y)
{
	GtkAllocation allocation = {0};
	GtkAllocation _tmp0_ = {0};
	GtkAllocation _tmp1_;
	gint _tmp2_;
	GtkAllocation _tmp3_;
	gint _tmp4_;
#line 1435 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (IS_CHECKERBOARD_LAYOUT (self));
#line 1436 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	checkerboard_layout_clear_drag_select (self);
#line 1439 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	gtk_widget_get_allocation (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), &_tmp0_);
#line 1439 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	allocation = _tmp0_;
#line 1441 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = allocation;
#line 1441 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp2_ = _tmp1_.width;
#line 1441 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->drag_origin.x = CLAMP (x, 0, _tmp2_);
#line 1442 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp3_ = allocation;
#line 1442 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp4_ = _tmp3_.height;
#line 1442 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->drag_origin.y = CLAMP (y, 0, _tmp4_);
#line 8459 "CheckerboardLayout.c"
}


void
checkerboard_layout_set_drag_select_endpoint (CheckerboardLayout* self,
                                              gint x,
                                              gint y)
{
	GtkAllocation allocation = {0};
	GtkAllocation _tmp0_ = {0};
	GtkAllocation _tmp1_;
	gint _tmp2_;
	GtkAllocation _tmp3_;
	gint _tmp4_;
	GdkRectangle old_selection_band = {0};
	GdkRectangle _tmp5_;
	GdkPoint _tmp6_;
	GdkPoint _tmp7_;
	Box _tmp8_ = {0};
	GdkRectangle _tmp9_ = {0};
	GdkWindow* _tmp10_;
#line 1445 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (IS_CHECKERBOARD_LAYOUT (self));
#line 1447 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	gtk_widget_get_allocation (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), &_tmp0_);
#line 1447 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	allocation = _tmp0_;
#line 1449 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = allocation;
#line 1449 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp2_ = _tmp1_.width;
#line 1449 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->drag_endpoint.x = CLAMP (x, 0, _tmp2_);
#line 1450 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp3_ = allocation;
#line 1450 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp4_ = _tmp3_.height;
#line 1450 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->drag_endpoint.y = CLAMP (y, 0, _tmp4_);
#line 1454 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp5_ = self->priv->selection_band;
#line 1454 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	old_selection_band = _tmp5_;
#line 1455 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp6_ = self->priv->drag_origin;
#line 1455 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp7_ = self->priv->drag_endpoint;
#line 1455 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	box_from_points (&_tmp6_, &_tmp7_, &_tmp8_);
#line 1455 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	box_get_rectangle (&_tmp8_, &_tmp9_);
#line 1455 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->selection_band = _tmp9_;
#line 1458 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp10_ = gtk_widget_get_window (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
#line 1458 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp10_ != NULL) {
#line 8517 "CheckerboardLayout.c"
		GdkRectangle _union_ = {0};
		GdkRectangle _tmp11_;
		GdkRectangle _tmp12_ = {0};
		GdkRectangle _tmp13_;
		gint _tmp14_;
		GdkRectangle _tmp15_;
		gint _tmp16_;
		GdkRectangle _tmp17_;
		gint _tmp18_;
		GdkRectangle _tmp19_;
		gint _tmp20_;
#line 1460 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp11_ = old_selection_band;
#line 1460 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		gdk_rectangle_union (&self->priv->selection_band, &_tmp11_, &_tmp12_);
#line 1460 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_union_ = _tmp12_;
#line 1462 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp13_ = _union_;
#line 1462 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp14_ = _tmp13_.x;
#line 1462 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp15_ = _union_;
#line 1462 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp16_ = _tmp15_.y;
#line 1462 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp17_ = _union_;
#line 1462 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp18_ = _tmp17_.width;
#line 1462 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp19_ = _union_;
#line 1462 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp20_ = _tmp19_.height;
#line 1462 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		gtk_widget_queue_draw_area (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), _tmp14_, _tmp16_, _tmp18_, _tmp20_);
#line 8553 "CheckerboardLayout.c"
	}
}


GeeList*
checkerboard_layout_items_in_selection_band (CheckerboardLayout* self)
{
	GeeList* result = NULL;
	GdkRectangle _tmp0_;
	Dimensions _tmp1_ = {0};
	GdkRectangle _tmp2_;
	GeeList* _tmp3_;
#line 1466 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_val_if_fail (IS_CHECKERBOARD_LAYOUT (self), NULL);
#line 1467 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = self->priv->selection_band;
#line 1467 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	dimensions_for_rectangle (&_tmp0_, &_tmp1_);
#line 1467 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (!dimensions_has_area (&_tmp1_)) {
#line 1468 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		result = NULL;
#line 1468 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		return result;
#line 8578 "CheckerboardLayout.c"
	}
#line 1470 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp2_ = self->priv->selection_band;
#line 1470 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp3_ = checkerboard_layout_intersection (self, &_tmp2_);
#line 1470 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	result = _tmp3_;
#line 1470 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return result;
#line 8588 "CheckerboardLayout.c"
}


gboolean
checkerboard_layout_is_drag_select_active (CheckerboardLayout* self)
{
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	GdkPoint _tmp1_;
	gint _tmp2_;
#line 1473 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_val_if_fail (IS_CHECKERBOARD_LAYOUT (self), FALSE);
#line 1474 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = self->priv->drag_origin;
#line 1474 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp2_ = _tmp1_.x;
#line 1474 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp2_ >= 0) {
#line 8607 "CheckerboardLayout.c"
		GdkPoint _tmp3_;
		gint _tmp4_;
#line 1474 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp3_ = self->priv->drag_origin;
#line 1474 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp4_ = _tmp3_.y;
#line 1474 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp0_ = _tmp4_ >= 0;
#line 8616 "CheckerboardLayout.c"
	} else {
#line 1474 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp0_ = FALSE;
#line 8620 "CheckerboardLayout.c"
	}
#line 1474 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	result = _tmp0_;
#line 1474 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return result;
#line 8626 "CheckerboardLayout.c"
}


void
checkerboard_layout_clear_drag_select (CheckerboardLayout* self)
{
#line 1477 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (IS_CHECKERBOARD_LAYOUT (self));
#line 1478 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	memset (&self->priv->selection_band, 0, sizeof (GdkRectangle));
#line 1479 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->drag_origin.x = -1;
#line 1480 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->drag_origin.y = -1;
#line 1481 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->drag_endpoint.x = -1;
#line 1482 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->drag_endpoint.y = -1;
#line 1485 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	gtk_widget_queue_draw (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
#line 8647 "CheckerboardLayout.c"
}


static void
checkerboard_layout_viewport_resized (CheckerboardLayout* self)
{
	GdkRectangle _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
#line 1488 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (IS_CHECKERBOARD_LAYOUT (self));
#line 1490 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	checkerboard_layout_update_visible_page (self);
#line 1493 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = self->priv->visible_page;
#line 1493 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = _tmp0_.width;
#line 1493 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp2_ = self->priv->last_width;
#line 1493 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp1_ != _tmp2_) {
#line 8669 "CheckerboardLayout.c"
		gint old_width = 0;
		gint _tmp3_;
		GdkRectangle _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		GdkRectangle _tmp7_;
		gint _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
#line 1494 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp3_ = self->priv->last_width;
#line 1494 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		old_width = _tmp3_;
#line 1495 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp4_ = self->priv->visible_page;
#line 1495 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp5_ = _tmp4_.width;
#line 1495 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		self->priv->last_width = _tmp5_;
#line 1497 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp6_ = old_width;
#line 1497 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp7_ = self->priv->visible_page;
#line 1497 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp8_ = _tmp7_.width;
#line 1497 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp9_ = g_strdup_printf ("viewport_resized (%d -> %d)", _tmp6_, _tmp8_);
#line 1497 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp10_ = _tmp9_;
#line 1497 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		checkerboard_layout_need_reflow (self, _tmp10_);
#line 1497 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_g_free0 (_tmp10_);
#line 8703 "CheckerboardLayout.c"
	} else {
		gint _tmp11_;
		gchar* _tmp12_;
		gchar* _tmp13_;
#line 1500 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp11_ = self->priv->last_width;
#line 1500 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp12_ = g_strdup_printf ("viewport_resized (same width=%d)", _tmp11_);
#line 1500 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp13_ = _tmp12_;
#line 1500 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		checkerboard_layout_need_exposure (self, _tmp13_);
#line 1500 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_g_free0 (_tmp13_);
#line 8718 "CheckerboardLayout.c"
	}
}


static void
checkerboard_layout_expose_items (CheckerboardLayout* self,
                                  const gchar* caller)
{
	GeeHashSet* new_exposed_items = NULL;
	GeeHashSet* _tmp0_;
	ViewCollection* _tmp1_;
	GeeList* items = NULL;
	GeeList* _tmp2_;
	GeeHashSet* _tmp25_;
	GeeHashSet* _tmp26_;
	ViewCollection* _tmp27_;
#line 1504 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (IS_CHECKERBOARD_LAYOUT (self));
#line 1504 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (caller != NULL);
#line 1507 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = gee_hash_set_new (TYPE_CHECKERBOARD_ITEM, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL);
#line 1507 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	new_exposed_items = _tmp0_;
#line 1509 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = self->priv->view;
#line 1509 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	data_collection_freeze_notifications (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TYPE_DATA_COLLECTION, DataCollection));
#line 1511 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp2_ = checkerboard_layout_get_visible_items (self);
#line 1511 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	items = _tmp2_;
#line 8751 "CheckerboardLayout.c"
	{
		GeeList* _item_list = NULL;
		GeeList* _tmp3_;
		GeeList* _tmp4_;
		gint _item_size = 0;
		GeeList* _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
		gint _item_index = 0;
#line 1512 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp3_ = items;
#line 1512 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp4_ = _g_object_ref0 (_tmp3_);
#line 1512 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_item_list = _tmp4_;
#line 1512 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp5_ = _item_list;
#line 1512 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp6_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, GEE_TYPE_COLLECTION, GeeCollection));
#line 1512 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp7_ = _tmp6_;
#line 1512 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_item_size = _tmp7_;
#line 1512 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_item_index = -1;
#line 1512 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		while (TRUE) {
#line 8779 "CheckerboardLayout.c"
			gint _tmp8_;
			gint _tmp9_;
			gint _tmp10_;
			CheckerboardItem* item = NULL;
			GeeList* _tmp11_;
			gint _tmp12_;
			gpointer _tmp13_;
			GeeHashSet* _tmp14_;
			CheckerboardItem* _tmp15_;
			GeeHashSet* _tmp16_;
			CheckerboardItem* _tmp17_;
#line 1512 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp8_ = _item_index;
#line 1512 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_item_index = _tmp8_ + 1;
#line 1512 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp9_ = _item_index;
#line 1512 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp10_ = _item_size;
#line 1512 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			if (!(_tmp9_ < _tmp10_)) {
#line 1512 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				break;
#line 8803 "CheckerboardLayout.c"
			}
#line 1512 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp11_ = _item_list;
#line 1512 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp12_ = _item_index;
#line 1512 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp13_ = gee_list_get (_tmp11_, _tmp12_);
#line 1512 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			item = (CheckerboardItem*) _tmp13_;
#line 1513 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp14_ = new_exposed_items;
#line 1513 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp15_ = item;
#line 1513 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp15_);
#line 1516 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp16_ = self->priv->exposed_items;
#line 1516 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp17_ = item;
#line 1516 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			if (!gee_abstract_collection_remove (G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp17_)) {
#line 8825 "CheckerboardLayout.c"
				CheckerboardItem* _tmp18_;
#line 1517 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp18_ = item;
#line 1517 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				checkerboard_item_exposed (_tmp18_);
#line 8831 "CheckerboardLayout.c"
			}
#line 1512 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_g_object_unref0 (item);
#line 8835 "CheckerboardLayout.c"
		}
#line 1512 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_g_object_unref0 (_item_list);
#line 8839 "CheckerboardLayout.c"
	}
	{
		GeeIterator* _item_it = NULL;
		GeeHashSet* _tmp19_;
		GeeIterator* _tmp20_;
#line 1521 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp19_ = self->priv->exposed_items;
#line 1521 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp20_ = gee_abstract_collection_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp19_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
#line 1521 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_item_it = _tmp20_;
#line 1521 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		while (TRUE) {
#line 8853 "CheckerboardLayout.c"
			GeeIterator* _tmp21_;
			CheckerboardItem* item = NULL;
			GeeIterator* _tmp22_;
			gpointer _tmp23_;
			CheckerboardItem* _tmp24_;
#line 1521 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp21_ = _item_it;
#line 1521 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			if (!gee_iterator_next (_tmp21_)) {
#line 1521 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				break;
#line 8865 "CheckerboardLayout.c"
			}
#line 1521 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp22_ = _item_it;
#line 1521 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp23_ = gee_iterator_get (_tmp22_);
#line 1521 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			item = (CheckerboardItem*) _tmp23_;
#line 1522 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp24_ = item;
#line 1522 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			checkerboard_item_unexposed (_tmp24_);
#line 1521 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_g_object_unref0 (item);
#line 8879 "CheckerboardLayout.c"
		}
#line 1521 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_g_object_unref0 (_item_it);
#line 8883 "CheckerboardLayout.c"
	}
#line 1525 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp25_ = new_exposed_items;
#line 1525 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp26_ = _g_object_ref0 (_tmp25_);
#line 1525 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_g_object_unref0 (self->priv->exposed_items);
#line 1525 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->exposed_items = _tmp26_;
#line 1526 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->exposure_dirty = FALSE;
#line 1531 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp27_ = self->priv->view;
#line 1531 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	data_collection_thaw_notifications (G_TYPE_CHECK_INSTANCE_CAST (_tmp27_, TYPE_DATA_COLLECTION, DataCollection));
#line 1504 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_g_object_unref0 (items);
#line 1504 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_g_object_unref0 (new_exposed_items);
#line 8903 "CheckerboardLayout.c"
}


static void
checkerboard_layout_unexpose_items (CheckerboardLayout* self,
                                    const gchar* caller)
{
	ViewCollection* _tmp0_;
	GeeHashSet* _tmp7_;
	ViewCollection* _tmp8_;
#line 1537 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (IS_CHECKERBOARD_LAYOUT (self));
#line 1537 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (caller != NULL);
#line 1538 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = self->priv->view;
#line 1538 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	data_collection_freeze_notifications (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, TYPE_DATA_COLLECTION, DataCollection));
#line 8922 "CheckerboardLayout.c"
	{
		GeeIterator* _item_it = NULL;
		GeeHashSet* _tmp1_;
		GeeIterator* _tmp2_;
#line 1540 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp1_ = self->priv->exposed_items;
#line 1540 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp2_ = gee_abstract_collection_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
#line 1540 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_item_it = _tmp2_;
#line 1540 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		while (TRUE) {
#line 8935 "CheckerboardLayout.c"
			GeeIterator* _tmp3_;
			CheckerboardItem* item = NULL;
			GeeIterator* _tmp4_;
			gpointer _tmp5_;
			CheckerboardItem* _tmp6_;
#line 1540 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp3_ = _item_it;
#line 1540 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			if (!gee_iterator_next (_tmp3_)) {
#line 1540 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				break;
#line 8947 "CheckerboardLayout.c"
			}
#line 1540 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp4_ = _item_it;
#line 1540 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp5_ = gee_iterator_get (_tmp4_);
#line 1540 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			item = (CheckerboardItem*) _tmp5_;
#line 1541 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp6_ = item;
#line 1541 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			checkerboard_item_unexposed (_tmp6_);
#line 1540 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_g_object_unref0 (item);
#line 8961 "CheckerboardLayout.c"
		}
#line 1540 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_g_object_unref0 (_item_it);
#line 8965 "CheckerboardLayout.c"
	}
#line 1543 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp7_ = self->priv->exposed_items;
#line 1543 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	gee_abstract_collection_clear (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
#line 1544 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->exposure_dirty = FALSE;
#line 1549 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp8_ = self->priv->view;
#line 1549 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	data_collection_thaw_notifications (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, TYPE_DATA_COLLECTION, DataCollection));
#line 8977 "CheckerboardLayout.c"
}


static void
checkerboard_layout_reflow (CheckerboardLayout* self,
                            const gchar* caller)
{
	const gchar* _tmp0_;
	GtkAllocation allocation = {0};
	GtkAllocation _tmp1_ = {0};
	gint _tmp2_ = 0;
	GdkRectangle _tmp3_;
	gint _tmp4_;
	gint visible_width = 0;
	gint _tmp9_;
	gint total_items = 0;
	ViewCollection* _tmp10_;
	gint _tmp11_;
	gboolean _tmp14_ = FALSE;
	CheckerboardItem* _tmp15_;
	gint max_cols = 0;
	gint _tmp17_;
	gint _tmp60_;
	gint max_rows = 0;
	gint _tmp61_;
	gint _tmp62_;
	gint row = 0;
	gint tallest = 0;
	gint widest = 0;
	gint row_alignment_point = 0;
	gint total_width = 0;
	gint col = 0;
	gint* column_widths = NULL;
	gint _tmp63_;
	gint* _tmp64_;
	gint column_widths_length1;
	gint _column_widths_size_;
	gint* row_heights = NULL;
	gint _tmp65_;
	gint* _tmp66_;
	gint row_heights_length1;
	gint _row_heights_size_;
	gint* alignment_points = NULL;
	gint _tmp67_;
	gint* _tmp68_;
	gint alignment_points_length1;
	gint _alignment_points_size_;
	gint gutter = 0;
	gint _tmp177_;
	CheckerboardLayoutLayoutRow** _tmp178_;
	gint x = 0;
	gint _tmp179_;
	gint y = 0;
	CheckerboardLayoutLayoutRow* current_row = NULL;
	CheckerboardLayoutLayoutRow* _tmp248_;
	gint _tmp254_;
	gint _tmp255_;
	gint _tmp256_;
	gint _tmp257_;
	gint total_height = 0;
	gint _tmp258_;
	gint* _tmp259_;
	gint _tmp259__length1;
	gint _tmp260_;
	gint _tmp261_;
	gboolean _tmp262_ = FALSE;
	gint _tmp263_;
	GtkAllocation _tmp264_;
	gint _tmp265_;
#line 1555 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (IS_CHECKERBOARD_LAYOUT (self));
#line 1555 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (caller != NULL);
#line 1556 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->reflow_needed = FALSE;
#line 1559 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = self->priv->message;
#line 1559 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp0_ != NULL) {
#line 1560 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		return;
#line 9059 "CheckerboardLayout.c"
	}
#line 1563 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	gtk_widget_get_allocation (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), &_tmp1_);
#line 1563 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	allocation = _tmp1_;
#line 1565 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp3_ = self->priv->visible_page;
#line 1565 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp4_ = _tmp3_.width;
#line 1565 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp4_ > 0) {
#line 9071 "CheckerboardLayout.c"
		GdkRectangle _tmp5_;
		gint _tmp6_;
#line 1565 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp5_ = self->priv->visible_page;
#line 1565 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp6_ = _tmp5_.width;
#line 1565 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp2_ = _tmp6_;
#line 9080 "CheckerboardLayout.c"
	} else {
		GtkAllocation _tmp7_;
		gint _tmp8_;
#line 1565 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp7_ = allocation;
#line 1565 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp8_ = _tmp7_.width;
#line 1565 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp2_ = _tmp8_;
#line 9090 "CheckerboardLayout.c"
	}
#line 1565 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	visible_width = _tmp2_;
#line 1573 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp9_ = visible_width;
#line 1573 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp9_ <= 1) {
#line 1574 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		return;
#line 9100 "CheckerboardLayout.c"
	}
#line 1576 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp10_ = self->priv->view;
#line 1576 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	total_items = data_collection_get_count (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, TYPE_DATA_COLLECTION, DataCollection));
#line 1579 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp11_ = total_items;
#line 1579 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp11_ == 0) {
#line 9110 "CheckerboardLayout.c"
		gint _tmp12_;
		CheckerboardLayoutLayoutRow** _tmp13_;
#line 1580 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp12_ = visible_width;
#line 1580 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		gtk_widget_set_size_request (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), _tmp12_, 0);
#line 1581 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp13_ = g_new0 (CheckerboardLayoutLayoutRow*, 0 + 1);
#line 1581 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		self->priv->item_rows = (_vala_array_free (self->priv->item_rows, self->priv->item_rows_length1, (GDestroyNotify) checkerboard_layout_layout_row_unref), NULL);
#line 1581 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		self->priv->item_rows = _tmp13_;
#line 1581 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		self->priv->item_rows_length1 = 0;
#line 1581 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		self->priv->_item_rows_size_ = self->priv->item_rows_length1;
#line 1583 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		return;
#line 9129 "CheckerboardLayout.c"
	}
#line 1591 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp15_ = self->priv->anchor;
#line 1591 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp15_ == NULL) {
#line 1591 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp14_ = TRUE;
#line 9137 "CheckerboardLayout.c"
	} else {
		CheckerboardItem* _tmp16_;
#line 1591 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp16_ = self->priv->anchor;
#line 1591 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp14_ = !data_view_is_visible (G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, TYPE_DATA_VIEW, DataView));
#line 9144 "CheckerboardLayout.c"
	}
#line 1591 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp14_) {
#line 1592 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		checkerboard_layout_update_anchor (self);
#line 9150 "CheckerboardLayout.c"
	}
#line 1595 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->item_rows = (_vala_array_free (self->priv->item_rows, self->priv->item_rows_length1, (GDestroyNotify) checkerboard_layout_layout_row_unref), NULL);
#line 1595 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->item_rows = NULL;
#line 1595 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->item_rows_length1 = 0;
#line 1595 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->_item_rows_size_ = self->priv->item_rows_length1;
#line 1600 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	max_cols = 0;
#line 1601 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp17_ = self->priv->scale;
#line 1601 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp17_ > 0) {
#line 9166 "CheckerboardLayout.c"
		gint remaining_width = 0;
		gint _tmp18_;
		gint max_item_width = 0;
		gint _tmp19_;
		gint _tmp20_;
		gint _tmp21_;
		gint _tmp22_;
		gint _tmp30_;
		gint _tmp31_;
#line 1603 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp18_ = visible_width;
#line 1603 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		remaining_width = _tmp18_ - (CHECKERBOARD_LAYOUT_COLUMN_GUTTER_PADDING * 2);
#line 1604 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp19_ = self->priv->scale;
#line 1604 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		max_item_width = checkerboard_item_get_max_width (_tmp19_);
#line 1605 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp20_ = remaining_width;
#line 1605 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp21_ = max_item_width;
#line 1605 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		max_cols = _tmp20_ / _tmp21_;
#line 1606 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp22_ = max_cols;
#line 1606 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		if (_tmp22_ <= 0) {
#line 1607 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			max_cols = 1;
#line 9196 "CheckerboardLayout.c"
		}
#line 1610 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		while (TRUE) {
#line 9200 "CheckerboardLayout.c"
			gboolean _tmp23_ = FALSE;
			gint _tmp24_;
			gint _tmp29_;
#line 1610 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp24_ = max_cols;
#line 1610 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			if (_tmp24_ > 1) {
#line 9208 "CheckerboardLayout.c"
				gint _tmp25_;
				gint _tmp26_;
				gint _tmp27_;
				gint _tmp28_;
#line 1611 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp25_ = max_cols;
#line 1611 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp26_ = max_item_width;
#line 1611 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp27_ = max_cols;
#line 1611 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp28_ = remaining_width;
#line 1611 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp23_ = ((_tmp25_ * _tmp26_) + ((_tmp27_ - 1) * CHECKERBOARD_LAYOUT_COLUMN_GUTTER_PADDING)) > _tmp28_;
#line 9223 "CheckerboardLayout.c"
			} else {
#line 1610 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp23_ = FALSE;
#line 9227 "CheckerboardLayout.c"
			}
#line 1610 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			if (!_tmp23_) {
#line 1610 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				break;
#line 9233 "CheckerboardLayout.c"
			}
#line 1616 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp29_ = max_cols;
#line 1616 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			max_cols = _tmp29_ - 1;
#line 9239 "CheckerboardLayout.c"
		}
#line 1620 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp30_ = total_items;
#line 1620 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp31_ = max_cols;
#line 1620 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		if (_tmp30_ < _tmp31_) {
#line 9247 "CheckerboardLayout.c"
			gint _tmp32_;
#line 1621 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp32_ = total_items;
#line 1621 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			max_cols = _tmp32_;
#line 9253 "CheckerboardLayout.c"
		}
	} else {
		gint x = 0;
		gint col = 0;
		gint row_width = 0;
		gint widest_row = 0;
		gint _tmp57_;
		gint _tmp58_;
#line 1628 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		x = CHECKERBOARD_LAYOUT_COLUMN_GUTTER_PADDING;
#line 1629 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		col = 0;
#line 1630 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		row_width = 0;
#line 1631 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		widest_row = 0;
#line 9270 "CheckerboardLayout.c"
		{
			gint ctr = 0;
#line 1633 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			ctr = 0;
#line 9275 "CheckerboardLayout.c"
			{
				gboolean _tmp33_ = FALSE;
#line 1633 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp33_ = TRUE;
#line 1633 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				while (TRUE) {
#line 9282 "CheckerboardLayout.c"
					gint _tmp35_;
					gint _tmp36_;
					CheckerboardItem* item = NULL;
					ViewCollection* _tmp37_;
					gint _tmp38_;
					DataObject* _tmp39_;
					Dimensions req = {0};
					CheckerboardItem* _tmp40_;
					Dimensions _tmp41_;
					gint _tmp42_;
					Dimensions _tmp43_;
					gint _tmp44_;
					gint _tmp45_;
					gint _tmp50_;
					Dimensions _tmp51_;
					gint _tmp52_;
					gint _tmp53_;
					Dimensions _tmp54_;
					gint _tmp55_;
					gint _tmp56_;
#line 1633 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					if (!_tmp33_) {
#line 9305 "CheckerboardLayout.c"
						gint _tmp34_;
#line 1633 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
						_tmp34_ = ctr;
#line 1633 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
						ctr = _tmp34_ + 1;
#line 9311 "CheckerboardLayout.c"
					}
#line 1633 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp33_ = FALSE;
#line 1633 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp35_ = ctr;
#line 1633 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp36_ = total_items;
#line 1633 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					if (!(_tmp35_ < _tmp36_)) {
#line 1633 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
						break;
#line 9323 "CheckerboardLayout.c"
					}
#line 1634 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp37_ = self->priv->view;
#line 1634 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp38_ = ctr;
#line 1634 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp39_ = data_collection_get_at (G_TYPE_CHECK_INSTANCE_CAST (_tmp37_, TYPE_DATA_COLLECTION, DataCollection), _tmp38_);
#line 1634 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					item = G_TYPE_CHECK_INSTANCE_CAST (_tmp39_, TYPE_CHECKERBOARD_ITEM, CheckerboardItem);
#line 1635 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp40_ = item;
#line 1635 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp41_ = _tmp40_->requisition;
#line 1635 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					req = _tmp41_;
#line 1638 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_vala_assert (dimensions_has_area (&req), "req.has_area()");
#line 1641 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp42_ = x;
#line 1641 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp43_ = req;
#line 1641 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp44_ = _tmp43_.width;
#line 1641 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp45_ = visible_width;
#line 1641 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					if (((_tmp42_ + _tmp44_) + CHECKERBOARD_LAYOUT_COLUMN_GUTTER_PADDING) > _tmp45_) {
#line 9351 "CheckerboardLayout.c"
						gint _tmp46_;
						gint _tmp47_;
#line 1642 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
						_tmp46_ = row_width;
#line 1642 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
						_tmp47_ = widest_row;
#line 1642 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
						if (_tmp46_ > _tmp47_) {
#line 9360 "CheckerboardLayout.c"
							gint _tmp48_;
							gint _tmp49_;
#line 1643 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
							_tmp48_ = row_width;
#line 1643 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
							widest_row = _tmp48_;
#line 1644 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
							_tmp49_ = col;
#line 1644 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
							max_cols = _tmp49_;
#line 9371 "CheckerboardLayout.c"
						}
#line 1647 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
						col = 0;
#line 1648 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
						x = CHECKERBOARD_LAYOUT_COLUMN_GUTTER_PADDING;
#line 1649 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
						row_width = 0;
#line 9379 "CheckerboardLayout.c"
					}
#line 1652 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp50_ = x;
#line 1652 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp51_ = req;
#line 1652 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp52_ = _tmp51_.width;
#line 1652 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					x = _tmp50_ + (_tmp52_ + CHECKERBOARD_LAYOUT_COLUMN_GUTTER_PADDING);
#line 1653 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp53_ = row_width;
#line 1653 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp54_ = req;
#line 1653 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp55_ = _tmp54_.width;
#line 1653 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					row_width = _tmp53_ + _tmp55_;
#line 1655 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp56_ = col;
#line 1655 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					col = _tmp56_ + 1;
#line 1633 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_g_object_unref0 (item);
#line 9403 "CheckerboardLayout.c"
				}
			}
		}
#line 1659 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp57_ = row_width;
#line 1659 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp58_ = widest_row;
#line 1659 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		if (_tmp57_ > _tmp58_) {
#line 9413 "CheckerboardLayout.c"
			gint _tmp59_;
#line 1660 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp59_ = col;
#line 1660 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			max_cols = _tmp59_;
#line 9419 "CheckerboardLayout.c"
		}
	}
#line 1668 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp60_ = max_cols;
#line 1668 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_vala_assert (_tmp60_ > 0, "max_cols > 0");
#line 1669 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp61_ = total_items;
#line 1669 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp62_ = max_cols;
#line 1669 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	max_rows = (_tmp61_ / _tmp62_) + 1;
#line 1673 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	row = 0;
#line 1674 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	tallest = 0;
#line 1675 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	widest = 0;
#line 1676 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	row_alignment_point = 0;
#line 1677 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	total_width = 0;
#line 1678 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	col = 0;
#line 1679 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp63_ = max_cols;
#line 1679 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp64_ = g_new0 (gint, _tmp63_);
#line 1679 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	column_widths = _tmp64_;
#line 1679 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	column_widths_length1 = _tmp63_;
#line 1679 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_column_widths_size_ = column_widths_length1;
#line 1680 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp65_ = max_rows;
#line 1680 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp66_ = g_new0 (gint, _tmp65_);
#line 1680 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	row_heights = _tmp66_;
#line 1680 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	row_heights_length1 = _tmp65_;
#line 1680 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_row_heights_size_ = row_heights_length1;
#line 1681 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp67_ = max_rows;
#line 1681 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp68_ = g_new0 (gint, _tmp67_);
#line 1681 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	alignment_points = _tmp68_;
#line 1681 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	alignment_points_length1 = _tmp67_;
#line 1681 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_alignment_points_size_ = alignment_points_length1;
#line 1682 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	gutter = 0;
#line 9476 "CheckerboardLayout.c"
	{
		gboolean _tmp69_ = FALSE;
#line 1684 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp69_ = TRUE;
#line 1684 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		while (TRUE) {
#line 9483 "CheckerboardLayout.c"
			gint _tmp124_;
			gint _tmp133_;
			gint _tmp134_;
			gint _tmp135_;
			gint _tmp136_;
			gint _tmp137_;
#line 1684 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			if (!_tmp69_) {
#line 9492 "CheckerboardLayout.c"
			}
#line 1684 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp69_ = FALSE;
#line 9496 "CheckerboardLayout.c"
			{
				gint ctr = 0;
#line 1685 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				ctr = 0;
#line 9501 "CheckerboardLayout.c"
				{
					gboolean _tmp70_ = FALSE;
#line 1685 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp70_ = TRUE;
#line 1685 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					while (TRUE) {
#line 9508 "CheckerboardLayout.c"
						gint _tmp72_;
						gint _tmp73_;
						CheckerboardItem* item = NULL;
						ViewCollection* _tmp74_;
						gint _tmp75_;
						DataObject* _tmp76_;
						Dimensions req = {0};
						CheckerboardItem* _tmp77_;
						Dimensions _tmp78_;
						gint alignment_point = 0;
						CheckerboardItem* _tmp79_;
						gint _tmp80_;
						Dimensions _tmp81_;
						gint _tmp82_;
						Dimensions _tmp83_;
						gint _tmp84_;
						gint _tmp85_;
						Dimensions _tmp88_;
						gint _tmp89_;
						gint _tmp90_;
						gint _tmp93_;
						gint _tmp94_;
						gint* _tmp96_;
						gint _tmp96__length1;
						gint _tmp97_;
						gint _tmp98_;
						Dimensions _tmp99_;
						gint _tmp100_;
						gint _tmp113_;
						gint _tmp114_;
						gint _tmp115_;
#line 1685 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
						if (!_tmp70_) {
#line 9542 "CheckerboardLayout.c"
							gint _tmp71_;
#line 1685 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
							_tmp71_ = ctr;
#line 1685 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
							ctr = _tmp71_ + 1;
#line 9548 "CheckerboardLayout.c"
						}
#line 1685 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
						_tmp70_ = FALSE;
#line 1685 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
						_tmp72_ = ctr;
#line 1685 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
						_tmp73_ = total_items;
#line 1685 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
						if (!(_tmp72_ < _tmp73_)) {
#line 1685 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
							break;
#line 9560 "CheckerboardLayout.c"
						}
#line 1686 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
						_tmp74_ = self->priv->view;
#line 1686 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
						_tmp75_ = ctr;
#line 1686 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
						_tmp76_ = data_collection_get_at (G_TYPE_CHECK_INSTANCE_CAST (_tmp74_, TYPE_DATA_COLLECTION, DataCollection), _tmp75_);
#line 1686 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
						item = G_TYPE_CHECK_INSTANCE_CAST (_tmp76_, TYPE_CHECKERBOARD_ITEM, CheckerboardItem);
#line 1687 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
						_tmp77_ = item;
#line 1687 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
						_tmp78_ = _tmp77_->requisition;
#line 1687 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
						req = _tmp78_;
#line 1688 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
						_tmp79_ = item;
#line 1688 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
						alignment_point = checkerboard_item_get_alignment_point (_tmp79_);
#line 1691 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
						_tmp80_ = alignment_point;
#line 1691 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
						_tmp81_ = req;
#line 1691 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
						_tmp82_ = _tmp81_.height;
#line 1691 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
						_vala_assert (_tmp80_ < _tmp82_, "alignment_point < req.height");
#line 1693 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
						_tmp83_ = req;
#line 1693 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
						_tmp84_ = _tmp83_.height;
#line 1693 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
						_tmp85_ = tallest;
#line 1693 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
						if (_tmp84_ > _tmp85_) {
#line 9596 "CheckerboardLayout.c"
							Dimensions _tmp86_;
							gint _tmp87_;
#line 1694 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
							_tmp86_ = req;
#line 1694 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
							_tmp87_ = _tmp86_.height;
#line 1694 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
							tallest = _tmp87_;
#line 9605 "CheckerboardLayout.c"
						}
#line 1696 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
						_tmp88_ = req;
#line 1696 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
						_tmp89_ = _tmp88_.width;
#line 1696 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
						_tmp90_ = widest;
#line 1696 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
						if (_tmp89_ > _tmp90_) {
#line 9615 "CheckerboardLayout.c"
							Dimensions _tmp91_;
							gint _tmp92_;
#line 1697 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
							_tmp91_ = req;
#line 1697 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
							_tmp92_ = _tmp91_.width;
#line 1697 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
							widest = _tmp92_;
#line 9624 "CheckerboardLayout.c"
						}
#line 1699 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
						_tmp93_ = alignment_point;
#line 1699 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
						_tmp94_ = row_alignment_point;
#line 1699 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
						if (_tmp93_ > _tmp94_) {
#line 9632 "CheckerboardLayout.c"
							gint _tmp95_;
#line 1700 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
							_tmp95_ = alignment_point;
#line 1700 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
							row_alignment_point = _tmp95_;
#line 9638 "CheckerboardLayout.c"
						}
#line 1704 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
						_tmp96_ = column_widths;
#line 1704 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
						_tmp96__length1 = column_widths_length1;
#line 1704 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
						_tmp97_ = col;
#line 1704 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
						_tmp98_ = _tmp96_[_tmp97_];
#line 1704 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
						_tmp99_ = req;
#line 1704 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
						_tmp100_ = _tmp99_.width;
#line 1704 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
						if (_tmp98_ < _tmp100_) {
#line 9654 "CheckerboardLayout.c"
							gint _tmp101_;
							gint* _tmp102_;
							gint _tmp102__length1;
							gint _tmp103_;
							gint _tmp104_;
							gint* _tmp105_;
							gint _tmp105__length1;
							gint _tmp106_;
							Dimensions _tmp107_;
							gint _tmp108_;
							gint _tmp109_;
							gint _tmp110_;
							Dimensions _tmp111_;
							gint _tmp112_;
#line 1705 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
							_tmp101_ = total_width;
#line 1705 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
							_tmp102_ = column_widths;
#line 1705 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
							_tmp102__length1 = column_widths_length1;
#line 1705 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
							_tmp103_ = col;
#line 1705 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
							_tmp104_ = _tmp102_[_tmp103_];
#line 1705 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
							total_width = _tmp101_ - _tmp104_;
#line 1706 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
							_tmp105_ = column_widths;
#line 1706 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
							_tmp105__length1 = column_widths_length1;
#line 1706 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
							_tmp106_ = col;
#line 1706 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
							_tmp107_ = req;
#line 1706 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
							_tmp108_ = _tmp107_.width;
#line 1706 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
							_tmp105_[_tmp106_] = _tmp108_;
#line 1706 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
							_tmp109_ = _tmp105_[_tmp106_];
#line 1707 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
							_tmp110_ = total_width;
#line 1707 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
							_tmp111_ = req;
#line 1707 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
							_tmp112_ = _tmp111_.width;
#line 1707 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
							total_width = _tmp110_ + _tmp112_;
#line 9703 "CheckerboardLayout.c"
						}
#line 1710 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
						_tmp113_ = col;
#line 1710 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
						col = _tmp113_ + 1;
#line 1710 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
						_tmp114_ = col;
#line 1710 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
						_tmp115_ = max_cols;
#line 1710 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
						if (_tmp114_ >= _tmp115_) {
#line 9715 "CheckerboardLayout.c"
							gint* _tmp116_;
							gint _tmp116__length1;
							gint _tmp117_;
							gint _tmp118_;
							gint _tmp119_;
							gint* _tmp120_;
							gint _tmp120__length1;
							gint _tmp121_;
							gint _tmp122_;
							gint _tmp123_;
#line 1711 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
							_tmp116_ = alignment_points;
#line 1711 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
							_tmp116__length1 = alignment_points_length1;
#line 1711 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
							_tmp117_ = row;
#line 1711 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
							_tmp118_ = row_alignment_point;
#line 1711 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
							_tmp116_[_tmp117_] = _tmp118_;
#line 1711 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
							_tmp119_ = _tmp116_[_tmp117_];
#line 1712 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
							_tmp120_ = row_heights;
#line 1712 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
							_tmp120__length1 = row_heights_length1;
#line 1712 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
							_tmp121_ = row;
#line 1712 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
							row = _tmp121_ + 1;
#line 1712 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
							_tmp122_ = tallest;
#line 1712 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
							_tmp120_[_tmp121_] = _tmp122_;
#line 1712 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
							_tmp123_ = _tmp120_[_tmp121_];
#line 1714 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
							col = 0;
#line 1715 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
							row_alignment_point = 0;
#line 1716 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
							tallest = 0;
#line 9758 "CheckerboardLayout.c"
						}
#line 1685 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
						_g_object_unref0 (item);
#line 9762 "CheckerboardLayout.c"
					}
				}
			}
#line 1721 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp124_ = col;
#line 1721 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			if (_tmp124_ != 0) {
#line 9770 "CheckerboardLayout.c"
				gint* _tmp125_;
				gint _tmp125__length1;
				gint _tmp126_;
				gint _tmp127_;
				gint _tmp128_;
				gint* _tmp129_;
				gint _tmp129__length1;
				gint _tmp130_;
				gint _tmp131_;
				gint _tmp132_;
#line 1722 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp125_ = alignment_points;
#line 1722 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp125__length1 = alignment_points_length1;
#line 1722 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp126_ = row;
#line 1722 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp127_ = row_alignment_point;
#line 1722 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp125_[_tmp126_] = _tmp127_;
#line 1722 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp128_ = _tmp125_[_tmp126_];
#line 1723 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp129_ = row_heights;
#line 1723 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp129__length1 = row_heights_length1;
#line 1723 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp130_ = row;
#line 1723 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp131_ = tallest;
#line 1723 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp129_[_tmp130_] = _tmp131_;
#line 1723 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp132_ = _tmp129_[_tmp130_];
#line 9805 "CheckerboardLayout.c"
			}
#line 1728 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp133_ = visible_width;
#line 1728 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp134_ = total_width;
#line 1728 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp135_ = max_cols;
#line 1728 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			gutter = (_tmp133_ - _tmp134_) / (_tmp135_ + 1);
#line 1731 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp136_ = max_cols;
#line 1731 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			if (_tmp136_ == 1) {
#line 1732 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				break;
#line 9821 "CheckerboardLayout.c"
			}
#line 1737 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp137_ = gutter;
#line 1737 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			if (_tmp137_ < CHECKERBOARD_LAYOUT_COLUMN_GUTTER_PADDING) {
#line 9827 "CheckerboardLayout.c"
				gint _tmp138_;
				gint _tmp139_;
				gint _tmp140_;
				gint _tmp141_;
				gint* _tmp142_;
				gint _tmp143_;
				gint* _tmp144_;
				gint _tmp145_;
				gint* _tmp146_;
#line 1738 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp138_ = max_cols;
#line 1738 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				max_cols = _tmp138_ - 1;
#line 1739 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp139_ = total_items;
#line 1739 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp140_ = max_cols;
#line 1739 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				max_rows = (_tmp139_ / _tmp140_) + 1;
#line 1746 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				col = 0;
#line 1747 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				row = 0;
#line 1748 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				tallest = 0;
#line 1749 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				widest = 0;
#line 1750 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				total_width = 0;
#line 1751 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				row_alignment_point = 0;
#line 1752 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp141_ = max_cols;
#line 1752 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp142_ = g_new0 (gint, _tmp141_);
#line 1752 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				column_widths = (g_free (column_widths), NULL);
#line 1752 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				column_widths = _tmp142_;
#line 1752 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				column_widths_length1 = _tmp141_;
#line 1752 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_column_widths_size_ = column_widths_length1;
#line 1753 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp143_ = max_rows;
#line 1753 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp144_ = g_new0 (gint, _tmp143_);
#line 1753 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				row_heights = (g_free (row_heights), NULL);
#line 1753 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				row_heights = _tmp144_;
#line 1753 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				row_heights_length1 = _tmp143_;
#line 1753 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_row_heights_size_ = row_heights_length1;
#line 1754 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp145_ = max_rows;
#line 1754 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp146_ = g_new0 (gint, _tmp145_);
#line 1754 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				alignment_points = (g_free (alignment_points), NULL);
#line 1754 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				alignment_points = _tmp146_;
#line 1754 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				alignment_points_length1 = _tmp145_;
#line 1754 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_alignment_points_size_ = alignment_points_length1;
#line 9895 "CheckerboardLayout.c"
			} else {
#line 1756 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				break;
#line 9899 "CheckerboardLayout.c"
			}
		}
	}
#line 1768 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	col = 0;
#line 1769 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	row = 0;
#line 9907 "CheckerboardLayout.c"
	{
		gint ctr = 0;
#line 1771 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		ctr = 0;
#line 9912 "CheckerboardLayout.c"
		{
			gboolean _tmp147_ = FALSE;
#line 1771 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp147_ = TRUE;
#line 1771 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			while (TRUE) {
#line 9919 "CheckerboardLayout.c"
				gint _tmp149_;
				gint _tmp150_;
				CheckerboardItem* item = NULL;
				ViewCollection* _tmp151_;
				gint _tmp152_;
				DataObject* _tmp153_;
				Dimensions req = {0};
				CheckerboardItem* _tmp154_;
				Dimensions _tmp155_;
				gint true_height = 0;
				Dimensions _tmp156_;
				gint _tmp157_;
				gint* _tmp158_;
				gint _tmp158__length1;
				gint _tmp159_;
				gint _tmp160_;
				CheckerboardItem* _tmp161_;
				gint _tmp162_;
				Dimensions _tmp163_;
				gint _tmp164_;
				gint _tmp165_;
				gint* _tmp166_;
				gint _tmp166__length1;
				gint _tmp167_;
				gint _tmp168_;
				gint _tmp173_;
				gint _tmp174_;
				gint _tmp175_;
#line 1771 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				if (!_tmp147_) {
#line 9950 "CheckerboardLayout.c"
					gint _tmp148_;
#line 1771 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp148_ = ctr;
#line 1771 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					ctr = _tmp148_ + 1;
#line 9956 "CheckerboardLayout.c"
				}
#line 1771 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp147_ = FALSE;
#line 1771 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp149_ = ctr;
#line 1771 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp150_ = total_items;
#line 1771 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				if (!(_tmp149_ < _tmp150_)) {
#line 1771 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					break;
#line 9968 "CheckerboardLayout.c"
				}
#line 1772 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp151_ = self->priv->view;
#line 1772 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp152_ = ctr;
#line 1772 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp153_ = data_collection_get_at (G_TYPE_CHECK_INSTANCE_CAST (_tmp151_, TYPE_DATA_COLLECTION, DataCollection), _tmp152_);
#line 1772 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				item = G_TYPE_CHECK_INSTANCE_CAST (_tmp153_, TYPE_CHECKERBOARD_ITEM, CheckerboardItem);
#line 1773 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp154_ = item;
#line 1773 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp155_ = _tmp154_->requisition;
#line 1773 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				req = _tmp155_;
#line 1778 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp156_ = req;
#line 1778 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp157_ = _tmp156_.height;
#line 1778 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp158_ = alignment_points;
#line 1778 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp158__length1 = alignment_points_length1;
#line 1778 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp159_ = row;
#line 1778 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp160_ = _tmp158_[_tmp159_];
#line 1778 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp161_ = item;
#line 1778 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				true_height = _tmp157_ + (_tmp160_ - checkerboard_item_get_alignment_point (_tmp161_));
#line 1779 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp162_ = true_height;
#line 1779 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp163_ = req;
#line 1779 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp164_ = _tmp163_.height;
#line 1779 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_vala_assert (_tmp162_ >= _tmp164_, "true_height >= req.height");
#line 1782 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp165_ = true_height;
#line 1782 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp166_ = row_heights;
#line 1782 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp166__length1 = row_heights_length1;
#line 1782 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp167_ = row;
#line 1782 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp168_ = _tmp166_[_tmp167_];
#line 1782 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				if (_tmp165_ > _tmp168_) {
#line 10020 "CheckerboardLayout.c"
					gint* _tmp169_;
					gint _tmp169__length1;
					gint _tmp170_;
					gint _tmp171_;
					gint _tmp172_;
#line 1787 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp169_ = row_heights;
#line 1787 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp169__length1 = row_heights_length1;
#line 1787 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp170_ = row;
#line 1787 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp171_ = true_height;
#line 1787 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp169_[_tmp170_] = _tmp171_;
#line 1787 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp172_ = _tmp169_[_tmp170_];
#line 10038 "CheckerboardLayout.c"
				}
#line 1791 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp173_ = col;
#line 1791 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				col = _tmp173_ + 1;
#line 1791 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp174_ = col;
#line 1791 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp175_ = max_cols;
#line 1791 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				if (_tmp174_ >= _tmp175_) {
#line 10050 "CheckerboardLayout.c"
					gint _tmp176_;
#line 1792 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					col = 0;
#line 1793 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp176_ = row;
#line 1793 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					row = _tmp176_ + 1;
#line 10058 "CheckerboardLayout.c"
				}
#line 1771 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_g_object_unref0 (item);
#line 10062 "CheckerboardLayout.c"
			}
		}
	}
#line 1798 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp177_ = max_rows;
#line 1798 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp178_ = g_new0 (CheckerboardLayoutLayoutRow*, _tmp177_ + 1);
#line 1798 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->item_rows = (_vala_array_free (self->priv->item_rows, self->priv->item_rows_length1, (GDestroyNotify) checkerboard_layout_layout_row_unref), NULL);
#line 1798 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->item_rows = _tmp178_;
#line 1798 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->item_rows_length1 = _tmp177_;
#line 1798 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->_item_rows_size_ = self->priv->item_rows_length1;
#line 1801 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp179_ = gutter;
#line 1801 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	x = _tmp179_;
#line 1802 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	y = CHECKERBOARD_LAYOUT_TOP_PADDING;
#line 1803 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	col = 0;
#line 1804 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	row = 0;
#line 1805 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	current_row = NULL;
#line 10090 "CheckerboardLayout.c"
	{
		gint ctr = 0;
#line 1807 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		ctr = 0;
#line 10095 "CheckerboardLayout.c"
		{
			gboolean _tmp180_ = FALSE;
#line 1807 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp180_ = TRUE;
#line 1807 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			while (TRUE) {
#line 10102 "CheckerboardLayout.c"
				gint _tmp182_;
				gint _tmp183_;
				CheckerboardItem* item = NULL;
				ViewCollection* _tmp184_;
				gint _tmp185_;
				DataObject* _tmp186_;
				Dimensions req = {0};
				CheckerboardItem* _tmp187_;
				Dimensions _tmp188_;
				gint xpadding = 0;
				gint* _tmp189_;
				gint _tmp189__length1;
				gint _tmp190_;
				gint _tmp191_;
				Dimensions _tmp192_;
				gint _tmp193_;
				gint _tmp194_;
				gint ypadding = 0;
				gint* _tmp195_;
				gint _tmp195__length1;
				gint _tmp196_;
				gint _tmp197_;
				CheckerboardItem* _tmp198_;
				gint _tmp199_;
				CheckerboardItem* _tmp200_;
				gint _tmp201_;
				gint _tmp202_;
				CheckerboardItem* _tmp203_;
				gint _tmp204_;
				gint _tmp205_;
				CheckerboardItem* _tmp206_;
				Dimensions _tmp207_;
				gint _tmp208_;
				CheckerboardItem* _tmp209_;
				Dimensions _tmp210_;
				gint _tmp211_;
				CheckerboardItem* _tmp212_;
				gint _tmp213_;
				gint _tmp214_;
				CheckerboardLayoutLayoutRow* _tmp215_;
				CheckerboardLayoutLayoutRow* _tmp222_;
				CheckerboardItem** _tmp223_;
				gint _tmp223__length1;
				gint _tmp224_;
				CheckerboardItem* _tmp225_;
				CheckerboardItem* _tmp226_;
				CheckerboardItem* _tmp227_;
				gint _tmp228_;
				gint* _tmp229_;
				gint _tmp229__length1;
				gint _tmp230_;
				gint _tmp231_;
				gint _tmp232_;
				gint _tmp233_;
				gint _tmp234_;
				gint _tmp235_;
#line 1807 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				if (!_tmp180_) {
#line 10161 "CheckerboardLayout.c"
					gint _tmp181_;
#line 1807 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp181_ = ctr;
#line 1807 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					ctr = _tmp181_ + 1;
#line 10167 "CheckerboardLayout.c"
				}
#line 1807 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp180_ = FALSE;
#line 1807 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp182_ = ctr;
#line 1807 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp183_ = total_items;
#line 1807 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				if (!(_tmp182_ < _tmp183_)) {
#line 1807 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					break;
#line 10179 "CheckerboardLayout.c"
				}
#line 1808 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp184_ = self->priv->view;
#line 1808 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp185_ = ctr;
#line 1808 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp186_ = data_collection_get_at (G_TYPE_CHECK_INSTANCE_CAST (_tmp184_, TYPE_DATA_COLLECTION, DataCollection), _tmp185_);
#line 1808 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				item = G_TYPE_CHECK_INSTANCE_CAST (_tmp186_, TYPE_CHECKERBOARD_ITEM, CheckerboardItem);
#line 1809 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp187_ = item;
#line 1809 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp188_ = _tmp187_->requisition;
#line 1809 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				req = _tmp188_;
#line 1812 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp189_ = column_widths;
#line 1812 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp189__length1 = column_widths_length1;
#line 1812 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp190_ = col;
#line 1812 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp191_ = _tmp189_[_tmp190_];
#line 1812 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp192_ = req;
#line 1812 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp193_ = _tmp192_.width;
#line 1812 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				xpadding = (_tmp191_ - _tmp193_) / 2;
#line 1813 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp194_ = xpadding;
#line 1813 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_vala_assert (_tmp194_ >= 0, "xpadding >= 0");
#line 1816 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp195_ = alignment_points;
#line 1816 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp195__length1 = alignment_points_length1;
#line 1816 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp196_ = row;
#line 1816 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp197_ = _tmp195_[_tmp196_];
#line 1816 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp198_ = item;
#line 1816 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				ypadding = _tmp197_ - checkerboard_item_get_alignment_point (_tmp198_);
#line 1817 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp199_ = ypadding;
#line 1817 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_vala_assert (_tmp199_ >= 0, "ypadding >= 0");
#line 1820 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp200_ = item;
#line 1820 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp201_ = x;
#line 1820 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp202_ = xpadding;
#line 1820 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp200_->allocation.x = _tmp201_ + _tmp202_;
#line 1821 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp203_ = item;
#line 1821 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp204_ = y;
#line 1821 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp205_ = ypadding;
#line 1821 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp203_->allocation.y = _tmp204_ + _tmp205_;
#line 1822 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp206_ = item;
#line 1822 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp207_ = req;
#line 1822 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp208_ = _tmp207_.width;
#line 1822 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp206_->allocation.width = _tmp208_;
#line 1823 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp209_ = item;
#line 1823 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp210_ = req;
#line 1823 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp211_ = _tmp210_.height;
#line 1823 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp209_->allocation.height = _tmp211_;
#line 1824 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp212_ = item;
#line 1824 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp213_ = col;
#line 1824 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp214_ = row;
#line 1824 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				checkerboard_item_set_grid_coordinates (_tmp212_, _tmp213_, _tmp214_);
#line 1827 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp215_ = current_row;
#line 1827 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				if (_tmp215_ == NULL) {
#line 10273 "CheckerboardLayout.c"
					gint _tmp216_;
					gint* _tmp217_;
					gint _tmp217__length1;
					gint _tmp218_;
					gint _tmp219_;
					gint _tmp220_;
					CheckerboardLayoutLayoutRow* _tmp221_;
#line 1828 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp216_ = y;
#line 1828 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp217_ = row_heights;
#line 1828 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp217__length1 = row_heights_length1;
#line 1828 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp218_ = row;
#line 1828 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp219_ = _tmp217_[_tmp218_];
#line 1828 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp220_ = max_cols;
#line 1828 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp221_ = checkerboard_layout_layout_row_new (_tmp216_, _tmp219_, _tmp220_);
#line 1828 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_checkerboard_layout_layout_row_unref0 (current_row);
#line 1828 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					current_row = _tmp221_;
#line 10299 "CheckerboardLayout.c"
				}
#line 1830 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp222_ = current_row;
#line 1830 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp223_ = _tmp222_->items;
#line 1830 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp223__length1 = _tmp222_->items_length1;
#line 1830 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp224_ = col;
#line 1830 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp225_ = item;
#line 1830 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp226_ = _g_object_ref0 (_tmp225_);
#line 1830 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_g_object_unref0 (_tmp223_[_tmp224_]);
#line 1830 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp223_[_tmp224_] = _tmp226_;
#line 1830 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp227_ = _tmp223_[_tmp224_];
#line 1832 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp228_ = x;
#line 1832 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp229_ = column_widths;
#line 1832 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp229__length1 = column_widths_length1;
#line 1832 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp230_ = col;
#line 1832 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp231_ = _tmp229_[_tmp230_];
#line 1832 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp232_ = gutter;
#line 1832 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				x = _tmp228_ + (_tmp231_ + _tmp232_);
#line 1835 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp233_ = col;
#line 1835 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				col = _tmp233_ + 1;
#line 1835 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp234_ = col;
#line 1835 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp235_ = max_cols;
#line 1835 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				if (_tmp234_ >= _tmp235_) {
#line 10343 "CheckerboardLayout.c"
					CheckerboardLayoutLayoutRow* _tmp236_;
					CheckerboardLayoutLayoutRow** _tmp237_;
					gint _tmp237__length1;
					gint _tmp238_;
					CheckerboardLayoutLayoutRow* _tmp239_;
					CheckerboardLayoutLayoutRow* _tmp240_;
					CheckerboardLayoutLayoutRow* _tmp241_;
					gint _tmp242_;
					gint _tmp243_;
					gint* _tmp244_;
					gint _tmp244__length1;
					gint _tmp245_;
					gint _tmp246_;
					gint _tmp247_;
#line 1836 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp236_ = current_row;
#line 1836 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_vala_assert (_tmp236_ != NULL, "current_row != null");
#line 1837 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp237_ = self->priv->item_rows;
#line 1837 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp237__length1 = self->priv->item_rows_length1;
#line 1837 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp238_ = row;
#line 1837 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp239_ = current_row;
#line 1837 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp240_ = _checkerboard_layout_layout_row_ref0 (_tmp239_);
#line 1837 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_checkerboard_layout_layout_row_unref0 (_tmp237_[_tmp238_]);
#line 1837 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp237_[_tmp238_] = _tmp240_;
#line 1837 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp241_ = _tmp237_[_tmp238_];
#line 1838 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_checkerboard_layout_layout_row_unref0 (current_row);
#line 1838 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					current_row = NULL;
#line 1840 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp242_ = gutter;
#line 1840 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					x = _tmp242_;
#line 1841 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp243_ = y;
#line 1841 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp244_ = row_heights;
#line 1841 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp244__length1 = row_heights_length1;
#line 1841 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp245_ = row;
#line 1841 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp246_ = _tmp244_[_tmp245_];
#line 1841 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					y = _tmp243_ + (_tmp246_ + CHECKERBOARD_LAYOUT_ROW_GUTTER_PADDING);
#line 1842 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					col = 0;
#line 1843 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp247_ = row;
#line 1843 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					row = _tmp247_ + 1;
#line 10404 "CheckerboardLayout.c"
				}
#line 1807 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_g_object_unref0 (item);
#line 10408 "CheckerboardLayout.c"
			}
		}
	}
#line 1848 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp248_ = current_row;
#line 1848 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp248_ != NULL) {
#line 10416 "CheckerboardLayout.c"
		CheckerboardLayoutLayoutRow** _tmp249_;
		gint _tmp249__length1;
		gint _tmp250_;
		CheckerboardLayoutLayoutRow* _tmp251_;
		CheckerboardLayoutLayoutRow* _tmp252_;
		CheckerboardLayoutLayoutRow* _tmp253_;
#line 1849 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp249_ = self->priv->item_rows;
#line 1849 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp249__length1 = self->priv->item_rows_length1;
#line 1849 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp250_ = row;
#line 1849 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp251_ = current_row;
#line 1849 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp252_ = _checkerboard_layout_layout_row_ref0 (_tmp251_);
#line 1849 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_checkerboard_layout_layout_row_unref0 (_tmp249_[_tmp250_]);
#line 1849 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp249_[_tmp250_] = _tmp252_;
#line 1849 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp253_ = _tmp249_[_tmp250_];
#line 10439 "CheckerboardLayout.c"
	}
#line 1852 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp254_ = max_cols;
#line 1852 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->columns = _tmp254_;
#line 1853 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp255_ = row;
#line 1853 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->rows = _tmp255_ + 1;
#line 1854 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp256_ = self->priv->rows;
#line 1854 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp257_ = max_rows;
#line 1854 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_vala_assert (_tmp256_ == _tmp257_, "rows == max_rows");
#line 1858 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp258_ = y;
#line 1858 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp259_ = row_heights;
#line 1858 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp259__length1 = row_heights_length1;
#line 1858 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp260_ = row;
#line 1858 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp261_ = _tmp259_[_tmp260_];
#line 1858 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	total_height = (_tmp258_ + _tmp261_) + CHECKERBOARD_LAYOUT_BOTTOM_PADDING;
#line 1859 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp263_ = visible_width;
#line 1859 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp264_ = allocation;
#line 1859 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp265_ = _tmp264_.width;
#line 1859 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp263_ != _tmp265_) {
#line 1859 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp262_ = TRUE;
#line 10477 "CheckerboardLayout.c"
	} else {
		gint _tmp266_;
		GtkAllocation _tmp267_;
		gint _tmp268_;
#line 1859 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp266_ = total_height;
#line 1859 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp267_ = allocation;
#line 1859 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp268_ = _tmp267_.height;
#line 1859 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp262_ = _tmp266_ != _tmp268_;
#line 10490 "CheckerboardLayout.c"
	}
#line 1859 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp262_) {
#line 10494 "CheckerboardLayout.c"
		gint _tmp269_;
		gint _tmp270_;
		gint _tmp271_;
#line 1864 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp269_ = visible_width;
#line 1864 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp270_ = total_height;
#line 1864 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		gtk_widget_set_size_request (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), _tmp269_, _tmp270_);
#line 1865 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		self->priv->size_allocate_due_to_reflow = TRUE;
#line 1868 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp271_ = total_height;
#line 1868 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		checkerboard_layout_center_on_anchor (self, (gdouble) _tmp271_);
#line 10510 "CheckerboardLayout.c"
	}
#line 1555 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_checkerboard_layout_layout_row_unref0 (current_row);
#line 1555 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	alignment_points = (g_free (alignment_points), NULL);
#line 1555 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	row_heights = (g_free (row_heights), NULL);
#line 1555 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	column_widths = (g_free (column_widths), NULL);
#line 10520 "CheckerboardLayout.c"
}


static void
checkerboard_layout_items_dirty (CheckerboardLayout* self,
                                 const gchar* reason,
                                 GeeIterable* items)
{
	GdkRectangle dirty = {0};
	gboolean _tmp30_ = FALSE;
	GdkRectangle _tmp31_;
	gint _tmp32_;
#line 1872 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (IS_CHECKERBOARD_LAYOUT (self));
#line 1872 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (reason != NULL);
#line 1872 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (GEE_IS_ITERABLE (items));
#line 1873 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	memset (&dirty, 0, sizeof (GdkRectangle));
#line 10541 "CheckerboardLayout.c"
	{
		GeeIterator* _data_view_it = NULL;
		GeeIterator* _tmp0_;
#line 1874 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp0_ = gee_iterable_iterator (items);
#line 1874 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_data_view_it = _tmp0_;
#line 1874 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		while (TRUE) {
#line 10551 "CheckerboardLayout.c"
			GeeIterator* _tmp1_;
			DataView* data_view = NULL;
			GeeIterator* _tmp2_;
			gpointer _tmp3_;
			CheckerboardItem* item = NULL;
			DataView* _tmp4_;
			CheckerboardItem* _tmp5_;
			CheckerboardItem* _tmp6_;
			ViewCollection* _tmp7_;
			CheckerboardItem* _tmp8_;
			gboolean _tmp9_ = FALSE;
			CheckerboardItem* _tmp10_;
			GdkRectangle _tmp11_;
			gint _tmp12_;
			GdkRectangle intersection = {0};
			CheckerboardItem* _tmp18_;
			GdkRectangle _tmp19_;
			GdkRectangle _tmp20_ = {0};
			gboolean _tmp21_;
			gboolean _tmp22_ = FALSE;
			GdkRectangle _tmp23_;
			gint _tmp24_;
#line 1874 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp1_ = _data_view_it;
#line 1874 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			if (!gee_iterator_next (_tmp1_)) {
#line 1874 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				break;
#line 10580 "CheckerboardLayout.c"
			}
#line 1874 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp2_ = _data_view_it;
#line 1874 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp3_ = gee_iterator_get (_tmp2_);
#line 1874 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			data_view = (DataView*) _tmp3_;
#line 1875 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp4_ = data_view;
#line 1875 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp5_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, TYPE_CHECKERBOARD_ITEM, CheckerboardItem));
#line 1875 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			item = _tmp5_;
#line 1877 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp6_ = item;
#line 1877 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			if (!data_view_is_visible (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, TYPE_DATA_VIEW, DataView))) {
#line 1878 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_g_object_unref0 (item);
#line 1878 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_g_object_unref0 (data_view);
#line 1878 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				continue;
#line 10604 "CheckerboardLayout.c"
			}
#line 1880 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp7_ = self->priv->view;
#line 1880 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp8_ = item;
#line 1880 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_vala_assert (data_collection_contains (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, TYPE_DATA_COLLECTION, DataCollection), G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, TYPE_DATA_OBJECT, DataObject)), "view.contains(item)");
#line 1884 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp10_ = item;
#line 1884 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp11_ = _tmp10_->allocation;
#line 1884 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp12_ = _tmp11_.width;
#line 1884 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			if (_tmp12_ <= 0) {
#line 1884 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp9_ = TRUE;
#line 10622 "CheckerboardLayout.c"
			} else {
				CheckerboardItem* _tmp13_;
				GdkRectangle _tmp14_;
				gint _tmp15_;
#line 1884 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp13_ = item;
#line 1884 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp14_ = _tmp13_->allocation;
#line 1884 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp15_ = _tmp14_.height;
#line 1884 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp9_ = _tmp15_ <= 0;
#line 10635 "CheckerboardLayout.c"
			}
#line 1884 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			if (_tmp9_) {
#line 10639 "CheckerboardLayout.c"
				gchar* _tmp16_;
				gchar* _tmp17_;
#line 1885 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp16_ = g_strdup_printf ("items_dirty: %s", reason);
#line 1885 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp17_ = _tmp16_;
#line 1885 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				checkerboard_layout_need_reflow (self, _tmp17_);
#line 1885 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_g_free0 (_tmp17_);
#line 1887 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_g_object_unref0 (item);
#line 1887 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_g_object_unref0 (data_view);
#line 1887 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_g_object_unref0 (_data_view_it);
#line 1887 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				return;
#line 10658 "CheckerboardLayout.c"
			}
#line 1891 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			memset (&intersection, 0, sizeof (GdkRectangle));
#line 1892 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp18_ = item;
#line 1892 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp19_ = _tmp18_->allocation;
#line 1892 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp21_ = gdk_rectangle_intersect (&self->priv->visible_page, &_tmp19_, &_tmp20_);
#line 1892 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			intersection = _tmp20_;
#line 1892 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			if (!_tmp21_) {
#line 1893 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_g_object_unref0 (item);
#line 1893 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_g_object_unref0 (data_view);
#line 1893 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				continue;
#line 10678 "CheckerboardLayout.c"
			}
#line 1896 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp23_ = dirty;
#line 1896 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp24_ = _tmp23_.width;
#line 1896 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			if (_tmp24_ == 0) {
#line 1896 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp22_ = TRUE;
#line 10688 "CheckerboardLayout.c"
			} else {
				GdkRectangle _tmp25_;
				gint _tmp26_;
#line 1896 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp25_ = dirty;
#line 1896 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp26_ = _tmp25_.height;
#line 1896 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp22_ = _tmp26_ == 0;
#line 10698 "CheckerboardLayout.c"
			}
#line 1896 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			if (_tmp22_) {
#line 10702 "CheckerboardLayout.c"
				GdkRectangle _tmp27_;
#line 1897 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp27_ = intersection;
#line 1897 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				dirty = _tmp27_;
#line 10708 "CheckerboardLayout.c"
			} else {
				GdkRectangle _tmp28_;
				GdkRectangle _tmp29_ = {0};
#line 1899 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp28_ = intersection;
#line 1899 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				gdk_rectangle_union (&dirty, &_tmp28_, &_tmp29_);
#line 1899 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				dirty = _tmp29_;
#line 10718 "CheckerboardLayout.c"
			}
#line 1874 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_g_object_unref0 (item);
#line 1874 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_g_object_unref0 (data_view);
#line 10724 "CheckerboardLayout.c"
		}
#line 1874 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_g_object_unref0 (_data_view_it);
#line 10728 "CheckerboardLayout.c"
	}
#line 1902 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp31_ = dirty;
#line 1902 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp32_ = _tmp31_.width;
#line 1902 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp32_ > 0) {
#line 10736 "CheckerboardLayout.c"
		GdkRectangle _tmp33_;
		gint _tmp34_;
#line 1902 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp33_ = dirty;
#line 1902 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp34_ = _tmp33_.height;
#line 1902 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp30_ = _tmp34_ > 0;
#line 10745 "CheckerboardLayout.c"
	} else {
#line 1902 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp30_ = FALSE;
#line 10749 "CheckerboardLayout.c"
	}
#line 1902 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp30_) {
#line 10753 "CheckerboardLayout.c"
		GdkRectangle _tmp35_;
		gint _tmp36_;
		GdkRectangle _tmp37_;
		gint _tmp38_;
		GdkRectangle _tmp39_;
		gint _tmp40_;
		GdkRectangle _tmp41_;
		gint _tmp42_;
#line 1907 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp35_ = dirty;
#line 1907 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp36_ = _tmp35_.x;
#line 1907 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp37_ = dirty;
#line 1907 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp38_ = _tmp37_.y;
#line 1907 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp39_ = dirty;
#line 1907 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp40_ = _tmp39_.width;
#line 1907 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp41_ = dirty;
#line 1907 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp42_ = _tmp41_.height;
#line 1907 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		gtk_widget_queue_draw_area (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), _tmp36_, _tmp38_, _tmp40_, _tmp42_);
#line 10780 "CheckerboardLayout.c"
	}
}


static void
checkerboard_layout_real_map (GtkWidget* base)
{
	CheckerboardLayout * self;
#line 1911 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_CHECKERBOARD_LAYOUT, CheckerboardLayout);
#line 1912 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	GTK_WIDGET_CLASS (checkerboard_layout_parent_class)->map (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_drawing_area_get_type (), GtkDrawingArea), gtk_widget_get_type (), GtkWidget));
#line 1914 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	checkerboard_layout_set_colors (self, TRUE);
#line 10795 "CheckerboardLayout.c"
}


static void
checkerboard_layout_set_colors (CheckerboardLayout* self,
                                gboolean in_focus)
{
	ConfigFacade* _tmp0_;
	ConfigFacade* _tmp1_;
	GdkRGBA _tmp2_ = {0};
	ConfigFacade* _tmp3_;
	ConfigFacade* _tmp4_;
	GdkRGBA _tmp5_ = {0};
	ConfigFacade* _tmp6_;
	ConfigFacade* _tmp7_;
	GdkRGBA _tmp8_ = {0};
	GtkStyleContext* _tmp9_;
	GdkRGBA _tmp10_ = {0};
#line 1917 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (IS_CHECKERBOARD_LAYOUT (self));
#line 1919 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = config_facade_get_instance ();
#line 1919 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = _tmp0_;
#line 1919 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	config_facade_get_selected_color (_tmp1_, in_focus, &_tmp2_);
#line 1919 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->selected_color = _tmp2_;
#line 1919 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_g_object_unref0 (_tmp1_);
#line 1920 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp3_ = config_facade_get_instance ();
#line 1920 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp4_ = _tmp3_;
#line 1920 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	config_facade_get_unselected_color (_tmp4_, &_tmp5_);
#line 1920 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->unselected_color = _tmp5_;
#line 1920 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_g_object_unref0 (_tmp4_);
#line 1921 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp6_ = config_facade_get_instance ();
#line 1921 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp7_ = _tmp6_;
#line 1921 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	config_facade_get_border_color (_tmp7_, &_tmp8_);
#line 1921 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->border_color = _tmp8_;
#line 1921 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_g_object_unref0 (_tmp7_);
#line 1922 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp9_ = gtk_widget_get_style_context (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
#line 1922 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	gtk_style_context_get_background_color (_tmp9_, GTK_STATE_FLAG_NORMAL, &_tmp10_);
#line 1922 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->bg_color = _tmp10_;
#line 10852 "CheckerboardLayout.c"
}


static void
checkerboard_layout_real_size_allocate (GtkWidget* base,
                                        GtkAllocation* allocation)
{
	CheckerboardLayout * self;
	GtkAllocation _tmp0_;
#line 1925 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_CHECKERBOARD_LAYOUT, CheckerboardLayout);
#line 1925 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (allocation != NULL);
#line 1926 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = *allocation;
#line 1926 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	GTK_WIDGET_CLASS (checkerboard_layout_parent_class)->size_allocate (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_drawing_area_get_type (), GtkDrawingArea), gtk_widget_get_type (), GtkWidget), &_tmp0_);
#line 1928 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	checkerboard_layout_viewport_resized (self);
#line 10872 "CheckerboardLayout.c"
}


static gboolean
checkerboard_layout_real_draw (GtkWidget* base,
                               cairo_t* ctx)
{
	CheckerboardLayout * self;
	gboolean result = FALSE;
	GtkAllocation allocation = {0};
	GtkAllocation _tmp0_ = {0};
	GtkStyleContext* _tmp1_;
	GtkAllocation _tmp2_;
	gint _tmp3_;
	GtkAllocation _tmp4_;
	gint _tmp5_;
	const gchar* _tmp6_;
	gboolean _tmp54_ = FALSE;
	gboolean _result_ = FALSE;
#line 1931 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_CHECKERBOARD_LAYOUT, CheckerboardLayout);
#line 1931 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_val_if_fail (ctx != NULL, FALSE);
#line 1940 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	gtk_widget_get_allocation (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), &_tmp0_);
#line 1940 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	allocation = _tmp0_;
#line 1941 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = gtk_widget_get_style_context (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
#line 1941 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp2_ = allocation;
#line 1941 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp3_ = _tmp2_.width;
#line 1941 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp4_ = allocation;
#line 1941 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp5_ = _tmp4_.height;
#line 1941 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	gtk_render_background (_tmp1_, ctx, (gdouble) 0, (gdouble) 0, (gdouble) _tmp3_, (gdouble) _tmp5_);
#line 1944 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp6_ = self->priv->message;
#line 1944 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp6_ == NULL) {
#line 10916 "CheckerboardLayout.c"
		gboolean _tmp7_;
#line 1949 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp7_ = self->priv->exposure_dirty;
#line 1949 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		if (_tmp7_) {
#line 1950 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			checkerboard_layout_expose_items (self, "draw");
#line 10924 "CheckerboardLayout.c"
		}
		{
			GeeList* _item_list = NULL;
			GdkRectangle _tmp8_;
			GeeList* _tmp9_;
			gint _item_size = 0;
			GeeList* _tmp10_;
			gint _tmp11_;
			gint _tmp12_;
			gint _item_index = 0;
#line 1953 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp8_ = self->priv->visible_page;
#line 1953 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp9_ = checkerboard_layout_intersection (self, &_tmp8_);
#line 1953 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_item_list = _tmp9_;
#line 1953 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp10_ = _item_list;
#line 1953 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp11_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, GEE_TYPE_COLLECTION, GeeCollection));
#line 1953 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp12_ = _tmp11_;
#line 1953 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_item_size = _tmp12_;
#line 1953 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_item_index = -1;
#line 1953 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			while (TRUE) {
#line 10953 "CheckerboardLayout.c"
				gint _tmp13_;
				gint _tmp14_;
				gint _tmp15_;
				CheckerboardItem* item = NULL;
				GeeList* _tmp16_;
				gint _tmp17_;
				gpointer _tmp18_;
				GdkRGBA _tmp19_ = {0};
				CheckerboardItem* _tmp20_;
				CheckerboardItem* _tmp23_;
				GdkRGBA _tmp24_;
				GdkRGBA _tmp25_;
				GdkRGBA _tmp26_;
#line 1953 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp13_ = _item_index;
#line 1953 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_item_index = _tmp13_ + 1;
#line 1953 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp14_ = _item_index;
#line 1953 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp15_ = _item_size;
#line 1953 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				if (!(_tmp14_ < _tmp15_)) {
#line 1953 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					break;
#line 10979 "CheckerboardLayout.c"
				}
#line 1953 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp16_ = _item_list;
#line 1953 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp17_ = _item_index;
#line 1953 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp18_ = gee_list_get (_tmp16_, _tmp17_);
#line 1953 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				item = (CheckerboardItem*) _tmp18_;
#line 1954 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp20_ = item;
#line 1954 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				if (data_view_is_selected (G_TYPE_CHECK_INSTANCE_CAST (_tmp20_, TYPE_DATA_VIEW, DataView))) {
#line 10993 "CheckerboardLayout.c"
					GdkRGBA _tmp21_;
#line 1954 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp21_ = self->priv->selected_color;
#line 1954 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp19_ = _tmp21_;
#line 10999 "CheckerboardLayout.c"
				} else {
					GdkRGBA _tmp22_;
#line 1954 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp22_ = self->priv->unselected_color;
#line 1954 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp19_ = _tmp22_;
#line 11006 "CheckerboardLayout.c"
				}
#line 1954 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp23_ = item;
#line 1954 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp24_ = self->priv->bg_color;
#line 1954 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp25_ = self->priv->unselected_color;
#line 1954 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp26_ = self->priv->border_color;
#line 1954 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				checkerboard_item_paint (_tmp23_, ctx, &_tmp24_, &_tmp19_, &_tmp25_, &_tmp26_);
#line 1953 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_g_object_unref0 (item);
#line 11020 "CheckerboardLayout.c"
			}
#line 1953 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_g_object_unref0 (_item_list);
#line 11024 "CheckerboardLayout.c"
		}
	} else {
		PangoLayout* pango_layout = NULL;
		const gchar* _tmp27_;
		PangoLayout* _tmp28_;
		gint text_width = 0;
		gint text_height = 0;
		PangoLayout* _tmp29_;
		gint _tmp30_ = 0;
		gint _tmp31_ = 0;
		GtkAllocation _tmp32_ = {0};
		gint x = 0;
		GtkAllocation _tmp33_;
		gint _tmp34_;
		gint _tmp35_;
		gint _tmp36_ = 0;
		gint _tmp37_;
		gint y = 0;
		GtkAllocation _tmp39_;
		gint _tmp40_;
		gint _tmp41_;
		gint _tmp42_ = 0;
		gint _tmp43_;
		GdkRGBA _tmp45_;
		gdouble _tmp46_;
		GdkRGBA _tmp47_;
		gdouble _tmp48_;
		GdkRGBA _tmp49_;
		gdouble _tmp50_;
		gint _tmp51_;
		gint _tmp52_;
		PangoLayout* _tmp53_;
#line 1959 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp27_ = self->priv->message;
#line 1959 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp28_ = gtk_widget_create_pango_layout (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), _tmp27_);
#line 1959 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		pango_layout = _tmp28_;
#line 1961 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp29_ = pango_layout;
#line 1961 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		pango_layout_get_pixel_size (_tmp29_, &_tmp30_, &_tmp31_);
#line 1961 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		text_width = _tmp30_;
#line 1961 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		text_height = _tmp31_;
#line 1963 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		gtk_widget_get_allocation (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), &_tmp32_);
#line 1963 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		allocation = _tmp32_;
#line 1965 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp33_ = allocation;
#line 1965 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp34_ = _tmp33_.width;
#line 1965 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp35_ = text_width;
#line 1965 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		x = _tmp34_ - _tmp35_;
#line 1966 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp37_ = x;
#line 1966 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		if (_tmp37_ > 0) {
#line 11087 "CheckerboardLayout.c"
			gint _tmp38_;
#line 1966 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp38_ = x;
#line 1966 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp36_ = _tmp38_ / 2;
#line 11093 "CheckerboardLayout.c"
		} else {
#line 1966 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp36_ = 0;
#line 11097 "CheckerboardLayout.c"
		}
#line 1966 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		x = _tmp36_;
#line 1968 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp39_ = allocation;
#line 1968 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp40_ = _tmp39_.height;
#line 1968 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp41_ = text_height;
#line 1968 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		y = _tmp40_ - _tmp41_;
#line 1969 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp43_ = y;
#line 1969 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		if (_tmp43_ > 0) {
#line 11113 "CheckerboardLayout.c"
			gint _tmp44_;
#line 1969 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp44_ = y;
#line 1969 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp42_ = _tmp44_ / 2;
#line 11119 "CheckerboardLayout.c"
		} else {
#line 1969 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp42_ = 0;
#line 11123 "CheckerboardLayout.c"
		}
#line 1969 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		y = _tmp42_;
#line 1971 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp45_ = self->priv->unselected_color;
#line 1971 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp46_ = _tmp45_.red;
#line 1971 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp47_ = self->priv->unselected_color;
#line 1971 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp48_ = _tmp47_.green;
#line 1971 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp49_ = self->priv->unselected_color;
#line 1971 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp50_ = _tmp49_.blue;
#line 1971 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		cairo_set_source_rgb (ctx, _tmp46_, _tmp48_, _tmp50_);
#line 1972 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp51_ = x;
#line 1972 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp52_ = y;
#line 1972 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		cairo_move_to (ctx, (gdouble) _tmp51_, (gdouble) _tmp52_);
#line 1973 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp53_ = pango_layout;
#line 1973 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		pango_cairo_show_layout (ctx, _tmp53_);
#line 1944 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_g_object_unref0 (pango_layout);
#line 11153 "CheckerboardLayout.c"
	}
#line 1976 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (GTK_WIDGET_CLASS (checkerboard_layout_parent_class)->draw != NULL) {
#line 1976 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp54_ = GTK_WIDGET_CLASS (checkerboard_layout_parent_class)->draw (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_drawing_area_get_type (), GtkDrawingArea), gtk_widget_get_type (), GtkWidget), ctx);
#line 11159 "CheckerboardLayout.c"
	} else {
#line 1976 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp54_ = TRUE;
#line 11163 "CheckerboardLayout.c"
	}
#line 1976 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_result_ = _tmp54_;
#line 1979 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	checkerboard_layout_draw_selection_band (self, ctx);
#line 1981 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	result = _result_;
#line 1981 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return result;
#line 11173 "CheckerboardLayout.c"
}


static void
checkerboard_layout_draw_selection_band (CheckerboardLayout* self,
                                         cairo_t* ctx)
{
	gboolean _tmp0_ = FALSE;
	GdkRectangle _tmp1_;
	gint _tmp2_;
	gboolean _tmp5_ = FALSE;
	GtkAdjustment* _tmp6_;
	GdkRectangle visible_page = {0};
	GtkAdjustment* _tmp8_;
	GtkAdjustment* _tmp9_;
	GdkRectangle _tmp10_ = {0};
	GdkRectangle visible_band = {0};
	GdkRectangle _tmp11_;
	GdkRectangle _tmp12_ = {0};
	gboolean _tmp13_ = FALSE;
	GdkRectangle _tmp14_;
	gint _tmp15_;
	GdkRGBA _tmp32_;
	gdouble _tmp33_;
	GdkRGBA _tmp34_;
	gdouble _tmp35_;
	GdkRGBA _tmp36_;
	gdouble _tmp37_;
	GdkRectangle _tmp38_;
	gint _tmp39_;
	GdkRectangle _tmp40_;
	gint _tmp41_;
	GdkRectangle _tmp42_;
	gint _tmp43_;
	GdkRectangle _tmp44_;
	gint _tmp45_;
#line 1984 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (IS_CHECKERBOARD_LAYOUT (self));
#line 1984 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (ctx != NULL);
#line 1986 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = self->priv->selection_band;
#line 1986 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp2_ = _tmp1_.width;
#line 1986 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp2_ <= 1) {
#line 1986 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp0_ = TRUE;
#line 11222 "CheckerboardLayout.c"
	} else {
		GdkRectangle _tmp3_;
		gint _tmp4_;
#line 1986 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp3_ = self->priv->selection_band;
#line 1986 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp4_ = _tmp3_.height;
#line 1986 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp0_ = _tmp4_ <= 1;
#line 11232 "CheckerboardLayout.c"
	}
#line 1986 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp0_) {
#line 1987 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		return;
#line 11238 "CheckerboardLayout.c"
	}
#line 1990 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp6_ = self->priv->hadjustment;
#line 1990 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp6_ == NULL) {
#line 1990 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp5_ = TRUE;
#line 11246 "CheckerboardLayout.c"
	} else {
		GtkAdjustment* _tmp7_;
#line 1990 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp7_ = self->priv->vadjustment;
#line 1990 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp5_ = _tmp7_ == NULL;
#line 11253 "CheckerboardLayout.c"
	}
#line 1990 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp5_) {
#line 1991 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		return;
#line 11259 "CheckerboardLayout.c"
	}
#line 1994 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp8_ = self->priv->hadjustment;
#line 1994 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp9_ = self->priv->vadjustment;
#line 1994 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	get_adjustment_page (_tmp8_, _tmp9_, &_tmp10_);
#line 1994 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	visible_page = _tmp10_;
#line 1995 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	memset (&visible_band, 0, sizeof (GdkRectangle));
#line 1996 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp11_ = self->priv->selection_band;
#line 1996 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	gdk_rectangle_intersect (&visible_page, &_tmp11_, &_tmp12_);
#line 1996 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	visible_band = _tmp12_;
#line 1999 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp14_ = visible_band;
#line 1999 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp15_ = _tmp14_.width;
#line 1999 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp15_ > 1) {
#line 11283 "CheckerboardLayout.c"
		GdkRectangle _tmp16_;
		gint _tmp17_;
#line 1999 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp16_ = visible_band;
#line 1999 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp17_ = _tmp16_.height;
#line 1999 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp13_ = _tmp17_ > 1;
#line 11292 "CheckerboardLayout.c"
	} else {
#line 1999 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp13_ = FALSE;
#line 11296 "CheckerboardLayout.c"
	}
#line 1999 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp13_) {
#line 11300 "CheckerboardLayout.c"
		GdkRGBA _tmp18_;
		gdouble _tmp19_;
		GdkRGBA _tmp20_;
		gdouble _tmp21_;
		GdkRGBA _tmp22_;
		gdouble _tmp23_;
		GdkRectangle _tmp24_;
		gint _tmp25_;
		GdkRectangle _tmp26_;
		gint _tmp27_;
		GdkRectangle _tmp28_;
		gint _tmp29_;
		GdkRectangle _tmp30_;
		gint _tmp31_;
#line 2000 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp18_ = self->priv->selected_color;
#line 2000 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp19_ = _tmp18_.red;
#line 2000 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp20_ = self->priv->selected_color;
#line 2000 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp21_ = _tmp20_.green;
#line 2000 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp22_ = self->priv->selected_color;
#line 2000 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp23_ = _tmp22_.blue;
#line 2000 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		cairo_set_source_rgba (ctx, _tmp19_, _tmp21_, _tmp23_, CHECKERBOARD_LAYOUT_SELECTION_ALPHA);
#line 2002 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp24_ = visible_band;
#line 2002 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp25_ = _tmp24_.x;
#line 2002 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp26_ = visible_band;
#line 2002 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp27_ = _tmp26_.y;
#line 2002 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp28_ = visible_band;
#line 2002 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp29_ = _tmp28_.width;
#line 2002 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp30_ = visible_band;
#line 2002 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp31_ = _tmp30_.height;
#line 2002 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		cairo_rectangle (ctx, (gdouble) _tmp25_, (gdouble) _tmp27_, (gdouble) _tmp29_, (gdouble) _tmp31_);
#line 2004 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		cairo_fill (ctx);
#line 11349 "CheckerboardLayout.c"
	}
#line 2010 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	cairo_set_line_width (ctx, 1.0);
#line 2011 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	cairo_set_line_cap (ctx, CAIRO_LINE_CAP_SQUARE);
#line 2012 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp32_ = self->priv->selected_color;
#line 2012 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp33_ = _tmp32_.red;
#line 2012 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp34_ = self->priv->selected_color;
#line 2012 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp35_ = _tmp34_.green;
#line 2012 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp36_ = self->priv->selected_color;
#line 2012 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp37_ = _tmp36_.blue;
#line 2012 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	cairo_set_source_rgb (ctx, _tmp33_, _tmp35_, _tmp37_);
#line 2013 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp38_ = self->priv->selection_band;
#line 2013 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp39_ = _tmp38_.x;
#line 2013 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp40_ = self->priv->selection_band;
#line 2013 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp41_ = _tmp40_.y;
#line 2013 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp42_ = self->priv->selection_band;
#line 2013 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp43_ = _tmp42_.width;
#line 2013 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp44_ = self->priv->selection_band;
#line 2013 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp45_ = _tmp44_.height;
#line 2013 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	cairo_rectangle (ctx, ((gdouble) _tmp39_) + 0.5, ((gdouble) _tmp41_) + 0.5, ((gdouble) _tmp43_) - 1.0, ((gdouble) _tmp45_) - 1.0);
#line 2015 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	cairo_stroke (ctx);
#line 11389 "CheckerboardLayout.c"
}


static gboolean
checkerboard_layout_real_query_tooltip (GtkWidget* base,
                                        gint x,
                                        gint y,
                                        gboolean keyboard_mode,
                                        GtkTooltip* tooltip)
{
	CheckerboardLayout * self;
	gboolean result = FALSE;
	CheckerboardItem* item = NULL;
	CheckerboardItem* _tmp0_;
	gboolean _tmp1_ = FALSE;
	CheckerboardItem* _tmp2_;
#line 2018 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_CHECKERBOARD_LAYOUT, CheckerboardLayout);
#line 2018 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_val_if_fail (GTK_IS_TOOLTIP (tooltip), FALSE);
#line 2019 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = checkerboard_layout_get_item_at_pixel (self, (gdouble) x, (gdouble) y);
#line 2019 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	item = _tmp0_;
#line 2021 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp2_ = item;
#line 2021 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp2_ != NULL) {
#line 11418 "CheckerboardLayout.c"
		CheckerboardItem* _tmp3_;
#line 2021 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp3_ = item;
#line 2021 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp1_ = checkerboard_item_query_tooltip (_tmp3_, x, y, tooltip);
#line 11424 "CheckerboardLayout.c"
	} else {
#line 2021 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp1_ = FALSE;
#line 11428 "CheckerboardLayout.c"
	}
#line 2021 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	result = _tmp1_;
#line 2021 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_g_object_unref0 (item);
#line 2021 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return result;
#line 11436 "CheckerboardLayout.c"
}


static void
checkerboard_layout_on_colors_changed (CheckerboardLayout* self)
{
	ConfigFacade* _tmp0_;
	ConfigFacade* _tmp1_;
	GdkRGBA _tmp2_ = {0};
#line 2024 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (IS_CHECKERBOARD_LAYOUT (self));
#line 2025 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	invalidate_transparent_background ();
#line 2026 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = config_facade_get_instance ();
#line 2026 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = _tmp0_;
#line 2026 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	config_facade_get_bg_color (_tmp1_, &_tmp2_);
#line 2026 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	gtk_widget_override_background_color (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), GTK_STATE_FLAG_NORMAL, &_tmp2_);
#line 2026 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_g_object_unref0 (_tmp1_);
#line 2027 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	checkerboard_layout_set_colors (self, TRUE);
#line 11462 "CheckerboardLayout.c"
}


static gboolean
checkerboard_layout_real_focus_in_event (GtkWidget* base,
                                         GdkEventFocus* event)
{
	CheckerboardLayout * self;
	gboolean result = FALSE;
	ViewCollection* _tmp0_;
	GeeList* _tmp1_;
	GeeList* _tmp2_;
#line 2030 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_CHECKERBOARD_LAYOUT, CheckerboardLayout);
#line 2030 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_val_if_fail (event != NULL, FALSE);
#line 2031 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	checkerboard_layout_set_colors (self, TRUE);
#line 2032 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = self->priv->view;
#line 2032 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = view_collection_get_selected (_tmp0_);
#line 2032 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp2_ = _tmp1_;
#line 2032 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	checkerboard_layout_items_dirty (self, "focus_in_event", G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GEE_TYPE_ITERABLE, GeeIterable));
#line 2032 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_g_object_unref0 (_tmp2_);
#line 2034 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	result = GTK_WIDGET_CLASS (checkerboard_layout_parent_class)->focus_in_event (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_drawing_area_get_type (), GtkDrawingArea), gtk_widget_get_type (), GtkWidget), event);
#line 2034 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return result;
#line 11495 "CheckerboardLayout.c"
}


static gboolean
checkerboard_layout_real_focus_out_event (GtkWidget* base,
                                          GdkEventFocus* event)
{
	CheckerboardLayout * self;
	gboolean result = FALSE;
	ViewCollection* _tmp0_;
	GeeList* _tmp1_;
	GeeList* _tmp2_;
#line 2037 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_CHECKERBOARD_LAYOUT, CheckerboardLayout);
#line 2037 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_val_if_fail (event != NULL, FALSE);
#line 2038 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	checkerboard_layout_set_colors (self, FALSE);
#line 2039 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = self->priv->view;
#line 2039 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = view_collection_get_selected (_tmp0_);
#line 2039 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp2_ = _tmp1_;
#line 2039 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	checkerboard_layout_items_dirty (self, "focus_out_event", G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GEE_TYPE_ITERABLE, GeeIterable));
#line 2039 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_g_object_unref0 (_tmp2_);
#line 2041 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	result = GTK_WIDGET_CLASS (checkerboard_layout_parent_class)->focus_out_event (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_drawing_area_get_type (), GtkDrawingArea), gtk_widget_get_type (), GtkWidget), event);
#line 2041 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return result;
#line 11528 "CheckerboardLayout.c"
}


static CheckerboardLayoutLayoutRow*
checkerboard_layout_layout_row_construct (GType object_type,
                                          gint y,
                                          gint height,
                                          gint num_in_row)
{
	CheckerboardLayoutLayoutRow* self = NULL;
	CheckerboardItem** _tmp0_;
#line 847 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self = (CheckerboardLayoutLayoutRow*) g_type_create_instance (object_type);
#line 848 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->y = y;
#line 849 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->height = height;
#line 850 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = g_new0 (CheckerboardItem*, num_in_row + 1);
#line 850 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->items = (_vala_array_free (self->items, self->items_length1, (GDestroyNotify) g_object_unref), NULL);
#line 850 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->items = _tmp0_;
#line 850 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->items_length1 = num_in_row;
#line 850 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->_items_size_ = self->items_length1;
#line 847 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return self;
#line 11558 "CheckerboardLayout.c"
}


static CheckerboardLayoutLayoutRow*
checkerboard_layout_layout_row_new (gint y,
                                    gint height,
                                    gint num_in_row)
{
#line 847 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return checkerboard_layout_layout_row_construct (CHECKERBOARD_LAYOUT_TYPE_LAYOUT_ROW, y, height, num_in_row);
#line 11569 "CheckerboardLayout.c"
}


static void
checkerboard_layout_value_layout_row_init (GValue* value)
{
#line 842 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	value->data[0].v_pointer = NULL;
#line 11578 "CheckerboardLayout.c"
}


static void
checkerboard_layout_value_layout_row_free_value (GValue* value)
{
#line 842 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (value->data[0].v_pointer) {
#line 842 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		checkerboard_layout_layout_row_unref (value->data[0].v_pointer);
#line 11589 "CheckerboardLayout.c"
	}
}


static void
checkerboard_layout_value_layout_row_copy_value (const GValue* src_value,
                                                 GValue* dest_value)
{
#line 842 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (src_value->data[0].v_pointer) {
#line 842 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		dest_value->data[0].v_pointer = checkerboard_layout_layout_row_ref (src_value->data[0].v_pointer);
#line 11602 "CheckerboardLayout.c"
	} else {
#line 842 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		dest_value->data[0].v_pointer = NULL;
#line 11606 "CheckerboardLayout.c"
	}
}


static gpointer
checkerboard_layout_value_layout_row_peek_pointer (const GValue* value)
{
#line 842 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return value->data[0].v_pointer;
#line 11616 "CheckerboardLayout.c"
}


static gchar*
checkerboard_layout_value_layout_row_collect_value (GValue* value,
                                                    guint n_collect_values,
                                                    GTypeCValue* collect_values,
                                                    guint collect_flags)
{
#line 842 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (collect_values[0].v_pointer) {
#line 11628 "CheckerboardLayout.c"
		CheckerboardLayoutLayoutRow * object;
		object = collect_values[0].v_pointer;
#line 842 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		if (object->parent_instance.g_class == NULL) {
#line 842 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 11635 "CheckerboardLayout.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 842 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 11639 "CheckerboardLayout.c"
		}
#line 842 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		value->data[0].v_pointer = checkerboard_layout_layout_row_ref (object);
#line 11643 "CheckerboardLayout.c"
	} else {
#line 842 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		value->data[0].v_pointer = NULL;
#line 11647 "CheckerboardLayout.c"
	}
#line 842 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return NULL;
#line 11651 "CheckerboardLayout.c"
}


static gchar*
checkerboard_layout_value_layout_row_lcopy_value (const GValue* value,
                                                  guint n_collect_values,
                                                  GTypeCValue* collect_values,
                                                  guint collect_flags)
{
	CheckerboardLayoutLayoutRow ** object_p;
	object_p = collect_values[0].v_pointer;
#line 842 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (!object_p) {
#line 842 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 11667 "CheckerboardLayout.c"
	}
#line 842 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (!value->data[0].v_pointer) {
#line 842 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		*object_p = NULL;
#line 11673 "CheckerboardLayout.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 842 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		*object_p = value->data[0].v_pointer;
#line 11677 "CheckerboardLayout.c"
	} else {
#line 842 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		*object_p = checkerboard_layout_layout_row_ref (value->data[0].v_pointer);
#line 11681 "CheckerboardLayout.c"
	}
#line 842 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return NULL;
#line 11685 "CheckerboardLayout.c"
}


static GParamSpec*
checkerboard_layout_param_spec_layout_row (const gchar* name,
                                           const gchar* nick,
                                           const gchar* blurb,
                                           GType object_type,
                                           GParamFlags flags)
{
	CheckerboardLayoutParamSpecLayoutRow* spec;
#line 842 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_val_if_fail (g_type_is_a (object_type, CHECKERBOARD_LAYOUT_TYPE_LAYOUT_ROW), NULL);
#line 842 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 842 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 842 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return G_PARAM_SPEC (spec);
#line 11705 "CheckerboardLayout.c"
}


static gpointer
checkerboard_layout_value_get_layout_row (const GValue* value)
{
#line 842 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, CHECKERBOARD_LAYOUT_TYPE_LAYOUT_ROW), NULL);
#line 842 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return value->data[0].v_pointer;
#line 11716 "CheckerboardLayout.c"
}


static void
checkerboard_layout_value_set_layout_row (GValue* value,
                                          gpointer v_object)
{
	CheckerboardLayoutLayoutRow * old;
#line 842 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, CHECKERBOARD_LAYOUT_TYPE_LAYOUT_ROW));
#line 842 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	old = value->data[0].v_pointer;
#line 842 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (v_object) {
#line 842 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, CHECKERBOARD_LAYOUT_TYPE_LAYOUT_ROW));
#line 842 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 842 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		value->data[0].v_pointer = v_object;
#line 842 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		checkerboard_layout_layout_row_ref (value->data[0].v_pointer);
#line 11739 "CheckerboardLayout.c"
	} else {
#line 842 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		value->data[0].v_pointer = NULL;
#line 11743 "CheckerboardLayout.c"
	}
#line 842 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (old) {
#line 842 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		checkerboard_layout_layout_row_unref (old);
#line 11749 "CheckerboardLayout.c"
	}
}


static void
checkerboard_layout_value_take_layout_row (GValue* value,
                                           gpointer v_object)
{
	CheckerboardLayoutLayoutRow * old;
#line 842 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, CHECKERBOARD_LAYOUT_TYPE_LAYOUT_ROW));
#line 842 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	old = value->data[0].v_pointer;
#line 842 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (v_object) {
#line 842 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, CHECKERBOARD_LAYOUT_TYPE_LAYOUT_ROW));
#line 842 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 842 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		value->data[0].v_pointer = v_object;
#line 11771 "CheckerboardLayout.c"
	} else {
#line 842 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		value->data[0].v_pointer = NULL;
#line 11775 "CheckerboardLayout.c"
	}
#line 842 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (old) {
#line 842 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		checkerboard_layout_layout_row_unref (old);
#line 11781 "CheckerboardLayout.c"
	}
}


static void
checkerboard_layout_layout_row_class_init (CheckerboardLayoutLayoutRowClass * klass)
{
#line 842 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	checkerboard_layout_layout_row_parent_class = g_type_class_peek_parent (klass);
#line 842 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	((CheckerboardLayoutLayoutRowClass *) klass)->finalize = checkerboard_layout_layout_row_finalize;
#line 11793 "CheckerboardLayout.c"
}


static void
checkerboard_layout_layout_row_instance_init (CheckerboardLayoutLayoutRow * self)
{
#line 842 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->ref_count = 1;
#line 11802 "CheckerboardLayout.c"
}


static void
checkerboard_layout_layout_row_finalize (CheckerboardLayoutLayoutRow * obj)
{
	CheckerboardLayoutLayoutRow * self;
#line 842 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CHECKERBOARD_LAYOUT_TYPE_LAYOUT_ROW, CheckerboardLayoutLayoutRow);
#line 842 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_signal_handlers_destroy (self);
#line 845 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->items = (_vala_array_free (self->items, self->items_length1, (GDestroyNotify) g_object_unref), NULL);
#line 11816 "CheckerboardLayout.c"
}


static GType
checkerboard_layout_layout_row_get_type (void)
{
	static volatile gsize checkerboard_layout_layout_row_type_id__volatile = 0;
	if (g_once_init_enter (&checkerboard_layout_layout_row_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { checkerboard_layout_value_layout_row_init, checkerboard_layout_value_layout_row_free_value, checkerboard_layout_value_layout_row_copy_value, checkerboard_layout_value_layout_row_peek_pointer, "p", checkerboard_layout_value_layout_row_collect_value, "p", checkerboard_layout_value_layout_row_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (CheckerboardLayoutLayoutRowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) checkerboard_layout_layout_row_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CheckerboardLayoutLayoutRow), 0, (GInstanceInitFunc) checkerboard_layout_layout_row_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType checkerboard_layout_layout_row_type_id;
		checkerboard_layout_layout_row_type_id = g_type_register_fundamental (g_type_fundamental_next (), "CheckerboardLayoutLayoutRow", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&checkerboard_layout_layout_row_type_id__volatile, checkerboard_layout_layout_row_type_id);
	}
	return checkerboard_layout_layout_row_type_id__volatile;
}


static gpointer
checkerboard_layout_layout_row_ref (gpointer instance)
{
	CheckerboardLayoutLayoutRow * self;
	self = instance;
#line 842 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_atomic_int_inc (&self->ref_count);
#line 842 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return instance;
#line 11845 "CheckerboardLayout.c"
}


static void
checkerboard_layout_layout_row_unref (gpointer instance)
{
	CheckerboardLayoutLayoutRow * self;
	self = instance;
#line 842 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 842 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		CHECKERBOARD_LAYOUT_LAYOUT_ROW_GET_CLASS (self)->finalize (self);
#line 842 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 11860 "CheckerboardLayout.c"
	}
}


static void
checkerboard_layout_class_init (CheckerboardLayoutClass * klass)
{
#line 825 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	checkerboard_layout_parent_class = g_type_class_peek_parent (klass);
#line 825 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_type_class_add_private (klass, sizeof (CheckerboardLayoutPrivate));
#line 825 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	((GtkWidgetClass *) klass)->map = (void (*) (GtkWidget *)) checkerboard_layout_real_map;
#line 825 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	((GtkWidgetClass *) klass)->size_allocate = (void (*) (GtkWidget *, GtkAllocation*)) checkerboard_layout_real_size_allocate;
#line 825 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	((GtkWidgetClass *) klass)->draw = (gboolean (*) (GtkWidget *, cairo_t*)) checkerboard_layout_real_draw;
#line 825 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	((GtkWidgetClass *) klass)->query_tooltip = (gboolean (*) (GtkWidget *, gint, gint, gboolean, GtkTooltip*)) checkerboard_layout_real_query_tooltip;
#line 825 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	((GtkWidgetClass *) klass)->focus_in_event = (gboolean (*) (GtkWidget *, GdkEventFocus*)) checkerboard_layout_real_focus_in_event;
#line 825 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	((GtkWidgetClass *) klass)->focus_out_event = (gboolean (*) (GtkWidget *, GdkEventFocus*)) checkerboard_layout_real_focus_out_event;
#line 825 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	G_OBJECT_CLASS (klass)->finalize = checkerboard_layout_finalize;
#line 11886 "CheckerboardLayout.c"
}


static void
checkerboard_layout_instance_init (CheckerboardLayout * self)
{
	gchar* _tmp0_;
	GeeHashSet* _tmp1_;
#line 825 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv = CHECKERBOARD_LAYOUT_GET_PRIVATE (self);
#line 855 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = g_strdup ("");
#line 855 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->page_name = _tmp0_;
#line 856 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->item_rows = NULL;
#line 856 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->item_rows_length1 = 0;
#line 856 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->_item_rows_size_ = self->priv->item_rows_length1;
#line 857 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = gee_hash_set_new (TYPE_CHECKERBOARD_ITEM, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL);
#line 857 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->exposed_items = _tmp1_;
#line 858 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->hadjustment = NULL;
#line 859 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->vadjustment = NULL;
#line 860 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->message = NULL;
#line 865 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	memset (&self->priv->visible_page, 0, sizeof (GdkRectangle));
#line 866 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->last_width = 0;
#line 867 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->columns = 0;
#line 868 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->rows = 0;
#line 869 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	memset (&self->priv->drag_origin, 0, sizeof (GdkPoint));
#line 870 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	memset (&self->priv->drag_endpoint, 0, sizeof (GdkPoint));
#line 871 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	memset (&self->priv->selection_band, 0, sizeof (GdkRectangle));
#line 872 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->scale = 0;
#line 873 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->flow_scheduled = FALSE;
#line 874 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->exposure_dirty = TRUE;
#line 875 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->anchor = NULL;
#line 876 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->cursor = NULL;
#line 877 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->in_center_on_anchor = FALSE;
#line 878 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->size_allocate_due_to_reflow = FALSE;
#line 879 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->is_in_view = FALSE;
#line 880 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->reflow_needed = FALSE;
#line 11949 "CheckerboardLayout.c"
}


static void
checkerboard_layout_finalize (GObject * obj)
{
	CheckerboardLayout * self;
	ViewCollection* _tmp0_;
	guint _tmp1_;
	ViewCollection* _tmp2_;
	guint _tmp3_;
	ViewCollection* _tmp4_;
	guint _tmp5_;
	ViewCollection* _tmp6_;
	guint _tmp7_;
	ViewCollection* _tmp8_;
	guint _tmp9_;
	ViewCollection* _tmp10_;
	guint _tmp11_;
	ViewCollection* _tmp12_;
	guint _tmp13_;
	ViewCollection* _tmp14_;
	guint _tmp15_;
	ViewCollection* _tmp16_;
	guint _tmp17_;
	GtkAdjustment* _tmp18_;
	GtkAdjustment* _tmp21_;
	GtkContainer* _tmp24_;
	GtkContainer* _tmp25_;
	ConfigFacade* _tmp29_;
	ConfigFacade* _tmp30_;
	guint _tmp31_;
#line 825 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_CHECKERBOARD_LAYOUT, CheckerboardLayout);
#line 911 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = self->priv->view;
#line 911 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_signal_parse_name ("contents-altered", TYPE_DATA_COLLECTION, &_tmp1_, NULL, FALSE);
#line 911 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_signal_handlers_disconnect_matched (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, TYPE_DATA_COLLECTION, DataCollection), G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, 0, NULL, (GCallback) _checkerboard_layout_on_contents_altered_data_collection_contents_altered, self);
#line 912 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp2_ = self->priv->view;
#line 912 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_signal_parse_name ("items-altered", TYPE_DATA_COLLECTION, &_tmp3_, NULL, FALSE);
#line 912 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_signal_handlers_disconnect_matched (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, TYPE_DATA_COLLECTION, DataCollection), G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp3_, 0, NULL, (GCallback) _checkerboard_layout_on_items_altered_data_collection_items_altered, self);
#line 913 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp4_ = self->priv->view;
#line 913 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_signal_parse_name ("items-state-changed", TYPE_VIEW_COLLECTION, &_tmp5_, NULL, FALSE);
#line 913 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_signal_handlers_disconnect_matched (_tmp4_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp5_, 0, NULL, (GCallback) _checkerboard_layout_on_items_state_changed_view_collection_items_state_changed, self);
#line 914 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp6_ = self->priv->view;
#line 914 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_signal_parse_name ("items-visibility-changed", TYPE_VIEW_COLLECTION, &_tmp7_, NULL, FALSE);
#line 914 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_signal_handlers_disconnect_matched (_tmp6_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp7_, 0, NULL, (GCallback) _checkerboard_layout_on_items_visibility_changed_view_collection_items_visibility_changed, self);
#line 915 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp8_ = self->priv->view;
#line 915 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_signal_parse_name ("ordering-changed", TYPE_DATA_COLLECTION, &_tmp9_, NULL, FALSE);
#line 915 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_signal_handlers_disconnect_matched (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, TYPE_DATA_COLLECTION, DataCollection), G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp9_, 0, NULL, (GCallback) _checkerboard_layout_on_ordering_changed_data_collection_ordering_changed, self);
#line 916 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp10_ = self->priv->view;
#line 916 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_signal_parse_name ("views-altered", TYPE_VIEW_COLLECTION, &_tmp11_, NULL, FALSE);
#line 916 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_signal_handlers_disconnect_matched (_tmp10_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp11_, 0, NULL, (GCallback) _checkerboard_layout_on_views_altered_view_collection_views_altered, self);
#line 917 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp12_ = self->priv->view;
#line 917 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_signal_parse_name ("geometries-altered", TYPE_VIEW_COLLECTION, &_tmp13_, NULL, FALSE);
#line 917 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_signal_handlers_disconnect_matched (_tmp12_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp13_, 0, NULL, (GCallback) _checkerboard_layout_on_geometries_altered_view_collection_geometries_altered, self);
#line 918 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp14_ = self->priv->view;
#line 918 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_signal_parse_name ("items-selected", TYPE_VIEW_COLLECTION, &_tmp15_, NULL, FALSE);
#line 918 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_signal_handlers_disconnect_matched (_tmp14_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp15_, 0, NULL, (GCallback) _checkerboard_layout_on_items_selection_changed_view_collection_items_selected, self);
#line 919 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp16_ = self->priv->view;
#line 919 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_signal_parse_name ("items-unselected", TYPE_VIEW_COLLECTION, &_tmp17_, NULL, FALSE);
#line 919 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_signal_handlers_disconnect_matched (_tmp16_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp17_, 0, NULL, (GCallback) _checkerboard_layout_on_items_selection_changed_view_collection_items_unselected, self);
#line 921 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp18_ = self->priv->hadjustment;
#line 921 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp18_ != NULL) {
#line 12042 "CheckerboardLayout.c"
		GtkAdjustment* _tmp19_;
		guint _tmp20_;
#line 922 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp19_ = self->priv->hadjustment;
#line 922 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		g_signal_parse_name ("value-changed", gtk_adjustment_get_type (), &_tmp20_, NULL, FALSE);
#line 922 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		g_signal_handlers_disconnect_matched (_tmp19_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp20_, 0, NULL, (GCallback) _checkerboard_layout_on_viewport_shifted_gtk_adjustment_value_changed, self);
#line 12051 "CheckerboardLayout.c"
	}
#line 924 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp21_ = self->priv->vadjustment;
#line 924 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp21_ != NULL) {
#line 12057 "CheckerboardLayout.c"
		GtkAdjustment* _tmp22_;
		guint _tmp23_;
#line 925 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp22_ = self->priv->vadjustment;
#line 925 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		g_signal_parse_name ("value-changed", gtk_adjustment_get_type (), &_tmp23_, NULL, FALSE);
#line 925 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		g_signal_handlers_disconnect_matched (_tmp22_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp23_, 0, NULL, (GCallback) _checkerboard_layout_on_viewport_shifted_gtk_adjustment_value_changed, self);
#line 12066 "CheckerboardLayout.c"
	}
#line 927 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp24_ = gtk_widget_get_parent (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
#line 927 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp25_ = _tmp24_;
#line 927 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp25_ != NULL) {
#line 12074 "CheckerboardLayout.c"
		GtkContainer* _tmp26_;
		GtkContainer* _tmp27_;
		guint _tmp28_;
#line 928 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp26_ = gtk_widget_get_parent (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
#line 928 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp27_ = _tmp26_;
#line 928 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		g_signal_parse_name ("size-allocate", gtk_widget_get_type (), &_tmp28_, NULL, FALSE);
#line 928 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		g_signal_handlers_disconnect_matched (G_TYPE_CHECK_INSTANCE_CAST (_tmp27_, gtk_widget_get_type (), GtkWidget), G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp28_, 0, NULL, (GCallback) _checkerboard_layout_on_viewport_resized_gtk_widget_size_allocate, self);
#line 12086 "CheckerboardLayout.c"
	}
#line 930 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp29_ = config_facade_get_instance ();
#line 930 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp30_ = _tmp29_;
#line 930 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_signal_parse_name ("colors-changed", CONFIG_TYPE_FACADE, &_tmp31_, NULL, FALSE);
#line 930 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_signal_handlers_disconnect_matched (_tmp30_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp31_, 0, NULL, (GCallback) _checkerboard_layout_on_colors_changed_config_facade_colors_changed, self);
#line 930 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_g_object_unref0 (_tmp30_);
#line 854 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_data_collection_unref0 (self->priv->view);
#line 855 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_g_free0 (self->priv->page_name);
#line 856 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->item_rows = (_vala_array_free (self->priv->item_rows, self->priv->item_rows_length1, (GDestroyNotify) checkerboard_layout_layout_row_unref), NULL);
#line 857 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_g_object_unref0 (self->priv->exposed_items);
#line 858 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_g_object_unref0 (self->priv->hadjustment);
#line 859 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_g_object_unref0 (self->priv->vadjustment);
#line 860 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_g_free0 (self->priv->message);
#line 875 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_g_object_unref0 (self->priv->anchor);
#line 876 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_g_object_unref0 (self->priv->cursor);
#line 825 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	G_OBJECT_CLASS (checkerboard_layout_parent_class)->finalize (obj);
#line 12118 "CheckerboardLayout.c"
}


GType
checkerboard_layout_get_type (void)
{
	static volatile gsize checkerboard_layout_type_id__volatile = 0;
	if (g_once_init_enter (&checkerboard_layout_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (CheckerboardLayoutClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) checkerboard_layout_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CheckerboardLayout), 0, (GInstanceInitFunc) checkerboard_layout_instance_init, NULL };
		GType checkerboard_layout_type_id;
		checkerboard_layout_type_id = g_type_register_static (gtk_drawing_area_get_type (), "CheckerboardLayout", &g_define_type_info, 0);
		g_once_init_leave (&checkerboard_layout_type_id__volatile, checkerboard_layout_type_id);
	}
	return checkerboard_layout_type_id__volatile;
}


static void
_vala_array_destroy (gpointer array,
                     gint array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void
_vala_array_free (gpointer array,
                  gint array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



