/*
 * Decompiled with CFR 0.152.
 */
package com.google.web.bindery.requestfactory.vm;

import com.google.web.bindery.autobean.shared.AutoBean;
import com.google.web.bindery.autobean.shared.AutoBeanFactory;
import com.google.web.bindery.autobean.vm.impl.BeanMethod;
import com.google.web.bindery.autobean.vm.impl.TypeUtils;
import com.google.web.bindery.requestfactory.shared.InstanceRequest;
import com.google.web.bindery.requestfactory.shared.JsonRpcContent;
import com.google.web.bindery.requestfactory.shared.JsonRpcWireName;
import com.google.web.bindery.requestfactory.shared.Request;
import com.google.web.bindery.requestfactory.shared.RequestContext;
import com.google.web.bindery.requestfactory.shared.impl.AbstractRequest;
import com.google.web.bindery.requestfactory.shared.impl.AbstractRequestContext;
import com.google.web.bindery.requestfactory.shared.impl.AbstractRequestFactory;
import com.google.web.bindery.requestfactory.shared.impl.RequestData;
import com.google.web.bindery.requestfactory.vm.InProcessRequestFactory;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.util.Collection;

class InProcessRequestContext
extends AbstractRequestContext {
    static final Object[] NO_ARGS = new Object[0];
    private final AbstractRequestContext.Dialect dialect;

    protected InProcessRequestContext(AbstractRequestFactory factory, AbstractRequestContext.Dialect dialect) {
        super(factory, dialect);
        this.dialect = dialect;
    }

    protected AutoBeanFactory getAutoBeanFactory() {
        return ((InProcessRequestFactory)this.getRequestFactory()).getAutoBeanFactory();
    }

    class RequestContextHandler
    implements InvocationHandler {
        RequestContextHandler() {
        }

        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            RequestData data;
            Class<?> elementType;
            Object[] actualArgs;
            Type returnGenericType;
            Class<?> owner = method.getDeclaringClass();
            if (Object.class.equals(owner) || RequestContext.class.equals(owner) || AbstractRequestContext.class.equals(owner)) {
                try {
                    return method.invoke((Object)InProcessRequestContext.this, args);
                }
                catch (InvocationTargetException e) {
                    throw e.getCause();
                }
            }
            boolean isInstance = InstanceRequest.class.isAssignableFrom(method.getReturnType());
            if (isInstance) {
                returnGenericType = TypeUtils.getParameterization(InstanceRequest.class, method.getGenericReturnType(), method.getReturnType())[1];
                if (args == null) {
                    actualArgs = new Object[1];
                } else {
                    actualArgs = new Object[args.length + 1];
                    System.arraycopy(args, 0, actualArgs, 1, args.length);
                }
            } else {
                returnGenericType = TypeUtils.getSingleParameterization(Request.class, method.getGenericReturnType(), method.getReturnType());
                actualArgs = args == null ? NO_ARGS : args;
            }
            Class<?> returnType = TypeUtils.ensureBaseType(returnGenericType);
            Class<?> clazz = elementType = Collection.class.isAssignableFrom(returnType) ? TypeUtils.ensureBaseType(TypeUtils.getSingleParameterization(Collection.class, returnGenericType)) : null;
            if (InProcessRequestContext.this.dialect.equals((Object)AbstractRequestContext.Dialect.STANDARD)) {
                String operation = method.getDeclaringClass().getName() + "::" + method.getName();
                data = new RequestData(operation, actualArgs, returnType, elementType);
            } else {
                JsonRpcWireName wireInfo = method.getReturnType().getAnnotation(JsonRpcWireName.class);
                String apiVersion = wireInfo.version();
                String operation = wireInfo.value();
                int foundContent = -1;
                String[] parameterNames = args == null ? new String[]{} : new String[args.length];
                Annotation[][] parameterAnnotations = method.getParameterAnnotations();
                int j = parameterAnnotations.length;
                block2: for (int i = 0; i < j; ++i) {
                    for (Annotation annotation : parameterAnnotations[i]) {
                        if (AutoBean.PropertyName.class.equals(annotation.annotationType())) {
                            parameterNames[i] = ((AutoBean.PropertyName)annotation).value();
                            continue block2;
                        }
                        if (!JsonRpcContent.class.equals(annotation.annotationType())) continue;
                        foundContent = i;
                        continue block2;
                    }
                    throw new UnsupportedOperationException("No " + AutoBean.PropertyName.class.getCanonicalName() + " annotation on parameter " + i + " of method " + method.toString());
                }
                int contentIdx = foundContent;
                data = new RequestData(operation, actualArgs, returnType, elementType);
                int j2 = args.length;
                for (int i = 0; i < j2; ++i) {
                    if (i != contentIdx) {
                        data.setNamedParameter(parameterNames[i], args[i]);
                    } else {
                        data.setRequestContent(args[i]);
                    }
                    data.setApiVersion(apiVersion);
                }
            }
            final AbstractRequest<Object> req = new AbstractRequest<Object>((AbstractRequestContext)InProcessRequestContext.this){

                @Override
                protected RequestData makeRequestData() {
                    data.setPropertyRefs(this.propertyRefs);
                    return data;
                }
            };
            if (!isInstance) {
                InProcessRequestContext.this.addInvocation(req);
            }
            if (InProcessRequestContext.this.dialect.equals((Object)AbstractRequestContext.Dialect.STANDARD)) {
                return req;
            }
            if (InProcessRequestContext.this.dialect.equals((Object)AbstractRequestContext.Dialect.JSON_RPC)) {
                Class<Request> requestType = method.getReturnType().asSubclass(Request.class);
                return Proxy.newProxyInstance(requestType.getClassLoader(), new Class[]{requestType}, new InvocationHandler(){

                    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                        if (Object.class.equals(method.getDeclaringClass()) || Request.class.equals(method.getDeclaringClass())) {
                            return method.invoke((Object)req, args);
                        }
                        if (BeanMethod.SET.matches(method) || BeanMethod.SET_BUILDER.matches(method)) {
                            req.getRequestData().setNamedParameter(BeanMethod.SET.inferName(method), args[0]);
                            return Void.TYPE.equals(method.getReturnType()) ? null : proxy;
                        }
                        throw new UnsupportedOperationException(method.toString());
                    }
                });
            }
            throw new RuntimeException("Should not reach here");
        }
    }
}

