/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.io;

import it.unimi.dsi.bits.Fast;
import it.unimi.dsi.fastutil.booleans.BooleanIterator;
import it.unimi.dsi.fastutil.io.RepositionableStream;
import it.unimi.dsi.io.InputBitStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.Flushable;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.nio.channels.FileChannel;

public class OutputBitStream
implements Flushable,
Closeable {
    public static final int MAX_PRECOMPUTED = 4096;
    private static final boolean DEBUG = false;
    public static final int[] GAMMA = new int[4096];
    public static final int[] DELTA = new int[4096];
    public static final int[] ZETA_3 = new int[4096];
    public static final int[] SHIFTED_GAMMA = new int[4096];
    public static final int DEFAULT_BUFFER_SIZE = 16384;
    protected final OutputStream os;
    private long writtenBits;
    private int current;
    protected byte[] buffer;
    protected int free;
    protected int pos;
    protected long position;
    protected int avail;
    static final int TEMP_BUFFER_SIZE = 128;
    protected final FileChannel fileChannel;
    protected final RepositionableStream repositionableStream;
    protected final boolean wrapping;

    protected OutputBitStream() {
        this.os = null;
        this.fileChannel = null;
        this.repositionableStream = null;
        this.wrapping = false;
    }

    public OutputBitStream(OutputStream os) {
        this(os, true);
    }

    public OutputBitStream(OutputStream os, boolean testForPosition) {
        this(os, 16384);
    }

    public OutputBitStream(OutputStream os, int bufSize) {
        this(os, bufSize, true);
    }

    public OutputBitStream(OutputStream os, int bufSize, boolean testForPosition) {
        this.os = os;
        this.wrapping = false;
        if (bufSize != 0) {
            this.buffer = new byte[bufSize];
            this.avail = bufSize;
        }
        this.free = 8;
        if (os instanceof RepositionableStream) {
            this.repositionableStream = (RepositionableStream)((Object)os);
            this.fileChannel = null;
        } else if (testForPosition) {
            FileChannel fc = null;
            try {
                fc = (FileChannel)os.getClass().getMethod("getChannel", new Class[0]).invoke((Object)os, new Object[0]);
            }
            catch (IllegalAccessException e) {
            }
            catch (IllegalArgumentException e) {
            }
            catch (NoSuchMethodException e) {
            }
            catch (InvocationTargetException e) {
            }
            catch (ClassCastException e) {
                // empty catch block
            }
            this.fileChannel = fc;
            this.repositionableStream = null;
        } else {
            this.repositionableStream = null;
            this.fileChannel = null;
        }
    }

    public OutputBitStream(FileOutputStream os) {
        this(os, 16384);
    }

    public OutputBitStream(FileOutputStream os, int bufSize) {
        this.os = os;
        this.wrapping = false;
        if (bufSize != 0) {
            this.buffer = new byte[bufSize];
            this.avail = bufSize;
        }
        this.free = 8;
        this.repositionableStream = null;
        this.fileChannel = os.getChannel();
    }

    public OutputBitStream(byte[] a) {
        this.os = null;
        this.free = 8;
        this.buffer = a;
        this.avail = a.length;
        this.wrapping = true;
        this.fileChannel = null;
        this.repositionableStream = null;
    }

    public OutputBitStream(String name, int bufSize) throws FileNotFoundException {
        this(new FileOutputStream(name), bufSize);
    }

    public OutputBitStream(String name) throws FileNotFoundException {
        this(new FileOutputStream(name), 16384);
    }

    public OutputBitStream(File file, int bufSize) throws FileNotFoundException {
        this(new FileOutputStream(file), bufSize);
    }

    public OutputBitStream(File file) throws FileNotFoundException {
        this(new FileOutputStream(file), 16384);
    }

    @Override
    public void flush() throws IOException {
        this.align();
        if (this.os != null) {
            if (this.buffer != null) {
                this.os.write(this.buffer, 0, this.pos);
                this.position += (long)this.pos;
                this.pos = 0;
                this.avail = this.buffer.length;
            }
            this.os.flush();
        }
    }

    @Override
    public void close() throws IOException {
        this.flush();
        if (this.os != null && this.os != System.out && this.os != System.err) {
            this.os.close();
        }
        this.buffer = null;
    }

    public long writtenBits() {
        return this.writtenBits;
    }

    public void writtenBits(long writtenBits) {
        this.writtenBits = writtenBits;
    }

    private void write(int b) throws IOException {
        if (this.avail-- == 0) {
            if (this.os == null) {
                this.avail = 0;
                throw new IOException("Array full");
            }
            if (this.buffer == null) {
                this.os.write(b);
                ++this.position;
                this.avail = 0;
                return;
            }
            this.os.write(this.buffer);
            this.position += (long)this.buffer.length;
            this.avail = this.buffer.length - 1;
            this.pos = 0;
        }
        this.buffer[this.pos++] = (byte)b;
    }

    private int writeInCurrent(int b, int len) throws IOException {
        this.current |= (b & (1 << len) - 1) << (this.free -= len);
        if (this.free == 0) {
            this.write(this.current);
            this.free = 8;
            this.current = 0;
        }
        this.writtenBits += (long)len;
        return len;
    }

    public int align() throws IOException {
        if (this.free != 8) {
            return this.writeInCurrent(0, this.free);
        }
        return 0;
    }

    public void position(long position) throws IOException {
        if (position < 0L) {
            throw new IllegalArgumentException("Illegal position: " + position);
        }
        if ((position & 7L) != 0L) {
            throw new IllegalArgumentException("Not a byte-aligned position: " + position);
        }
        if (this.wrapping) {
            if (position > (long)this.buffer.length) {
                throw new IllegalArgumentException("Illegal position: " + position);
            }
            this.flush();
            this.free = 8;
            this.pos = (int)position;
            this.avail = this.buffer.length - this.pos;
        } else if (this.repositionableStream != null) {
            this.flush();
            if (position >> 3 != this.position) {
                this.position = position >> 3;
                this.repositionableStream.position(this.position);
            }
        } else if (this.fileChannel != null) {
            this.flush();
            if (position >> 3 != this.position) {
                this.position = position >> 3;
                this.fileChannel.position(this.position);
            }
        } else {
            throw new UnsupportedOperationException("position() can only be called if the underlying byte stream implements the RepositionableStream interface or if the getChannel() method of the underlying byte stream exists and returns a FileChannel");
        }
    }

    public long write(byte[] bits, long len) throws IOException {
        return this.writeByteOffset(bits, 0, len);
    }

    public long write(byte[] bits, long offset, long len) throws IOException {
        int initial = (int)(8L - (offset & 7L));
        if (initial == 8) {
            return this.writeByteOffset(bits, (int)offset / 8, len);
        }
        if (len <= (long)initial) {
            return this.writeInt((0xFF & bits[(int)(offset / 8L)]) >>> (int)((long)initial - len), (int)len);
        }
        return (long)this.writeInt(bits[(int)(offset / 8L)], initial) + this.writeByteOffset(bits, (int)(offset / 8L + 1L), len - (long)initial);
    }

    protected long writeByteOffset(byte[] bits, int offset, long len) throws IOException {
        if (len == 0L) {
            return 0L;
        }
        if (len <= (long)this.free) {
            return this.writeInCurrent(bits[offset] >>> (int)(8L - len), (int)len);
        }
        int shift = this.free;
        this.writeInCurrent(bits[offset] >>> 8 - shift, shift);
        int j = offset;
        int i = (int)((len -= (long)shift) >> 3);
        while (i-- != 0) {
            this.write(bits[j] << shift | (bits[j + 1] & 0xFF) >>> 8 - shift);
            this.writtenBits += 8L;
            ++j;
        }
        int queue = (int)(len & 7L);
        if (queue != 0) {
            if (queue <= 8 - shift) {
                this.writeInCurrent(bits[j] >>> 8 - shift - queue, queue);
            } else {
                this.writeInCurrent(bits[j], 8 - shift);
                this.writeInCurrent(bits[j + 1] >>> 16 - queue - shift, queue + shift - 8);
            }
        }
        return len + (long)shift;
    }

    public int writeBit(boolean bit) throws IOException {
        return this.writeInCurrent(bit ? 1 : 0, 1);
    }

    public int writeBit(int bit) throws IOException {
        if (bit < 0 || bit > 1) {
            throw new IllegalArgumentException("The argument " + bit + " is not a bit.");
        }
        return this.writeInCurrent(bit, 1);
    }

    public int write(BooleanIterator i) throws IOException {
        int count = 0;
        while (i.hasNext()) {
            boolean bit;
            try {
                bit = i.nextBoolean();
            }
            catch (RuntimeException hide) {
                return -count - 1;
            }
            this.writeBit(bit);
            ++count;
        }
        return count;
    }

    public int writeInt(int x, int len) throws IOException {
        if (len < 0 || len > 32) {
            throw new IllegalArgumentException("You cannot write " + len + " bits to an integer.");
        }
        if (len <= this.free) {
            return this.writeInCurrent(x, len);
        }
        int i = len - this.free;
        int queue = i & 7;
        if (this.free != 0) {
            this.writeInCurrent(x >>> i, this.free);
        }
        if (queue != 0) {
            i -= queue;
            this.writeInCurrent(x, queue);
            x >>>= queue;
        }
        if (i == 32) {
            this.write(x >>> 24);
        }
        if (i > 23) {
            this.write(x >>> 16);
        }
        if (i > 15) {
            this.write(x >>> 8);
        }
        if (i > 7) {
            this.write(x);
        }
        this.writtenBits += (long)i;
        return len;
    }

    public int writeLong(long x, int len) throws IOException {
        if (len < 0 || len > 64) {
            throw new IllegalArgumentException("You cannot write " + len + " bits to a long.");
        }
        if (len <= this.free) {
            return this.writeInCurrent((int)x, len);
        }
        int i = len - this.free;
        int queue = i & 7;
        if (this.free != 0) {
            this.writeInCurrent((int)(x >>> i), this.free);
        }
        if (queue != 0) {
            i -= queue;
            this.writeInCurrent((int)x, queue);
            x >>>= queue;
        }
        if (i == 64) {
            this.write((int)(x >>> 56));
        }
        if (i > 55) {
            this.write((int)(x >>> 48));
        }
        if (i > 47) {
            this.write((int)(x >>> 40));
        }
        if (i > 39) {
            this.write((int)(x >>> 32));
        }
        if (i > 31) {
            this.write((int)x >>> 24);
        }
        if (i > 23) {
            this.write((int)x >>> 16);
        }
        if (i > 15) {
            this.write((int)x >>> 8);
        }
        if (i > 7) {
            this.write((int)x);
        }
        this.writtenBits += (long)i;
        return len;
    }

    public int writeUnary(int x) throws IOException {
        if (x < 0) {
            throw new IllegalArgumentException("The argument " + x + " is negative");
        }
        if (x < this.free) {
            return this.writeInCurrent(1, x + 1);
        }
        int shift = this.free;
        this.writtenBits += (long)shift;
        this.write(this.current);
        this.free = 8;
        this.current = 0;
        int i = (x -= shift) >> 3;
        this.writtenBits += (long)(x & 0x7FFFFFF8);
        while (i-- != 0) {
            this.write(0);
        }
        this.writeInCurrent(1, (x & 7) + 1);
        return x + shift + 1;
    }

    public long writeLongUnary(long x) throws IOException {
        if (x < 0L) {
            throw new IllegalArgumentException("The argument " + x + " is negative");
        }
        if (x < (long)this.free) {
            return this.writeInCurrent(1, (int)x + 1);
        }
        int shift = this.free;
        this.writtenBits += (long)shift;
        this.write(this.current);
        this.free = 8;
        this.current = 0;
        long i = (x -= (long)shift) >> 3;
        this.writtenBits += x & 0x7FFFFFFFFFFFFFF8L;
        while (i-- != 0L) {
            this.write(0);
        }
        this.writeInCurrent(1, (int)(x & 7L) + 1);
        return x + (long)shift + 1L;
    }

    public int writeGamma(int x) throws IOException {
        if (x < 0) {
            throw new IllegalArgumentException("The argument " + x + " is negative");
        }
        if (x < 4096) {
            return this.writeInt(GAMMA[x], GAMMA[x] >>> 26);
        }
        int msb = Fast.mostSignificantBit(++x);
        int l = this.writeUnary(msb);
        return l + (msb != 0 ? this.writeInt(x, msb) : 0);
    }

    public int writeLongGamma(long x) throws IOException {
        if (x < 0L) {
            throw new IllegalArgumentException("The argument " + x + " is negative");
        }
        if (x < 4096L) {
            return this.writeInt(GAMMA[(int)x], GAMMA[(int)x] >>> 26);
        }
        int msb = Fast.mostSignificantBit(++x);
        int l = this.writeUnary(msb);
        return l + (msb != 0 ? this.writeLong(x, msb) : 0);
    }

    public int writeShiftedGamma(int x) throws IOException {
        if (x < 0) {
            throw new IllegalArgumentException("The argument " + x + " is negative");
        }
        if (x < 4096) {
            return this.writeInt(SHIFTED_GAMMA[x], SHIFTED_GAMMA[x] >>> 26);
        }
        int msb = Fast.mostSignificantBit(x);
        int l = this.writeUnary(msb + 1);
        return l + (msb > 0 ? this.writeInt(x, msb) : 0);
    }

    public int writeLongShiftedGamma(long x) throws IOException {
        if (x < 0L) {
            throw new IllegalArgumentException("The argument " + x + " is negative");
        }
        if (x < 4096L) {
            return this.writeInt(SHIFTED_GAMMA[(int)x], SHIFTED_GAMMA[(int)x] >>> 26);
        }
        int msb = Fast.mostSignificantBit(x);
        int l = this.writeUnary(msb + 1);
        return l + (msb > 0 ? this.writeLong(x, msb) : 0);
    }

    public int writeDelta(int x) throws IOException {
        if (x < 0) {
            throw new IllegalArgumentException("The argument " + x + " is negative");
        }
        if (x < 4096) {
            return this.writeInt(DELTA[x], DELTA[x] >>> 26);
        }
        int msb = Fast.mostSignificantBit(++x);
        int l = this.writeGamma(msb);
        return l + (msb != 0 ? this.writeInt(x, msb) : 0);
    }

    public int writeLongDelta(long x) throws IOException {
        if (x < 0L) {
            throw new IllegalArgumentException("The argument " + x + " is negative");
        }
        if (x < 4096L) {
            return this.writeInt(DELTA[(int)x], DELTA[(int)x] >>> 26);
        }
        int msb = Fast.mostSignificantBit(++x);
        int l = this.writeGamma(msb);
        return l + (msb != 0 ? this.writeLong(x, msb) : 0);
    }

    public int writeMinimalBinary(int x, int b) throws IOException {
        if (b < 1) {
            throw new IllegalArgumentException("The bound " + b + " is not positive");
        }
        return this.writeMinimalBinary(x, b, Fast.mostSignificantBit(b));
    }

    public int writeMinimalBinary(int x, int b, int log2b) throws IOException {
        if (x < 0) {
            throw new IllegalArgumentException("The argument " + x + " is negative");
        }
        if (b < 1) {
            throw new IllegalArgumentException("The bound " + b + " is not positive");
        }
        if (x >= b) {
            throw new IllegalArgumentException("The argument " + x + " exceeds the bound " + b);
        }
        int m = (1 << log2b + 1) - b;
        if (x < m) {
            return this.writeInt(x, log2b);
        }
        return this.writeInt(m + x, log2b + 1);
    }

    public int writeLongMinimalBinary(long x, long b) throws IOException {
        if (b < 1L) {
            throw new IllegalArgumentException("The bound " + b + " is not positive");
        }
        return this.writeLongMinimalBinary(x, b, Fast.mostSignificantBit(b));
    }

    public int writeLongMinimalBinary(long x, long b, int log2b) throws IOException {
        if (x < 0L) {
            throw new IllegalArgumentException("The argument " + x + " is negative");
        }
        if (b < 1L) {
            throw new IllegalArgumentException("The bound " + b + " is not positive");
        }
        if (x >= b) {
            throw new IllegalArgumentException("The argument " + x + " exceeds the bound " + b);
        }
        long m = (long)(1 << log2b + 1) - b;
        if (x < m) {
            return this.writeLong(x, log2b);
        }
        return this.writeLong(m + x, log2b + 1);
    }

    public int writeGolomb(int x, int b) throws IOException {
        return this.writeGolomb(x, b, Fast.mostSignificantBit(b));
    }

    public int writeGolomb(int x, int b, int log2b) throws IOException {
        if (x < 0) {
            throw new IllegalArgumentException("The argument " + x + " is negative");
        }
        if (b < 0) {
            throw new IllegalArgumentException("The modulus " + b + " is negative");
        }
        if (b == 0) {
            if (x != 0) {
                throw new IllegalArgumentException("The modulus is 0, but the argument is " + x);
            }
            return 0;
        }
        int l = this.writeUnary(x / b);
        return l + this.writeMinimalBinary(x % b, b, log2b);
    }

    public long writeLongGolomb(long x, long b) throws IOException {
        return this.writeLongGolomb(x, b, Fast.mostSignificantBit(b));
    }

    public long writeLongGolomb(long x, long b, int log2b) throws IOException {
        if (x < 0L) {
            throw new IllegalArgumentException("The argument " + x + " is negative");
        }
        if (b < 1L) {
            throw new IllegalArgumentException("The modulus " + b + " is not positive");
        }
        if (b == 0L) {
            if (x != 0L) {
                throw new IllegalArgumentException("The modulus is 0, but the argument is " + x);
            }
            return 0L;
        }
        long l = this.writeLongUnary(x / b);
        return l + (long)this.writeLongMinimalBinary(x % b, b, log2b);
    }

    public int writeSkewedGolomb(int x, int b) throws IOException {
        if (x < 0) {
            throw new IllegalArgumentException("The argument " + x + " is negative");
        }
        if (b < 0) {
            throw new IllegalArgumentException("The modulus " + b + " is negative");
        }
        if (b == 0) {
            if (x != 0) {
                throw new IllegalArgumentException("The modulus is 0, but the argument is " + x);
            }
            return 0;
        }
        int i = Fast.mostSignificantBit(x / b + 1);
        int l = this.writeUnary(i);
        int M = ((1 << i + 1) - 1) * b;
        int m = M / (2 * b) * b;
        return l + this.writeMinimalBinary(x - m, M - m);
    }

    public long writeLongSkewedGolomb(long x, long b) throws IOException {
        if (x < 0L) {
            throw new IllegalArgumentException("The argument " + x + " is negative");
        }
        if (b < 0L) {
            throw new IllegalArgumentException("The modulus " + b + " is negative");
        }
        if (b == 0L) {
            if (x != 0L) {
                throw new IllegalArgumentException("The modulus is 0, but the argument is " + x);
            }
            return 0L;
        }
        long i = Fast.mostSignificantBit(x / b + 1L);
        long l = this.writeLongUnary(i);
        long M = (long)((1 << (int)(i + 1L)) - 1) * b;
        long m = M / (2L * b) * b;
        return l + (long)this.writeLongMinimalBinary(x - m, M - m);
    }

    public int writeZeta(int x, int k) throws IOException {
        if (x < 0) {
            throw new IllegalArgumentException("The argument " + x + " is negative");
        }
        if (k < 1) {
            throw new IllegalArgumentException("The shrinking factor " + k + " is not positive");
        }
        if (k == 3 && x < 4096) {
            return this.writeInt(ZETA_3[x], ZETA_3[x] >>> 26);
        }
        int msb = Fast.mostSignificantBit(++x);
        int h = msb / k;
        int l = this.writeUnary(h);
        int left = 1 << h * k;
        return l + (x - left < left ? this.writeInt(x - left, h * k + k - 1) : this.writeInt(x, h * k + k));
    }

    public int writeLongZeta(long x, int k) throws IOException {
        if (x < 0L) {
            throw new IllegalArgumentException("The argument " + x + " is negative");
        }
        if (k < 1) {
            throw new IllegalArgumentException("The shrinking factor " + k + " is not positive");
        }
        if (k == 3 && x < 4096L) {
            return this.writeInt(ZETA_3[(int)x], ZETA_3[(int)x] >>> 26);
        }
        int msb = Fast.mostSignificantBit(++x);
        int h = msb / k;
        int l = this.writeUnary(h);
        long left = 1 << h * k;
        return l + (x - left < left ? this.writeLong(x - left, h * k + k - 1) : this.writeLong(x, h * k + k));
    }

    public int writeNibble(int x) throws IOException {
        if (x < 0) {
            throw new IllegalArgumentException("The argument " + x + " is negative");
        }
        if (x == 0) {
            return this.writeInt(8, 4);
        }
        int msb = Fast.mostSignificantBit(x);
        int h = msb / 3;
        do {
            this.writeBit(h == 0);
            this.writeInt(x >> h * 3, 3);
        } while (h-- != 0);
        return msb / 3 + 1 << 2;
    }

    public int writeLongNibble(long x) throws IOException {
        if (x < 0L) {
            throw new IllegalArgumentException("The argument " + x + " is negative");
        }
        if (x == 0L) {
            return this.writeInt(8, 4);
        }
        int msb = Fast.mostSignificantBit(x);
        int h = msb / 3;
        do {
            this.writeBit(h == 0);
            this.writeInt((int)(x >> h * 3), 3);
        } while (h-- != 0);
        return msb / 3 + 1 << 2;
    }

    static {
        try {
            InputBitStream.fillArrayFromResource("gamma.out.12", GAMMA);
            InputBitStream.fillArrayFromResource("delta.out.12", DELTA);
            InputBitStream.fillArrayFromResource("zeta3.out.12", ZETA_3);
            InputBitStream.fillArrayFromResource("shiftedgamma.out.12", SHIFTED_GAMMA);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

