#!/bin/ksh ~/.mgltools/pythonsh
########################################################################
#
#    Vision Network - Python source code - file generated by vision
#    Thursday 30 July 2009 16:00:15 
#    
#       The Scripps Research Institute (TSRI)
#       Molecular Graphics Lab
#       La Jolla, CA 92037, USA
#
# Copyright: Daniel Stoffler, Michel Sanner and TSRI
#   
# revision: Guillaume Vareille
#  
#########################################################################
#
# $Header: /opt/cvs/python/packages/share1.5/Vision/doc/Tutorial/cartoon/cartoon2c_net.py,v 1.2 2009/07/31 00:54:52 vareille Exp $
#
# $Id: cartoon2c_net.py,v 1.2 2009/07/31 00:54:52 vareille Exp $
#


if __name__=='__main__':
    from sys import argv
    if '--help' in argv or '-h' in argv or '-w' in argv: # run without Vision
        withoutVision = True
        from Vision.VPE import NoGuiExec
        ed = NoGuiExec()
        from NetworkEditor.net import Network
        import os
        masterNet = Network("process-"+str(os.getpid()))
        ed.addNetwork(masterNet)
    else: # run as a stand alone application while vision is hidden
        withoutVision = False
        from Vision import launchVisionToRunNetworkAsApplication, mainLoopVisionToRunNetworkAsApplication
	if '-noSplash' in argv:
	    splash = False
	else:
	    splash = True
        masterNet = launchVisionToRunNetworkAsApplication(splash=splash)
        import os
        masterNet.filename = os.path.abspath(__file__)
from traceback import print_exc
masterNet.createUserPanel('MyApp' ,width=191, height=215)
## loading libraries ##
from Vision.PILNodes import imagelib
from Vision.StandardNodes import stdlib
try:
    masterNet
except (NameError, AttributeError): # we run the network outside Vision
    from NetworkEditor.net import Network
    masterNet = Network()

masterNet.getEditor().addLibraryInstance(imagelib,"Vision.PILNodes", "imagelib")

masterNet.getEditor().addLibraryInstance(stdlib,"Vision.StandardNodes", "stdlib")

try:
    ## saving node Read Image ##
    from Vision.PILNodes import ReadImage
    Read_Image_1 = ReadImage(constrkw={}, name='Read Image', library=imagelib)
    masterNet.addNode(Read_Image_1,140,192)
    apply(Read_Image_1.inputPortByName['filename'].configure, (), {'datatype': 'string', 'originalDatatype': 'str'})
    Read_Image_1.inputPortByName['filename'].rebindWidget()
    Read_Image_1.inputPortByName['filename'].widget.set(r"", run=False)
    Read_Image_1.inputPortByName['filename'].unbindWidget()
    apply(Read_Image_1.configure, (), {'paramPanelImmediate': 1})
except:
    print "WARNING: failed to restore ReadImage named Read Image in network masterNet"
    print_exc()
    Read_Image_1=None

try:
    ## saving node Scale ##
    from Vision.PILNodes import ResizeImage
    Scale_2 = ResizeImage(constrkw={}, name='Scale', library=imagelib)
    masterNet.addNode(Scale_2,140,242)
    apply(Scale_2.inputPortByName['scale'].widget.configure, (), {'master': 'MyApp', 'widgetPlacerCfg': {'rely': '0.1532', 'relx': '0.4974'}})
    Scale_2.inputPortByName['scale'].widget.set(0.322222222222, run=False)
    Scale_2.inputPortByName['filter'].widget.set(r"NEAREST", run=False)
    apply(Scale_2.configure, (), {'paramPanelImmediate': 1})
except:
    print "WARNING: failed to restore ResizeImage named Scale in network masterNet"
    print_exc()
    Scale_2=None

try:
    ## saving node Show Image ##
    from Vision.PILNodes import ShowImage
    Show_Image_3 = ShowImage(constrkw={}, name='Show Image', library=imagelib)
    masterNet.addNode(Show_Image_3,16,254)
    apply(Show_Image_3.configure, (), {'paramPanelImmediate': 1, 'expanded': False})
except:
    print "WARNING: failed to restore ShowImage named Show Image in network masterNet"
    print_exc()
    Show_Image_3=None

try:
    ## saving node ThumbWheelInt ##
    from Vision.StandardNodes import ThumbWheelIntNE
    ThumbWheelInt_4 = ThumbWheelIntNE(constrkw={}, name='ThumbWheelInt', library=stdlib)
    masterNet.addNode(ThumbWheelInt_4,113,124)
    apply(ThumbWheelInt_4.inputPortByName['thumbwheel'].widget.configure, (), {'min': 0, 'max': 100, 'master': 'MyApp', 'oneTurn': 30.0, 'widgetGridCfgMyApp': {'labelSide': 'top'}, 'widgetGridCfgnode': {'rowspan': 1, 'labelSide': 'top', 'column': 1, 'ipady': 0, 'ipadx': 0, 'columnspan': 1, 'pady': 0, 'padx': 0, 'row': 1}, 'labelCfg': {'text': 'max frame'}, 'widgetPlacerCfg': {'rely': '0.3427', 'relx': '0.5183'}})
    ThumbWheelInt_4.inputPortByName['thumbwheel'].widget.set(87, run=False)
    apply(ThumbWheelInt_4.configure, (), {'paramPanelImmediate': 1})
except:
    print "WARNING: failed to restore ThumbWheelIntNE named ThumbWheelInt in network masterNet"
    print_exc()
    ThumbWheelInt_4=None

try:
    ## saving node DialInt ##
    from Vision.StandardNodes import DialIntNE
    DialInt_5 = DialIntNE(constrkw={}, name='DialInt', library=stdlib)
    masterNet.addNode(DialInt_5,719,121)
    DialInt_5.inputPortByName['dial'].widget.set(0, run=False)
except:
    print "WARNING: failed to restore DialIntNE named DialInt in network masterNet"
    print_exc()
    DialInt_5=None

try:
    ## saving node Index ##
    from Vision.StandardNodes import Index
    Index_6 = Index(constrkw={}, name='Index', library=stdlib)
    masterNet.addNode(Index_6,12,191)
    Index_6.inputPortByName['index'].rebindWidget()
    Index_6.inputPortByName['index'].widget.set(0, run=False)
    Index_6.inputPortByName['index'].unbindWidget()
    apply(Index_6.configure, (), {'paramPanelImmediate': 1})
except:
    print "WARNING: failed to restore Index named Index in network masterNet"
    print_exc()
    Index_6=None

try:
    ## saving node indexMax ##
    from NetworkEditor.macros import MacroNode
    indexMax_7 = MacroNode(name='indexMax')
    masterNet.addNode(indexMax_7, 130, 68)
    from Vision.StandardNodes import Len
    len_10 = Len(constrkw={}, name='len', library=stdlib)
    indexMax_7.macroNetwork.addNode(len_10,198,86)
    apply(len_10.inputPortByName['in1'].configure, (), {'datatype': 'list', 'originalDatatype': 'None'})
    apply(len_10.configure, (), {'paramPanelImmediate': 1, 'expanded': False})
    from Vision.StandardNodes import Operator2
    sub_11 = Operator2(constrkw={}, name='sub', library=stdlib)
    indexMax_7.macroNetwork.addNode(sub_11,202,160)
    apply(sub_11.inputPortByName['data1'].configure, (), {'datatype': 'int', 'originalDatatype': 'None'})
    sub_11.inputPortByName['operation'].widget.set(r"sub", run=False)
    sub_11.inputPortByName['applyToElements'].widget.set(0, run=False)
    apply(sub_11.configure, (), {'paramPanelImmediate': 1})
    from Vision.StandardNodes import Eval
    _1_12 = Eval(constrkw={}, name='-1', library=stdlib)
    indexMax_7.macroNetwork.addNode(_1_12,259,98)
    _1_12.inputPortByName['command'].widget.set(r"1", run=False)
    _1_12.inputPortByName['importString'].widget.set(r"", run=False)
    apply(_1_12.configure, (), {'paramPanelImmediate': 1})

    ## saving connections for network indexMax ##
    indexMax_7.macroNetwork.freeze()
    if len_10 is not None and sub_11 is not None:
        try:
            indexMax_7.macroNetwork.connectNodes(
                len_10, sub_11, "length", "data1", blocking=True
                , splitratio=[0.27871352596671012, 0.73994958649700804])
        except:
            print "WARNING: failed to restore connection between len_10 and sub_11 in network indexMax_7.macroNetwork"
    if _1_12 is not None and sub_11 is not None:
        try:
            indexMax_7.macroNetwork.connectNodes(
                _1_12, sub_11, "result", "data2", blocking=True
                , splitratio=[1.0, 0.6875])
        except:
            print "WARNING: failed to restore connection between _1_12 and sub_11 in network indexMax_7.macroNetwork"
    input_Ports_8 = indexMax_7.macroNetwork.ipNode
    if input_Ports_8 is not None and len_10 is not None:
        try:
            indexMax_7.macroNetwork.connectNodes(
                input_Ports_8, len_10, "new", "in1", blocking=True
                , splitratio=[0.61722487530220482, 0.26419414111833783])
        except:
            print "WARNING: failed to restore connection between input_Ports_8 and len_10 in network indexMax_7.macroNetwork"
    output_Ports_9 = indexMax_7.macroNetwork.opNode
    if sub_11 is not None and output_Ports_9 is not None:
        try:
            indexMax_7.macroNetwork.connectNodes(
                sub_11, output_Ports_9, "result", "new", blocking=True
                , splitratio=[0.56661316760805525, 0.53322781063576086])
        except:
            print "WARNING: failed to restore connection between sub_11 and output_Ports_9 in network indexMax_7.macroNetwork"
    indexMax_7.macroNetwork.unfreeze()

    ## modifying MacroInputNode dynamic ports
    input_Ports_8.outputPorts[1].configure(name='len_in1')

    ## modifying MacroOutputNode dynamic ports
    output_Ports_9.inputPorts[1].configure(singleConnection='auto')
    output_Ports_9.inputPorts[1].configure(name='sub_result')
    indexMax_7.inputPorts[0].configure(name='len_in1')
    indexMax_7.inputPorts[0].configure(datatype='list')
    ## configure MacroNode input ports
    indexMax_7.outputPorts[0].configure(name='sub_result')
    indexMax_7.outputPorts[0].configure(datatype='None')
    ## configure MacroNode output ports
    indexMax_7.shrink()
    apply(indexMax_7.configure, (), {'paramPanelImmediate': 1, 'expanded': False})
except:
    print "WARNING: failed to restore MacroNode named indexMax in network masterNet"
    print_exc()
    indexMax_7=None

try:
    ## saving node Entry ##
    from Vision.StandardNodes import Filelist
    Entry_13 = Filelist(constrkw={}, name='Entry', library=stdlib)
    masterNet.addNode(Entry_13,12,9)
    apply(Entry_13.inputPortByName['directory'].widget.configure, (), {'master': 'MyApp', 'widgetPlacerCfg': {'rely': '0.6791', 'relx': '0.5707'}})
    Entry_13.inputPortByName['directory'].widget.set(r"cartoonMovie", run=False)
    apply(Entry_13.inputPortByName['match_str'].widget.configure, (), {'master': 'MyApp', 'widgetPlacerCfg': {'rely': '0.5256', 'relx': '0.644'}})
    Entry_13.inputPortByName['match_str'].widget.set(r"*.png", run=False)
    apply(Entry_13.configure, (), {'paramPanelImmediate': 1})
except:
    print "WARNING: failed to restore Filelist named Entry in network masterNet"
    print_exc()
    Entry_13=None

#masterNet.run()
masterNet.freeze()

## saving connections for network cartoon2c ##
if Read_Image_1 is not None and Scale_2 is not None:
    try:
        masterNet.connectNodes(
            Read_Image_1, Scale_2, "image", "image", blocking=True
            , splitratio=[0.62083758285351998, 0.36846929420389607])
    except:
        print "WARNING: failed to restore connection between Read_Image_1 and Scale_2 in network masterNet"
if Scale_2 is not None and Show_Image_3 is not None:
    try:
        masterNet.connectNodes(
            Scale_2, Show_Image_3, "scaledImage", "image", blocking=True
            , splitratio=[0.41696011532164196, -1.1538461538461537])
    except:
        print "WARNING: failed to restore connection between Scale_2 and Show_Image_3 in network masterNet"
if ThumbWheelInt_4 is not None and Index_6 is not None:
    try:
        masterNet.connectNodes(
            ThumbWheelInt_4, Index_6, "value", "index", blocking=True
            , splitratio=[0.31598988412154444, 0.24748970175823765])
    except:
        print "WARNING: failed to restore connection between ThumbWheelInt_4 and Index_6 in network masterNet"
if Index_6 is not None and Read_Image_1 is not None:
    try:
        masterNet.connectNodes(
            Index_6, Read_Image_1, "data", "filename", blocking=True
            , splitratio=[0.64329376207199618, 0.38157871299236096])
    except:
        print "WARNING: failed to restore connection between Index_6 and Read_Image_1 in network masterNet"
indexMax_7 = masterNet.nodes[6]
if indexMax_7 is not None and ThumbWheelInt_4 is not None:
    try:
        masterNet.connectNodes(
            indexMax_7, ThumbWheelInt_4, "sub_result", "maxi", blocking=True
            , splitratio=[0.36466914514189108, 0.54151729011151972])
    except:
        print "WARNING: failed to restore connection between indexMax_7 and ThumbWheelInt_4 in network masterNet"
if Entry_13 is not None and Index_6 is not None:
    try:
        masterNet.connectNodes(
            Entry_13, Index_6, "filelist", "data", blocking=True
            , splitratio=[0.60331216792587838, 0.48163376828711962])
    except:
        print "WARNING: failed to restore connection between Entry_13 and Index_6 in network masterNet"
if Entry_13 is not None and indexMax_7 is not None:
    try:
        masterNet.connectNodes(
            Entry_13, indexMax_7, "filelist", "len_in1", blocking=True
            , splitratio=[0.51507132542515577, 0.46459172066680099])
    except:
        print "WARNING: failed to restore connection between Entry_13 and indexMax_7 in network masterNet"
masterNet.runOnNewData.value = False

if __name__=='__main__':
    from sys import argv
    lNodePortValues = []
    if (len(argv) > 0) and argv[1].startswith('-'):
        lArgIndex = 2
    else:
        lArgIndex = 1
    while lArgIndex < len(argv) and argv[lArgIndex][-3:]!='.py':
        lNodePortValues.append(argv[lArgIndex])
        lArgIndex += 1
    masterNet.setNodePortValues(lNodePortValues)
    if '--help' in argv or '-h' in argv: # show help
        masterNet.helpForNetworkAsApplication()
    elif '-w' in argv: # run without Vision and exit
         # create communicator
        from NetworkEditor.net import Communicator
        masterNet.communicator = Communicator(masterNet)
        print 'Communicator listening on port:', masterNet.communicator.port

        import socket
        f = open(argv[0]+'.sock', 'w')
        f.write("%s %i"%(socket.gethostbyname(socket.gethostname()),
                         masterNet.communicator.port))
        f.close()

        # create communication socket
        import socket
        HOST = ''                 # Symbolic name meaning the local host
        PORT = 50010              # Arbitrary non-privileged port
        s = socket.socket(socket.AF_INET, socket.SOCK_STREAM)
        s.bind((HOST, PORT))
        s.listen(5)
        s.setblocking(0)
        masterNet.socket = s
        masterNet.socketConnections = []
        masterNet.HOST = HOST
        masterNet.PORT = PORT

        masterNet.run()

    else: # stand alone application while vision is hidden
        if '-e' in argv: # run and exit
            masterNet.run()
        elif '-r' in argv or len(masterNet.userPanels) == 0: # no user panel => run
            masterNet.run()
            mainLoopVisionToRunNetworkAsApplication(masterNet.editor)
        else: # user panel
            mainLoopVisionToRunNetworkAsApplication(masterNet.editor)

