/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.ide.launch;

import com.nvidia.common.util.CoreUtil;
import com.nvidia.viper.ide.Activator;
import com.nvidia.viper.ide.ViperIDEUtil;
import com.nvidia.viper.ide.launch.RemoteSystemSourceLocator;
import com.nvidia.viper.model.Executable;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.debug.internal.core.sourcelookup.CSourceLookupDirector;
import org.eclipse.cdt.dsf.gdb.launching.LaunchUtils;
import org.eclipse.cdt.launch.remote.IRemoteConnectionConfigurationConstants;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchDelegate;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.model.ILaunchConfigurationDelegate;
import org.eclipse.debug.core.model.ILaunchConfigurationDelegate2;
import org.eclipse.debug.core.sourcelookup.ISourceContainer;
import org.eclipse.debug.core.sourcelookup.containers.DefaultSourceContainer;

public abstract class LaunchConfigurationAdapter {
    private static final Map<ILaunchConfiguration, WeakReference<LaunchConfigurationAdapter>> adaptersCache = new WeakHashMap<ILaunchConfiguration, WeakReference<LaunchConfigurationAdapter>>();
    protected final ILaunchConfiguration lc;
    private CSourceLookupDirector locator;

    public static synchronized LaunchConfigurationAdapter getLaunchConfigurationAdapter(String launchConfigurationName, boolean remote) {
        if (!CoreUtil.isNullOrEmpty((String)launchConfigurationName)) {
            String type = remote ? "org.eclipse.cdt.launch.remoteApplicationLaunchType" : "org.eclipse.cdt.launch.applicationLaunchType";
            ILaunchConfiguration lc = LaunchConfigurationAdapter.getLaunchConfiguration(type, launchConfigurationName);
            return lc != null ? LaunchConfigurationAdapter.getAdapter(lc) : null;
        }
        return null;
    }

    private static LaunchConfigurationAdapter getAdapter(ILaunchConfiguration configuration) {
        LaunchConfigurationAdapter adapter;
        WeakReference<LaunchConfigurationAdapter> reference = adaptersCache.get(configuration);
        if (reference != null && (adapter = (LaunchConfigurationAdapter)reference.get()) != null) {
            return adapter;
        }
        try {
            adapter = LaunchConfigurationAdapter.createAdapter(configuration);
            if (adapter != null) {
                adaptersCache.put(configuration, new WeakReference<LaunchConfigurationAdapter>(adapter));
            }
            return adapter;
        }
        catch (CoreException e) {
            Activator.log(e);
            return null;
        }
    }

    private static String checkAndGet(ILaunchConfiguration configuration, String attr, String label) throws CoreException {
        if (configuration.hasAttribute(attr)) {
            return configuration.getAttribute(attr, null);
        }
        throw new CoreException((IStatus)new Status(4, "com.nvidia.viper.ide", String.format("%s is not defined", label)));
    }

    private static LaunchConfigurationAdapter createAdapter(ILaunchConfiguration configuration) throws CoreException {
        String identifier = configuration.getType().getIdentifier();
        if ("org.eclipse.cdt.launch.applicationLaunchType".equals(identifier)) {
            return new LocalLaunchAdapter(configuration);
        }
        if (ViperIDEUtil.isRemoteLaunch(configuration)) {
            return new RemoteLaunchAdapter(configuration);
        }
        return null;
    }

    public static String getDefaultSessionFile(String name) {
        return Activator.getDefault().getStateLocation().append(name).addFileExtension("nvvp").toOSString();
    }

    private static ILaunchConfiguration getLaunchConfiguration(String launchConfigurationType, String name) {
        ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfigurationType type = launchManager.getLaunchConfigurationType(launchConfigurationType);
        if (type != null) {
            try {
                ILaunchConfiguration[] launchConfigurations;
                ILaunchConfiguration[] iLaunchConfigurationArray = launchConfigurations = launchManager.getLaunchConfigurations(type);
                int n = launchConfigurations.length;
                int n2 = 0;
                while (n2 < n) {
                    ILaunchConfiguration configuration = iLaunchConfigurationArray[n2];
                    if (configuration.getName().equals(name)) {
                        return configuration;
                    }
                    ++n2;
                }
            }
            catch (CoreException e) {
                Activator.log(e);
            }
        }
        return null;
    }

    protected LaunchConfigurationAdapter(ILaunchConfiguration lc) {
        this.lc = lc;
    }

    public Executable createExecutable() throws CoreException {
        Executable executable = new Executable();
        executable.setFilename(this.getExecutablePath());
        executable.setWorkingDir(this.getWorkingDir());
        executable.setConnectionName(this.getConnectionName());
        executable.setArgs(this.lc.getAttribute("org.eclipse.cdt.launch.PROGRAM_ARGUMENTS", ""));
        this.fillEnvironment(executable);
        executable.setProfileOnStart(this.lc.getAttribute("nvvp.startProfiling", true));
        executable.setConcurrentKernel(this.lc.getAttribute("nvvp.concurrentProfiling", true));
        executable.setApiTrace(this.lc.getAttribute("nvvp.apiTraceProfiling", true));
        executable.setEnvironmentProfiling(this.lc.getAttribute("nvvp.environmentProfiling", false));
        executable.setUvmProfiling(this.lc.getAttribute("nvvp.uvmProfiling", true));
        executable.setApplicationReplay(this.lc.getAttribute("nvvp.appReplay", false));
        executable.setTimeOut(this.lc.getAttribute("nvvp.timeout", 0));
        executable.setMultiProcessProfile(this.lc.getAttribute("nvvp.multiProcess", 0));
        executable.setLaunchConfigurationName(this.lc.getName());
        executable.setOpenAccProfiling(this.lc.getAttribute("nvvp.openaccProfiling", true));
        executable.setCDPBuffersize(this.lc.getAttribute("nvvp.devicebuffersize", executable.getDeviceBuffersize()));
        executable.setCDPBuffersize(this.lc.getAttribute("nvvp.cdpbuffersize", executable.getCDPBuffersize()));
        return executable;
    }

    private void fillEnvironment(Executable executable) throws CoreException {
        ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
        String[] environment = launchManager.getEnvironment(this.lc);
        if (environment != null) {
            String[] stringArray = environment;
            int n = environment.length;
            int n2 = 0;
            while (n2 < n) {
                String string = stringArray[n2];
                int equals = string.indexOf("=");
                if (equals >= 0) {
                    executable.addEnvVar(string.substring(0, equals), string.substring(equals + 1));
                } else {
                    executable.addEnvVar(string, "");
                }
                ++n2;
            }
        }
    }

    protected abstract String getConnectionName() throws CoreException;

    private String getDefaultSessionFile() {
        return LaunchConfigurationAdapter.getDefaultSessionFile(this.lc.getName());
    }

    protected abstract String getExecutablePath() throws CoreException;

    private ILaunchConfigurationDelegate2 getLaunchConfigurationDelegate(ILaunchConfiguration lc) {
        ILaunchConfigurationDelegate lcDelegate;
        try {
            ILaunchDelegate[] delegates;
            ILaunchDelegate delegate = lc.getPreferredDelegate(Collections.singleton("profile"));
            if (delegate == null && (delegates = lc.getType().getDelegates(Collections.singleton("profile"))) != null && delegates.length > 0) {
                delegate = delegates[0];
            }
            if (!((lcDelegate = delegate.getDelegate()) instanceof ILaunchConfigurationDelegate2)) {
                return null;
            }
        }
        catch (CoreException e) {
            Activator.log(e);
            return null;
        }
        return (ILaunchConfigurationDelegate2)lcDelegate;
    }

    public String getSessionFileName() throws CoreException {
        return this.lc.getAttribute("nvvp.filename", this.getDefaultSessionFile());
    }

    public synchronized CSourceLookupDirector getSourceLocator() throws CoreException {
        if (this.locator == null) {
            this.locator = new CSourceLookupDirector(){

                public void setSourceContainers(ISourceContainer[] containers) {
                    if (containers != null && containers.length == 1 && containers[0] instanceof DefaultSourceContainer) {
                        super.setSourceContainers((ISourceContainer[])CoreUtil.append((Object[])containers, (Object[])new RemoteSystemSourceLocator[]{new RemoteSystemSourceLocator()}));
                    }
                }
            };
            String memento = this.lc.getAttribute(ILaunchConfiguration.ATTR_SOURCE_LOCATOR_MEMENTO, null);
            if (memento == null) {
                this.locator.initializeDefaults(this.lc);
            } else {
                this.locator.initializeFromMemento(memento, this.lc);
            }
        }
        return this.locator;
    }

    protected String getWorkingDir() throws CoreException {
        return this.lc.getAttribute("org.eclipse.cdt.launch.WORKING_DIRECTORY", null);
    }

    public final boolean prepareForLaunch() throws CoreException {
        ILaunchConfigurationDelegate2 lcDelegate = this.getLaunchConfigurationDelegate(this.lc);
        lcDelegate.buildForLaunch(this.lc, "profile", (IProgressMonitor)new NullProgressMonitor());
        return lcDelegate.finalLaunchCheck(this.lc, "profile", (IProgressMonitor)new NullProgressMonitor());
    }

    public boolean readyToRun() {
        return this.lc != null && this.getLaunchConfigurationDelegate(this.lc) != null;
    }

    private static final class LocalLaunchAdapter
    extends LaunchConfigurationAdapter {
        public LocalLaunchAdapter(ILaunchConfiguration lc) {
            super(lc);
        }

        @Override
        public String getConnectionName() {
            return null;
        }

        @Override
        public String getExecutablePath() throws CoreException {
            String exe = LaunchConfigurationAdapter.checkAndGet(this.lc, "org.eclipse.cdt.launch.PROGRAM_NAME", "Executable file name");
            String resolvedExe = VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(exe);
            Path path = new Path(resolvedExe);
            ICProject project = LaunchUtils.getCProject((ILaunchConfiguration)this.lc);
            if (project != null && !path.isAbsolute()) {
                IFile file = project.getProject().getFile((IPath)path);
                if (file.isAccessible()) {
                    return file.getLocation().toOSString();
                }
                throw new CoreException((IStatus)new Status(4, "com.nvidia.viper.ide", String.format("Executable file %s was not found in project %s", resolvedExe, project.getProject().getName())));
            }
            return resolvedExe;
        }

        @Override
        public String getWorkingDir() throws CoreException {
            if (this.lc.hasAttribute("org.eclipse.cdt.launch.WORKING_DIRECTORY")) {
                return super.getWorkingDir();
            }
            ICProject project = LaunchUtils.getCProject((ILaunchConfiguration)this.lc);
            if (project != null) {
                return project.getProject().getLocation().toOSString();
            }
            return null;
        }
    }

    private static final class RemoteLaunchAdapter
    extends LaunchConfigurationAdapter {
        public RemoteLaunchAdapter(ILaunchConfiguration lc) {
            super(lc);
        }

        @Override
        public String getConnectionName() throws CoreException {
            return this.lc.getAttribute(IRemoteConnectionConfigurationConstants.ATTR_REMOTE_CONNECTION, null);
        }

        @Override
        public String getExecutablePath() throws CoreException {
            return LaunchConfigurationAdapter.checkAndGet(this.lc, IRemoteConnectionConfigurationConstants.ATTR_REMOTE_PATH, "Executable file name");
        }
    }
}

