/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.ps;

import java.awt.geom.AffineTransform;
import java.io.IOException;
import java.io.OutputStream;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Stack;
import org.apache.fop.render.ps.PSState;

public class PSGenerator {
    public static final AtendIndicator ATEND = new AtendIndicator(){};
    private OutputStream out;
    private boolean commentsEnabled = true;
    private Stack graphicsStateStack = new Stack();
    private PSState currentState;
    private DecimalFormat df3 = new DecimalFormat("0.000", new DecimalFormatSymbols(Locale.US));
    private DecimalFormat df1 = new DecimalFormat("0.#", new DecimalFormatSymbols(Locale.US));
    private DecimalFormat df5 = new DecimalFormat("0.#####", new DecimalFormatSymbols(Locale.US));
    private StringBuffer tempBuffer = new StringBuffer(256);

    public PSGenerator(OutputStream out) {
        this.out = out;
        this.currentState = new PSState();
        this.graphicsStateStack.push(this.currentState);
    }

    public OutputStream getOutputStream() {
        return this.out;
    }

    public int getPSLevel() {
        return 3;
    }

    public final void newLine() throws IOException {
        this.out.write(10);
    }

    public String formatDouble(double value) {
        return this.df1.format(value);
    }

    public String formatDouble5(double value) {
        return this.df5.format(value);
    }

    public void write(String cmd) throws IOException {
        this.out.write(cmd.getBytes("US-ASCII"));
    }

    public void writeln(String cmd) throws IOException {
        this.write(cmd);
        this.newLine();
    }

    public void commentln(String comment) throws IOException {
        if (this.commentsEnabled) {
            this.writeln(comment);
        }
    }

    public void writeByteArr(byte[] cmd) throws IOException {
        this.out.write(cmd);
        this.newLine();
    }

    public void flush() throws IOException {
        this.out.flush();
    }

    public static final void escapeChar(char c, StringBuffer target) {
        if (c > '\u007f') {
            target.append("\\");
            target.append(Integer.toOctalString(c));
        } else {
            switch (c) {
                case '\n': {
                    target.append("\\n");
                    break;
                }
                case '\r': {
                    target.append("\\r");
                    break;
                }
                case '\t': {
                    target.append("\\t");
                    break;
                }
                case '\b': {
                    target.append("\\b");
                    break;
                }
                case '\f': {
                    target.append("\\f");
                    break;
                }
                case '\\': {
                    target.append("\\\\");
                    break;
                }
                case '(': {
                    target.append("\\(");
                    break;
                }
                case ')': {
                    target.append("\\)");
                    break;
                }
                default: {
                    target.append(c);
                }
            }
        }
    }

    public static final String convertStringToDSC(String text) {
        return PSGenerator.convertStringToDSC(text, false);
    }

    public static final String convertStringToDSC(String text, boolean forceParentheses) {
        if (text == null || text.length() == 0) {
            return "()";
        }
        int initialSize = text.length();
        initialSize += initialSize / 2;
        StringBuffer sb = new StringBuffer(initialSize);
        if (Long.getLong(text) != null || text.indexOf(" ") >= 0 || forceParentheses) {
            sb.append("(");
            for (int i = 0; i < text.length(); ++i) {
                char c = text.charAt(i);
                PSGenerator.escapeChar(c, sb);
            }
            sb.append(")");
            return sb.toString();
        }
        return text;
    }

    public void writeDSCComment(String name) throws IOException {
        this.writeln("%%" + name);
    }

    public void writeDSCComment(String name, Object param) throws IOException {
        this.writeDSCComment(name, new Object[]{param});
    }

    public void writeDSCComment(String name, Object[] params) throws IOException {
        this.tempBuffer.setLength(0);
        this.tempBuffer.append("%%");
        this.tempBuffer.append(name);
        if (params != null && params.length > 0) {
            this.tempBuffer.append(": ");
            for (int i = 0; i < params.length; ++i) {
                if (i > 0) {
                    this.tempBuffer.append(" ");
                }
                if (params[i] instanceof String) {
                    this.tempBuffer.append(PSGenerator.convertStringToDSC((String)params[i]));
                    continue;
                }
                if (params[i] instanceof AtendIndicator) {
                    this.tempBuffer.append("(atend)");
                    continue;
                }
                if (params[i] instanceof Double) {
                    this.tempBuffer.append(this.df3.format(params[i]));
                    continue;
                }
                if (params[i] instanceof Number) {
                    this.tempBuffer.append(params[i].toString());
                    continue;
                }
                if (params[i] instanceof Date) {
                    SimpleDateFormat datef = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
                    this.tempBuffer.append(PSGenerator.convertStringToDSC(datef.format((Date)params[i])));
                    continue;
                }
                throw new IllegalArgumentException("Unsupported parameter type: " + params[i].getClass().getName());
            }
        }
        this.writeln(this.tempBuffer.toString());
    }

    public void saveGraphicsState() throws IOException {
        this.writeln("gsave");
        PSState state = (PSState)this.currentState.clone();
        this.graphicsStateStack.push(this.currentState);
        this.currentState = state;
    }

    public void restoreGraphicsState() throws IOException {
        this.writeln("grestore");
        this.currentState = (PSState)this.graphicsStateStack.pop();
    }

    public void concatMatrix(double a, double b, double c, double d, double e, double f) throws IOException {
        this.writeln("[" + this.formatDouble5(a) + " " + this.formatDouble5(b) + " " + this.formatDouble5(c) + " " + this.formatDouble5(d) + " " + this.formatDouble5(e) + " " + this.formatDouble5(f) + "] concat");
    }

    public void concatMatrix(double[] matrix) throws IOException {
        this.concatMatrix(matrix[0], matrix[1], matrix[2], matrix[3], matrix[4], matrix[5]);
    }

    public void concatMatrix(AffineTransform at) throws IOException {
        double[] matrix = new double[6];
        at.getMatrix(matrix);
        this.concatMatrix(matrix);
    }

    public void defineRect(double x, double y, double w, double h) throws IOException {
        this.writeln(this.formatDouble(x) + " " + this.formatDouble(y) + " " + this.formatDouble(w) + " " + this.formatDouble(h) + " re");
    }

    public PSState getCurrentState() {
        return this.currentState;
    }

    private static interface AtendIndicator {
    }
}

