/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.core.cdi;

import org.eclipse.cdt.debug.core.cdi.CDIException;
import org.eclipse.cdt.debug.core.cdi.ICDIFunctionFinished;
import org.eclipse.cdt.debug.core.cdi.model.ICDIValue;
import org.eclipse.cdt.debug.core.cdi.model.type.ICDIType;
import org.eclipse.cdt.debug.mi.core.cdi.CdiResources;
import org.eclipse.cdt.debug.mi.core.cdi.EndSteppingRange;
import org.eclipse.cdt.debug.mi.core.cdi.Session;
import org.eclipse.cdt.debug.mi.core.cdi.SourceManager;
import org.eclipse.cdt.debug.mi.core.cdi.VariableManager;
import org.eclipse.cdt.debug.mi.core.cdi.model.LocalVariableDescriptor;
import org.eclipse.cdt.debug.mi.core.cdi.model.StackFrame;
import org.eclipse.cdt.debug.mi.core.cdi.model.Target;
import org.eclipse.cdt.debug.mi.core.cdi.model.Thread;
import org.eclipse.cdt.debug.mi.core.cdi.model.Variable;
import org.eclipse.cdt.debug.mi.core.event.MIFunctionFinishedEvent;

public class FunctionFinished
extends EndSteppingRange
implements ICDIFunctionFinished {
    MIFunctionFinishedEvent fMIEvent;

    public FunctionFinished(Session session, MIFunctionFinishedEvent event) {
        super(session);
        this.fMIEvent = event;
    }

    public ICDIType getReturnType() throws CDIException {
        Session session = (Session)this.getSession();
        Target target = session.getTarget(this.fMIEvent.getMISession());
        String rType = this.fMIEvent.getReturnType();
        if (rType == null || rType.length() == 0) {
            throw new CDIException(CdiResources.getString("cdi.VariableManager.Unknown_type"));
        }
        SourceManager srcMgr = session.getSourceManager();
        return srcMgr.getType(target, rType);
    }

    public ICDIValue getReturnValue() throws CDIException {
        Session session = (Session)this.getSession();
        Target target = session.getTarget(this.fMIEvent.getMISession());
        Thread thread = (Thread)target.getCurrentThread();
        StackFrame frame = thread.getCurrentStackFrame();
        String gdbVariable = this.fMIEvent.getGDBResultVar();
        if (gdbVariable == null || gdbVariable.length() == 0) {
            throw new CDIException(CdiResources.getString("cdi.VariableManager.Unknown_type"));
        }
        LocalVariableDescriptor varDesc = new LocalVariableDescriptor(target, thread, frame, gdbVariable, null, 0, 0);
        VariableManager varMgr = session.getVariableManager();
        Variable var = varMgr.createVariable(varDesc);
        return var.getValue();
    }
}

