/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.mi.service.command.events;

import org.eclipse.cdt.dsf.concurrent.Immutable;
import org.eclipse.cdt.dsf.debug.service.IProcesses;
import org.eclipse.cdt.dsf.mi.service.command.events.MIEvent;
import org.eclipse.cdt.dsf.mi.service.command.output.MIConst;
import org.eclipse.cdt.dsf.mi.service.command.output.MIResult;
import org.eclipse.cdt.dsf.mi.service.command.output.MIValue;

@Immutable
public class MIThreadGroupExitedEvent
extends MIEvent<IProcesses.IProcessDMContext> {
    private String fGroupId;
    private String fExitCode;

    @Deprecated
    public MIThreadGroupExitedEvent(IProcesses.IProcessDMContext ctx, int token, String groupId) {
        super(ctx, token, null);
        this.fGroupId = groupId;
        this.fExitCode = null;
    }

    public MIThreadGroupExitedEvent(IProcesses.IProcessDMContext ctx, int token, MIResult[] results) {
        super(ctx, token, results);
        this.parse();
    }

    public String getGroupId() {
        return this.fGroupId;
    }

    public String getExitCode() {
        return this.fExitCode;
    }

    private void parse() {
        MIResult[] results = this.getResults();
        if (results == null) {
            return;
        }
        int i = 0;
        while (i < results.length) {
            String var = results[i].getVariable();
            MIValue val = results[i].getMIValue();
            if (var.equals("id")) {
                if (val instanceof MIConst) {
                    this.fGroupId = ((MIConst)val).getString().trim();
                }
            } else if (var.equals("exit-code") && val instanceof MIConst) {
                this.fExitCode = ((MIConst)val).getString().trim();
            }
            ++i;
        }
    }
}

