/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.indexer;

import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import org.eclipse.cdt.core.index.IIndexFileLocation;
import org.eclipse.cdt.internal.core.dom.IIncludeFileResolutionHeuristics;
import org.eclipse.cdt.internal.core.pdom.ASTFilePathResolver;
import org.eclipse.cdt.internal.core.pdom.indexer.IndexerPreferences;
import org.eclipse.cdt.internal.core.resources.ResourceLookup;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;

public class ProjectIndexerIncludeResolutionHeuristics
implements IIncludeFileResolutionHeuristics {
    private static final String TRUE = String.valueOf(true);
    private IProject fProject;
    private IProject[] fProjects;
    private final ASTFilePathResolver fResolver;
    private final boolean fIgnoreCase;

    public ProjectIndexerIncludeResolutionHeuristics(IProject project, ASTFilePathResolver resolver) {
        this.fProject = project;
        this.fResolver = resolver;
        this.fIgnoreCase = resolver.isCaseInsensitiveFileSystem();
    }

    private boolean useIncludeHeuristics() {
        if (this.fProject == null) {
            return false;
        }
        String val = this.fProject.isOpen() ? IndexerPreferences.get(this.fProject, "useHeuristicIncludeResolution", TRUE) : null;
        return TRUE.equals(val);
    }

    @Override
    public String findInclusion(String include, String currentFile) {
        String rc = this.findInclusionAux(include, currentFile);
        if (rc != null) {
            return rc;
        }
        if (!"macosx".equals(Platform.getOS()) || !this.useIncludeHeuristics()) {
            return null;
        }
        return this.findMacFramework(include);
    }

    public String findInclusionAux(String include, String currentFile) {
        IFile[] files;
        IIndexFileLocation ifl = this.fResolver.resolveASTPath(currentFile);
        if (ifl == null || ifl.getFullPath() == null) {
            return null;
        }
        if (this.fProject == null) {
            return null;
        }
        if (this.fProjects == null) {
            if (this.useIncludeHeuristics()) {
                this.fProjects = this.getOpenReferencedProjects(this.fProject);
            }
            if (this.fProjects == null) {
                this.fProject = null;
                return null;
            }
        }
        if ((files = ResourceLookup.findFilesByName((IPath)new Path(include), this.fProjects, this.fIgnoreCase)).length == 0) {
            return null;
        }
        IPath bestLocation = this.selectBest(files, ifl.getFullPath().toCharArray()).getLocation();
        if (bestLocation == null) {
            return null;
        }
        return bestLocation.toString();
    }

    private String findMacFramework(String include) {
        if (include == null || include.indexOf(47) < 2) {
            return null;
        }
        String[] parts = include.split("/", 2);
        String includePath = String.format("/System/Library/Frameworks/%s.framework/Headers/%s", parts[0], parts[1]);
        return new File(includePath).isFile() ? includePath : null;
    }

    private IResource selectBest(IFile[] files, char[] currentFullPath) {
        IFile best = files[0];
        int bestScore = this.computeScore(best.getFullPath().toString().toCharArray(), currentFullPath);
        int i = 1;
        while (i < files.length) {
            IFile file = files[i];
            int score = this.computeScore(file.getFullPath().toString().toCharArray(), currentFullPath);
            if (score > bestScore) {
                bestScore = score;
                best = file;
            }
            ++i;
        }
        return best;
    }

    private int computeScore(char[] path1, char[] path2) {
        int limit = Math.min(path1.length, path2.length);
        int match = 0;
        int i = 0;
        while (i < limit) {
            if (path1[i] != path2[i]) break;
            if (path1[i] == '/') {
                match = i;
            }
            ++i;
        }
        return (match << 16) - path1.length;
    }

    private IProject[] getOpenReferencedProjects(IProject prj) {
        HashSet<IProject> result = new HashSet<IProject>();
        if (prj.isOpen()) {
            result.add(prj);
            ArrayList<IProject> projectsToSearch = new ArrayList<IProject>();
            projectsToSearch.add(prj);
            int i = 0;
            while (i < projectsToSearch.size()) {
                IProject project = (IProject)projectsToSearch.get(i);
                try {
                    IProject[] nextLevel;
                    IProject[] iProjectArray = nextLevel = project.getReferencedProjects();
                    int n = nextLevel.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IProject prjNextLevel = iProjectArray[n2];
                        if (prjNextLevel.isOpen() && result.add(prjNextLevel)) {
                            projectsToSearch.add(prjNextLevel);
                        }
                        ++n2;
                    }
                }
                catch (CoreException coreException) {}
                ++i;
            }
        }
        return result.toArray(new IProject[result.size()]);
    }
}

