/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.index;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.index.IIndex;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.parser.util.ArrayUtil;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.internal.core.CCoreInternals;
import org.eclipse.cdt.internal.core.index.CIndex;
import org.eclipse.cdt.internal.core.index.EmptyCIndex;
import org.eclipse.cdt.internal.core.index.IIndexFragment;
import org.eclipse.cdt.internal.core.index.IWritableIndex;
import org.eclipse.cdt.internal.core.index.IWritableIndexFragment;
import org.eclipse.cdt.internal.core.index.Messages;
import org.eclipse.cdt.internal.core.index.WritableCIndex;
import org.eclipse.cdt.internal.core.index.provider.IndexProviderManager;
import org.eclipse.cdt.internal.core.pdom.IPDOM;
import org.eclipse.cdt.internal.core.pdom.PDOMManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.osgi.util.NLS;

public class IndexFactory {
    private static final int ALL_FRAGMENT_OPTIONS = 2040;
    private PDOMManager fPDOMManager;

    public IndexFactory(PDOMManager manager) {
        this.fPDOMManager = manager;
    }

    public IIndex getIndex(ICProject[] projects, int options) throws CoreException {
        projects = ArrayUtil.removeNulls(ICProject.class, projects);
        boolean addDependencies = (options & 1) != 0;
        boolean addDependent = (options & 2) != 0;
        int fragmentUsage = options & 0x7F8;
        Collection<ICProject> indexProjects = this.getProjects(projects, addDependencies, addDependent, new HashSet<IProject>());
        LinkedHashMap<String, IIndexFragment> fragments = new LinkedHashMap<String, IIndexFragment>();
        for (ICProject cproject : indexProjects) {
            IPDOM pdom = this.fPDOMManager.getPDOM(cproject);
            if (pdom == null) continue;
            this.safeAddFragment(fragments, pdom);
            if (fragmentUsage == 0) continue;
            this.safeAddProvidedFragments(cproject, fragments, fragmentUsage);
        }
        if (fragments.isEmpty()) {
            return EmptyCIndex.INSTANCE;
        }
        Collection pdoms = ((HashMap)fragments).values();
        return new CIndex(pdoms.toArray(new IIndexFragment[pdoms.size()]));
    }

    public IWritableIndex getWritableIndex(ICProject project) throws CoreException {
        IWritableIndexFragment pdom = (IWritableIndexFragment)((Object)this.fPDOMManager.getPDOM(project));
        if (pdom == null) {
            throw new CoreException(CCorePlugin.createStatus(NLS.bind((String)Messages.IndexFactory_errorNoSuchPDOM0, (Object)project.getElementName())));
        }
        return new WritableCIndex(pdom);
    }

    private Collection<ICProject> getProjects(ICProject[] projects, boolean addDependencies, boolean addDependent, Set<IProject> handled) {
        ArrayList<ICProject> result = new ArrayList<ICProject>();
        ICProject[] iCProjectArray = projects;
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            ICProject cproject = iCProjectArray[n2];
            this.checkAddProject(cproject, handled, result);
            ++n2;
        }
        if (addDependencies || addDependent) {
            CoreModel cm = CoreModel.getDefault();
            int i = 0;
            while (i < result.size()) {
                ICProject cproject = (ICProject)result.get(i);
                IProject project = cproject.getProject();
                try {
                    IProject rp;
                    int n3;
                    int n4;
                    IProject[] iProjectArray;
                    if (addDependencies) {
                        iProjectArray = project.getReferencedProjects();
                        n4 = iProjectArray.length;
                        n3 = 0;
                        while (n3 < n4) {
                            rp = iProjectArray[n3];
                            this.checkAddProject(cm.create(rp), handled, result);
                            ++n3;
                        }
                    }
                    if (addDependent) {
                        iProjectArray = project.getReferencingProjects();
                        n4 = iProjectArray.length;
                        n3 = 0;
                        while (n3 < n4) {
                            rp = iProjectArray[n3];
                            this.checkAddProject(cm.create(rp), handled, result);
                            ++n3;
                        }
                    }
                }
                catch (CoreException coreException) {
                    handled.add(project);
                }
                ++i;
            }
        }
        return result;
    }

    private void checkAddProject(ICProject cproject, Set<IProject> handled, List<ICProject> target) {
        IProject project;
        if (cproject != null && handled.add(project = cproject.getProject()) && project.isOpen()) {
            target.add(cproject);
        }
    }

    private void safeAddFragment(Map<String, IIndexFragment> id2fragment, IIndexFragment fragment) {
        if (fragment != null) {
            try {
                fragment.acquireReadLock();
                try {
                    String id = fragment.getProperty("org.eclipse.cdt.internal.core.index.fragment.id");
                    id2fragment.put(id, fragment);
                }
                finally {
                    fragment.releaseReadLock();
                }
            }
            catch (CoreException e) {
                CCorePlugin.log(e);
            }
            catch (InterruptedException e) {
                CCorePlugin.log(e);
            }
        }
    }

    private void safeAddProvidedFragments(ICProject cproject, Map<String, IIndexFragment> fragments, int usage) {
        ICProjectDescription pd = CoreModel.getDefault().getProjectDescription(cproject.getProject(), false);
        if (pd != null) {
            IndexProviderManager ipm = CCoreInternals.getPDOMManager().getIndexProviderManager();
            ICConfigurationDescription cfg = pd.getDefaultSettingConfiguration();
            if (cfg != null) {
                try {
                    IIndexFragment[] pFragments;
                    IIndexFragment[] iIndexFragmentArray = pFragments = ipm.getProvidedIndexFragments(cfg, usage);
                    int n = pFragments.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IIndexFragment fragment = iIndexFragmentArray[n2];
                        this.safeAddFragment(fragments, fragment);
                        ++n2;
                    }
                }
                catch (CoreException e) {
                    CCorePlugin.log(e);
                }
            }
        }
    }
}

