/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuda.ide.debug.mi;

import com.nvidia.common.util.CoreUtil;
import com.nvidia.cuda.ide.debug.mi.AbstractMITableInfo;
import com.nvidia.cuda.ide.debug.mi.vo.KernelInfo;
import com.nvidia.cuda.ide.debug.model.CudaDim;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.cdt.dsf.mi.service.command.output.MIOutput;

public class MICudaInfoKernelsInfo
extends AbstractMITableInfo<KernelInfo> {
    private static final Set<String> IGNORED_FIELDS = new HashSet<String>(Arrays.asList("grid", "sms_mask", "args", "current", "invocation"));

    public MICudaInfoKernelsInfo(MIOutput record) {
        super(record, "InfoCudaKernelsTable");
    }

    @Override
    protected void setEntryProperty(KernelInfo kernel, String var, String val) {
        if ("name".equals(var) || "invocation".equals(var)) {
            kernel.setName(val);
        } else if ("kernel".equals(var)) {
            kernel.setId(Long.parseLong(val));
        } else if ("device".equals(var)) {
            kernel.setDeviceId(Short.parseShort(val));
        } else if ("gridDim".equals(var)) {
            kernel.setGridDim(CudaDim.parse(val));
        } else if ("blockDim".equals(var)) {
            kernel.setBlockDim(CudaDim.parse(val));
        } else if ("parent".equals(var)) {
            if (!CoreUtil.isNullOrEmpty((String)val) && !"-".equals(val.trim())) {
                kernel.setParentId(Long.parseLong(val.trim()));
            }
        } else if ("status".equals(var)) {
            kernel.setStatus(val);
        } else if (!IGNORED_FIELDS.contains(var)) {
            System.out.printf("[MICudaInfoKernelsInfo#setEntryProperty] Unknown field: %s\n", var);
        }
    }

    @Override
    protected KernelInfo createEntry(String variable) {
        if (variable.equals("InfoCudaKernelsRow")) {
            return new KernelInfo();
        }
        return null;
    }

    protected KernelInfo[] createArray(int length) {
        return new KernelInfo[length];
    }
}

