/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuda.ide.debug.service;

import com.nvidia.common.util.CoreUtil;
import com.nvidia.cuda.ide.debug.core.Activator;
import com.nvidia.cuda.ide.debug.launch.CudaControl;
import com.nvidia.cuda.ide.debug.mi.MIFileListExecSourceFilesInfo;
import com.nvidia.cuda.ide.debug.mi.vo.SourceInfo;
import com.nvidia.cuda.ide.debug.service.CudaCommandFactory;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.Executor;
import org.eclipse.cdt.dsf.concurrent.ConfinedToDsfExecutor;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.ImmediateExecutor;
import org.eclipse.cdt.dsf.debug.service.command.ICommand;
import org.eclipse.cdt.dsf.debug.service.command.ICommandControlService;
import org.eclipse.cdt.dsf.service.DsfServicesTracker;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;

public final class DebuggerFilesMap {
    private Map<IPath, String> knownSourceFiles = null;
    private final Collection<DataRequestMonitor<Map<IPath, String>>> queue = new LinkedList<DataRequestMonitor<Map<IPath, String>>>();
    private final DsfSession session;

    private static void issueCommand(CudaControl control, final DataRequestMonitor<Map<IPath, String>> drm) {
        CudaCommandFactory factory = control.getCommandFactory();
        ICommand<MIFileListExecSourceFilesInfo> command = factory.createMIFileListExecSourceFiles((ICommandControlService.ICommandControlDMContext)control.getControlDMContext());
        control.queueCommand(command, new DataRequestMonitor<MIFileListExecSourceFilesInfo>(ImmediateExecutor.getInstance(), drm){

            protected void handleSuccess() {
                drm.done((Object)DebuggerFilesMap.parseFilesList((MIFileListExecSourceFilesInfo)((Object)this.getData())));
            }
        });
    }

    private static Map<IPath, String> parseFilesList(MIFileListExecSourceFilesInfo data) {
        SourceInfo[] children = data.getSourceFiles();
        HashMap<IPath, String> paths = new HashMap<IPath, String>(children.length);
        SourceInfo[] sourceInfoArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            SourceInfo sourceInfo = sourceInfoArray[n2];
            String fullname = sourceInfo.getFullname();
            paths.put((IPath)new Path(fullname), sourceInfo.getFile());
            ++n2;
        }
        return paths;
    }

    public DebuggerFilesMap(DsfSession session) {
        this.session = session;
    }

    public synchronized void clear() {
        this.knownSourceFiles = null;
    }

    public synchronized void getFiles(DataRequestMonitor<Map<IPath, String>> dataRequestMonitor) {
        if (this.knownSourceFiles == null) {
            if (this.postCommand()) {
                this.queue.add(dataRequestMonitor);
            } else {
                dataRequestMonitor.done(CoreUtil.errorStatus((String)"Debug services were not properly initialized", (Object[])new Object[0]));
            }
        } else {
            dataRequestMonitor.done(this.knownSourceFiles);
        }
    }

    private boolean isCommandPosted() {
        return !this.queue.isEmpty();
    }

    private boolean postCommand() {
        if (!this.isCommandPosted()) {
            DsfServicesTracker tracker = new DsfServicesTracker(Activator.getBundleContext(), this.session.getId());
            CudaControl control = (CudaControl)((Object)tracker.getService(CudaControl.class));
            if (control != null) {
                DebuggerFilesMap.issueCommand(control, new DataRequestMonitor<Map<IPath, String>>((Executor)this.session.getExecutor(), null){

                    @ConfinedToDsfExecutor(value="fExecutor")
                    protected void handleCompleted() {
                        DebuggerFilesMap.this.processResult((Map)this.getData(), this.getStatus(), this.isCanceled());
                    }
                });
                return true;
            }
            return false;
        }
        return true;
    }

    private synchronized void processResult(Map<IPath, String> data, IStatus status, boolean canceled) {
        this.knownSourceFiles = data != null ? data : Collections.emptyMap();
        for (DataRequestMonitor<Map<IPath, String>> drm : this.queue) {
            if (canceled) {
                drm.cancel();
                drm.done();
                continue;
            }
            if (status != null && status.getSeverity() != 0) {
                drm.done(status);
                continue;
            }
            drm.done(data);
        }
        this.queue.clear();
    }
}

