/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuda.ide.debug.util;

import com.nvidia.cuda.ide.debug.model.IFocusDMContext;
import com.nvidia.cuda.ide.debug.ui.viewmodel.ICudaThreadColumns;
import com.nvidia.cuda.ide.debug.util.ThreadColumnsManager;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IColumnPresentation;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IColumnPresentation2;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IPresentationContext;
import org.eclipse.jface.resource.ImageDescriptor;

public final class ThreadsColumnPresentation
implements IColumnPresentation2 {
    private static final String THREAD_COLUMN_ID_PREFIX = "cuda.thread.";
    private IPresentationContext context;
    private final IColumnPresentation delegate;
    private final AtomicBoolean refreshing = new AtomicBoolean(false);

    public static String createColumnId(int num, IDMContext idmContext) {
        return String.format("%s%d", THREAD_COLUMN_ID_PREFIX, num);
    }

    public static String getId(String id) {
        return String.format("_CUDA_%s", id);
    }

    private static boolean isCudaColumn(String id) {
        return id.startsWith(THREAD_COLUMN_ID_PREFIX);
    }

    public ThreadsColumnPresentation(IColumnPresentation delegate) {
        this.delegate = delegate;
    }

    public void dispose() {
        this.delegate.dispose();
    }

    public String[] getAvailableColumns() {
        System.out.printf("[ThreadsColumnPresentation#getAvailableColumns] %h\n", this.context);
        return this.delegate.getAvailableColumns();
    }

    public IFocusDMContext getColumnFocus(String columnId) {
        Object columns;
        if (columnId.startsWith(THREAD_COLUMN_ID_PREFIX) && this.context != null && (columns = this.context.getProperty("cuda_threads")) instanceof ICudaThreadColumns) {
            return ((ICudaThreadColumns)columns).getColumnFocus(columnId);
        }
        return null;
    }

    public String getHeader(String id) {
        if (ThreadsColumnPresentation.isCudaColumn(id)) {
            IFocusDMContext focus = this.getColumnFocus(id);
            if (focus != null) {
                return String.format("T%sB%s", focus.getThreadIdx(), focus.getBlockIdx());
            }
            this.scheduleColumnsRefresh();
            return "{stored_column}";
        }
        return this.delegate.getHeader(id);
    }

    public String getId() {
        return ThreadsColumnPresentation.getId(this.delegate.getId());
    }

    public ImageDescriptor getImageDescriptor(String id) {
        if (ThreadsColumnPresentation.isCudaColumn(id)) {
            return null;
        }
        return this.delegate.getImageDescriptor(id);
    }

    public String[] getInitialColumns() {
        String[] columns = this.getManager().getCurrentColumns();
        if (columns == null) {
            return this.delegate.getInitialColumns();
        }
        return columns;
    }

    public int getInitialColumnWidth(String id, int treeWidgetWidth, String[] visibleColumnIds) {
        if (ThreadsColumnPresentation.isCudaColumn(id) || !(this.delegate instanceof IColumnPresentation2)) {
            return -1;
        }
        return ((IColumnPresentation2)this.delegate).getInitialColumnWidth(id, treeWidgetWidth, visibleColumnIds);
    }

    public void init(IPresentationContext context) {
        this.context = context;
        this.delegate.init(context);
    }

    public boolean isOptional() {
        return this.delegate.isOptional();
    }

    private void scheduleColumnsRefresh() {
        if (this.refreshing.compareAndSet(false, true)) {
            this.context.getWindow().getShell().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    ThreadsColumnPresentation.this.getManager().refresh();
                    ThreadsColumnPresentation.this.refreshing.set(false);
                }
            });
        }
    }

    private ThreadColumnsManager getManager() {
        return ThreadColumnsManager.getColumnsManager(this.context, this.delegate.getInitialColumns());
    }
}

