/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.decorators;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.egit.core.AdapterUtils;
import org.eclipse.egit.ui.internal.decorators.IProblemDecoratable;
import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.BaseLabelProvider;
import org.eclipse.jface.viewers.DecorationOverlayIcon;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.team.ui.TeamImages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProblemLabelDecorator
extends BaseLabelProvider
implements ILabelDecorator,
IResourceChangeListener {
    private final StructuredViewer viewer;
    private final ResourceManager resourceManager = new LocalResourceManager(JFaceResources.getResources());

    public ProblemLabelDecorator(StructuredViewer viewer) {
        this.viewer = viewer;
        if (this.viewer != null) {
            ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
        }
    }

    public void dispose() {
        this.resourceManager.dispose();
        if (this.viewer != null) {
            ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        }
        super.dispose();
    }

    public Image decorateImage(Image image, Object element) {
        IProblemDecoratable decoratable = this.getProblemDecoratable(element);
        if (decoratable != null) {
            int problemSeverity = decoratable.getProblemSeverity();
            if (problemSeverity == 2) {
                return this.getDecoratedImage(image, "ovr/error_co.gif");
            }
            if (problemSeverity == 1) {
                return this.getDecoratedImage(image, "ovr/warning_co.gif");
            }
        }
        return null;
    }

    public String decorateText(String text, Object element) {
        return null;
    }

    private IProblemDecoratable getProblemDecoratable(Object element) {
        if (element instanceof IProblemDecoratable) {
            return (IProblemDecoratable)element;
        }
        return null;
    }

    private Image getDecoratedImage(Image base, String teamImageId) {
        ImageDescriptor overlay = TeamImages.getImageDescriptor((String)teamImageId);
        DecorationOverlayIcon decorated = new DecorationOverlayIcon(base, overlay, 2);
        return (Image)this.resourceManager.get((DeviceResourceDescriptor)decorated);
    }

    public void resourceChanged(IResourceChangeEvent event) {
        IMarkerDelta[] markerDeltas;
        HashSet<IResource> resources = new HashSet<IResource>();
        IMarkerDelta[] iMarkerDeltaArray = markerDeltas = event.findMarkerDeltas("org.eclipse.core.resources.problemmarker", true);
        int n = markerDeltas.length;
        int n2 = 0;
        while (n2 < n) {
            IMarkerDelta delta = iMarkerDeltaArray[n2];
            resources.add(delta.getResource());
            ++n2;
        }
        if (!resources.isEmpty()) {
            this.updateLabels(resources);
        }
    }

    private void updateLabels(Set<IResource> changedResources) {
        List<Object> elements = this.getAffectedElements(changedResources);
        if (!elements.isEmpty()) {
            final Object[] updateElements = elements.toArray(new Object[elements.size()]);
            Display display = this.viewer.getControl().getDisplay();
            display.asyncExec(new Runnable(){

                public void run() {
                    ProblemLabelDecorator.this.viewer.update(updateElements, null);
                }
            });
        }
    }

    private List<Object> getAffectedElements(Set<IResource> resources) {
        ArrayList<Object> result = new ArrayList<Object>();
        if (this.viewer.getContentProvider() instanceof IStructuredContentProvider) {
            Object[] elements;
            IStructuredContentProvider contentProvider = (IStructuredContentProvider)this.viewer.getContentProvider();
            Object[] objectArray = elements = contentProvider.getElements(null);
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                Object element = objectArray[n2];
                IResource resource = (IResource)AdapterUtils.adapt((Object)element, IResource.class);
                if (resource != null && resources.contains(resource)) {
                    result.add(element);
                }
                ++n2;
            }
        }
        return result;
    }
}

