/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.push;

import java.util.Set;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.components.RepositorySelectionPage;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddRemotePage
extends RepositorySelectionPage {
    private final Repository repository;
    private Text remoteNameText;

    public AddRemotePage(Repository repository) {
        super(false, null);
        this.repository = repository;
    }

    public String getRemoteName() {
        return this.remoteNameText.getText();
    }

    @Override
    protected void createRemoteNamePanel(Composite panel) {
        Composite remoteNamePanel = new Composite(panel, 0);
        remoteNamePanel.setLayout((Layout)new GridLayout(2, false));
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)remoteNamePanel);
        Label remoteNameLabel = new Label(remoteNamePanel, 0);
        remoteNameLabel.setText(UIText.AddRemotePage_RemoteNameLabel);
        this.remoteNameText = new Text(remoteNamePanel, 2048);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.remoteNameText);
        if (!this.getExistingRemotes().contains("origin")) {
            this.remoteNameText.setText("origin");
            this.remoteNameText.setSelection(this.remoteNameText.getText().length());
        } else {
            this.setMessage(UIText.AddRemotePage_EnterRemoteNameMessage);
        }
        this.remoteNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AddRemotePage.this.checkPage();
            }
        });
    }

    @Override
    protected void checkPage() {
        String remoteName = this.getRemoteName();
        if (remoteName.length() == 0) {
            this.setErrorMessage(UIText.AddRemotePage_RemoteNameEmptyError);
            this.setPageComplete(false);
        } else if (!AddRemotePage.isValidRemoteName(remoteName)) {
            this.setErrorMessage(UIText.AddRemotePage_RemoteNameInvalidError);
            this.setPageComplete(false);
        } else if (this.getExistingRemotes().contains(remoteName)) {
            this.setErrorMessage(UIText.AddRemotePage_RemoteNameAlreadyExistsError);
            this.setPageComplete(false);
        } else {
            super.checkPage();
        }
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.remoteNameText.setFocus();
        }
    }

    private Set<String> getExistingRemotes() {
        return this.repository.getConfig().getSubsections("remote");
    }

    private static boolean isValidRemoteName(String remoteName) {
        String testRef = "refs/remotes/" + remoteName + "/test";
        return Repository.isValidRefName((String)testRef);
    }
}

