/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.webapp.servlet;

import java.io.IOException;
import java.util.Map;
import java.util.WeakHashMap;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.transform.TransformerException;
import org.eclipse.help.internal.HelpPlugin;
import org.eclipse.help.internal.UAElement;
import org.eclipse.help.internal.base.BaseHelpSystem;
import org.eclipse.help.internal.dynamic.DocumentWriter;
import org.eclipse.help.internal.index.Index;
import org.eclipse.help.internal.index.IndexContribution;
import org.eclipse.help.internal.webapp.data.UrlUtil;

public class IndexServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private Map responseByLocale;
    private DocumentWriter writer;

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        resp.setContentType("application/xml; charset=UTF-8");
        resp.getWriter().write(this.processRequest(req, resp));
    }

    protected String processRequest(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String response;
        BaseHelpSystem.checkMode();
        String locale = UrlUtil.getLocale(req, resp);
        req.setCharacterEncoding("UTF-8");
        if (this.responseByLocale == null) {
            this.responseByLocale = new WeakHashMap();
        }
        if ((response = (String)this.responseByLocale.get(locale)) == null) {
            IndexContribution[] contributions = HelpPlugin.getIndexManager().getIndexContributions(locale);
            try {
                response = this.serialize(contributions, locale);
            }
            catch (TransformerException e) {
                throw new ServletException((Throwable)e);
            }
            this.responseByLocale.put(locale, response);
        }
        return response != null ? response : "";
    }

    public String serialize(IndexContribution[] contributions, String locale) throws TransformerException {
        StringBuffer buf = new StringBuffer();
        buf.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        buf.append("<indexContributions>\n");
        if (this.writer == null) {
            this.writer = new DocumentWriter();
        }
        int i = 0;
        while (i < contributions.length) {
            IndexContribution contrib = contributions[i];
            buf.append("<indexContribution\n");
            buf.append("      id=\"" + contrib.getId() + '\"');
            buf.append("      locale=\"" + contrib.getLocale() + "\">\n");
            buf.append(this.writer.writeString((UAElement)((Index)contrib.getIndex()), false));
            buf.append("</indexContribution>\n");
            ++i;
        }
        buf.append("</indexContributions>\n");
        return buf.toString();
    }
}

