/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.model;

import com.nvidia.viper.ViperColors;
import com.nvidia.viper.ViperException;
import com.nvidia.viper.ViperExceptionHandler;
import com.nvidia.viper.model.ContainerState;
import com.nvidia.viper.model.IModel;
import com.nvidia.viper.model.ITimelineInterval;
import com.nvidia.viper.model.ModelWithProperties;
import com.nvidia.viper.model.ProfileDataModel;
import com.nvidia.viper.model.Session;
import com.nvidia.viper.model.TimelineIntervalKind;
import com.nvidia.viper.model.TimelineIntervalMin;
import com.nvidia.viper.model.TimelineIntervalMinFactory;
import com.nvidia.viper.model.TimelineIntervalMinStart;
import com.nvidia.viper.model.TimelineIntervalMinStartEnd;
import com.nvidia.viper.model.TimelineKind;
import com.nvidia.viper.ui.TimelineFigure;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.eclipse.gef.Disposable;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Display;

public class Timeline
extends ModelWithProperties
implements IModel,
Disposable {
    public static final String PROPERTY_DISPLAYNAME = "timeline:displayname";
    public static final String PROPERTY_BGCOLOR = "timeline:bgcolor";
    public static final String PROPERTY_CHILDREN = "timeline:children";
    public static final String PROPERTY_VISIBLE = "timeline:visible";
    public static final String PROPERTY_FILTERED = "timeline:filtered";
    public static final String PROPERTY_INTERVALEVENT = "timeline:ievent";
    public static final String PROPERTY_INTERVALMETRIC = "timeline:imetric";
    protected static final int MAX_TIMELINE_HEIGHT = 160;
    protected static final int MAX_INTERVAL_ROWS = 64;
    protected static final int MIN_INTERVAL_ROW_HEIGHT = 1;
    public static final int MAX_INTERVAL_ROW_HEIGHT = 18;
    protected static final int DEFAULT_INTERVAL_ROW_MARGIN = 1;
    protected static final int DEFAULT_INTERVAL_ROW_BORDER = 1;
    protected static final int INITIAL_REFRESH_INTERVAL = 1;
    protected static final int MAX_REFRESH_INTERVAL = 128;
    private int refreshInterval;
    private static final int MAX_CACHED_INTERVALS = 4096;
    private String name;
    private String customName;
    private final TimelineKind kind;
    private Session session;
    private int intervalRowHeight = 18;
    private int intervalRowInnerMargin = 1;
    private int timelineOuterMargin = 1;
    private int intervalRowBorder = 1;
    private Color backgroundColor = ViperColors.TIMELINE_DEFAULT_BGCOLOR;
    private boolean filtered = false;
    private boolean visible = true;
    private ContainerState containerState = ContainerState.OPEN_ALL;
    private Timeline parent = null;
    private List<Timeline> children = null;
    private ViperColors.GradientColors intervalColors;
    TimelineFigure timelineFigure;
    public ReadWriteLock rwl = new ReentrantReadWriteLock(false);
    private HashMap<Integer, ITimelineInterval[]> intervalPosPerRow = new HashMap();
    private HashMap<Integer, ITimelineInterval[]> intervalPosPerRowBuffer = new HashMap();
    private HashMap<Integer, Set<ITimelineInterval>> intervalsToDraw = new HashMap();
    private HashMap<Integer, Set<ITimelineInterval>> intervalsRecentlyUsed = new HashMap();
    private int windowWidth;
    private long windowStart;
    private long windowDuration;
    private int intervalCountLoading = 0;
    private int numRows = 0;
    private int defaultRowNumber = 0;
    private HashMap<Long, Row> idToRowMap = new HashMap();
    private List<TimelineIntervalMin> intervalsMin = new ArrayList<TimelineIntervalMin>();
    private long[] intervalIds = new long[0];
    private Long earliestKernelStart = null;
    private Set<TimelineIntervalKind> intervalKinds = new HashSet<TimelineIntervalKind>();
    private long totalTime = 0L;

    public Timeline(String name, TimelineKind kind) {
        this.name = name;
        this.kind = kind;
    }

    private void assignIntervalRows() {
        if (!this.kind.supportsMultipleIntervalRows(this.isSegmented())) {
            return;
        }
        LinkedList<Row> rows = new LinkedList<Row>();
        Comparator<TimelineIntervalMin> startComparator = new Comparator<TimelineIntervalMin>(){

            @Override
            public int compare(TimelineIntervalMin interval0, TimelineIntervalMin interval1) {
                long diff = ((TimelineIntervalMinStartEnd)interval0).start - ((TimelineIntervalMinStartEnd)interval1).start;
                if (diff < 0L) {
                    return -1;
                }
                if (diff > 0L) {
                    return 1;
                }
                return 0;
            }
        };
        Collections.sort(this.intervalsMin, startComparator);
        Row firstRow = null;
        for (TimelineIntervalMin interval : this.intervalsMin) {
            Row row = null;
            TimelineIntervalMinStartEnd intervalStartEnd = (TimelineIntervalMinStartEnd)interval;
            ListIterator itr = rows.listIterator(0);
            while (itr.hasNext()) {
                row = (Row)itr.next();
                if (intervalStartEnd.start >= row.endTime) break;
                row = null;
            }
            if (row == null) {
                row = new Row(intervalStartEnd.start, intervalStartEnd.end);
                rows.addLast(row);
                if (firstRow == null) {
                    firstRow = row;
                }
            } else {
                row.endTime = intervalStartEnd.end;
            }
            if (row == firstRow) continue;
            this.idToRowMap.put(interval.id, row);
        }
        Comparator<Row> rowStartComparator = new Comparator<Row>(){

            @Override
            public int compare(Row row0, Row row1) {
                long diff = row0.startTime - row1.startTime;
                if (diff < 0L) {
                    return -1;
                }
                if (diff > 0L) {
                    return 1;
                }
                return 0;
            }
        };
        Collections.sort(rows, rowStartComparator);
        this.numRows = 0;
        for (Row row : rows) {
            row.row = this.numRows;
            if (row == firstRow) {
                this.defaultRowNumber = row.row;
            }
            ++this.numRows;
        }
        if (this.timelineOuterMargin * 2 + this.numRows * this.intervalRowHeight + (this.numRows - 1) * this.intervalRowInnerMargin > 160) {
            double rowHeight = (160 - this.timelineOuterMargin * 2 - this.intervalRowInnerMargin * (this.numRows - 1)) / this.numRows;
            if (rowHeight < 1.0) {
                this.intervalRowInnerMargin = 0;
                rowHeight = (160 - this.timelineOuterMargin * 2) / this.numRows;
            }
            this.intervalRowHeight = rowHeight < 1.0 ? 1 : (int)Math.floor(rowHeight);
        }
    }

    private void sortIntervalIDs() {
        if (!this.getKind().supportsStartSorting()) {
            return;
        }
        Comparator<TimelineIntervalMin> startComparator = new Comparator<TimelineIntervalMin>(){

            @Override
            public int compare(TimelineIntervalMin interval0, TimelineIntervalMin interval1) {
                long diff = ((TimelineIntervalMinStart)interval0).start - ((TimelineIntervalMinStart)interval1).start;
                if (diff < 0L) {
                    return -1;
                }
                if (diff > 0L) {
                    return 1;
                }
                return 0;
            }
        };
        Collections.sort(this.intervalsMin, startComparator);
    }

    private void calculateTotalTime() {
        if (!this.getKind().supportsEndSorting(this.isSegmented())) {
            return;
        }
        long currentEnd = 0L;
        for (TimelineIntervalMin interval : this.intervalsMin) {
            TimelineIntervalMinStartEnd intervalStartEnd = (TimelineIntervalMinStartEnd)interval;
            if (intervalStartEnd.start > currentEnd) {
                this.totalTime += intervalStartEnd.end - intervalStartEnd.start;
            } else if (intervalStartEnd.end > currentEnd) {
                this.totalTime += intervalStartEnd.end - currentEnd;
            }
            if (intervalStartEnd.end <= currentEnd) continue;
            currentEnd = intervalStartEnd.end;
        }
    }

    private void assignIntervalIDs() {
        int count = 0;
        int intervalSize = this.intervalsMin.size();
        this.intervalIds = new long[intervalSize];
        for (TimelineIntervalMin interval : this.intervalsMin) {
            this.intervalIds[count] = interval.id;
            ++count;
        }
    }

    public void processIntervalMins() {
        if (this.intervalsMin == null) {
            return;
        }
        this.assignIntervalRows();
        this.sortIntervalIDs();
        this.calculateTotalTime();
        this.assignIntervalIDs();
        this.intervalsMin = null;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void dispose() {
        this.removeAllPropertyChangeListeners();
        this.session = null;
        this.parent = null;
        this.children = null;
        this.idToRowMap = new HashMap();
        this.intervalsRecentlyUsed.clear();
        this.intervalIds = null;
    }

    public final String getName() {
        return this.name;
    }

    public String getCustomName() {
        return this.customName;
    }

    public void setCustomName(String name) {
        this.customName = name;
    }

    public String getIdentifyingName() {
        return this.customName != null ? this.customName : this.name;
    }

    public String getDisplayName(boolean verbose) {
        return this.getIdentifyingName();
    }

    public TimelineKind getKind() {
        return this.kind;
    }

    public Session getSession() {
        return this.session;
    }

    public void setSession(Session session) {
        this.session = session;
    }

    public int getTimelineOuterMargin() {
        return this.timelineOuterMargin + this.intervalRowBorder;
    }

    public int getNumIntervalRows() {
        if (this.kind.supportsMultipleIntervalRows(this.isSegmented())) {
            return this.numRows;
        }
        return 1;
    }

    public int getIntervalRowHeight() {
        return this.intervalRowHeight;
    }

    public int getIntervalRowInnerMargin() {
        return this.intervalRowInnerMargin + 2 * this.intervalRowBorder;
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(Color backgroundColor) {
        if (!backgroundColor.equals((Object)this.backgroundColor)) {
            this.backgroundColor = backgroundColor;
            this.firePropertyChange(PROPERTY_BGCOLOR);
        }
    }

    public Timeline getParent() {
        return this.parent;
    }

    public List<Timeline> getChildren() {
        if (this.children == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.children);
    }

    public boolean appendChild(Timeline child) {
        if (child.parent != null) {
            child.parent.removeChild(child);
        }
        if (this.children == null) {
            this.children = new LinkedList<Timeline>();
        }
        this.children.add(child);
        if (this.session != null) {
            this.session.initTimeline(child);
        }
        child.parent = this;
        this.firePropertyChange(PROPERTY_CHILDREN);
        return true;
    }

    public boolean appendChild(Timeline child, Timeline after) {
        if (this.children == null || this.children.indexOf(after) == -1) {
            return false;
        }
        if (child == after) {
            return true;
        }
        if (child.parent != null) {
            child.parent.removeChild(child);
        }
        int afterIdx = this.children.indexOf(after);
        if (this.children == null) {
            this.children = new LinkedList<Timeline>();
        }
        this.children.add(afterIdx + 1, child);
        child.parent = this;
        this.firePropertyChange(PROPERTY_CHILDREN);
        return true;
    }

    public boolean insertChild(Timeline child) {
        if (child.parent != null) {
            child.parent.removeChild(child);
        }
        if (this.children == null) {
            this.children = new LinkedList<Timeline>();
        }
        this.children.add(0, child);
        child.parent = this;
        this.firePropertyChange(PROPERTY_CHILDREN);
        return true;
    }

    public boolean insertChild(Timeline child, Timeline before) {
        if (this.children == null || this.children.indexOf(before) == -1) {
            return false;
        }
        if (child == before) {
            return true;
        }
        if (child.parent != null) {
            child.parent.removeChild(child);
        }
        int beforeIdx = this.children.indexOf(before);
        if (this.children == null) {
            this.children = new LinkedList<Timeline>();
        }
        this.children.add(beforeIdx, child);
        child.parent = this;
        this.firePropertyChange(PROPERTY_CHILDREN);
        return true;
    }

    public boolean removeChild(Timeline child) {
        if (child.parent != this || this.children == null) {
            return false;
        }
        boolean ret = this.children.remove(child);
        if (ret) {
            child.parent = null;
        }
        this.firePropertyChange(PROPERTY_CHILDREN);
        return ret;
    }

    public Timeline getAncestor(TimelineKind kind) {
        if (this.parent != null) {
            if (this.parent.kind.equals((Object)kind)) {
                return this.parent;
            }
            return this.parent.getAncestor(kind);
        }
        return null;
    }

    public List<Timeline> getDescendants() {
        ArrayList<Timeline> ctls = new ArrayList<Timeline>();
        for (Timeline child : this.getChildren()) {
            ctls.add(child);
            child.collectDescendants(null, ctls);
        }
        return ctls;
    }

    public List<Timeline> getDescendants(TimelineKind kind) {
        return this.getDescendants(Arrays.asList(kind));
    }

    public List<Timeline> getDescendants(Collection<TimelineKind> kinds) {
        ArrayList<Timeline> ctls = new ArrayList<Timeline>();
        for (Timeline child : this.getChildren()) {
            if (kinds.contains((Object)child.kind)) {
                ctls.add(child);
            }
            child.collectDescendants(kinds, ctls);
        }
        return ctls;
    }

    private void collectDescendants(Collection<TimelineKind> kinds, List<Timeline> ctls) {
        for (Timeline child : this.getChildren()) {
            if (kinds == null || kinds.contains((Object)child.kind)) {
                ctls.add(child);
            }
            child.collectDescendants(kinds, ctls);
        }
    }

    public List<Timeline> getChildrenFiltered(boolean filtered) {
        ArrayList<Timeline> ctls = new ArrayList<Timeline>();
        for (Timeline child : this.getChildren()) {
            if (child.isFiltered() != filtered) continue;
            ctls.add(child);
        }
        return ctls;
    }

    public boolean isContainer() {
        return this.children != null && !this.children.isEmpty();
    }

    public boolean contains(Timeline other) {
        if (this.children == null) {
            return false;
        }
        for (Timeline child : this.children) {
            if (child != other && !child.contains(other)) continue;
            return true;
        }
        return false;
    }

    public boolean isFiltered() {
        return this.filtered;
    }

    public void setFiltered(boolean filtered) {
        if (this.filtered != filtered) {
            this.filtered = filtered;
            this.firePropertyChange(PROPERTY_FILTERED);
            if (this.parent != null) {
                this.parent.refreshDescendantVisibility(true);
            }
        }
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        if (this.visible != visible) {
            this.visible = visible;
            this.firePropertyChange(PROPERTY_VISIBLE);
        }
    }

    public boolean refreshDescendantVisibility(boolean deferredNotification) {
        boolean changed = false;
        try {
            if (deferredNotification) {
                Timeline.disableAllNotifications();
            }
            changed = this.refreshDescendantVisibility();
        }
        finally {
            if (deferredNotification) {
                Timeline.enableAllNotifications();
                if (changed && this.getSession() != null) {
                    this.getSession().fireGlobalVisibilityChange();
                }
            }
        }
        return changed;
    }

    public boolean refreshDescendantVisibility() {
        boolean changed = false;
        if (!this.getChildren().isEmpty()) {
            boolean newFilteredVisible = this.visible && this.containerState.isFilteredVisible();
            boolean newNonFilteredVisible = this.visible && this.containerState.isNonFilteredVisible();
            for (Timeline child : this.getChildren()) {
                if (child.isFiltered()) {
                    if (child.isVisible() != newFilteredVisible) {
                        child.setVisible(newFilteredVisible);
                        changed = true;
                    }
                } else if (child.isVisible() != newNonFilteredVisible) {
                    child.setVisible(newNonFilteredVisible);
                    changed = true;
                }
                changed |= child.refreshDescendantVisibility();
            }
        }
        return changed;
    }

    public ContainerState getContainerState() {
        if (this.isContainer()) {
            return this.containerState;
        }
        return ContainerState.OPEN_ALL;
    }

    public void setContainerState(ContainerState state) {
        if (this.isContainer() && state != this.containerState) {
            this.containerState = state;
            this.refreshDescendantVisibility(true);
        }
    }

    public ViperColors.GradientColors getIntervalColors(ITimelineInterval interval) {
        ViperColors.GradientColors colors = interval.getColor(this.intervalColors);
        if (colors != null) {
            return colors;
        }
        return interval.getKind().getColors();
    }

    public void setIntervalColors(ViperColors.GradientColors intervalColors) {
        this.intervalColors = intervalColors;
    }

    public int getIntervalAlpha(ITimelineInterval interval) {
        if (this.getKind().isGhostWhenFiltered()) {
            Timeline primary = interval.getPrimaryTimeline();
            if (primary == null) {
                primary = this;
            }
            if (primary.isFiltered()) {
                return 50;
            }
        }
        Collection<Long> selected = this.getSession().getAllSelectedIntervalIds();
        if (this.getSession().isUvmFilterEnabled() && selected == null) {
            return 50;
        }
        if (selected != null && !selected.contains(interval.getID())) {
            return 50;
        }
        return -1;
    }

    public int getNumIntervals() {
        return this.intervalIds.length;
    }

    public boolean hasInterval(ITimelineInterval interval) {
        if (interval == null) {
            return false;
        }
        long intervalId = interval.getID();
        long[] lArray = this.intervalIds;
        int n = this.intervalIds.length;
        int n2 = 0;
        while (n2 < n) {
            long id = lArray[n2];
            if (intervalId == id) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public List<ITimelineInterval> getIntervals(boolean loadAnalysis) {
        ArrayList<ITimelineInterval> results = new ArrayList<ITimelineInterval>();
        int i = 0;
        while (i < this.intervalIds.length) {
            ITimelineInterval interval = this.session.loadInterval(this.intervalIds[i], loadAnalysis);
            if (interval != null) {
                results.add(interval);
                if (interval.getPrimaryTimeline() == null) {
                    ViperExceptionHandler.logError("Missing primary timeline for this interval");
                    interval.setPrimaryTimeline(this);
                }
            }
            ++i;
        }
        return results;
    }

    public long getEarliestKernelStart() {
        if (!this.getKind().supportsStartSorting()) {
            ViperExceptionHandler.logError("This timeline doesn't support sorting, so can't get earliest time");
            return 0L;
        }
        return this.earliestKernelStart != null ? this.earliestKernelStart : 0L;
    }

    public Set<ITimelineInterval> getIntervalsToDraw(int row) {
        Set<ITimelineInterval> intervals = this.intervalsToDraw.get(row);
        if (intervals != null) {
            return intervals;
        }
        return Collections.emptySet();
    }

    private int getStartIndex(long start) {
        long intervalStartInWindow = start - this.windowStart;
        int intervalStartPos = (int)Math.ceil((double)intervalStartInWindow * (double)this.windowWidth / (double)this.windowDuration);
        return intervalStartPos;
    }

    private int getStartIndex(ITimelineInterval interval) {
        return this.getStartIndex(interval.getStart());
    }

    private int getEndIndex(long end) {
        long intervalEndInWindow = end - this.windowStart;
        int intervalEndPos = (int)Math.floor((double)intervalEndInWindow * (double)this.windowWidth / (double)this.windowDuration);
        return intervalEndPos;
    }

    private int getEndIndex(ITimelineInterval interval) {
        long intervalEnd = this.getKind().usesExtendedEnd() ? interval.getExtendedEnd() : interval.getEnd();
        return this.getEndIndex(intervalEnd);
    }

    public int getRowNum(ITimelineInterval interval) {
        int row = 0;
        if (this.kind.supportsMultipleIntervalRows(this.isSegmented())) {
            long id = interval.getID();
            row = this.idToRowMap != null && this.idToRowMap.containsKey(id) ? this.idToRowMap.get((Object)Long.valueOf((long)id)).row : this.defaultRowNumber;
        }
        return row;
    }

    public Set<ITimelineInterval> getIntervalsAt(long start, long end, int row) {
        int startIdx = this.getStartIndex(start);
        int endIdx = this.getEndIndex(end);
        if (endIdx == startIdx - 1) {
            --startIdx;
        }
        HashSet<ITimelineInterval> set = new HashSet<ITimelineInterval>();
        this.rwl.readLock().lock();
        ITimelineInterval[] array = null;
        array = this.kind.supportsMultipleIntervalRows(this.isSegmented()) ? this.intervalPosPerRow.get(row) : this.intervalPosPerRow.get(0);
        if (array != null) {
            int i = startIdx;
            while (i <= endIdx) {
                if (i >= 0) {
                    if (i >= this.windowWidth) break;
                    if (array[i] != null) {
                        set.add(array[i]);
                    }
                }
                ++i;
            }
        }
        this.rwl.readLock().unlock();
        return set;
    }

    public void initializeTimelineWindow(int width, long start, long end) {
        this.intervalCountLoading = 0;
        this.intervalPosPerRowBuffer.clear();
        this.rwl.writeLock().lock();
        this.windowWidth = width > 0 ? width : 0;
        this.windowStart = start;
        this.windowDuration = end - start;
        this.intervalPosPerRow.clear();
        this.refreshInterval = 1;
        this.rwl.writeLock().unlock();
        this.addPendingIntervals();
    }

    public void finalizeTimelineWindow() {
        this.addPendingIntervals();
    }

    public boolean addIntervalForceUnderLock(ITimelineInterval interval) {
        this.rwl.readLock().lock();
        if (this.windowDuration <= 0L) {
            this.rwl.readLock().unlock();
            return false;
        }
        int intervalStartPos = this.getStartIndex(interval);
        int intervalEndPos = this.getEndIndex(interval);
        if (intervalStartPos >= this.windowWidth || intervalEndPos < 0) {
            this.rwl.readLock().unlock();
            return false;
        }
        if (intervalEndPos == intervalStartPos - 1) {
            --intervalStartPos;
        }
        int row = this.getRowNum(interval);
        this.rwl.readLock().unlock();
        this.addPendingInterval(interval, intervalStartPos, intervalEndPos, row);
        return true;
    }

    public boolean canAddInterval(ITimelineInterval interval) {
        if (this.windowDuration <= 0L) {
            return false;
        }
        int intervalStartPos = this.getStartIndex(interval);
        int intervalEndPos = this.getEndIndex(interval);
        return intervalStartPos < this.windowWidth && intervalEndPos >= 0;
    }

    public boolean addInterval(ITimelineInterval interval, boolean forceAdd) {
        int row;
        ITimelineInterval[] array;
        if (this.windowDuration <= 0L) {
            return false;
        }
        int intervalStartPos = this.getStartIndex(interval);
        int intervalEndPos = this.getEndIndex(interval);
        if (intervalStartPos >= this.windowWidth || intervalEndPos < 0) {
            return false;
        }
        if (intervalEndPos == intervalStartPos - 1) {
            --intervalStartPos;
        }
        if ((array = this.intervalPosPerRowBuffer.get(row = this.getRowNum(interval))) == null) {
            array = new ITimelineInterval[this.windowWidth];
            this.intervalPosPerRowBuffer.put(row, array);
        }
        boolean shouldAdd = false;
        int i = intervalStartPos;
        while (i <= intervalEndPos) {
            if (i >= 0) {
                if (i >= this.windowWidth) break;
                if (array[i] == null || forceAdd) {
                    shouldAdd = true;
                    array[i] = interval;
                }
            }
            ++i;
        }
        if (!shouldAdd) {
            return false;
        }
        Set<ITimelineInterval> recentlyUsedIntervals = this.intervalsRecentlyUsed.get(row);
        if (recentlyUsedIntervals == null) {
            recentlyUsedIntervals = Collections.newSetFromMap(new LinkedHashMap<ITimelineInterval, Boolean>(4097, 1.0f, true){

                @Override
                protected boolean removeEldestEntry(Map.Entry<ITimelineInterval, Boolean> eldest) {
                    return this.size() > 4096;
                }
            });
            this.intervalsRecentlyUsed.put(row, recentlyUsedIntervals);
        }
        if (!forceAdd && recentlyUsedIntervals.contains(interval)) {
            return true;
        }
        ++this.intervalCountLoading;
        recentlyUsedIntervals.add(interval);
        if (this.intervalCountLoading > this.refreshInterval) {
            this.addPendingIntervals();
            this.intervalCountLoading = 0;
            this.refreshInterval *= 2;
            if (this.refreshInterval > 128) {
                this.refreshInterval = 128;
            }
        } else if (forceAdd) {
            this.addPendingInterval(interval, intervalStartPos, intervalEndPos, row);
        }
        return true;
    }

    public void fireIntervalEventChange(ITimelineInterval interval) {
        this.firePropertyChange(PROPERTY_INTERVALEVENT);
    }

    public void fireIntervalMetricChange(ITimelineInterval interval) {
        this.firePropertyChange(PROPERTY_INTERVALMETRIC);
    }

    public void setFigure(TimelineFigure figure) {
        this.timelineFigure = figure;
    }

    public void addIntervalMin(long id, long start, long end, long extendedEnd, TimelineIntervalKind intervalKind) {
        TimelineIntervalMin interval = TimelineIntervalMinFactory.createTimelineIntervalMin(id, start, end, extendedEnd, this.kind, this.isSegmented());
        if (intervalKind.equals((Object)TimelineIntervalKind.KERNEL)) {
            this.earliestKernelStart = this.earliestKernelStart == null ? start : (this.earliestKernelStart < start ? this.earliestKernelStart : start);
        }
        this.intervalsMin.add(interval);
        this.intervalKinds.add(intervalKind);
    }

    public void addPendingIntervals() {
        this.rwl.writeLock().lock();
        this.intervalPosPerRow.clear();
        for (int r : this.intervalPosPerRowBuffer.keySet()) {
            ITimelineInterval[] orig = this.intervalPosPerRowBuffer.get(r);
            ITimelineInterval[] copy = new ITimelineInterval[this.windowWidth];
            System.arraycopy(orig, 0, copy, 0, this.windowWidth);
            this.intervalPosPerRow.put(r, copy);
        }
        this.intervalsToDraw.clear();
        for (int r : this.intervalsRecentlyUsed.keySet()) {
            HashSet<ITimelineInterval> set = new HashSet<ITimelineInterval>();
            this.intervalsToDraw.put(r, set);
            ITimelineInterval[] pos = this.intervalPosPerRow.get(r);
            if (pos == null) {
                pos = new ITimelineInterval[this.windowWidth];
                this.intervalPosPerRow.put(r, pos);
            }
            for (ITimelineInterval interval : this.intervalsRecentlyUsed.get(r)) {
                int startIndex = this.getStartIndex(interval.getStart());
                int endIndex = this.getEndIndex(interval.getExtendedEnd());
                if (endIndex == startIndex - 1) {
                    --startIndex;
                }
                if (endIndex >= 0 && startIndex < this.windowWidth) {
                    set.add(interval);
                }
                startIndex = Math.max(startIndex, 0);
                endIndex = Math.min(endIndex, this.windowWidth - 1);
                int i = startIndex;
                while (i <= endIndex) {
                    if (pos[i] == null) {
                        pos[i] = interval;
                    }
                    ++i;
                }
            }
        }
        this.rwl.writeLock().unlock();
        this.refreshFigure();
    }

    private void addPendingInterval(ITimelineInterval interval, int startPos, int endPos, int row) {
        Set<ITimelineInterval> toDraw;
        this.rwl.writeLock().lock();
        ITimelineInterval[] posRow = this.intervalPosPerRow.get(row);
        if (posRow != null) {
            int start = Math.max(startPos, 0);
            int end = Math.min(endPos, this.windowWidth - 1);
            int pos = start;
            while (pos <= end) {
                posRow[pos] = interval;
                ++pos;
            }
        }
        if ((toDraw = this.intervalsToDraw.get(row)) != null) {
            toDraw.add(interval);
        }
        this.rwl.writeLock().unlock();
        this.refreshFigure();
    }

    private void refreshFigure() {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (Timeline.this.timelineFigure != null) {
                    Timeline.this.timelineFigure.repaint();
                    Timeline.this.timelineFigure.getUpdateManager().performUpdate();
                }
            }
        });
    }

    public void appendToPDM(ProfileDataModel pdm) throws ViperException {
        for (ITimelineInterval interval : this.getIntervals(true)) {
            interval.appendToPDM(pdm);
        }
    }

    public void dump(PrintStream out, int indent) {
        int i = 0;
        while (i < indent) {
            out.append(' ');
            ++i;
        }
        out.println(this.toString());
        for (Timeline child : this.getChildren()) {
            child.dump(out, indent + 2);
        }
    }

    public String toString() {
        return this.getDisplayName(true);
    }

    public Set<TimelineIntervalKind> getIntervalKinds() {
        return this.intervalKinds;
    }

    public long getTotalTime() {
        if (!this.getKind().supportsEndSorting(this.isSegmented())) {
            ViperExceptionHandler.logError("This timeline doesn't support end sorting");
            return 0L;
        }
        return this.totalTime;
    }

    public long[] getIntervalIds() {
        return this.intervalIds;
    }

    public void addAdditionalIntervals() {
    }

    public boolean isSegmented() {
        return false;
    }

    private class Row {
        public int row;
        public final long startTime;
        public long endTime;

        public Row(long startTime, long endTime) {
            this.startTime = startTime;
            this.endTime = endTime;
        }
    }
}

