/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.core;

import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.util.ArrayList;
import org.eclipse.cdt.core.ErrorParserManager;
import org.eclipse.cdt.core.IConsoleParser;
import org.eclipse.cdt.core.IMarkerGenerator;
import org.eclipse.cdt.core.language.settings.providers.IWorkingDirectoryTracker;
import org.eclipse.cdt.core.resources.IConsole;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.internal.core.BuildRunnerHelper;
import org.eclipse.cdt.managedbuilder.buildmodel.BuildDescriptionManager;
import org.eclipse.cdt.managedbuilder.buildmodel.IBuildDescription;
import org.eclipse.cdt.managedbuilder.core.AbstractBuildRunner;
import org.eclipse.cdt.managedbuilder.core.IBuilder;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.core.ManagedBuilderCorePlugin;
import org.eclipse.cdt.managedbuilder.internal.buildmodel.BuildStateManager;
import org.eclipse.cdt.managedbuilder.internal.buildmodel.DescriptionBuilder;
import org.eclipse.cdt.managedbuilder.internal.buildmodel.IConfigurationBuildState;
import org.eclipse.cdt.managedbuilder.internal.buildmodel.IProjectBuildState;
import org.eclipse.cdt.managedbuilder.internal.buildmodel.ParallelBuilder;
import org.eclipse.cdt.managedbuilder.internal.core.ManagedMakeMessages;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;

public class InternalBuildRunner
extends AbstractBuildRunner {
    private static final int PROGRESS_MONITOR_SCALE = 100;
    private static final int TICKS_STREAM_PROGRESS_MONITOR = 100;
    private static final int TICKS_DELETE_MARKERS = 100;
    private static final int TICKS_EXECUTE_COMMAND = 100;
    private static final int TICKS_REFRESH_PROJECT = 100;

    @Override
    public boolean invokeBuild(int kind, IProject project, IConfiguration configuration, IBuilder builder, IConsole console, IMarkerGenerator markerGenerator, IncrementalProjectBuilder projectBuilder, IProgressMonitor monitor) throws CoreException {
        BuildRunnerHelper buildRunnerHelper = new BuildRunnerHelper(project);
        try {
            if (monitor == null) {
                monitor = new NullProgressMonitor();
            }
            monitor.beginTask("", 400);
            boolean isParallel = builder.getParallelizationNum() > 1;
            boolean resumeOnErr = !builder.isStopOnError();
            int flags = 0;
            IResourceDelta delta = projectBuilder.getDelta(project);
            BuildStateManager bsMngr = BuildStateManager.getInstance();
            IProjectBuildState pBS = bsMngr.getProjectBuildState(project);
            IConfigurationBuildState cBS = pBS.getConfigurationBuildState(configuration.getId(), true);
            flags = 7;
            boolean buildIncrementaly = delta != null;
            ICConfigurationDescription cfgDescription = ManagedBuildManager.getDescriptionForConfiguration(configuration);
            String cfgName = configuration.getName();
            String toolchainName = configuration.getToolChain().getName();
            boolean isConfigurationSupported = configuration.isSupported();
            URI workingDirectoryURI = ManagedBuildManager.getBuildLocationURI(configuration, builder);
            String[] errorParsers = builder.getErrorParsers();
            ErrorParserManager epm = new ErrorParserManager(project, workingDirectoryURI, markerGenerator, errorParsers);
            ArrayList<IConsoleParser> parsers = new ArrayList<IConsoleParser>();
            ManagedBuildManager.collectLanguageSettingsConsoleParsers(cfgDescription, (IWorkingDirectoryTracker)epm, parsers);
            buildRunnerHelper.prepareStreams(epm, parsers, console, (IProgressMonitor)new SubProgressMonitor(monitor, 100));
            IBuildDescription des = BuildDescriptionManager.createBuildDescription(configuration, cBS, delta, flags);
            DescriptionBuilder dBuilder = null;
            if (!isParallel && (dBuilder = new DescriptionBuilder(des, buildIncrementaly, resumeOnErr, cBS)).getNumCommands() <= 0) {
                buildRunnerHelper.printLine(ManagedMakeMessages.getFormattedString("ManagedMakeBuilder.message.no.build", project.getName()));
                return false;
            }
            try {
                int status;
                buildRunnerHelper.removeOldMarkers((IResource)project, (IProgressMonitor)new SubProgressMonitor(monitor, 100, 4));
                if (buildIncrementaly) {
                    buildRunnerHelper.greeting(10, cfgName, toolchainName, isConfigurationSupported);
                } else {
                    buildRunnerHelper.greeting(ManagedMakeMessages.getResourceString("ManagedMakeBuider.type.rebuild"), cfgName, toolchainName, isConfigurationSupported);
                }
                buildRunnerHelper.printLine(ManagedMakeMessages.getResourceString("ManagedMakeBuilder.message.internal.builder.header.note"));
                OutputStream stdout = buildRunnerHelper.getOutputStream();
                OutputStream stderr = buildRunnerHelper.getErrorStream();
                if (dBuilder != null) {
                    status = dBuilder.build(stdout, stderr, (IProgressMonitor)new SubProgressMonitor(monitor, 100, 4));
                } else {
                    status = ParallelBuilder.build(des, null, null, stdout, stderr, (IProgressMonitor)new SubProgressMonitor(monitor, 100, 4), resumeOnErr, buildIncrementaly);
                    if (status == 0) {
                        cBS.setState(0);
                    }
                    buildRunnerHelper.printLine(ManagedMakeMessages.getFormattedString("CommonBuilder.7", Integer.toString(ParallelBuilder.lastThreadsUsed)));
                }
                bsMngr.setProjectBuildState(project, pBS);
                buildRunnerHelper.close();
                buildRunnerHelper.goodbye();
                if (status != -1) {
                    buildRunnerHelper.refreshProject(cfgName, (IProgressMonitor)new SubProgressMonitor(monitor, 100, 4));
                }
            }
            catch (Exception e) {
                projectBuilder.forgetLastBuiltState();
                String msg = ManagedMakeMessages.getFormattedString("ManagedMakeBuilder.message.error.build", new String[]{project.getName(), configuration.getName()});
                throw new CoreException((IStatus)new Status(4, "org.eclipse.cdt.managedbuilder.core", msg, (Throwable)e));
            }
        }
        finally {
            try {
                buildRunnerHelper.close();
            }
            catch (IOException e) {
                ManagedBuilderCorePlugin.log(e);
            }
            monitor.done();
        }
        return false;
    }
}

