/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.internal.executor.doc;

import java.util.ArrayList;
import java.util.Comparator;
import org.eclipse.birt.report.engine.internal.document.v4.CascadingComparator;
import org.eclipse.birt.report.engine.internal.executor.doc.FragmentComparator;
import org.eclipse.birt.report.engine.internal.executor.doc.Segment;

public class Fragment {
    Object index;
    Segment segment;
    Fragment next;
    Fragment child;
    Comparator comparator;
    private ArrayList<Section> sections = new ArrayList();
    private CascadingComparator cascadingComparator;

    public Fragment(Comparator comparator) {
        this(comparator, null);
        this.cascadingComparator = new CascadingComparator(comparator);
    }

    private Fragment(Comparator comparator, Object offset) {
        this.comparator = comparator instanceof FragmentComparator ? comparator : new FragmentComparator(comparator);
        this.index = offset;
        this.segment = new Segment(this.comparator);
    }

    public Fragment getFragment(Object offset) {
        Fragment frag = this.child;
        while (frag != null) {
            if (this.comparator.compare(frag.index, offset) == 0) {
                return frag;
            }
            frag = frag.next;
        }
        return null;
    }

    public Fragment getNextFragment(Object offset) {
        if (offset == Segment.LEFT_MOST_EDGE) {
            return this.child;
        }
        if (offset == Segment.RIGHT_MOST_EDGE) {
            return null;
        }
        Fragment frag = this.child;
        while (frag != null) {
            if (this.comparator.compare(frag.index, offset) > 0) {
                return frag;
            }
            frag = frag.next;
        }
        return null;
    }

    public Fragment getFirstFragment() {
        return this.child;
    }

    public void insertFragment(Object offset) {
        this.segment.insertSection(offset, offset);
        Fragment frag = this.addChildFragment(offset);
        frag.segment.insertSection(Segment.LEFT_MOST_EDGE, Segment.RIGHT_MOST_EDGE);
    }

    private Fragment addChildFragment(Object offset) {
        Fragment prev = null;
        Fragment frag = this.child;
        while (frag != null) {
            int result = this.comparator.compare(frag.index, offset);
            if (result == 0) {
                return frag;
            }
            if (result == 1) break;
            prev = frag;
            frag = frag.next;
        }
        frag = new Fragment(this.comparator, offset);
        if (prev != null) {
            if (prev.next != null) {
                frag.next = prev.next.next;
            }
            prev.next = frag;
        } else {
            frag.next = this.child;
            this.child = frag;
        }
        return frag;
    }

    public void build() {
        for (Section sect : this.sections) {
            Fragment leftEdge = this;
            int i = 0;
            while (i < sect.left.length) {
                leftEdge.segment.startSegment(sect.left[i]);
                leftEdge = this.addFragment(leftEdge, sect.left[i]);
                ++i;
            }
            leftEdge.segment.startSegment(Segment.LEFT_MOST_EDGE);
            Fragment rightEdge = this;
            int i2 = 0;
            while (i2 < sect.right.length) {
                rightEdge.segment.endSegment(sect.right[i2]);
                rightEdge = this.addFragment(rightEdge, sect.right[i2]);
                ++i2;
            }
            rightEdge.segment.endSegment(Segment.LEFT_MOST_EDGE);
        }
        this.segment.normalize();
    }

    public void addSection(Object[] left, Object[] right) {
        int index = this.search(left);
        this.insert(index, left, right);
    }

    protected int search(Object[] left) {
        if (this.sections.size() == 0) {
            return 0;
        }
        int result = 0;
        int low = 0;
        int high = this.sections.size() - 1;
        result = this.checkInsertPoint(left, high);
        if (result > 0) {
            return high + 1;
        }
        if (result == 0) {
            return high;
        }
        --high;
        while (low <= high) {
            int index = low + high >> 1;
            result = this.checkInsertPoint(left, index);
            if (result == 0) {
                return index;
            }
            if (result > 0) {
                low = index + 1;
                continue;
            }
            high = index - 1;
        }
        return low;
    }

    private int checkInsertPoint(Object[] left, int index) {
        assert (index >= 0);
        assert (index < this.sections.size());
        if (this.sections.size() > 0) {
            Section sect = this.sections.get(index);
            return this.cascadingComparator.compare(left, sect.left);
        }
        if (index == 0) {
            return 0;
        }
        throw new RuntimeException("invalid insert position");
    }

    protected void insert(int index, Object[] left, Object[] right) {
        if (index > 0) {
            Section prev = this.sections.get(index - 1);
            if (this.cascadingComparator.compare(left, prev.right) > 0) {
                this.sections.add(index, new Section(left, right));
                this.merge(index);
            } else {
                if (this.cascadingComparator.compare(right, prev.right) <= 0) {
                    return;
                }
                prev.right = right;
                this.merge(index - 1);
            }
        } else {
            this.sections.add(index, new Section(left, right));
            this.merge(index);
        }
    }

    private void merge(int index) {
        Object[] right = this.sections.get((int)index).right;
        int i = index + 1;
        while (i < this.sections.size()) {
            Section current = this.sections.get(i);
            if (this.cascadingComparator.compare(right, current.left) < 0) {
                return;
            }
            this.sections.remove(i--);
            if (this.cascadingComparator.compare(right, current.right) <= 0) {
                this.sections.get((int)index).right = current.right;
                return;
            }
            ++i;
        }
    }

    /*
     * Unable to fully structure code
     */
    private Fragment addFragment(Fragment parent, Object offset) {
        if (!Fragment.$assertionsDisabled && parent == null) {
            throw new AssertionError();
        }
        frag = parent.child;
        if (frag != null) ** GOTO lbl8
        parent.child = frag = new Fragment(this.comparator, offset);
        return frag;
lbl-1000:
        // 1 sources

        {
            frag = frag.next;
lbl8:
            // 2 sources

            ** while (frag.next != null)
        }
lbl9:
        // 1 sources

        result = this.comparator.compare(frag.index, offset);
        if (result == 0) {
            return frag;
        }
        if (result < 0) {
            frag.next = newFrag = new Fragment(this.comparator, offset);
            return newFrag;
        }
        throw new RuntimeException("Wrong offset found while building fragment tree");
    }

    public boolean inFragment(Object offset) {
        return this.segment.inSegment(offset);
    }

    public Object getOffset() {
        return this.index;
    }

    public Object[][] getSections() {
        if (this.segment != null) {
            this.segment.normalize();
            return this.segment.sections;
        }
        return null;
    }

    public String printEdges() {
        StringBuilder sb = new StringBuilder();
        for (Section edge : this.sections) {
            sb.append(edge.toString());
        }
        return sb.toString();
    }

    private static class Section {
        Object[] left;
        Object[] right;

        Section(Object[] left, Object[] right) {
            this.left = left;
            this.right = right;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("[");
            sb.append(this.left[0]);
            int i = 1;
            while (i < this.left.length) {
                sb.append(".");
                sb.append(this.left[i]);
                ++i;
            }
            sb.append(", ");
            sb.append(this.right[0]);
            i = 1;
            while (i < this.right.length) {
                sb.append(".");
                sb.append(this.right[i]);
                ++i;
            }
            sb.append("]");
            return sb.toString();
        }
    }
}

